{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GSocketListener@ is an object that keeps track of a set
-- of server sockets and helps you accept sockets from any of the
-- socket, either sync or async.
-- 
-- Add addresses and ports to listen on using
-- 'GI.Gio.Objects.SocketListener.socketListenerAddAddress' and
-- 'GI.Gio.Objects.SocketListener.socketListenerAddInetPort'. These will be listened on until
-- 'GI.Gio.Objects.SocketListener.socketListenerClose' is called. Dropping your final reference to
-- the @GSocketListener@ will not cause 'GI.Gio.Objects.SocketListener.socketListenerClose' to be
-- called implicitly, as some references to the @GSocketListener@ may be held
-- internally.
-- 
-- If you want to implement a network server, also look at
-- t'GI.Gio.Objects.SocketService.SocketService' and t'GI.Gio.Objects.ThreadedSocketService.ThreadedSocketService' which are
-- subclasses of @GSocketListener@ that make this even easier.
-- 
-- /Since: 2.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SocketListener
    ( 

-- * Exported types
    SocketListener(..)                      ,
    IsSocketListener                        ,
    toSocketListener                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [accept]("GI.Gio.Objects.SocketListener#g:method:accept"), [acceptAsync]("GI.Gio.Objects.SocketListener#g:method:acceptAsync"), [acceptFinish]("GI.Gio.Objects.SocketListener#g:method:acceptFinish"), [acceptSocket]("GI.Gio.Objects.SocketListener#g:method:acceptSocket"), [acceptSocketAsync]("GI.Gio.Objects.SocketListener#g:method:acceptSocketAsync"), [acceptSocketFinish]("GI.Gio.Objects.SocketListener#g:method:acceptSocketFinish"), [addAddress]("GI.Gio.Objects.SocketListener#g:method:addAddress"), [addAnyInetPort]("GI.Gio.Objects.SocketListener#g:method:addAnyInetPort"), [addInetPort]("GI.Gio.Objects.SocketListener#g:method:addInetPort"), [addSocket]("GI.Gio.Objects.SocketListener#g:method:addSocket"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [close]("GI.Gio.Objects.SocketListener#g:method:close"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setBacklog]("GI.Gio.Objects.SocketListener#g:method:setBacklog"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSocketListenerMethod             ,
#endif

-- ** accept #method:accept#

#if defined(ENABLE_OVERLOADING)
    SocketListenerAcceptMethodInfo          ,
#endif
    socketListenerAccept                    ,


-- ** acceptAsync #method:acceptAsync#

#if defined(ENABLE_OVERLOADING)
    SocketListenerAcceptAsyncMethodInfo     ,
#endif
    socketListenerAcceptAsync               ,


-- ** acceptFinish #method:acceptFinish#

#if defined(ENABLE_OVERLOADING)
    SocketListenerAcceptFinishMethodInfo    ,
#endif
    socketListenerAcceptFinish              ,


-- ** acceptSocket #method:acceptSocket#

#if defined(ENABLE_OVERLOADING)
    SocketListenerAcceptSocketMethodInfo    ,
#endif
    socketListenerAcceptSocket              ,


-- ** acceptSocketAsync #method:acceptSocketAsync#

#if defined(ENABLE_OVERLOADING)
    SocketListenerAcceptSocketAsyncMethodInfo,
#endif
    socketListenerAcceptSocketAsync         ,


-- ** acceptSocketFinish #method:acceptSocketFinish#

#if defined(ENABLE_OVERLOADING)
    SocketListenerAcceptSocketFinishMethodInfo,
#endif
    socketListenerAcceptSocketFinish        ,


-- ** addAddress #method:addAddress#

#if defined(ENABLE_OVERLOADING)
    SocketListenerAddAddressMethodInfo      ,
#endif
    socketListenerAddAddress                ,


-- ** addAnyInetPort #method:addAnyInetPort#

#if defined(ENABLE_OVERLOADING)
    SocketListenerAddAnyInetPortMethodInfo  ,
#endif
    socketListenerAddAnyInetPort            ,


-- ** addInetPort #method:addInetPort#

#if defined(ENABLE_OVERLOADING)
    SocketListenerAddInetPortMethodInfo     ,
#endif
    socketListenerAddInetPort               ,


-- ** addSocket #method:addSocket#

#if defined(ENABLE_OVERLOADING)
    SocketListenerAddSocketMethodInfo       ,
#endif
    socketListenerAddSocket                 ,


-- ** close #method:close#

#if defined(ENABLE_OVERLOADING)
    SocketListenerCloseMethodInfo           ,
#endif
    socketListenerClose                     ,


-- ** new #method:new#

    socketListenerNew                       ,


-- ** setBacklog #method:setBacklog#

#if defined(ENABLE_OVERLOADING)
    SocketListenerSetBacklogMethodInfo      ,
#endif
    socketListenerSetBacklog                ,




 -- * Properties


-- ** listenBacklog #attr:listenBacklog#
-- | The number of outstanding connections in the listen queue.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    SocketListenerListenBacklogPropertyInfo ,
#endif
    constructSocketListenerListenBacklog    ,
    getSocketListenerListenBacklog          ,
    setSocketListenerListenBacklog          ,
#if defined(ENABLE_OVERLOADING)
    socketListenerListenBacklog             ,
#endif




 -- * Signals


-- ** event #signal:event#

    SocketListenerEventCallback             ,
#if defined(ENABLE_OVERLOADING)
    SocketListenerEventSignalInfo           ,
#endif
    afterSocketListenerEvent                ,
    onSocketListenerEvent                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Flags as GLib.Flags
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketControlMessage as Gio.SocketControlMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputMessage as Gio.InputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputVector as Gio.InputVector
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputMessage as Gio.OutputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection

#endif

-- | Memory-managed wrapper type.
newtype SocketListener = SocketListener (SP.ManagedPtr SocketListener)
    deriving (Eq)

instance SP.ManagedPtrNewtype SocketListener where
    toManagedPtr (SocketListener p) = p

foreign import ccall "g_socket_listener_get_type"
    c_g_socket_listener_get_type :: IO B.Types.GType

instance B.Types.TypedObject SocketListener where
    glibType = c_g_socket_listener_get_type

instance B.Types.GObject SocketListener

-- | Type class for types which can be safely cast to `SocketListener`, for instance with `toSocketListener`.
class (SP.GObject o, O.IsDescendantOf SocketListener o) => IsSocketListener o
instance (SP.GObject o, O.IsDescendantOf SocketListener o) => IsSocketListener o

instance O.HasParentTypes SocketListener
type instance O.ParentTypes SocketListener = '[GObject.Object.Object]

-- | Cast to `SocketListener`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSocketListener :: (MIO.MonadIO m, IsSocketListener o) => o -> m SocketListener
toSocketListener = MIO.liftIO . B.ManagedPtr.unsafeCastTo SocketListener

-- | Convert 'SocketListener' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SocketListener) where
    gvalueGType_ = c_g_socket_listener_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SocketListener)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SocketListener)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SocketListener ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSocketListenerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSocketListenerMethod "accept" o = SocketListenerAcceptMethodInfo
    ResolveSocketListenerMethod "acceptAsync" o = SocketListenerAcceptAsyncMethodInfo
    ResolveSocketListenerMethod "acceptFinish" o = SocketListenerAcceptFinishMethodInfo
    ResolveSocketListenerMethod "acceptSocket" o = SocketListenerAcceptSocketMethodInfo
    ResolveSocketListenerMethod "acceptSocketAsync" o = SocketListenerAcceptSocketAsyncMethodInfo
    ResolveSocketListenerMethod "acceptSocketFinish" o = SocketListenerAcceptSocketFinishMethodInfo
    ResolveSocketListenerMethod "addAddress" o = SocketListenerAddAddressMethodInfo
    ResolveSocketListenerMethod "addAnyInetPort" o = SocketListenerAddAnyInetPortMethodInfo
    ResolveSocketListenerMethod "addInetPort" o = SocketListenerAddInetPortMethodInfo
    ResolveSocketListenerMethod "addSocket" o = SocketListenerAddSocketMethodInfo
    ResolveSocketListenerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSocketListenerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSocketListenerMethod "close" o = SocketListenerCloseMethodInfo
    ResolveSocketListenerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSocketListenerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSocketListenerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSocketListenerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSocketListenerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSocketListenerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSocketListenerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSocketListenerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSocketListenerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSocketListenerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSocketListenerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSocketListenerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSocketListenerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSocketListenerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSocketListenerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSocketListenerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSocketListenerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSocketListenerMethod "setBacklog" o = SocketListenerSetBacklogMethodInfo
    ResolveSocketListenerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSocketListenerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSocketListenerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSocketListenerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSocketListenerMethod t SocketListener, O.OverloadedMethod info SocketListener p) => OL.IsLabel t (SocketListener -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSocketListenerMethod t SocketListener, O.OverloadedMethod info SocketListener p, R.HasField t SocketListener p) => R.HasField t SocketListener p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSocketListenerMethod t SocketListener, O.OverloadedMethodInfo info SocketListener) => OL.IsLabel t (O.MethodProxy info SocketListener) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal SocketListener::event
-- | Emitted when /@listener@/\'s activity on /@socket@/ changes state.
-- Note that when /@listener@/ is used to listen on both IPv4 and
-- IPv6, a separate set of signals will be emitted for each, and
-- the order they happen in is undefined.
-- 
-- /Since: 2.46/
type SocketListenerEventCallback =
    Gio.Enums.SocketListenerEvent
    -- ^ /@event@/: the event that is occurring
    -> Gio.Socket.Socket
    -- ^ /@socket@/: the t'GI.Gio.Objects.Socket.Socket' the event is occurring on
    -> IO ()

type C_SocketListenerEventCallback =
    Ptr SocketListener ->                   -- object
    CUInt ->
    Ptr Gio.Socket.Socket ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SocketListenerEventCallback`.
foreign import ccall "wrapper"
    mk_SocketListenerEventCallback :: C_SocketListenerEventCallback -> IO (FunPtr C_SocketListenerEventCallback)

wrap_SocketListenerEventCallback :: 
    GObject a => (a -> SocketListenerEventCallback) ->
    C_SocketListenerEventCallback
wrap_SocketListenerEventCallback gi'cb gi'selfPtr event socket _ = do
    let event' = (toEnum . fromIntegral) event
    socket' <- (newObject Gio.Socket.Socket) socket
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  event' socket'


-- | Connect a signal handler for the [event](#signal:event) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' socketListener #event callback
-- @
-- 
-- 
onSocketListenerEvent :: (IsSocketListener a, MonadIO m) => a -> ((?self :: a) => SocketListenerEventCallback) -> m SignalHandlerId
onSocketListenerEvent obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SocketListenerEventCallback wrapped
    wrapped'' <- mk_SocketListenerEventCallback wrapped'
    connectSignalFunPtr obj "event" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [event](#signal:event) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' socketListener #event callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSocketListenerEvent :: (IsSocketListener a, MonadIO m) => a -> ((?self :: a) => SocketListenerEventCallback) -> m SignalHandlerId
afterSocketListenerEvent obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SocketListenerEventCallback wrapped
    wrapped'' <- mk_SocketListenerEventCallback wrapped'
    connectSignalFunPtr obj "event" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SocketListenerEventSignalInfo
instance SignalInfo SocketListenerEventSignalInfo where
    type HaskellCallbackType SocketListenerEventSignalInfo = SocketListenerEventCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SocketListenerEventCallback cb
        cb'' <- mk_SocketListenerEventCallback cb'
        connectSignalFunPtr obj "event" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener::event"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#g:signal:event"})

#endif

-- VVV Prop "listen-backlog"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@listen-backlog@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketListener #listenBacklog
-- @
getSocketListenerListenBacklog :: (MonadIO m, IsSocketListener o) => o -> m Int32
getSocketListenerListenBacklog obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "listen-backlog"

-- | Set the value of the “@listen-backlog@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketListener [ #listenBacklog 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketListenerListenBacklog :: (MonadIO m, IsSocketListener o) => o -> Int32 -> m ()
setSocketListenerListenBacklog obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "listen-backlog" val

-- | Construct a `GValueConstruct` with valid value for the “@listen-backlog@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketListenerListenBacklog :: (IsSocketListener o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructSocketListenerListenBacklog val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "listen-backlog" val

#if defined(ENABLE_OVERLOADING)
data SocketListenerListenBacklogPropertyInfo
instance AttrInfo SocketListenerListenBacklogPropertyInfo where
    type AttrAllowedOps SocketListenerListenBacklogPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SocketListenerListenBacklogPropertyInfo = IsSocketListener
    type AttrSetTypeConstraint SocketListenerListenBacklogPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint SocketListenerListenBacklogPropertyInfo = (~) Int32
    type AttrTransferType SocketListenerListenBacklogPropertyInfo = Int32
    type AttrGetType SocketListenerListenBacklogPropertyInfo = Int32
    type AttrLabel SocketListenerListenBacklogPropertyInfo = "listen-backlog"
    type AttrOrigin SocketListenerListenBacklogPropertyInfo = SocketListener
    attrGet = getSocketListenerListenBacklog
    attrSet = setSocketListenerListenBacklog
    attrTransfer _ v = do
        return v
    attrConstruct = constructSocketListenerListenBacklog
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.listenBacklog"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#g:attr:listenBacklog"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SocketListener
type instance O.AttributeList SocketListener = SocketListenerAttributeList
type SocketListenerAttributeList = ('[ '("listenBacklog", SocketListenerListenBacklogPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
socketListenerListenBacklog :: AttrLabelProxy "listenBacklog"
socketListenerListenBacklog = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SocketListener = SocketListenerSignalList
type SocketListenerSignalList = ('[ '("event", SocketListenerEventSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SocketListener::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketListener" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_listener_new" g_socket_listener_new :: 
    IO (Ptr SocketListener)

-- | Creates a new t'GI.Gio.Objects.SocketListener.SocketListener' with no sockets to listen for.
-- New listeners can be added with e.g. 'GI.Gio.Objects.SocketListener.socketListenerAddAddress'
-- or 'GI.Gio.Objects.SocketListener.socketListenerAddInetPort'.
-- 
-- /Since: 2.22/
socketListenerNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m SocketListener
    -- ^ __Returns:__ a new t'GI.Gio.Objects.SocketListener.SocketListener'.
socketListenerNew  = liftIO $ do
    result <- g_socket_listener_new
    checkUnexpectedReturnNULL "socketListenerNew" result
    result' <- (wrapObject SocketListener) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SocketListener::accept
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location where #GObject pointer will be stored, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_listener_accept" g_socket_listener_accept :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Ptr (Ptr GObject.Object.Object) ->      -- source_object : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketConnection.SocketConnection)

-- | Blocks waiting for a client to connect to any of the sockets added
-- to the listener. Returns a t'GI.Gio.Objects.SocketConnection.SocketConnection' for the socket that was
-- accepted.
-- 
-- If /@sourceObject@/ is not 'P.Nothing' it will be filled out with the source
-- object specified when the corresponding socket or address was added
-- to the listener.
-- 
-- If /@cancellable@/ is not 'P.Nothing', then the operation can be cancelled by
-- triggering the cancellable object from another thread. If the operation
-- was cancelled, the error 'GI.Gio.Enums.IOErrorEnumCancelled' will be returned.
-- 
-- /Since: 2.22/
socketListenerAccept ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ((Gio.SocketConnection.SocketConnection, Maybe GObject.Object.Object))
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketConnection.SocketConnection' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketListenerAccept listener cancellable = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    sourceObject <- callocMem :: IO (Ptr (Ptr GObject.Object.Object))
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_socket_listener_accept listener' sourceObject maybeCancellable
        checkUnexpectedReturnNULL "socketListenerAccept" result
        result' <- (wrapObject Gio.SocketConnection.SocketConnection) result
        sourceObject' <- peek sourceObject
        maybeSourceObject' <- convertIfNonNull sourceObject' $ \sourceObject'' -> do
            sourceObject''' <- (newObject GObject.Object.Object) sourceObject''
            return sourceObject'''
        touchManagedPtr listener
        whenJust cancellable touchManagedPtr
        freeMem sourceObject
        return (result', maybeSourceObject')
     ) (do
        freeMem sourceObject
     )

#if defined(ENABLE_OVERLOADING)
data SocketListenerAcceptMethodInfo
instance (signature ~ (Maybe (b) -> m ((Gio.SocketConnection.SocketConnection, Maybe GObject.Object.Object))), MonadIO m, IsSocketListener a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketListenerAcceptMethodInfo a signature where
    overloadedMethod = socketListenerAccept

instance O.OverloadedMethodInfo SocketListenerAcceptMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerAccept",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerAccept"
        })


#endif

-- method SocketListener::accept_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_listener_accept_async" g_socket_listener_accept_async :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | This is the asynchronous version of 'GI.Gio.Objects.SocketListener.socketListenerAccept'.
-- 
-- When the operation is finished /@callback@/ will be
-- called. You can then call 'GI.Gio.Objects.SocketListener.socketListenerAcceptFinish'
-- to get the result of the operation.
-- 
-- /Since: 2.22/
socketListenerAcceptAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    -> m ()
socketListenerAcceptAsync listener cancellable callback = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_socket_listener_accept_async listener' maybeCancellable maybeCallback userData
    touchManagedPtr listener
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketListenerAcceptAsyncMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsSocketListener a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketListenerAcceptAsyncMethodInfo a signature where
    overloadedMethod = socketListenerAcceptAsync

instance O.OverloadedMethodInfo SocketListenerAcceptAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerAcceptAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerAcceptAsync"
        })


#endif

-- method SocketListener::accept_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Optional #GObject identifying this source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_listener_accept_finish" g_socket_listener_accept_finish :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GObject.Object.Object) ->      -- source_object : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketConnection.SocketConnection)

-- | Finishes an async accept operation. See 'GI.Gio.Objects.SocketListener.socketListenerAcceptAsync'
-- 
-- /Since: 2.22/
socketListenerAcceptFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ((Gio.SocketConnection.SocketConnection, Maybe GObject.Object.Object))
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketConnection.SocketConnection' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketListenerAcceptFinish listener result_ = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    result_' <- unsafeManagedPtrCastPtr result_
    sourceObject <- callocMem :: IO (Ptr (Ptr GObject.Object.Object))
    onException (do
        result <- propagateGError $ g_socket_listener_accept_finish listener' result_' sourceObject
        checkUnexpectedReturnNULL "socketListenerAcceptFinish" result
        result' <- (wrapObject Gio.SocketConnection.SocketConnection) result
        sourceObject' <- peek sourceObject
        maybeSourceObject' <- convertIfNonNull sourceObject' $ \sourceObject'' -> do
            sourceObject''' <- (newObject GObject.Object.Object) sourceObject''
            return sourceObject'''
        touchManagedPtr listener
        touchManagedPtr result_
        freeMem sourceObject
        return (result', maybeSourceObject')
     ) (do
        freeMem sourceObject
     )

#if defined(ENABLE_OVERLOADING)
data SocketListenerAcceptFinishMethodInfo
instance (signature ~ (b -> m ((Gio.SocketConnection.SocketConnection, Maybe GObject.Object.Object))), MonadIO m, IsSocketListener a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod SocketListenerAcceptFinishMethodInfo a signature where
    overloadedMethod = socketListenerAcceptFinish

instance O.OverloadedMethodInfo SocketListenerAcceptFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerAcceptFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerAcceptFinish"
        })


#endif

-- method SocketListener::accept_socket
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location where #GObject pointer will be stored, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Socket" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_listener_accept_socket" g_socket_listener_accept_socket :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Ptr (Ptr GObject.Object.Object) ->      -- source_object : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.Socket.Socket)

-- | Blocks waiting for a client to connect to any of the sockets added
-- to the listener. Returns the t'GI.Gio.Objects.Socket.Socket' that was accepted.
-- 
-- If you want to accept the high-level t'GI.Gio.Objects.SocketConnection.SocketConnection', not a t'GI.Gio.Objects.Socket.Socket',
-- which is often the case, then you should use 'GI.Gio.Objects.SocketListener.socketListenerAccept'
-- instead.
-- 
-- If /@sourceObject@/ is not 'P.Nothing' it will be filled out with the source
-- object specified when the corresponding socket or address was added
-- to the listener.
-- 
-- If /@cancellable@/ is not 'P.Nothing', then the operation can be cancelled by
-- triggering the cancellable object from another thread. If the operation
-- was cancelled, the error 'GI.Gio.Enums.IOErrorEnumCancelled' will be returned.
-- 
-- /Since: 2.22/
socketListenerAcceptSocket ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ((Gio.Socket.Socket, Maybe GObject.Object.Object))
    -- ^ __Returns:__ a t'GI.Gio.Objects.Socket.Socket' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketListenerAcceptSocket listener cancellable = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    sourceObject <- callocMem :: IO (Ptr (Ptr GObject.Object.Object))
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_socket_listener_accept_socket listener' sourceObject maybeCancellable
        checkUnexpectedReturnNULL "socketListenerAcceptSocket" result
        result' <- (wrapObject Gio.Socket.Socket) result
        sourceObject' <- peek sourceObject
        maybeSourceObject' <- convertIfNonNull sourceObject' $ \sourceObject'' -> do
            sourceObject''' <- (newObject GObject.Object.Object) sourceObject''
            return sourceObject'''
        touchManagedPtr listener
        whenJust cancellable touchManagedPtr
        freeMem sourceObject
        return (result', maybeSourceObject')
     ) (do
        freeMem sourceObject
     )

#if defined(ENABLE_OVERLOADING)
data SocketListenerAcceptSocketMethodInfo
instance (signature ~ (Maybe (b) -> m ((Gio.Socket.Socket, Maybe GObject.Object.Object))), MonadIO m, IsSocketListener a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketListenerAcceptSocketMethodInfo a signature where
    overloadedMethod = socketListenerAcceptSocket

instance O.OverloadedMethodInfo SocketListenerAcceptSocketMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerAcceptSocket",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerAcceptSocket"
        })


#endif

-- method SocketListener::accept_socket_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_listener_accept_socket_async" g_socket_listener_accept_socket_async :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | This is the asynchronous version of 'GI.Gio.Objects.SocketListener.socketListenerAcceptSocket'.
-- 
-- When the operation is finished /@callback@/ will be
-- called. You can then call 'GI.Gio.Objects.SocketListener.socketListenerAcceptSocketFinish'
-- to get the result of the operation.
-- 
-- /Since: 2.22/
socketListenerAcceptSocketAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    -> m ()
socketListenerAcceptSocketAsync listener cancellable callback = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_socket_listener_accept_socket_async listener' maybeCancellable maybeCallback userData
    touchManagedPtr listener
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketListenerAcceptSocketAsyncMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsSocketListener a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketListenerAcceptSocketAsyncMethodInfo a signature where
    overloadedMethod = socketListenerAcceptSocketAsync

instance O.OverloadedMethodInfo SocketListenerAcceptSocketAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerAcceptSocketAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerAcceptSocketAsync"
        })


#endif

-- method SocketListener::accept_socket_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Optional #GObject identifying this source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Socket" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_listener_accept_socket_finish" g_socket_listener_accept_socket_finish :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GObject.Object.Object) ->      -- source_object : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.Socket.Socket)

-- | Finishes an async accept operation. See 'GI.Gio.Objects.SocketListener.socketListenerAcceptSocketAsync'
-- 
-- /Since: 2.22/
socketListenerAcceptSocketFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ((Gio.Socket.Socket, Maybe GObject.Object.Object))
    -- ^ __Returns:__ a t'GI.Gio.Objects.Socket.Socket' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketListenerAcceptSocketFinish listener result_ = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    result_' <- unsafeManagedPtrCastPtr result_
    sourceObject <- callocMem :: IO (Ptr (Ptr GObject.Object.Object))
    onException (do
        result <- propagateGError $ g_socket_listener_accept_socket_finish listener' result_' sourceObject
        checkUnexpectedReturnNULL "socketListenerAcceptSocketFinish" result
        result' <- (wrapObject Gio.Socket.Socket) result
        sourceObject' <- peek sourceObject
        maybeSourceObject' <- convertIfNonNull sourceObject' $ \sourceObject'' -> do
            sourceObject''' <- (newObject GObject.Object.Object) sourceObject''
            return sourceObject'''
        touchManagedPtr listener
        touchManagedPtr result_
        freeMem sourceObject
        return (result', maybeSourceObject')
     ) (do
        freeMem sourceObject
     )

#if defined(ENABLE_OVERLOADING)
data SocketListenerAcceptSocketFinishMethodInfo
instance (signature ~ (b -> m ((Gio.Socket.Socket, Maybe GObject.Object.Object))), MonadIO m, IsSocketListener a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod SocketListenerAcceptSocketFinishMethodInfo a signature where
    overloadedMethod = socketListenerAcceptSocketFinish

instance O.OverloadedMethodInfo SocketListenerAcceptSocketFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerAcceptSocketFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerAcceptSocketFinish"
        })


#endif

-- method SocketListener::add_address
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "protocol"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketProtocol" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketProtocol" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Optional #GObject identifying this source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "effective_address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketAddress" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store the address that was bound to, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_listener_add_address" g_socket_listener_add_address :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Ptr Gio.SocketAddress.SocketAddress ->  -- address : TInterface (Name {namespace = "Gio", name = "SocketAddress"})
    CUInt ->                                -- type : TInterface (Name {namespace = "Gio", name = "SocketType"})
    CInt ->                                 -- protocol : TInterface (Name {namespace = "Gio", name = "SocketProtocol"})
    Ptr GObject.Object.Object ->            -- source_object : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr (Ptr Gio.SocketAddress.SocketAddress) -> -- effective_address : TInterface (Name {namespace = "Gio", name = "SocketAddress"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Creates a socket of type /@type@/ and protocol /@protocol@/, binds
-- it to /@address@/ and adds it to the set of sockets we\'re accepting
-- sockets from.
-- 
-- Note that adding an IPv6 address, depending on the platform,
-- may or may not result in a listener that also accepts IPv4
-- connections.  For more deterministic behavior, see
-- 'GI.Gio.Objects.SocketListener.socketListenerAddInetPort'.
-- 
-- /@sourceObject@/ will be passed out in the various calls
-- to accept to identify this particular source, which is
-- useful if you\'re listening on multiple addresses and do
-- different things depending on what address is connected to.
-- 
-- If successful and /@effectiveAddress@/ is non-'P.Nothing' then it will
-- be set to the address that the binding actually occurred at.  This
-- is helpful for determining the port number that was used for when
-- requesting a binding to port 0 (ie: \"any port\").  This address, if
-- requested, belongs to the caller and must be freed.
-- 
-- Call 'GI.Gio.Objects.SocketListener.socketListenerClose' to stop listening on /@address@/; this will not
-- be done automatically when you drop your final reference to /@listener@/, as
-- references may be held internally.
-- 
-- /Since: 2.22/
socketListenerAddAddress ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a, Gio.SocketAddress.IsSocketAddress b, GObject.Object.IsObject c) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> b
    -- ^ /@address@/: a t'GI.Gio.Objects.SocketAddress.SocketAddress'
    -> Gio.Enums.SocketType
    -- ^ /@type@/: a t'GI.Gio.Enums.SocketType'
    -> Gio.Enums.SocketProtocol
    -- ^ /@protocol@/: a t'GI.Gio.Enums.SocketProtocol'
    -> Maybe (c)
    -- ^ /@sourceObject@/: Optional t'GI.GObject.Objects.Object.Object' identifying this source
    -> m (Gio.SocketAddress.SocketAddress)
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
socketListenerAddAddress listener address type_ protocol sourceObject = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    address' <- unsafeManagedPtrCastPtr address
    let type_' = (fromIntegral . fromEnum) type_
    let protocol' = (fromIntegral . fromEnum) protocol
    maybeSourceObject <- case sourceObject of
        Nothing -> return FP.nullPtr
        Just jSourceObject -> do
            jSourceObject' <- unsafeManagedPtrCastPtr jSourceObject
            return jSourceObject'
    effectiveAddress <- callocMem :: IO (Ptr (Ptr Gio.SocketAddress.SocketAddress))
    onException (do
        _ <- propagateGError $ g_socket_listener_add_address listener' address' type_' protocol' maybeSourceObject effectiveAddress
        effectiveAddress' <- peek effectiveAddress
        effectiveAddress'' <- (wrapObject Gio.SocketAddress.SocketAddress) effectiveAddress'
        touchManagedPtr listener
        touchManagedPtr address
        whenJust sourceObject touchManagedPtr
        freeMem effectiveAddress
        return effectiveAddress''
     ) (do
        freeMem effectiveAddress
     )

#if defined(ENABLE_OVERLOADING)
data SocketListenerAddAddressMethodInfo
instance (signature ~ (b -> Gio.Enums.SocketType -> Gio.Enums.SocketProtocol -> Maybe (c) -> m (Gio.SocketAddress.SocketAddress)), MonadIO m, IsSocketListener a, Gio.SocketAddress.IsSocketAddress b, GObject.Object.IsObject c) => O.OverloadedMethod SocketListenerAddAddressMethodInfo a signature where
    overloadedMethod = socketListenerAddAddress

instance O.OverloadedMethodInfo SocketListenerAddAddressMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerAddAddress",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerAddAddress"
        })


#endif

-- method SocketListener::add_any_inet_port
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Optional #GObject identifying this source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt16)
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_listener_add_any_inet_port" g_socket_listener_add_any_inet_port :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Ptr GObject.Object.Object ->            -- source_object : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr (Ptr GError) ->                     -- error
    IO Word16

-- | Listens for TCP connections on any available port number for both
-- IPv6 and IPv4 (if each is available).
-- 
-- This is useful if you need to have a socket for incoming connections
-- but don\'t care about the specific port number.
-- 
-- /@sourceObject@/ will be passed out in the various calls
-- to accept to identify this particular source, which is
-- useful if you\'re listening on multiple addresses and do
-- different things depending on what address is connected to.
-- 
-- /Since: 2.24/
socketListenerAddAnyInetPort ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a, GObject.Object.IsObject b) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> Maybe (b)
    -- ^ /@sourceObject@/: Optional t'GI.GObject.Objects.Object.Object' identifying this source
    -> m Word16
    -- ^ __Returns:__ the port number, or 0 in case of failure. /(Can throw 'Data.GI.Base.GError.GError')/
socketListenerAddAnyInetPort listener sourceObject = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    maybeSourceObject <- case sourceObject of
        Nothing -> return FP.nullPtr
        Just jSourceObject -> do
            jSourceObject' <- unsafeManagedPtrCastPtr jSourceObject
            return jSourceObject'
    onException (do
        result <- propagateGError $ g_socket_listener_add_any_inet_port listener' maybeSourceObject
        touchManagedPtr listener
        whenJust sourceObject touchManagedPtr
        return result
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketListenerAddAnyInetPortMethodInfo
instance (signature ~ (Maybe (b) -> m Word16), MonadIO m, IsSocketListener a, GObject.Object.IsObject b) => O.OverloadedMethod SocketListenerAddAnyInetPortMethodInfo a signature where
    overloadedMethod = socketListenerAddAnyInetPort

instance O.OverloadedMethodInfo SocketListenerAddAnyInetPortMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerAddAnyInetPort",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerAddAnyInetPort"
        })


#endif

-- method SocketListener::add_inet_port
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "port"
--           , argType = TBasicType TUInt16
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an IP port number (non-zero)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Optional #GObject identifying this source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_listener_add_inet_port" g_socket_listener_add_inet_port :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Word16 ->                               -- port : TBasicType TUInt16
    Ptr GObject.Object.Object ->            -- source_object : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Helper function for 'GI.Gio.Objects.SocketListener.socketListenerAddAddress' that
-- creates a TCP\/IP socket listening on IPv4 and IPv6 (if
-- supported) on the specified port on all interfaces.
-- 
-- /@sourceObject@/ will be passed out in the various calls
-- to accept to identify this particular source, which is
-- useful if you\'re listening on multiple addresses and do
-- different things depending on what address is connected to.
-- 
-- Call 'GI.Gio.Objects.SocketListener.socketListenerClose' to stop listening on /@port@/; this will not
-- be done automatically when you drop your final reference to /@listener@/, as
-- references may be held internally.
-- 
-- /Since: 2.22/
socketListenerAddInetPort ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a, GObject.Object.IsObject b) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> Word16
    -- ^ /@port@/: an IP port number (non-zero)
    -> Maybe (b)
    -- ^ /@sourceObject@/: Optional t'GI.GObject.Objects.Object.Object' identifying this source
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
socketListenerAddInetPort listener port sourceObject = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    maybeSourceObject <- case sourceObject of
        Nothing -> return FP.nullPtr
        Just jSourceObject -> do
            jSourceObject' <- unsafeManagedPtrCastPtr jSourceObject
            return jSourceObject'
    onException (do
        _ <- propagateGError $ g_socket_listener_add_inet_port listener' port maybeSourceObject
        touchManagedPtr listener
        whenJust sourceObject touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketListenerAddInetPortMethodInfo
instance (signature ~ (Word16 -> Maybe (b) -> m ()), MonadIO m, IsSocketListener a, GObject.Object.IsObject b) => O.OverloadedMethod SocketListenerAddInetPortMethodInfo a signature where
    overloadedMethod = socketListenerAddInetPort

instance O.OverloadedMethodInfo SocketListenerAddInetPortMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerAddInetPort",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerAddInetPort"
        })


#endif

-- method SocketListener::add_socket
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "socket"
--           , argType = TInterface Name { namespace = "Gio" , name = "Socket" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a listening #GSocket"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Optional #GObject identifying this source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_listener_add_socket" g_socket_listener_add_socket :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Ptr Gio.Socket.Socket ->                -- socket : TInterface (Name {namespace = "Gio", name = "Socket"})
    Ptr GObject.Object.Object ->            -- source_object : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Adds /@socket@/ to the set of sockets that we try to accept
-- new clients from. The socket must be bound to a local
-- address and listened to.
-- 
-- /@sourceObject@/ will be passed out in the various calls
-- to accept to identify this particular source, which is
-- useful if you\'re listening on multiple addresses and do
-- different things depending on what address is connected to.
-- 
-- The /@socket@/ will not be automatically closed when the /@listener@/ is finalized
-- unless the listener held the final reference to the socket. Before GLib 2.42,
-- the /@socket@/ was automatically closed on finalization of the /@listener@/, even
-- if references to it were held elsewhere.
-- 
-- /Since: 2.22/
socketListenerAddSocket ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a, Gio.Socket.IsSocket b, GObject.Object.IsObject c) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> b
    -- ^ /@socket@/: a listening t'GI.Gio.Objects.Socket.Socket'
    -> Maybe (c)
    -- ^ /@sourceObject@/: Optional t'GI.GObject.Objects.Object.Object' identifying this source
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
socketListenerAddSocket listener socket sourceObject = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    socket' <- unsafeManagedPtrCastPtr socket
    maybeSourceObject <- case sourceObject of
        Nothing -> return FP.nullPtr
        Just jSourceObject -> do
            jSourceObject' <- unsafeManagedPtrCastPtr jSourceObject
            return jSourceObject'
    onException (do
        _ <- propagateGError $ g_socket_listener_add_socket listener' socket' maybeSourceObject
        touchManagedPtr listener
        touchManagedPtr socket
        whenJust sourceObject touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketListenerAddSocketMethodInfo
instance (signature ~ (b -> Maybe (c) -> m ()), MonadIO m, IsSocketListener a, Gio.Socket.IsSocket b, GObject.Object.IsObject c) => O.OverloadedMethod SocketListenerAddSocketMethodInfo a signature where
    overloadedMethod = socketListenerAddSocket

instance O.OverloadedMethodInfo SocketListenerAddSocketMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerAddSocket",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerAddSocket"
        })


#endif

-- method SocketListener::close
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_listener_close" g_socket_listener_close :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    IO ()

-- | Closes all the sockets in the listener.
-- 
-- /Since: 2.22/
socketListenerClose ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> m ()
socketListenerClose listener = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    g_socket_listener_close listener'
    touchManagedPtr listener
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketListenerCloseMethodInfo
instance (signature ~ (m ()), MonadIO m, IsSocketListener a) => O.OverloadedMethod SocketListenerCloseMethodInfo a signature where
    overloadedMethod = socketListenerClose

instance O.OverloadedMethodInfo SocketListenerCloseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerClose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerClose"
        })


#endif

-- method SocketListener::set_backlog
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "listener"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketListener" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketListener" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "listen_backlog"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an integer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_listener_set_backlog" g_socket_listener_set_backlog :: 
    Ptr SocketListener ->                   -- listener : TInterface (Name {namespace = "Gio", name = "SocketListener"})
    Int32 ->                                -- listen_backlog : TBasicType TInt
    IO ()

-- | Sets the listen backlog on the sockets in the listener. This must be called
-- before adding any sockets, addresses or ports to the t'GI.Gio.Objects.SocketListener.SocketListener' (for
-- example, by calling 'GI.Gio.Objects.SocketListener.socketListenerAddInetPort') to be effective.
-- 
-- See 'GI.Gio.Objects.Socket.socketSetListenBacklog' for details
-- 
-- /Since: 2.22/
socketListenerSetBacklog ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketListener a) =>
    a
    -- ^ /@listener@/: a t'GI.Gio.Objects.SocketListener.SocketListener'
    -> Int32
    -- ^ /@listenBacklog@/: an integer
    -> m ()
socketListenerSetBacklog listener listenBacklog = liftIO $ do
    listener' <- unsafeManagedPtrCastPtr listener
    g_socket_listener_set_backlog listener' listenBacklog
    touchManagedPtr listener
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketListenerSetBacklogMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsSocketListener a) => O.OverloadedMethod SocketListenerSetBacklogMethodInfo a signature where
    overloadedMethod = socketListenerSetBacklog

instance O.OverloadedMethodInfo SocketListenerSetBacklogMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketListener.socketListenerSetBacklog",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketListener.html#v:socketListenerSetBacklog"
        })


#endif


