{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GSocketClient@ is a lightweight high-level utility class for connecting to
-- a network host using a connection oriented socket type.
-- 
-- You create a @GSocketClient@ object, set any options you want, and then
-- call a sync or async connect operation, which returns a
-- t'GI.Gio.Objects.SocketConnection.SocketConnection' subclass on success.
-- 
-- The type of the t'GI.Gio.Objects.SocketConnection.SocketConnection' object returned depends on the
-- type of the underlying socket that is in use. For instance, for a TCP\/IP
-- connection it will be a t'GI.Gio.Objects.TcpConnection.TcpConnection'.
-- 
-- As @GSocketClient@ is a lightweight object, you don\'t need to cache it. You
-- can just create a new one any time you need one.
-- 
-- /Since: 2.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SocketClient
    ( 

-- * Exported types
    SocketClient(..)                        ,
    IsSocketClient                          ,
    toSocketClient                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addApplicationProxy]("GI.Gio.Objects.SocketClient#g:method:addApplicationProxy"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [connect]("GI.Gio.Objects.SocketClient#g:method:connect"), [connectAsync]("GI.Gio.Objects.SocketClient#g:method:connectAsync"), [connectFinish]("GI.Gio.Objects.SocketClient#g:method:connectFinish"), [connectToHost]("GI.Gio.Objects.SocketClient#g:method:connectToHost"), [connectToHostAsync]("GI.Gio.Objects.SocketClient#g:method:connectToHostAsync"), [connectToHostFinish]("GI.Gio.Objects.SocketClient#g:method:connectToHostFinish"), [connectToService]("GI.Gio.Objects.SocketClient#g:method:connectToService"), [connectToServiceAsync]("GI.Gio.Objects.SocketClient#g:method:connectToServiceAsync"), [connectToServiceFinish]("GI.Gio.Objects.SocketClient#g:method:connectToServiceFinish"), [connectToUri]("GI.Gio.Objects.SocketClient#g:method:connectToUri"), [connectToUriAsync]("GI.Gio.Objects.SocketClient#g:method:connectToUriAsync"), [connectToUriFinish]("GI.Gio.Objects.SocketClient#g:method:connectToUriFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getEnableProxy]("GI.Gio.Objects.SocketClient#g:method:getEnableProxy"), [getFamily]("GI.Gio.Objects.SocketClient#g:method:getFamily"), [getLocalAddress]("GI.Gio.Objects.SocketClient#g:method:getLocalAddress"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getProtocol]("GI.Gio.Objects.SocketClient#g:method:getProtocol"), [getProxyResolver]("GI.Gio.Objects.SocketClient#g:method:getProxyResolver"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSocketType]("GI.Gio.Objects.SocketClient#g:method:getSocketType"), [getTimeout]("GI.Gio.Objects.SocketClient#g:method:getTimeout"), [getTls]("GI.Gio.Objects.SocketClient#g:method:getTls"), [getTlsValidationFlags]("GI.Gio.Objects.SocketClient#g:method:getTlsValidationFlags").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setEnableProxy]("GI.Gio.Objects.SocketClient#g:method:setEnableProxy"), [setFamily]("GI.Gio.Objects.SocketClient#g:method:setFamily"), [setLocalAddress]("GI.Gio.Objects.SocketClient#g:method:setLocalAddress"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setProtocol]("GI.Gio.Objects.SocketClient#g:method:setProtocol"), [setProxyResolver]("GI.Gio.Objects.SocketClient#g:method:setProxyResolver"), [setSocketType]("GI.Gio.Objects.SocketClient#g:method:setSocketType"), [setTimeout]("GI.Gio.Objects.SocketClient#g:method:setTimeout"), [setTls]("GI.Gio.Objects.SocketClient#g:method:setTls"), [setTlsValidationFlags]("GI.Gio.Objects.SocketClient#g:method:setTlsValidationFlags").

#if defined(ENABLE_OVERLOADING)
    ResolveSocketClientMethod               ,
#endif

-- ** addApplicationProxy #method:addApplicationProxy#

#if defined(ENABLE_OVERLOADING)
    SocketClientAddApplicationProxyMethodInfo,
#endif
    socketClientAddApplicationProxy         ,


-- ** connect #method:connect#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectMethodInfo           ,
#endif
    socketClientConnect                     ,


-- ** connectAsync #method:connectAsync#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectAsyncMethodInfo      ,
#endif
    socketClientConnectAsync                ,


-- ** connectFinish #method:connectFinish#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectFinishMethodInfo     ,
#endif
    socketClientConnectFinish               ,


-- ** connectToHost #method:connectToHost#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectToHostMethodInfo     ,
#endif
    socketClientConnectToHost               ,


-- ** connectToHostAsync #method:connectToHostAsync#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectToHostAsyncMethodInfo,
#endif
    socketClientConnectToHostAsync          ,


-- ** connectToHostFinish #method:connectToHostFinish#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectToHostFinishMethodInfo,
#endif
    socketClientConnectToHostFinish         ,


-- ** connectToService #method:connectToService#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectToServiceMethodInfo  ,
#endif
    socketClientConnectToService            ,


-- ** connectToServiceAsync #method:connectToServiceAsync#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectToServiceAsyncMethodInfo,
#endif
    socketClientConnectToServiceAsync       ,


-- ** connectToServiceFinish #method:connectToServiceFinish#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectToServiceFinishMethodInfo,
#endif
    socketClientConnectToServiceFinish      ,


-- ** connectToUri #method:connectToUri#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectToUriMethodInfo      ,
#endif
    socketClientConnectToUri                ,


-- ** connectToUriAsync #method:connectToUriAsync#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectToUriAsyncMethodInfo ,
#endif
    socketClientConnectToUriAsync           ,


-- ** connectToUriFinish #method:connectToUriFinish#

#if defined(ENABLE_OVERLOADING)
    SocketClientConnectToUriFinishMethodInfo,
#endif
    socketClientConnectToUriFinish          ,


-- ** getEnableProxy #method:getEnableProxy#

#if defined(ENABLE_OVERLOADING)
    SocketClientGetEnableProxyMethodInfo    ,
#endif
    socketClientGetEnableProxy              ,


-- ** getFamily #method:getFamily#

#if defined(ENABLE_OVERLOADING)
    SocketClientGetFamilyMethodInfo         ,
#endif
    socketClientGetFamily                   ,


-- ** getLocalAddress #method:getLocalAddress#

#if defined(ENABLE_OVERLOADING)
    SocketClientGetLocalAddressMethodInfo   ,
#endif
    socketClientGetLocalAddress             ,


-- ** getProtocol #method:getProtocol#

#if defined(ENABLE_OVERLOADING)
    SocketClientGetProtocolMethodInfo       ,
#endif
    socketClientGetProtocol                 ,


-- ** getProxyResolver #method:getProxyResolver#

#if defined(ENABLE_OVERLOADING)
    SocketClientGetProxyResolverMethodInfo  ,
#endif
    socketClientGetProxyResolver            ,


-- ** getSocketType #method:getSocketType#

#if defined(ENABLE_OVERLOADING)
    SocketClientGetSocketTypeMethodInfo     ,
#endif
    socketClientGetSocketType               ,


-- ** getTimeout #method:getTimeout#

#if defined(ENABLE_OVERLOADING)
    SocketClientGetTimeoutMethodInfo        ,
#endif
    socketClientGetTimeout                  ,


-- ** getTls #method:getTls#

#if defined(ENABLE_OVERLOADING)
    SocketClientGetTlsMethodInfo            ,
#endif
    socketClientGetTls                      ,


-- ** getTlsValidationFlags #method:getTlsValidationFlags#

#if defined(ENABLE_OVERLOADING)
    SocketClientGetTlsValidationFlagsMethodInfo,
#endif
    socketClientGetTlsValidationFlags       ,


-- ** new #method:new#

    socketClientNew                         ,


-- ** setEnableProxy #method:setEnableProxy#

#if defined(ENABLE_OVERLOADING)
    SocketClientSetEnableProxyMethodInfo    ,
#endif
    socketClientSetEnableProxy              ,


-- ** setFamily #method:setFamily#

#if defined(ENABLE_OVERLOADING)
    SocketClientSetFamilyMethodInfo         ,
#endif
    socketClientSetFamily                   ,


-- ** setLocalAddress #method:setLocalAddress#

#if defined(ENABLE_OVERLOADING)
    SocketClientSetLocalAddressMethodInfo   ,
#endif
    socketClientSetLocalAddress             ,


-- ** setProtocol #method:setProtocol#

#if defined(ENABLE_OVERLOADING)
    SocketClientSetProtocolMethodInfo       ,
#endif
    socketClientSetProtocol                 ,


-- ** setProxyResolver #method:setProxyResolver#

#if defined(ENABLE_OVERLOADING)
    SocketClientSetProxyResolverMethodInfo  ,
#endif
    socketClientSetProxyResolver            ,


-- ** setSocketType #method:setSocketType#

#if defined(ENABLE_OVERLOADING)
    SocketClientSetSocketTypeMethodInfo     ,
#endif
    socketClientSetSocketType               ,


-- ** setTimeout #method:setTimeout#

#if defined(ENABLE_OVERLOADING)
    SocketClientSetTimeoutMethodInfo        ,
#endif
    socketClientSetTimeout                  ,


-- ** setTls #method:setTls#

#if defined(ENABLE_OVERLOADING)
    SocketClientSetTlsMethodInfo            ,
#endif
    socketClientSetTls                      ,


-- ** setTlsValidationFlags #method:setTlsValidationFlags#

#if defined(ENABLE_OVERLOADING)
    SocketClientSetTlsValidationFlagsMethodInfo,
#endif
    socketClientSetTlsValidationFlags       ,




 -- * Properties


-- ** enableProxy #attr:enableProxy#
-- | Enable proxy support.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    SocketClientEnableProxyPropertyInfo     ,
#endif
    constructSocketClientEnableProxy        ,
    getSocketClientEnableProxy              ,
    setSocketClientEnableProxy              ,
#if defined(ENABLE_OVERLOADING)
    socketClientEnableProxy                 ,
#endif


-- ** family #attr:family#
-- | The address family to use for socket construction.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    SocketClientFamilyPropertyInfo          ,
#endif
    constructSocketClientFamily             ,
    getSocketClientFamily                   ,
    setSocketClientFamily                   ,
#if defined(ENABLE_OVERLOADING)
    socketClientFamily                      ,
#endif


-- ** localAddress #attr:localAddress#
-- | The local address constructed sockets will be bound to.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    SocketClientLocalAddressPropertyInfo    ,
#endif
    clearSocketClientLocalAddress           ,
    constructSocketClientLocalAddress       ,
    getSocketClientLocalAddress             ,
    setSocketClientLocalAddress             ,
#if defined(ENABLE_OVERLOADING)
    socketClientLocalAddress                ,
#endif


-- ** protocol #attr:protocol#
-- | The protocol to use for socket construction, or @0@ for default.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    SocketClientProtocolPropertyInfo        ,
#endif
    constructSocketClientProtocol           ,
    getSocketClientProtocol                 ,
    setSocketClientProtocol                 ,
#if defined(ENABLE_OVERLOADING)
    socketClientProtocol                    ,
#endif


-- ** proxyResolver #attr:proxyResolver#
-- | The proxy resolver to use
-- 
-- /Since: 2.36/

#if defined(ENABLE_OVERLOADING)
    SocketClientProxyResolverPropertyInfo   ,
#endif
    clearSocketClientProxyResolver          ,
    constructSocketClientProxyResolver      ,
    getSocketClientProxyResolver            ,
    setSocketClientProxyResolver            ,
#if defined(ENABLE_OVERLOADING)
    socketClientProxyResolver               ,
#endif


-- ** timeout #attr:timeout#
-- | The I\/O timeout for sockets, in seconds, or @0@ for none.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    SocketClientTimeoutPropertyInfo         ,
#endif
    constructSocketClientTimeout            ,
    getSocketClientTimeout                  ,
    setSocketClientTimeout                  ,
#if defined(ENABLE_OVERLOADING)
    socketClientTimeout                     ,
#endif


-- ** tls #attr:tls#
-- | Whether to create TLS connections.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    SocketClientTlsPropertyInfo             ,
#endif
    constructSocketClientTls                ,
    getSocketClientTls                      ,
    setSocketClientTls                      ,
#if defined(ENABLE_OVERLOADING)
    socketClientTls                         ,
#endif


-- ** tlsValidationFlags #attr:tlsValidationFlags#
-- | The TLS validation flags used when creating TLS connections. The
-- default value is 'GI.Gio.Flags.TlsCertificateFlagsValidateAll'.
-- 
-- GLib guarantees that if certificate verification fails, at least one
-- flag will be set, but it does not guarantee that all possible flags
-- will be set. Accordingly, you may not safely decide to ignore any
-- particular type of error. For example, it would be incorrect to mask
-- 'GI.Gio.Flags.TlsCertificateFlagsExpired' if you want to allow expired certificates,
-- because this could potentially be the only error flag set even if
-- other problems exist with the certificate. Therefore, there is no
-- safe way to use this property. This is not a horrible problem,
-- though, because you should not be attempting to ignore validation
-- errors anyway. If you really must ignore TLS certificate errors,
-- connect to the [SocketClient::event]("GI.Gio.Objects.SocketClient#g:signal:event") signal, wait for it to be
-- emitted with 'GI.Gio.Enums.SocketClientEventTlsHandshaking', and use that to
-- connect to [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate").

#if defined(ENABLE_OVERLOADING)
    SocketClientTlsValidationFlagsPropertyInfo,
#endif
    constructSocketClientTlsValidationFlags ,
    getSocketClientTlsValidationFlags       ,
    setSocketClientTlsValidationFlags       ,
#if defined(ENABLE_OVERLOADING)
    socketClientTlsValidationFlags          ,
#endif


-- ** type #attr:type#
-- | The type to use for socket construction.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    SocketClientTypePropertyInfo            ,
#endif
    constructSocketClientType               ,
    getSocketClientType                     ,
    setSocketClientType                     ,
#if defined(ENABLE_OVERLOADING)
    socketClientType                        ,
#endif




 -- * Signals


-- ** event #signal:event#

    SocketClientEventCallback               ,
#if defined(ENABLE_OVERLOADING)
    SocketClientEventSignalInfo             ,
#endif
    afterSocketClientEvent                  ,
    onSocketClientEvent                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Flags as GLib.Flags
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ProxyResolver as Gio.ProxyResolver
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketControlMessage as Gio.SocketControlMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputMessage as Gio.InputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputVector as Gio.InputVector
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputMessage as Gio.OutputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ProxyResolver as Gio.ProxyResolver
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection

#endif

-- | Memory-managed wrapper type.
newtype SocketClient = SocketClient (SP.ManagedPtr SocketClient)
    deriving (Eq)

instance SP.ManagedPtrNewtype SocketClient where
    toManagedPtr (SocketClient p) = p

foreign import ccall "g_socket_client_get_type"
    c_g_socket_client_get_type :: IO B.Types.GType

instance B.Types.TypedObject SocketClient where
    glibType = c_g_socket_client_get_type

instance B.Types.GObject SocketClient

-- | Type class for types which can be safely cast to `SocketClient`, for instance with `toSocketClient`.
class (SP.GObject o, O.IsDescendantOf SocketClient o) => IsSocketClient o
instance (SP.GObject o, O.IsDescendantOf SocketClient o) => IsSocketClient o

instance O.HasParentTypes SocketClient
type instance O.ParentTypes SocketClient = '[GObject.Object.Object]

-- | Cast to `SocketClient`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSocketClient :: (MIO.MonadIO m, IsSocketClient o) => o -> m SocketClient
toSocketClient = MIO.liftIO . B.ManagedPtr.unsafeCastTo SocketClient

-- | Convert 'SocketClient' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SocketClient) where
    gvalueGType_ = c_g_socket_client_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SocketClient)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SocketClient)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SocketClient ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSocketClientMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSocketClientMethod "addApplicationProxy" o = SocketClientAddApplicationProxyMethodInfo
    ResolveSocketClientMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSocketClientMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSocketClientMethod "connect" o = SocketClientConnectMethodInfo
    ResolveSocketClientMethod "connectAsync" o = SocketClientConnectAsyncMethodInfo
    ResolveSocketClientMethod "connectFinish" o = SocketClientConnectFinishMethodInfo
    ResolveSocketClientMethod "connectToHost" o = SocketClientConnectToHostMethodInfo
    ResolveSocketClientMethod "connectToHostAsync" o = SocketClientConnectToHostAsyncMethodInfo
    ResolveSocketClientMethod "connectToHostFinish" o = SocketClientConnectToHostFinishMethodInfo
    ResolveSocketClientMethod "connectToService" o = SocketClientConnectToServiceMethodInfo
    ResolveSocketClientMethod "connectToServiceAsync" o = SocketClientConnectToServiceAsyncMethodInfo
    ResolveSocketClientMethod "connectToServiceFinish" o = SocketClientConnectToServiceFinishMethodInfo
    ResolveSocketClientMethod "connectToUri" o = SocketClientConnectToUriMethodInfo
    ResolveSocketClientMethod "connectToUriAsync" o = SocketClientConnectToUriAsyncMethodInfo
    ResolveSocketClientMethod "connectToUriFinish" o = SocketClientConnectToUriFinishMethodInfo
    ResolveSocketClientMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSocketClientMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSocketClientMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSocketClientMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSocketClientMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSocketClientMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSocketClientMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSocketClientMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSocketClientMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSocketClientMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSocketClientMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSocketClientMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSocketClientMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSocketClientMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSocketClientMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSocketClientMethod "getEnableProxy" o = SocketClientGetEnableProxyMethodInfo
    ResolveSocketClientMethod "getFamily" o = SocketClientGetFamilyMethodInfo
    ResolveSocketClientMethod "getLocalAddress" o = SocketClientGetLocalAddressMethodInfo
    ResolveSocketClientMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSocketClientMethod "getProtocol" o = SocketClientGetProtocolMethodInfo
    ResolveSocketClientMethod "getProxyResolver" o = SocketClientGetProxyResolverMethodInfo
    ResolveSocketClientMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSocketClientMethod "getSocketType" o = SocketClientGetSocketTypeMethodInfo
    ResolveSocketClientMethod "getTimeout" o = SocketClientGetTimeoutMethodInfo
    ResolveSocketClientMethod "getTls" o = SocketClientGetTlsMethodInfo
    ResolveSocketClientMethod "getTlsValidationFlags" o = SocketClientGetTlsValidationFlagsMethodInfo
    ResolveSocketClientMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSocketClientMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSocketClientMethod "setEnableProxy" o = SocketClientSetEnableProxyMethodInfo
    ResolveSocketClientMethod "setFamily" o = SocketClientSetFamilyMethodInfo
    ResolveSocketClientMethod "setLocalAddress" o = SocketClientSetLocalAddressMethodInfo
    ResolveSocketClientMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSocketClientMethod "setProtocol" o = SocketClientSetProtocolMethodInfo
    ResolveSocketClientMethod "setProxyResolver" o = SocketClientSetProxyResolverMethodInfo
    ResolveSocketClientMethod "setSocketType" o = SocketClientSetSocketTypeMethodInfo
    ResolveSocketClientMethod "setTimeout" o = SocketClientSetTimeoutMethodInfo
    ResolveSocketClientMethod "setTls" o = SocketClientSetTlsMethodInfo
    ResolveSocketClientMethod "setTlsValidationFlags" o = SocketClientSetTlsValidationFlagsMethodInfo
    ResolveSocketClientMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSocketClientMethod t SocketClient, O.OverloadedMethod info SocketClient p) => OL.IsLabel t (SocketClient -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSocketClientMethod t SocketClient, O.OverloadedMethod info SocketClient p, R.HasField t SocketClient p) => R.HasField t SocketClient p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSocketClientMethod t SocketClient, O.OverloadedMethodInfo info SocketClient) => OL.IsLabel t (O.MethodProxy info SocketClient) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal SocketClient::event
-- | Emitted when /@client@/\'s activity on /@connectable@/ changes state.
-- Among other things, this can be used to provide progress
-- information about a network connection in the UI. The meanings of
-- the different /@event@/ values are as follows:
-- 
-- * 'GI.Gio.Enums.SocketClientEventResolving': /@client@/ is about to look up /@connectable@/
-- in DNS. /@connection@/ will be 'P.Nothing'.
-- * 'GI.Gio.Enums.SocketClientEventResolved':  /@client@/ has successfully resolved
-- /@connectable@/ in DNS. /@connection@/ will be 'P.Nothing'.
-- * 'GI.Gio.Enums.SocketClientEventConnecting': /@client@/ is about to make a connection
-- to a remote host; either a proxy server or the destination server
-- itself. /@connection@/ is the t'GI.Gio.Objects.SocketConnection.SocketConnection', which is not yet
-- connected.  Since GLib 2.40, you can access the remote
-- address via 'GI.Gio.Objects.SocketConnection.socketConnectionGetRemoteAddress'.
-- * 'GI.Gio.Enums.SocketClientEventConnected': /@client@/ has successfully connected
-- to a remote host. /@connection@/ is the connected t'GI.Gio.Objects.SocketConnection.SocketConnection'.
-- * 'GI.Gio.Enums.SocketClientEventProxyNegotiating': /@client@/ is about to negotiate
-- with a proxy to get it to connect to /@connectable@/. /@connection@/ is
-- the t'GI.Gio.Objects.SocketConnection.SocketConnection' to the proxy server.
-- * 'GI.Gio.Enums.SocketClientEventProxyNegotiated': /@client@/ has negotiated a
-- connection to /@connectable@/ through a proxy server. /@connection@/ is
-- the stream returned from 'GI.Gio.Interfaces.Proxy.proxyConnect', which may or may not
-- be a t'GI.Gio.Objects.SocketConnection.SocketConnection'.
-- * 'GI.Gio.Enums.SocketClientEventTlsHandshaking': /@client@/ is about to begin a TLS
-- handshake. /@connection@/ is a t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'.
-- * 'GI.Gio.Enums.SocketClientEventTlsHandshaked': /@client@/ has successfully completed
-- the TLS handshake. /@connection@/ is a t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'.
-- * 'GI.Gio.Enums.SocketClientEventComplete': /@client@/ has either successfully connected
-- to /@connectable@/ (in which case /@connection@/ is the t'GI.Gio.Objects.SocketConnection.SocketConnection'
-- that it will be returning to the caller) or has failed (in which
-- case /@connection@/ is 'P.Nothing' and the client is about to return an error).
-- 
-- 
-- Each event except 'GI.Gio.Enums.SocketClientEventComplete' may be emitted
-- multiple times (or not at all) for a given connectable (in
-- particular, if /@client@/ ends up attempting to connect to more than
-- one address). However, if /@client@/ emits the [SocketClient::event]("GI.Gio.Objects.SocketClient#g:signal:event")
-- signal at all for a given connectable, then it will always emit
-- it with 'GI.Gio.Enums.SocketClientEventComplete' when it is done.
-- 
-- Note that there may be additional t'GI.Gio.Enums.SocketClientEvent' values in
-- the future; unrecognized /@event@/ values should be ignored.
-- 
-- /Since: 2.32/
type SocketClientEventCallback =
    Gio.Enums.SocketClientEvent
    -- ^ /@event@/: the event that is occurring
    -> Gio.SocketConnectable.SocketConnectable
    -- ^ /@connectable@/: the t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable' that /@event@/ is occurring on
    -> Maybe Gio.IOStream.IOStream
    -- ^ /@connection@/: the current representation of the connection
    -> IO ()

type C_SocketClientEventCallback =
    Ptr SocketClient ->                     -- object
    CUInt ->
    Ptr Gio.SocketConnectable.SocketConnectable ->
    Ptr Gio.IOStream.IOStream ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SocketClientEventCallback`.
foreign import ccall "wrapper"
    mk_SocketClientEventCallback :: C_SocketClientEventCallback -> IO (FunPtr C_SocketClientEventCallback)

wrap_SocketClientEventCallback :: 
    GObject a => (a -> SocketClientEventCallback) ->
    C_SocketClientEventCallback
wrap_SocketClientEventCallback gi'cb gi'selfPtr event connectable connection _ = do
    let event' = (toEnum . fromIntegral) event
    connectable' <- (newObject Gio.SocketConnectable.SocketConnectable) connectable
    maybeConnection <-
        if connection == FP.nullPtr
        then return Nothing
        else do
            connection' <- (newObject Gio.IOStream.IOStream) connection
            return $ Just connection'
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  event' connectable' maybeConnection


-- | Connect a signal handler for the [event](#signal:event) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' socketClient #event callback
-- @
-- 
-- 
onSocketClientEvent :: (IsSocketClient a, MonadIO m) => a -> ((?self :: a) => SocketClientEventCallback) -> m SignalHandlerId
onSocketClientEvent obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SocketClientEventCallback wrapped
    wrapped'' <- mk_SocketClientEventCallback wrapped'
    connectSignalFunPtr obj "event" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [event](#signal:event) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' socketClient #event callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSocketClientEvent :: (IsSocketClient a, MonadIO m) => a -> ((?self :: a) => SocketClientEventCallback) -> m SignalHandlerId
afterSocketClientEvent obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SocketClientEventCallback wrapped
    wrapped'' <- mk_SocketClientEventCallback wrapped'
    connectSignalFunPtr obj "event" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SocketClientEventSignalInfo
instance SignalInfo SocketClientEventSignalInfo where
    type HaskellCallbackType SocketClientEventSignalInfo = SocketClientEventCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SocketClientEventCallback cb
        cb'' <- mk_SocketClientEventCallback cb'
        connectSignalFunPtr obj "event" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient::event"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#g:signal:event"})

#endif

-- VVV Prop "enable-proxy"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@enable-proxy@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketClient #enableProxy
-- @
getSocketClientEnableProxy :: (MonadIO m, IsSocketClient o) => o -> m Bool
getSocketClientEnableProxy obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "enable-proxy"

-- | Set the value of the “@enable-proxy@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketClient [ #enableProxy 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketClientEnableProxy :: (MonadIO m, IsSocketClient o) => o -> Bool -> m ()
setSocketClientEnableProxy obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "enable-proxy" val

-- | Construct a `GValueConstruct` with valid value for the “@enable-proxy@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketClientEnableProxy :: (IsSocketClient o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSocketClientEnableProxy val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "enable-proxy" val

#if defined(ENABLE_OVERLOADING)
data SocketClientEnableProxyPropertyInfo
instance AttrInfo SocketClientEnableProxyPropertyInfo where
    type AttrAllowedOps SocketClientEnableProxyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SocketClientEnableProxyPropertyInfo = IsSocketClient
    type AttrSetTypeConstraint SocketClientEnableProxyPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SocketClientEnableProxyPropertyInfo = (~) Bool
    type AttrTransferType SocketClientEnableProxyPropertyInfo = Bool
    type AttrGetType SocketClientEnableProxyPropertyInfo = Bool
    type AttrLabel SocketClientEnableProxyPropertyInfo = "enable-proxy"
    type AttrOrigin SocketClientEnableProxyPropertyInfo = SocketClient
    attrGet = getSocketClientEnableProxy
    attrSet = setSocketClientEnableProxy
    attrTransfer _ v = do
        return v
    attrConstruct = constructSocketClientEnableProxy
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.enableProxy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#g:attr:enableProxy"
        })
#endif

-- VVV Prop "family"
   -- Type: TInterface (Name {namespace = "Gio", name = "SocketFamily"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@family@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketClient #family
-- @
getSocketClientFamily :: (MonadIO m, IsSocketClient o) => o -> m Gio.Enums.SocketFamily
getSocketClientFamily obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "family"

-- | Set the value of the “@family@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketClient [ #family 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketClientFamily :: (MonadIO m, IsSocketClient o) => o -> Gio.Enums.SocketFamily -> m ()
setSocketClientFamily obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "family" val

-- | Construct a `GValueConstruct` with valid value for the “@family@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketClientFamily :: (IsSocketClient o, MIO.MonadIO m) => Gio.Enums.SocketFamily -> m (GValueConstruct o)
constructSocketClientFamily val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "family" val

#if defined(ENABLE_OVERLOADING)
data SocketClientFamilyPropertyInfo
instance AttrInfo SocketClientFamilyPropertyInfo where
    type AttrAllowedOps SocketClientFamilyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SocketClientFamilyPropertyInfo = IsSocketClient
    type AttrSetTypeConstraint SocketClientFamilyPropertyInfo = (~) Gio.Enums.SocketFamily
    type AttrTransferTypeConstraint SocketClientFamilyPropertyInfo = (~) Gio.Enums.SocketFamily
    type AttrTransferType SocketClientFamilyPropertyInfo = Gio.Enums.SocketFamily
    type AttrGetType SocketClientFamilyPropertyInfo = Gio.Enums.SocketFamily
    type AttrLabel SocketClientFamilyPropertyInfo = "family"
    type AttrOrigin SocketClientFamilyPropertyInfo = SocketClient
    attrGet = getSocketClientFamily
    attrSet = setSocketClientFamily
    attrTransfer _ v = do
        return v
    attrConstruct = constructSocketClientFamily
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.family"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#g:attr:family"
        })
#endif

-- VVV Prop "local-address"
   -- Type: TInterface (Name {namespace = "Gio", name = "SocketAddress"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@local-address@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketClient #localAddress
-- @
getSocketClientLocalAddress :: (MonadIO m, IsSocketClient o) => o -> m (Maybe Gio.SocketAddress.SocketAddress)
getSocketClientLocalAddress obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "local-address" Gio.SocketAddress.SocketAddress

-- | Set the value of the “@local-address@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketClient [ #localAddress 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketClientLocalAddress :: (MonadIO m, IsSocketClient o, Gio.SocketAddress.IsSocketAddress a) => o -> a -> m ()
setSocketClientLocalAddress obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "local-address" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@local-address@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketClientLocalAddress :: (IsSocketClient o, MIO.MonadIO m, Gio.SocketAddress.IsSocketAddress a) => a -> m (GValueConstruct o)
constructSocketClientLocalAddress val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "local-address" (P.Just val)

-- | Set the value of the “@local-address@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #localAddress
-- @
clearSocketClientLocalAddress :: (MonadIO m, IsSocketClient o) => o -> m ()
clearSocketClientLocalAddress obj = liftIO $ B.Properties.setObjectPropertyObject obj "local-address" (Nothing :: Maybe Gio.SocketAddress.SocketAddress)

#if defined(ENABLE_OVERLOADING)
data SocketClientLocalAddressPropertyInfo
instance AttrInfo SocketClientLocalAddressPropertyInfo where
    type AttrAllowedOps SocketClientLocalAddressPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SocketClientLocalAddressPropertyInfo = IsSocketClient
    type AttrSetTypeConstraint SocketClientLocalAddressPropertyInfo = Gio.SocketAddress.IsSocketAddress
    type AttrTransferTypeConstraint SocketClientLocalAddressPropertyInfo = Gio.SocketAddress.IsSocketAddress
    type AttrTransferType SocketClientLocalAddressPropertyInfo = Gio.SocketAddress.SocketAddress
    type AttrGetType SocketClientLocalAddressPropertyInfo = (Maybe Gio.SocketAddress.SocketAddress)
    type AttrLabel SocketClientLocalAddressPropertyInfo = "local-address"
    type AttrOrigin SocketClientLocalAddressPropertyInfo = SocketClient
    attrGet = getSocketClientLocalAddress
    attrSet = setSocketClientLocalAddress
    attrTransfer _ v = do
        unsafeCastTo Gio.SocketAddress.SocketAddress v
    attrConstruct = constructSocketClientLocalAddress
    attrClear = clearSocketClientLocalAddress
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.localAddress"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#g:attr:localAddress"
        })
#endif

-- VVV Prop "protocol"
   -- Type: TInterface (Name {namespace = "Gio", name = "SocketProtocol"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@protocol@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketClient #protocol
-- @
getSocketClientProtocol :: (MonadIO m, IsSocketClient o) => o -> m Gio.Enums.SocketProtocol
getSocketClientProtocol obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "protocol"

-- | Set the value of the “@protocol@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketClient [ #protocol 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketClientProtocol :: (MonadIO m, IsSocketClient o) => o -> Gio.Enums.SocketProtocol -> m ()
setSocketClientProtocol obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "protocol" val

-- | Construct a `GValueConstruct` with valid value for the “@protocol@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketClientProtocol :: (IsSocketClient o, MIO.MonadIO m) => Gio.Enums.SocketProtocol -> m (GValueConstruct o)
constructSocketClientProtocol val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "protocol" val

#if defined(ENABLE_OVERLOADING)
data SocketClientProtocolPropertyInfo
instance AttrInfo SocketClientProtocolPropertyInfo where
    type AttrAllowedOps SocketClientProtocolPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SocketClientProtocolPropertyInfo = IsSocketClient
    type AttrSetTypeConstraint SocketClientProtocolPropertyInfo = (~) Gio.Enums.SocketProtocol
    type AttrTransferTypeConstraint SocketClientProtocolPropertyInfo = (~) Gio.Enums.SocketProtocol
    type AttrTransferType SocketClientProtocolPropertyInfo = Gio.Enums.SocketProtocol
    type AttrGetType SocketClientProtocolPropertyInfo = Gio.Enums.SocketProtocol
    type AttrLabel SocketClientProtocolPropertyInfo = "protocol"
    type AttrOrigin SocketClientProtocolPropertyInfo = SocketClient
    attrGet = getSocketClientProtocol
    attrSet = setSocketClientProtocol
    attrTransfer _ v = do
        return v
    attrConstruct = constructSocketClientProtocol
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.protocol"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#g:attr:protocol"
        })
#endif

-- VVV Prop "proxy-resolver"
   -- Type: TInterface (Name {namespace = "Gio", name = "ProxyResolver"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just True)

-- | Get the value of the “@proxy-resolver@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketClient #proxyResolver
-- @
getSocketClientProxyResolver :: (MonadIO m, IsSocketClient o) => o -> m Gio.ProxyResolver.ProxyResolver
getSocketClientProxyResolver obj = MIO.liftIO $ checkUnexpectedNothing "getSocketClientProxyResolver" $ B.Properties.getObjectPropertyObject obj "proxy-resolver" Gio.ProxyResolver.ProxyResolver

-- | Set the value of the “@proxy-resolver@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketClient [ #proxyResolver 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketClientProxyResolver :: (MonadIO m, IsSocketClient o, Gio.ProxyResolver.IsProxyResolver a) => o -> a -> m ()
setSocketClientProxyResolver obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "proxy-resolver" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@proxy-resolver@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketClientProxyResolver :: (IsSocketClient o, MIO.MonadIO m, Gio.ProxyResolver.IsProxyResolver a) => a -> m (GValueConstruct o)
constructSocketClientProxyResolver val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "proxy-resolver" (P.Just val)

-- | Set the value of the “@proxy-resolver@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #proxyResolver
-- @
clearSocketClientProxyResolver :: (MonadIO m, IsSocketClient o) => o -> m ()
clearSocketClientProxyResolver obj = liftIO $ B.Properties.setObjectPropertyObject obj "proxy-resolver" (Nothing :: Maybe Gio.ProxyResolver.ProxyResolver)

#if defined(ENABLE_OVERLOADING)
data SocketClientProxyResolverPropertyInfo
instance AttrInfo SocketClientProxyResolverPropertyInfo where
    type AttrAllowedOps SocketClientProxyResolverPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SocketClientProxyResolverPropertyInfo = IsSocketClient
    type AttrSetTypeConstraint SocketClientProxyResolverPropertyInfo = Gio.ProxyResolver.IsProxyResolver
    type AttrTransferTypeConstraint SocketClientProxyResolverPropertyInfo = Gio.ProxyResolver.IsProxyResolver
    type AttrTransferType SocketClientProxyResolverPropertyInfo = Gio.ProxyResolver.ProxyResolver
    type AttrGetType SocketClientProxyResolverPropertyInfo = Gio.ProxyResolver.ProxyResolver
    type AttrLabel SocketClientProxyResolverPropertyInfo = "proxy-resolver"
    type AttrOrigin SocketClientProxyResolverPropertyInfo = SocketClient
    attrGet = getSocketClientProxyResolver
    attrSet = setSocketClientProxyResolver
    attrTransfer _ v = do
        unsafeCastTo Gio.ProxyResolver.ProxyResolver v
    attrConstruct = constructSocketClientProxyResolver
    attrClear = clearSocketClientProxyResolver
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.proxyResolver"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#g:attr:proxyResolver"
        })
#endif

-- VVV Prop "timeout"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@timeout@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketClient #timeout
-- @
getSocketClientTimeout :: (MonadIO m, IsSocketClient o) => o -> m Word32
getSocketClientTimeout obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "timeout"

-- | Set the value of the “@timeout@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketClient [ #timeout 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketClientTimeout :: (MonadIO m, IsSocketClient o) => o -> Word32 -> m ()
setSocketClientTimeout obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "timeout" val

-- | Construct a `GValueConstruct` with valid value for the “@timeout@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketClientTimeout :: (IsSocketClient o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructSocketClientTimeout val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "timeout" val

#if defined(ENABLE_OVERLOADING)
data SocketClientTimeoutPropertyInfo
instance AttrInfo SocketClientTimeoutPropertyInfo where
    type AttrAllowedOps SocketClientTimeoutPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SocketClientTimeoutPropertyInfo = IsSocketClient
    type AttrSetTypeConstraint SocketClientTimeoutPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint SocketClientTimeoutPropertyInfo = (~) Word32
    type AttrTransferType SocketClientTimeoutPropertyInfo = Word32
    type AttrGetType SocketClientTimeoutPropertyInfo = Word32
    type AttrLabel SocketClientTimeoutPropertyInfo = "timeout"
    type AttrOrigin SocketClientTimeoutPropertyInfo = SocketClient
    attrGet = getSocketClientTimeout
    attrSet = setSocketClientTimeout
    attrTransfer _ v = do
        return v
    attrConstruct = constructSocketClientTimeout
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.timeout"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#g:attr:timeout"
        })
#endif

-- VVV Prop "tls"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@tls@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketClient #tls
-- @
getSocketClientTls :: (MonadIO m, IsSocketClient o) => o -> m Bool
getSocketClientTls obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "tls"

-- | Set the value of the “@tls@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketClient [ #tls 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketClientTls :: (MonadIO m, IsSocketClient o) => o -> Bool -> m ()
setSocketClientTls obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "tls" val

-- | Construct a `GValueConstruct` with valid value for the “@tls@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketClientTls :: (IsSocketClient o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSocketClientTls val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "tls" val

#if defined(ENABLE_OVERLOADING)
data SocketClientTlsPropertyInfo
instance AttrInfo SocketClientTlsPropertyInfo where
    type AttrAllowedOps SocketClientTlsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SocketClientTlsPropertyInfo = IsSocketClient
    type AttrSetTypeConstraint SocketClientTlsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SocketClientTlsPropertyInfo = (~) Bool
    type AttrTransferType SocketClientTlsPropertyInfo = Bool
    type AttrGetType SocketClientTlsPropertyInfo = Bool
    type AttrLabel SocketClientTlsPropertyInfo = "tls"
    type AttrOrigin SocketClientTlsPropertyInfo = SocketClient
    attrGet = getSocketClientTls
    attrSet = setSocketClientTls
    attrTransfer _ v = do
        return v
    attrConstruct = constructSocketClientTls
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.tls"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#g:attr:tls"
        })
#endif

-- VVV Prop "tls-validation-flags"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsCertificateFlags"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@tls-validation-flags@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketClient #tlsValidationFlags
-- @
getSocketClientTlsValidationFlags :: (MonadIO m, IsSocketClient o) => o -> m [Gio.Flags.TlsCertificateFlags]
getSocketClientTlsValidationFlags obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "tls-validation-flags"

-- | Set the value of the “@tls-validation-flags@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketClient [ #tlsValidationFlags 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketClientTlsValidationFlags :: (MonadIO m, IsSocketClient o) => o -> [Gio.Flags.TlsCertificateFlags] -> m ()
setSocketClientTlsValidationFlags obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "tls-validation-flags" val

-- | Construct a `GValueConstruct` with valid value for the “@tls-validation-flags@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketClientTlsValidationFlags :: (IsSocketClient o, MIO.MonadIO m) => [Gio.Flags.TlsCertificateFlags] -> m (GValueConstruct o)
constructSocketClientTlsValidationFlags val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "tls-validation-flags" val

#if defined(ENABLE_OVERLOADING)
data SocketClientTlsValidationFlagsPropertyInfo
instance AttrInfo SocketClientTlsValidationFlagsPropertyInfo where
    type AttrAllowedOps SocketClientTlsValidationFlagsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SocketClientTlsValidationFlagsPropertyInfo = IsSocketClient
    type AttrSetTypeConstraint SocketClientTlsValidationFlagsPropertyInfo = (~) [Gio.Flags.TlsCertificateFlags]
    type AttrTransferTypeConstraint SocketClientTlsValidationFlagsPropertyInfo = (~) [Gio.Flags.TlsCertificateFlags]
    type AttrTransferType SocketClientTlsValidationFlagsPropertyInfo = [Gio.Flags.TlsCertificateFlags]
    type AttrGetType SocketClientTlsValidationFlagsPropertyInfo = [Gio.Flags.TlsCertificateFlags]
    type AttrLabel SocketClientTlsValidationFlagsPropertyInfo = "tls-validation-flags"
    type AttrOrigin SocketClientTlsValidationFlagsPropertyInfo = SocketClient
    attrGet = getSocketClientTlsValidationFlags
    attrSet = setSocketClientTlsValidationFlags
    attrTransfer _ v = do
        return v
    attrConstruct = constructSocketClientTlsValidationFlags
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.tlsValidationFlags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#g:attr:tlsValidationFlags"
        })
#endif

-- VVV Prop "type"
   -- Type: TInterface (Name {namespace = "Gio", name = "SocketType"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketClient #type
-- @
getSocketClientType :: (MonadIO m, IsSocketClient o) => o -> m Gio.Enums.SocketType
getSocketClientType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "type"

-- | Set the value of the “@type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' socketClient [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setSocketClientType :: (MonadIO m, IsSocketClient o) => o -> Gio.Enums.SocketType -> m ()
setSocketClientType obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "type" val

-- | Construct a `GValueConstruct` with valid value for the “@type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSocketClientType :: (IsSocketClient o, MIO.MonadIO m) => Gio.Enums.SocketType -> m (GValueConstruct o)
constructSocketClientType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "type" val

#if defined(ENABLE_OVERLOADING)
data SocketClientTypePropertyInfo
instance AttrInfo SocketClientTypePropertyInfo where
    type AttrAllowedOps SocketClientTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SocketClientTypePropertyInfo = IsSocketClient
    type AttrSetTypeConstraint SocketClientTypePropertyInfo = (~) Gio.Enums.SocketType
    type AttrTransferTypeConstraint SocketClientTypePropertyInfo = (~) Gio.Enums.SocketType
    type AttrTransferType SocketClientTypePropertyInfo = Gio.Enums.SocketType
    type AttrGetType SocketClientTypePropertyInfo = Gio.Enums.SocketType
    type AttrLabel SocketClientTypePropertyInfo = "type"
    type AttrOrigin SocketClientTypePropertyInfo = SocketClient
    attrGet = getSocketClientType
    attrSet = setSocketClientType
    attrTransfer _ v = do
        return v
    attrConstruct = constructSocketClientType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#g:attr:type"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SocketClient
type instance O.AttributeList SocketClient = SocketClientAttributeList
type SocketClientAttributeList = ('[ '("enableProxy", SocketClientEnableProxyPropertyInfo), '("family", SocketClientFamilyPropertyInfo), '("localAddress", SocketClientLocalAddressPropertyInfo), '("protocol", SocketClientProtocolPropertyInfo), '("proxyResolver", SocketClientProxyResolverPropertyInfo), '("timeout", SocketClientTimeoutPropertyInfo), '("tls", SocketClientTlsPropertyInfo), '("tlsValidationFlags", SocketClientTlsValidationFlagsPropertyInfo), '("type", SocketClientTypePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
socketClientEnableProxy :: AttrLabelProxy "enableProxy"
socketClientEnableProxy = AttrLabelProxy

socketClientFamily :: AttrLabelProxy "family"
socketClientFamily = AttrLabelProxy

socketClientLocalAddress :: AttrLabelProxy "localAddress"
socketClientLocalAddress = AttrLabelProxy

socketClientProtocol :: AttrLabelProxy "protocol"
socketClientProtocol = AttrLabelProxy

socketClientProxyResolver :: AttrLabelProxy "proxyResolver"
socketClientProxyResolver = AttrLabelProxy

socketClientTimeout :: AttrLabelProxy "timeout"
socketClientTimeout = AttrLabelProxy

socketClientTls :: AttrLabelProxy "tls"
socketClientTls = AttrLabelProxy

socketClientTlsValidationFlags :: AttrLabelProxy "tlsValidationFlags"
socketClientTlsValidationFlags = AttrLabelProxy

socketClientType :: AttrLabelProxy "type"
socketClientType = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SocketClient = SocketClientSignalList
type SocketClientSignalList = ('[ '("event", SocketClientEventSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SocketClient::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketClient" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_new" g_socket_client_new :: 
    IO (Ptr SocketClient)

-- | Creates a new t'GI.Gio.Objects.SocketClient.SocketClient' with the default options.
-- 
-- /Since: 2.22/
socketClientNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m SocketClient
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketClient.SocketClient'.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'.
socketClientNew  = liftIO $ do
    result <- g_socket_client_new
    checkUnexpectedReturnNULL "socketClientNew" result
    result' <- (wrapObject SocketClient) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SocketClient::add_application_proxy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "protocol"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The proxy protocol" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_add_application_proxy" g_socket_client_add_application_proxy :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CString ->                              -- protocol : TBasicType TUTF8
    IO ()

-- | Enable proxy protocols to be handled by the application. When the
-- indicated proxy protocol is returned by the t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver',
-- t'GI.Gio.Objects.SocketClient.SocketClient' will consider this protocol as supported but will
-- not try to find a t'GI.Gio.Interfaces.Proxy.Proxy' instance to handle handshaking. The
-- application must check for this case by calling
-- 'GI.Gio.Objects.SocketConnection.socketConnectionGetRemoteAddress' on the returned
-- t'GI.Gio.Objects.SocketConnection.SocketConnection', and seeing if it\'s a t'GI.Gio.Objects.ProxyAddress.ProxyAddress' of the
-- appropriate type, to determine whether or not it needs to handle
-- the proxy handshaking itself.
-- 
-- This should be used for proxy protocols that are dialects of
-- another protocol such as HTTP proxy. It also allows cohabitation of
-- proxy protocols that are reused between protocols. A good example
-- is HTTP. It can be used to proxy HTTP, FTP and Gopher and can also
-- be use as generic socket proxy through the HTTP CONNECT method.
-- 
-- When the proxy is detected as being an application proxy, TLS handshake
-- will be skipped. This is required to let the application do the proxy
-- specific handshake.
socketClientAddApplicationProxy ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'
    -> T.Text
    -- ^ /@protocol@/: The proxy protocol
    -> m ()
socketClientAddApplicationProxy client protocol = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    protocol' <- textToCString protocol
    g_socket_client_add_application_proxy client' protocol'
    touchManagedPtr client
    freeMem protocol'
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientAddApplicationProxyMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientAddApplicationProxyMethodInfo a signature where
    overloadedMethod = socketClientAddApplicationProxy

instance O.OverloadedMethodInfo SocketClientAddApplicationProxyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientAddApplicationProxy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientAddApplicationProxy"
        })


#endif

-- method SocketClient::connect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "connectable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketConnectable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GSocketConnectable specifying the remote address."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_client_connect" g_socket_client_connect :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    Ptr Gio.SocketConnectable.SocketConnectable -> -- connectable : TInterface (Name {namespace = "Gio", name = "SocketConnectable"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketConnection.SocketConnection)

-- | Tries to resolve the /@connectable@/ and make a network connection to it.
-- 
-- Upon a successful connection, a new t'GI.Gio.Objects.SocketConnection.SocketConnection' is constructed
-- and returned.  The caller owns this new object and must drop their
-- reference to it when finished with it.
-- 
-- The type of the t'GI.Gio.Objects.SocketConnection.SocketConnection' object returned depends on the type of
-- the underlying socket that is used. For instance, for a TCP\/IP connection
-- it will be a t'GI.Gio.Objects.TcpConnection.TcpConnection'.
-- 
-- The socket created will be the same family as the address that the
-- /@connectable@/ resolves to, unless family is set with 'GI.Gio.Objects.SocketClient.socketClientSetFamily'
-- or indirectly via 'GI.Gio.Objects.SocketClient.socketClientSetLocalAddress'. The socket type
-- defaults to 'GI.Gio.Enums.SocketTypeStream' but can be set with
-- 'GI.Gio.Objects.SocketClient.socketClientSetSocketType'.
-- 
-- If a local address is specified with 'GI.Gio.Objects.SocketClient.socketClientSetLocalAddress' the
-- socket will be bound to this address before connecting.
-- 
-- /Since: 2.22/
socketClientConnect ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.SocketConnectable.IsSocketConnectable b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> b
    -- ^ /@connectable@/: a t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable' specifying the remote address.
    -> Maybe (c)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m Gio.SocketConnection.SocketConnection
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketConnection.SocketConnection' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketClientConnect client connectable cancellable = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    connectable' <- unsafeManagedPtrCastPtr connectable
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_socket_client_connect client' connectable' maybeCancellable
        checkUnexpectedReturnNULL "socketClientConnect" result
        result' <- (wrapObject Gio.SocketConnection.SocketConnection) result
        touchManagedPtr client
        touchManagedPtr connectable
        whenJust cancellable touchManagedPtr
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectMethodInfo
instance (signature ~ (b -> Maybe (c) -> m Gio.SocketConnection.SocketConnection), MonadIO m, IsSocketClient a, Gio.SocketConnectable.IsSocketConnectable b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod SocketClientConnectMethodInfo a signature where
    overloadedMethod = socketClientConnect

instance O.OverloadedMethodInfo SocketClientConnectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnect"
        })


#endif

-- method SocketClient::connect_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "connectable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketConnectable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GSocketConnectable specifying the remote address."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_connect_async" g_socket_client_connect_async :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    Ptr Gio.SocketConnectable.SocketConnectable -> -- connectable : TInterface (Name {namespace = "Gio", name = "SocketConnectable"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | This is the asynchronous version of 'GI.Gio.Objects.SocketClient.socketClientConnect'.
-- 
-- You may wish to prefer the asynchronous version even in synchronous
-- command line programs because, since 2.60, it implements
-- <https://tools.ietf.org/html/rfc8305 RFC 8305> \"Happy Eyeballs\"
-- recommendations to work around long connection timeouts in networks
-- where IPv6 is broken by performing an IPv4 connection simultaneously
-- without waiting for IPv6 to time out, which is not supported by the
-- synchronous call. (This is not an API guarantee, and may change in
-- the future.)
-- 
-- When the operation is finished /@callback@/ will be
-- called. You can then call 'GI.Gio.Objects.SocketClient.socketClientConnectFinish' to get
-- the result of the operation.
-- 
-- /Since: 2.22/
socketClientConnectAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.SocketConnectable.IsSocketConnectable b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'
    -> b
    -- ^ /@connectable@/: a t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable' specifying the remote address.
    -> Maybe (c)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    -> m ()
socketClientConnectAsync client connectable cancellable callback = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    connectable' <- unsafeManagedPtrCastPtr connectable
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_socket_client_connect_async client' connectable' maybeCancellable maybeCallback userData
    touchManagedPtr client
    touchManagedPtr connectable
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectAsyncMethodInfo
instance (signature ~ (b -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsSocketClient a, Gio.SocketConnectable.IsSocketConnectable b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod SocketClientConnectAsyncMethodInfo a signature where
    overloadedMethod = socketClientConnectAsync

instance O.OverloadedMethodInfo SocketClientConnectAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectAsync"
        })


#endif

-- method SocketClient::connect_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_client_connect_finish" g_socket_client_connect_finish :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketConnection.SocketConnection)

-- | Finishes an async connect operation. See 'GI.Gio.Objects.SocketClient.socketClientConnectAsync'
-- 
-- /Since: 2.22/
socketClientConnectFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m Gio.SocketConnection.SocketConnection
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketConnection.SocketConnection' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketClientConnectFinish client result_ = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_socket_client_connect_finish client' result_'
        checkUnexpectedReturnNULL "socketClientConnectFinish" result
        result' <- (wrapObject Gio.SocketConnection.SocketConnection) result
        touchManagedPtr client
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectFinishMethodInfo
instance (signature ~ (b -> m Gio.SocketConnection.SocketConnection), MonadIO m, IsSocketClient a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod SocketClientConnectFinishMethodInfo a signature where
    overloadedMethod = socketClientConnectFinish

instance O.OverloadedMethodInfo SocketClientConnectFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectFinish"
        })


#endif

-- method SocketClient::connect_to_host
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "host_and_port"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the name and optionally port of the host to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_port"
--           , argType = TBasicType TUInt16
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the default port to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_client_connect_to_host" g_socket_client_connect_to_host :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CString ->                              -- host_and_port : TBasicType TUTF8
    Word16 ->                               -- default_port : TBasicType TUInt16
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketConnection.SocketConnection)

-- | This is a helper function for 'GI.Gio.Objects.SocketClient.socketClientConnect'.
-- 
-- Attempts to create a TCP connection to the named host.
-- 
-- /@hostAndPort@/ may be in any of a number of recognized formats; an IPv6
-- address, an IPv4 address, or a domain name (in which case a DNS
-- lookup is performed).  Quoting with [] is supported for all address
-- types.  A port override may be specified in the usual way with a
-- colon.  Ports may be given as decimal numbers or symbolic names (in
-- which case an \/etc\/services lookup is performed).
-- 
-- If no port override is given in /@hostAndPort@/ then /@defaultPort@/ will be
-- used as the port number to connect to.
-- 
-- In general, /@hostAndPort@/ is expected to be provided by the user (allowing
-- them to give the hostname, and a port override if necessary) and
-- /@defaultPort@/ is expected to be provided by the application.
-- 
-- In the case that an IP address is given, a single connection
-- attempt is made.  In the case that a name is given, multiple
-- connection attempts may be made, in turn and according to the
-- number of address records in DNS, until a connection succeeds.
-- 
-- Upon a successful connection, a new t'GI.Gio.Objects.SocketConnection.SocketConnection' is constructed
-- and returned.  The caller owns this new object and must drop their
-- reference to it when finished with it.
-- 
-- In the event of any failure (DNS error, service not found, no hosts
-- connectable) 'P.Nothing' is returned and /@error@/ (if non-'P.Nothing') is set
-- accordingly.
-- 
-- /Since: 2.22/
socketClientConnectToHost ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'
    -> T.Text
    -- ^ /@hostAndPort@/: the name and optionally port of the host to connect to
    -> Word16
    -- ^ /@defaultPort@/: the default port to connect to
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m Gio.SocketConnection.SocketConnection
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketConnection.SocketConnection' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketClientConnectToHost client hostAndPort defaultPort cancellable = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    hostAndPort' <- textToCString hostAndPort
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_socket_client_connect_to_host client' hostAndPort' defaultPort maybeCancellable
        checkUnexpectedReturnNULL "socketClientConnectToHost" result
        result' <- (wrapObject Gio.SocketConnection.SocketConnection) result
        touchManagedPtr client
        whenJust cancellable touchManagedPtr
        freeMem hostAndPort'
        return result'
     ) (do
        freeMem hostAndPort'
     )

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectToHostMethodInfo
instance (signature ~ (T.Text -> Word16 -> Maybe (b) -> m Gio.SocketConnection.SocketConnection), MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketClientConnectToHostMethodInfo a signature where
    overloadedMethod = socketClientConnectToHost

instance O.OverloadedMethodInfo SocketClientConnectToHostMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectToHost",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectToHost"
        })


#endif

-- method SocketClient::connect_to_host_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "host_and_port"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the name and optionally the port of the host to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_port"
--           , argType = TBasicType TUInt16
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the default port to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_connect_to_host_async" g_socket_client_connect_to_host_async :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CString ->                              -- host_and_port : TBasicType TUTF8
    Word16 ->                               -- default_port : TBasicType TUInt16
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | This is the asynchronous version of 'GI.Gio.Objects.SocketClient.socketClientConnectToHost'.
-- 
-- When the operation is finished /@callback@/ will be
-- called. You can then call 'GI.Gio.Objects.SocketClient.socketClientConnectToHostFinish' to get
-- the result of the operation.
-- 
-- /Since: 2.22/
socketClientConnectToHostAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'
    -> T.Text
    -- ^ /@hostAndPort@/: the name and optionally the port of the host to connect to
    -> Word16
    -- ^ /@defaultPort@/: the default port to connect to
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    -> m ()
socketClientConnectToHostAsync client hostAndPort defaultPort cancellable callback = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    hostAndPort' <- textToCString hostAndPort
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_socket_client_connect_to_host_async client' hostAndPort' defaultPort maybeCancellable maybeCallback userData
    touchManagedPtr client
    whenJust cancellable touchManagedPtr
    freeMem hostAndPort'
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectToHostAsyncMethodInfo
instance (signature ~ (T.Text -> Word16 -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketClientConnectToHostAsyncMethodInfo a signature where
    overloadedMethod = socketClientConnectToHostAsync

instance O.OverloadedMethodInfo SocketClientConnectToHostAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectToHostAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectToHostAsync"
        })


#endif

-- method SocketClient::connect_to_host_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_client_connect_to_host_finish" g_socket_client_connect_to_host_finish :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketConnection.SocketConnection)

-- | Finishes an async connect operation. See 'GI.Gio.Objects.SocketClient.socketClientConnectToHostAsync'
-- 
-- /Since: 2.22/
socketClientConnectToHostFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m Gio.SocketConnection.SocketConnection
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketConnection.SocketConnection' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketClientConnectToHostFinish client result_ = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_socket_client_connect_to_host_finish client' result_'
        checkUnexpectedReturnNULL "socketClientConnectToHostFinish" result
        result' <- (wrapObject Gio.SocketConnection.SocketConnection) result
        touchManagedPtr client
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectToHostFinishMethodInfo
instance (signature ~ (b -> m Gio.SocketConnection.SocketConnection), MonadIO m, IsSocketClient a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod SocketClientConnectToHostFinishMethodInfo a signature where
    overloadedMethod = socketClientConnectToHostFinish

instance O.OverloadedMethodInfo SocketClientConnectToHostFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectToHostFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectToHostFinish"
        })


#endif

-- method SocketClient::connect_to_service
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a domain name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "service"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the service to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_client_connect_to_service" g_socket_client_connect_to_service :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CString ->                              -- domain : TBasicType TUTF8
    CString ->                              -- service : TBasicType TUTF8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketConnection.SocketConnection)

-- | Attempts to create a TCP connection to a service.
-- 
-- This call looks up the SRV record for /@service@/ at /@domain@/ for the
-- \"tcp\" protocol.  It then attempts to connect, in turn, to each of
-- the hosts providing the service until either a connection succeeds
-- or there are no hosts remaining.
-- 
-- Upon a successful connection, a new t'GI.Gio.Objects.SocketConnection.SocketConnection' is constructed
-- and returned.  The caller owns this new object and must drop their
-- reference to it when finished with it.
-- 
-- In the event of any failure (DNS error, service not found, no hosts
-- connectable) 'P.Nothing' is returned and /@error@/ (if non-'P.Nothing') is set
-- accordingly.
socketClientConnectToService ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketConnection.SocketConnection'
    -> T.Text
    -- ^ /@domain@/: a domain name
    -> T.Text
    -- ^ /@service@/: the name of the service to connect to
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m Gio.SocketConnection.SocketConnection
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketConnection.SocketConnection' if successful, or 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
socketClientConnectToService client domain service cancellable = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    domain' <- textToCString domain
    service' <- textToCString service
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_socket_client_connect_to_service client' domain' service' maybeCancellable
        checkUnexpectedReturnNULL "socketClientConnectToService" result
        result' <- (wrapObject Gio.SocketConnection.SocketConnection) result
        touchManagedPtr client
        whenJust cancellable touchManagedPtr
        freeMem domain'
        freeMem service'
        return result'
     ) (do
        freeMem domain'
        freeMem service'
     )

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectToServiceMethodInfo
instance (signature ~ (T.Text -> T.Text -> Maybe (b) -> m Gio.SocketConnection.SocketConnection), MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketClientConnectToServiceMethodInfo a signature where
    overloadedMethod = socketClientConnectToService

instance O.OverloadedMethodInfo SocketClientConnectToServiceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectToService",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectToService"
        })


#endif

-- method SocketClient::connect_to_service_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a domain name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "service"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the service to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_connect_to_service_async" g_socket_client_connect_to_service_async :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CString ->                              -- domain : TBasicType TUTF8
    CString ->                              -- service : TBasicType TUTF8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | This is the asynchronous version of
-- 'GI.Gio.Objects.SocketClient.socketClientConnectToService'.
-- 
-- /Since: 2.22/
socketClientConnectToServiceAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'
    -> T.Text
    -- ^ /@domain@/: a domain name
    -> T.Text
    -- ^ /@service@/: the name of the service to connect to
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    -> m ()
socketClientConnectToServiceAsync client domain service cancellable callback = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    domain' <- textToCString domain
    service' <- textToCString service
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_socket_client_connect_to_service_async client' domain' service' maybeCancellable maybeCallback userData
    touchManagedPtr client
    whenJust cancellable touchManagedPtr
    freeMem domain'
    freeMem service'
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectToServiceAsyncMethodInfo
instance (signature ~ (T.Text -> T.Text -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketClientConnectToServiceAsyncMethodInfo a signature where
    overloadedMethod = socketClientConnectToServiceAsync

instance O.OverloadedMethodInfo SocketClientConnectToServiceAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectToServiceAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectToServiceAsync"
        })


#endif

-- method SocketClient::connect_to_service_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_client_connect_to_service_finish" g_socket_client_connect_to_service_finish :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketConnection.SocketConnection)

-- | Finishes an async connect operation. See 'GI.Gio.Objects.SocketClient.socketClientConnectToServiceAsync'
-- 
-- /Since: 2.22/
socketClientConnectToServiceFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m Gio.SocketConnection.SocketConnection
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketConnection.SocketConnection' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketClientConnectToServiceFinish client result_ = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_socket_client_connect_to_service_finish client' result_'
        checkUnexpectedReturnNULL "socketClientConnectToServiceFinish" result
        result' <- (wrapObject Gio.SocketConnection.SocketConnection) result
        touchManagedPtr client
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectToServiceFinishMethodInfo
instance (signature ~ (b -> m Gio.SocketConnection.SocketConnection), MonadIO m, IsSocketClient a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod SocketClientConnectToServiceFinishMethodInfo a signature where
    overloadedMethod = socketClientConnectToServiceFinish

instance O.OverloadedMethodInfo SocketClientConnectToServiceFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectToServiceFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectToServiceFinish"
        })


#endif

-- method SocketClient::connect_to_uri
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A network URI" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_port"
--           , argType = TBasicType TUInt16
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the default port to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_client_connect_to_uri" g_socket_client_connect_to_uri :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CString ->                              -- uri : TBasicType TUTF8
    Word16 ->                               -- default_port : TBasicType TUInt16
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketConnection.SocketConnection)

-- | This is a helper function for 'GI.Gio.Objects.SocketClient.socketClientConnect'.
-- 
-- Attempts to create a TCP connection with a network URI.
-- 
-- /@uri@/ may be any valid URI containing an \"authority\" (hostname\/port)
-- component. If a port is not specified in the URI, /@defaultPort@/
-- will be used. TLS will be negotiated if [SocketClient:tls]("GI.Gio.Objects.SocketClient#g:attr:tls") is 'P.True'.
-- (t'GI.Gio.Objects.SocketClient.SocketClient' does not know to automatically assume TLS for
-- certain URI schemes.)
-- 
-- Using this rather than 'GI.Gio.Objects.SocketClient.socketClientConnect' or
-- 'GI.Gio.Objects.SocketClient.socketClientConnectToHost' allows t'GI.Gio.Objects.SocketClient.SocketClient' to
-- determine when to use application-specific proxy protocols.
-- 
-- Upon a successful connection, a new t'GI.Gio.Objects.SocketConnection.SocketConnection' is constructed
-- and returned.  The caller owns this new object and must drop their
-- reference to it when finished with it.
-- 
-- In the event of any failure (DNS error, service not found, no hosts
-- connectable) 'P.Nothing' is returned and /@error@/ (if non-'P.Nothing') is set
-- accordingly.
-- 
-- /Since: 2.26/
socketClientConnectToUri ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'
    -> T.Text
    -- ^ /@uri@/: A network URI
    -> Word16
    -- ^ /@defaultPort@/: the default port to connect to
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m Gio.SocketConnection.SocketConnection
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketConnection.SocketConnection' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketClientConnectToUri client uri defaultPort cancellable = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    uri' <- textToCString uri
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_socket_client_connect_to_uri client' uri' defaultPort maybeCancellable
        checkUnexpectedReturnNULL "socketClientConnectToUri" result
        result' <- (wrapObject Gio.SocketConnection.SocketConnection) result
        touchManagedPtr client
        whenJust cancellable touchManagedPtr
        freeMem uri'
        return result'
     ) (do
        freeMem uri'
     )

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectToUriMethodInfo
instance (signature ~ (T.Text -> Word16 -> Maybe (b) -> m Gio.SocketConnection.SocketConnection), MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketClientConnectToUriMethodInfo a signature where
    overloadedMethod = socketClientConnectToUri

instance O.OverloadedMethodInfo SocketClientConnectToUriMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectToUri",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectToUri"
        })


#endif

-- method SocketClient::connect_to_uri_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a network uri" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "default_port"
--           , argType = TBasicType TUInt16
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the default port to connect to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data for the callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_connect_to_uri_async" g_socket_client_connect_to_uri_async :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CString ->                              -- uri : TBasicType TUTF8
    Word16 ->                               -- default_port : TBasicType TUInt16
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | This is the asynchronous version of 'GI.Gio.Objects.SocketClient.socketClientConnectToUri'.
-- 
-- When the operation is finished /@callback@/ will be
-- called. You can then call 'GI.Gio.Objects.SocketClient.socketClientConnectToUriFinish' to get
-- the result of the operation.
-- 
-- /Since: 2.26/
socketClientConnectToUriAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'
    -> T.Text
    -- ^ /@uri@/: a network uri
    -> Word16
    -- ^ /@defaultPort@/: the default port to connect to
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    -> m ()
socketClientConnectToUriAsync client uri defaultPort cancellable callback = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    uri' <- textToCString uri
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_socket_client_connect_to_uri_async client' uri' defaultPort maybeCancellable maybeCallback userData
    touchManagedPtr client
    whenJust cancellable touchManagedPtr
    freeMem uri'
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectToUriAsyncMethodInfo
instance (signature ~ (T.Text -> Word16 -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsSocketClient a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SocketClientConnectToUriAsyncMethodInfo a signature where
    overloadedMethod = socketClientConnectToUriAsync

instance O.OverloadedMethodInfo SocketClientConnectToUriAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectToUriAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectToUriAsync"
        })


#endif

-- method SocketClient::connect_to_uri_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_client_connect_to_uri_finish" g_socket_client_connect_to_uri_finish :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.SocketConnection.SocketConnection)

-- | Finishes an async connect operation. See 'GI.Gio.Objects.SocketClient.socketClientConnectToUriAsync'
-- 
-- /Since: 2.26/
socketClientConnectToUriFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m Gio.SocketConnection.SocketConnection
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketConnection.SocketConnection' on success, 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
socketClientConnectToUriFinish client result_ = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_socket_client_connect_to_uri_finish client' result_'
        checkUnexpectedReturnNULL "socketClientConnectToUriFinish" result
        result' <- (wrapObject Gio.SocketConnection.SocketConnection) result
        touchManagedPtr client
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketClientConnectToUriFinishMethodInfo
instance (signature ~ (b -> m Gio.SocketConnection.SocketConnection), MonadIO m, IsSocketClient a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod SocketClientConnectToUriFinishMethodInfo a signature where
    overloadedMethod = socketClientConnectToUriFinish

instance O.OverloadedMethodInfo SocketClientConnectToUriFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientConnectToUriFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientConnectToUriFinish"
        })


#endif

-- method SocketClient::get_enable_proxy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_get_enable_proxy" g_socket_client_get_enable_proxy :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    IO CInt

-- | Gets the proxy enable state; see 'GI.Gio.Objects.SocketClient.socketClientSetEnableProxy'
-- 
-- /Since: 2.26/
socketClientGetEnableProxy ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> m Bool
    -- ^ __Returns:__ whether proxying is enabled
socketClientGetEnableProxy client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- g_socket_client_get_enable_proxy client'
    let result' = (/= 0) result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data SocketClientGetEnableProxyMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientGetEnableProxyMethodInfo a signature where
    overloadedMethod = socketClientGetEnableProxy

instance O.OverloadedMethodInfo SocketClientGetEnableProxyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientGetEnableProxy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientGetEnableProxy"
        })


#endif

-- method SocketClient::get_family
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketFamily" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_get_family" g_socket_client_get_family :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    IO CUInt

-- | Gets the socket family of the socket client.
-- 
-- See 'GI.Gio.Objects.SocketClient.socketClientSetFamily' for details.
-- 
-- /Since: 2.22/
socketClientGetFamily ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> m Gio.Enums.SocketFamily
    -- ^ __Returns:__ a t'GI.Gio.Enums.SocketFamily'
socketClientGetFamily client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- g_socket_client_get_family client'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data SocketClientGetFamilyMethodInfo
instance (signature ~ (m Gio.Enums.SocketFamily), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientGetFamilyMethodInfo a signature where
    overloadedMethod = socketClientGetFamily

instance O.OverloadedMethodInfo SocketClientGetFamilyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientGetFamily",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientGetFamily"
        })


#endif

-- method SocketClient::get_local_address
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_get_local_address" g_socket_client_get_local_address :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    IO (Ptr Gio.SocketAddress.SocketAddress)

-- | Gets the local address of the socket client.
-- 
-- See 'GI.Gio.Objects.SocketClient.socketClientSetLocalAddress' for details.
-- 
-- /Since: 2.22/
socketClientGetLocalAddress ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> m (Maybe Gio.SocketAddress.SocketAddress)
    -- ^ __Returns:__ a t'GI.Gio.Objects.SocketAddress.SocketAddress' or 'P.Nothing'. Do not free.
socketClientGetLocalAddress client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- g_socket_client_get_local_address client'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.SocketAddress.SocketAddress) result'
        return result''
    touchManagedPtr client
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SocketClientGetLocalAddressMethodInfo
instance (signature ~ (m (Maybe Gio.SocketAddress.SocketAddress)), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientGetLocalAddressMethodInfo a signature where
    overloadedMethod = socketClientGetLocalAddress

instance O.OverloadedMethodInfo SocketClientGetLocalAddressMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientGetLocalAddress",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientGetLocalAddress"
        })


#endif

-- method SocketClient::get_protocol
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketProtocol" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_get_protocol" g_socket_client_get_protocol :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    IO CInt

-- | Gets the protocol name type of the socket client.
-- 
-- See 'GI.Gio.Objects.SocketClient.socketClientSetProtocol' for details.
-- 
-- /Since: 2.22/
socketClientGetProtocol ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'
    -> m Gio.Enums.SocketProtocol
    -- ^ __Returns:__ a t'GI.Gio.Enums.SocketProtocol'
socketClientGetProtocol client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- g_socket_client_get_protocol client'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data SocketClientGetProtocolMethodInfo
instance (signature ~ (m Gio.Enums.SocketProtocol), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientGetProtocolMethodInfo a signature where
    overloadedMethod = socketClientGetProtocol

instance O.OverloadedMethodInfo SocketClientGetProtocolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientGetProtocol",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientGetProtocol"
        })


#endif

-- method SocketClient::get_proxy_resolver
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "ProxyResolver" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_get_proxy_resolver" g_socket_client_get_proxy_resolver :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    IO (Ptr Gio.ProxyResolver.ProxyResolver)

-- | Gets the t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver' being used by /@client@/. Normally, this will
-- be the resolver returned by 'GI.Gio.Functions.proxyResolverGetDefault', but you
-- can override it with 'GI.Gio.Objects.SocketClient.socketClientSetProxyResolver'.
-- 
-- /Since: 2.36/
socketClientGetProxyResolver ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> m Gio.ProxyResolver.ProxyResolver
    -- ^ __Returns:__ The t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver' being used by
    --   /@client@/.
socketClientGetProxyResolver client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- g_socket_client_get_proxy_resolver client'
    checkUnexpectedReturnNULL "socketClientGetProxyResolver" result
    result' <- (newObject Gio.ProxyResolver.ProxyResolver) result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data SocketClientGetProxyResolverMethodInfo
instance (signature ~ (m Gio.ProxyResolver.ProxyResolver), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientGetProxyResolverMethodInfo a signature where
    overloadedMethod = socketClientGetProxyResolver

instance O.OverloadedMethodInfo SocketClientGetProxyResolverMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientGetProxyResolver",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientGetProxyResolver"
        })


#endif

-- method SocketClient::get_socket_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "SocketType" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_get_socket_type" g_socket_client_get_socket_type :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    IO CUInt

-- | Gets the socket type of the socket client.
-- 
-- See 'GI.Gio.Objects.SocketClient.socketClientSetSocketType' for details.
-- 
-- /Since: 2.22/
socketClientGetSocketType ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> m Gio.Enums.SocketType
    -- ^ __Returns:__ a t'GI.Gio.Enums.SocketFamily'
socketClientGetSocketType client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- g_socket_client_get_socket_type client'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data SocketClientGetSocketTypeMethodInfo
instance (signature ~ (m Gio.Enums.SocketType), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientGetSocketTypeMethodInfo a signature where
    overloadedMethod = socketClientGetSocketType

instance O.OverloadedMethodInfo SocketClientGetSocketTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientGetSocketType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientGetSocketType"
        })


#endif

-- method SocketClient::get_timeout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_get_timeout" g_socket_client_get_timeout :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    IO Word32

-- | Gets the I\/O timeout time for sockets created by /@client@/.
-- 
-- See 'GI.Gio.Objects.SocketClient.socketClientSetTimeout' for details.
-- 
-- /Since: 2.26/
socketClientGetTimeout ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'
    -> m Word32
    -- ^ __Returns:__ the timeout in seconds
socketClientGetTimeout client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- g_socket_client_get_timeout client'
    touchManagedPtr client
    return result

#if defined(ENABLE_OVERLOADING)
data SocketClientGetTimeoutMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientGetTimeoutMethodInfo a signature where
    overloadedMethod = socketClientGetTimeout

instance O.OverloadedMethodInfo SocketClientGetTimeoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientGetTimeout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientGetTimeout"
        })


#endif

-- method SocketClient::get_tls
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_get_tls" g_socket_client_get_tls :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    IO CInt

-- | Gets whether /@client@/ creates TLS connections. See
-- 'GI.Gio.Objects.SocketClient.socketClientSetTls' for details.
-- 
-- /Since: 2.28/
socketClientGetTls ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> m Bool
    -- ^ __Returns:__ whether /@client@/ uses TLS
socketClientGetTls client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- g_socket_client_get_tls client'
    let result' = (/= 0) result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data SocketClientGetTlsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientGetTlsMethodInfo a signature where
    overloadedMethod = socketClientGetTls

instance O.OverloadedMethodInfo SocketClientGetTlsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientGetTls",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientGetTls"
        })


#endif

-- method SocketClient::get_tls_validation_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "TlsCertificateFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_get_tls_validation_flags" g_socket_client_get_tls_validation_flags :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    IO CUInt

{-# DEPRECATED socketClientGetTlsValidationFlags ["(Since version 2.72)","Do not attempt to ignore validation errors."] #-}
-- | Gets the TLS validation flags used creating TLS connections via
-- /@client@/.
-- 
-- This function does not work as originally designed and is impossible
-- to use correctly. See [SocketClient:tlsValidationFlags]("GI.Gio.Objects.SocketClient#g:attr:tlsValidationFlags") for more
-- information.
-- 
-- /Since: 2.28/
socketClientGetTlsValidationFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> m [Gio.Flags.TlsCertificateFlags]
    -- ^ __Returns:__ the TLS validation flags
socketClientGetTlsValidationFlags client = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    result <- g_socket_client_get_tls_validation_flags client'
    let result' = wordToGFlags result
    touchManagedPtr client
    return result'

#if defined(ENABLE_OVERLOADING)
data SocketClientGetTlsValidationFlagsMethodInfo
instance (signature ~ (m [Gio.Flags.TlsCertificateFlags]), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientGetTlsValidationFlagsMethodInfo a signature where
    overloadedMethod = socketClientGetTlsValidationFlags

instance O.OverloadedMethodInfo SocketClientGetTlsValidationFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientGetTlsValidationFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientGetTlsValidationFlags"
        })


#endif

-- method SocketClient::set_enable_proxy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enable"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to enable proxies"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_set_enable_proxy" g_socket_client_set_enable_proxy :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CInt ->                                 -- enable : TBasicType TBoolean
    IO ()

-- | Sets whether or not /@client@/ attempts to make connections via a
-- proxy server. When enabled (the default), t'GI.Gio.Objects.SocketClient.SocketClient' will use a
-- t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver' to determine if a proxy protocol such as SOCKS is
-- needed, and automatically do the necessary proxy negotiation.
-- 
-- See also 'GI.Gio.Objects.SocketClient.socketClientSetProxyResolver'.
-- 
-- /Since: 2.26/
socketClientSetEnableProxy ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> Bool
    -- ^ /@enable@/: whether to enable proxies
    -> m ()
socketClientSetEnableProxy client enable = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    let enable' = (P.fromIntegral . P.fromEnum) enable
    g_socket_client_set_enable_proxy client' enable'
    touchManagedPtr client
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientSetEnableProxyMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientSetEnableProxyMethodInfo a signature where
    overloadedMethod = socketClientSetEnableProxy

instance O.OverloadedMethodInfo SocketClientSetEnableProxyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientSetEnableProxy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientSetEnableProxy"
        })


#endif

-- method SocketClient::set_family
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "family"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketFamily" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketFamily" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_set_family" g_socket_client_set_family :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CUInt ->                                -- family : TInterface (Name {namespace = "Gio", name = "SocketFamily"})
    IO ()

-- | Sets the socket family of the socket client.
-- If this is set to something other than 'GI.Gio.Enums.SocketFamilyInvalid'
-- then the sockets created by this object will be of the specified
-- family.
-- 
-- This might be useful for instance if you want to force the local
-- connection to be an ipv4 socket, even though the address might
-- be an ipv6 mapped to ipv4 address.
-- 
-- /Since: 2.22/
socketClientSetFamily ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> Gio.Enums.SocketFamily
    -- ^ /@family@/: a t'GI.Gio.Enums.SocketFamily'
    -> m ()
socketClientSetFamily client family = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    let family' = (fromIntegral . fromEnum) family
    g_socket_client_set_family client' family'
    touchManagedPtr client
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientSetFamilyMethodInfo
instance (signature ~ (Gio.Enums.SocketFamily -> m ()), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientSetFamilyMethodInfo a signature where
    overloadedMethod = socketClientSetFamily

instance O.OverloadedMethodInfo SocketClientSetFamilyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientSetFamily",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientSetFamily"
        })


#endif

-- method SocketClient::set_local_address
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketAddress" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketAddress, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_set_local_address" g_socket_client_set_local_address :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    Ptr Gio.SocketAddress.SocketAddress ->  -- address : TInterface (Name {namespace = "Gio", name = "SocketAddress"})
    IO ()

-- | Sets the local address of the socket client.
-- The sockets created by this object will bound to the
-- specified address (if not 'P.Nothing') before connecting.
-- 
-- This is useful if you want to ensure that the local
-- side of the connection is on a specific port, or on
-- a specific interface.
-- 
-- /Since: 2.22/
socketClientSetLocalAddress ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.SocketAddress.IsSocketAddress b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> Maybe (b)
    -- ^ /@address@/: a t'GI.Gio.Objects.SocketAddress.SocketAddress', or 'P.Nothing'
    -> m ()
socketClientSetLocalAddress client address = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    maybeAddress <- case address of
        Nothing -> return FP.nullPtr
        Just jAddress -> do
            jAddress' <- unsafeManagedPtrCastPtr jAddress
            return jAddress'
    g_socket_client_set_local_address client' maybeAddress
    touchManagedPtr client
    whenJust address touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientSetLocalAddressMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsSocketClient a, Gio.SocketAddress.IsSocketAddress b) => O.OverloadedMethod SocketClientSetLocalAddressMethodInfo a signature where
    overloadedMethod = socketClientSetLocalAddress

instance O.OverloadedMethodInfo SocketClientSetLocalAddressMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientSetLocalAddress",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientSetLocalAddress"
        })


#endif

-- method SocketClient::set_protocol
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "protocol"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketProtocol" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketProtocol" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_set_protocol" g_socket_client_set_protocol :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CInt ->                                 -- protocol : TInterface (Name {namespace = "Gio", name = "SocketProtocol"})
    IO ()

-- | Sets the protocol of the socket client.
-- The sockets created by this object will use of the specified
-- protocol.
-- 
-- If /@protocol@/ is 'GI.Gio.Enums.SocketProtocolDefault' that means to use the default
-- protocol for the socket family and type.
-- 
-- /Since: 2.22/
socketClientSetProtocol ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> Gio.Enums.SocketProtocol
    -- ^ /@protocol@/: a t'GI.Gio.Enums.SocketProtocol'
    -> m ()
socketClientSetProtocol client protocol = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    let protocol' = (fromIntegral . fromEnum) protocol
    g_socket_client_set_protocol client' protocol'
    touchManagedPtr client
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientSetProtocolMethodInfo
instance (signature ~ (Gio.Enums.SocketProtocol -> m ()), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientSetProtocolMethodInfo a signature where
    overloadedMethod = socketClientSetProtocol

instance O.OverloadedMethodInfo SocketClientSetProtocolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientSetProtocol",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientSetProtocol"
        })


#endif

-- method SocketClient::set_proxy_resolver
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "proxy_resolver"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyResolver" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GProxyResolver, or %NULL for the\n  default."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_set_proxy_resolver" g_socket_client_set_proxy_resolver :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    Ptr Gio.ProxyResolver.ProxyResolver ->  -- proxy_resolver : TInterface (Name {namespace = "Gio", name = "ProxyResolver"})
    IO ()

-- | Overrides the t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver' used by /@client@/. You can call this if
-- you want to use specific proxies, rather than using the system
-- default proxy settings.
-- 
-- Note that whether or not the proxy resolver is actually used
-- depends on the setting of [SocketClient:enableProxy]("GI.Gio.Objects.SocketClient#g:attr:enableProxy"), which is not
-- changed by this function (but which is 'P.True' by default)
-- 
-- /Since: 2.36/
socketClientSetProxyResolver ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a, Gio.ProxyResolver.IsProxyResolver b) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> Maybe (b)
    -- ^ /@proxyResolver@/: a t'GI.Gio.Interfaces.ProxyResolver.ProxyResolver', or 'P.Nothing' for the
    --   default.
    -> m ()
socketClientSetProxyResolver client proxyResolver = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    maybeProxyResolver <- case proxyResolver of
        Nothing -> return FP.nullPtr
        Just jProxyResolver -> do
            jProxyResolver' <- unsafeManagedPtrCastPtr jProxyResolver
            return jProxyResolver'
    g_socket_client_set_proxy_resolver client' maybeProxyResolver
    touchManagedPtr client
    whenJust proxyResolver touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientSetProxyResolverMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsSocketClient a, Gio.ProxyResolver.IsProxyResolver b) => O.OverloadedMethod SocketClientSetProxyResolverMethodInfo a signature where
    overloadedMethod = socketClientSetProxyResolver

instance O.OverloadedMethodInfo SocketClientSetProxyResolverMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientSetProxyResolver",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientSetProxyResolver"
        })


#endif

-- method SocketClient::set_socket_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_set_socket_type" g_socket_client_set_socket_type :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CUInt ->                                -- type : TInterface (Name {namespace = "Gio", name = "SocketType"})
    IO ()

-- | Sets the socket type of the socket client.
-- The sockets created by this object will be of the specified
-- type.
-- 
-- It doesn\'t make sense to specify a type of 'GI.Gio.Enums.SocketTypeDatagram',
-- as GSocketClient is used for connection oriented services.
-- 
-- /Since: 2.22/
socketClientSetSocketType ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> Gio.Enums.SocketType
    -- ^ /@type@/: a t'GI.Gio.Enums.SocketType'
    -> m ()
socketClientSetSocketType client type_ = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    let type_' = (fromIntegral . fromEnum) type_
    g_socket_client_set_socket_type client' type_'
    touchManagedPtr client
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientSetSocketTypeMethodInfo
instance (signature ~ (Gio.Enums.SocketType -> m ()), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientSetSocketTypeMethodInfo a signature where
    overloadedMethod = socketClientSetSocketType

instance O.OverloadedMethodInfo SocketClientSetSocketTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientSetSocketType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientSetSocketType"
        })


#endif

-- method SocketClient::set_timeout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timeout"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the timeout" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_set_timeout" g_socket_client_set_timeout :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    Word32 ->                               -- timeout : TBasicType TUInt
    IO ()

-- | Sets the I\/O timeout for sockets created by /@client@/. /@timeout@/ is a
-- time in seconds, or 0 for no timeout (the default).
-- 
-- The timeout value affects the initial connection attempt as well,
-- so setting this may cause calls to 'GI.Gio.Objects.SocketClient.socketClientConnect', etc,
-- to fail with 'GI.Gio.Enums.IOErrorEnumTimedOut'.
-- 
-- /Since: 2.26/
socketClientSetTimeout ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> Word32
    -- ^ /@timeout@/: the timeout
    -> m ()
socketClientSetTimeout client timeout = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    g_socket_client_set_timeout client' timeout
    touchManagedPtr client
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientSetTimeoutMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientSetTimeoutMethodInfo a signature where
    overloadedMethod = socketClientSetTimeout

instance O.OverloadedMethodInfo SocketClientSetTimeoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientSetTimeout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientSetTimeout"
        })


#endif

-- method SocketClient::set_tls
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tls"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to use TLS" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_set_tls" g_socket_client_set_tls :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CInt ->                                 -- tls : TBasicType TBoolean
    IO ()

-- | Sets whether /@client@/ creates TLS (aka SSL) connections. If /@tls@/ is
-- 'P.True', /@client@/ will wrap its connections in a t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
-- and perform a TLS handshake when connecting.
-- 
-- Note that since t'GI.Gio.Objects.SocketClient.SocketClient' must return a t'GI.Gio.Objects.SocketConnection.SocketConnection',
-- but t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection' is not a t'GI.Gio.Objects.SocketConnection.SocketConnection', this
-- actually wraps the resulting t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection' in a
-- t'GI.Gio.Objects.TcpWrapperConnection.TcpWrapperConnection' when returning it. You can use
-- 'GI.Gio.Objects.TcpWrapperConnection.tcpWrapperConnectionGetBaseIoStream' on the return value
-- to extract the t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'.
-- 
-- If you need to modify the behavior of the TLS handshake (eg, by
-- setting a client-side certificate to use, or connecting to the
-- [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate") signal), you can connect to
-- /@client@/\'s [SocketClient::event]("GI.Gio.Objects.SocketClient#g:signal:event") signal and wait for it to be
-- emitted with 'GI.Gio.Enums.SocketClientEventTlsHandshaking', which will give you
-- a chance to see the t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection' before the handshake
-- starts.
-- 
-- /Since: 2.28/
socketClientSetTls ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> Bool
    -- ^ /@tls@/: whether to use TLS
    -> m ()
socketClientSetTls client tls = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    let tls' = (P.fromIntegral . P.fromEnum) tls
    g_socket_client_set_tls client' tls'
    touchManagedPtr client
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientSetTlsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientSetTlsMethodInfo a signature where
    overloadedMethod = socketClientSetTls

instance O.OverloadedMethodInfo SocketClientSetTlsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientSetTls",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientSetTls"
        })


#endif

-- method SocketClient::set_tls_validation_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "client"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketClient." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsCertificateFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the validation flags"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_client_set_tls_validation_flags" g_socket_client_set_tls_validation_flags :: 
    Ptr SocketClient ->                     -- client : TInterface (Name {namespace = "Gio", name = "SocketClient"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "TlsCertificateFlags"})
    IO ()

{-# DEPRECATED socketClientSetTlsValidationFlags ["(Since version 2.72)","Do not attempt to ignore validation errors."] #-}
-- | Sets the TLS validation flags used when creating TLS connections
-- via /@client@/. The default value is 'GI.Gio.Flags.TlsCertificateFlagsValidateAll'.
-- 
-- This function does not work as originally designed and is impossible
-- to use correctly. See [SocketClient:tlsValidationFlags]("GI.Gio.Objects.SocketClient#g:attr:tlsValidationFlags") for more
-- information.
-- 
-- /Since: 2.28/
socketClientSetTlsValidationFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketClient a) =>
    a
    -- ^ /@client@/: a t'GI.Gio.Objects.SocketClient.SocketClient'.
    -> [Gio.Flags.TlsCertificateFlags]
    -- ^ /@flags@/: the validation flags
    -> m ()
socketClientSetTlsValidationFlags client flags = liftIO $ do
    client' <- unsafeManagedPtrCastPtr client
    let flags' = gflagsToWord flags
    g_socket_client_set_tls_validation_flags client' flags'
    touchManagedPtr client
    return ()

#if defined(ENABLE_OVERLOADING)
data SocketClientSetTlsValidationFlagsMethodInfo
instance (signature ~ ([Gio.Flags.TlsCertificateFlags] -> m ()), MonadIO m, IsSocketClient a) => O.OverloadedMethod SocketClientSetTlsValidationFlagsMethodInfo a signature where
    overloadedMethod = socketClientSetTlsValidationFlags

instance O.OverloadedMethodInfo SocketClientSetTlsValidationFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketClient.socketClientSetTlsValidationFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SocketClient.html#v:socketClientSetTlsValidationFlags"
        })


#endif


