{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GSimplePermission@ is a trivial implementation of t'GI.Gio.Objects.Permission.Permission'
-- that represents a permission that is either always or never allowed.  The
-- value is given at construction and doesn’t change.
-- 
-- Calling 'GI.Gio.Objects.Permission.permissionAcquire' or 'GI.Gio.Objects.Permission.permissionRelease'
-- on a @GSimplePermission@ will result in errors.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SimplePermission
    ( 

-- * Exported types
    SimplePermission(..)                    ,
    IsSimplePermission                      ,
    toSimplePermission                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [acquire]("GI.Gio.Objects.Permission#g:method:acquire"), [acquireAsync]("GI.Gio.Objects.Permission#g:method:acquireAsync"), [acquireFinish]("GI.Gio.Objects.Permission#g:method:acquireFinish"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [implUpdate]("GI.Gio.Objects.Permission#g:method:implUpdate"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [release]("GI.Gio.Objects.Permission#g:method:release"), [releaseAsync]("GI.Gio.Objects.Permission#g:method:releaseAsync"), [releaseFinish]("GI.Gio.Objects.Permission#g:method:releaseFinish"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAllowed]("GI.Gio.Objects.Permission#g:method:getAllowed"), [getCanAcquire]("GI.Gio.Objects.Permission#g:method:getCanAcquire"), [getCanRelease]("GI.Gio.Objects.Permission#g:method:getCanRelease"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSimplePermissionMethod           ,
#endif

-- ** new #method:new#

    simplePermissionNew                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Permission as Gio.Permission

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.Permission as Gio.Permission

#endif

-- | Memory-managed wrapper type.
newtype SimplePermission = SimplePermission (SP.ManagedPtr SimplePermission)
    deriving (Eq)

instance SP.ManagedPtrNewtype SimplePermission where
    toManagedPtr (SimplePermission p) = p

foreign import ccall "g_simple_permission_get_type"
    c_g_simple_permission_get_type :: IO B.Types.GType

instance B.Types.TypedObject SimplePermission where
    glibType = c_g_simple_permission_get_type

instance B.Types.GObject SimplePermission

-- | Type class for types which can be safely cast to `SimplePermission`, for instance with `toSimplePermission`.
class (SP.GObject o, O.IsDescendantOf SimplePermission o) => IsSimplePermission o
instance (SP.GObject o, O.IsDescendantOf SimplePermission o) => IsSimplePermission o

instance O.HasParentTypes SimplePermission
type instance O.ParentTypes SimplePermission = '[Gio.Permission.Permission, GObject.Object.Object]

-- | Cast to `SimplePermission`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSimplePermission :: (MIO.MonadIO m, IsSimplePermission o) => o -> m SimplePermission
toSimplePermission = MIO.liftIO . B.ManagedPtr.unsafeCastTo SimplePermission

-- | Convert 'SimplePermission' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SimplePermission) where
    gvalueGType_ = c_g_simple_permission_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SimplePermission)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SimplePermission)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SimplePermission ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSimplePermissionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSimplePermissionMethod "acquire" o = Gio.Permission.PermissionAcquireMethodInfo
    ResolveSimplePermissionMethod "acquireAsync" o = Gio.Permission.PermissionAcquireAsyncMethodInfo
    ResolveSimplePermissionMethod "acquireFinish" o = Gio.Permission.PermissionAcquireFinishMethodInfo
    ResolveSimplePermissionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSimplePermissionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSimplePermissionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSimplePermissionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSimplePermissionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSimplePermissionMethod "implUpdate" o = Gio.Permission.PermissionImplUpdateMethodInfo
    ResolveSimplePermissionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSimplePermissionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSimplePermissionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSimplePermissionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSimplePermissionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSimplePermissionMethod "release" o = Gio.Permission.PermissionReleaseMethodInfo
    ResolveSimplePermissionMethod "releaseAsync" o = Gio.Permission.PermissionReleaseAsyncMethodInfo
    ResolveSimplePermissionMethod "releaseFinish" o = Gio.Permission.PermissionReleaseFinishMethodInfo
    ResolveSimplePermissionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSimplePermissionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSimplePermissionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSimplePermissionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSimplePermissionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSimplePermissionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSimplePermissionMethod "getAllowed" o = Gio.Permission.PermissionGetAllowedMethodInfo
    ResolveSimplePermissionMethod "getCanAcquire" o = Gio.Permission.PermissionGetCanAcquireMethodInfo
    ResolveSimplePermissionMethod "getCanRelease" o = Gio.Permission.PermissionGetCanReleaseMethodInfo
    ResolveSimplePermissionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSimplePermissionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSimplePermissionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSimplePermissionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSimplePermissionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSimplePermissionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSimplePermissionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSimplePermissionMethod t SimplePermission, O.OverloadedMethod info SimplePermission p) => OL.IsLabel t (SimplePermission -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSimplePermissionMethod t SimplePermission, O.OverloadedMethod info SimplePermission p, R.HasField t SimplePermission p) => R.HasField t SimplePermission p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSimplePermissionMethod t SimplePermission, O.OverloadedMethodInfo info SimplePermission) => OL.IsLabel t (O.MethodProxy info SimplePermission) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SimplePermission
type instance O.AttributeList SimplePermission = SimplePermissionAttributeList
type SimplePermissionAttributeList = ('[ '("allowed", Gio.Permission.PermissionAllowedPropertyInfo), '("canAcquire", Gio.Permission.PermissionCanAcquirePropertyInfo), '("canRelease", Gio.Permission.PermissionCanReleasePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SimplePermission = SimplePermissionSignalList
type SimplePermissionSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SimplePermission::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "allowed"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if the action is allowed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SimplePermission" })
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_permission_new" g_simple_permission_new :: 
    CInt ->                                 -- allowed : TBasicType TBoolean
    IO (Ptr SimplePermission)

-- | Creates a new t'GI.Gio.Objects.Permission.Permission' instance that represents an action that is
-- either always or never allowed.
-- 
-- /Since: 2.26/
simplePermissionNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Bool
    -- ^ /@allowed@/: 'P.True' if the action is allowed
    -> m SimplePermission
    -- ^ __Returns:__ the t'GI.Gio.Objects.SimplePermission.SimplePermission', as a t'GI.Gio.Objects.Permission.Permission'
simplePermissionNew allowed = liftIO $ do
    let allowed' = (P.fromIntegral . P.fromEnum) allowed
    result <- g_simple_permission_new allowed'
    checkUnexpectedReturnNULL "simplePermissionNew" result
    result' <- (wrapObject SimplePermission) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


