{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GSimpleIOStream@ creates a t'GI.Gio.Objects.IOStream.IOStream' from an arbitrary
-- t'GI.Gio.Objects.InputStream.InputStream' and t'GI.Gio.Objects.OutputStream.OutputStream'. This allows any pair of
-- input and output streams to be used with t'GI.Gio.Objects.IOStream.IOStream' methods.
-- 
-- This is useful when you obtained a t'GI.Gio.Objects.InputStream.InputStream' and a
-- t'GI.Gio.Objects.OutputStream.OutputStream' by other means, for instance creating them with
-- platform specific methods as
-- <http://developer.gnome.org/gio/stable/../gio-unix/ctor.UnixInputStream.new.html `g_unix_input_stream_new()`>
-- (from @gio-unix-2.0.pc@ \/ @GioUnix-2.0@), and you want to
-- take advantage of the methods provided by t'GI.Gio.Objects.IOStream.IOStream'.
-- 
-- /Since: 2.44/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SimpleIOStream
    ( 

-- * Exported types
    SimpleIOStream(..)                      ,
    IsSimpleIOStream                        ,
    toSimpleIOStream                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearPending]("GI.Gio.Objects.IOStream#g:method:clearPending"), [close]("GI.Gio.Objects.IOStream#g:method:close"), [closeAsync]("GI.Gio.Objects.IOStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.IOStream#g:method:closeFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.IOStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.IOStream#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [spliceAsync]("GI.Gio.Objects.IOStream#g:method:spliceAsync"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getInputStream]("GI.Gio.Objects.IOStream#g:method:getInputStream"), [getOutputStream]("GI.Gio.Objects.IOStream#g:method:getOutputStream"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.IOStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSimpleIOStreamMethod             ,
#endif

-- ** new #method:new#

    simpleIOStreamNew                       ,




 -- * Properties


-- ** inputStream #attr:inputStream#
-- | The t'GI.Gio.Objects.InputStream.InputStream' to read from.
-- 
-- /Since: 2.44/

#if defined(ENABLE_OVERLOADING)
    SimpleIOStreamInputStreamPropertyInfo   ,
#endif
    constructSimpleIOStreamInputStream      ,
    getSimpleIOStreamInputStream            ,
#if defined(ENABLE_OVERLOADING)
    simpleIOStreamInputStream               ,
#endif


-- ** outputStream #attr:outputStream#
-- | The t'GI.Gio.Objects.OutputStream.OutputStream' to write to.
-- 
-- /Since: 2.44/

#if defined(ENABLE_OVERLOADING)
    SimpleIOStreamOutputStreamPropertyInfo  ,
#endif
    constructSimpleIOStreamOutputStream     ,
    getSimpleIOStreamOutputStream           ,
#if defined(ENABLE_OVERLOADING)
    simpleIOStreamOutputStream              ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#endif

-- | Memory-managed wrapper type.
newtype SimpleIOStream = SimpleIOStream (SP.ManagedPtr SimpleIOStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype SimpleIOStream where
    toManagedPtr (SimpleIOStream p) = p

foreign import ccall "g_simple_io_stream_get_type"
    c_g_simple_io_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject SimpleIOStream where
    glibType = c_g_simple_io_stream_get_type

instance B.Types.GObject SimpleIOStream

-- | Type class for types which can be safely cast to `SimpleIOStream`, for instance with `toSimpleIOStream`.
class (SP.GObject o, O.IsDescendantOf SimpleIOStream o) => IsSimpleIOStream o
instance (SP.GObject o, O.IsDescendantOf SimpleIOStream o) => IsSimpleIOStream o

instance O.HasParentTypes SimpleIOStream
type instance O.ParentTypes SimpleIOStream = '[Gio.IOStream.IOStream, GObject.Object.Object]

-- | Cast to `SimpleIOStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSimpleIOStream :: (MIO.MonadIO m, IsSimpleIOStream o) => o -> m SimpleIOStream
toSimpleIOStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo SimpleIOStream

-- | Convert 'SimpleIOStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SimpleIOStream) where
    gvalueGType_ = c_g_simple_io_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SimpleIOStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SimpleIOStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SimpleIOStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSimpleIOStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSimpleIOStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSimpleIOStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSimpleIOStreamMethod "clearPending" o = Gio.IOStream.IOStreamClearPendingMethodInfo
    ResolveSimpleIOStreamMethod "close" o = Gio.IOStream.IOStreamCloseMethodInfo
    ResolveSimpleIOStreamMethod "closeAsync" o = Gio.IOStream.IOStreamCloseAsyncMethodInfo
    ResolveSimpleIOStreamMethod "closeFinish" o = Gio.IOStream.IOStreamCloseFinishMethodInfo
    ResolveSimpleIOStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSimpleIOStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSimpleIOStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSimpleIOStreamMethod "hasPending" o = Gio.IOStream.IOStreamHasPendingMethodInfo
    ResolveSimpleIOStreamMethod "isClosed" o = Gio.IOStream.IOStreamIsClosedMethodInfo
    ResolveSimpleIOStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSimpleIOStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSimpleIOStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSimpleIOStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSimpleIOStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSimpleIOStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSimpleIOStreamMethod "spliceAsync" o = Gio.IOStream.IOStreamSpliceAsyncMethodInfo
    ResolveSimpleIOStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSimpleIOStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSimpleIOStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSimpleIOStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSimpleIOStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSimpleIOStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSimpleIOStreamMethod "getInputStream" o = Gio.IOStream.IOStreamGetInputStreamMethodInfo
    ResolveSimpleIOStreamMethod "getOutputStream" o = Gio.IOStream.IOStreamGetOutputStreamMethodInfo
    ResolveSimpleIOStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSimpleIOStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSimpleIOStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSimpleIOStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSimpleIOStreamMethod "setPending" o = Gio.IOStream.IOStreamSetPendingMethodInfo
    ResolveSimpleIOStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSimpleIOStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSimpleIOStreamMethod t SimpleIOStream, O.OverloadedMethod info SimpleIOStream p) => OL.IsLabel t (SimpleIOStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSimpleIOStreamMethod t SimpleIOStream, O.OverloadedMethod info SimpleIOStream p, R.HasField t SimpleIOStream p) => R.HasField t SimpleIOStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSimpleIOStreamMethod t SimpleIOStream, O.OverloadedMethodInfo info SimpleIOStream) => OL.IsLabel t (O.MethodProxy info SimpleIOStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

--- XXX Duplicated object with different types:
  --- Name {namespace = "Gio", name = "SimpleIOStream"} -> Property {propName = "input-stream", propType = TInterface (Name {namespace = "Gio", name = "InputStream"}), propFlags = [PropertyReadable,PropertyWritable,PropertyConstructOnly], propReadNullable = Nothing, propWriteNullable = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The [class@Gio.InputStream] to read from.", sinceVersion = Just "2.44"}, propDeprecated = Nothing}
  --- Name {namespace = "Gio", name = "IOStream"} -> Property {propName = "input-stream", propType = TInterface (Name {namespace = "Gio", name = "InputStream"}), propFlags = [PropertyReadable], propReadNullable = Just False, propWriteNullable = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The [class@Gio.InputStream] to read from.", sinceVersion = Just "2.22"}, propDeprecated = Nothing}
--- XXX Duplicated object with different types:
  --- Name {namespace = "Gio", name = "SimpleIOStream"} -> Property {propName = "output-stream", propType = TInterface (Name {namespace = "Gio", name = "OutputStream"}), propFlags = [PropertyReadable,PropertyWritable,PropertyConstructOnly], propReadNullable = Nothing, propWriteNullable = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The [class@Gio.OutputStream] to write to.", sinceVersion = Just "2.44"}, propDeprecated = Nothing}
  --- Name {namespace = "Gio", name = "IOStream"} -> Property {propName = "output-stream", propType = TInterface (Name {namespace = "Gio", name = "OutputStream"}), propFlags = [PropertyReadable], propReadNullable = Just False, propWriteNullable = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The [class@Gio.OutputStream] to write to.", sinceVersion = Just "2.22"}, propDeprecated = Nothing}
-- VVV Prop "input-stream"
   -- Type: TInterface (Name {namespace = "Gio", name = "InputStream"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@input-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' simpleIOStream #inputStream
-- @
getSimpleIOStreamInputStream :: (MonadIO m, IsSimpleIOStream o) => o -> m (Maybe Gio.InputStream.InputStream)
getSimpleIOStreamInputStream obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "input-stream" Gio.InputStream.InputStream

-- | Construct a `GValueConstruct` with valid value for the “@input-stream@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSimpleIOStreamInputStream :: (IsSimpleIOStream o, MIO.MonadIO m, Gio.InputStream.IsInputStream a) => a -> m (GValueConstruct o)
constructSimpleIOStreamInputStream val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "input-stream" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data SimpleIOStreamInputStreamPropertyInfo
instance AttrInfo SimpleIOStreamInputStreamPropertyInfo where
    type AttrAllowedOps SimpleIOStreamInputStreamPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SimpleIOStreamInputStreamPropertyInfo = IsSimpleIOStream
    type AttrSetTypeConstraint SimpleIOStreamInputStreamPropertyInfo = Gio.InputStream.IsInputStream
    type AttrTransferTypeConstraint SimpleIOStreamInputStreamPropertyInfo = Gio.InputStream.IsInputStream
    type AttrTransferType SimpleIOStreamInputStreamPropertyInfo = Gio.InputStream.InputStream
    type AttrGetType SimpleIOStreamInputStreamPropertyInfo = (Maybe Gio.InputStream.InputStream)
    type AttrLabel SimpleIOStreamInputStreamPropertyInfo = "input-stream"
    type AttrOrigin SimpleIOStreamInputStreamPropertyInfo = SimpleIOStream
    attrGet = getSimpleIOStreamInputStream
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.InputStream.InputStream v
    attrConstruct = constructSimpleIOStreamInputStream
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleIOStream.inputStream"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleIOStream.html#g:attr:inputStream"
        })
#endif

-- VVV Prop "output-stream"
   -- Type: TInterface (Name {namespace = "Gio", name = "OutputStream"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@output-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' simpleIOStream #outputStream
-- @
getSimpleIOStreamOutputStream :: (MonadIO m, IsSimpleIOStream o) => o -> m (Maybe Gio.OutputStream.OutputStream)
getSimpleIOStreamOutputStream obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "output-stream" Gio.OutputStream.OutputStream

-- | Construct a `GValueConstruct` with valid value for the “@output-stream@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSimpleIOStreamOutputStream :: (IsSimpleIOStream o, MIO.MonadIO m, Gio.OutputStream.IsOutputStream a) => a -> m (GValueConstruct o)
constructSimpleIOStreamOutputStream val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "output-stream" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data SimpleIOStreamOutputStreamPropertyInfo
instance AttrInfo SimpleIOStreamOutputStreamPropertyInfo where
    type AttrAllowedOps SimpleIOStreamOutputStreamPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SimpleIOStreamOutputStreamPropertyInfo = IsSimpleIOStream
    type AttrSetTypeConstraint SimpleIOStreamOutputStreamPropertyInfo = Gio.OutputStream.IsOutputStream
    type AttrTransferTypeConstraint SimpleIOStreamOutputStreamPropertyInfo = Gio.OutputStream.IsOutputStream
    type AttrTransferType SimpleIOStreamOutputStreamPropertyInfo = Gio.OutputStream.OutputStream
    type AttrGetType SimpleIOStreamOutputStreamPropertyInfo = (Maybe Gio.OutputStream.OutputStream)
    type AttrLabel SimpleIOStreamOutputStreamPropertyInfo = "output-stream"
    type AttrOrigin SimpleIOStreamOutputStreamPropertyInfo = SimpleIOStream
    attrGet = getSimpleIOStreamOutputStream
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.OutputStream.OutputStream v
    attrConstruct = constructSimpleIOStreamOutputStream
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleIOStream.outputStream"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleIOStream.html#g:attr:outputStream"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SimpleIOStream
type instance O.AttributeList SimpleIOStream = SimpleIOStreamAttributeList
type SimpleIOStreamAttributeList = ('[ '("closed", Gio.IOStream.IOStreamClosedPropertyInfo), '("inputStream", SimpleIOStreamInputStreamPropertyInfo), '("outputStream", SimpleIOStreamOutputStreamPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
simpleIOStreamInputStream :: AttrLabelProxy "inputStream"
simpleIOStreamInputStream = AttrLabelProxy

simpleIOStreamOutputStream :: AttrLabelProxy "outputStream"
simpleIOStreamOutputStream = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SimpleIOStream = SimpleIOStreamSignalList
type SimpleIOStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SimpleIOStream::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "input_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "output_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "OutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOutputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SimpleIOStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_io_stream_new" g_simple_io_stream_new :: 
    Ptr Gio.InputStream.InputStream ->      -- input_stream : TInterface (Name {namespace = "Gio", name = "InputStream"})
    Ptr Gio.OutputStream.OutputStream ->    -- output_stream : TInterface (Name {namespace = "Gio", name = "OutputStream"})
    IO (Ptr SimpleIOStream)

-- | Creates a new t'GI.Gio.Objects.SimpleIOStream.SimpleIOStream' wrapping /@inputStream@/ and /@outputStream@/.
-- See also t'GI.Gio.Objects.IOStream.IOStream'.
-- 
-- /Since: 2.44/
simpleIOStreamNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.OutputStream.IsOutputStream b) =>
    a
    -- ^ /@inputStream@/: a t'GI.Gio.Objects.InputStream.InputStream'.
    -> b
    -- ^ /@outputStream@/: a t'GI.Gio.Objects.OutputStream.OutputStream'.
    -> m SimpleIOStream
    -- ^ __Returns:__ a new t'GI.Gio.Objects.SimpleIOStream.SimpleIOStream' instance.
simpleIOStreamNew inputStream outputStream = liftIO $ do
    inputStream' <- unsafeManagedPtrCastPtr inputStream
    outputStream' <- unsafeManagedPtrCastPtr outputStream
    result <- g_simple_io_stream_new inputStream' outputStream'
    checkUnexpectedReturnNULL "simpleIOStreamNew" result
    result' <- (wrapObject SimpleIOStream) result
    touchManagedPtr inputStream
    touchManagedPtr outputStream
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


