{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- As of GLib 2.46, @GSimpleAsyncResult@ is deprecated in favor of
-- t'GI.Gio.Objects.Task.Task', which provides a simpler API.
-- 
-- @GSimpleAsyncResult@ implements t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
-- 
-- @GSimpleAsyncResult@ handles [type/@gio@/.AsyncReadyCallback]s, error
-- reporting, operation cancellation and the final state of an operation,
-- completely transparent to the application. Results can be returned
-- as a pointer e.g. for functions that return data that is collected
-- asynchronously, a boolean value for checking the success or failure
-- of an operation, or a @gssize@ for operations which return the number
-- of bytes modified by the operation; all of the simple return cases
-- are covered.
-- 
-- Most of the time, an application will not need to know of the details
-- of this API; it is handled transparently, and any necessary operations
-- are handled by t'GI.Gio.Interfaces.AsyncResult.AsyncResult'’s interface. However, if implementing
-- a new GIO module, for writing language bindings, or for complex
-- applications that need better control of how asynchronous operations
-- are completed, it is important to understand this functionality.
-- 
-- @GSimpleAsyncResult@s are tagged with the calling function to ensure
-- that asynchronous functions and their finishing functions are used
-- together correctly.
-- 
-- To create a new @GSimpleAsyncResult@, call 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultNew'.
-- If the result needs to be created for a @GError@, use
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultNewFromError' or
-- t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.@/new_take_error/@(). If a @GError@ is not available
-- (e.g. the asynchronous operation doesn’t take a @GError@ argument),
-- but the result still needs to be created for an error condition, use
-- t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.@/new_error/@() (or
-- t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.@/set_error_va/@() if your application or binding
-- requires passing a variable argument list directly), and the error can then
-- be propagated through the use of
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultPropagateError'.
-- 
-- An asynchronous operation can be made to ignore a cancellation event by
-- calling 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetHandleCancellation' with a
-- @GSimpleAsyncResult@ for the operation and @FALSE@. This is useful for
-- operations that are dangerous to cancel, such as close (which would
-- cause a leak if cancelled before being run).
-- 
-- @GSimpleAsyncResult@ can integrate into GLib’s event loop,
-- [type/@gLib@/.MainLoop], or it can use [type/@gLib@/.Thread]s.
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultComplete' will finish an I\/O task directly
-- from the point where it is called.
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultCompleteInIdle' will finish it from an idle
-- handler in the  thread-default main context (see
-- 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault') where the @GSimpleAsyncResult@
-- was created. t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.@/run_in_thread/@() will run the job in
-- a separate thread and then use
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultCompleteInIdle' to deliver the result.
-- 
-- To set the results of an asynchronous function,
-- t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.@/set_op_res_gpointer/@(),
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetOpResGboolean', and
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetOpResGssize'
-- are provided, setting the operation\'s result to a @gpointer@, @gboolean@, or
-- @gssize@, respectively.
-- 
-- Likewise, to get the result of an asynchronous function,
-- t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.@/get_op_res_gpointer/@(),
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultGetOpResGboolean', and
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultGetOpResGssize' are
-- provided, getting the operation’s result as a @gpointer@, @gboolean@, and
-- @gssize@, respectively.
-- 
-- For the details of the requirements implementations must respect, see
-- t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.  A typical implementation of an asynchronous
-- operation using @GSimpleAsyncResult@ looks something like this:
-- 
-- 
-- === /c code/
-- >static void
-- >baked_cb (Cake    *cake,
-- >          gpointer user_data)
-- >{
-- >  // In this example, this callback is not given a reference to the cake,
-- >  // so the GSimpleAsyncResult has to take a reference to it.
-- >  GSimpleAsyncResult *result = user_data;
-- >
-- >  if (cake == NULL)
-- >    g_simple_async_result_set_error (result,
-- >                                     BAKER_ERRORS,
-- >                                     BAKER_ERROR_NO_FLOUR,
-- >                                     "Go to the supermarket");
-- >  else
-- >    g_simple_async_result_set_op_res_gpointer (result,
-- >                                               g_object_ref (cake),
-- >                                               g_object_unref);
-- >
-- >
-- >  // In this example, we assume that baked_cb is called as a callback from
-- >  // the mainloop, so it's safe to complete the operation synchronously here.
-- >  // If, however, _baker_prepare_cake () might call its callback without
-- >  // first returning to the mainloop — inadvisable, but some APIs do so —
-- >  // we would need to use g_simple_async_result_complete_in_idle().
-- >  g_simple_async_result_complete (result);
-- >  g_object_unref (result);
-- >}
-- >
-- >void
-- >baker_bake_cake_async (Baker              *self,
-- >                       guint               radius,
-- >                       GAsyncReadyCallback callback,
-- >                       gpointer            user_data)
-- >{
-- >  GSimpleAsyncResult *simple;
-- >  Cake               *cake;
-- >
-- >  if (radius < 3)
-- >    {
-- >      g_simple_async_report_error_in_idle (G_OBJECT (self),
-- >                                           callback,
-- >                                           user_data,
-- >                                           BAKER_ERRORS,
-- >                                           BAKER_ERROR_TOO_SMALL,
-- >                                           "%ucm radius cakes are silly",
-- >                                           radius);
-- >      return;
-- >    }
-- >
-- >  simple = g_simple_async_result_new (G_OBJECT (self),
-- >                                      callback,
-- >                                      user_data,
-- >                                      baker_bake_cake_async);
-- >  cake = _baker_get_cached_cake (self, radius);
-- >
-- >  if (cake != NULL)
-- >    {
-- >      g_simple_async_result_set_op_res_gpointer (simple,
-- >                                                 g_object_ref (cake),
-- >                                                 g_object_unref);
-- >      g_simple_async_result_complete_in_idle (simple);
-- >      g_object_unref (simple);
-- >      // Drop the reference returned by _baker_get_cached_cake();
-- >      // the GSimpleAsyncResult has taken its own reference.
-- >      g_object_unref (cake);
-- >      return;
-- >    }
-- >
-- >  _baker_prepare_cake (self, radius, baked_cb, simple);
-- >}
-- >
-- >Cake *
-- >baker_bake_cake_finish (Baker        *self,
-- >                        GAsyncResult *result,
-- >                        GError      **error)
-- >{
-- >  GSimpleAsyncResult *simple;
-- >  Cake               *cake;
-- >
-- >  g_return_val_if_fail (g_simple_async_result_is_valid (result,
-- >                                                        G_OBJECT (self),
-- >                                                        baker_bake_cake_async),
-- >                        NULL);
-- >
-- >  simple = (GSimpleAsyncResult *) result;
-- >
-- >  if (g_simple_async_result_propagate_error (simple, error))
-- >    return NULL;
-- >
-- >  cake = CAKE (g_simple_async_result_get_op_res_gpointer (simple));
-- >  return g_object_ref (cake);
-- >}
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SimpleAsyncResult
    ( 

-- * Exported types
    SimpleAsyncResult(..)                   ,
    IsSimpleAsyncResult                     ,
    toSimpleAsyncResult                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [complete]("GI.Gio.Objects.SimpleAsyncResult#g:method:complete"), [completeInIdle]("GI.Gio.Objects.SimpleAsyncResult#g:method:completeInIdle"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isTagged]("GI.Gio.Interfaces.AsyncResult#g:method:isTagged"), [legacyPropagateError]("GI.Gio.Interfaces.AsyncResult#g:method:legacyPropagateError"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [propagateError]("GI.Gio.Objects.SimpleAsyncResult#g:method:propagateError"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getOpResGboolean]("GI.Gio.Objects.SimpleAsyncResult#g:method:getOpResGboolean"), [getOpResGssize]("GI.Gio.Objects.SimpleAsyncResult#g:method:getOpResGssize"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSourceObject]("GI.Gio.Interfaces.AsyncResult#g:method:getSourceObject"), [getUserData]("GI.Gio.Interfaces.AsyncResult#g:method:getUserData").
-- 
-- ==== Setters
-- [setCheckCancellable]("GI.Gio.Objects.SimpleAsyncResult#g:method:setCheckCancellable"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFromError]("GI.Gio.Objects.SimpleAsyncResult#g:method:setFromError"), [setHandleCancellation]("GI.Gio.Objects.SimpleAsyncResult#g:method:setHandleCancellation"), [setOpResGboolean]("GI.Gio.Objects.SimpleAsyncResult#g:method:setOpResGboolean"), [setOpResGssize]("GI.Gio.Objects.SimpleAsyncResult#g:method:setOpResGssize"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSimpleAsyncResultMethod          ,
#endif

-- ** complete #method:complete#

#if defined(ENABLE_OVERLOADING)
    SimpleAsyncResultCompleteMethodInfo     ,
#endif
    simpleAsyncResultComplete               ,


-- ** completeInIdle #method:completeInIdle#

#if defined(ENABLE_OVERLOADING)
    SimpleAsyncResultCompleteInIdleMethodInfo,
#endif
    simpleAsyncResultCompleteInIdle         ,


-- ** getOpResGboolean #method:getOpResGboolean#

#if defined(ENABLE_OVERLOADING)
    SimpleAsyncResultGetOpResGbooleanMethodInfo,
#endif
    simpleAsyncResultGetOpResGboolean       ,


-- ** getOpResGssize #method:getOpResGssize#

#if defined(ENABLE_OVERLOADING)
    SimpleAsyncResultGetOpResGssizeMethodInfo,
#endif
    simpleAsyncResultGetOpResGssize         ,


-- ** isValid #method:isValid#

    simpleAsyncResultIsValid                ,


-- ** new #method:new#

    simpleAsyncResultNew                    ,


-- ** newFromError #method:newFromError#

    simpleAsyncResultNewFromError           ,


-- ** propagateError #method:propagateError#

#if defined(ENABLE_OVERLOADING)
    SimpleAsyncResultPropagateErrorMethodInfo,
#endif
    simpleAsyncResultPropagateError         ,


-- ** setCheckCancellable #method:setCheckCancellable#

#if defined(ENABLE_OVERLOADING)
    SimpleAsyncResultSetCheckCancellableMethodInfo,
#endif
    simpleAsyncResultSetCheckCancellable    ,


-- ** setFromError #method:setFromError#

#if defined(ENABLE_OVERLOADING)
    SimpleAsyncResultSetFromErrorMethodInfo ,
#endif
    simpleAsyncResultSetFromError           ,


-- ** setHandleCancellation #method:setHandleCancellation#

#if defined(ENABLE_OVERLOADING)
    SimpleAsyncResultSetHandleCancellationMethodInfo,
#endif
    simpleAsyncResultSetHandleCancellation  ,


-- ** setOpResGboolean #method:setOpResGboolean#

#if defined(ENABLE_OVERLOADING)
    SimpleAsyncResultSetOpResGbooleanMethodInfo,
#endif
    simpleAsyncResultSetOpResGboolean       ,


-- ** setOpResGssize #method:setOpResGssize#

#if defined(ENABLE_OVERLOADING)
    SimpleAsyncResultSetOpResGssizeMethodInfo,
#endif
    simpleAsyncResultSetOpResGssize         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable

#endif

-- | Memory-managed wrapper type.
newtype SimpleAsyncResult = SimpleAsyncResult (SP.ManagedPtr SimpleAsyncResult)
    deriving (Eq)

instance SP.ManagedPtrNewtype SimpleAsyncResult where
    toManagedPtr (SimpleAsyncResult p) = p

foreign import ccall "g_simple_async_result_get_type"
    c_g_simple_async_result_get_type :: IO B.Types.GType

instance B.Types.TypedObject SimpleAsyncResult where
    glibType = c_g_simple_async_result_get_type

instance B.Types.GObject SimpleAsyncResult

-- | Type class for types which can be safely cast to `SimpleAsyncResult`, for instance with `toSimpleAsyncResult`.
class (SP.GObject o, O.IsDescendantOf SimpleAsyncResult o) => IsSimpleAsyncResult o
instance (SP.GObject o, O.IsDescendantOf SimpleAsyncResult o) => IsSimpleAsyncResult o

instance O.HasParentTypes SimpleAsyncResult
type instance O.ParentTypes SimpleAsyncResult = '[GObject.Object.Object, Gio.AsyncResult.AsyncResult]

-- | Cast to `SimpleAsyncResult`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSimpleAsyncResult :: (MIO.MonadIO m, IsSimpleAsyncResult o) => o -> m SimpleAsyncResult
toSimpleAsyncResult = MIO.liftIO . B.ManagedPtr.unsafeCastTo SimpleAsyncResult

-- | Convert 'SimpleAsyncResult' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SimpleAsyncResult) where
    gvalueGType_ = c_g_simple_async_result_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SimpleAsyncResult)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SimpleAsyncResult)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SimpleAsyncResult ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSimpleAsyncResultMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSimpleAsyncResultMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSimpleAsyncResultMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSimpleAsyncResultMethod "complete" o = SimpleAsyncResultCompleteMethodInfo
    ResolveSimpleAsyncResultMethod "completeInIdle" o = SimpleAsyncResultCompleteInIdleMethodInfo
    ResolveSimpleAsyncResultMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSimpleAsyncResultMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSimpleAsyncResultMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSimpleAsyncResultMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSimpleAsyncResultMethod "isTagged" o = Gio.AsyncResult.AsyncResultIsTaggedMethodInfo
    ResolveSimpleAsyncResultMethod "legacyPropagateError" o = Gio.AsyncResult.AsyncResultLegacyPropagateErrorMethodInfo
    ResolveSimpleAsyncResultMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSimpleAsyncResultMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSimpleAsyncResultMethod "propagateError" o = SimpleAsyncResultPropagateErrorMethodInfo
    ResolveSimpleAsyncResultMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSimpleAsyncResultMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSimpleAsyncResultMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSimpleAsyncResultMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSimpleAsyncResultMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSimpleAsyncResultMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSimpleAsyncResultMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSimpleAsyncResultMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSimpleAsyncResultMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSimpleAsyncResultMethod "getOpResGboolean" o = SimpleAsyncResultGetOpResGbooleanMethodInfo
    ResolveSimpleAsyncResultMethod "getOpResGssize" o = SimpleAsyncResultGetOpResGssizeMethodInfo
    ResolveSimpleAsyncResultMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSimpleAsyncResultMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSimpleAsyncResultMethod "getSourceObject" o = Gio.AsyncResult.AsyncResultGetSourceObjectMethodInfo
    ResolveSimpleAsyncResultMethod "getUserData" o = Gio.AsyncResult.AsyncResultGetUserDataMethodInfo
    ResolveSimpleAsyncResultMethod "setCheckCancellable" o = SimpleAsyncResultSetCheckCancellableMethodInfo
    ResolveSimpleAsyncResultMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSimpleAsyncResultMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSimpleAsyncResultMethod "setFromError" o = SimpleAsyncResultSetFromErrorMethodInfo
    ResolveSimpleAsyncResultMethod "setHandleCancellation" o = SimpleAsyncResultSetHandleCancellationMethodInfo
    ResolveSimpleAsyncResultMethod "setOpResGboolean" o = SimpleAsyncResultSetOpResGbooleanMethodInfo
    ResolveSimpleAsyncResultMethod "setOpResGssize" o = SimpleAsyncResultSetOpResGssizeMethodInfo
    ResolveSimpleAsyncResultMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSimpleAsyncResultMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSimpleAsyncResultMethod t SimpleAsyncResult, O.OverloadedMethod info SimpleAsyncResult p) => OL.IsLabel t (SimpleAsyncResult -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSimpleAsyncResultMethod t SimpleAsyncResult, O.OverloadedMethod info SimpleAsyncResult p, R.HasField t SimpleAsyncResult p) => R.HasField t SimpleAsyncResult p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSimpleAsyncResultMethod t SimpleAsyncResult, O.OverloadedMethodInfo info SimpleAsyncResult) => OL.IsLabel t (O.MethodProxy info SimpleAsyncResult) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SimpleAsyncResult
type instance O.AttributeList SimpleAsyncResult = SimpleAsyncResultAttributeList
type SimpleAsyncResultAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SimpleAsyncResult = SimpleAsyncResultSignalList
type SimpleAsyncResultSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SimpleAsyncResult::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObject, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_tag"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the asynchronous function."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "SimpleAsyncResult" })
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_new" g_simple_async_result_new :: 
    Ptr GObject.Object.Object ->            -- source_object : TInterface (Name {namespace = "GObject", name = "Object"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    Ptr () ->                               -- source_tag : TBasicType TPtr
    IO (Ptr SimpleAsyncResult)

{-# DEPRECATED simpleAsyncResultNew ["(Since version 2.46)","Use 'GI.Gio.Objects.Task.taskNew' instead."] #-}
-- | Creates a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
-- 
-- The common convention is to create the t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult' in the
-- function that starts the asynchronous operation and use that same
-- function as the /@sourceTag@/.
-- 
-- If your operation supports cancellation with t'GI.Gio.Objects.Cancellable.Cancellable' (which it
-- probably should) then you should provide the user\'s cancellable to
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetCheckCancellable' immediately after
-- this function returns.
simpleAsyncResultNew ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    Maybe (a)
    -- ^ /@sourceObject@/: a t'GI.GObject.Objects.Object.Object', or 'P.Nothing'.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'.
    -> Ptr ()
    -- ^ /@sourceTag@/: the asynchronous function.
    -> m SimpleAsyncResult
    -- ^ __Returns:__ a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
simpleAsyncResultNew sourceObject callback sourceTag = liftIO $ do
    maybeSourceObject <- case sourceObject of
        Nothing -> return FP.nullPtr
        Just jSourceObject -> do
            jSourceObject' <- unsafeManagedPtrCastPtr jSourceObject
            return jSourceObject'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    result <- g_simple_async_result_new maybeSourceObject maybeCallback userData sourceTag
    checkUnexpectedReturnNULL "simpleAsyncResultNew" result
    result' <- (wrapObject SimpleAsyncResult) result
    whenJust sourceObject touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SimpleAsyncResult::new_from_error
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObject, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GError" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "SimpleAsyncResult" })
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_new_from_error" g_simple_async_result_new_from_error :: 
    Ptr GObject.Object.Object ->            -- source_object : TInterface (Name {namespace = "GObject", name = "Object"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    Ptr GError ->                           -- error : TError
    IO (Ptr SimpleAsyncResult)

{-# DEPRECATED simpleAsyncResultNewFromError ["(Since version 2.46)","Use 'GI.Gio.Objects.Task.taskNew' and 'GI.Gio.Objects.Task.taskReturnError' instead."] #-}
-- | Creates a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult' from an error condition.
simpleAsyncResultNewFromError ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    Maybe (a)
    -- ^ /@sourceObject@/: a t'GI.GObject.Objects.Object.Object', or 'P.Nothing'.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'.
    -> GError
    -- ^ /@error@/: a t'GError'
    -> m SimpleAsyncResult
    -- ^ __Returns:__ a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
simpleAsyncResultNewFromError sourceObject callback error_ = liftIO $ do
    maybeSourceObject <- case sourceObject of
        Nothing -> return FP.nullPtr
        Just jSourceObject -> do
            jSourceObject' <- unsafeManagedPtrCastPtr jSourceObject
            return jSourceObject'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    error_' <- unsafeManagedPtrGetPtr error_
    let userData = nullPtr
    result <- g_simple_async_result_new_from_error maybeSourceObject maybeCallback userData error_'
    checkUnexpectedReturnNULL "simpleAsyncResultNewFromError" result
    result' <- (wrapObject SimpleAsyncResult) result
    whenJust sourceObject touchManagedPtr
    touchManagedPtr error_
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SimpleAsyncResult::complete
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_complete" g_simple_async_result_complete :: 
    Ptr SimpleAsyncResult ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAsyncResult"})
    IO ()

{-# DEPRECATED simpleAsyncResultComplete ["(Since version 2.46)","Use t'GI.Gio.Objects.Task.Task' instead."] #-}
-- | Completes an asynchronous I\/O job immediately. Must be called in
-- the thread where the asynchronous result was to be delivered, as it
-- invokes the callback directly. If you are in a different thread use
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultCompleteInIdle'.
-- 
-- Calling this function takes a reference to /@simple@/ for as long as
-- is needed to complete the call.
simpleAsyncResultComplete ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAsyncResult a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> m ()
simpleAsyncResultComplete simple = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    g_simple_async_result_complete simple'
    touchManagedPtr simple
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleAsyncResultCompleteMethodInfo
instance (signature ~ (m ()), MonadIO m, IsSimpleAsyncResult a) => O.OverloadedMethod SimpleAsyncResultCompleteMethodInfo a signature where
    overloadedMethod = simpleAsyncResultComplete

instance O.OverloadedMethodInfo SimpleAsyncResultCompleteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultComplete",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleAsyncResult.html#v:simpleAsyncResultComplete"
        })


#endif

-- method SimpleAsyncResult::complete_in_idle
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_complete_in_idle" g_simple_async_result_complete_in_idle :: 
    Ptr SimpleAsyncResult ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAsyncResult"})
    IO ()

{-# DEPRECATED simpleAsyncResultCompleteInIdle ["(Since version 2.46)","Use t'GI.Gio.Objects.Task.Task' instead."] #-}
-- | Completes an asynchronous function in an idle handler in the
-- thread-default main context (see 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault')
-- of the thread that /@simple@/ was initially created in
-- (and re-pushes that context around the invocation of the callback).
-- 
-- Calling this function takes a reference to /@simple@/ for as long as
-- is needed to complete the call.
simpleAsyncResultCompleteInIdle ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAsyncResult a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> m ()
simpleAsyncResultCompleteInIdle simple = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    g_simple_async_result_complete_in_idle simple'
    touchManagedPtr simple
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleAsyncResultCompleteInIdleMethodInfo
instance (signature ~ (m ()), MonadIO m, IsSimpleAsyncResult a) => O.OverloadedMethod SimpleAsyncResultCompleteInIdleMethodInfo a signature where
    overloadedMethod = simpleAsyncResultCompleteInIdle

instance O.OverloadedMethodInfo SimpleAsyncResultCompleteInIdleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultCompleteInIdle",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleAsyncResult.html#v:simpleAsyncResultCompleteInIdle"
        })


#endif

-- method SimpleAsyncResult::get_op_res_gboolean
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_get_op_res_gboolean" g_simple_async_result_get_op_res_gboolean :: 
    Ptr SimpleAsyncResult ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAsyncResult"})
    IO CInt

{-# DEPRECATED simpleAsyncResultGetOpResGboolean ["(Since version 2.46)","Use t'GI.Gio.Objects.Task.Task' and 'GI.Gio.Objects.Task.taskPropagateBoolean' instead."] #-}
-- | Gets the operation result boolean from within the asynchronous result.
simpleAsyncResultGetOpResGboolean ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAsyncResult a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the operation\'s result was 'P.True', 'P.False'
    --     if the operation\'s result was 'P.False'.
simpleAsyncResultGetOpResGboolean simple = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    result <- g_simple_async_result_get_op_res_gboolean simple'
    let result' = (/= 0) result
    touchManagedPtr simple
    return result'

#if defined(ENABLE_OVERLOADING)
data SimpleAsyncResultGetOpResGbooleanMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSimpleAsyncResult a) => O.OverloadedMethod SimpleAsyncResultGetOpResGbooleanMethodInfo a signature where
    overloadedMethod = simpleAsyncResultGetOpResGboolean

instance O.OverloadedMethodInfo SimpleAsyncResultGetOpResGbooleanMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultGetOpResGboolean",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleAsyncResult.html#v:simpleAsyncResultGetOpResGboolean"
        })


#endif

-- method SimpleAsyncResult::get_op_res_gssize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_get_op_res_gssize" g_simple_async_result_get_op_res_gssize :: 
    Ptr SimpleAsyncResult ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAsyncResult"})
    IO DI.Int64

{-# DEPRECATED simpleAsyncResultGetOpResGssize ["(Since version 2.46)","Use t'GI.Gio.Objects.Task.Task' and 'GI.Gio.Objects.Task.taskPropagateInt' instead."] #-}
-- | Gets a gssize from the asynchronous result.
simpleAsyncResultGetOpResGssize ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAsyncResult a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> m DI.Int64
    -- ^ __Returns:__ a gssize returned from the asynchronous function.
simpleAsyncResultGetOpResGssize simple = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    result <- g_simple_async_result_get_op_res_gssize simple'
    touchManagedPtr simple
    return result

#if defined(ENABLE_OVERLOADING)
data SimpleAsyncResultGetOpResGssizeMethodInfo
instance (signature ~ (m DI.Int64), MonadIO m, IsSimpleAsyncResult a) => O.OverloadedMethod SimpleAsyncResultGetOpResGssizeMethodInfo a signature where
    overloadedMethod = simpleAsyncResultGetOpResGssize

instance O.OverloadedMethodInfo SimpleAsyncResultGetOpResGssizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultGetOpResGssize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleAsyncResult.html#v:simpleAsyncResultGetOpResGssize"
        })


#endif

-- method SimpleAsyncResult::propagate_error
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_simple_async_result_propagate_error" g_simple_async_result_propagate_error :: 
    Ptr SimpleAsyncResult ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

{-# DEPRECATED simpleAsyncResultPropagateError ["(Since version 2.46)","Use t'GI.Gio.Objects.Task.Task' instead."] #-}
-- | Propagates an error from within the simple asynchronous result to
-- a given destination.
-- 
-- If the t'GI.Gio.Objects.Cancellable.Cancellable' given to a prior call to
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetCheckCancellable' is cancelled then this
-- function will return 'P.True' with /@dest@/ set appropriately.
simpleAsyncResultPropagateError ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAsyncResult a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
simpleAsyncResultPropagateError simple = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    onException (do
        _ <- propagateGError $ g_simple_async_result_propagate_error simple'
        touchManagedPtr simple
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SimpleAsyncResultPropagateErrorMethodInfo
instance (signature ~ (m ()), MonadIO m, IsSimpleAsyncResult a) => O.OverloadedMethod SimpleAsyncResultPropagateErrorMethodInfo a signature where
    overloadedMethod = simpleAsyncResultPropagateError

instance O.OverloadedMethodInfo SimpleAsyncResultPropagateErrorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultPropagateError",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleAsyncResult.html#v:simpleAsyncResultPropagateError"
        })


#endif

-- method SimpleAsyncResult::set_check_cancellable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "check_cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable to check, or %NULL to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_set_check_cancellable" g_simple_async_result_set_check_cancellable :: 
    Ptr SimpleAsyncResult ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAsyncResult"})
    Ptr Gio.Cancellable.Cancellable ->      -- check_cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    IO ()

{-# DEPRECATED simpleAsyncResultSetCheckCancellable ["(Since version 2.46)","Use t'GI.Gio.Objects.Task.Task' instead."] #-}
-- | Sets a t'GI.Gio.Objects.Cancellable.Cancellable' to check before dispatching results.
-- 
-- This function has one very specific purpose: the provided cancellable
-- is checked at the time of 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultPropagateError' If
-- it is cancelled, these functions will return an \"Operation was
-- cancelled\" error ('GI.Gio.Enums.IOErrorEnumCancelled').
-- 
-- Implementors of cancellable asynchronous functions should use this in
-- order to provide a guarantee to their callers that cancelling an
-- async operation will reliably result in an error being returned for
-- that operation (even if a positive result for the operation has
-- already been sent as an idle to the main context to be dispatched).
-- 
-- The checking described above is done regardless of any call to the
-- unrelated 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetHandleCancellation' function.
-- 
-- /Since: 2.32/
simpleAsyncResultSetCheckCancellable ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAsyncResult a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'
    -> Maybe (b)
    -- ^ /@checkCancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable' to check, or 'P.Nothing' to unset
    -> m ()
simpleAsyncResultSetCheckCancellable simple checkCancellable = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    maybeCheckCancellable <- case checkCancellable of
        Nothing -> return FP.nullPtr
        Just jCheckCancellable -> do
            jCheckCancellable' <- unsafeManagedPtrCastPtr jCheckCancellable
            return jCheckCancellable'
    g_simple_async_result_set_check_cancellable simple' maybeCheckCancellable
    touchManagedPtr simple
    whenJust checkCancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleAsyncResultSetCheckCancellableMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsSimpleAsyncResult a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod SimpleAsyncResultSetCheckCancellableMethodInfo a signature where
    overloadedMethod = simpleAsyncResultSetCheckCancellable

instance O.OverloadedMethodInfo SimpleAsyncResultSetCheckCancellableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetCheckCancellable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleAsyncResult.html#v:simpleAsyncResultSetCheckCancellable"
        })


#endif

-- method SimpleAsyncResult::set_from_error
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GError." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_set_from_error" g_simple_async_result_set_from_error :: 
    Ptr SimpleAsyncResult ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAsyncResult"})
    Ptr GError ->                           -- error : TError
    IO ()

{-# DEPRECATED simpleAsyncResultSetFromError ["(Since version 2.46)","Use t'GI.Gio.Objects.Task.Task' and 'GI.Gio.Objects.Task.taskReturnError' instead."] #-}
-- | Sets the result from a t'GError'.
simpleAsyncResultSetFromError ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAsyncResult a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> GError
    -- ^ /@error@/: t'GError'.
    -> m ()
simpleAsyncResultSetFromError simple error_ = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    error_' <- unsafeManagedPtrGetPtr error_
    g_simple_async_result_set_from_error simple' error_'
    touchManagedPtr simple
    touchManagedPtr error_
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleAsyncResultSetFromErrorMethodInfo
instance (signature ~ (GError -> m ()), MonadIO m, IsSimpleAsyncResult a) => O.OverloadedMethod SimpleAsyncResultSetFromErrorMethodInfo a signature where
    overloadedMethod = simpleAsyncResultSetFromError

instance O.OverloadedMethodInfo SimpleAsyncResultSetFromErrorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetFromError",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleAsyncResult.html#v:simpleAsyncResultSetFromError"
        })


#endif

-- method SimpleAsyncResult::set_handle_cancellation
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "handle_cancellation"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gboolean." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_set_handle_cancellation" g_simple_async_result_set_handle_cancellation :: 
    Ptr SimpleAsyncResult ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAsyncResult"})
    CInt ->                                 -- handle_cancellation : TBasicType TBoolean
    IO ()

{-# DEPRECATED simpleAsyncResultSetHandleCancellation ["(Since version 2.46)"] #-}
-- | Sets whether to handle cancellation within the asynchronous operation.
-- 
-- This function has nothing to do with
-- 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetCheckCancellable'.  It only refers to the
-- t'GI.Gio.Objects.Cancellable.Cancellable' passed to @/g_simple_async_result_run_in_thread()/@.
simpleAsyncResultSetHandleCancellation ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAsyncResult a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> Bool
    -- ^ /@handleCancellation@/: a t'P.Bool'.
    -> m ()
simpleAsyncResultSetHandleCancellation simple handleCancellation = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    let handleCancellation' = (P.fromIntegral . P.fromEnum) handleCancellation
    g_simple_async_result_set_handle_cancellation simple' handleCancellation'
    touchManagedPtr simple
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleAsyncResultSetHandleCancellationMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSimpleAsyncResult a) => O.OverloadedMethod SimpleAsyncResultSetHandleCancellationMethodInfo a signature where
    overloadedMethod = simpleAsyncResultSetHandleCancellation

instance O.OverloadedMethodInfo SimpleAsyncResultSetHandleCancellationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetHandleCancellation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleAsyncResult.html#v:simpleAsyncResultSetHandleCancellation"
        })


#endif

-- method SimpleAsyncResult::set_op_res_gboolean
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "op_res"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gboolean." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_set_op_res_gboolean" g_simple_async_result_set_op_res_gboolean :: 
    Ptr SimpleAsyncResult ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAsyncResult"})
    CInt ->                                 -- op_res : TBasicType TBoolean
    IO ()

{-# DEPRECATED simpleAsyncResultSetOpResGboolean ["(Since version 2.46)","Use t'GI.Gio.Objects.Task.Task' and 'GI.Gio.Objects.Task.taskReturnBoolean' instead."] #-}
-- | Sets the operation result to a boolean within the asynchronous result.
simpleAsyncResultSetOpResGboolean ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAsyncResult a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> Bool
    -- ^ /@opRes@/: a t'P.Bool'.
    -> m ()
simpleAsyncResultSetOpResGboolean simple opRes = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    let opRes' = (P.fromIntegral . P.fromEnum) opRes
    g_simple_async_result_set_op_res_gboolean simple' opRes'
    touchManagedPtr simple
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleAsyncResultSetOpResGbooleanMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSimpleAsyncResult a) => O.OverloadedMethod SimpleAsyncResultSetOpResGbooleanMethodInfo a signature where
    overloadedMethod = simpleAsyncResultSetOpResGboolean

instance O.OverloadedMethodInfo SimpleAsyncResultSetOpResGbooleanMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetOpResGboolean",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleAsyncResult.html#v:simpleAsyncResultSetOpResGboolean"
        })


#endif

-- method SimpleAsyncResult::set_op_res_gssize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "op_res"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gssize." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_set_op_res_gssize" g_simple_async_result_set_op_res_gssize :: 
    Ptr SimpleAsyncResult ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAsyncResult"})
    DI.Int64 ->                             -- op_res : TBasicType TSSize
    IO ()

{-# DEPRECATED simpleAsyncResultSetOpResGssize ["(Since version 2.46)","Use t'GI.Gio.Objects.Task.Task' and 'GI.Gio.Objects.Task.taskReturnInt' instead."] #-}
-- | Sets the operation result within the asynchronous result to
-- the given /@opRes@/.
simpleAsyncResultSetOpResGssize ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAsyncResult a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> DI.Int64
    -- ^ /@opRes@/: a @/gssize/@.
    -> m ()
simpleAsyncResultSetOpResGssize simple opRes = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    g_simple_async_result_set_op_res_gssize simple' opRes
    touchManagedPtr simple
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleAsyncResultSetOpResGssizeMethodInfo
instance (signature ~ (DI.Int64 -> m ()), MonadIO m, IsSimpleAsyncResult a) => O.OverloadedMethod SimpleAsyncResultSetOpResGssizeMethodInfo a signature where
    overloadedMethod = simpleAsyncResultSetOpResGssize

instance O.OverloadedMethodInfo SimpleAsyncResultSetOpResGssizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultSetOpResGssize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleAsyncResult.html#v:simpleAsyncResultSetOpResGssize"
        })


#endif

-- method SimpleAsyncResult::is_valid
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GAsyncResult passed to the _finish function."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GObject passed to the _finish function."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_tag"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the asynchronous function."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_result_is_valid" g_simple_async_result_is_valid :: 
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr GObject.Object.Object ->            -- source : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr () ->                               -- source_tag : TBasicType TPtr
    IO CInt

{-# DEPRECATED simpleAsyncResultIsValid ["(Since version 2.46)","Use t'GI.Gio.Objects.Task.Task' and 'GI.Gio.Objects.Task.taskIsValid' instead."] #-}
-- | Ensures that the data passed to the _finish function of an async
-- operation is consistent.  Three checks are performed.
-- 
-- First, /@result@/ is checked to ensure that it is really a
-- t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.  Second, /@source@/ is checked to ensure that it
-- matches the source object of /@result@/.  Third, /@sourceTag@/ is
-- checked to ensure that it is equal to the /@sourceTag@/ argument given
-- to 'GI.Gio.Objects.SimpleAsyncResult.simpleAsyncResultNew' (which, by convention, is a pointer
-- to the _async function corresponding to the _finish function from
-- which this function is called).  (Alternatively, if either
-- /@sourceTag@/ or /@result@/\'s source tag is 'P.Nothing', then the source tag
-- check is skipped.)
-- 
-- /Since: 2.20/
simpleAsyncResultIsValid ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AsyncResult.IsAsyncResult a, GObject.Object.IsObject b) =>
    a
    -- ^ /@result@/: the t'GI.Gio.Interfaces.AsyncResult.AsyncResult' passed to the _finish function.
    -> Maybe (b)
    -- ^ /@source@/: the t'GI.GObject.Objects.Object.Object' passed to the _finish function.
    -> Ptr ()
    -- ^ /@sourceTag@/: the asynchronous function.
    -> m Bool
    -- ^ __Returns:__ @/TRUE/@ if all checks passed or @/FALSE/@ if any failed.
simpleAsyncResultIsValid result_ source sourceTag = liftIO $ do
    result_' <- unsafeManagedPtrCastPtr result_
    maybeSource <- case source of
        Nothing -> return FP.nullPtr
        Just jSource -> do
            jSource' <- unsafeManagedPtrCastPtr jSource
            return jSource'
    result <- g_simple_async_result_is_valid result_' maybeSource sourceTag
    let result' = (/= 0) result
    touchManagedPtr result_
    whenJust source touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


