{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GSimpleActionGroup@ is a hash table filled with t'GI.Gio.Interfaces.Action.Action' objects,
-- implementing the t'GI.Gio.Interfaces.ActionGroup.ActionGroup' and t'GI.Gio.Interfaces.ActionMap.ActionMap'
-- interfaces.
-- 
-- /Since: 2.28/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SimpleActionGroup
    ( 

-- * Exported types
    SimpleActionGroup(..)                   ,
    IsSimpleActionGroup                     ,
    toSimpleActionGroup                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionAdded]("GI.Gio.Interfaces.ActionGroup#g:method:actionAdded"), [actionEnabledChanged]("GI.Gio.Interfaces.ActionGroup#g:method:actionEnabledChanged"), [actionRemoved]("GI.Gio.Interfaces.ActionGroup#g:method:actionRemoved"), [actionStateChanged]("GI.Gio.Interfaces.ActionGroup#g:method:actionStateChanged"), [activateAction]("GI.Gio.Interfaces.ActionGroup#g:method:activateAction"), [addAction]("GI.Gio.Interfaces.ActionMap#g:method:addAction"), [addActionEntries]("GI.Gio.Interfaces.ActionMap#g:method:addActionEntries"), [addEntries]("GI.Gio.Objects.SimpleActionGroup#g:method:addEntries"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changeActionState]("GI.Gio.Interfaces.ActionGroup#g:method:changeActionState"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasAction]("GI.Gio.Interfaces.ActionGroup#g:method:hasAction"), [insert]("GI.Gio.Objects.SimpleActionGroup#g:method:insert"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listActions]("GI.Gio.Interfaces.ActionGroup#g:method:listActions"), [lookup]("GI.Gio.Objects.SimpleActionGroup#g:method:lookup"), [lookupAction]("GI.Gio.Interfaces.ActionMap#g:method:lookupAction"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [queryAction]("GI.Gio.Interfaces.ActionGroup#g:method:queryAction"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gio.Objects.SimpleActionGroup#g:method:remove"), [removeAction]("GI.Gio.Interfaces.ActionMap#g:method:removeAction"), [removeActionEntries]("GI.Gio.Interfaces.ActionMap#g:method:removeActionEntries"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActionEnabled]("GI.Gio.Interfaces.ActionGroup#g:method:getActionEnabled"), [getActionParameterType]("GI.Gio.Interfaces.ActionGroup#g:method:getActionParameterType"), [getActionState]("GI.Gio.Interfaces.ActionGroup#g:method:getActionState"), [getActionStateHint]("GI.Gio.Interfaces.ActionGroup#g:method:getActionStateHint"), [getActionStateType]("GI.Gio.Interfaces.ActionGroup#g:method:getActionStateType"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSimpleActionGroupMethod          ,
#endif

-- ** addEntries #method:addEntries#

#if defined(ENABLE_OVERLOADING)
    SimpleActionGroupAddEntriesMethodInfo   ,
#endif
    simpleActionGroupAddEntries             ,


-- ** insert #method:insert#

#if defined(ENABLE_OVERLOADING)
    SimpleActionGroupInsertMethodInfo       ,
#endif
    simpleActionGroupInsert                 ,


-- ** lookup #method:lookup#

#if defined(ENABLE_OVERLOADING)
    SimpleActionGroupLookupMethodInfo       ,
#endif
    simpleActionGroupLookup                 ,


-- ** new #method:new#

    simpleActionGroupNew                    ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    SimpleActionGroupRemoveMethodInfo       ,
#endif
    simpleActionGroupRemove                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Action as Gio.Action
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import {-# SOURCE #-} qualified GI.Gio.Structs.ActionEntry as Gio.ActionEntry

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Action as Gio.Action
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import {-# SOURCE #-} qualified GI.Gio.Structs.ActionEntry as Gio.ActionEntry

#endif

-- | Memory-managed wrapper type.
newtype SimpleActionGroup = SimpleActionGroup (SP.ManagedPtr SimpleActionGroup)
    deriving (Eq)

instance SP.ManagedPtrNewtype SimpleActionGroup where
    toManagedPtr (SimpleActionGroup p) = p

foreign import ccall "g_simple_action_group_get_type"
    c_g_simple_action_group_get_type :: IO B.Types.GType

instance B.Types.TypedObject SimpleActionGroup where
    glibType = c_g_simple_action_group_get_type

instance B.Types.GObject SimpleActionGroup

-- | Type class for types which can be safely cast to `SimpleActionGroup`, for instance with `toSimpleActionGroup`.
class (SP.GObject o, O.IsDescendantOf SimpleActionGroup o) => IsSimpleActionGroup o
instance (SP.GObject o, O.IsDescendantOf SimpleActionGroup o) => IsSimpleActionGroup o

instance O.HasParentTypes SimpleActionGroup
type instance O.ParentTypes SimpleActionGroup = '[GObject.Object.Object, Gio.ActionGroup.ActionGroup, Gio.ActionMap.ActionMap]

-- | Cast to `SimpleActionGroup`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSimpleActionGroup :: (MIO.MonadIO m, IsSimpleActionGroup o) => o -> m SimpleActionGroup
toSimpleActionGroup = MIO.liftIO . B.ManagedPtr.unsafeCastTo SimpleActionGroup

-- | Convert 'SimpleActionGroup' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SimpleActionGroup) where
    gvalueGType_ = c_g_simple_action_group_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SimpleActionGroup)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SimpleActionGroup)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SimpleActionGroup ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSimpleActionGroupMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSimpleActionGroupMethod "actionAdded" o = Gio.ActionGroup.ActionGroupActionAddedMethodInfo
    ResolveSimpleActionGroupMethod "actionEnabledChanged" o = Gio.ActionGroup.ActionGroupActionEnabledChangedMethodInfo
    ResolveSimpleActionGroupMethod "actionRemoved" o = Gio.ActionGroup.ActionGroupActionRemovedMethodInfo
    ResolveSimpleActionGroupMethod "actionStateChanged" o = Gio.ActionGroup.ActionGroupActionStateChangedMethodInfo
    ResolveSimpleActionGroupMethod "activateAction" o = Gio.ActionGroup.ActionGroupActivateActionMethodInfo
    ResolveSimpleActionGroupMethod "addAction" o = Gio.ActionMap.ActionMapAddActionMethodInfo
    ResolveSimpleActionGroupMethod "addActionEntries" o = Gio.ActionMap.ActionMapAddActionEntriesMethodInfo
    ResolveSimpleActionGroupMethod "addEntries" o = SimpleActionGroupAddEntriesMethodInfo
    ResolveSimpleActionGroupMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSimpleActionGroupMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSimpleActionGroupMethod "changeActionState" o = Gio.ActionGroup.ActionGroupChangeActionStateMethodInfo
    ResolveSimpleActionGroupMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSimpleActionGroupMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSimpleActionGroupMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSimpleActionGroupMethod "hasAction" o = Gio.ActionGroup.ActionGroupHasActionMethodInfo
    ResolveSimpleActionGroupMethod "insert" o = SimpleActionGroupInsertMethodInfo
    ResolveSimpleActionGroupMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSimpleActionGroupMethod "listActions" o = Gio.ActionGroup.ActionGroupListActionsMethodInfo
    ResolveSimpleActionGroupMethod "lookup" o = SimpleActionGroupLookupMethodInfo
    ResolveSimpleActionGroupMethod "lookupAction" o = Gio.ActionMap.ActionMapLookupActionMethodInfo
    ResolveSimpleActionGroupMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSimpleActionGroupMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSimpleActionGroupMethod "queryAction" o = Gio.ActionGroup.ActionGroupQueryActionMethodInfo
    ResolveSimpleActionGroupMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSimpleActionGroupMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSimpleActionGroupMethod "remove" o = SimpleActionGroupRemoveMethodInfo
    ResolveSimpleActionGroupMethod "removeAction" o = Gio.ActionMap.ActionMapRemoveActionMethodInfo
    ResolveSimpleActionGroupMethod "removeActionEntries" o = Gio.ActionMap.ActionMapRemoveActionEntriesMethodInfo
    ResolveSimpleActionGroupMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSimpleActionGroupMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSimpleActionGroupMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSimpleActionGroupMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSimpleActionGroupMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSimpleActionGroupMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSimpleActionGroupMethod "getActionEnabled" o = Gio.ActionGroup.ActionGroupGetActionEnabledMethodInfo
    ResolveSimpleActionGroupMethod "getActionParameterType" o = Gio.ActionGroup.ActionGroupGetActionParameterTypeMethodInfo
    ResolveSimpleActionGroupMethod "getActionState" o = Gio.ActionGroup.ActionGroupGetActionStateMethodInfo
    ResolveSimpleActionGroupMethod "getActionStateHint" o = Gio.ActionGroup.ActionGroupGetActionStateHintMethodInfo
    ResolveSimpleActionGroupMethod "getActionStateType" o = Gio.ActionGroup.ActionGroupGetActionStateTypeMethodInfo
    ResolveSimpleActionGroupMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSimpleActionGroupMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSimpleActionGroupMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSimpleActionGroupMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSimpleActionGroupMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSimpleActionGroupMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSimpleActionGroupMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSimpleActionGroupMethod t SimpleActionGroup, O.OverloadedMethod info SimpleActionGroup p) => OL.IsLabel t (SimpleActionGroup -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSimpleActionGroupMethod t SimpleActionGroup, O.OverloadedMethod info SimpleActionGroup p, R.HasField t SimpleActionGroup p) => R.HasField t SimpleActionGroup p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSimpleActionGroupMethod t SimpleActionGroup, O.OverloadedMethodInfo info SimpleActionGroup) => OL.IsLabel t (O.MethodProxy info SimpleActionGroup) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SimpleActionGroup
type instance O.AttributeList SimpleActionGroup = SimpleActionGroupAttributeList
type SimpleActionGroupAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SimpleActionGroup = SimpleActionGroupSignalList
type SimpleActionGroupSignalList = ('[ '("actionAdded", Gio.ActionGroup.ActionGroupActionAddedSignalInfo), '("actionEnabledChanged", Gio.ActionGroup.ActionGroupActionEnabledChangedSignalInfo), '("actionRemoved", Gio.ActionGroup.ActionGroupActionRemovedSignalInfo), '("actionStateChanged", Gio.ActionGroup.ActionGroupActionStateChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SimpleActionGroup::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "SimpleActionGroup" })
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_action_group_new" g_simple_action_group_new :: 
    IO (Ptr SimpleActionGroup)

-- | Creates a new, empty, t'GI.Gio.Objects.SimpleActionGroup.SimpleActionGroup'.
-- 
-- /Since: 2.28/
simpleActionGroupNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m SimpleActionGroup
    -- ^ __Returns:__ a new t'GI.Gio.Objects.SimpleActionGroup.SimpleActionGroup'
simpleActionGroupNew  = liftIO $ do
    result <- g_simple_action_group_new
    checkUnexpectedReturnNULL "simpleActionGroupNew" result
    result' <- (wrapObject SimpleActionGroup) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SimpleActionGroup::add_entries
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleActionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleActionGroup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "entries"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "Gio" , name = "ActionEntry" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pointer to the first item in\n          an array of #GActionEntry structs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_entries"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the length of @entries, or -1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the user data for signal connections"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_entries"
--              , argType = TBasicType TInt
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the length of @entries, or -1"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_action_group_add_entries" g_simple_action_group_add_entries :: 
    Ptr SimpleActionGroup ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleActionGroup"})
    Ptr Gio.ActionEntry.ActionEntry ->      -- entries : TCArray False (-1) 2 (TInterface (Name {namespace = "Gio", name = "ActionEntry"}))
    Int32 ->                                -- n_entries : TBasicType TInt
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

{-# DEPRECATED simpleActionGroupAddEntries ["(Since version 2.38)","Use 'GI.Gio.Interfaces.ActionMap.actionMapAddActionEntries'"] #-}
-- | A convenience function for creating multiple t'GI.Gio.Objects.SimpleAction.SimpleAction' instances
-- and adding them to the action group.
-- 
-- /Since: 2.30/
simpleActionGroupAddEntries ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleActionGroup a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleActionGroup.SimpleActionGroup'
    -> [Gio.ActionEntry.ActionEntry]
    -- ^ /@entries@/: a pointer to the first item in
    --           an array of t'GI.Gio.Structs.ActionEntry.ActionEntry' structs
    -> Ptr ()
    -- ^ /@userData@/: the user data for signal connections
    -> m ()
simpleActionGroupAddEntries simple entries userData = liftIO $ do
    let nEntries = fromIntegral $ P.length entries
    simple' <- unsafeManagedPtrCastPtr simple
    entries' <- mapM unsafeManagedPtrGetPtr entries
    entries'' <- packBlockArray 64 entries'
    g_simple_action_group_add_entries simple' entries'' nEntries userData
    touchManagedPtr simple
    mapM_ touchManagedPtr entries
    freeMem entries''
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleActionGroupAddEntriesMethodInfo
instance (signature ~ ([Gio.ActionEntry.ActionEntry] -> Ptr () -> m ()), MonadIO m, IsSimpleActionGroup a) => O.OverloadedMethod SimpleActionGroupAddEntriesMethodInfo a signature where
    overloadedMethod = simpleActionGroupAddEntries

instance O.OverloadedMethodInfo SimpleActionGroupAddEntriesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleActionGroup.simpleActionGroupAddEntries",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleActionGroup.html#v:simpleActionGroupAddEntries"
        })


#endif

-- method SimpleActionGroup::insert
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleActionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleActionGroup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action"
--           , argType = TInterface Name { namespace = "Gio" , name = "Action" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAction" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_action_group_insert" g_simple_action_group_insert :: 
    Ptr SimpleActionGroup ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleActionGroup"})
    Ptr Gio.Action.Action ->                -- action : TInterface (Name {namespace = "Gio", name = "Action"})
    IO ()

{-# DEPRECATED simpleActionGroupInsert ["(Since version 2.38)","Use 'GI.Gio.Interfaces.ActionMap.actionMapAddAction'"] #-}
-- | Adds an action to the action group.
-- 
-- If the action group already contains an action with the same name as
-- /@action@/ then the old action is dropped from the group.
-- 
-- The action group takes its own reference on /@action@/.
-- 
-- /Since: 2.28/
simpleActionGroupInsert ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleActionGroup a, Gio.Action.IsAction b) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleActionGroup.SimpleActionGroup'
    -> b
    -- ^ /@action@/: a t'GI.Gio.Interfaces.Action.Action'
    -> m ()
simpleActionGroupInsert simple action = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    action' <- unsafeManagedPtrCastPtr action
    g_simple_action_group_insert simple' action'
    touchManagedPtr simple
    touchManagedPtr action
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleActionGroupInsertMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsSimpleActionGroup a, Gio.Action.IsAction b) => O.OverloadedMethod SimpleActionGroupInsertMethodInfo a signature where
    overloadedMethod = simpleActionGroupInsert

instance O.OverloadedMethodInfo SimpleActionGroupInsertMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleActionGroup.simpleActionGroupInsert",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleActionGroup.html#v:simpleActionGroupInsert"
        })


#endif

-- method SimpleActionGroup::lookup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleActionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleActionGroup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of an action"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Action" })
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_action_group_lookup" g_simple_action_group_lookup :: 
    Ptr SimpleActionGroup ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleActionGroup"})
    CString ->                              -- action_name : TBasicType TUTF8
    IO (Ptr Gio.Action.Action)

{-# DEPRECATED simpleActionGroupLookup ["(Since version 2.38)","Use 'GI.Gio.Interfaces.ActionMap.actionMapLookupAction'"] #-}
-- | Looks up the action with the name /@actionName@/ in the group.
-- 
-- If no such action exists, returns 'P.Nothing'.
-- 
-- /Since: 2.28/
simpleActionGroupLookup ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleActionGroup a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleActionGroup.SimpleActionGroup'
    -> T.Text
    -- ^ /@actionName@/: the name of an action
    -> m Gio.Action.Action
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Action.Action', or 'P.Nothing'
simpleActionGroupLookup simple actionName = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    actionName' <- textToCString actionName
    result <- g_simple_action_group_lookup simple' actionName'
    checkUnexpectedReturnNULL "simpleActionGroupLookup" result
    result' <- (newObject Gio.Action.Action) result
    touchManagedPtr simple
    freeMem actionName'
    return result'

#if defined(ENABLE_OVERLOADING)
data SimpleActionGroupLookupMethodInfo
instance (signature ~ (T.Text -> m Gio.Action.Action), MonadIO m, IsSimpleActionGroup a) => O.OverloadedMethod SimpleActionGroupLookupMethodInfo a signature where
    overloadedMethod = simpleActionGroupLookup

instance O.OverloadedMethodInfo SimpleActionGroupLookupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleActionGroup.simpleActionGroupLookup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleActionGroup.html#v:simpleActionGroupLookup"
        })


#endif

-- method SimpleActionGroup::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleActionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleActionGroup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the action"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_action_group_remove" g_simple_action_group_remove :: 
    Ptr SimpleActionGroup ->                -- simple : TInterface (Name {namespace = "Gio", name = "SimpleActionGroup"})
    CString ->                              -- action_name : TBasicType TUTF8
    IO ()

{-# DEPRECATED simpleActionGroupRemove ["(Since version 2.38)","Use 'GI.Gio.Interfaces.ActionMap.actionMapRemoveAction'"] #-}
-- | Removes the named action from the action group.
-- 
-- If no action of this name is in the group then nothing happens.
-- 
-- /Since: 2.28/
simpleActionGroupRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleActionGroup a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleActionGroup.SimpleActionGroup'
    -> T.Text
    -- ^ /@actionName@/: the name of the action
    -> m ()
simpleActionGroupRemove simple actionName = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    actionName' <- textToCString actionName
    g_simple_action_group_remove simple' actionName'
    touchManagedPtr simple
    freeMem actionName'
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleActionGroupRemoveMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsSimpleActionGroup a) => O.OverloadedMethod SimpleActionGroupRemoveMethodInfo a signature where
    overloadedMethod = simpleActionGroupRemove

instance O.OverloadedMethodInfo SimpleActionGroupRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleActionGroup.simpleActionGroupRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SimpleActionGroup.html#v:simpleActionGroupRemove"
        })


#endif


