{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GSettingsBackend@ interface defines a generic interface for
-- non-strictly-typed data that is stored in a hierarchy. To implement
-- an alternative storage backend for t'GI.Gio.Objects.Settings.Settings', you need to
-- implement the @GSettingsBackend@ interface and then make it implement the
-- extension point @G_SETTINGS_BACKEND_EXTENSION_POINT_NAME@.
-- 
-- The interface defines methods for reading and writing values, a
-- method for determining if writing of certain values will fail
-- (lockdown) and a change notification mechanism.
-- 
-- The semantics of the interface are very precisely defined and
-- implementations must carefully adhere to the expectations of
-- callers that are documented on each of the interface methods.
-- 
-- Some of the @GSettingsBackend@ functions accept or return a
-- [struct/@gLib@/.Tree]. These trees always have strings as keys and
-- [struct/@gLib@/.Variant] as values.
-- 
-- The @GSettingsBackend@ API is exported to allow third-party
-- implementations, but does not carry the same stability guarantees
-- as the public GIO API. For this reason, you have to define the
-- C preprocessor symbol @G_SETTINGS_ENABLE_BACKEND@ before including
-- @gio\/gsettingsbackend.h@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SettingsBackend
    ( 
#if defined(ENABLE_OVERLOADING)
    SettingsBackendFlattenTreeMethodInfo    ,
#endif

-- * Exported types
    SettingsBackend(..)                     ,
    IsSettingsBackend                       ,
    toSettingsBackend                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gio.Objects.SettingsBackend#g:method:changed"), [changedTree]("GI.Gio.Objects.SettingsBackend#g:method:changedTree"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [keysChanged]("GI.Gio.Objects.SettingsBackend#g:method:keysChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [pathChanged]("GI.Gio.Objects.SettingsBackend#g:method:pathChanged"), [pathWritableChanged]("GI.Gio.Objects.SettingsBackend#g:method:pathWritableChanged"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [writableChanged]("GI.Gio.Objects.SettingsBackend#g:method:writableChanged").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSettingsBackendMethod            ,
#endif

-- ** changed #method:changed#

#if defined(ENABLE_OVERLOADING)
    SettingsBackendChangedMethodInfo        ,
#endif
    settingsBackendChanged                  ,


-- ** changedTree #method:changedTree#

#if defined(ENABLE_OVERLOADING)
    SettingsBackendChangedTreeMethodInfo    ,
#endif
    settingsBackendChangedTree              ,


-- ** getDefault #method:getDefault#

    settingsBackendGetDefault               ,


-- ** keysChanged #method:keysChanged#

#if defined(ENABLE_OVERLOADING)
    SettingsBackendKeysChangedMethodInfo    ,
#endif
    settingsBackendKeysChanged              ,


-- ** pathChanged #method:pathChanged#

#if defined(ENABLE_OVERLOADING)
    SettingsBackendPathChangedMethodInfo    ,
#endif
    settingsBackendPathChanged              ,


-- ** pathWritableChanged #method:pathWritableChanged#

#if defined(ENABLE_OVERLOADING)
    SettingsBackendPathWritableChangedMethodInfo,
#endif
    settingsBackendPathWritableChanged      ,


-- ** writableChanged #method:writableChanged#

#if defined(ENABLE_OVERLOADING)
    SettingsBackendWritableChangedMethodInfo,
#endif
    settingsBackendWritableChanged          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Tree as GLib.Tree
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GLib.Structs.Tree as GLib.Tree
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype SettingsBackend = SettingsBackend (SP.ManagedPtr SettingsBackend)
    deriving (Eq)

instance SP.ManagedPtrNewtype SettingsBackend where
    toManagedPtr (SettingsBackend p) = p

foreign import ccall "g_settings_backend_get_type"
    c_g_settings_backend_get_type :: IO B.Types.GType

instance B.Types.TypedObject SettingsBackend where
    glibType = c_g_settings_backend_get_type

instance B.Types.GObject SettingsBackend

-- | Type class for types which can be safely cast to `SettingsBackend`, for instance with `toSettingsBackend`.
class (SP.GObject o, O.IsDescendantOf SettingsBackend o) => IsSettingsBackend o
instance (SP.GObject o, O.IsDescendantOf SettingsBackend o) => IsSettingsBackend o

instance O.HasParentTypes SettingsBackend
type instance O.ParentTypes SettingsBackend = '[GObject.Object.Object]

-- | Cast to `SettingsBackend`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSettingsBackend :: (MIO.MonadIO m, IsSettingsBackend o) => o -> m SettingsBackend
toSettingsBackend = MIO.liftIO . B.ManagedPtr.unsafeCastTo SettingsBackend

-- | Convert 'SettingsBackend' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SettingsBackend) where
    gvalueGType_ = c_g_settings_backend_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SettingsBackend)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SettingsBackend)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SettingsBackend ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSettingsBackendMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSettingsBackendMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSettingsBackendMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSettingsBackendMethod "changed" o = SettingsBackendChangedMethodInfo
    ResolveSettingsBackendMethod "changedTree" o = SettingsBackendChangedTreeMethodInfo
    ResolveSettingsBackendMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSettingsBackendMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSettingsBackendMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSettingsBackendMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSettingsBackendMethod "keysChanged" o = SettingsBackendKeysChangedMethodInfo
    ResolveSettingsBackendMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSettingsBackendMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSettingsBackendMethod "pathChanged" o = SettingsBackendPathChangedMethodInfo
    ResolveSettingsBackendMethod "pathWritableChanged" o = SettingsBackendPathWritableChangedMethodInfo
    ResolveSettingsBackendMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSettingsBackendMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSettingsBackendMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSettingsBackendMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSettingsBackendMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSettingsBackendMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSettingsBackendMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSettingsBackendMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSettingsBackendMethod "writableChanged" o = SettingsBackendWritableChangedMethodInfo
    ResolveSettingsBackendMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSettingsBackendMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSettingsBackendMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSettingsBackendMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSettingsBackendMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSettingsBackendMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSettingsBackendMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSettingsBackendMethod t SettingsBackend, O.OverloadedMethod info SettingsBackend p) => OL.IsLabel t (SettingsBackend -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSettingsBackendMethod t SettingsBackend, O.OverloadedMethod info SettingsBackend p, R.HasField t SettingsBackend p) => R.HasField t SettingsBackend p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSettingsBackendMethod t SettingsBackend, O.OverloadedMethodInfo info SettingsBackend) => OL.IsLabel t (O.MethodProxy info SettingsBackend) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SettingsBackend
type instance O.AttributeList SettingsBackend = SettingsBackendAttributeList
type SettingsBackendAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SettingsBackend = SettingsBackendSignalList
type SettingsBackendSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SettingsBackend::changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsBackend implementation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "origin_tag"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the origin tag" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_backend_changed" g_settings_backend_changed :: 
    Ptr SettingsBackend ->                  -- backend : TInterface (Name {namespace = "Gio", name = "SettingsBackend"})
    CString ->                              -- key : TBasicType TUTF8
    Ptr () ->                               -- origin_tag : TBasicType TPtr
    IO ()

-- | Signals that a single key has possibly changed.  Backend
-- implementations should call this if a key has possibly changed its
-- value.
-- 
-- /@key@/ must be a valid key (ie starting with a slash, not containing
-- \'\/\/\', and not ending with a slash).
-- 
-- The implementation must call this function during any call to
-- @/g_settings_backend_write()/@, before the call returns (except in the
-- case that no keys are actually changed and it cares to detect this
-- fact).  It may not rely on the existence of a mainloop for
-- dispatching the signal later.
-- 
-- The implementation may call this function at any other time it likes
-- in response to other events (such as changes occurring outside of the
-- program).  These calls may originate from a mainloop or may originate
-- in response to any other action (including from calls to
-- @/g_settings_backend_write()/@).
-- 
-- In the case that this call is in response to a call to
-- @/g_settings_backend_write()/@ then /@originTag@/ must be set to the same
-- value that was passed to that call.
-- 
-- /Since: 2.26/
settingsBackendChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsSettingsBackend a) =>
    a
    -- ^ /@backend@/: a t'GI.Gio.Objects.SettingsBackend.SettingsBackend' implementation
    -> T.Text
    -- ^ /@key@/: the name of the key
    -> Ptr ()
    -- ^ /@originTag@/: the origin tag
    -> m ()
settingsBackendChanged backend key originTag = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    key' <- textToCString key
    g_settings_backend_changed backend' key' originTag
    touchManagedPtr backend
    freeMem key'
    return ()

#if defined(ENABLE_OVERLOADING)
data SettingsBackendChangedMethodInfo
instance (signature ~ (T.Text -> Ptr () -> m ()), MonadIO m, IsSettingsBackend a) => O.OverloadedMethod SettingsBackendChangedMethodInfo a signature where
    overloadedMethod = settingsBackendChanged

instance O.OverloadedMethodInfo SettingsBackendChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SettingsBackend.settingsBackendChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SettingsBackend.html#v:settingsBackendChanged"
        })


#endif

-- method SettingsBackend::changed_tree
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsBackend implementation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tree"
--           , argType = TInterface Name { namespace = "GLib" , name = "Tree" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTree containing the changes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "origin_tag"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the origin tag" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_backend_changed_tree" g_settings_backend_changed_tree :: 
    Ptr SettingsBackend ->                  -- backend : TInterface (Name {namespace = "Gio", name = "SettingsBackend"})
    Ptr GLib.Tree.Tree ->                   -- tree : TInterface (Name {namespace = "GLib", name = "Tree"})
    Ptr () ->                               -- origin_tag : TBasicType TPtr
    IO ()

-- | This call is a convenience wrapper.  It gets the list of changes from
-- /@tree@/, computes the longest common prefix and calls
-- 'GI.Gio.Objects.SettingsBackend.settingsBackendChanged'.
-- 
-- /Since: 2.26/
settingsBackendChangedTree ::
    (B.CallStack.HasCallStack, MonadIO m, IsSettingsBackend a) =>
    a
    -- ^ /@backend@/: a t'GI.Gio.Objects.SettingsBackend.SettingsBackend' implementation
    -> GLib.Tree.Tree
    -- ^ /@tree@/: a t'GI.GLib.Structs.Tree.Tree' containing the changes
    -> Ptr ()
    -- ^ /@originTag@/: the origin tag
    -> m ()
settingsBackendChangedTree backend tree originTag = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    tree' <- unsafeManagedPtrGetPtr tree
    g_settings_backend_changed_tree backend' tree' originTag
    touchManagedPtr backend
    touchManagedPtr tree
    return ()

#if defined(ENABLE_OVERLOADING)
data SettingsBackendChangedTreeMethodInfo
instance (signature ~ (GLib.Tree.Tree -> Ptr () -> m ()), MonadIO m, IsSettingsBackend a) => O.OverloadedMethod SettingsBackendChangedTreeMethodInfo a signature where
    overloadedMethod = settingsBackendChangedTree

instance O.OverloadedMethodInfo SettingsBackendChangedTreeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SettingsBackend.settingsBackendChangedTree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SettingsBackend.html#v:settingsBackendChangedTree"
        })


#endif

-- method SettingsBackend::keys_changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsBackend implementation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the path containing the changes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "items"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the %NULL-terminated list of changed keys"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "origin_tag"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the origin tag" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_backend_keys_changed" g_settings_backend_keys_changed :: 
    Ptr SettingsBackend ->                  -- backend : TInterface (Name {namespace = "Gio", name = "SettingsBackend"})
    CString ->                              -- path : TBasicType TUTF8
    Ptr CString ->                          -- items : TCArray True (-1) (-1) (TBasicType TUTF8)
    Ptr () ->                               -- origin_tag : TBasicType TPtr
    IO ()

-- | Signals that a list of keys have possibly changed.  Backend
-- implementations should call this if keys have possibly changed their
-- values.
-- 
-- /@path@/ must be a valid path (ie starting and ending with a slash and
-- not containing \'\/\/\').  Each string in /@items@/ must form a valid key
-- name when /@path@/ is prefixed to it (ie: each item must not start or
-- end with \'\/\' and must not contain \'\/\/\').
-- 
-- The meaning of this signal is that any of the key names resulting
-- from the contatenation of /@path@/ with each item in /@items@/ may have
-- changed.
-- 
-- The same rules for when notifications must occur apply as per
-- 'GI.Gio.Objects.SettingsBackend.settingsBackendChanged'.  These two calls can be used
-- interchangeably if exactly one item has changed (although in that
-- case 'GI.Gio.Objects.SettingsBackend.settingsBackendChanged' is definitely preferred).
-- 
-- For efficiency reasons, the implementation should strive for /@path@/ to
-- be as long as possible (ie: the longest common prefix of all of the
-- keys that were changed) but this is not strictly required.
-- 
-- /Since: 2.26/
settingsBackendKeysChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsSettingsBackend a) =>
    a
    -- ^ /@backend@/: a t'GI.Gio.Objects.SettingsBackend.SettingsBackend' implementation
    -> T.Text
    -- ^ /@path@/: the path containing the changes
    -> [T.Text]
    -- ^ /@items@/: the 'P.Nothing'-terminated list of changed keys
    -> Ptr ()
    -- ^ /@originTag@/: the origin tag
    -> m ()
settingsBackendKeysChanged backend path items originTag = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    path' <- textToCString path
    items' <- packZeroTerminatedUTF8CArray items
    g_settings_backend_keys_changed backend' path' items' originTag
    touchManagedPtr backend
    freeMem path'
    mapZeroTerminatedCArray freeMem items'
    freeMem items'
    return ()

#if defined(ENABLE_OVERLOADING)
data SettingsBackendKeysChangedMethodInfo
instance (signature ~ (T.Text -> [T.Text] -> Ptr () -> m ()), MonadIO m, IsSettingsBackend a) => O.OverloadedMethod SettingsBackendKeysChangedMethodInfo a signature where
    overloadedMethod = settingsBackendKeysChanged

instance O.OverloadedMethodInfo SettingsBackendKeysChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SettingsBackend.settingsBackendKeysChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SettingsBackend.html#v:settingsBackendKeysChanged"
        })


#endif

-- method SettingsBackend::path_changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsBackend implementation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the path containing the changes"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "origin_tag"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the origin tag" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_backend_path_changed" g_settings_backend_path_changed :: 
    Ptr SettingsBackend ->                  -- backend : TInterface (Name {namespace = "Gio", name = "SettingsBackend"})
    CString ->                              -- path : TBasicType TUTF8
    Ptr () ->                               -- origin_tag : TBasicType TPtr
    IO ()

-- | Signals that all keys below a given path may have possibly changed.
-- Backend implementations should call this if an entire path of keys
-- have possibly changed their values.
-- 
-- /@path@/ must be a valid path (ie starting and ending with a slash and
-- not containing \'\/\/\').
-- 
-- The meaning of this signal is that any of the key which has a name
-- starting with /@path@/ may have changed.
-- 
-- The same rules for when notifications must occur apply as per
-- 'GI.Gio.Objects.SettingsBackend.settingsBackendChanged'.  This call might be an appropriate
-- reasponse to a \'reset\' call but implementations are also free to
-- explicitly list the keys that were affected by that call if they can
-- easily do so.
-- 
-- For efficiency reasons, the implementation should strive for /@path@/ to
-- be as long as possible (ie: the longest common prefix of all of the
-- keys that were changed) but this is not strictly required.  As an
-- example, if this function is called with the path of \"\/\" then every
-- single key in the application will be notified of a possible change.
-- 
-- /Since: 2.26/
settingsBackendPathChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsSettingsBackend a) =>
    a
    -- ^ /@backend@/: a t'GI.Gio.Objects.SettingsBackend.SettingsBackend' implementation
    -> T.Text
    -- ^ /@path@/: the path containing the changes
    -> Ptr ()
    -- ^ /@originTag@/: the origin tag
    -> m ()
settingsBackendPathChanged backend path originTag = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    path' <- textToCString path
    g_settings_backend_path_changed backend' path' originTag
    touchManagedPtr backend
    freeMem path'
    return ()

#if defined(ENABLE_OVERLOADING)
data SettingsBackendPathChangedMethodInfo
instance (signature ~ (T.Text -> Ptr () -> m ()), MonadIO m, IsSettingsBackend a) => O.OverloadedMethod SettingsBackendPathChangedMethodInfo a signature where
    overloadedMethod = settingsBackendPathChanged

instance O.OverloadedMethodInfo SettingsBackendPathChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SettingsBackend.settingsBackendPathChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SettingsBackend.html#v:settingsBackendPathChanged"
        })


#endif

-- method SettingsBackend::path_writable_changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsBackend implementation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the path"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_backend_path_writable_changed" g_settings_backend_path_writable_changed :: 
    Ptr SettingsBackend ->                  -- backend : TInterface (Name {namespace = "Gio", name = "SettingsBackend"})
    CString ->                              -- path : TBasicType TUTF8
    IO ()

-- | Signals that the writability of all keys below a given path may have
-- changed.
-- 
-- Since GSettings performs no locking operations for itself, this call
-- will always be made in response to external events.
-- 
-- /Since: 2.26/
settingsBackendPathWritableChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsSettingsBackend a) =>
    a
    -- ^ /@backend@/: a t'GI.Gio.Objects.SettingsBackend.SettingsBackend' implementation
    -> T.Text
    -- ^ /@path@/: the name of the path
    -> m ()
settingsBackendPathWritableChanged backend path = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    path' <- textToCString path
    g_settings_backend_path_writable_changed backend' path'
    touchManagedPtr backend
    freeMem path'
    return ()

#if defined(ENABLE_OVERLOADING)
data SettingsBackendPathWritableChangedMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsSettingsBackend a) => O.OverloadedMethod SettingsBackendPathWritableChangedMethodInfo a signature where
    overloadedMethod = settingsBackendPathWritableChanged

instance O.OverloadedMethodInfo SettingsBackendPathWritableChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SettingsBackend.settingsBackendPathWritableChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SettingsBackend.html#v:settingsBackendPathWritableChanged"
        })


#endif

-- method SettingsBackend::writable_changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "backend"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SettingsBackend" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSettingsBackend implementation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "key"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_backend_writable_changed" g_settings_backend_writable_changed :: 
    Ptr SettingsBackend ->                  -- backend : TInterface (Name {namespace = "Gio", name = "SettingsBackend"})
    CString ->                              -- key : TBasicType TUTF8
    IO ()

-- | Signals that the writability of a single key has possibly changed.
-- 
-- Since GSettings performs no locking operations for itself, this call
-- will always be made in response to external events.
-- 
-- /Since: 2.26/
settingsBackendWritableChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsSettingsBackend a) =>
    a
    -- ^ /@backend@/: a t'GI.Gio.Objects.SettingsBackend.SettingsBackend' implementation
    -> T.Text
    -- ^ /@key@/: the name of the key
    -> m ()
settingsBackendWritableChanged backend key = liftIO $ do
    backend' <- unsafeManagedPtrCastPtr backend
    key' <- textToCString key
    g_settings_backend_writable_changed backend' key'
    touchManagedPtr backend
    freeMem key'
    return ()

#if defined(ENABLE_OVERLOADING)
data SettingsBackendWritableChangedMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsSettingsBackend a) => O.OverloadedMethod SettingsBackendWritableChangedMethodInfo a signature where
    overloadedMethod = settingsBackendWritableChanged

instance O.OverloadedMethodInfo SettingsBackendWritableChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SettingsBackend.settingsBackendWritableChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-SettingsBackend.html#v:settingsBackendWritableChanged"
        })


#endif

-- XXX Could not generate method SettingsBackend::flatten_tree
-- Not implemented: Don't know how to unpack C array of type TCArray True (-1) (-1) TVariant
#if defined(ENABLE_OVERLOADING)
-- XXX: Dummy instance, since code generation failed.
-- Please file a bug at http://github.com/haskell-gi/haskell-gi.
data SettingsBackendFlattenTreeMethodInfo
instance (p ~ (), o ~ O.UnsupportedMethodError "flattenTree" SettingsBackend) => O.OverloadedMethod SettingsBackendFlattenTreeMethodInfo o p where
    overloadedMethod = undefined

instance (o ~ O.UnsupportedMethodError "flattenTree" SettingsBackend) => O.OverloadedMethodInfo SettingsBackendFlattenTreeMethodInfo o where
    overloadedMethodInfo = undefined

#endif

-- method SettingsBackend::get_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SettingsBackend" })
-- throws : False
-- Skip return : False

foreign import ccall "g_settings_backend_get_default" g_settings_backend_get_default :: 
    IO (Ptr SettingsBackend)

-- | Returns the default t'GI.Gio.Objects.SettingsBackend.SettingsBackend'. It is possible to override
-- the default by setting the @GSETTINGS_BACKEND@ environment variable
-- to the name of a settings backend.
-- 
-- The user gets a reference to the backend.
-- 
-- /Since: 2.28/
settingsBackendGetDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m SettingsBackend
    -- ^ __Returns:__ the default t'GI.Gio.Objects.SettingsBackend.SettingsBackend',
    --     which will be a dummy (memory) settings backend if no other settings
    --     backend is available.
settingsBackendGetDefault  = liftIO $ do
    result <- g_settings_backend_get_default
    checkUnexpectedReturnNULL "settingsBackendGetDefault" result
    result' <- (wrapObject SettingsBackend) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


