{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gio.Objects.MenuLinkIter.MenuLinkIter' is an opaque structure type.  You must access it using
-- the functions below.
-- 
-- /Since: 2.32/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.MenuLinkIter
    ( 

-- * Exported types
    MenuLinkIter(..)                        ,
    IsMenuLinkIter                          ,
    toMenuLinkIter                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [next]("GI.Gio.Objects.MenuLinkIter#g:method:next"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getName]("GI.Gio.Objects.MenuLinkIter#g:method:getName"), [getNext]("GI.Gio.Objects.MenuLinkIter#g:method:getNext"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getValue]("GI.Gio.Objects.MenuLinkIter#g:method:getValue").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMenuLinkIterMethod               ,
#endif

-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    MenuLinkIterGetNameMethodInfo           ,
#endif
    menuLinkIterGetName                     ,


-- ** getNext #method:getNext#

#if defined(ENABLE_OVERLOADING)
    MenuLinkIterGetNextMethodInfo           ,
#endif
    menuLinkIterGetNext                     ,


-- ** getValue #method:getValue#

#if defined(ENABLE_OVERLOADING)
    MenuLinkIterGetValueMethodInfo          ,
#endif
    menuLinkIterGetValue                    ,


-- ** next #method:next#

#if defined(ENABLE_OVERLOADING)
    MenuLinkIterNextMethodInfo              ,
#endif
    menuLinkIterNext                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuAttributeIter as Gio.MenuAttributeIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel

#endif

-- | Memory-managed wrapper type.
newtype MenuLinkIter = MenuLinkIter (SP.ManagedPtr MenuLinkIter)
    deriving (Eq)

instance SP.ManagedPtrNewtype MenuLinkIter where
    toManagedPtr (MenuLinkIter p) = p

foreign import ccall "g_menu_link_iter_get_type"
    c_g_menu_link_iter_get_type :: IO B.Types.GType

instance B.Types.TypedObject MenuLinkIter where
    glibType = c_g_menu_link_iter_get_type

instance B.Types.GObject MenuLinkIter

-- | Type class for types which can be safely cast to `MenuLinkIter`, for instance with `toMenuLinkIter`.
class (SP.GObject o, O.IsDescendantOf MenuLinkIter o) => IsMenuLinkIter o
instance (SP.GObject o, O.IsDescendantOf MenuLinkIter o) => IsMenuLinkIter o

instance O.HasParentTypes MenuLinkIter
type instance O.ParentTypes MenuLinkIter = '[GObject.Object.Object]

-- | Cast to `MenuLinkIter`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMenuLinkIter :: (MIO.MonadIO m, IsMenuLinkIter o) => o -> m MenuLinkIter
toMenuLinkIter = MIO.liftIO . B.ManagedPtr.unsafeCastTo MenuLinkIter

-- | Convert 'MenuLinkIter' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MenuLinkIter) where
    gvalueGType_ = c_g_menu_link_iter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MenuLinkIter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MenuLinkIter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MenuLinkIter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMenuLinkIterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMenuLinkIterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMenuLinkIterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMenuLinkIterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMenuLinkIterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMenuLinkIterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMenuLinkIterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMenuLinkIterMethod "next" o = MenuLinkIterNextMethodInfo
    ResolveMenuLinkIterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMenuLinkIterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMenuLinkIterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMenuLinkIterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMenuLinkIterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMenuLinkIterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMenuLinkIterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMenuLinkIterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMenuLinkIterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMenuLinkIterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMenuLinkIterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMenuLinkIterMethod "getName" o = MenuLinkIterGetNameMethodInfo
    ResolveMenuLinkIterMethod "getNext" o = MenuLinkIterGetNextMethodInfo
    ResolveMenuLinkIterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMenuLinkIterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMenuLinkIterMethod "getValue" o = MenuLinkIterGetValueMethodInfo
    ResolveMenuLinkIterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMenuLinkIterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMenuLinkIterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMenuLinkIterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMenuLinkIterMethod t MenuLinkIter, O.OverloadedMethod info MenuLinkIter p) => OL.IsLabel t (MenuLinkIter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMenuLinkIterMethod t MenuLinkIter, O.OverloadedMethod info MenuLinkIter p, R.HasField t MenuLinkIter p) => R.HasField t MenuLinkIter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMenuLinkIterMethod t MenuLinkIter, O.OverloadedMethodInfo info MenuLinkIter) => OL.IsLabel t (O.MethodProxy info MenuLinkIter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MenuLinkIter
type instance O.AttributeList MenuLinkIter = MenuLinkIterAttributeList
type MenuLinkIterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MenuLinkIter = MenuLinkIterSignalList
type MenuLinkIterSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MenuLinkIter::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuLinkIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuLinkIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_link_iter_get_name" g_menu_link_iter_get_name :: 
    Ptr MenuLinkIter ->                     -- iter : TInterface (Name {namespace = "Gio", name = "MenuLinkIter"})
    IO CString

-- | Gets the name of the link at the current iterator position.
-- 
-- The iterator is not advanced.
-- 
-- /Since: 2.32/
menuLinkIterGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuLinkIter a) =>
    a
    -- ^ /@iter@/: a t'GI.Gio.Objects.MenuLinkIter.MenuLinkIter'
    -> m T.Text
    -- ^ __Returns:__ the type of the link
menuLinkIterGetName iter = liftIO $ do
    iter' <- unsafeManagedPtrCastPtr iter
    result <- g_menu_link_iter_get_name iter'
    checkUnexpectedReturnNULL "menuLinkIterGetName" result
    result' <- cstringToText result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuLinkIterGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsMenuLinkIter a) => O.OverloadedMethod MenuLinkIterGetNameMethodInfo a signature where
    overloadedMethod = menuLinkIterGetName

instance O.OverloadedMethodInfo MenuLinkIterGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuLinkIter.menuLinkIterGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuLinkIter.html#v:menuLinkIterGetName"
        })


#endif

-- method MenuLinkIter::get_next
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuLinkIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuLinkIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "out_link"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the link"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the linked #GMenuModel"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_link_iter_get_next" g_menu_link_iter_get_next :: 
    Ptr MenuLinkIter ->                     -- iter : TInterface (Name {namespace = "Gio", name = "MenuLinkIter"})
    Ptr CString ->                          -- out_link : TBasicType TUTF8
    Ptr (Ptr Gio.MenuModel.MenuModel) ->    -- value : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO CInt

-- | This function combines 'GI.Gio.Objects.MenuLinkIter.menuLinkIterNext' with
-- 'GI.Gio.Objects.MenuLinkIter.menuLinkIterGetName' and 'GI.Gio.Objects.MenuLinkIter.menuLinkIterGetValue'.
-- 
-- First the iterator is advanced to the next (possibly first) link.
-- If that fails, then 'P.False' is returned and there are no other effects.
-- 
-- If successful, /@outLink@/ and /@value@/ are set to the name and t'GI.Gio.Objects.MenuModel.MenuModel'
-- of the link that has just been advanced to.  At this point,
-- 'GI.Gio.Objects.MenuLinkIter.menuLinkIterGetName' and 'GI.Gio.Objects.MenuLinkIter.menuLinkIterGetValue' will return the
-- same values again.
-- 
-- The value returned in /@outLink@/ remains valid for as long as the iterator
-- remains at the current position.  The value returned in /@value@/ must
-- be unreffed using 'GI.GObject.Objects.Object.objectUnref' when it is no longer in use.
-- 
-- /Since: 2.32/
menuLinkIterGetNext ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuLinkIter a) =>
    a
    -- ^ /@iter@/: a t'GI.Gio.Objects.MenuLinkIter.MenuLinkIter'
    -> m ((Bool, T.Text, Gio.MenuModel.MenuModel))
    -- ^ __Returns:__ 'P.True' on success, or 'P.False' if there is no additional link
menuLinkIterGetNext iter = liftIO $ do
    iter' <- unsafeManagedPtrCastPtr iter
    outLink <- callocMem :: IO (Ptr CString)
    value <- callocMem :: IO (Ptr (Ptr Gio.MenuModel.MenuModel))
    result <- g_menu_link_iter_get_next iter' outLink value
    let result' = (/= 0) result
    outLink' <- peek outLink
    outLink'' <- cstringToText outLink'
    value' <- peek value
    value'' <- (wrapObject Gio.MenuModel.MenuModel) value'
    touchManagedPtr iter
    freeMem outLink
    freeMem value
    return (result', outLink'', value'')

#if defined(ENABLE_OVERLOADING)
data MenuLinkIterGetNextMethodInfo
instance (signature ~ (m ((Bool, T.Text, Gio.MenuModel.MenuModel))), MonadIO m, IsMenuLinkIter a) => O.OverloadedMethod MenuLinkIterGetNextMethodInfo a signature where
    overloadedMethod = menuLinkIterGetNext

instance O.OverloadedMethodInfo MenuLinkIterGetNextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuLinkIter.menuLinkIterGetNext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuLinkIter.html#v:menuLinkIterGetNext"
        })


#endif

-- method MenuLinkIter::get_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuLinkIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuLinkIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "MenuModel" })
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_link_iter_get_value" g_menu_link_iter_get_value :: 
    Ptr MenuLinkIter ->                     -- iter : TInterface (Name {namespace = "Gio", name = "MenuLinkIter"})
    IO (Ptr Gio.MenuModel.MenuModel)

-- | Gets the linked t'GI.Gio.Objects.MenuModel.MenuModel' at the current iterator position.
-- 
-- The iterator is not advanced.
-- 
-- /Since: 2.32/
menuLinkIterGetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuLinkIter a) =>
    a
    -- ^ /@iter@/: a t'GI.Gio.Objects.MenuLinkIter.MenuLinkIter'
    -> m Gio.MenuModel.MenuModel
    -- ^ __Returns:__ the t'GI.Gio.Objects.MenuModel.MenuModel' that is linked to
menuLinkIterGetValue iter = liftIO $ do
    iter' <- unsafeManagedPtrCastPtr iter
    result <- g_menu_link_iter_get_value iter'
    checkUnexpectedReturnNULL "menuLinkIterGetValue" result
    result' <- (wrapObject Gio.MenuModel.MenuModel) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuLinkIterGetValueMethodInfo
instance (signature ~ (m Gio.MenuModel.MenuModel), MonadIO m, IsMenuLinkIter a) => O.OverloadedMethod MenuLinkIterGetValueMethodInfo a signature where
    overloadedMethod = menuLinkIterGetValue

instance O.OverloadedMethodInfo MenuLinkIterGetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuLinkIter.menuLinkIterGetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuLinkIter.html#v:menuLinkIterGetValue"
        })


#endif

-- method MenuLinkIter::next
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuLinkIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuLinkIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_link_iter_next" g_menu_link_iter_next :: 
    Ptr MenuLinkIter ->                     -- iter : TInterface (Name {namespace = "Gio", name = "MenuLinkIter"})
    IO CInt

-- | Attempts to advance the iterator to the next (possibly first)
-- link.
-- 
-- 'P.True' is returned on success, or 'P.False' if there are no more links.
-- 
-- You must call this function when you first acquire the iterator to
-- advance it to the first link (and determine if the first link exists
-- at all).
-- 
-- /Since: 2.32/
menuLinkIterNext ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuLinkIter a) =>
    a
    -- ^ /@iter@/: a t'GI.Gio.Objects.MenuLinkIter.MenuLinkIter'
    -> m Bool
    -- ^ __Returns:__ 'P.True' on success, or 'P.False' when there are no more links
menuLinkIterNext iter = liftIO $ do
    iter' <- unsafeManagedPtrCastPtr iter
    result <- g_menu_link_iter_next iter'
    let result' = (/= 0) result
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data MenuLinkIterNextMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMenuLinkIter a) => O.OverloadedMethod MenuLinkIterNextMethodInfo a signature where
    overloadedMethod = menuLinkIterNext

instance O.OverloadedMethodInfo MenuLinkIterNextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuLinkIter.menuLinkIterNext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuLinkIter.html#v:menuLinkIterNext"
        })


#endif


