{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gio.Objects.MenuItem.MenuItem' is an opaque structure type.  You must access it using the
-- functions below.
-- 
-- /Since: 2.32/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.MenuItem
    ( 

-- * Exported types
    MenuItem(..)                            ,
    IsMenuItem                              ,
    toMenuItem                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAttributeValue]("GI.Gio.Objects.MenuItem#g:method:getAttributeValue"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLink]("GI.Gio.Objects.MenuItem#g:method:getLink"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setActionAndTargetValue]("GI.Gio.Objects.MenuItem#g:method:setActionAndTargetValue"), [setAttributeValue]("GI.Gio.Objects.MenuItem#g:method:setAttributeValue"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDetailedAction]("GI.Gio.Objects.MenuItem#g:method:setDetailedAction"), [setIcon]("GI.Gio.Objects.MenuItem#g:method:setIcon"), [setLabel]("GI.Gio.Objects.MenuItem#g:method:setLabel"), [setLink]("GI.Gio.Objects.MenuItem#g:method:setLink"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSection]("GI.Gio.Objects.MenuItem#g:method:setSection"), [setSubmenu]("GI.Gio.Objects.MenuItem#g:method:setSubmenu").

#if defined(ENABLE_OVERLOADING)
    ResolveMenuItemMethod                   ,
#endif

-- ** getAttributeValue #method:getAttributeValue#

#if defined(ENABLE_OVERLOADING)
    MenuItemGetAttributeValueMethodInfo     ,
#endif
    menuItemGetAttributeValue               ,


-- ** getLink #method:getLink#

#if defined(ENABLE_OVERLOADING)
    MenuItemGetLinkMethodInfo               ,
#endif
    menuItemGetLink                         ,


-- ** new #method:new#

    menuItemNew                             ,


-- ** newFromModel #method:newFromModel#

    menuItemNewFromModel                    ,


-- ** newSection #method:newSection#

    menuItemNewSection                      ,


-- ** newSubmenu #method:newSubmenu#

    menuItemNewSubmenu                      ,


-- ** setActionAndTargetValue #method:setActionAndTargetValue#

#if defined(ENABLE_OVERLOADING)
    MenuItemSetActionAndTargetValueMethodInfo,
#endif
    menuItemSetActionAndTargetValue         ,


-- ** setAttributeValue #method:setAttributeValue#

#if defined(ENABLE_OVERLOADING)
    MenuItemSetAttributeValueMethodInfo     ,
#endif
    menuItemSetAttributeValue               ,


-- ** setDetailedAction #method:setDetailedAction#

#if defined(ENABLE_OVERLOADING)
    MenuItemSetDetailedActionMethodInfo     ,
#endif
    menuItemSetDetailedAction               ,


-- ** setIcon #method:setIcon#

#if defined(ENABLE_OVERLOADING)
    MenuItemSetIconMethodInfo               ,
#endif
    menuItemSetIcon                         ,


-- ** setLabel #method:setLabel#

#if defined(ENABLE_OVERLOADING)
    MenuItemSetLabelMethodInfo              ,
#endif
    menuItemSetLabel                        ,


-- ** setLink #method:setLink#

#if defined(ENABLE_OVERLOADING)
    MenuItemSetLinkMethodInfo               ,
#endif
    menuItemSetLink                         ,


-- ** setSection #method:setSection#

#if defined(ENABLE_OVERLOADING)
    MenuItemSetSectionMethodInfo            ,
#endif
    menuItemSetSection                      ,


-- ** setSubmenu #method:setSubmenu#

#if defined(ENABLE_OVERLOADING)
    MenuItemSetSubmenuMethodInfo            ,
#endif
    menuItemSetSubmenu                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuAttributeIter as Gio.MenuAttributeIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuLinkIter as Gio.MenuLinkIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel

#else
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel

#endif

-- | Memory-managed wrapper type.
newtype MenuItem = MenuItem (SP.ManagedPtr MenuItem)
    deriving (Eq)

instance SP.ManagedPtrNewtype MenuItem where
    toManagedPtr (MenuItem p) = p

foreign import ccall "g_menu_item_get_type"
    c_g_menu_item_get_type :: IO B.Types.GType

instance B.Types.TypedObject MenuItem where
    glibType = c_g_menu_item_get_type

instance B.Types.GObject MenuItem

-- | Type class for types which can be safely cast to `MenuItem`, for instance with `toMenuItem`.
class (SP.GObject o, O.IsDescendantOf MenuItem o) => IsMenuItem o
instance (SP.GObject o, O.IsDescendantOf MenuItem o) => IsMenuItem o

instance O.HasParentTypes MenuItem
type instance O.ParentTypes MenuItem = '[GObject.Object.Object]

-- | Cast to `MenuItem`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMenuItem :: (MIO.MonadIO m, IsMenuItem o) => o -> m MenuItem
toMenuItem = MIO.liftIO . B.ManagedPtr.unsafeCastTo MenuItem

-- | Convert 'MenuItem' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MenuItem) where
    gvalueGType_ = c_g_menu_item_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MenuItem)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MenuItem)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MenuItem ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMenuItemMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMenuItemMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMenuItemMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMenuItemMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMenuItemMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMenuItemMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMenuItemMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMenuItemMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMenuItemMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMenuItemMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMenuItemMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMenuItemMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMenuItemMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMenuItemMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMenuItemMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMenuItemMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMenuItemMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMenuItemMethod "getAttributeValue" o = MenuItemGetAttributeValueMethodInfo
    ResolveMenuItemMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMenuItemMethod "getLink" o = MenuItemGetLinkMethodInfo
    ResolveMenuItemMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMenuItemMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMenuItemMethod "setActionAndTargetValue" o = MenuItemSetActionAndTargetValueMethodInfo
    ResolveMenuItemMethod "setAttributeValue" o = MenuItemSetAttributeValueMethodInfo
    ResolveMenuItemMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMenuItemMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMenuItemMethod "setDetailedAction" o = MenuItemSetDetailedActionMethodInfo
    ResolveMenuItemMethod "setIcon" o = MenuItemSetIconMethodInfo
    ResolveMenuItemMethod "setLabel" o = MenuItemSetLabelMethodInfo
    ResolveMenuItemMethod "setLink" o = MenuItemSetLinkMethodInfo
    ResolveMenuItemMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMenuItemMethod "setSection" o = MenuItemSetSectionMethodInfo
    ResolveMenuItemMethod "setSubmenu" o = MenuItemSetSubmenuMethodInfo
    ResolveMenuItemMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMenuItemMethod t MenuItem, O.OverloadedMethod info MenuItem p) => OL.IsLabel t (MenuItem -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMenuItemMethod t MenuItem, O.OverloadedMethod info MenuItem p, R.HasField t MenuItem p) => R.HasField t MenuItem p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMenuItemMethod t MenuItem, O.OverloadedMethodInfo info MenuItem) => OL.IsLabel t (O.MethodProxy info MenuItem) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MenuItem
type instance O.AttributeList MenuItem = MenuItemAttributeList
type MenuItemAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MenuItem = MenuItemSignalList
type MenuItemSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MenuItem::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the section label, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detailed_action"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the detailed action string, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "MenuItem" })
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_new" g_menu_item_new :: 
    CString ->                              -- label : TBasicType TUTF8
    CString ->                              -- detailed_action : TBasicType TUTF8
    IO (Ptr MenuItem)

-- | Creates a new t'GI.Gio.Objects.MenuItem.MenuItem'.
-- 
-- If /@label@/ is non-'P.Nothing' it is used to set the \"label\" attribute of the
-- new item.
-- 
-- If /@detailedAction@/ is non-'P.Nothing' it is used to set the \"action\" and
-- possibly the \"target\" attribute of the new item.  See
-- 'GI.Gio.Objects.MenuItem.menuItemSetDetailedAction' for more information.
-- 
-- /Since: 2.32/
menuItemNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@label@/: the section label, or 'P.Nothing'
    -> Maybe (T.Text)
    -- ^ /@detailedAction@/: the detailed action string, or 'P.Nothing'
    -> m MenuItem
    -- ^ __Returns:__ a new t'GI.Gio.Objects.MenuItem.MenuItem'
menuItemNew label detailedAction = liftIO $ do
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    maybeDetailedAction <- case detailedAction of
        Nothing -> return FP.nullPtr
        Just jDetailedAction -> do
            jDetailedAction' <- textToCString jDetailedAction
            return jDetailedAction'
    result <- g_menu_item_new maybeLabel maybeDetailedAction
    checkUnexpectedReturnNULL "menuItemNew" result
    result' <- (wrapObject MenuItem) result
    freeMem maybeLabel
    freeMem maybeDetailedAction
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MenuItem::new_from_model
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuModel" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item_index"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index of an item in @model"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "MenuItem" })
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_new_from_model" g_menu_item_new_from_model :: 
    Ptr Gio.MenuModel.MenuModel ->          -- model : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    Int32 ->                                -- item_index : TBasicType TInt
    IO (Ptr MenuItem)

-- | Creates a t'GI.Gio.Objects.MenuItem.MenuItem' as an exact copy of an existing menu item in a
-- t'GI.Gio.Objects.MenuModel.MenuModel'.
-- 
-- /@itemIndex@/ must be valid (ie: be sure to call
-- 'GI.Gio.Objects.MenuModel.menuModelGetNItems' first).
-- 
-- /Since: 2.34/
menuItemNewFromModel ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.MenuModel.IsMenuModel a) =>
    a
    -- ^ /@model@/: a t'GI.Gio.Objects.MenuModel.MenuModel'
    -> Int32
    -- ^ /@itemIndex@/: the index of an item in /@model@/
    -> m MenuItem
    -- ^ __Returns:__ a new t'GI.Gio.Objects.MenuItem.MenuItem'.
menuItemNewFromModel model itemIndex = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    result <- g_menu_item_new_from_model model' itemIndex
    checkUnexpectedReturnNULL "menuItemNewFromModel" result
    result' <- (wrapObject MenuItem) result
    touchManagedPtr model
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MenuItem::new_section
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the section label, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "section"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuModel with the items of the section"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "MenuItem" })
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_new_section" g_menu_item_new_section :: 
    CString ->                              -- label : TBasicType TUTF8
    Ptr Gio.MenuModel.MenuModel ->          -- section : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO (Ptr MenuItem)

-- | Creates a new t'GI.Gio.Objects.MenuItem.MenuItem' representing a section.
-- 
-- This is a convenience API around 'GI.Gio.Objects.MenuItem.menuItemNew' and
-- 'GI.Gio.Objects.MenuItem.menuItemSetSection'.
-- 
-- The effect of having one menu appear as a section of another is
-- exactly as it sounds: the items from /@section@/ become a direct part of
-- the menu that /@menuItem@/ is added to.
-- 
-- Visual separation is typically displayed between two non-empty
-- sections.  If /@label@/ is non-'P.Nothing' then it will be incorporated into
-- this visual indication.  This allows for labeled subsections of a
-- menu.
-- 
-- As a simple example, consider a typical \"Edit\" menu from a simple
-- program.  It probably contains an \"Undo\" and \"Redo\" item, followed by
-- a separator, followed by \"Cut\", \"Copy\" and \"Paste\".
-- 
-- This would be accomplished by creating three t'GI.Gio.Objects.Menu.Menu' instances.  The
-- first would be populated with the \"Undo\" and \"Redo\" items, and the
-- second with the \"Cut\", \"Copy\" and \"Paste\" items.  The first and
-- second menus would then be added as submenus of the third.  In XML
-- format, this would look something like the following:
-- >
-- ><menu id='edit-menu'>
-- >  <section>
-- >    <item label='Undo'/>
-- >    <item label='Redo'/>
-- >  </section>
-- >  <section>
-- >    <item label='Cut'/>
-- >    <item label='Copy'/>
-- >    <item label='Paste'/>
-- >  </section>
-- ></menu>
-- 
-- 
-- The following example is exactly equivalent.  It is more illustrative
-- of the exact relationship between the menus and items (keeping in
-- mind that the \'link\' element defines a new menu that is linked to the
-- containing one).  The style of the second example is more verbose and
-- difficult to read (and therefore not recommended except for the
-- purpose of understanding what is really going on).
-- >
-- ><menu id='edit-menu'>
-- >  <item>
-- >    <link name='section'>
-- >      <item label='Undo'/>
-- >      <item label='Redo'/>
-- >    </link>
-- >  </item>
-- >  <item>
-- >    <link name='section'>
-- >      <item label='Cut'/>
-- >      <item label='Copy'/>
-- >      <item label='Paste'/>
-- >    </link>
-- >  </item>
-- ></menu>
-- 
-- 
-- /Since: 2.32/
menuItemNewSection ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.MenuModel.IsMenuModel a) =>
    Maybe (T.Text)
    -- ^ /@label@/: the section label, or 'P.Nothing'
    -> a
    -- ^ /@section@/: a t'GI.Gio.Objects.MenuModel.MenuModel' with the items of the section
    -> m MenuItem
    -- ^ __Returns:__ a new t'GI.Gio.Objects.MenuItem.MenuItem'
menuItemNewSection label section = liftIO $ do
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    section' <- unsafeManagedPtrCastPtr section
    result <- g_menu_item_new_section maybeLabel section'
    checkUnexpectedReturnNULL "menuItemNewSection" result
    result' <- (wrapObject MenuItem) result
    touchManagedPtr section
    freeMem maybeLabel
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MenuItem::new_submenu
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the section label, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "submenu"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuModel with the items of the submenu"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "MenuItem" })
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_new_submenu" g_menu_item_new_submenu :: 
    CString ->                              -- label : TBasicType TUTF8
    Ptr Gio.MenuModel.MenuModel ->          -- submenu : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO (Ptr MenuItem)

-- | Creates a new t'GI.Gio.Objects.MenuItem.MenuItem' representing a submenu.
-- 
-- This is a convenience API around 'GI.Gio.Objects.MenuItem.menuItemNew' and
-- 'GI.Gio.Objects.MenuItem.menuItemSetSubmenu'.
-- 
-- /Since: 2.32/
menuItemNewSubmenu ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.MenuModel.IsMenuModel a) =>
    Maybe (T.Text)
    -- ^ /@label@/: the section label, or 'P.Nothing'
    -> a
    -- ^ /@submenu@/: a t'GI.Gio.Objects.MenuModel.MenuModel' with the items of the submenu
    -> m MenuItem
    -- ^ __Returns:__ a new t'GI.Gio.Objects.MenuItem.MenuItem'
menuItemNewSubmenu label submenu = liftIO $ do
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    submenu' <- unsafeManagedPtrCastPtr submenu
    result <- g_menu_item_new_submenu maybeLabel submenu'
    checkUnexpectedReturnNULL "menuItemNewSubmenu" result
    result' <- (wrapObject MenuItem) result
    touchManagedPtr submenu
    freeMem maybeLabel
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MenuItem::get_attribute_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_item"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuItem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attribute"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the attribute name to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expected_type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantType" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expected type of the attribute"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_get_attribute_value" g_menu_item_get_attribute_value :: 
    Ptr MenuItem ->                         -- menu_item : TInterface (Name {namespace = "Gio", name = "MenuItem"})
    CString ->                              -- attribute : TBasicType TUTF8
    Ptr GLib.VariantType.VariantType ->     -- expected_type : TInterface (Name {namespace = "GLib", name = "VariantType"})
    IO (Ptr GVariant)

-- | Queries the named /@attribute@/ on /@menuItem@/.
-- 
-- If /@expectedType@/ is specified and the attribute does not have this
-- type, 'P.Nothing' is returned.  'P.Nothing' is also returned if the attribute
-- simply does not exist.
-- 
-- /Since: 2.34/
menuItemGetAttributeValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuItem a) =>
    a
    -- ^ /@menuItem@/: a t'GI.Gio.Objects.MenuItem.MenuItem'
    -> T.Text
    -- ^ /@attribute@/: the attribute name to query
    -> Maybe (GLib.VariantType.VariantType)
    -- ^ /@expectedType@/: the expected type of the attribute
    -> m (Maybe GVariant)
    -- ^ __Returns:__ the attribute value, or 'P.Nothing'
menuItemGetAttributeValue menuItem attribute expectedType = liftIO $ do
    menuItem' <- unsafeManagedPtrCastPtr menuItem
    attribute' <- textToCString attribute
    maybeExpectedType <- case expectedType of
        Nothing -> return FP.nullPtr
        Just jExpectedType -> do
            jExpectedType' <- unsafeManagedPtrGetPtr jExpectedType
            return jExpectedType'
    result <- g_menu_item_get_attribute_value menuItem' attribute' maybeExpectedType
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- B.GVariant.wrapGVariantPtr result'
        return result''
    touchManagedPtr menuItem
    whenJust expectedType touchManagedPtr
    freeMem attribute'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuItemGetAttributeValueMethodInfo
instance (signature ~ (T.Text -> Maybe (GLib.VariantType.VariantType) -> m (Maybe GVariant)), MonadIO m, IsMenuItem a) => O.OverloadedMethod MenuItemGetAttributeValueMethodInfo a signature where
    overloadedMethod = menuItemGetAttributeValue

instance O.OverloadedMethodInfo MenuItemGetAttributeValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuItem.menuItemGetAttributeValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuItem.html#v:menuItemGetAttributeValue"
        })


#endif

-- method MenuItem::get_link
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_item"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuItem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "link"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the link name to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "MenuModel" })
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_get_link" g_menu_item_get_link :: 
    Ptr MenuItem ->                         -- menu_item : TInterface (Name {namespace = "Gio", name = "MenuItem"})
    CString ->                              -- link : TBasicType TUTF8
    IO (Ptr Gio.MenuModel.MenuModel)

-- | Queries the named /@link@/ on /@menuItem@/.
-- 
-- /Since: 2.34/
menuItemGetLink ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuItem a) =>
    a
    -- ^ /@menuItem@/: a t'GI.Gio.Objects.MenuItem.MenuItem'
    -> T.Text
    -- ^ /@link@/: the link name to query
    -> m (Maybe Gio.MenuModel.MenuModel)
    -- ^ __Returns:__ the link, or 'P.Nothing'
menuItemGetLink menuItem link = liftIO $ do
    menuItem' <- unsafeManagedPtrCastPtr menuItem
    link' <- textToCString link
    result <- g_menu_item_get_link menuItem' link'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.MenuModel.MenuModel) result'
        return result''
    touchManagedPtr menuItem
    freeMem link'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MenuItemGetLinkMethodInfo
instance (signature ~ (T.Text -> m (Maybe Gio.MenuModel.MenuModel)), MonadIO m, IsMenuItem a) => O.OverloadedMethod MenuItemGetLinkMethodInfo a signature where
    overloadedMethod = menuItemGetLink

instance O.OverloadedMethodInfo MenuItemGetLinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuItem.menuItemGetLink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuItem.html#v:menuItemGetLink"
        })


#endif

-- method MenuItem::set_action_and_target_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_item"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuItem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the action for this item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "target_value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVariant to use as the action target"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_set_action_and_target_value" g_menu_item_set_action_and_target_value :: 
    Ptr MenuItem ->                         -- menu_item : TInterface (Name {namespace = "Gio", name = "MenuItem"})
    CString ->                              -- action : TBasicType TUTF8
    Ptr GVariant ->                         -- target_value : TVariant
    IO ()

-- | Sets or unsets the \"action\" and \"target\" attributes of /@menuItem@/.
-- 
-- If /@action@/ is 'P.Nothing' then both the \"action\" and \"target\" attributes
-- are unset (and /@targetValue@/ is ignored).
-- 
-- If /@action@/ is non-'P.Nothing' then the \"action\" attribute is set.  The
-- \"target\" attribute is then set to the value of /@targetValue@/ if it is
-- non-'P.Nothing' or unset otherwise.
-- 
-- Normal menu items (ie: not submenu, section or other custom item
-- types) are expected to have the \"action\" attribute set to identify
-- the action that they are associated with.  The state type of the
-- action help to determine the disposition of the menu item.  See
-- t'GI.Gio.Interfaces.Action.Action' and t'GI.Gio.Interfaces.ActionGroup.ActionGroup' for an overview of actions.
-- 
-- In general, clicking on the menu item will result in activation of
-- the named action with the \"target\" attribute given as the parameter
-- to the action invocation.  If the \"target\" attribute is not set then
-- the action is invoked with no parameter.
-- 
-- If the action has no state then the menu item is usually drawn as a
-- plain menu item (ie: with no additional decoration).
-- 
-- If the action has a boolean state then the menu item is usually drawn
-- as a toggle menu item (ie: with a checkmark or equivalent
-- indication).  The item should be marked as \'toggled\' or \'checked\'
-- when the boolean state is 'P.True'.
-- 
-- If the action has a string state then the menu item is usually drawn
-- as a radio menu item (ie: with a radio bullet or equivalent
-- indication).  The item should be marked as \'selected\' when the string
-- state is equal to the value of the /@target@/ property.
-- 
-- See @/g_menu_item_set_action_and_target()/@ or
-- 'GI.Gio.Objects.MenuItem.menuItemSetDetailedAction' for two equivalent calls that are
-- probably more convenient for most uses.
-- 
-- /Since: 2.32/
menuItemSetActionAndTargetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuItem a) =>
    a
    -- ^ /@menuItem@/: a t'GI.Gio.Objects.MenuItem.MenuItem'
    -> Maybe (T.Text)
    -- ^ /@action@/: the name of the action for this item
    -> Maybe (GVariant)
    -- ^ /@targetValue@/: a t'GVariant' to use as the action target
    -> m ()
menuItemSetActionAndTargetValue menuItem action targetValue = liftIO $ do
    menuItem' <- unsafeManagedPtrCastPtr menuItem
    maybeAction <- case action of
        Nothing -> return FP.nullPtr
        Just jAction -> do
            jAction' <- textToCString jAction
            return jAction'
    maybeTargetValue <- case targetValue of
        Nothing -> return FP.nullPtr
        Just jTargetValue -> do
            jTargetValue' <- unsafeManagedPtrGetPtr jTargetValue
            return jTargetValue'
    g_menu_item_set_action_and_target_value menuItem' maybeAction maybeTargetValue
    touchManagedPtr menuItem
    whenJust targetValue touchManagedPtr
    freeMem maybeAction
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuItemSetActionAndTargetValueMethodInfo
instance (signature ~ (Maybe (T.Text) -> Maybe (GVariant) -> m ()), MonadIO m, IsMenuItem a) => O.OverloadedMethod MenuItemSetActionAndTargetValueMethodInfo a signature where
    overloadedMethod = menuItemSetActionAndTargetValue

instance O.OverloadedMethodInfo MenuItemSetActionAndTargetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuItem.menuItemSetActionAndTargetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuItem.html#v:menuItemSetActionAndTargetValue"
        })


#endif

-- method MenuItem::set_attribute_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_item"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuItem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attribute"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the attribute to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVariant to use as the value, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_set_attribute_value" g_menu_item_set_attribute_value :: 
    Ptr MenuItem ->                         -- menu_item : TInterface (Name {namespace = "Gio", name = "MenuItem"})
    CString ->                              -- attribute : TBasicType TUTF8
    Ptr GVariant ->                         -- value : TVariant
    IO ()

-- | Sets or unsets an attribute on /@menuItem@/.
-- 
-- The attribute to set or unset is specified by /@attribute@/. This
-- can be one of the standard attribute names 'GI.Gio.Constants.MENU_ATTRIBUTE_LABEL',
-- 'GI.Gio.Constants.MENU_ATTRIBUTE_ACTION', 'GI.Gio.Constants.MENU_ATTRIBUTE_TARGET', or a custom
-- attribute name.
-- Attribute names are restricted to lowercase characters, numbers
-- and \'-\'. Furthermore, the names must begin with a lowercase character,
-- must not end with a \'-\', and must not contain consecutive dashes.
-- 
-- must consist only of lowercase
-- ASCII characters, digits and \'-\'.
-- 
-- If /@value@/ is non-'P.Nothing' then it is used as the new value for the
-- attribute.  If /@value@/ is 'P.Nothing' then the attribute is unset. If
-- the /@value@/ t'GVariant' is floating, it is consumed.
-- 
-- See also @/g_menu_item_set_attribute()/@ for a more convenient way to do
-- the same.
-- 
-- /Since: 2.32/
menuItemSetAttributeValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuItem a) =>
    a
    -- ^ /@menuItem@/: a t'GI.Gio.Objects.MenuItem.MenuItem'
    -> T.Text
    -- ^ /@attribute@/: the attribute to set
    -> Maybe (GVariant)
    -- ^ /@value@/: a t'GVariant' to use as the value, or 'P.Nothing'
    -> m ()
menuItemSetAttributeValue menuItem attribute value = liftIO $ do
    menuItem' <- unsafeManagedPtrCastPtr menuItem
    attribute' <- textToCString attribute
    maybeValue <- case value of
        Nothing -> return FP.nullPtr
        Just jValue -> do
            jValue' <- unsafeManagedPtrGetPtr jValue
            return jValue'
    g_menu_item_set_attribute_value menuItem' attribute' maybeValue
    touchManagedPtr menuItem
    whenJust value touchManagedPtr
    freeMem attribute'
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuItemSetAttributeValueMethodInfo
instance (signature ~ (T.Text -> Maybe (GVariant) -> m ()), MonadIO m, IsMenuItem a) => O.OverloadedMethod MenuItemSetAttributeValueMethodInfo a signature where
    overloadedMethod = menuItemSetAttributeValue

instance O.OverloadedMethodInfo MenuItemSetAttributeValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuItem.menuItemSetAttributeValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuItem.html#v:menuItemSetAttributeValue"
        })


#endif

-- method MenuItem::set_detailed_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_item"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuItem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "detailed_action"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the \"detailed\" action string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_set_detailed_action" g_menu_item_set_detailed_action :: 
    Ptr MenuItem ->                         -- menu_item : TInterface (Name {namespace = "Gio", name = "MenuItem"})
    CString ->                              -- detailed_action : TBasicType TUTF8
    IO ()

-- | Sets the \"action\" and possibly the \"target\" attribute of /@menuItem@/.
-- 
-- The format of /@detailedAction@/ is the same format parsed by
-- 'GI.Gio.Functions.actionParseDetailedName'.
-- 
-- See @/g_menu_item_set_action_and_target()/@ or
-- 'GI.Gio.Objects.MenuItem.menuItemSetActionAndTargetValue' for more flexible (but
-- slightly less convenient) alternatives.
-- 
-- See also 'GI.Gio.Objects.MenuItem.menuItemSetActionAndTargetValue' for a description of
-- the semantics of the action and target attributes.
-- 
-- /Since: 2.32/
menuItemSetDetailedAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuItem a) =>
    a
    -- ^ /@menuItem@/: a t'GI.Gio.Objects.MenuItem.MenuItem'
    -> T.Text
    -- ^ /@detailedAction@/: the \"detailed\" action string
    -> m ()
menuItemSetDetailedAction menuItem detailedAction = liftIO $ do
    menuItem' <- unsafeManagedPtrCastPtr menuItem
    detailedAction' <- textToCString detailedAction
    g_menu_item_set_detailed_action menuItem' detailedAction'
    touchManagedPtr menuItem
    freeMem detailedAction'
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuItemSetDetailedActionMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsMenuItem a) => O.OverloadedMethod MenuItemSetDetailedActionMethodInfo a signature where
    overloadedMethod = menuItemSetDetailedAction

instance O.OverloadedMethodInfo MenuItemSetDetailedActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuItem.menuItemSetDetailedAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuItem.html#v:menuItemSetDetailedAction"
        })


#endif

-- method MenuItem::set_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_item"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuItem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIcon, or %NULL" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_set_icon" g_menu_item_set_icon :: 
    Ptr MenuItem ->                         -- menu_item : TInterface (Name {namespace = "Gio", name = "MenuItem"})
    Ptr Gio.Icon.Icon ->                    -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    IO ()

-- | Sets (or unsets) the icon on /@menuItem@/.
-- 
-- This call is the same as calling 'GI.Gio.Interfaces.Icon.iconSerialize' and using the
-- result as the value to 'GI.Gio.Objects.MenuItem.menuItemSetAttributeValue' for
-- 'GI.Gio.Constants.MENU_ATTRIBUTE_ICON'.
-- 
-- This API is only intended for use with \"noun\" menu items; things like
-- bookmarks or applications in an \"Open With\" menu.  Don\'t use it on
-- menu items corresponding to verbs (eg: stock icons for \'Save\' or
-- \'Quit\').
-- 
-- If /@icon@/ is 'P.Nothing' then the icon is unset.
-- 
-- /Since: 2.38/
menuItemSetIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuItem a, Gio.Icon.IsIcon b) =>
    a
    -- ^ /@menuItem@/: a t'GI.Gio.Objects.MenuItem.MenuItem'
    -> b
    -- ^ /@icon@/: a t'GI.Gio.Interfaces.Icon.Icon', or 'P.Nothing'
    -> m ()
menuItemSetIcon menuItem icon = liftIO $ do
    menuItem' <- unsafeManagedPtrCastPtr menuItem
    icon' <- unsafeManagedPtrCastPtr icon
    g_menu_item_set_icon menuItem' icon'
    touchManagedPtr menuItem
    touchManagedPtr icon
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuItemSetIconMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMenuItem a, Gio.Icon.IsIcon b) => O.OverloadedMethod MenuItemSetIconMethodInfo a signature where
    overloadedMethod = menuItemSetIcon

instance O.OverloadedMethodInfo MenuItemSetIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuItem.menuItemSetIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuItem.html#v:menuItemSetIcon"
        })


#endif

-- method MenuItem::set_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_item"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuItem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the label to set, or %NULL to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_set_label" g_menu_item_set_label :: 
    Ptr MenuItem ->                         -- menu_item : TInterface (Name {namespace = "Gio", name = "MenuItem"})
    CString ->                              -- label : TBasicType TUTF8
    IO ()

-- | Sets or unsets the \"label\" attribute of /@menuItem@/.
-- 
-- If /@label@/ is non-'P.Nothing' it is used as the label for the menu item.  If
-- it is 'P.Nothing' then the label attribute is unset.
-- 
-- /Since: 2.32/
menuItemSetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuItem a) =>
    a
    -- ^ /@menuItem@/: a t'GI.Gio.Objects.MenuItem.MenuItem'
    -> Maybe (T.Text)
    -- ^ /@label@/: the label to set, or 'P.Nothing' to unset
    -> m ()
menuItemSetLabel menuItem label = liftIO $ do
    menuItem' <- unsafeManagedPtrCastPtr menuItem
    maybeLabel <- case label of
        Nothing -> return FP.nullPtr
        Just jLabel -> do
            jLabel' <- textToCString jLabel
            return jLabel'
    g_menu_item_set_label menuItem' maybeLabel
    touchManagedPtr menuItem
    freeMem maybeLabel
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuItemSetLabelMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsMenuItem a) => O.OverloadedMethod MenuItemSetLabelMethodInfo a signature where
    overloadedMethod = menuItemSetLabel

instance O.OverloadedMethodInfo MenuItemSetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuItem.menuItemSetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuItem.html#v:menuItemSetLabel"
        })


#endif

-- method MenuItem::set_link
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_item"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuItem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "link"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "type of link to establish or unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GMenuModel to link to (or %NULL to unset)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_set_link" g_menu_item_set_link :: 
    Ptr MenuItem ->                         -- menu_item : TInterface (Name {namespace = "Gio", name = "MenuItem"})
    CString ->                              -- link : TBasicType TUTF8
    Ptr Gio.MenuModel.MenuModel ->          -- model : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO ()

-- | Creates a link from /@menuItem@/ to /@model@/ if non-'P.Nothing', or unsets it.
-- 
-- Links are used to establish a relationship between a particular menu
-- item and another menu.  For example, 'GI.Gio.Constants.MENU_LINK_SUBMENU' is used to
-- associate a submenu with a particular menu item, and 'GI.Gio.Constants.MENU_LINK_SECTION'
-- is used to create a section. Other types of link can be used, but there
-- is no guarantee that clients will be able to make sense of them.
-- Link types are restricted to lowercase characters, numbers
-- and \'-\'. Furthermore, the names must begin with a lowercase character,
-- must not end with a \'-\', and must not contain consecutive dashes.
-- 
-- /Since: 2.32/
menuItemSetLink ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuItem a, Gio.MenuModel.IsMenuModel b) =>
    a
    -- ^ /@menuItem@/: a t'GI.Gio.Objects.MenuItem.MenuItem'
    -> T.Text
    -- ^ /@link@/: type of link to establish or unset
    -> Maybe (b)
    -- ^ /@model@/: the t'GI.Gio.Objects.MenuModel.MenuModel' to link to (or 'P.Nothing' to unset)
    -> m ()
menuItemSetLink menuItem link model = liftIO $ do
    menuItem' <- unsafeManagedPtrCastPtr menuItem
    link' <- textToCString link
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    g_menu_item_set_link menuItem' link' maybeModel
    touchManagedPtr menuItem
    whenJust model touchManagedPtr
    freeMem link'
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuItemSetLinkMethodInfo
instance (signature ~ (T.Text -> Maybe (b) -> m ()), MonadIO m, IsMenuItem a, Gio.MenuModel.IsMenuModel b) => O.OverloadedMethod MenuItemSetLinkMethodInfo a signature where
    overloadedMethod = menuItemSetLink

instance O.OverloadedMethodInfo MenuItemSetLinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuItem.menuItemSetLink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuItem.html#v:menuItemSetLink"
        })


#endif

-- method MenuItem::set_section
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_item"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuItem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "section"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuModel, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_set_section" g_menu_item_set_section :: 
    Ptr MenuItem ->                         -- menu_item : TInterface (Name {namespace = "Gio", name = "MenuItem"})
    Ptr Gio.MenuModel.MenuModel ->          -- section : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO ()

-- | Sets or unsets the \"section\" link of /@menuItem@/ to /@section@/.
-- 
-- The effect of having one menu appear as a section of another is
-- exactly as it sounds: the items from /@section@/ become a direct part of
-- the menu that /@menuItem@/ is added to.  See 'GI.Gio.Objects.MenuItem.menuItemNewSection'
-- for more information about what it means for a menu item to be a
-- section.
-- 
-- /Since: 2.32/
menuItemSetSection ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuItem a, Gio.MenuModel.IsMenuModel b) =>
    a
    -- ^ /@menuItem@/: a t'GI.Gio.Objects.MenuItem.MenuItem'
    -> Maybe (b)
    -- ^ /@section@/: a t'GI.Gio.Objects.MenuModel.MenuModel', or 'P.Nothing'
    -> m ()
menuItemSetSection menuItem section = liftIO $ do
    menuItem' <- unsafeManagedPtrCastPtr menuItem
    maybeSection <- case section of
        Nothing -> return FP.nullPtr
        Just jSection -> do
            jSection' <- unsafeManagedPtrCastPtr jSection
            return jSection'
    g_menu_item_set_section menuItem' maybeSection
    touchManagedPtr menuItem
    whenJust section touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuItemSetSectionMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMenuItem a, Gio.MenuModel.IsMenuModel b) => O.OverloadedMethod MenuItemSetSectionMethodInfo a signature where
    overloadedMethod = menuItemSetSection

instance O.OverloadedMethodInfo MenuItemSetSectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuItem.menuItemSetSection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuItem.html#v:menuItemSetSection"
        })


#endif

-- method MenuItem::set_submenu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "menu_item"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuItem" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuItem" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "submenu"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMenuModel, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_menu_item_set_submenu" g_menu_item_set_submenu :: 
    Ptr MenuItem ->                         -- menu_item : TInterface (Name {namespace = "Gio", name = "MenuItem"})
    Ptr Gio.MenuModel.MenuModel ->          -- submenu : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO ()

-- | Sets or unsets the \"submenu\" link of /@menuItem@/ to /@submenu@/.
-- 
-- If /@submenu@/ is non-'P.Nothing', it is linked to.  If it is 'P.Nothing' then the
-- link is unset.
-- 
-- The effect of having one menu appear as a submenu of another is
-- exactly as it sounds.
-- 
-- /Since: 2.32/
menuItemSetSubmenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsMenuItem a, Gio.MenuModel.IsMenuModel b) =>
    a
    -- ^ /@menuItem@/: a t'GI.Gio.Objects.MenuItem.MenuItem'
    -> Maybe (b)
    -- ^ /@submenu@/: a t'GI.Gio.Objects.MenuModel.MenuModel', or 'P.Nothing'
    -> m ()
menuItemSetSubmenu menuItem submenu = liftIO $ do
    menuItem' <- unsafeManagedPtrCastPtr menuItem
    maybeSubmenu <- case submenu of
        Nothing -> return FP.nullPtr
        Just jSubmenu -> do
            jSubmenu' <- unsafeManagedPtrCastPtr jSubmenu
            return jSubmenu'
    g_menu_item_set_submenu menuItem' maybeSubmenu
    touchManagedPtr menuItem
    whenJust submenu touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MenuItemSetSubmenuMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsMenuItem a, Gio.MenuModel.IsMenuModel b) => O.OverloadedMethod MenuItemSetSubmenuMethodInfo a signature where
    overloadedMethod = menuItemSetSubmenu

instance O.OverloadedMethodInfo MenuItemSetSubmenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MenuItem.menuItemSetSubmenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MenuItem.html#v:menuItemSetSubmenu"
        })


#endif


