{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GMemoryOutputStream@ is a class for using arbitrary
-- memory chunks as output for GIO streaming output operations.
-- 
-- As of GLib 2.34, @GMemoryOutputStream@ trivially implements
-- t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream': it always polls as ready.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.MemoryOutputStream
    ( 

-- * Exported types
    MemoryOutputStream(..)                  ,
    IsMemoryOutputStream                    ,
    toMemoryOutputStream                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canPoll]("GI.Gio.Interfaces.PollableOutputStream#g:method:canPoll"), [canSeek]("GI.Gio.Interfaces.Seekable#g:method:canSeek"), [canTruncate]("GI.Gio.Interfaces.Seekable#g:method:canTruncate"), [clearPending]("GI.Gio.Objects.OutputStream#g:method:clearPending"), [close]("GI.Gio.Objects.OutputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.OutputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.OutputStream#g:method:closeFinish"), [createSource]("GI.Gio.Interfaces.PollableOutputStream#g:method:createSource"), [flush]("GI.Gio.Objects.OutputStream#g:method:flush"), [flushAsync]("GI.Gio.Objects.OutputStream#g:method:flushAsync"), [flushFinish]("GI.Gio.Objects.OutputStream#g:method:flushFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.OutputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.OutputStream#g:method:isClosed"), [isClosing]("GI.Gio.Objects.OutputStream#g:method:isClosing"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isWritable]("GI.Gio.Interfaces.PollableOutputStream#g:method:isWritable"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [seek]("GI.Gio.Interfaces.Seekable#g:method:seek"), [splice]("GI.Gio.Objects.OutputStream#g:method:splice"), [spliceAsync]("GI.Gio.Objects.OutputStream#g:method:spliceAsync"), [spliceFinish]("GI.Gio.Objects.OutputStream#g:method:spliceFinish"), [stealAsBytes]("GI.Gio.Objects.MemoryOutputStream#g:method:stealAsBytes"), [stealData]("GI.Gio.Objects.MemoryOutputStream#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [tell]("GI.Gio.Interfaces.Seekable#g:method:tell"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [truncate]("GI.Gio.Interfaces.Seekable#g:method:truncate"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [write]("GI.Gio.Objects.OutputStream#g:method:write"), [writeAll]("GI.Gio.Objects.OutputStream#g:method:writeAll"), [writeAllAsync]("GI.Gio.Objects.OutputStream#g:method:writeAllAsync"), [writeAllFinish]("GI.Gio.Objects.OutputStream#g:method:writeAllFinish"), [writeAsync]("GI.Gio.Objects.OutputStream#g:method:writeAsync"), [writeBytes]("GI.Gio.Objects.OutputStream#g:method:writeBytes"), [writeBytesAsync]("GI.Gio.Objects.OutputStream#g:method:writeBytesAsync"), [writeBytesFinish]("GI.Gio.Objects.OutputStream#g:method:writeBytesFinish"), [writeFinish]("GI.Gio.Objects.OutputStream#g:method:writeFinish"), [writeNonblocking]("GI.Gio.Interfaces.PollableOutputStream#g:method:writeNonblocking"), [writev]("GI.Gio.Objects.OutputStream#g:method:writev"), [writevAll]("GI.Gio.Objects.OutputStream#g:method:writevAll"), [writevAllAsync]("GI.Gio.Objects.OutputStream#g:method:writevAllAsync"), [writevAllFinish]("GI.Gio.Objects.OutputStream#g:method:writevAllFinish"), [writevAsync]("GI.Gio.Objects.OutputStream#g:method:writevAsync"), [writevFinish]("GI.Gio.Objects.OutputStream#g:method:writevFinish"), [writevNonblocking]("GI.Gio.Interfaces.PollableOutputStream#g:method:writevNonblocking").
-- 
-- ==== Getters
-- [getData]("GI.Gio.Objects.MemoryOutputStream#g:method:getData"), [getDataSize]("GI.Gio.Objects.MemoryOutputStream#g:method:getDataSize"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSize]("GI.Gio.Objects.MemoryOutputStream#g:method:getSize").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.OutputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMemoryOutputStreamMethod         ,
#endif

-- ** getData #method:getData#

#if defined(ENABLE_OVERLOADING)
    MemoryOutputStreamGetDataMethodInfo     ,
#endif
    memoryOutputStreamGetData               ,


-- ** getDataSize #method:getDataSize#

#if defined(ENABLE_OVERLOADING)
    MemoryOutputStreamGetDataSizeMethodInfo ,
#endif
    memoryOutputStreamGetDataSize           ,


-- ** getSize #method:getSize#

#if defined(ENABLE_OVERLOADING)
    MemoryOutputStreamGetSizeMethodInfo     ,
#endif
    memoryOutputStreamGetSize               ,


-- ** newResizable #method:newResizable#

    memoryOutputStreamNewResizable          ,


-- ** stealAsBytes #method:stealAsBytes#

#if defined(ENABLE_OVERLOADING)
    MemoryOutputStreamStealAsBytesMethodInfo,
#endif
    memoryOutputStreamStealAsBytes          ,


-- ** stealData #method:stealData#

#if defined(ENABLE_OVERLOADING)
    MemoryOutputStreamStealDataMethodInfo   ,
#endif
    memoryOutputStreamStealData             ,




 -- * Properties


-- ** data #attr:data#
-- | Pointer to buffer where data will be written.
-- 
-- /Since: 2.24/

#if defined(ENABLE_OVERLOADING)
    MemoryOutputStreamDataPropertyInfo      ,
#endif
    constructMemoryOutputStreamData         ,
    getMemoryOutputStreamData               ,
#if defined(ENABLE_OVERLOADING)
    memoryOutputStreamData                  ,
#endif


-- ** dataSize #attr:dataSize#
-- | Size of data written to the buffer.
-- 
-- /Since: 2.24/

#if defined(ENABLE_OVERLOADING)
    MemoryOutputStreamDataSizePropertyInfo  ,
#endif
    getMemoryOutputStreamDataSize           ,
#if defined(ENABLE_OVERLOADING)
    memoryOutputStreamDataSize              ,
#endif


-- ** size #attr:size#
-- | Current size of the data buffer.
-- 
-- /Since: 2.24/

#if defined(ENABLE_OVERLOADING)
    MemoryOutputStreamSizePropertyInfo      ,
#endif
    constructMemoryOutputStreamSize         ,
    getMemoryOutputStreamSize               ,
#if defined(ENABLE_OVERLOADING)
    memoryOutputStreamSize                  ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableOutputStream as Gio.PollableOutputStream
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableOutputStream as Gio.PollableOutputStream
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#endif

-- | Memory-managed wrapper type.
newtype MemoryOutputStream = MemoryOutputStream (SP.ManagedPtr MemoryOutputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype MemoryOutputStream where
    toManagedPtr (MemoryOutputStream p) = p

foreign import ccall "g_memory_output_stream_get_type"
    c_g_memory_output_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject MemoryOutputStream where
    glibType = c_g_memory_output_stream_get_type

instance B.Types.GObject MemoryOutputStream

-- | Type class for types which can be safely cast to `MemoryOutputStream`, for instance with `toMemoryOutputStream`.
class (SP.GObject o, O.IsDescendantOf MemoryOutputStream o) => IsMemoryOutputStream o
instance (SP.GObject o, O.IsDescendantOf MemoryOutputStream o) => IsMemoryOutputStream o

instance O.HasParentTypes MemoryOutputStream
type instance O.ParentTypes MemoryOutputStream = '[Gio.OutputStream.OutputStream, GObject.Object.Object, Gio.PollableOutputStream.PollableOutputStream, Gio.Seekable.Seekable]

-- | Cast to `MemoryOutputStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMemoryOutputStream :: (MIO.MonadIO m, IsMemoryOutputStream o) => o -> m MemoryOutputStream
toMemoryOutputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo MemoryOutputStream

-- | Convert 'MemoryOutputStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MemoryOutputStream) where
    gvalueGType_ = c_g_memory_output_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MemoryOutputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MemoryOutputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MemoryOutputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMemoryOutputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMemoryOutputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMemoryOutputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMemoryOutputStreamMethod "canPoll" o = Gio.PollableOutputStream.PollableOutputStreamCanPollMethodInfo
    ResolveMemoryOutputStreamMethod "canSeek" o = Gio.Seekable.SeekableCanSeekMethodInfo
    ResolveMemoryOutputStreamMethod "canTruncate" o = Gio.Seekable.SeekableCanTruncateMethodInfo
    ResolveMemoryOutputStreamMethod "clearPending" o = Gio.OutputStream.OutputStreamClearPendingMethodInfo
    ResolveMemoryOutputStreamMethod "close" o = Gio.OutputStream.OutputStreamCloseMethodInfo
    ResolveMemoryOutputStreamMethod "closeAsync" o = Gio.OutputStream.OutputStreamCloseAsyncMethodInfo
    ResolveMemoryOutputStreamMethod "closeFinish" o = Gio.OutputStream.OutputStreamCloseFinishMethodInfo
    ResolveMemoryOutputStreamMethod "createSource" o = Gio.PollableOutputStream.PollableOutputStreamCreateSourceMethodInfo
    ResolveMemoryOutputStreamMethod "flush" o = Gio.OutputStream.OutputStreamFlushMethodInfo
    ResolveMemoryOutputStreamMethod "flushAsync" o = Gio.OutputStream.OutputStreamFlushAsyncMethodInfo
    ResolveMemoryOutputStreamMethod "flushFinish" o = Gio.OutputStream.OutputStreamFlushFinishMethodInfo
    ResolveMemoryOutputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMemoryOutputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMemoryOutputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMemoryOutputStreamMethod "hasPending" o = Gio.OutputStream.OutputStreamHasPendingMethodInfo
    ResolveMemoryOutputStreamMethod "isClosed" o = Gio.OutputStream.OutputStreamIsClosedMethodInfo
    ResolveMemoryOutputStreamMethod "isClosing" o = Gio.OutputStream.OutputStreamIsClosingMethodInfo
    ResolveMemoryOutputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMemoryOutputStreamMethod "isWritable" o = Gio.PollableOutputStream.PollableOutputStreamIsWritableMethodInfo
    ResolveMemoryOutputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMemoryOutputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMemoryOutputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMemoryOutputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMemoryOutputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMemoryOutputStreamMethod "seek" o = Gio.Seekable.SeekableSeekMethodInfo
    ResolveMemoryOutputStreamMethod "splice" o = Gio.OutputStream.OutputStreamSpliceMethodInfo
    ResolveMemoryOutputStreamMethod "spliceAsync" o = Gio.OutputStream.OutputStreamSpliceAsyncMethodInfo
    ResolveMemoryOutputStreamMethod "spliceFinish" o = Gio.OutputStream.OutputStreamSpliceFinishMethodInfo
    ResolveMemoryOutputStreamMethod "stealAsBytes" o = MemoryOutputStreamStealAsBytesMethodInfo
    ResolveMemoryOutputStreamMethod "stealData" o = MemoryOutputStreamStealDataMethodInfo
    ResolveMemoryOutputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMemoryOutputStreamMethod "tell" o = Gio.Seekable.SeekableTellMethodInfo
    ResolveMemoryOutputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMemoryOutputStreamMethod "truncate" o = Gio.Seekable.SeekableTruncateMethodInfo
    ResolveMemoryOutputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMemoryOutputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMemoryOutputStreamMethod "write" o = Gio.OutputStream.OutputStreamWriteMethodInfo
    ResolveMemoryOutputStreamMethod "writeAll" o = Gio.OutputStream.OutputStreamWriteAllMethodInfo
    ResolveMemoryOutputStreamMethod "writeAllAsync" o = Gio.OutputStream.OutputStreamWriteAllAsyncMethodInfo
    ResolveMemoryOutputStreamMethod "writeAllFinish" o = Gio.OutputStream.OutputStreamWriteAllFinishMethodInfo
    ResolveMemoryOutputStreamMethod "writeAsync" o = Gio.OutputStream.OutputStreamWriteAsyncMethodInfo
    ResolveMemoryOutputStreamMethod "writeBytes" o = Gio.OutputStream.OutputStreamWriteBytesMethodInfo
    ResolveMemoryOutputStreamMethod "writeBytesAsync" o = Gio.OutputStream.OutputStreamWriteBytesAsyncMethodInfo
    ResolveMemoryOutputStreamMethod "writeBytesFinish" o = Gio.OutputStream.OutputStreamWriteBytesFinishMethodInfo
    ResolveMemoryOutputStreamMethod "writeFinish" o = Gio.OutputStream.OutputStreamWriteFinishMethodInfo
    ResolveMemoryOutputStreamMethod "writeNonblocking" o = Gio.PollableOutputStream.PollableOutputStreamWriteNonblockingMethodInfo
    ResolveMemoryOutputStreamMethod "writev" o = Gio.OutputStream.OutputStreamWritevMethodInfo
    ResolveMemoryOutputStreamMethod "writevAll" o = Gio.OutputStream.OutputStreamWritevAllMethodInfo
    ResolveMemoryOutputStreamMethod "writevAllAsync" o = Gio.OutputStream.OutputStreamWritevAllAsyncMethodInfo
    ResolveMemoryOutputStreamMethod "writevAllFinish" o = Gio.OutputStream.OutputStreamWritevAllFinishMethodInfo
    ResolveMemoryOutputStreamMethod "writevAsync" o = Gio.OutputStream.OutputStreamWritevAsyncMethodInfo
    ResolveMemoryOutputStreamMethod "writevFinish" o = Gio.OutputStream.OutputStreamWritevFinishMethodInfo
    ResolveMemoryOutputStreamMethod "writevNonblocking" o = Gio.PollableOutputStream.PollableOutputStreamWritevNonblockingMethodInfo
    ResolveMemoryOutputStreamMethod "getData" o = MemoryOutputStreamGetDataMethodInfo
    ResolveMemoryOutputStreamMethod "getDataSize" o = MemoryOutputStreamGetDataSizeMethodInfo
    ResolveMemoryOutputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMemoryOutputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMemoryOutputStreamMethod "getSize" o = MemoryOutputStreamGetSizeMethodInfo
    ResolveMemoryOutputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMemoryOutputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMemoryOutputStreamMethod "setPending" o = Gio.OutputStream.OutputStreamSetPendingMethodInfo
    ResolveMemoryOutputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMemoryOutputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMemoryOutputStreamMethod t MemoryOutputStream, O.OverloadedMethod info MemoryOutputStream p) => OL.IsLabel t (MemoryOutputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMemoryOutputStreamMethod t MemoryOutputStream, O.OverloadedMethod info MemoryOutputStream p, R.HasField t MemoryOutputStream p) => R.HasField t MemoryOutputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMemoryOutputStreamMethod t MemoryOutputStream, O.OverloadedMethodInfo info MemoryOutputStream) => OL.IsLabel t (O.MethodProxy info MemoryOutputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "data"
   -- Type: TBasicType TPtr
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@data@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryOutputStream #data
-- @
getMemoryOutputStreamData :: (MonadIO m, IsMemoryOutputStream o) => o -> m (Ptr ())
getMemoryOutputStreamData obj = MIO.liftIO $ B.Properties.getObjectPropertyPtr obj "data"

-- | Construct a `GValueConstruct` with valid value for the “@data@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMemoryOutputStreamData :: (IsMemoryOutputStream o, MIO.MonadIO m) => Ptr () -> m (GValueConstruct o)
constructMemoryOutputStreamData val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyPtr "data" val

#if defined(ENABLE_OVERLOADING)
data MemoryOutputStreamDataPropertyInfo
instance AttrInfo MemoryOutputStreamDataPropertyInfo where
    type AttrAllowedOps MemoryOutputStreamDataPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MemoryOutputStreamDataPropertyInfo = IsMemoryOutputStream
    type AttrSetTypeConstraint MemoryOutputStreamDataPropertyInfo = (~) (Ptr ())
    type AttrTransferTypeConstraint MemoryOutputStreamDataPropertyInfo = (~) (Ptr ())
    type AttrTransferType MemoryOutputStreamDataPropertyInfo = Ptr ()
    type AttrGetType MemoryOutputStreamDataPropertyInfo = (Ptr ())
    type AttrLabel MemoryOutputStreamDataPropertyInfo = "data"
    type AttrOrigin MemoryOutputStreamDataPropertyInfo = MemoryOutputStream
    attrGet = getMemoryOutputStreamData
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructMemoryOutputStreamData
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MemoryOutputStream.data"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MemoryOutputStream.html#g:attr:data"
        })
#endif

-- VVV Prop "data-size"
   -- Type: TBasicType TULong
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@data-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryOutputStream #dataSize
-- @
getMemoryOutputStreamDataSize :: (MonadIO m, IsMemoryOutputStream o) => o -> m FCT.CULong
getMemoryOutputStreamDataSize obj = MIO.liftIO $ B.Properties.getObjectPropertyULong obj "data-size"

#if defined(ENABLE_OVERLOADING)
data MemoryOutputStreamDataSizePropertyInfo
instance AttrInfo MemoryOutputStreamDataSizePropertyInfo where
    type AttrAllowedOps MemoryOutputStreamDataSizePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint MemoryOutputStreamDataSizePropertyInfo = IsMemoryOutputStream
    type AttrSetTypeConstraint MemoryOutputStreamDataSizePropertyInfo = (~) ()
    type AttrTransferTypeConstraint MemoryOutputStreamDataSizePropertyInfo = (~) ()
    type AttrTransferType MemoryOutputStreamDataSizePropertyInfo = ()
    type AttrGetType MemoryOutputStreamDataSizePropertyInfo = FCT.CULong
    type AttrLabel MemoryOutputStreamDataSizePropertyInfo = "data-size"
    type AttrOrigin MemoryOutputStreamDataSizePropertyInfo = MemoryOutputStream
    attrGet = getMemoryOutputStreamDataSize
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MemoryOutputStream.dataSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MemoryOutputStream.html#g:attr:dataSize"
        })
#endif

-- VVV Prop "size"
   -- Type: TBasicType TULong
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' memoryOutputStream #size
-- @
getMemoryOutputStreamSize :: (MonadIO m, IsMemoryOutputStream o) => o -> m FCT.CULong
getMemoryOutputStreamSize obj = MIO.liftIO $ B.Properties.getObjectPropertyULong obj "size"

-- | Construct a `GValueConstruct` with valid value for the “@size@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructMemoryOutputStreamSize :: (IsMemoryOutputStream o, MIO.MonadIO m) => FCT.CULong -> m (GValueConstruct o)
constructMemoryOutputStreamSize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyULong "size" val

#if defined(ENABLE_OVERLOADING)
data MemoryOutputStreamSizePropertyInfo
instance AttrInfo MemoryOutputStreamSizePropertyInfo where
    type AttrAllowedOps MemoryOutputStreamSizePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint MemoryOutputStreamSizePropertyInfo = IsMemoryOutputStream
    type AttrSetTypeConstraint MemoryOutputStreamSizePropertyInfo = (~) FCT.CULong
    type AttrTransferTypeConstraint MemoryOutputStreamSizePropertyInfo = (~) FCT.CULong
    type AttrTransferType MemoryOutputStreamSizePropertyInfo = FCT.CULong
    type AttrGetType MemoryOutputStreamSizePropertyInfo = FCT.CULong
    type AttrLabel MemoryOutputStreamSizePropertyInfo = "size"
    type AttrOrigin MemoryOutputStreamSizePropertyInfo = MemoryOutputStream
    attrGet = getMemoryOutputStreamSize
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructMemoryOutputStreamSize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MemoryOutputStream.size"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MemoryOutputStream.html#g:attr:size"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MemoryOutputStream
type instance O.AttributeList MemoryOutputStream = MemoryOutputStreamAttributeList
type MemoryOutputStreamAttributeList = ('[ '("data", MemoryOutputStreamDataPropertyInfo), '("dataSize", MemoryOutputStreamDataSizePropertyInfo), '("size", MemoryOutputStreamSizePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
memoryOutputStreamData :: AttrLabelProxy "data"
memoryOutputStreamData = AttrLabelProxy

memoryOutputStreamDataSize :: AttrLabelProxy "dataSize"
memoryOutputStreamDataSize = AttrLabelProxy

memoryOutputStreamSize :: AttrLabelProxy "size"
memoryOutputStreamSize = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MemoryOutputStream = MemoryOutputStreamSignalList
type MemoryOutputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MemoryOutputStream::new_resizable
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "MemoryOutputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_output_stream_new_resizable" g_memory_output_stream_new_resizable :: 
    IO (Ptr MemoryOutputStream)

-- | Creates a new t'GI.Gio.Objects.MemoryOutputStream.MemoryOutputStream', using 'GI.GLib.Functions.realloc' and 'GI.GLib.Functions.free'
-- for memory allocation.
-- 
-- /Since: 2.36/
memoryOutputStreamNewResizable ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m MemoryOutputStream
memoryOutputStreamNewResizable  = liftIO $ do
    result <- g_memory_output_stream_new_resizable
    checkUnexpectedReturnNULL "memoryOutputStreamNewResizable" result
    result' <- (wrapObject MemoryOutputStream) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MemoryOutputStream::get_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "ostream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MemoryOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMemoryOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_output_stream_get_data" g_memory_output_stream_get_data :: 
    Ptr MemoryOutputStream ->               -- ostream : TInterface (Name {namespace = "Gio", name = "MemoryOutputStream"})
    IO (Ptr ())

-- | Gets any loaded data from the /@ostream@/.
-- 
-- Note that the returned pointer may become invalid on the next
-- write or truncate operation on the stream.
memoryOutputStreamGetData ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryOutputStream a) =>
    a
    -- ^ /@ostream@/: a t'GI.Gio.Objects.MemoryOutputStream.MemoryOutputStream'
    -> m (Ptr ())
    -- ^ __Returns:__ pointer to the stream\'s data, or 'P.Nothing' if the data
    --    has been stolen
memoryOutputStreamGetData ostream = liftIO $ do
    ostream' <- unsafeManagedPtrCastPtr ostream
    result <- g_memory_output_stream_get_data ostream'
    touchManagedPtr ostream
    return result

#if defined(ENABLE_OVERLOADING)
data MemoryOutputStreamGetDataMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m, IsMemoryOutputStream a) => O.OverloadedMethod MemoryOutputStreamGetDataMethodInfo a signature where
    overloadedMethod = memoryOutputStreamGetData

instance O.OverloadedMethodInfo MemoryOutputStreamGetDataMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MemoryOutputStream.memoryOutputStreamGetData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MemoryOutputStream.html#v:memoryOutputStreamGetData"
        })


#endif

-- method MemoryOutputStream::get_data_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "ostream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MemoryOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMemoryOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_output_stream_get_data_size" g_memory_output_stream_get_data_size :: 
    Ptr MemoryOutputStream ->               -- ostream : TInterface (Name {namespace = "Gio", name = "MemoryOutputStream"})
    IO FCT.CSize

-- | Returns the number of bytes from the start up to including the last
-- byte written in the stream that has not been truncated away.
-- 
-- /Since: 2.18/
memoryOutputStreamGetDataSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryOutputStream a) =>
    a
    -- ^ /@ostream@/: a t'GI.Gio.Objects.MemoryOutputStream.MemoryOutputStream'
    -> m FCT.CSize
    -- ^ __Returns:__ the number of bytes written to the stream
memoryOutputStreamGetDataSize ostream = liftIO $ do
    ostream' <- unsafeManagedPtrCastPtr ostream
    result <- g_memory_output_stream_get_data_size ostream'
    touchManagedPtr ostream
    return result

#if defined(ENABLE_OVERLOADING)
data MemoryOutputStreamGetDataSizeMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsMemoryOutputStream a) => O.OverloadedMethod MemoryOutputStreamGetDataSizeMethodInfo a signature where
    overloadedMethod = memoryOutputStreamGetDataSize

instance O.OverloadedMethodInfo MemoryOutputStreamGetDataSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MemoryOutputStream.memoryOutputStreamGetDataSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MemoryOutputStream.html#v:memoryOutputStreamGetDataSize"
        })


#endif

-- method MemoryOutputStream::get_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "ostream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MemoryOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMemoryOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_output_stream_get_size" g_memory_output_stream_get_size :: 
    Ptr MemoryOutputStream ->               -- ostream : TInterface (Name {namespace = "Gio", name = "MemoryOutputStream"})
    IO FCT.CSize

-- | Gets the size of the currently allocated data area (available from
-- 'GI.Gio.Objects.MemoryOutputStream.memoryOutputStreamGetData').
-- 
-- You probably don\'t want to use this function on resizable streams.
-- See 'GI.Gio.Objects.MemoryOutputStream.memoryOutputStreamGetDataSize' instead.  For resizable
-- streams the size returned by this function is an implementation
-- detail and may be change at any time in response to operations on the
-- stream.
-- 
-- If the stream is fixed-sized (ie: no realloc was passed to
-- @/g_memory_output_stream_new()/@) then this is the maximum size of the
-- stream and further writes will return 'GI.Gio.Enums.IOErrorEnumNoSpace'.
-- 
-- In any case, if you want the number of bytes currently written to the
-- stream, use 'GI.Gio.Objects.MemoryOutputStream.memoryOutputStreamGetDataSize'.
memoryOutputStreamGetSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryOutputStream a) =>
    a
    -- ^ /@ostream@/: a t'GI.Gio.Objects.MemoryOutputStream.MemoryOutputStream'
    -> m FCT.CSize
    -- ^ __Returns:__ the number of bytes allocated for the data buffer
memoryOutputStreamGetSize ostream = liftIO $ do
    ostream' <- unsafeManagedPtrCastPtr ostream
    result <- g_memory_output_stream_get_size ostream'
    touchManagedPtr ostream
    return result

#if defined(ENABLE_OVERLOADING)
data MemoryOutputStreamGetSizeMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsMemoryOutputStream a) => O.OverloadedMethod MemoryOutputStreamGetSizeMethodInfo a signature where
    overloadedMethod = memoryOutputStreamGetSize

instance O.OverloadedMethodInfo MemoryOutputStreamGetSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MemoryOutputStream.memoryOutputStreamGetSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MemoryOutputStream.html#v:memoryOutputStreamGetSize"
        })


#endif

-- method MemoryOutputStream::steal_as_bytes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "ostream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MemoryOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMemoryOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Bytes" })
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_output_stream_steal_as_bytes" g_memory_output_stream_steal_as_bytes :: 
    Ptr MemoryOutputStream ->               -- ostream : TInterface (Name {namespace = "Gio", name = "MemoryOutputStream"})
    IO (Ptr GLib.Bytes.Bytes)

-- | Returns data from the /@ostream@/ as a t'GI.GLib.Structs.Bytes.Bytes'. /@ostream@/ must be
-- closed before calling this function.
-- 
-- /Since: 2.34/
memoryOutputStreamStealAsBytes ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryOutputStream a) =>
    a
    -- ^ /@ostream@/: a t'GI.Gio.Objects.MemoryOutputStream.MemoryOutputStream'
    -> m GLib.Bytes.Bytes
    -- ^ __Returns:__ the stream\'s data
memoryOutputStreamStealAsBytes ostream = liftIO $ do
    ostream' <- unsafeManagedPtrCastPtr ostream
    result <- g_memory_output_stream_steal_as_bytes ostream'
    checkUnexpectedReturnNULL "memoryOutputStreamStealAsBytes" result
    result' <- (wrapBoxed GLib.Bytes.Bytes) result
    touchManagedPtr ostream
    return result'

#if defined(ENABLE_OVERLOADING)
data MemoryOutputStreamStealAsBytesMethodInfo
instance (signature ~ (m GLib.Bytes.Bytes), MonadIO m, IsMemoryOutputStream a) => O.OverloadedMethod MemoryOutputStreamStealAsBytesMethodInfo a signature where
    overloadedMethod = memoryOutputStreamStealAsBytes

instance O.OverloadedMethodInfo MemoryOutputStreamStealAsBytesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MemoryOutputStream.memoryOutputStreamStealAsBytes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MemoryOutputStream.html#v:memoryOutputStreamStealAsBytes"
        })


#endif

-- method MemoryOutputStream::steal_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "ostream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MemoryOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMemoryOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_output_stream_steal_data" g_memory_output_stream_steal_data :: 
    Ptr MemoryOutputStream ->               -- ostream : TInterface (Name {namespace = "Gio", name = "MemoryOutputStream"})
    IO (Ptr ())

-- | Gets any loaded data from the /@ostream@/. Ownership of the data
-- is transferred to the caller; when no longer needed it must be
-- freed using the free function set in /@ostream@/\'s
-- t'GI.Gio.Objects.MemoryOutputStream.MemoryOutputStream':@/destroy-function/@ property.
-- 
-- /@ostream@/ must be closed before calling this function.
-- 
-- /Since: 2.26/
memoryOutputStreamStealData ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryOutputStream a) =>
    a
    -- ^ /@ostream@/: a t'GI.Gio.Objects.MemoryOutputStream.MemoryOutputStream'
    -> m (Ptr ())
    -- ^ __Returns:__ the stream\'s data, or 'P.Nothing' if it has previously
    --    been stolen
memoryOutputStreamStealData ostream = liftIO $ do
    ostream' <- unsafeManagedPtrCastPtr ostream
    result <- g_memory_output_stream_steal_data ostream'
    touchManagedPtr ostream
    return result

#if defined(ENABLE_OVERLOADING)
data MemoryOutputStreamStealDataMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m, IsMemoryOutputStream a) => O.OverloadedMethod MemoryOutputStreamStealDataMethodInfo a signature where
    overloadedMethod = memoryOutputStreamStealData

instance O.OverloadedMethodInfo MemoryOutputStreamStealDataMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MemoryOutputStream.memoryOutputStreamStealData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MemoryOutputStream.html#v:memoryOutputStreamStealData"
        })


#endif


