{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GMemoryInputStream@ is a class for using arbitrary
-- memory chunks as input for GIO streaming input operations.
-- 
-- As of GLib 2.34, @GMemoryInputStream@ implements
-- t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.MemoryInputStream
    ( 

-- * Exported types
    MemoryInputStream(..)                   ,
    IsMemoryInputStream                     ,
    toMemoryInputStream                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addBytes]("GI.Gio.Objects.MemoryInputStream#g:method:addBytes"), [addData]("GI.Gio.Objects.MemoryInputStream#g:method:addData"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canPoll]("GI.Gio.Interfaces.PollableInputStream#g:method:canPoll"), [canSeek]("GI.Gio.Interfaces.Seekable#g:method:canSeek"), [canTruncate]("GI.Gio.Interfaces.Seekable#g:method:canTruncate"), [clearPending]("GI.Gio.Objects.InputStream#g:method:clearPending"), [close]("GI.Gio.Objects.InputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.InputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.InputStream#g:method:closeFinish"), [createSource]("GI.Gio.Interfaces.PollableInputStream#g:method:createSource"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.InputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.InputStream#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isReadable]("GI.Gio.Interfaces.PollableInputStream#g:method:isReadable"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [read]("GI.Gio.Objects.InputStream#g:method:read"), [readAll]("GI.Gio.Objects.InputStream#g:method:readAll"), [readAllAsync]("GI.Gio.Objects.InputStream#g:method:readAllAsync"), [readAllFinish]("GI.Gio.Objects.InputStream#g:method:readAllFinish"), [readAsync]("GI.Gio.Objects.InputStream#g:method:readAsync"), [readBytes]("GI.Gio.Objects.InputStream#g:method:readBytes"), [readBytesAsync]("GI.Gio.Objects.InputStream#g:method:readBytesAsync"), [readBytesFinish]("GI.Gio.Objects.InputStream#g:method:readBytesFinish"), [readFinish]("GI.Gio.Objects.InputStream#g:method:readFinish"), [readNonblocking]("GI.Gio.Interfaces.PollableInputStream#g:method:readNonblocking"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [seek]("GI.Gio.Interfaces.Seekable#g:method:seek"), [skip]("GI.Gio.Objects.InputStream#g:method:skip"), [skipAsync]("GI.Gio.Objects.InputStream#g:method:skipAsync"), [skipFinish]("GI.Gio.Objects.InputStream#g:method:skipFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [tell]("GI.Gio.Interfaces.Seekable#g:method:tell"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [truncate]("GI.Gio.Interfaces.Seekable#g:method:truncate"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.InputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMemoryInputStreamMethod          ,
#endif

-- ** addBytes #method:addBytes#

#if defined(ENABLE_OVERLOADING)
    MemoryInputStreamAddBytesMethodInfo     ,
#endif
    memoryInputStreamAddBytes               ,


-- ** addData #method:addData#

#if defined(ENABLE_OVERLOADING)
    MemoryInputStreamAddDataMethodInfo      ,
#endif
    memoryInputStreamAddData                ,


-- ** new #method:new#

    memoryInputStreamNew                    ,


-- ** newFromBytes #method:newFromBytes#

    memoryInputStreamNewFromBytes           ,


-- ** newFromData #method:newFromData#

    memoryInputStreamNewFromData            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableInputStream as Gio.PollableInputStream
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableInputStream as Gio.PollableInputStream
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#endif

-- | Memory-managed wrapper type.
newtype MemoryInputStream = MemoryInputStream (SP.ManagedPtr MemoryInputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype MemoryInputStream where
    toManagedPtr (MemoryInputStream p) = p

foreign import ccall "g_memory_input_stream_get_type"
    c_g_memory_input_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject MemoryInputStream where
    glibType = c_g_memory_input_stream_get_type

instance B.Types.GObject MemoryInputStream

-- | Type class for types which can be safely cast to `MemoryInputStream`, for instance with `toMemoryInputStream`.
class (SP.GObject o, O.IsDescendantOf MemoryInputStream o) => IsMemoryInputStream o
instance (SP.GObject o, O.IsDescendantOf MemoryInputStream o) => IsMemoryInputStream o

instance O.HasParentTypes MemoryInputStream
type instance O.ParentTypes MemoryInputStream = '[Gio.InputStream.InputStream, GObject.Object.Object, Gio.PollableInputStream.PollableInputStream, Gio.Seekable.Seekable]

-- | Cast to `MemoryInputStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMemoryInputStream :: (MIO.MonadIO m, IsMemoryInputStream o) => o -> m MemoryInputStream
toMemoryInputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo MemoryInputStream

-- | Convert 'MemoryInputStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe MemoryInputStream) where
    gvalueGType_ = c_g_memory_input_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr MemoryInputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr MemoryInputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject MemoryInputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveMemoryInputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMemoryInputStreamMethod "addBytes" o = MemoryInputStreamAddBytesMethodInfo
    ResolveMemoryInputStreamMethod "addData" o = MemoryInputStreamAddDataMethodInfo
    ResolveMemoryInputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMemoryInputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMemoryInputStreamMethod "canPoll" o = Gio.PollableInputStream.PollableInputStreamCanPollMethodInfo
    ResolveMemoryInputStreamMethod "canSeek" o = Gio.Seekable.SeekableCanSeekMethodInfo
    ResolveMemoryInputStreamMethod "canTruncate" o = Gio.Seekable.SeekableCanTruncateMethodInfo
    ResolveMemoryInputStreamMethod "clearPending" o = Gio.InputStream.InputStreamClearPendingMethodInfo
    ResolveMemoryInputStreamMethod "close" o = Gio.InputStream.InputStreamCloseMethodInfo
    ResolveMemoryInputStreamMethod "closeAsync" o = Gio.InputStream.InputStreamCloseAsyncMethodInfo
    ResolveMemoryInputStreamMethod "closeFinish" o = Gio.InputStream.InputStreamCloseFinishMethodInfo
    ResolveMemoryInputStreamMethod "createSource" o = Gio.PollableInputStream.PollableInputStreamCreateSourceMethodInfo
    ResolveMemoryInputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMemoryInputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMemoryInputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMemoryInputStreamMethod "hasPending" o = Gio.InputStream.InputStreamHasPendingMethodInfo
    ResolveMemoryInputStreamMethod "isClosed" o = Gio.InputStream.InputStreamIsClosedMethodInfo
    ResolveMemoryInputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMemoryInputStreamMethod "isReadable" o = Gio.PollableInputStream.PollableInputStreamIsReadableMethodInfo
    ResolveMemoryInputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMemoryInputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMemoryInputStreamMethod "read" o = Gio.InputStream.InputStreamReadMethodInfo
    ResolveMemoryInputStreamMethod "readAll" o = Gio.InputStream.InputStreamReadAllMethodInfo
    ResolveMemoryInputStreamMethod "readAllAsync" o = Gio.InputStream.InputStreamReadAllAsyncMethodInfo
    ResolveMemoryInputStreamMethod "readAllFinish" o = Gio.InputStream.InputStreamReadAllFinishMethodInfo
    ResolveMemoryInputStreamMethod "readAsync" o = Gio.InputStream.InputStreamReadAsyncMethodInfo
    ResolveMemoryInputStreamMethod "readBytes" o = Gio.InputStream.InputStreamReadBytesMethodInfo
    ResolveMemoryInputStreamMethod "readBytesAsync" o = Gio.InputStream.InputStreamReadBytesAsyncMethodInfo
    ResolveMemoryInputStreamMethod "readBytesFinish" o = Gio.InputStream.InputStreamReadBytesFinishMethodInfo
    ResolveMemoryInputStreamMethod "readFinish" o = Gio.InputStream.InputStreamReadFinishMethodInfo
    ResolveMemoryInputStreamMethod "readNonblocking" o = Gio.PollableInputStream.PollableInputStreamReadNonblockingMethodInfo
    ResolveMemoryInputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMemoryInputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMemoryInputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMemoryInputStreamMethod "seek" o = Gio.Seekable.SeekableSeekMethodInfo
    ResolveMemoryInputStreamMethod "skip" o = Gio.InputStream.InputStreamSkipMethodInfo
    ResolveMemoryInputStreamMethod "skipAsync" o = Gio.InputStream.InputStreamSkipAsyncMethodInfo
    ResolveMemoryInputStreamMethod "skipFinish" o = Gio.InputStream.InputStreamSkipFinishMethodInfo
    ResolveMemoryInputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMemoryInputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMemoryInputStreamMethod "tell" o = Gio.Seekable.SeekableTellMethodInfo
    ResolveMemoryInputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMemoryInputStreamMethod "truncate" o = Gio.Seekable.SeekableTruncateMethodInfo
    ResolveMemoryInputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMemoryInputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMemoryInputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMemoryInputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMemoryInputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMemoryInputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMemoryInputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMemoryInputStreamMethod "setPending" o = Gio.InputStream.InputStreamSetPendingMethodInfo
    ResolveMemoryInputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMemoryInputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMemoryInputStreamMethod t MemoryInputStream, O.OverloadedMethod info MemoryInputStream p) => OL.IsLabel t (MemoryInputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMemoryInputStreamMethod t MemoryInputStream, O.OverloadedMethod info MemoryInputStream p, R.HasField t MemoryInputStream p) => R.HasField t MemoryInputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMemoryInputStreamMethod t MemoryInputStream, O.OverloadedMethodInfo info MemoryInputStream) => OL.IsLabel t (O.MethodProxy info MemoryInputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList MemoryInputStream
type instance O.AttributeList MemoryInputStream = MemoryInputStreamAttributeList
type MemoryInputStreamAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList MemoryInputStream = MemoryInputStreamSignalList
type MemoryInputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method MemoryInputStream::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "MemoryInputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_input_stream_new" g_memory_input_stream_new :: 
    IO (Ptr MemoryInputStream)

-- | Creates a new empty t'GI.Gio.Objects.MemoryInputStream.MemoryInputStream'.
memoryInputStreamNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m MemoryInputStream
    -- ^ __Returns:__ a new t'GI.Gio.Objects.InputStream.InputStream'
memoryInputStreamNew  = liftIO $ do
    result <- g_memory_input_stream_new
    checkUnexpectedReturnNULL "memoryInputStreamNew" result
    result' <- (wrapObject MemoryInputStream) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MemoryInputStream::new_from_bytes
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "bytes"
--           , argType = TInterface Name { namespace = "GLib" , name = "Bytes" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GBytes" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "MemoryInputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_input_stream_new_from_bytes" g_memory_input_stream_new_from_bytes :: 
    Ptr GLib.Bytes.Bytes ->                 -- bytes : TInterface (Name {namespace = "GLib", name = "Bytes"})
    IO (Ptr MemoryInputStream)

-- | Creates a new t'GI.Gio.Objects.MemoryInputStream.MemoryInputStream' with data from the given /@bytes@/.
-- 
-- /Since: 2.34/
memoryInputStreamNewFromBytes ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Bytes.Bytes
    -- ^ /@bytes@/: a t'GI.GLib.Structs.Bytes.Bytes'
    -> m MemoryInputStream
    -- ^ __Returns:__ new t'GI.Gio.Objects.InputStream.InputStream' read from /@bytes@/
memoryInputStreamNewFromBytes bytes = liftIO $ do
    bytes' <- unsafeManagedPtrGetPtr bytes
    result <- g_memory_input_stream_new_from_bytes bytes'
    checkUnexpectedReturnNULL "memoryInputStreamNewFromBytes" result
    result' <- (wrapObject MemoryInputStream) result
    touchManagedPtr bytes
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MemoryInputStream::new_from_data
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "data"
--           , argType = TCArray False (-1) 1 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "input data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "length of the data, may be -1 if @data is a nul-terminated string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function that is called to free @data, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "len"
--              , argType = TBasicType TSSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "length of the data, may be -1 if @data is a nul-terminated string"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "MemoryInputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_input_stream_new_from_data" g_memory_input_stream_new_from_data :: 
    Ptr Word8 ->                            -- data : TCArray False (-1) 1 (TBasicType TUInt8)
    DI.Int64 ->                             -- len : TBasicType TSSize
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr MemoryInputStream)

-- | Creates a new t'GI.Gio.Objects.MemoryInputStream.MemoryInputStream' with data in memory of a given size.
memoryInputStreamNewFromData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ByteString
    -- ^ /@data@/: input data
    -> Maybe (GLib.Callbacks.DestroyNotify)
    -- ^ /@destroy@/: function that is called to free /@data@/, or 'P.Nothing'
    -> m MemoryInputStream
    -- ^ __Returns:__ new t'GI.Gio.Objects.InputStream.InputStream' read from /@data@/ of /@len@/ bytes.
memoryInputStreamNewFromData data_ destroy = liftIO $ do
    let len = fromIntegral $ B.length data_
    data_' <- packByteString data_
    maybeDestroy <- case destroy of
        Nothing -> return FP.nullFunPtr
        Just jDestroy -> do
            ptrdestroy <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
            jDestroy' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrdestroy) (GLib.Callbacks.drop_closures_DestroyNotify jDestroy))
            poke ptrdestroy jDestroy'
            return jDestroy'
    result <- g_memory_input_stream_new_from_data data_' len maybeDestroy
    checkUnexpectedReturnNULL "memoryInputStreamNewFromData" result
    result' <- (wrapObject MemoryInputStream) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method MemoryInputStream::add_bytes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MemoryInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMemoryInputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes"
--           , argType = TInterface Name { namespace = "GLib" , name = "Bytes" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "input data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_input_stream_add_bytes" g_memory_input_stream_add_bytes :: 
    Ptr MemoryInputStream ->                -- stream : TInterface (Name {namespace = "Gio", name = "MemoryInputStream"})
    Ptr GLib.Bytes.Bytes ->                 -- bytes : TInterface (Name {namespace = "GLib", name = "Bytes"})
    IO ()

-- | Appends /@bytes@/ to data that can be read from the input stream.
-- 
-- /Since: 2.34/
memoryInputStreamAddBytes ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.MemoryInputStream.MemoryInputStream'
    -> GLib.Bytes.Bytes
    -- ^ /@bytes@/: input data
    -> m ()
memoryInputStreamAddBytes stream bytes = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    bytes' <- unsafeManagedPtrGetPtr bytes
    g_memory_input_stream_add_bytes stream' bytes'
    touchManagedPtr stream
    touchManagedPtr bytes
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryInputStreamAddBytesMethodInfo
instance (signature ~ (GLib.Bytes.Bytes -> m ()), MonadIO m, IsMemoryInputStream a) => O.OverloadedMethod MemoryInputStreamAddBytesMethodInfo a signature where
    overloadedMethod = memoryInputStreamAddBytes

instance O.OverloadedMethodInfo MemoryInputStreamAddBytesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MemoryInputStream.memoryInputStreamAddBytes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MemoryInputStream.html#v:memoryInputStreamAddBytes"
        })


#endif

-- method MemoryInputStream::add_data
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MemoryInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMemoryInputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "input data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "length of the data, may be -1 if @data is a nul-terminated string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destroy"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "function that is called to free @data, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "len"
--              , argType = TBasicType TSSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just
--                          "length of the data, may be -1 if @data is a nul-terminated string"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_input_stream_add_data" g_memory_input_stream_add_data :: 
    Ptr MemoryInputStream ->                -- stream : TInterface (Name {namespace = "Gio", name = "MemoryInputStream"})
    Ptr Word8 ->                            -- data : TCArray False (-1) 2 (TBasicType TUInt8)
    DI.Int64 ->                             -- len : TBasicType TSSize
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- destroy : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO ()

-- | Appends /@data@/ to data that can be read from the input stream
memoryInputStreamAddData ::
    (B.CallStack.HasCallStack, MonadIO m, IsMemoryInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.MemoryInputStream.MemoryInputStream'
    -> ByteString
    -- ^ /@data@/: input data
    -> Maybe (GLib.Callbacks.DestroyNotify)
    -- ^ /@destroy@/: function that is called to free /@data@/, or 'P.Nothing'
    -> m ()
memoryInputStreamAddData stream data_ destroy = liftIO $ do
    let len = fromIntegral $ B.length data_
    stream' <- unsafeManagedPtrCastPtr stream
    data_' <- packByteString data_
    maybeDestroy <- case destroy of
        Nothing -> return FP.nullFunPtr
        Just jDestroy -> do
            ptrdestroy <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
            jDestroy' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptrdestroy) (GLib.Callbacks.drop_closures_DestroyNotify jDestroy))
            poke ptrdestroy jDestroy'
            return jDestroy'
    g_memory_input_stream_add_data stream' data_' len maybeDestroy
    touchManagedPtr stream
    return ()

#if defined(ENABLE_OVERLOADING)
data MemoryInputStreamAddDataMethodInfo
instance (signature ~ (ByteString -> Maybe (GLib.Callbacks.DestroyNotify) -> m ()), MonadIO m, IsMemoryInputStream a) => O.OverloadedMethod MemoryInputStreamAddDataMethodInfo a signature where
    overloadedMethod = memoryInputStreamAddData

instance O.OverloadedMethodInfo MemoryInputStreamAddDataMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.MemoryInputStream.memoryInputStreamAddData",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-MemoryInputStream.html#v:memoryInputStreamAddData"
        })


#endif


