{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GInetAddressMask@ represents a range of IPv4 or IPv6 addresses
-- described by a base address and a length indicating how many bits
-- of the base address are relevant for matching purposes. These are
-- often given in string form. For example, @10.0.0.0\/8@, or @fe80::\/10@.
-- 
-- /Since: 2.32/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.InetAddressMask
    ( 

-- * Exported types
    InetAddressMask(..)                     ,
    IsInetAddressMask                       ,
    toInetAddressMask                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [equal]("GI.Gio.Objects.InetAddressMask#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [init]("GI.Gio.Interfaces.Initable#g:method:init"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [matches]("GI.Gio.Objects.InetAddressMask#g:method:matches"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Objects.InetAddressMask#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAddress]("GI.Gio.Objects.InetAddressMask#g:method:getAddress"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFamily]("GI.Gio.Objects.InetAddressMask#g:method:getFamily"), [getLength]("GI.Gio.Objects.InetAddressMask#g:method:getLength"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveInetAddressMaskMethod            ,
#endif

-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    InetAddressMaskEqualMethodInfo          ,
#endif
    inetAddressMaskEqual                    ,


-- ** getAddress #method:getAddress#

#if defined(ENABLE_OVERLOADING)
    InetAddressMaskGetAddressMethodInfo     ,
#endif
    inetAddressMaskGetAddress               ,


-- ** getFamily #method:getFamily#

#if defined(ENABLE_OVERLOADING)
    InetAddressMaskGetFamilyMethodInfo      ,
#endif
    inetAddressMaskGetFamily                ,


-- ** getLength #method:getLength#

#if defined(ENABLE_OVERLOADING)
    InetAddressMaskGetLengthMethodInfo      ,
#endif
    inetAddressMaskGetLength                ,


-- ** matches #method:matches#

#if defined(ENABLE_OVERLOADING)
    InetAddressMaskMatchesMethodInfo        ,
#endif
    inetAddressMaskMatches                  ,


-- ** new #method:new#

    inetAddressMaskNew                      ,


-- ** newFromString #method:newFromString#

    inetAddressMaskNewFromString            ,


-- ** toString #method:toString#

#if defined(ENABLE_OVERLOADING)
    InetAddressMaskToStringMethodInfo       ,
#endif
    inetAddressMaskToString                 ,




 -- * Properties


-- ** address #attr:address#
-- | The base address.
-- 
-- /Since: 2.32/

#if defined(ENABLE_OVERLOADING)
    InetAddressMaskAddressPropertyInfo      ,
#endif
    clearInetAddressMaskAddress             ,
    constructInetAddressMaskAddress         ,
    getInetAddressMaskAddress               ,
#if defined(ENABLE_OVERLOADING)
    inetAddressMaskAddress                  ,
#endif
    setInetAddressMaskAddress               ,


-- ** family #attr:family#
-- | The address family (IPv4 or IPv6).
-- 
-- /Since: 2.32/

#if defined(ENABLE_OVERLOADING)
    InetAddressMaskFamilyPropertyInfo       ,
#endif
    getInetAddressMaskFamily                ,
#if defined(ENABLE_OVERLOADING)
    inetAddressMaskFamily                   ,
#endif


-- ** length #attr:length#
-- | The prefix length, in bytes.
-- 
-- /Since: 2.32/

#if defined(ENABLE_OVERLOADING)
    InetAddressMaskLengthPropertyInfo       ,
#endif
    constructInetAddressMaskLength          ,
    getInetAddressMaskLength                ,
#if defined(ENABLE_OVERLOADING)
    inetAddressMaskLength                   ,
#endif
    setInetAddressMaskLength                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress

#endif

-- | Memory-managed wrapper type.
newtype InetAddressMask = InetAddressMask (SP.ManagedPtr InetAddressMask)
    deriving (Eq)

instance SP.ManagedPtrNewtype InetAddressMask where
    toManagedPtr (InetAddressMask p) = p

foreign import ccall "g_inet_address_mask_get_type"
    c_g_inet_address_mask_get_type :: IO B.Types.GType

instance B.Types.TypedObject InetAddressMask where
    glibType = c_g_inet_address_mask_get_type

instance B.Types.GObject InetAddressMask

-- | Type class for types which can be safely cast to `InetAddressMask`, for instance with `toInetAddressMask`.
class (SP.GObject o, O.IsDescendantOf InetAddressMask o) => IsInetAddressMask o
instance (SP.GObject o, O.IsDescendantOf InetAddressMask o) => IsInetAddressMask o

instance O.HasParentTypes InetAddressMask
type instance O.ParentTypes InetAddressMask = '[GObject.Object.Object, Gio.Initable.Initable]

-- | Cast to `InetAddressMask`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toInetAddressMask :: (MIO.MonadIO m, IsInetAddressMask o) => o -> m InetAddressMask
toInetAddressMask = MIO.liftIO . B.ManagedPtr.unsafeCastTo InetAddressMask

-- | Convert 'InetAddressMask' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe InetAddressMask) where
    gvalueGType_ = c_g_inet_address_mask_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr InetAddressMask)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr InetAddressMask)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject InetAddressMask ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveInetAddressMaskMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInetAddressMaskMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveInetAddressMaskMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveInetAddressMaskMethod "equal" o = InetAddressMaskEqualMethodInfo
    ResolveInetAddressMaskMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveInetAddressMaskMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveInetAddressMaskMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveInetAddressMaskMethod "init" o = Gio.Initable.InitableInitMethodInfo
    ResolveInetAddressMaskMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveInetAddressMaskMethod "matches" o = InetAddressMaskMatchesMethodInfo
    ResolveInetAddressMaskMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveInetAddressMaskMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveInetAddressMaskMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveInetAddressMaskMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveInetAddressMaskMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveInetAddressMaskMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveInetAddressMaskMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveInetAddressMaskMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveInetAddressMaskMethod "toString" o = InetAddressMaskToStringMethodInfo
    ResolveInetAddressMaskMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveInetAddressMaskMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveInetAddressMaskMethod "getAddress" o = InetAddressMaskGetAddressMethodInfo
    ResolveInetAddressMaskMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveInetAddressMaskMethod "getFamily" o = InetAddressMaskGetFamilyMethodInfo
    ResolveInetAddressMaskMethod "getLength" o = InetAddressMaskGetLengthMethodInfo
    ResolveInetAddressMaskMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveInetAddressMaskMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveInetAddressMaskMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveInetAddressMaskMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveInetAddressMaskMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveInetAddressMaskMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInetAddressMaskMethod t InetAddressMask, O.OverloadedMethod info InetAddressMask p) => OL.IsLabel t (InetAddressMask -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInetAddressMaskMethod t InetAddressMask, O.OverloadedMethod info InetAddressMask p, R.HasField t InetAddressMask p) => R.HasField t InetAddressMask p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInetAddressMaskMethod t InetAddressMask, O.OverloadedMethodInfo info InetAddressMask) => OL.IsLabel t (O.MethodProxy info InetAddressMask) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "address"
   -- Type: TInterface (Name {namespace = "Gio", name = "InetAddress"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@address@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddressMask #address
-- @
getInetAddressMaskAddress :: (MonadIO m, IsInetAddressMask o) => o -> m Gio.InetAddress.InetAddress
getInetAddressMaskAddress obj = MIO.liftIO $ checkUnexpectedNothing "getInetAddressMaskAddress" $ B.Properties.getObjectPropertyObject obj "address" Gio.InetAddress.InetAddress

-- | Set the value of the “@address@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inetAddressMask [ #address 'Data.GI.Base.Attributes.:=' value ]
-- @
setInetAddressMaskAddress :: (MonadIO m, IsInetAddressMask o, Gio.InetAddress.IsInetAddress a) => o -> a -> m ()
setInetAddressMaskAddress obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "address" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@address@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInetAddressMaskAddress :: (IsInetAddressMask o, MIO.MonadIO m, Gio.InetAddress.IsInetAddress a) => a -> m (GValueConstruct o)
constructInetAddressMaskAddress val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "address" (P.Just val)

-- | Set the value of the “@address@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #address
-- @
clearInetAddressMaskAddress :: (MonadIO m, IsInetAddressMask o) => o -> m ()
clearInetAddressMaskAddress obj = liftIO $ B.Properties.setObjectPropertyObject obj "address" (Nothing :: Maybe Gio.InetAddress.InetAddress)

#if defined(ENABLE_OVERLOADING)
data InetAddressMaskAddressPropertyInfo
instance AttrInfo InetAddressMaskAddressPropertyInfo where
    type AttrAllowedOps InetAddressMaskAddressPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint InetAddressMaskAddressPropertyInfo = IsInetAddressMask
    type AttrSetTypeConstraint InetAddressMaskAddressPropertyInfo = Gio.InetAddress.IsInetAddress
    type AttrTransferTypeConstraint InetAddressMaskAddressPropertyInfo = Gio.InetAddress.IsInetAddress
    type AttrTransferType InetAddressMaskAddressPropertyInfo = Gio.InetAddress.InetAddress
    type AttrGetType InetAddressMaskAddressPropertyInfo = Gio.InetAddress.InetAddress
    type AttrLabel InetAddressMaskAddressPropertyInfo = "address"
    type AttrOrigin InetAddressMaskAddressPropertyInfo = InetAddressMask
    attrGet = getInetAddressMaskAddress
    attrSet = setInetAddressMaskAddress
    attrTransfer _ v = do
        unsafeCastTo Gio.InetAddress.InetAddress v
    attrConstruct = constructInetAddressMaskAddress
    attrClear = clearInetAddressMaskAddress
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddressMask.address"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-InetAddressMask.html#g:attr:address"
        })
#endif

-- VVV Prop "family"
   -- Type: TInterface (Name {namespace = "Gio", name = "SocketFamily"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@family@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddressMask #family
-- @
getInetAddressMaskFamily :: (MonadIO m, IsInetAddressMask o) => o -> m Gio.Enums.SocketFamily
getInetAddressMaskFamily obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "family"

#if defined(ENABLE_OVERLOADING)
data InetAddressMaskFamilyPropertyInfo
instance AttrInfo InetAddressMaskFamilyPropertyInfo where
    type AttrAllowedOps InetAddressMaskFamilyPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint InetAddressMaskFamilyPropertyInfo = IsInetAddressMask
    type AttrSetTypeConstraint InetAddressMaskFamilyPropertyInfo = (~) ()
    type AttrTransferTypeConstraint InetAddressMaskFamilyPropertyInfo = (~) ()
    type AttrTransferType InetAddressMaskFamilyPropertyInfo = ()
    type AttrGetType InetAddressMaskFamilyPropertyInfo = Gio.Enums.SocketFamily
    type AttrLabel InetAddressMaskFamilyPropertyInfo = "family"
    type AttrOrigin InetAddressMaskFamilyPropertyInfo = InetAddressMask
    attrGet = getInetAddressMaskFamily
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddressMask.family"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-InetAddressMask.html#g:attr:family"
        })
#endif

-- VVV Prop "length"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@length@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inetAddressMask #length
-- @
getInetAddressMaskLength :: (MonadIO m, IsInetAddressMask o) => o -> m Word32
getInetAddressMaskLength obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "length"

-- | Set the value of the “@length@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inetAddressMask [ #length 'Data.GI.Base.Attributes.:=' value ]
-- @
setInetAddressMaskLength :: (MonadIO m, IsInetAddressMask o) => o -> Word32 -> m ()
setInetAddressMaskLength obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "length" val

-- | Construct a `GValueConstruct` with valid value for the “@length@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInetAddressMaskLength :: (IsInetAddressMask o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructInetAddressMaskLength val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "length" val

#if defined(ENABLE_OVERLOADING)
data InetAddressMaskLengthPropertyInfo
instance AttrInfo InetAddressMaskLengthPropertyInfo where
    type AttrAllowedOps InetAddressMaskLengthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint InetAddressMaskLengthPropertyInfo = IsInetAddressMask
    type AttrSetTypeConstraint InetAddressMaskLengthPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint InetAddressMaskLengthPropertyInfo = (~) Word32
    type AttrTransferType InetAddressMaskLengthPropertyInfo = Word32
    type AttrGetType InetAddressMaskLengthPropertyInfo = Word32
    type AttrLabel InetAddressMaskLengthPropertyInfo = "length"
    type AttrOrigin InetAddressMaskLengthPropertyInfo = InetAddressMask
    attrGet = getInetAddressMaskLength
    attrSet = setInetAddressMaskLength
    attrTransfer _ v = do
        return v
    attrConstruct = constructInetAddressMaskLength
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddressMask.length"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-InetAddressMask.html#g:attr:length"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList InetAddressMask
type instance O.AttributeList InetAddressMask = InetAddressMaskAttributeList
type InetAddressMaskAttributeList = ('[ '("address", InetAddressMaskAddressPropertyInfo), '("family", InetAddressMaskFamilyPropertyInfo), '("length", InetAddressMaskLengthPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
inetAddressMaskAddress :: AttrLabelProxy "address"
inetAddressMaskAddress = AttrLabelProxy

inetAddressMaskFamily :: AttrLabelProxy "family"
inetAddressMaskFamily = AttrLabelProxy

inetAddressMaskLength :: AttrLabelProxy "length"
inetAddressMaskLength = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList InetAddressMask = InetAddressMaskSignalList
type InetAddressMaskSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method InetAddressMask::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "addr"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "length"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of bits of @addr to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "InetAddressMask" })
-- throws : True
-- Skip return : False

foreign import ccall "g_inet_address_mask_new" g_inet_address_mask_new :: 
    Ptr Gio.InetAddress.InetAddress ->      -- addr : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    Word32 ->                               -- length : TBasicType TUInt
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr InetAddressMask)

-- | Creates a new t'GI.Gio.Objects.InetAddressMask.InetAddressMask' representing all addresses whose
-- first /@length@/ bits match /@addr@/.
-- 
-- /Since: 2.32/
inetAddressMaskNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InetAddress.IsInetAddress a) =>
    a
    -- ^ /@addr@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> Word32
    -- ^ /@length@/: number of bits of /@addr@/ to use
    -> m InetAddressMask
    -- ^ __Returns:__ a new t'GI.Gio.Objects.InetAddressMask.InetAddressMask', or 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
inetAddressMaskNew addr length_ = liftIO $ do
    addr' <- unsafeManagedPtrCastPtr addr
    onException (do
        result <- propagateGError $ g_inet_address_mask_new addr' length_
        checkUnexpectedReturnNULL "inetAddressMaskNew" result
        result' <- (wrapObject InetAddressMask) result
        touchManagedPtr addr
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method InetAddressMask::new_from_string
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "mask_string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an IP address or address/length string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "InetAddressMask" })
-- throws : True
-- Skip return : False

foreign import ccall "g_inet_address_mask_new_from_string" g_inet_address_mask_new_from_string :: 
    CString ->                              -- mask_string : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr InetAddressMask)

-- | Parses /@maskString@/ as an IP address and (optional) length, and
-- creates a new t'GI.Gio.Objects.InetAddressMask.InetAddressMask'. The length, if present, is
-- delimited by a \"\/\". If it is not present, then the length is
-- assumed to be the full length of the address.
-- 
-- /Since: 2.32/
inetAddressMaskNewFromString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@maskString@/: an IP address or address\/length string
    -> m InetAddressMask
    -- ^ __Returns:__ a new t'GI.Gio.Objects.InetAddressMask.InetAddressMask' corresponding to /@string@/, or 'P.Nothing'
    -- on error. /(Can throw 'Data.GI.Base.GError.GError')/
inetAddressMaskNewFromString maskString = liftIO $ do
    maskString' <- textToCString maskString
    onException (do
        result <- propagateGError $ g_inet_address_mask_new_from_string maskString'
        checkUnexpectedReturnNULL "inetAddressMaskNewFromString" result
        result' <- (wrapObject InetAddressMask) result
        freeMem maskString'
        return result'
     ) (do
        freeMem maskString'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method InetAddressMask::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddressMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddressMask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mask2"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddressMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another #GInetAddressMask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_mask_equal" g_inet_address_mask_equal :: 
    Ptr InetAddressMask ->                  -- mask : TInterface (Name {namespace = "Gio", name = "InetAddressMask"})
    Ptr InetAddressMask ->                  -- mask2 : TInterface (Name {namespace = "Gio", name = "InetAddressMask"})
    IO CInt

-- | Tests if /@mask@/ and /@mask2@/ are the same mask.
-- 
-- /Since: 2.32/
inetAddressMaskEqual ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddressMask a, IsInetAddressMask b) =>
    a
    -- ^ /@mask@/: a t'GI.Gio.Objects.InetAddressMask.InetAddressMask'
    -> b
    -- ^ /@mask2@/: another t'GI.Gio.Objects.InetAddressMask.InetAddressMask'
    -> m Bool
    -- ^ __Returns:__ whether /@mask@/ and /@mask2@/ are the same mask
inetAddressMaskEqual mask mask2 = liftIO $ do
    mask' <- unsafeManagedPtrCastPtr mask
    mask2' <- unsafeManagedPtrCastPtr mask2
    result <- g_inet_address_mask_equal mask' mask2'
    let result' = (/= 0) result
    touchManagedPtr mask
    touchManagedPtr mask2
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressMaskEqualMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsInetAddressMask a, IsInetAddressMask b) => O.OverloadedMethod InetAddressMaskEqualMethodInfo a signature where
    overloadedMethod = inetAddressMaskEqual

instance O.OverloadedMethodInfo InetAddressMaskEqualMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddressMask.inetAddressMaskEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-InetAddressMask.html#v:inetAddressMaskEqual"
        })


#endif

-- method InetAddressMask::get_address
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddressMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddressMask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InetAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_mask_get_address" g_inet_address_mask_get_address :: 
    Ptr InetAddressMask ->                  -- mask : TInterface (Name {namespace = "Gio", name = "InetAddressMask"})
    IO (Ptr Gio.InetAddress.InetAddress)

-- | Gets /@mask@/\'s base address
-- 
-- /Since: 2.32/
inetAddressMaskGetAddress ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddressMask a) =>
    a
    -- ^ /@mask@/: a t'GI.Gio.Objects.InetAddressMask.InetAddressMask'
    -> m Gio.InetAddress.InetAddress
    -- ^ __Returns:__ /@mask@/\'s base address
inetAddressMaskGetAddress mask = liftIO $ do
    mask' <- unsafeManagedPtrCastPtr mask
    result <- g_inet_address_mask_get_address mask'
    checkUnexpectedReturnNULL "inetAddressMaskGetAddress" result
    result' <- (newObject Gio.InetAddress.InetAddress) result
    touchManagedPtr mask
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressMaskGetAddressMethodInfo
instance (signature ~ (m Gio.InetAddress.InetAddress), MonadIO m, IsInetAddressMask a) => O.OverloadedMethod InetAddressMaskGetAddressMethodInfo a signature where
    overloadedMethod = inetAddressMaskGetAddress

instance O.OverloadedMethodInfo InetAddressMaskGetAddressMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddressMask.inetAddressMaskGetAddress",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-InetAddressMask.html#v:inetAddressMaskGetAddress"
        })


#endif

-- method InetAddressMask::get_family
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddressMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddressMask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketFamily" })
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_mask_get_family" g_inet_address_mask_get_family :: 
    Ptr InetAddressMask ->                  -- mask : TInterface (Name {namespace = "Gio", name = "InetAddressMask"})
    IO CUInt

-- | Gets the t'GI.Gio.Enums.SocketFamily' of /@mask@/\'s address
-- 
-- /Since: 2.32/
inetAddressMaskGetFamily ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddressMask a) =>
    a
    -- ^ /@mask@/: a t'GI.Gio.Objects.InetAddressMask.InetAddressMask'
    -> m Gio.Enums.SocketFamily
    -- ^ __Returns:__ the t'GI.Gio.Enums.SocketFamily' of /@mask@/\'s address
inetAddressMaskGetFamily mask = liftIO $ do
    mask' <- unsafeManagedPtrCastPtr mask
    result <- g_inet_address_mask_get_family mask'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr mask
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressMaskGetFamilyMethodInfo
instance (signature ~ (m Gio.Enums.SocketFamily), MonadIO m, IsInetAddressMask a) => O.OverloadedMethod InetAddressMaskGetFamilyMethodInfo a signature where
    overloadedMethod = inetAddressMaskGetFamily

instance O.OverloadedMethodInfo InetAddressMaskGetFamilyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddressMask.inetAddressMaskGetFamily",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-InetAddressMask.html#v:inetAddressMaskGetFamily"
        })


#endif

-- method InetAddressMask::get_length
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddressMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddressMask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_mask_get_length" g_inet_address_mask_get_length :: 
    Ptr InetAddressMask ->                  -- mask : TInterface (Name {namespace = "Gio", name = "InetAddressMask"})
    IO Word32

-- | Gets /@mask@/\'s length
-- 
-- /Since: 2.32/
inetAddressMaskGetLength ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddressMask a) =>
    a
    -- ^ /@mask@/: a t'GI.Gio.Objects.InetAddressMask.InetAddressMask'
    -> m Word32
    -- ^ __Returns:__ /@mask@/\'s length
inetAddressMaskGetLength mask = liftIO $ do
    mask' <- unsafeManagedPtrCastPtr mask
    result <- g_inet_address_mask_get_length mask'
    touchManagedPtr mask
    return result

#if defined(ENABLE_OVERLOADING)
data InetAddressMaskGetLengthMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsInetAddressMask a) => O.OverloadedMethod InetAddressMaskGetLengthMethodInfo a signature where
    overloadedMethod = inetAddressMaskGetLength

instance O.OverloadedMethodInfo InetAddressMaskGetLengthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddressMask.inetAddressMaskGetLength",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-InetAddressMask.html#v:inetAddressMaskGetLength"
        })


#endif

-- method InetAddressMask::matches
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddressMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddressMask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_mask_matches" g_inet_address_mask_matches :: 
    Ptr InetAddressMask ->                  -- mask : TInterface (Name {namespace = "Gio", name = "InetAddressMask"})
    Ptr Gio.InetAddress.InetAddress ->      -- address : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    IO CInt

-- | Tests if /@address@/ falls within the range described by /@mask@/.
-- 
-- /Since: 2.32/
inetAddressMaskMatches ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddressMask a, Gio.InetAddress.IsInetAddress b) =>
    a
    -- ^ /@mask@/: a t'GI.Gio.Objects.InetAddressMask.InetAddressMask'
    -> b
    -- ^ /@address@/: a t'GI.Gio.Objects.InetAddress.InetAddress'
    -> m Bool
    -- ^ __Returns:__ whether /@address@/ falls within the range described by
    -- /@mask@/.
inetAddressMaskMatches mask address = liftIO $ do
    mask' <- unsafeManagedPtrCastPtr mask
    address' <- unsafeManagedPtrCastPtr address
    result <- g_inet_address_mask_matches mask' address'
    let result' = (/= 0) result
    touchManagedPtr mask
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressMaskMatchesMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsInetAddressMask a, Gio.InetAddress.IsInetAddress b) => O.OverloadedMethod InetAddressMaskMatchesMethodInfo a signature where
    overloadedMethod = inetAddressMaskMatches

instance O.OverloadedMethodInfo InetAddressMaskMatchesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddressMask.inetAddressMaskMatches",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-InetAddressMask.html#v:inetAddressMaskMatches"
        })


#endif

-- method InetAddressMask::to_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mask"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddressMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInetAddressMask"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_inet_address_mask_to_string" g_inet_address_mask_to_string :: 
    Ptr InetAddressMask ->                  -- mask : TInterface (Name {namespace = "Gio", name = "InetAddressMask"})
    IO CString

-- | Converts /@mask@/ back to its corresponding string form.
-- 
-- /Since: 2.32/
inetAddressMaskToString ::
    (B.CallStack.HasCallStack, MonadIO m, IsInetAddressMask a) =>
    a
    -- ^ /@mask@/: a t'GI.Gio.Objects.InetAddressMask.InetAddressMask'
    -> m T.Text
    -- ^ __Returns:__ a string corresponding to /@mask@/.
inetAddressMaskToString mask = liftIO $ do
    mask' <- unsafeManagedPtrCastPtr mask
    result <- g_inet_address_mask_to_string mask'
    checkUnexpectedReturnNULL "inetAddressMaskToString" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr mask
    return result'

#if defined(ENABLE_OVERLOADING)
data InetAddressMaskToStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsInetAddressMask a) => O.OverloadedMethod InetAddressMaskToStringMethodInfo a signature where
    overloadedMethod = inetAddressMaskToString

instance O.OverloadedMethodInfo InetAddressMaskToStringMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.InetAddressMask.inetAddressMaskToString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-InetAddressMask.html#v:inetAddressMaskToString"
        })


#endif


