{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Base class for output stream implementations that perform some
-- kind of filtering operation on a base stream. Typical examples
-- of filtering operations are character set conversion, compression
-- and byte order flipping.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.FilterOutputStream
    ( 

-- * Exported types
    FilterOutputStream(..)                  ,
    IsFilterOutputStream                    ,
    toFilterOutputStream                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearPending]("GI.Gio.Objects.OutputStream#g:method:clearPending"), [close]("GI.Gio.Objects.OutputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.OutputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.OutputStream#g:method:closeFinish"), [flush]("GI.Gio.Objects.OutputStream#g:method:flush"), [flushAsync]("GI.Gio.Objects.OutputStream#g:method:flushAsync"), [flushFinish]("GI.Gio.Objects.OutputStream#g:method:flushFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.OutputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.OutputStream#g:method:isClosed"), [isClosing]("GI.Gio.Objects.OutputStream#g:method:isClosing"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [splice]("GI.Gio.Objects.OutputStream#g:method:splice"), [spliceAsync]("GI.Gio.Objects.OutputStream#g:method:spliceAsync"), [spliceFinish]("GI.Gio.Objects.OutputStream#g:method:spliceFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [write]("GI.Gio.Objects.OutputStream#g:method:write"), [writeAll]("GI.Gio.Objects.OutputStream#g:method:writeAll"), [writeAllAsync]("GI.Gio.Objects.OutputStream#g:method:writeAllAsync"), [writeAllFinish]("GI.Gio.Objects.OutputStream#g:method:writeAllFinish"), [writeAsync]("GI.Gio.Objects.OutputStream#g:method:writeAsync"), [writeBytes]("GI.Gio.Objects.OutputStream#g:method:writeBytes"), [writeBytesAsync]("GI.Gio.Objects.OutputStream#g:method:writeBytesAsync"), [writeBytesFinish]("GI.Gio.Objects.OutputStream#g:method:writeBytesFinish"), [writeFinish]("GI.Gio.Objects.OutputStream#g:method:writeFinish"), [writev]("GI.Gio.Objects.OutputStream#g:method:writev"), [writevAll]("GI.Gio.Objects.OutputStream#g:method:writevAll"), [writevAllAsync]("GI.Gio.Objects.OutputStream#g:method:writevAllAsync"), [writevAllFinish]("GI.Gio.Objects.OutputStream#g:method:writevAllFinish"), [writevAsync]("GI.Gio.Objects.OutputStream#g:method:writevAsync"), [writevFinish]("GI.Gio.Objects.OutputStream#g:method:writevFinish").
-- 
-- ==== Getters
-- [getBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:getBaseStream"), [getCloseBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:getCloseBaseStream"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setCloseBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:setCloseBaseStream"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.OutputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFilterOutputStreamMethod         ,
#endif

-- ** getBaseStream #method:getBaseStream#

#if defined(ENABLE_OVERLOADING)
    FilterOutputStreamGetBaseStreamMethodInfo,
#endif
    filterOutputStreamGetBaseStream         ,


-- ** getCloseBaseStream #method:getCloseBaseStream#

#if defined(ENABLE_OVERLOADING)
    FilterOutputStreamGetCloseBaseStreamMethodInfo,
#endif
    filterOutputStreamGetCloseBaseStream    ,


-- ** setCloseBaseStream #method:setCloseBaseStream#

#if defined(ENABLE_OVERLOADING)
    FilterOutputStreamSetCloseBaseStreamMethodInfo,
#endif
    filterOutputStreamSetCloseBaseStream    ,




 -- * Properties


-- ** baseStream #attr:baseStream#
-- | The underlying base stream on which the I\/O ops will be done.

#if defined(ENABLE_OVERLOADING)
    FilterOutputStreamBaseStreamPropertyInfo,
#endif
    constructFilterOutputStreamBaseStream   ,
#if defined(ENABLE_OVERLOADING)
    filterOutputStreamBaseStream            ,
#endif
    getFilterOutputStreamBaseStream         ,


-- ** closeBaseStream #attr:closeBaseStream#
-- | Whether the base stream should be closed when the filter stream is closed.

#if defined(ENABLE_OVERLOADING)
    FilterOutputStreamCloseBaseStreamPropertyInfo,
#endif
    constructFilterOutputStreamCloseBaseStream,
#if defined(ENABLE_OVERLOADING)
    filterOutputStreamCloseBaseStream       ,
#endif
    getFilterOutputStreamCloseBaseStream    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#endif

-- | Memory-managed wrapper type.
newtype FilterOutputStream = FilterOutputStream (SP.ManagedPtr FilterOutputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype FilterOutputStream where
    toManagedPtr (FilterOutputStream p) = p

foreign import ccall "g_filter_output_stream_get_type"
    c_g_filter_output_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject FilterOutputStream where
    glibType = c_g_filter_output_stream_get_type

instance B.Types.GObject FilterOutputStream

-- | Type class for types which can be safely cast to `FilterOutputStream`, for instance with `toFilterOutputStream`.
class (SP.GObject o, O.IsDescendantOf FilterOutputStream o) => IsFilterOutputStream o
instance (SP.GObject o, O.IsDescendantOf FilterOutputStream o) => IsFilterOutputStream o

instance O.HasParentTypes FilterOutputStream
type instance O.ParentTypes FilterOutputStream = '[Gio.OutputStream.OutputStream, GObject.Object.Object]

-- | Cast to `FilterOutputStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toFilterOutputStream :: (MIO.MonadIO m, IsFilterOutputStream o) => o -> m FilterOutputStream
toFilterOutputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo FilterOutputStream

-- | Convert 'FilterOutputStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FilterOutputStream) where
    gvalueGType_ = c_g_filter_output_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FilterOutputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FilterOutputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FilterOutputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFilterOutputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFilterOutputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFilterOutputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFilterOutputStreamMethod "clearPending" o = Gio.OutputStream.OutputStreamClearPendingMethodInfo
    ResolveFilterOutputStreamMethod "close" o = Gio.OutputStream.OutputStreamCloseMethodInfo
    ResolveFilterOutputStreamMethod "closeAsync" o = Gio.OutputStream.OutputStreamCloseAsyncMethodInfo
    ResolveFilterOutputStreamMethod "closeFinish" o = Gio.OutputStream.OutputStreamCloseFinishMethodInfo
    ResolveFilterOutputStreamMethod "flush" o = Gio.OutputStream.OutputStreamFlushMethodInfo
    ResolveFilterOutputStreamMethod "flushAsync" o = Gio.OutputStream.OutputStreamFlushAsyncMethodInfo
    ResolveFilterOutputStreamMethod "flushFinish" o = Gio.OutputStream.OutputStreamFlushFinishMethodInfo
    ResolveFilterOutputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFilterOutputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFilterOutputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFilterOutputStreamMethod "hasPending" o = Gio.OutputStream.OutputStreamHasPendingMethodInfo
    ResolveFilterOutputStreamMethod "isClosed" o = Gio.OutputStream.OutputStreamIsClosedMethodInfo
    ResolveFilterOutputStreamMethod "isClosing" o = Gio.OutputStream.OutputStreamIsClosingMethodInfo
    ResolveFilterOutputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFilterOutputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFilterOutputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFilterOutputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFilterOutputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFilterOutputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFilterOutputStreamMethod "splice" o = Gio.OutputStream.OutputStreamSpliceMethodInfo
    ResolveFilterOutputStreamMethod "spliceAsync" o = Gio.OutputStream.OutputStreamSpliceAsyncMethodInfo
    ResolveFilterOutputStreamMethod "spliceFinish" o = Gio.OutputStream.OutputStreamSpliceFinishMethodInfo
    ResolveFilterOutputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFilterOutputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFilterOutputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFilterOutputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFilterOutputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFilterOutputStreamMethod "write" o = Gio.OutputStream.OutputStreamWriteMethodInfo
    ResolveFilterOutputStreamMethod "writeAll" o = Gio.OutputStream.OutputStreamWriteAllMethodInfo
    ResolveFilterOutputStreamMethod "writeAllAsync" o = Gio.OutputStream.OutputStreamWriteAllAsyncMethodInfo
    ResolveFilterOutputStreamMethod "writeAllFinish" o = Gio.OutputStream.OutputStreamWriteAllFinishMethodInfo
    ResolveFilterOutputStreamMethod "writeAsync" o = Gio.OutputStream.OutputStreamWriteAsyncMethodInfo
    ResolveFilterOutputStreamMethod "writeBytes" o = Gio.OutputStream.OutputStreamWriteBytesMethodInfo
    ResolveFilterOutputStreamMethod "writeBytesAsync" o = Gio.OutputStream.OutputStreamWriteBytesAsyncMethodInfo
    ResolveFilterOutputStreamMethod "writeBytesFinish" o = Gio.OutputStream.OutputStreamWriteBytesFinishMethodInfo
    ResolveFilterOutputStreamMethod "writeFinish" o = Gio.OutputStream.OutputStreamWriteFinishMethodInfo
    ResolveFilterOutputStreamMethod "writev" o = Gio.OutputStream.OutputStreamWritevMethodInfo
    ResolveFilterOutputStreamMethod "writevAll" o = Gio.OutputStream.OutputStreamWritevAllMethodInfo
    ResolveFilterOutputStreamMethod "writevAllAsync" o = Gio.OutputStream.OutputStreamWritevAllAsyncMethodInfo
    ResolveFilterOutputStreamMethod "writevAllFinish" o = Gio.OutputStream.OutputStreamWritevAllFinishMethodInfo
    ResolveFilterOutputStreamMethod "writevAsync" o = Gio.OutputStream.OutputStreamWritevAsyncMethodInfo
    ResolveFilterOutputStreamMethod "writevFinish" o = Gio.OutputStream.OutputStreamWritevFinishMethodInfo
    ResolveFilterOutputStreamMethod "getBaseStream" o = FilterOutputStreamGetBaseStreamMethodInfo
    ResolveFilterOutputStreamMethod "getCloseBaseStream" o = FilterOutputStreamGetCloseBaseStreamMethodInfo
    ResolveFilterOutputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFilterOutputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFilterOutputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFilterOutputStreamMethod "setCloseBaseStream" o = FilterOutputStreamSetCloseBaseStreamMethodInfo
    ResolveFilterOutputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFilterOutputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFilterOutputStreamMethod "setPending" o = Gio.OutputStream.OutputStreamSetPendingMethodInfo
    ResolveFilterOutputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFilterOutputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFilterOutputStreamMethod t FilterOutputStream, O.OverloadedMethod info FilterOutputStream p) => OL.IsLabel t (FilterOutputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFilterOutputStreamMethod t FilterOutputStream, O.OverloadedMethod info FilterOutputStream p, R.HasField t FilterOutputStream p) => R.HasField t FilterOutputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFilterOutputStreamMethod t FilterOutputStream, O.OverloadedMethodInfo info FilterOutputStream) => OL.IsLabel t (O.MethodProxy info FilterOutputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "base-stream"
   -- Type: TInterface (Name {namespace = "Gio", name = "OutputStream"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@base-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' filterOutputStream #baseStream
-- @
getFilterOutputStreamBaseStream :: (MonadIO m, IsFilterOutputStream o) => o -> m Gio.OutputStream.OutputStream
getFilterOutputStreamBaseStream obj = MIO.liftIO $ checkUnexpectedNothing "getFilterOutputStreamBaseStream" $ B.Properties.getObjectPropertyObject obj "base-stream" Gio.OutputStream.OutputStream

-- | Construct a `GValueConstruct` with valid value for the “@base-stream@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFilterOutputStreamBaseStream :: (IsFilterOutputStream o, MIO.MonadIO m, Gio.OutputStream.IsOutputStream a) => a -> m (GValueConstruct o)
constructFilterOutputStreamBaseStream val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "base-stream" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data FilterOutputStreamBaseStreamPropertyInfo
instance AttrInfo FilterOutputStreamBaseStreamPropertyInfo where
    type AttrAllowedOps FilterOutputStreamBaseStreamPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint FilterOutputStreamBaseStreamPropertyInfo = IsFilterOutputStream
    type AttrSetTypeConstraint FilterOutputStreamBaseStreamPropertyInfo = Gio.OutputStream.IsOutputStream
    type AttrTransferTypeConstraint FilterOutputStreamBaseStreamPropertyInfo = Gio.OutputStream.IsOutputStream
    type AttrTransferType FilterOutputStreamBaseStreamPropertyInfo = Gio.OutputStream.OutputStream
    type AttrGetType FilterOutputStreamBaseStreamPropertyInfo = Gio.OutputStream.OutputStream
    type AttrLabel FilterOutputStreamBaseStreamPropertyInfo = "base-stream"
    type AttrOrigin FilterOutputStreamBaseStreamPropertyInfo = FilterOutputStream
    attrGet = getFilterOutputStreamBaseStream
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.OutputStream.OutputStream v
    attrConstruct = constructFilterOutputStreamBaseStream
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FilterOutputStream.baseStream"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FilterOutputStream.html#g:attr:baseStream"
        })
#endif

-- VVV Prop "close-base-stream"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@close-base-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' filterOutputStream #closeBaseStream
-- @
getFilterOutputStreamCloseBaseStream :: (MonadIO m, IsFilterOutputStream o) => o -> m Bool
getFilterOutputStreamCloseBaseStream obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "close-base-stream"

-- | Construct a `GValueConstruct` with valid value for the “@close-base-stream@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructFilterOutputStreamCloseBaseStream :: (IsFilterOutputStream o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructFilterOutputStreamCloseBaseStream val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "close-base-stream" val

#if defined(ENABLE_OVERLOADING)
data FilterOutputStreamCloseBaseStreamPropertyInfo
instance AttrInfo FilterOutputStreamCloseBaseStreamPropertyInfo where
    type AttrAllowedOps FilterOutputStreamCloseBaseStreamPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint FilterOutputStreamCloseBaseStreamPropertyInfo = IsFilterOutputStream
    type AttrSetTypeConstraint FilterOutputStreamCloseBaseStreamPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint FilterOutputStreamCloseBaseStreamPropertyInfo = (~) Bool
    type AttrTransferType FilterOutputStreamCloseBaseStreamPropertyInfo = Bool
    type AttrGetType FilterOutputStreamCloseBaseStreamPropertyInfo = Bool
    type AttrLabel FilterOutputStreamCloseBaseStreamPropertyInfo = "close-base-stream"
    type AttrOrigin FilterOutputStreamCloseBaseStreamPropertyInfo = FilterOutputStream
    attrGet = getFilterOutputStreamCloseBaseStream
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructFilterOutputStreamCloseBaseStream
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FilterOutputStream.closeBaseStream"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FilterOutputStream.html#g:attr:closeBaseStream"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FilterOutputStream
type instance O.AttributeList FilterOutputStream = FilterOutputStreamAttributeList
type FilterOutputStreamAttributeList = ('[ '("baseStream", FilterOutputStreamBaseStreamPropertyInfo), '("closeBaseStream", FilterOutputStreamCloseBaseStreamPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
filterOutputStreamBaseStream :: AttrLabelProxy "baseStream"
filterOutputStreamBaseStream = AttrLabelProxy

filterOutputStreamCloseBaseStream :: AttrLabelProxy "closeBaseStream"
filterOutputStreamCloseBaseStream = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FilterOutputStream = FilterOutputStreamSignalList
type FilterOutputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FilterOutputStream::get_base_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FilterOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.FilterOutputStream]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "OutputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_filter_output_stream_get_base_stream" g_filter_output_stream_get_base_stream :: 
    Ptr FilterOutputStream ->               -- stream : TInterface (Name {namespace = "Gio", name = "FilterOutputStream"})
    IO (Ptr Gio.OutputStream.OutputStream)

-- | Gets the base stream for the filter stream.
filterOutputStreamGetBaseStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsFilterOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.FilterOutputStream.FilterOutputStream'.
    -> m Gio.OutputStream.OutputStream
    -- ^ __Returns:__ a t'GI.Gio.Objects.OutputStream.OutputStream'.
filterOutputStreamGetBaseStream stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_filter_output_stream_get_base_stream stream'
    checkUnexpectedReturnNULL "filterOutputStreamGetBaseStream" result
    result' <- (newObject Gio.OutputStream.OutputStream) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
data FilterOutputStreamGetBaseStreamMethodInfo
instance (signature ~ (m Gio.OutputStream.OutputStream), MonadIO m, IsFilterOutputStream a) => O.OverloadedMethod FilterOutputStreamGetBaseStreamMethodInfo a signature where
    overloadedMethod = filterOutputStreamGetBaseStream

instance O.OverloadedMethodInfo FilterOutputStreamGetBaseStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FilterOutputStream.filterOutputStreamGetBaseStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FilterOutputStream.html#v:filterOutputStreamGetBaseStream"
        })


#endif

-- method FilterOutputStream::get_close_base_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FilterOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.FilterOutputStream]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_filter_output_stream_get_close_base_stream" g_filter_output_stream_get_close_base_stream :: 
    Ptr FilterOutputStream ->               -- stream : TInterface (Name {namespace = "Gio", name = "FilterOutputStream"})
    IO CInt

-- | Returns whether the base stream will be closed when /@stream@/ is
-- closed.
filterOutputStreamGetCloseBaseStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsFilterOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.FilterOutputStream.FilterOutputStream'.
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the base stream will be closed.
filterOutputStreamGetCloseBaseStream stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_filter_output_stream_get_close_base_stream stream'
    let result' = (/= 0) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
data FilterOutputStreamGetCloseBaseStreamMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsFilterOutputStream a) => O.OverloadedMethod FilterOutputStreamGetCloseBaseStreamMethodInfo a signature where
    overloadedMethod = filterOutputStreamGetCloseBaseStream

instance O.OverloadedMethodInfo FilterOutputStreamGetCloseBaseStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FilterOutputStream.filterOutputStreamGetCloseBaseStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FilterOutputStream.html#v:filterOutputStreamGetCloseBaseStream"
        })


#endif

-- method FilterOutputStream::set_close_base_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FilterOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.FilterOutputStream]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "close_base"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "`TRUE` to close the base stream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_filter_output_stream_set_close_base_stream" g_filter_output_stream_set_close_base_stream :: 
    Ptr FilterOutputStream ->               -- stream : TInterface (Name {namespace = "Gio", name = "FilterOutputStream"})
    CInt ->                                 -- close_base : TBasicType TBoolean
    IO ()

-- | Sets whether the base stream will be closed when /@stream@/ is closed.
filterOutputStreamSetCloseBaseStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsFilterOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.FilterOutputStream.FilterOutputStream'.
    -> Bool
    -- ^ /@closeBase@/: @TRUE@ to close the base stream.
    -> m ()
filterOutputStreamSetCloseBaseStream stream closeBase = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    let closeBase' = (P.fromIntegral . P.fromEnum) closeBase
    g_filter_output_stream_set_close_base_stream stream' closeBase'
    touchManagedPtr stream
    return ()

#if defined(ENABLE_OVERLOADING)
data FilterOutputStreamSetCloseBaseStreamMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFilterOutputStream a) => O.OverloadedMethod FilterOutputStreamSetCloseBaseStreamMethodInfo a signature where
    overloadedMethod = filterOutputStreamSetCloseBaseStream

instance O.OverloadedMethodInfo FilterOutputStreamSetCloseBaseStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FilterOutputStream.filterOutputStreamSetCloseBaseStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FilterOutputStream.html#v:filterOutputStreamSetCloseBaseStream"
        })


#endif


