{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Completes partial file and directory names given a partial string by
-- looking in the file system for clues. Can return a list of possible
-- completion strings for widget implementations.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.FilenameCompleter
    ( 

-- * Exported types
    FilenameCompleter(..)                   ,
    IsFilenameCompleter                     ,
    toFilenameCompleter                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCompletionSuffix]("GI.Gio.Objects.FilenameCompleter#g:method:getCompletionSuffix"), [getCompletions]("GI.Gio.Objects.FilenameCompleter#g:method:getCompletions"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirsOnly]("GI.Gio.Objects.FilenameCompleter#g:method:setDirsOnly"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFilenameCompleterMethod          ,
#endif

-- ** getCompletionSuffix #method:getCompletionSuffix#

#if defined(ENABLE_OVERLOADING)
    FilenameCompleterGetCompletionSuffixMethodInfo,
#endif
    filenameCompleterGetCompletionSuffix    ,


-- ** getCompletions #method:getCompletions#

#if defined(ENABLE_OVERLOADING)
    FilenameCompleterGetCompletionsMethodInfo,
#endif
    filenameCompleterGetCompletions         ,


-- ** new #method:new#

    filenameCompleterNew                    ,


-- ** setDirsOnly #method:setDirsOnly#

#if defined(ENABLE_OVERLOADING)
    FilenameCompleterSetDirsOnlyMethodInfo  ,
#endif
    filenameCompleterSetDirsOnly            ,




 -- * Signals


-- ** gotCompletionData #signal:gotCompletionData#

    FilenameCompleterGotCompletionDataCallback,
#if defined(ENABLE_OVERLOADING)
    FilenameCompleterGotCompletionDataSignalInfo,
#endif
    afterFilenameCompleterGotCompletionData ,
    onFilenameCompleterGotCompletionData    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype FilenameCompleter = FilenameCompleter (SP.ManagedPtr FilenameCompleter)
    deriving (Eq)

instance SP.ManagedPtrNewtype FilenameCompleter where
    toManagedPtr (FilenameCompleter p) = p

foreign import ccall "g_filename_completer_get_type"
    c_g_filename_completer_get_type :: IO B.Types.GType

instance B.Types.TypedObject FilenameCompleter where
    glibType = c_g_filename_completer_get_type

instance B.Types.GObject FilenameCompleter

-- | Type class for types which can be safely cast to `FilenameCompleter`, for instance with `toFilenameCompleter`.
class (SP.GObject o, O.IsDescendantOf FilenameCompleter o) => IsFilenameCompleter o
instance (SP.GObject o, O.IsDescendantOf FilenameCompleter o) => IsFilenameCompleter o

instance O.HasParentTypes FilenameCompleter
type instance O.ParentTypes FilenameCompleter = '[GObject.Object.Object]

-- | Cast to `FilenameCompleter`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toFilenameCompleter :: (MIO.MonadIO m, IsFilenameCompleter o) => o -> m FilenameCompleter
toFilenameCompleter = MIO.liftIO . B.ManagedPtr.unsafeCastTo FilenameCompleter

-- | Convert 'FilenameCompleter' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FilenameCompleter) where
    gvalueGType_ = c_g_filename_completer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FilenameCompleter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FilenameCompleter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FilenameCompleter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFilenameCompleterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFilenameCompleterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFilenameCompleterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFilenameCompleterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFilenameCompleterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFilenameCompleterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFilenameCompleterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFilenameCompleterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFilenameCompleterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFilenameCompleterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFilenameCompleterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFilenameCompleterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFilenameCompleterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFilenameCompleterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFilenameCompleterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFilenameCompleterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFilenameCompleterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFilenameCompleterMethod "getCompletionSuffix" o = FilenameCompleterGetCompletionSuffixMethodInfo
    ResolveFilenameCompleterMethod "getCompletions" o = FilenameCompleterGetCompletionsMethodInfo
    ResolveFilenameCompleterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFilenameCompleterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFilenameCompleterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFilenameCompleterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFilenameCompleterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFilenameCompleterMethod "setDirsOnly" o = FilenameCompleterSetDirsOnlyMethodInfo
    ResolveFilenameCompleterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFilenameCompleterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFilenameCompleterMethod t FilenameCompleter, O.OverloadedMethod info FilenameCompleter p) => OL.IsLabel t (FilenameCompleter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFilenameCompleterMethod t FilenameCompleter, O.OverloadedMethod info FilenameCompleter p, R.HasField t FilenameCompleter p) => R.HasField t FilenameCompleter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFilenameCompleterMethod t FilenameCompleter, O.OverloadedMethodInfo info FilenameCompleter) => OL.IsLabel t (O.MethodProxy info FilenameCompleter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal FilenameCompleter::got-completion-data
-- | Emitted when the file name completion information comes available.
type FilenameCompleterGotCompletionDataCallback =
    IO ()

type C_FilenameCompleterGotCompletionDataCallback =
    Ptr FilenameCompleter ->                -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FilenameCompleterGotCompletionDataCallback`.
foreign import ccall "wrapper"
    mk_FilenameCompleterGotCompletionDataCallback :: C_FilenameCompleterGotCompletionDataCallback -> IO (FunPtr C_FilenameCompleterGotCompletionDataCallback)

wrap_FilenameCompleterGotCompletionDataCallback :: 
    GObject a => (a -> FilenameCompleterGotCompletionDataCallback) ->
    C_FilenameCompleterGotCompletionDataCallback
wrap_FilenameCompleterGotCompletionDataCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [gotCompletionData](#signal:gotCompletionData) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' filenameCompleter #gotCompletionData callback
-- @
-- 
-- 
onFilenameCompleterGotCompletionData :: (IsFilenameCompleter a, MonadIO m) => a -> ((?self :: a) => FilenameCompleterGotCompletionDataCallback) -> m SignalHandlerId
onFilenameCompleterGotCompletionData obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FilenameCompleterGotCompletionDataCallback wrapped
    wrapped'' <- mk_FilenameCompleterGotCompletionDataCallback wrapped'
    connectSignalFunPtr obj "got-completion-data" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [gotCompletionData](#signal:gotCompletionData) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' filenameCompleter #gotCompletionData callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFilenameCompleterGotCompletionData :: (IsFilenameCompleter a, MonadIO m) => a -> ((?self :: a) => FilenameCompleterGotCompletionDataCallback) -> m SignalHandlerId
afterFilenameCompleterGotCompletionData obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FilenameCompleterGotCompletionDataCallback wrapped
    wrapped'' <- mk_FilenameCompleterGotCompletionDataCallback wrapped'
    connectSignalFunPtr obj "got-completion-data" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FilenameCompleterGotCompletionDataSignalInfo
instance SignalInfo FilenameCompleterGotCompletionDataSignalInfo where
    type HaskellCallbackType FilenameCompleterGotCompletionDataSignalInfo = FilenameCompleterGotCompletionDataCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FilenameCompleterGotCompletionDataCallback cb
        cb'' <- mk_FilenameCompleterGotCompletionDataCallback cb'
        connectSignalFunPtr obj "got-completion-data" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FilenameCompleter::got-completion-data"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FilenameCompleter.html#g:signal:gotCompletionData"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FilenameCompleter
type instance O.AttributeList FilenameCompleter = FilenameCompleterAttributeList
type FilenameCompleterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FilenameCompleter = FilenameCompleterSignalList
type FilenameCompleterSignalList = ('[ '("gotCompletionData", FilenameCompleterGotCompletionDataSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FilenameCompleter::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "FilenameCompleter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_filename_completer_new" g_filename_completer_new :: 
    IO (Ptr FilenameCompleter)

-- | Creates a new filename completer.
filenameCompleterNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m FilenameCompleter
    -- ^ __Returns:__ a t'GI.Gio.Objects.FilenameCompleter.FilenameCompleter'.
filenameCompleterNew  = liftIO $ do
    result <- g_filename_completer_new
    checkUnexpectedReturnNULL "filenameCompleterNew" result
    result' <- (wrapObject FilenameCompleter) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method FilenameCompleter::get_completion_suffix
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "completer"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FilenameCompleter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the filename completer."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "initial_text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "text to be completed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_filename_completer_get_completion_suffix" g_filename_completer_get_completion_suffix :: 
    Ptr FilenameCompleter ->                -- completer : TInterface (Name {namespace = "Gio", name = "FilenameCompleter"})
    CString ->                              -- initial_text : TBasicType TUTF8
    IO CString

-- | Obtains a completion for /@initialText@/ from /@completer@/.
filenameCompleterGetCompletionSuffix ::
    (B.CallStack.HasCallStack, MonadIO m, IsFilenameCompleter a) =>
    a
    -- ^ /@completer@/: the filename completer.
    -> T.Text
    -- ^ /@initialText@/: text to be completed.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a completed string, or 'P.Nothing' if no
    --     completion exists. This string is not owned by GIO, so remember to 'GI.GLib.Functions.free'
    --     it when finished.
filenameCompleterGetCompletionSuffix completer initialText = liftIO $ do
    completer' <- unsafeManagedPtrCastPtr completer
    initialText' <- textToCString initialText
    result <- g_filename_completer_get_completion_suffix completer' initialText'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr completer
    freeMem initialText'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FilenameCompleterGetCompletionSuffixMethodInfo
instance (signature ~ (T.Text -> m (Maybe T.Text)), MonadIO m, IsFilenameCompleter a) => O.OverloadedMethod FilenameCompleterGetCompletionSuffixMethodInfo a signature where
    overloadedMethod = filenameCompleterGetCompletionSuffix

instance O.OverloadedMethodInfo FilenameCompleterGetCompletionSuffixMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FilenameCompleter.filenameCompleterGetCompletionSuffix",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FilenameCompleter.html#v:filenameCompleterGetCompletionSuffix"
        })


#endif

-- method FilenameCompleter::get_completions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "completer"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FilenameCompleter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the filename completer."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "initial_text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "text to be completed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_filename_completer_get_completions" g_filename_completer_get_completions :: 
    Ptr FilenameCompleter ->                -- completer : TInterface (Name {namespace = "Gio", name = "FilenameCompleter"})
    CString ->                              -- initial_text : TBasicType TUTF8
    IO (Ptr CString)

-- | Gets an array of completion strings for a given initial text.
filenameCompleterGetCompletions ::
    (B.CallStack.HasCallStack, MonadIO m, IsFilenameCompleter a) =>
    a
    -- ^ /@completer@/: the filename completer.
    -> T.Text
    -- ^ /@initialText@/: text to be completed.
    -> m [T.Text]
    -- ^ __Returns:__ array of strings with possible completions for /@initialText@/.
    -- This array must be freed by 'GI.GLib.Functions.strfreev' when finished.
filenameCompleterGetCompletions completer initialText = liftIO $ do
    completer' <- unsafeManagedPtrCastPtr completer
    initialText' <- textToCString initialText
    result <- g_filename_completer_get_completions completer' initialText'
    checkUnexpectedReturnNULL "filenameCompleterGetCompletions" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    touchManagedPtr completer
    freeMem initialText'
    return result'

#if defined(ENABLE_OVERLOADING)
data FilenameCompleterGetCompletionsMethodInfo
instance (signature ~ (T.Text -> m [T.Text]), MonadIO m, IsFilenameCompleter a) => O.OverloadedMethod FilenameCompleterGetCompletionsMethodInfo a signature where
    overloadedMethod = filenameCompleterGetCompletions

instance O.OverloadedMethodInfo FilenameCompleterGetCompletionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FilenameCompleter.filenameCompleterGetCompletions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FilenameCompleter.html#v:filenameCompleterGetCompletions"
        })


#endif

-- method FilenameCompleter::set_dirs_only
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "completer"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FilenameCompleter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the filename completer."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dirs_only"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gboolean." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_filename_completer_set_dirs_only" g_filename_completer_set_dirs_only :: 
    Ptr FilenameCompleter ->                -- completer : TInterface (Name {namespace = "Gio", name = "FilenameCompleter"})
    CInt ->                                 -- dirs_only : TBasicType TBoolean
    IO ()

-- | If /@dirsOnly@/ is 'P.True', /@completer@/ will only
-- complete directory names, and not file names.
filenameCompleterSetDirsOnly ::
    (B.CallStack.HasCallStack, MonadIO m, IsFilenameCompleter a) =>
    a
    -- ^ /@completer@/: the filename completer.
    -> Bool
    -- ^ /@dirsOnly@/: a t'P.Bool'.
    -> m ()
filenameCompleterSetDirsOnly completer dirsOnly = liftIO $ do
    completer' <- unsafeManagedPtrCastPtr completer
    let dirsOnly' = (P.fromIntegral . P.fromEnum) dirsOnly
    g_filename_completer_set_dirs_only completer' dirsOnly'
    touchManagedPtr completer
    return ()

#if defined(ENABLE_OVERLOADING)
data FilenameCompleterSetDirsOnlyMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsFilenameCompleter a) => O.OverloadedMethod FilenameCompleterSetDirsOnlyMethodInfo a signature where
    overloadedMethod = filenameCompleterSetDirsOnly

instance O.OverloadedMethodInfo FilenameCompleterSetDirsOnlyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FilenameCompleter.filenameCompleterSetDirsOnly",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FilenameCompleter.html#v:filenameCompleterSetDirsOnly"
        })


#endif


