{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GFileIOStream@ provides I\/O streams that both read and write to the same
-- file handle.
-- 
-- @GFileIOStream@ implements t'GI.Gio.Interfaces.Seekable.Seekable', which allows the I\/O
-- stream to jump to arbitrary positions in the file and to truncate
-- the file, provided the filesystem of the file supports these
-- operations.
-- 
-- To find the position of a file I\/O stream, use 'GI.Gio.Interfaces.Seekable.seekableTell'.
-- 
-- To find out if a file I\/O stream supports seeking, use
-- 'GI.Gio.Interfaces.Seekable.seekableCanSeek'. To position a file I\/O stream, use
-- 'GI.Gio.Interfaces.Seekable.seekableSeek'. To find out if a file I\/O stream supports
-- truncating, use 'GI.Gio.Interfaces.Seekable.seekableCanTruncate'. To truncate a file I\/O
-- stream, use 'GI.Gio.Interfaces.Seekable.seekableTruncate'.
-- 
-- The default implementation of all the @GFileIOStream@ operations
-- and the implementation of t'GI.Gio.Interfaces.Seekable.Seekable' just call into the same
-- operations on the output stream.
-- 
-- /Since: 2.22/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.FileIOStream
    ( 

-- * Exported types
    FileIOStream(..)                        ,
    IsFileIOStream                          ,
    toFileIOStream                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canSeek]("GI.Gio.Interfaces.Seekable#g:method:canSeek"), [canTruncate]("GI.Gio.Interfaces.Seekable#g:method:canTruncate"), [clearPending]("GI.Gio.Objects.IOStream#g:method:clearPending"), [close]("GI.Gio.Objects.IOStream#g:method:close"), [closeAsync]("GI.Gio.Objects.IOStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.IOStream#g:method:closeFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.IOStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.IOStream#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [queryInfo]("GI.Gio.Objects.FileIOStream#g:method:queryInfo"), [queryInfoAsync]("GI.Gio.Objects.FileIOStream#g:method:queryInfoAsync"), [queryInfoFinish]("GI.Gio.Objects.FileIOStream#g:method:queryInfoFinish"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [seek]("GI.Gio.Interfaces.Seekable#g:method:seek"), [spliceAsync]("GI.Gio.Objects.IOStream#g:method:spliceAsync"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [tell]("GI.Gio.Interfaces.Seekable#g:method:tell"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [truncate]("GI.Gio.Interfaces.Seekable#g:method:truncate"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getEtag]("GI.Gio.Objects.FileIOStream#g:method:getEtag"), [getInputStream]("GI.Gio.Objects.IOStream#g:method:getInputStream"), [getOutputStream]("GI.Gio.Objects.IOStream#g:method:getOutputStream"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.IOStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFileIOStreamMethod               ,
#endif

-- ** getEtag #method:getEtag#

#if defined(ENABLE_OVERLOADING)
    FileIOStreamGetEtagMethodInfo           ,
#endif
    fileIOStreamGetEtag                     ,


-- ** queryInfo #method:queryInfo#

#if defined(ENABLE_OVERLOADING)
    FileIOStreamQueryInfoMethodInfo         ,
#endif
    fileIOStreamQueryInfo                   ,


-- ** queryInfoAsync #method:queryInfoAsync#

#if defined(ENABLE_OVERLOADING)
    FileIOStreamQueryInfoAsyncMethodInfo    ,
#endif
    fileIOStreamQueryInfoAsync              ,


-- ** queryInfoFinish #method:queryInfoFinish#

#if defined(ENABLE_OVERLOADING)
    FileIOStreamQueryInfoFinishMethodInfo   ,
#endif
    fileIOStreamQueryInfoFinish             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream

#endif

-- | Memory-managed wrapper type.
newtype FileIOStream = FileIOStream (SP.ManagedPtr FileIOStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileIOStream where
    toManagedPtr (FileIOStream p) = p

foreign import ccall "g_file_io_stream_get_type"
    c_g_file_io_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject FileIOStream where
    glibType = c_g_file_io_stream_get_type

instance B.Types.GObject FileIOStream

-- | Type class for types which can be safely cast to `FileIOStream`, for instance with `toFileIOStream`.
class (SP.GObject o, O.IsDescendantOf FileIOStream o) => IsFileIOStream o
instance (SP.GObject o, O.IsDescendantOf FileIOStream o) => IsFileIOStream o

instance O.HasParentTypes FileIOStream
type instance O.ParentTypes FileIOStream = '[Gio.IOStream.IOStream, GObject.Object.Object, Gio.Seekable.Seekable]

-- | Cast to `FileIOStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toFileIOStream :: (MIO.MonadIO m, IsFileIOStream o) => o -> m FileIOStream
toFileIOStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo FileIOStream

-- | Convert 'FileIOStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FileIOStream) where
    gvalueGType_ = c_g_file_io_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FileIOStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FileIOStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FileIOStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFileIOStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileIOStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFileIOStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFileIOStreamMethod "canSeek" o = Gio.Seekable.SeekableCanSeekMethodInfo
    ResolveFileIOStreamMethod "canTruncate" o = Gio.Seekable.SeekableCanTruncateMethodInfo
    ResolveFileIOStreamMethod "clearPending" o = Gio.IOStream.IOStreamClearPendingMethodInfo
    ResolveFileIOStreamMethod "close" o = Gio.IOStream.IOStreamCloseMethodInfo
    ResolveFileIOStreamMethod "closeAsync" o = Gio.IOStream.IOStreamCloseAsyncMethodInfo
    ResolveFileIOStreamMethod "closeFinish" o = Gio.IOStream.IOStreamCloseFinishMethodInfo
    ResolveFileIOStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFileIOStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFileIOStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFileIOStreamMethod "hasPending" o = Gio.IOStream.IOStreamHasPendingMethodInfo
    ResolveFileIOStreamMethod "isClosed" o = Gio.IOStream.IOStreamIsClosedMethodInfo
    ResolveFileIOStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFileIOStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFileIOStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFileIOStreamMethod "queryInfo" o = FileIOStreamQueryInfoMethodInfo
    ResolveFileIOStreamMethod "queryInfoAsync" o = FileIOStreamQueryInfoAsyncMethodInfo
    ResolveFileIOStreamMethod "queryInfoFinish" o = FileIOStreamQueryInfoFinishMethodInfo
    ResolveFileIOStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFileIOStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFileIOStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFileIOStreamMethod "seek" o = Gio.Seekable.SeekableSeekMethodInfo
    ResolveFileIOStreamMethod "spliceAsync" o = Gio.IOStream.IOStreamSpliceAsyncMethodInfo
    ResolveFileIOStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFileIOStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFileIOStreamMethod "tell" o = Gio.Seekable.SeekableTellMethodInfo
    ResolveFileIOStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFileIOStreamMethod "truncate" o = Gio.Seekable.SeekableTruncateMethodInfo
    ResolveFileIOStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFileIOStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFileIOStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFileIOStreamMethod "getEtag" o = FileIOStreamGetEtagMethodInfo
    ResolveFileIOStreamMethod "getInputStream" o = Gio.IOStream.IOStreamGetInputStreamMethodInfo
    ResolveFileIOStreamMethod "getOutputStream" o = Gio.IOStream.IOStreamGetOutputStreamMethodInfo
    ResolveFileIOStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFileIOStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFileIOStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFileIOStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFileIOStreamMethod "setPending" o = Gio.IOStream.IOStreamSetPendingMethodInfo
    ResolveFileIOStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFileIOStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileIOStreamMethod t FileIOStream, O.OverloadedMethod info FileIOStream p) => OL.IsLabel t (FileIOStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileIOStreamMethod t FileIOStream, O.OverloadedMethod info FileIOStream p, R.HasField t FileIOStream p) => R.HasField t FileIOStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileIOStreamMethod t FileIOStream, O.OverloadedMethodInfo info FileIOStream) => OL.IsLabel t (O.MethodProxy info FileIOStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileIOStream
type instance O.AttributeList FileIOStream = FileIOStreamAttributeList
type FileIOStreamAttributeList = ('[ '("closed", Gio.IOStream.IOStreamClosedPropertyInfo), '("inputStream", Gio.IOStream.IOStreamInputStreamPropertyInfo), '("outputStream", Gio.IOStream.IOStreamOutputStreamPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FileIOStream = FileIOStreamSignalList
type FileIOStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method FileIOStream::get_etag
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileIOStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileIOStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_file_io_stream_get_etag" g_file_io_stream_get_etag :: 
    Ptr FileIOStream ->                     -- stream : TInterface (Name {namespace = "Gio", name = "FileIOStream"})
    IO CString

-- | Gets the entity tag for the file when it has been written.
-- This must be called after the stream has been written
-- and closed, as the etag can change while writing.
-- 
-- /Since: 2.22/
fileIOStreamGetEtag ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileIOStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.FileIOStream.FileIOStream'.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the entity tag for the stream.
fileIOStreamGetEtag stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_file_io_stream_get_etag stream'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr stream
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data FileIOStreamGetEtagMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsFileIOStream a) => O.OverloadedMethod FileIOStreamGetEtagMethodInfo a signature where
    overloadedMethod = fileIOStreamGetEtag

instance O.OverloadedMethodInfo FileIOStreamGetEtagMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileIOStream.fileIOStreamGetEtag",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FileIOStream.html#v:fileIOStreamGetEtag"
        })


#endif

-- method FileIOStream::query_info
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileIOStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileIOStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attributes"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file attribute query string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "FileInfo" })
-- throws : True
-- Skip return : False

foreign import ccall "g_file_io_stream_query_info" g_file_io_stream_query_info :: 
    Ptr FileIOStream ->                     -- stream : TInterface (Name {namespace = "Gio", name = "FileIOStream"})
    CString ->                              -- attributes : TBasicType TUTF8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.FileInfo.FileInfo)

-- | Queries a file io stream for the given /@attributes@/.
-- This function blocks while querying the stream. For the asynchronous
-- version of this function, see 'GI.Gio.Objects.FileIOStream.fileIOStreamQueryInfoAsync'.
-- While the stream is blocked, the stream will set the pending flag
-- internally, and any other operations on the stream will fail with
-- 'GI.Gio.Enums.IOErrorEnumPending'.
-- 
-- Can fail if the stream was already closed (with /@error@/ being set to
-- 'GI.Gio.Enums.IOErrorEnumClosed'), the stream has pending operations (with /@error@/ being
-- set to 'GI.Gio.Enums.IOErrorEnumPending'), or if querying info is not supported for
-- the stream\'s interface (with /@error@/ being set to 'GI.Gio.Enums.IOErrorEnumNotSupported'). I
-- all cases of failure, 'P.Nothing' will be returned.
-- 
-- If /@cancellable@/ is not 'P.Nothing', then the operation can be cancelled by
-- triggering the cancellable object from another thread. If the operation
-- was cancelled, the error 'GI.Gio.Enums.IOErrorEnumCancelled' will be set, and 'P.Nothing' will
-- be returned.
-- 
-- /Since: 2.22/
fileIOStreamQueryInfo ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileIOStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.FileIOStream.FileIOStream'.
    -> T.Text
    -- ^ /@attributes@/: a file attribute query string.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m Gio.FileInfo.FileInfo
    -- ^ __Returns:__ a t'GI.Gio.Objects.FileInfo.FileInfo' for the /@stream@/, or 'P.Nothing' on error. /(Can throw 'Data.GI.Base.GError.GError')/
fileIOStreamQueryInfo stream attributes cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    attributes' <- textToCString attributes
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_file_io_stream_query_info stream' attributes' maybeCancellable
        checkUnexpectedReturnNULL "fileIOStreamQueryInfo" result
        result' <- (wrapObject Gio.FileInfo.FileInfo) result
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        freeMem attributes'
        return result'
     ) (do
        freeMem attributes'
     )

#if defined(ENABLE_OVERLOADING)
data FileIOStreamQueryInfoMethodInfo
instance (signature ~ (T.Text -> Maybe (b) -> m Gio.FileInfo.FileInfo), MonadIO m, IsFileIOStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod FileIOStreamQueryInfoMethodInfo a signature where
    overloadedMethod = fileIOStreamQueryInfo

instance O.OverloadedMethodInfo FileIOStreamQueryInfoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileIOStream.fileIOStreamQueryInfo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FileIOStream.html#v:fileIOStreamQueryInfo"
        })


#endif

-- method FileIOStream::query_info_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileIOStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileIOStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attributes"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file attribute query string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the [I/O priority](iface.AsyncResult.html#io-priority) of the\n  request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncReadyCallback\n  to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_file_io_stream_query_info_async" g_file_io_stream_query_info_async :: 
    Ptr FileIOStream ->                     -- stream : TInterface (Name {namespace = "Gio", name = "FileIOStream"})
    CString ->                              -- attributes : TBasicType TUTF8
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously queries the /@stream@/ for a t'GI.Gio.Objects.FileInfo.FileInfo'. When completed,
-- /@callback@/ will be called with a t'GI.Gio.Interfaces.AsyncResult.AsyncResult' which can be used to
-- finish the operation with 'GI.Gio.Objects.FileIOStream.fileIOStreamQueryInfoFinish'.
-- 
-- For the synchronous version of this function, see
-- 'GI.Gio.Objects.FileIOStream.fileIOStreamQueryInfo'.
-- 
-- /Since: 2.22/
fileIOStreamQueryInfoAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileIOStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.FileIOStream.FileIOStream'.
    -> T.Text
    -- ^ /@attributes@/: a file attribute query string.
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the
    --   request
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> m ()
fileIOStreamQueryInfoAsync stream attributes ioPriority cancellable callback = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    attributes' <- textToCString attributes
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_file_io_stream_query_info_async stream' attributes' ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr stream
    whenJust cancellable touchManagedPtr
    freeMem attributes'
    return ()

#if defined(ENABLE_OVERLOADING)
data FileIOStreamQueryInfoAsyncMethodInfo
instance (signature ~ (T.Text -> Int32 -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsFileIOStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod FileIOStreamQueryInfoAsyncMethodInfo a signature where
    overloadedMethod = fileIOStreamQueryInfoAsync

instance O.OverloadedMethodInfo FileIOStreamQueryInfoAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileIOStream.fileIOStreamQueryInfoAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FileIOStream.html#v:fileIOStreamQueryInfoAsync"
        })


#endif

-- method FileIOStream::query_info_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "FileIOStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileIOStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "FileInfo" })
-- throws : True
-- Skip return : False

foreign import ccall "g_file_io_stream_query_info_finish" g_file_io_stream_query_info_finish :: 
    Ptr FileIOStream ->                     -- stream : TInterface (Name {namespace = "Gio", name = "FileIOStream"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.FileInfo.FileInfo)

-- | Finalizes the asynchronous query started
-- by 'GI.Gio.Objects.FileIOStream.fileIOStreamQueryInfoAsync'.
-- 
-- /Since: 2.22/
fileIOStreamQueryInfoFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileIOStream a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.FileIOStream.FileIOStream'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m Gio.FileInfo.FileInfo
    -- ^ __Returns:__ A t'GI.Gio.Objects.FileInfo.FileInfo' for the finished query. /(Can throw 'Data.GI.Base.GError.GError')/
fileIOStreamQueryInfoFinish stream result_ = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_file_io_stream_query_info_finish stream' result_'
        checkUnexpectedReturnNULL "fileIOStreamQueryInfoFinish" result
        result' <- (wrapObject Gio.FileInfo.FileInfo) result
        touchManagedPtr stream
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data FileIOStreamQueryInfoFinishMethodInfo
instance (signature ~ (b -> m Gio.FileInfo.FileInfo), MonadIO m, IsFileIOStream a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod FileIOStreamQueryInfoFinishMethodInfo a signature where
    overloadedMethod = fileIOStreamQueryInfoFinish

instance O.OverloadedMethodInfo FileIOStreamQueryInfoFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.FileIOStream.fileIOStreamQueryInfoFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-FileIOStream.html#v:fileIOStreamQueryInfoFinish"
        })


#endif


