{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GDebugControllerDBus@ is an implementation of t'GI.Gio.Interfaces.DebugController.DebugController'
-- which exposes debug settings as a D-Bus object.
-- 
-- It is a t'GI.Gio.Interfaces.Initable.Initable' object, and will register an object at
-- @\/org\/gtk\/Debugging@ on the bus given as
-- [DebugControllerDBus:connection]("GI.Gio.Objects.DebugControllerDBus#g:attr:connection") once it’s initialized. The
-- object will be unregistered when the last reference to the
-- @GDebugControllerDBus@ is dropped.
-- 
-- This D-Bus object can be used by remote processes to enable or disable debug
-- output in this process. Remote processes calling
-- @org.gtk.Debugging.SetDebugEnabled()@ will affect the value of
-- t'GI.Gio.Interfaces.DebugController.DebugController':@/debug-enabled/@ and, by default,
-- 'GI.GLib.Functions.logGetDebugEnabled'.
-- 
-- By default, no processes are allowed to call @SetDebugEnabled()@ unless a
-- [DebugControllerDBus::authorize]("GI.Gio.Objects.DebugControllerDBus#g:signal:authorize") signal handler is installed. This
-- is because the process may be privileged, or might expose sensitive
-- information in its debug output. You may want to restrict the ability to
-- enable debug output to privileged users or processes.
-- 
-- One option is to install a D-Bus security policy which restricts access to
-- @SetDebugEnabled()@, installing something like the following in
-- @$datadir\/dbus-1\/system.d\/@:
-- 
-- 
-- === /xml code/
-- ><?xml version="1.0"?> <!--*-nxml-*-->
-- ><!DOCTYPE busconfig PUBLIC "-//freedesktop//DTD D-BUS Bus Configuration 1.0//EN"
-- >     "http://www.freedesktop.org/standards/dbus/1.0/busconfig.dtd">
-- ><busconfig>
-- >  <policy user="root">
-- >    <allow send_destination="com.example.MyService" send_interface="org.gtk.Debugging"/>
-- >  </policy>
-- >  <policy context="default">
-- >    <deny send_destination="com.example.MyService" send_interface="org.gtk.Debugging"/>
-- >  </policy>
-- ></busconfig>
-- 
-- 
-- This will prevent the @SetDebugEnabled()@ method from being called by all
-- except root. It will not prevent the @DebugEnabled@ property from being read,
-- as it’s accessed through the @org.freedesktop.DBus.Properties@ interface.
-- 
-- Another option is to use polkit to allow or deny requests on a case-by-case
-- basis, allowing for the possibility of dynamic authorisation. To do this,
-- connect to the [DebugControllerDBus::authorize]("GI.Gio.Objects.DebugControllerDBus#g:signal:authorize") signal and query
-- polkit in it:
-- 
-- 
-- === /c code/
-- >  g_autoptr(GError) child_error = NULL;
-- >  g_autoptr(GDBusConnection) connection = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, NULL);
-- >  gulong debug_controller_authorize_id = 0;
-- >
-- >  // Set up the debug controller.
-- >  debug_controller = G_DEBUG_CONTROLLER (g_debug_controller_dbus_new (priv->connection, NULL, &child_error));
-- >  if (debug_controller == NULL)
-- >    {
-- >      g_error ("Could not register debug controller on bus: %s",
-- >               child_error->message);
-- >    }
-- >
-- >  debug_controller_authorize_id = g_signal_connect (debug_controller,
-- >                                                    "authorize",
-- >                                                    G_CALLBACK (debug_controller_authorize_cb),
-- >                                                    self);
-- >
-- >  static gboolean
-- >  debug_controller_authorize_cb (GDebugControllerDBus  *debug_controller,
-- >                                 GDBusMethodInvocation *invocation,
-- >                                 gpointer               user_data)
-- >  {
-- >    g_autoptr(PolkitAuthority) authority = NULL;
-- >    g_autoptr(PolkitSubject) subject = NULL;
-- >    g_autoptr(PolkitAuthorizationResult) auth_result = NULL;
-- >    g_autoptr(GError) local_error = NULL;
-- >    GDBusMessage *message;
-- >    GDBusMessageFlags message_flags;
-- >    PolkitCheckAuthorizationFlags flags = POLKIT_CHECK_AUTHORIZATION_FLAGS_NONE;
-- >
-- >    message = g_dbus_method_invocation_get_message (invocation);
-- >    message_flags = g_dbus_message_get_flags (message);
-- >
-- >    authority = polkit_authority_get_sync (NULL, &local_error);
-- >    if (authority == NULL)
-- >      {
-- >        g_warning ("Failed to get polkit authority: %s", local_error->message);
-- >        return FALSE;
-- >      }
-- >
-- >    if (message_flags & G_DBUS_MESSAGE_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION)
-- >      flags |= POLKIT_CHECK_AUTHORIZATION_FLAGS_ALLOW_USER_INTERACTION;
-- >
-- >    subject = polkit_system_bus_name_new (g_dbus_method_invocation_get_sender (invocation));
-- >
-- >    auth_result = polkit_authority_check_authorization_sync (authority,
-- >                                                             subject,
-- >                                                             "com.example.MyService.set-debug-enabled",
-- >                                                             NULL,
-- >                                                             flags,
-- >                                                             NULL,
-- >                                                             &local_error);
-- >    if (auth_result == NULL)
-- >      {
-- >        g_warning ("Failed to get check polkit authorization: %s", local_error->message);
-- >        return FALSE;
-- >      }
-- >
-- >    return polkit_authorization_result_get_is_authorized (auth_result);
-- >  }
-- 
-- 
-- /Since: 2.72/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.DebugControllerDBus
    ( 

-- * Exported types
    DebugControllerDBus(..)                 ,
    IsDebugControllerDBus                   ,
    toDebugControllerDBus                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [init]("GI.Gio.Interfaces.Initable#g:method:init"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [stop]("GI.Gio.Objects.DebugControllerDBus#g:method:stop"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDebugEnabled]("GI.Gio.Interfaces.DebugController#g:method:getDebugEnabled"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDebugEnabled]("GI.Gio.Interfaces.DebugController#g:method:setDebugEnabled"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDebugControllerDBusMethod        ,
#endif

-- ** new #method:new#

    debugControllerDBusNew                  ,


-- ** stop #method:stop#

#if defined(ENABLE_OVERLOADING)
    DebugControllerDBusStopMethodInfo       ,
#endif
    debugControllerDBusStop                 ,




 -- * Properties


-- ** connection #attr:connection#
-- | The D-Bus connection to expose the debugging interface on.
-- 
-- Typically this will be the same connection (to the system or session bus)
-- which the rest of the application or service’s D-Bus objects are registered
-- on.
-- 
-- /Since: 2.72/

#if defined(ENABLE_OVERLOADING)
    DebugControllerDBusConnectionPropertyInfo,
#endif
    constructDebugControllerDBusConnection  ,
#if defined(ENABLE_OVERLOADING)
    debugControllerDBusConnection           ,
#endif
    getDebugControllerDBusConnection        ,




 -- * Signals


-- ** authorize #signal:authorize#

    DebugControllerDBusAuthorizeCallback    ,
#if defined(ENABLE_OVERLOADING)
    DebugControllerDBusAuthorizeSignalInfo  ,
#endif
    afterDebugControllerDBusAuthorize       ,
    onDebugControllerDBusAuthorize          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncInitable as Gio.AsyncInitable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DebugController as Gio.DebugController
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusAuthObserver as Gio.DBusAuthObserver
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMessage as Gio.DBusMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMethodInvocation as Gio.DBusMethodInvocation
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuAttributeIter as Gio.MenuAttributeIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuLinkIter as Gio.MenuLinkIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.UnixFDList as Gio.UnixFDList
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusMethodInfo as Gio.DBusMethodInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusPropertyInfo as Gio.DBusPropertyInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSignalInfo as Gio.DBusSignalInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSubtreeVTable as Gio.DBusSubtreeVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DebugController as Gio.DebugController
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMethodInvocation as Gio.DBusMethodInvocation

#endif

-- | Memory-managed wrapper type.
newtype DebugControllerDBus = DebugControllerDBus (SP.ManagedPtr DebugControllerDBus)
    deriving (Eq)

instance SP.ManagedPtrNewtype DebugControllerDBus where
    toManagedPtr (DebugControllerDBus p) = p

foreign import ccall "g_debug_controller_dbus_get_type"
    c_g_debug_controller_dbus_get_type :: IO B.Types.GType

instance B.Types.TypedObject DebugControllerDBus where
    glibType = c_g_debug_controller_dbus_get_type

instance B.Types.GObject DebugControllerDBus

-- | Type class for types which can be safely cast to `DebugControllerDBus`, for instance with `toDebugControllerDBus`.
class (SP.GObject o, O.IsDescendantOf DebugControllerDBus o) => IsDebugControllerDBus o
instance (SP.GObject o, O.IsDescendantOf DebugControllerDBus o) => IsDebugControllerDBus o

instance O.HasParentTypes DebugControllerDBus
type instance O.ParentTypes DebugControllerDBus = '[GObject.Object.Object, Gio.DebugController.DebugController, Gio.Initable.Initable]

-- | Cast to `DebugControllerDBus`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDebugControllerDBus :: (MIO.MonadIO m, IsDebugControllerDBus o) => o -> m DebugControllerDBus
toDebugControllerDBus = MIO.liftIO . B.ManagedPtr.unsafeCastTo DebugControllerDBus

-- | Convert 'DebugControllerDBus' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DebugControllerDBus) where
    gvalueGType_ = c_g_debug_controller_dbus_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DebugControllerDBus)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DebugControllerDBus)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DebugControllerDBus ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDebugControllerDBusMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDebugControllerDBusMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDebugControllerDBusMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDebugControllerDBusMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDebugControllerDBusMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDebugControllerDBusMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDebugControllerDBusMethod "init" o = Gio.Initable.InitableInitMethodInfo
    ResolveDebugControllerDBusMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDebugControllerDBusMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDebugControllerDBusMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDebugControllerDBusMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDebugControllerDBusMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDebugControllerDBusMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDebugControllerDBusMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDebugControllerDBusMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDebugControllerDBusMethod "stop" o = DebugControllerDBusStopMethodInfo
    ResolveDebugControllerDBusMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDebugControllerDBusMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDebugControllerDBusMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDebugControllerDBusMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDebugControllerDBusMethod "getDebugEnabled" o = Gio.DebugController.DebugControllerGetDebugEnabledMethodInfo
    ResolveDebugControllerDBusMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDebugControllerDBusMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDebugControllerDBusMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDebugControllerDBusMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDebugControllerDBusMethod "setDebugEnabled" o = Gio.DebugController.DebugControllerSetDebugEnabledMethodInfo
    ResolveDebugControllerDBusMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDebugControllerDBusMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDebugControllerDBusMethod t DebugControllerDBus, O.OverloadedMethod info DebugControllerDBus p) => OL.IsLabel t (DebugControllerDBus -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDebugControllerDBusMethod t DebugControllerDBus, O.OverloadedMethod info DebugControllerDBus p, R.HasField t DebugControllerDBus p) => R.HasField t DebugControllerDBus p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDebugControllerDBusMethod t DebugControllerDBus, O.OverloadedMethodInfo info DebugControllerDBus) => OL.IsLabel t (O.MethodProxy info DebugControllerDBus) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal DebugControllerDBus::authorize
-- | Emitted when a D-Bus peer is trying to change the debug settings and used
-- to determine if that is authorized.
-- 
-- This signal is emitted in a dedicated worker thread, so handlers are
-- allowed to perform blocking I\/O. This means that, for example, it is
-- appropriate to call @polkit_authority_check_authorization_sync()@ to check
-- authorization using polkit.
-- 
-- If 'P.False' is returned then no further handlers are run and the request to
-- change the debug settings is rejected.
-- 
-- Otherwise, if 'P.True' is returned, signal emission continues. If no handlers
-- return 'P.False', then the debug settings are allowed to be changed.
-- 
-- Signal handlers must not modify /@invocation@/, or cause it to return a value.
-- 
-- The default class handler just returns 'P.True'.
-- 
-- /Since: 2.72/
type DebugControllerDBusAuthorizeCallback =
    Gio.DBusMethodInvocation.DBusMethodInvocation
    -- ^ /@invocation@/: A t'GI.Gio.Objects.DBusMethodInvocation.DBusMethodInvocation'.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the call is authorized, 'P.False' otherwise.

type C_DebugControllerDBusAuthorizeCallback =
    Ptr DebugControllerDBus ->              -- object
    Ptr Gio.DBusMethodInvocation.DBusMethodInvocation ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_DebugControllerDBusAuthorizeCallback`.
foreign import ccall "wrapper"
    mk_DebugControllerDBusAuthorizeCallback :: C_DebugControllerDBusAuthorizeCallback -> IO (FunPtr C_DebugControllerDBusAuthorizeCallback)

wrap_DebugControllerDBusAuthorizeCallback :: 
    GObject a => (a -> DebugControllerDBusAuthorizeCallback) ->
    C_DebugControllerDBusAuthorizeCallback
wrap_DebugControllerDBusAuthorizeCallback gi'cb gi'selfPtr invocation _ = do
    invocation' <- (newObject Gio.DBusMethodInvocation.DBusMethodInvocation) invocation
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  invocation'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [authorize](#signal:authorize) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' debugControllerDBus #authorize callback
-- @
-- 
-- 
onDebugControllerDBusAuthorize :: (IsDebugControllerDBus a, MonadIO m) => a -> ((?self :: a) => DebugControllerDBusAuthorizeCallback) -> m SignalHandlerId
onDebugControllerDBusAuthorize obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DebugControllerDBusAuthorizeCallback wrapped
    wrapped'' <- mk_DebugControllerDBusAuthorizeCallback wrapped'
    connectSignalFunPtr obj "authorize" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [authorize](#signal:authorize) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' debugControllerDBus #authorize callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDebugControllerDBusAuthorize :: (IsDebugControllerDBus a, MonadIO m) => a -> ((?self :: a) => DebugControllerDBusAuthorizeCallback) -> m SignalHandlerId
afterDebugControllerDBusAuthorize obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DebugControllerDBusAuthorizeCallback wrapped
    wrapped'' <- mk_DebugControllerDBusAuthorizeCallback wrapped'
    connectSignalFunPtr obj "authorize" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DebugControllerDBusAuthorizeSignalInfo
instance SignalInfo DebugControllerDBusAuthorizeSignalInfo where
    type HaskellCallbackType DebugControllerDBusAuthorizeSignalInfo = DebugControllerDBusAuthorizeCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DebugControllerDBusAuthorizeCallback cb
        cb'' <- mk_DebugControllerDBusAuthorizeCallback cb'
        connectSignalFunPtr obj "authorize" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DebugControllerDBus::authorize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DebugControllerDBus.html#g:signal:authorize"})

#endif

-- VVV Prop "connection"
   -- Type: TInterface (Name {namespace = "Gio", name = "DBusConnection"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@connection@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' debugControllerDBus #connection
-- @
getDebugControllerDBusConnection :: (MonadIO m, IsDebugControllerDBus o) => o -> m (Maybe Gio.DBusConnection.DBusConnection)
getDebugControllerDBusConnection obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "connection" Gio.DBusConnection.DBusConnection

-- | Construct a `GValueConstruct` with valid value for the “@connection@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDebugControllerDBusConnection :: (IsDebugControllerDBus o, MIO.MonadIO m, Gio.DBusConnection.IsDBusConnection a) => a -> m (GValueConstruct o)
constructDebugControllerDBusConnection val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "connection" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DebugControllerDBusConnectionPropertyInfo
instance AttrInfo DebugControllerDBusConnectionPropertyInfo where
    type AttrAllowedOps DebugControllerDBusConnectionPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DebugControllerDBusConnectionPropertyInfo = IsDebugControllerDBus
    type AttrSetTypeConstraint DebugControllerDBusConnectionPropertyInfo = Gio.DBusConnection.IsDBusConnection
    type AttrTransferTypeConstraint DebugControllerDBusConnectionPropertyInfo = Gio.DBusConnection.IsDBusConnection
    type AttrTransferType DebugControllerDBusConnectionPropertyInfo = Gio.DBusConnection.DBusConnection
    type AttrGetType DebugControllerDBusConnectionPropertyInfo = (Maybe Gio.DBusConnection.DBusConnection)
    type AttrLabel DebugControllerDBusConnectionPropertyInfo = "connection"
    type AttrOrigin DebugControllerDBusConnectionPropertyInfo = DebugControllerDBus
    attrGet = getDebugControllerDBusConnection
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.DBusConnection.DBusConnection v
    attrConstruct = constructDebugControllerDBusConnection
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DebugControllerDBus.connection"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DebugControllerDBus.html#g:attr:connection"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DebugControllerDBus
type instance O.AttributeList DebugControllerDBus = DebugControllerDBusAttributeList
type DebugControllerDBusAttributeList = ('[ '("connection", DebugControllerDBusConnectionPropertyInfo), '("debugEnabled", Gio.DebugController.DebugControllerDebugEnabledPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
debugControllerDBusConnection :: AttrLabelProxy "connection"
debugControllerDBusConnection = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DebugControllerDBus = DebugControllerDBusSignalList
type DebugControllerDBusSignalList = ('[ '("authorize", DebugControllerDBusAuthorizeSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DebugControllerDBus::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GDBusConnection to register the debug object on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "DebugControllerDBus" })
-- throws : True
-- Skip return : False

foreign import ccall "g_debug_controller_dbus_new" g_debug_controller_dbus_new :: 
    Ptr Gio.DBusConnection.DBusConnection -> -- connection : TInterface (Name {namespace = "Gio", name = "DBusConnection"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr DebugControllerDBus)

-- | Create a new t'GI.Gio.Objects.DebugControllerDBus.DebugControllerDBus' and synchronously initialize it.
-- 
-- Initializing the object will export the debug object on /@connection@/. The
-- object will remain registered until the last reference to the
-- t'GI.Gio.Objects.DebugControllerDBus.DebugControllerDBus' is dropped.
-- 
-- Initialization may fail if registering the object on /@connection@/ fails.
-- 
-- /Since: 2.72/
debugControllerDBusNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@connection@/: a t'GI.Gio.Objects.DBusConnection.DBusConnection' to register the debug object on
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m (Maybe DebugControllerDBus)
    -- ^ __Returns:__ a new t'GI.Gio.Objects.DebugControllerDBus.DebugControllerDBus', or 'P.Nothing'
    --   on failure /(Can throw 'Data.GI.Base.GError.GError')/
debugControllerDBusNew connection cancellable = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_debug_controller_dbus_new connection' maybeCancellable
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- (wrapObject DebugControllerDBus) result'
            return result''
        touchManagedPtr connection
        whenJust cancellable touchManagedPtr
        return maybeResult
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method DebugControllerDBus::stop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DebugControllerDBus" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDebugControllerDBus"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_debug_controller_dbus_stop" g_debug_controller_dbus_stop :: 
    Ptr DebugControllerDBus ->              -- self : TInterface (Name {namespace = "Gio", name = "DebugControllerDBus"})
    IO ()

-- | Stop the debug controller, unregistering its object from the bus.
-- 
-- Any pending method calls to the object will complete successfully, but new
-- ones will return an error. This method will block until all pending
-- [DebugControllerDBus::authorize]("GI.Gio.Objects.DebugControllerDBus#g:signal:authorize") signals have been handled. This is expected
-- to not take long, as it will just be waiting for threads to join. If any
-- [DebugControllerDBus::authorize]("GI.Gio.Objects.DebugControllerDBus#g:signal:authorize") signal handlers are still executing in other
-- threads, this will block until after they have returned.
-- 
-- This method will be called automatically when the final reference to the
-- t'GI.Gio.Objects.DebugControllerDBus.DebugControllerDBus' is dropped. You may want to call it explicitly to know
-- when the controller has been fully removed from the bus, or to break
-- reference count cycles.
-- 
-- Calling this method from within a [DebugControllerDBus::authorize]("GI.Gio.Objects.DebugControllerDBus#g:signal:authorize") signal
-- handler will cause a deadlock and must not be done.
-- 
-- /Since: 2.72/
debugControllerDBusStop ::
    (B.CallStack.HasCallStack, MonadIO m, IsDebugControllerDBus a) =>
    a
    -- ^ /@self@/: a t'GI.Gio.Objects.DebugControllerDBus.DebugControllerDBus'
    -> m ()
debugControllerDBusStop self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    g_debug_controller_dbus_stop self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data DebugControllerDBusStopMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDebugControllerDBus a) => O.OverloadedMethod DebugControllerDBusStopMethodInfo a signature where
    overloadedMethod = debugControllerDBusStop

instance O.OverloadedMethodInfo DebugControllerDBusStopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DebugControllerDBus.debugControllerDBusStop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DebugControllerDBus.html#v:debugControllerDBusStop"
        })


#endif


