{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Data output stream implements t'GI.Gio.Objects.OutputStream.OutputStream' and includes functions
-- for writing data directly to an output stream.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.DataOutputStream
    ( 

-- * Exported types
    DataOutputStream(..)                    ,
    IsDataOutputStream                      ,
    toDataOutputStream                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canSeek]("GI.Gio.Interfaces.Seekable#g:method:canSeek"), [canTruncate]("GI.Gio.Interfaces.Seekable#g:method:canTruncate"), [clearPending]("GI.Gio.Objects.OutputStream#g:method:clearPending"), [close]("GI.Gio.Objects.OutputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.OutputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.OutputStream#g:method:closeFinish"), [flush]("GI.Gio.Objects.OutputStream#g:method:flush"), [flushAsync]("GI.Gio.Objects.OutputStream#g:method:flushAsync"), [flushFinish]("GI.Gio.Objects.OutputStream#g:method:flushFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.OutputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.OutputStream#g:method:isClosed"), [isClosing]("GI.Gio.Objects.OutputStream#g:method:isClosing"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [putByte]("GI.Gio.Objects.DataOutputStream#g:method:putByte"), [putInt16]("GI.Gio.Objects.DataOutputStream#g:method:putInt16"), [putInt32]("GI.Gio.Objects.DataOutputStream#g:method:putInt32"), [putInt64]("GI.Gio.Objects.DataOutputStream#g:method:putInt64"), [putString]("GI.Gio.Objects.DataOutputStream#g:method:putString"), [putUint16]("GI.Gio.Objects.DataOutputStream#g:method:putUint16"), [putUint32]("GI.Gio.Objects.DataOutputStream#g:method:putUint32"), [putUint64]("GI.Gio.Objects.DataOutputStream#g:method:putUint64"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [seek]("GI.Gio.Interfaces.Seekable#g:method:seek"), [splice]("GI.Gio.Objects.OutputStream#g:method:splice"), [spliceAsync]("GI.Gio.Objects.OutputStream#g:method:spliceAsync"), [spliceFinish]("GI.Gio.Objects.OutputStream#g:method:spliceFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [tell]("GI.Gio.Interfaces.Seekable#g:method:tell"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [truncate]("GI.Gio.Interfaces.Seekable#g:method:truncate"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [write]("GI.Gio.Objects.OutputStream#g:method:write"), [writeAll]("GI.Gio.Objects.OutputStream#g:method:writeAll"), [writeAllAsync]("GI.Gio.Objects.OutputStream#g:method:writeAllAsync"), [writeAllFinish]("GI.Gio.Objects.OutputStream#g:method:writeAllFinish"), [writeAsync]("GI.Gio.Objects.OutputStream#g:method:writeAsync"), [writeBytes]("GI.Gio.Objects.OutputStream#g:method:writeBytes"), [writeBytesAsync]("GI.Gio.Objects.OutputStream#g:method:writeBytesAsync"), [writeBytesFinish]("GI.Gio.Objects.OutputStream#g:method:writeBytesFinish"), [writeFinish]("GI.Gio.Objects.OutputStream#g:method:writeFinish"), [writev]("GI.Gio.Objects.OutputStream#g:method:writev"), [writevAll]("GI.Gio.Objects.OutputStream#g:method:writevAll"), [writevAllAsync]("GI.Gio.Objects.OutputStream#g:method:writevAllAsync"), [writevAllFinish]("GI.Gio.Objects.OutputStream#g:method:writevAllFinish"), [writevAsync]("GI.Gio.Objects.OutputStream#g:method:writevAsync"), [writevFinish]("GI.Gio.Objects.OutputStream#g:method:writevFinish").
-- 
-- ==== Getters
-- [getBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:getBaseStream"), [getByteOrder]("GI.Gio.Objects.DataOutputStream#g:method:getByteOrder"), [getCloseBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:getCloseBaseStream"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setByteOrder]("GI.Gio.Objects.DataOutputStream#g:method:setByteOrder"), [setCloseBaseStream]("GI.Gio.Objects.FilterOutputStream#g:method:setCloseBaseStream"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.OutputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDataOutputStreamMethod           ,
#endif

-- ** getByteOrder #method:getByteOrder#

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamGetByteOrderMethodInfo  ,
#endif
    dataOutputStreamGetByteOrder            ,


-- ** new #method:new#

    dataOutputStreamNew                     ,


-- ** putByte #method:putByte#

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamPutByteMethodInfo       ,
#endif
    dataOutputStreamPutByte                 ,


-- ** putInt16 #method:putInt16#

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamPutInt16MethodInfo      ,
#endif
    dataOutputStreamPutInt16                ,


-- ** putInt32 #method:putInt32#

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamPutInt32MethodInfo      ,
#endif
    dataOutputStreamPutInt32                ,


-- ** putInt64 #method:putInt64#

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamPutInt64MethodInfo      ,
#endif
    dataOutputStreamPutInt64                ,


-- ** putString #method:putString#

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamPutStringMethodInfo     ,
#endif
    dataOutputStreamPutString               ,


-- ** putUint16 #method:putUint16#

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamPutUint16MethodInfo     ,
#endif
    dataOutputStreamPutUint16               ,


-- ** putUint32 #method:putUint32#

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamPutUint32MethodInfo     ,
#endif
    dataOutputStreamPutUint32               ,


-- ** putUint64 #method:putUint64#

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamPutUint64MethodInfo     ,
#endif
    dataOutputStreamPutUint64               ,


-- ** setByteOrder #method:setByteOrder#

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamSetByteOrderMethodInfo  ,
#endif
    dataOutputStreamSetByteOrder            ,




 -- * Properties


-- ** byteOrder #attr:byteOrder#
-- | Determines the byte ordering that is used when writing
-- multi-byte entities (such as integers) to the stream.

#if defined(ENABLE_OVERLOADING)
    DataOutputStreamByteOrderPropertyInfo   ,
#endif
    constructDataOutputStreamByteOrder      ,
#if defined(ENABLE_OVERLOADING)
    dataOutputStreamByteOrder               ,
#endif
    getDataOutputStreamByteOrder            ,
    setDataOutputStreamByteOrder            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FilterOutputStream as Gio.FilterOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FilterOutputStream as Gio.FilterOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#endif

-- | Memory-managed wrapper type.
newtype DataOutputStream = DataOutputStream (SP.ManagedPtr DataOutputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype DataOutputStream where
    toManagedPtr (DataOutputStream p) = p

foreign import ccall "g_data_output_stream_get_type"
    c_g_data_output_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject DataOutputStream where
    glibType = c_g_data_output_stream_get_type

instance B.Types.GObject DataOutputStream

-- | Type class for types which can be safely cast to `DataOutputStream`, for instance with `toDataOutputStream`.
class (SP.GObject o, O.IsDescendantOf DataOutputStream o) => IsDataOutputStream o
instance (SP.GObject o, O.IsDescendantOf DataOutputStream o) => IsDataOutputStream o

instance O.HasParentTypes DataOutputStream
type instance O.ParentTypes DataOutputStream = '[Gio.FilterOutputStream.FilterOutputStream, Gio.OutputStream.OutputStream, GObject.Object.Object, Gio.Seekable.Seekable]

-- | Cast to `DataOutputStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDataOutputStream :: (MIO.MonadIO m, IsDataOutputStream o) => o -> m DataOutputStream
toDataOutputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo DataOutputStream

-- | Convert 'DataOutputStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DataOutputStream) where
    gvalueGType_ = c_g_data_output_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DataOutputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DataOutputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DataOutputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDataOutputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDataOutputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDataOutputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDataOutputStreamMethod "canSeek" o = Gio.Seekable.SeekableCanSeekMethodInfo
    ResolveDataOutputStreamMethod "canTruncate" o = Gio.Seekable.SeekableCanTruncateMethodInfo
    ResolveDataOutputStreamMethod "clearPending" o = Gio.OutputStream.OutputStreamClearPendingMethodInfo
    ResolveDataOutputStreamMethod "close" o = Gio.OutputStream.OutputStreamCloseMethodInfo
    ResolveDataOutputStreamMethod "closeAsync" o = Gio.OutputStream.OutputStreamCloseAsyncMethodInfo
    ResolveDataOutputStreamMethod "closeFinish" o = Gio.OutputStream.OutputStreamCloseFinishMethodInfo
    ResolveDataOutputStreamMethod "flush" o = Gio.OutputStream.OutputStreamFlushMethodInfo
    ResolveDataOutputStreamMethod "flushAsync" o = Gio.OutputStream.OutputStreamFlushAsyncMethodInfo
    ResolveDataOutputStreamMethod "flushFinish" o = Gio.OutputStream.OutputStreamFlushFinishMethodInfo
    ResolveDataOutputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDataOutputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDataOutputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDataOutputStreamMethod "hasPending" o = Gio.OutputStream.OutputStreamHasPendingMethodInfo
    ResolveDataOutputStreamMethod "isClosed" o = Gio.OutputStream.OutputStreamIsClosedMethodInfo
    ResolveDataOutputStreamMethod "isClosing" o = Gio.OutputStream.OutputStreamIsClosingMethodInfo
    ResolveDataOutputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDataOutputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDataOutputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDataOutputStreamMethod "putByte" o = DataOutputStreamPutByteMethodInfo
    ResolveDataOutputStreamMethod "putInt16" o = DataOutputStreamPutInt16MethodInfo
    ResolveDataOutputStreamMethod "putInt32" o = DataOutputStreamPutInt32MethodInfo
    ResolveDataOutputStreamMethod "putInt64" o = DataOutputStreamPutInt64MethodInfo
    ResolveDataOutputStreamMethod "putString" o = DataOutputStreamPutStringMethodInfo
    ResolveDataOutputStreamMethod "putUint16" o = DataOutputStreamPutUint16MethodInfo
    ResolveDataOutputStreamMethod "putUint32" o = DataOutputStreamPutUint32MethodInfo
    ResolveDataOutputStreamMethod "putUint64" o = DataOutputStreamPutUint64MethodInfo
    ResolveDataOutputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDataOutputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDataOutputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDataOutputStreamMethod "seek" o = Gio.Seekable.SeekableSeekMethodInfo
    ResolveDataOutputStreamMethod "splice" o = Gio.OutputStream.OutputStreamSpliceMethodInfo
    ResolveDataOutputStreamMethod "spliceAsync" o = Gio.OutputStream.OutputStreamSpliceAsyncMethodInfo
    ResolveDataOutputStreamMethod "spliceFinish" o = Gio.OutputStream.OutputStreamSpliceFinishMethodInfo
    ResolveDataOutputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDataOutputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDataOutputStreamMethod "tell" o = Gio.Seekable.SeekableTellMethodInfo
    ResolveDataOutputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDataOutputStreamMethod "truncate" o = Gio.Seekable.SeekableTruncateMethodInfo
    ResolveDataOutputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDataOutputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDataOutputStreamMethod "write" o = Gio.OutputStream.OutputStreamWriteMethodInfo
    ResolveDataOutputStreamMethod "writeAll" o = Gio.OutputStream.OutputStreamWriteAllMethodInfo
    ResolveDataOutputStreamMethod "writeAllAsync" o = Gio.OutputStream.OutputStreamWriteAllAsyncMethodInfo
    ResolveDataOutputStreamMethod "writeAllFinish" o = Gio.OutputStream.OutputStreamWriteAllFinishMethodInfo
    ResolveDataOutputStreamMethod "writeAsync" o = Gio.OutputStream.OutputStreamWriteAsyncMethodInfo
    ResolveDataOutputStreamMethod "writeBytes" o = Gio.OutputStream.OutputStreamWriteBytesMethodInfo
    ResolveDataOutputStreamMethod "writeBytesAsync" o = Gio.OutputStream.OutputStreamWriteBytesAsyncMethodInfo
    ResolveDataOutputStreamMethod "writeBytesFinish" o = Gio.OutputStream.OutputStreamWriteBytesFinishMethodInfo
    ResolveDataOutputStreamMethod "writeFinish" o = Gio.OutputStream.OutputStreamWriteFinishMethodInfo
    ResolveDataOutputStreamMethod "writev" o = Gio.OutputStream.OutputStreamWritevMethodInfo
    ResolveDataOutputStreamMethod "writevAll" o = Gio.OutputStream.OutputStreamWritevAllMethodInfo
    ResolveDataOutputStreamMethod "writevAllAsync" o = Gio.OutputStream.OutputStreamWritevAllAsyncMethodInfo
    ResolveDataOutputStreamMethod "writevAllFinish" o = Gio.OutputStream.OutputStreamWritevAllFinishMethodInfo
    ResolveDataOutputStreamMethod "writevAsync" o = Gio.OutputStream.OutputStreamWritevAsyncMethodInfo
    ResolveDataOutputStreamMethod "writevFinish" o = Gio.OutputStream.OutputStreamWritevFinishMethodInfo
    ResolveDataOutputStreamMethod "getBaseStream" o = Gio.FilterOutputStream.FilterOutputStreamGetBaseStreamMethodInfo
    ResolveDataOutputStreamMethod "getByteOrder" o = DataOutputStreamGetByteOrderMethodInfo
    ResolveDataOutputStreamMethod "getCloseBaseStream" o = Gio.FilterOutputStream.FilterOutputStreamGetCloseBaseStreamMethodInfo
    ResolveDataOutputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDataOutputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDataOutputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDataOutputStreamMethod "setByteOrder" o = DataOutputStreamSetByteOrderMethodInfo
    ResolveDataOutputStreamMethod "setCloseBaseStream" o = Gio.FilterOutputStream.FilterOutputStreamSetCloseBaseStreamMethodInfo
    ResolveDataOutputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDataOutputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDataOutputStreamMethod "setPending" o = Gio.OutputStream.OutputStreamSetPendingMethodInfo
    ResolveDataOutputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDataOutputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDataOutputStreamMethod t DataOutputStream, O.OverloadedMethod info DataOutputStream p) => OL.IsLabel t (DataOutputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDataOutputStreamMethod t DataOutputStream, O.OverloadedMethod info DataOutputStream p, R.HasField t DataOutputStream p) => R.HasField t DataOutputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDataOutputStreamMethod t DataOutputStream, O.OverloadedMethodInfo info DataOutputStream) => OL.IsLabel t (O.MethodProxy info DataOutputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "byte-order"
   -- Type: TInterface (Name {namespace = "Gio", name = "DataStreamByteOrder"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@byte-order@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dataOutputStream #byteOrder
-- @
getDataOutputStreamByteOrder :: (MonadIO m, IsDataOutputStream o) => o -> m Gio.Enums.DataStreamByteOrder
getDataOutputStreamByteOrder obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "byte-order"

-- | Set the value of the “@byte-order@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dataOutputStream [ #byteOrder 'Data.GI.Base.Attributes.:=' value ]
-- @
setDataOutputStreamByteOrder :: (MonadIO m, IsDataOutputStream o) => o -> Gio.Enums.DataStreamByteOrder -> m ()
setDataOutputStreamByteOrder obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "byte-order" val

-- | Construct a `GValueConstruct` with valid value for the “@byte-order@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDataOutputStreamByteOrder :: (IsDataOutputStream o, MIO.MonadIO m) => Gio.Enums.DataStreamByteOrder -> m (GValueConstruct o)
constructDataOutputStreamByteOrder val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "byte-order" val

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamByteOrderPropertyInfo
instance AttrInfo DataOutputStreamByteOrderPropertyInfo where
    type AttrAllowedOps DataOutputStreamByteOrderPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DataOutputStreamByteOrderPropertyInfo = IsDataOutputStream
    type AttrSetTypeConstraint DataOutputStreamByteOrderPropertyInfo = (~) Gio.Enums.DataStreamByteOrder
    type AttrTransferTypeConstraint DataOutputStreamByteOrderPropertyInfo = (~) Gio.Enums.DataStreamByteOrder
    type AttrTransferType DataOutputStreamByteOrderPropertyInfo = Gio.Enums.DataStreamByteOrder
    type AttrGetType DataOutputStreamByteOrderPropertyInfo = Gio.Enums.DataStreamByteOrder
    type AttrLabel DataOutputStreamByteOrderPropertyInfo = "byte-order"
    type AttrOrigin DataOutputStreamByteOrderPropertyInfo = DataOutputStream
    attrGet = getDataOutputStreamByteOrder
    attrSet = setDataOutputStreamByteOrder
    attrTransfer _ v = do
        return v
    attrConstruct = constructDataOutputStreamByteOrder
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.byteOrder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#g:attr:byteOrder"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DataOutputStream
type instance O.AttributeList DataOutputStream = DataOutputStreamAttributeList
type DataOutputStreamAttributeList = ('[ '("baseStream", Gio.FilterOutputStream.FilterOutputStreamBaseStreamPropertyInfo), '("byteOrder", DataOutputStreamByteOrderPropertyInfo), '("closeBaseStream", Gio.FilterOutputStream.FilterOutputStreamCloseBaseStreamPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
dataOutputStreamByteOrder :: AttrLabelProxy "byteOrder"
dataOutputStreamByteOrder = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DataOutputStream = DataOutputStreamSignalList
type DataOutputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DataOutputStream::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "base_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "OutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOutputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DataOutputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_data_output_stream_new" g_data_output_stream_new :: 
    Ptr Gio.OutputStream.OutputStream ->    -- base_stream : TInterface (Name {namespace = "Gio", name = "OutputStream"})
    IO (Ptr DataOutputStream)

-- | Creates a new data output stream for /@baseStream@/.
dataOutputStreamNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.OutputStream.IsOutputStream a) =>
    a
    -- ^ /@baseStream@/: a t'GI.Gio.Objects.OutputStream.OutputStream'.
    -> m DataOutputStream
    -- ^ __Returns:__ t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
dataOutputStreamNew baseStream = liftIO $ do
    baseStream' <- unsafeManagedPtrCastPtr baseStream
    result <- g_data_output_stream_new baseStream'
    checkUnexpectedReturnNULL "dataOutputStreamNew" result
    result' <- (wrapObject DataOutputStream) result
    touchManagedPtr baseStream
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method DataOutputStream::get_byte_order
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DataOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDataOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "DataStreamByteOrder" })
-- throws : False
-- Skip return : False

foreign import ccall "g_data_output_stream_get_byte_order" g_data_output_stream_get_byte_order :: 
    Ptr DataOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "DataOutputStream"})
    IO CUInt

-- | Gets the byte order for the stream.
dataOutputStreamGetByteOrder ::
    (B.CallStack.HasCallStack, MonadIO m, IsDataOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
    -> m Gio.Enums.DataStreamByteOrder
    -- ^ __Returns:__ the t'GI.Gio.Enums.DataStreamByteOrder' for the /@stream@/.
dataOutputStreamGetByteOrder stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_data_output_stream_get_byte_order stream'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamGetByteOrderMethodInfo
instance (signature ~ (m Gio.Enums.DataStreamByteOrder), MonadIO m, IsDataOutputStream a) => O.OverloadedMethod DataOutputStreamGetByteOrderMethodInfo a signature where
    overloadedMethod = dataOutputStreamGetByteOrder

instance O.OverloadedMethodInfo DataOutputStreamGetByteOrderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.dataOutputStreamGetByteOrder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#v:dataOutputStreamGetByteOrder"
        })


#endif

-- method DataOutputStream::put_byte
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DataOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDataOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TUInt8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #guchar." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_data_output_stream_put_byte" g_data_output_stream_put_byte :: 
    Ptr DataOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "DataOutputStream"})
    Word8 ->                                -- data : TBasicType TUInt8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Puts a byte into the output stream.
dataOutputStreamPutByte ::
    (B.CallStack.HasCallStack, MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
    -> Word8
    -- ^ /@data@/: a @/guchar/@.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dataOutputStreamPutByte stream data_ cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_data_output_stream_put_byte stream' data_ maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamPutByteMethodInfo
instance (signature ~ (Word8 -> Maybe (b) -> m ()), MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod DataOutputStreamPutByteMethodInfo a signature where
    overloadedMethod = dataOutputStreamPutByte

instance O.OverloadedMethodInfo DataOutputStreamPutByteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.dataOutputStreamPutByte",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#v:dataOutputStreamPutByte"
        })


#endif

-- method DataOutputStream::put_int16
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DataOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDataOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TInt16
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gint16." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_data_output_stream_put_int16" g_data_output_stream_put_int16 :: 
    Ptr DataOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "DataOutputStream"})
    Int16 ->                                -- data : TBasicType TInt16
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Puts a signed 16-bit integer into the output stream.
dataOutputStreamPutInt16 ::
    (B.CallStack.HasCallStack, MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
    -> Int16
    -- ^ /@data@/: a @/gint16/@.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dataOutputStreamPutInt16 stream data_ cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_data_output_stream_put_int16 stream' data_ maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamPutInt16MethodInfo
instance (signature ~ (Int16 -> Maybe (b) -> m ()), MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod DataOutputStreamPutInt16MethodInfo a signature where
    overloadedMethod = dataOutputStreamPutInt16

instance O.OverloadedMethodInfo DataOutputStreamPutInt16MethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.dataOutputStreamPutInt16",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#v:dataOutputStreamPutInt16"
        })


#endif

-- method DataOutputStream::put_int32
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DataOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDataOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gint32." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_data_output_stream_put_int32" g_data_output_stream_put_int32 :: 
    Ptr DataOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "DataOutputStream"})
    Int32 ->                                -- data : TBasicType TInt32
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Puts a signed 32-bit integer into the output stream.
dataOutputStreamPutInt32 ::
    (B.CallStack.HasCallStack, MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
    -> Int32
    -- ^ /@data@/: a @/gint32/@.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dataOutputStreamPutInt32 stream data_ cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_data_output_stream_put_int32 stream' data_ maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamPutInt32MethodInfo
instance (signature ~ (Int32 -> Maybe (b) -> m ()), MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod DataOutputStreamPutInt32MethodInfo a signature where
    overloadedMethod = dataOutputStreamPutInt32

instance O.OverloadedMethodInfo DataOutputStreamPutInt32MethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.dataOutputStreamPutInt32",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#v:dataOutputStreamPutInt32"
        })


#endif

-- method DataOutputStream::put_int64
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DataOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDataOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gint64." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_data_output_stream_put_int64" g_data_output_stream_put_int64 :: 
    Ptr DataOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "DataOutputStream"})
    Int64 ->                                -- data : TBasicType TInt64
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Puts a signed 64-bit integer into the stream.
dataOutputStreamPutInt64 ::
    (B.CallStack.HasCallStack, MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
    -> Int64
    -- ^ /@data@/: a @/gint64/@.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dataOutputStreamPutInt64 stream data_ cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_data_output_stream_put_int64 stream' data_ maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamPutInt64MethodInfo
instance (signature ~ (Int64 -> Maybe (b) -> m ()), MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod DataOutputStreamPutInt64MethodInfo a signature where
    overloadedMethod = dataOutputStreamPutInt64

instance O.OverloadedMethodInfo DataOutputStreamPutInt64MethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.dataOutputStreamPutInt64",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#v:dataOutputStreamPutInt64"
        })


#endif

-- method DataOutputStream::put_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DataOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDataOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_data_output_stream_put_string" g_data_output_stream_put_string :: 
    Ptr DataOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "DataOutputStream"})
    CString ->                              -- str : TBasicType TUTF8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Puts a string into the output stream.
dataOutputStreamPutString ::
    (B.CallStack.HasCallStack, MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
    -> T.Text
    -- ^ /@str@/: a string.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dataOutputStreamPutString stream str cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    str' <- textToCString str
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_data_output_stream_put_string stream' str' maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        freeMem str'
        return ()
     ) (do
        freeMem str'
     )

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamPutStringMethodInfo
instance (signature ~ (T.Text -> Maybe (b) -> m ()), MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod DataOutputStreamPutStringMethodInfo a signature where
    overloadedMethod = dataOutputStreamPutString

instance O.OverloadedMethodInfo DataOutputStreamPutStringMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.dataOutputStreamPutString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#v:dataOutputStreamPutString"
        })


#endif

-- method DataOutputStream::put_uint16
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DataOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDataOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TUInt16
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #guint16." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_data_output_stream_put_uint16" g_data_output_stream_put_uint16 :: 
    Ptr DataOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "DataOutputStream"})
    Word16 ->                               -- data : TBasicType TUInt16
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Puts an unsigned 16-bit integer into the output stream.
dataOutputStreamPutUint16 ::
    (B.CallStack.HasCallStack, MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
    -> Word16
    -- ^ /@data@/: a @/guint16/@.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dataOutputStreamPutUint16 stream data_ cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_data_output_stream_put_uint16 stream' data_ maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamPutUint16MethodInfo
instance (signature ~ (Word16 -> Maybe (b) -> m ()), MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod DataOutputStreamPutUint16MethodInfo a signature where
    overloadedMethod = dataOutputStreamPutUint16

instance O.OverloadedMethodInfo DataOutputStreamPutUint16MethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.dataOutputStreamPutUint16",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#v:dataOutputStreamPutUint16"
        })


#endif

-- method DataOutputStream::put_uint32
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DataOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDataOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #guint32." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_data_output_stream_put_uint32" g_data_output_stream_put_uint32 :: 
    Ptr DataOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "DataOutputStream"})
    Word32 ->                               -- data : TBasicType TUInt32
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Puts an unsigned 32-bit integer into the stream.
dataOutputStreamPutUint32 ::
    (B.CallStack.HasCallStack, MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
    -> Word32
    -- ^ /@data@/: a @/guint32/@.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dataOutputStreamPutUint32 stream data_ cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_data_output_stream_put_uint32 stream' data_ maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamPutUint32MethodInfo
instance (signature ~ (Word32 -> Maybe (b) -> m ()), MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod DataOutputStreamPutUint32MethodInfo a signature where
    overloadedMethod = dataOutputStreamPutUint32

instance O.OverloadedMethodInfo DataOutputStreamPutUint32MethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.dataOutputStreamPutUint32",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#v:dataOutputStreamPutUint32"
        })


#endif

-- method DataOutputStream::put_uint64
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DataOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDataOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #guint64." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_data_output_stream_put_uint64" g_data_output_stream_put_uint64 :: 
    Ptr DataOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "DataOutputStream"})
    Word64 ->                               -- data : TBasicType TUInt64
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Puts an unsigned 64-bit integer into the stream.
dataOutputStreamPutUint64 ::
    (B.CallStack.HasCallStack, MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
    -> Word64
    -- ^ /@data@/: a @/guint64/@.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dataOutputStreamPutUint64 stream data_ cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_data_output_stream_put_uint64 stream' data_ maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamPutUint64MethodInfo
instance (signature ~ (Word64 -> Maybe (b) -> m ()), MonadIO m, IsDataOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod DataOutputStreamPutUint64MethodInfo a signature where
    overloadedMethod = dataOutputStreamPutUint64

instance O.OverloadedMethodInfo DataOutputStreamPutUint64MethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.dataOutputStreamPutUint64",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#v:dataOutputStreamPutUint64"
        })


#endif

-- method DataOutputStream::set_byte_order
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DataOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDataOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "order"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DataStreamByteOrder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a %GDataStreamByteOrder."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_data_output_stream_set_byte_order" g_data_output_stream_set_byte_order :: 
    Ptr DataOutputStream ->                 -- stream : TInterface (Name {namespace = "Gio", name = "DataOutputStream"})
    CUInt ->                                -- order : TInterface (Name {namespace = "Gio", name = "DataStreamByteOrder"})
    IO ()

-- | Sets the byte order of the data output stream to /@order@/.
dataOutputStreamSetByteOrder ::
    (B.CallStack.HasCallStack, MonadIO m, IsDataOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.DataOutputStream.DataOutputStream'.
    -> Gio.Enums.DataStreamByteOrder
    -- ^ /@order@/: a @/GDataStreamByteOrder/@.
    -> m ()
dataOutputStreamSetByteOrder stream order = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    let order' = (fromIntegral . fromEnum) order
    g_data_output_stream_set_byte_order stream' order'
    touchManagedPtr stream
    return ()

#if defined(ENABLE_OVERLOADING)
data DataOutputStreamSetByteOrderMethodInfo
instance (signature ~ (Gio.Enums.DataStreamByteOrder -> m ()), MonadIO m, IsDataOutputStream a) => O.OverloadedMethod DataOutputStreamSetByteOrderMethodInfo a signature where
    overloadedMethod = dataOutputStreamSetByteOrder

instance O.OverloadedMethodInfo DataOutputStreamSetByteOrderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DataOutputStream.dataOutputStreamSetByteOrder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DataOutputStream.html#v:dataOutputStreamSetByteOrder"
        })


#endif


