{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GDBusObjectProxy@ is an object used to represent a remote object
-- with one or more D-Bus interfaces. Normally, you don’t instantiate
-- a @GDBusObjectProxy@ yourself — typically t'GI.Gio.Objects.DBusObjectManagerClient.DBusObjectManagerClient'
-- is used to obtain it.
-- 
-- /Since: 2.30/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.DBusObjectProxy
    ( 

-- * Exported types
    DBusObjectProxy(..)                     ,
    IsDBusObjectProxy                       ,
    toDBusObjectProxy                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getConnection]("GI.Gio.Objects.DBusObjectProxy#g:method:getConnection"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getInterface]("GI.Gio.Interfaces.DBusObject#g:method:getInterface"), [getInterfaces]("GI.Gio.Interfaces.DBusObject#g:method:getInterfaces"), [getObjectPath]("GI.Gio.Interfaces.DBusObject#g:method:getObjectPath"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDBusObjectProxyMethod            ,
#endif

-- ** getConnection #method:getConnection#

#if defined(ENABLE_OVERLOADING)
    DBusObjectProxyGetConnectionMethodInfo  ,
#endif
    dBusObjectProxyGetConnection            ,


-- ** new #method:new#

    dBusObjectProxyNew                      ,




 -- * Properties


-- ** gConnection #attr:gConnection#
-- | The connection of the proxy.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    DBusObjectProxyGConnectionPropertyInfo  ,
#endif
    constructDBusObjectProxyGConnection     ,
#if defined(ENABLE_OVERLOADING)
    dBusObjectProxyGConnection              ,
#endif
    getDBusObjectProxyGConnection           ,


-- ** gObjectPath #attr:gObjectPath#
-- | The object path of the proxy.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    DBusObjectProxyGObjectPathPropertyInfo  ,
#endif
    constructDBusObjectProxyGObjectPath     ,
#if defined(ENABLE_OVERLOADING)
    dBusObjectProxyGObjectPath              ,
#endif
    getDBusObjectProxyGObjectPath           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncInitable as Gio.AsyncInitable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusInterface as Gio.DBusInterface
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObject as Gio.DBusObject
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusAuthObserver as Gio.DBusAuthObserver
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMessage as Gio.DBusMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuAttributeIter as Gio.MenuAttributeIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuLinkIter as Gio.MenuLinkIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.UnixFDList as Gio.UnixFDList
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusMethodInfo as Gio.DBusMethodInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusPropertyInfo as Gio.DBusPropertyInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSignalInfo as Gio.DBusSignalInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSubtreeVTable as Gio.DBusSubtreeVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObject as Gio.DBusObject
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection

#endif

-- | Memory-managed wrapper type.
newtype DBusObjectProxy = DBusObjectProxy (SP.ManagedPtr DBusObjectProxy)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusObjectProxy where
    toManagedPtr (DBusObjectProxy p) = p

foreign import ccall "g_dbus_object_proxy_get_type"
    c_g_dbus_object_proxy_get_type :: IO B.Types.GType

instance B.Types.TypedObject DBusObjectProxy where
    glibType = c_g_dbus_object_proxy_get_type

instance B.Types.GObject DBusObjectProxy

-- | Type class for types which can be safely cast to `DBusObjectProxy`, for instance with `toDBusObjectProxy`.
class (SP.GObject o, O.IsDescendantOf DBusObjectProxy o) => IsDBusObjectProxy o
instance (SP.GObject o, O.IsDescendantOf DBusObjectProxy o) => IsDBusObjectProxy o

instance O.HasParentTypes DBusObjectProxy
type instance O.ParentTypes DBusObjectProxy = '[GObject.Object.Object, Gio.DBusObject.DBusObject]

-- | Cast to `DBusObjectProxy`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDBusObjectProxy :: (MIO.MonadIO m, IsDBusObjectProxy o) => o -> m DBusObjectProxy
toDBusObjectProxy = MIO.liftIO . B.ManagedPtr.unsafeCastTo DBusObjectProxy

-- | Convert 'DBusObjectProxy' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusObjectProxy) where
    gvalueGType_ = c_g_dbus_object_proxy_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DBusObjectProxy)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DBusObjectProxy)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DBusObjectProxy ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusObjectProxyMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusObjectProxyMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDBusObjectProxyMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDBusObjectProxyMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDBusObjectProxyMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDBusObjectProxyMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDBusObjectProxyMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDBusObjectProxyMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDBusObjectProxyMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDBusObjectProxyMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDBusObjectProxyMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDBusObjectProxyMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDBusObjectProxyMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDBusObjectProxyMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDBusObjectProxyMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDBusObjectProxyMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDBusObjectProxyMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDBusObjectProxyMethod "getConnection" o = DBusObjectProxyGetConnectionMethodInfo
    ResolveDBusObjectProxyMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDBusObjectProxyMethod "getInterface" o = Gio.DBusObject.DBusObjectGetInterfaceMethodInfo
    ResolveDBusObjectProxyMethod "getInterfaces" o = Gio.DBusObject.DBusObjectGetInterfacesMethodInfo
    ResolveDBusObjectProxyMethod "getObjectPath" o = Gio.DBusObject.DBusObjectGetObjectPathMethodInfo
    ResolveDBusObjectProxyMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDBusObjectProxyMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDBusObjectProxyMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDBusObjectProxyMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDBusObjectProxyMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDBusObjectProxyMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusObjectProxyMethod t DBusObjectProxy, O.OverloadedMethod info DBusObjectProxy p) => OL.IsLabel t (DBusObjectProxy -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusObjectProxyMethod t DBusObjectProxy, O.OverloadedMethod info DBusObjectProxy p, R.HasField t DBusObjectProxy p) => R.HasField t DBusObjectProxy p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusObjectProxyMethod t DBusObjectProxy, O.OverloadedMethodInfo info DBusObjectProxy) => OL.IsLabel t (O.MethodProxy info DBusObjectProxy) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "g-connection"
   -- Type: TInterface (Name {namespace = "Gio", name = "DBusConnection"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@g-connection@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusObjectProxy #gConnection
-- @
getDBusObjectProxyGConnection :: (MonadIO m, IsDBusObjectProxy o) => o -> m (Maybe Gio.DBusConnection.DBusConnection)
getDBusObjectProxyGConnection obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "g-connection" Gio.DBusConnection.DBusConnection

-- | Construct a `GValueConstruct` with valid value for the “@g-connection@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDBusObjectProxyGConnection :: (IsDBusObjectProxy o, MIO.MonadIO m, Gio.DBusConnection.IsDBusConnection a) => a -> m (GValueConstruct o)
constructDBusObjectProxyGConnection val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "g-connection" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DBusObjectProxyGConnectionPropertyInfo
instance AttrInfo DBusObjectProxyGConnectionPropertyInfo where
    type AttrAllowedOps DBusObjectProxyGConnectionPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DBusObjectProxyGConnectionPropertyInfo = IsDBusObjectProxy
    type AttrSetTypeConstraint DBusObjectProxyGConnectionPropertyInfo = Gio.DBusConnection.IsDBusConnection
    type AttrTransferTypeConstraint DBusObjectProxyGConnectionPropertyInfo = Gio.DBusConnection.IsDBusConnection
    type AttrTransferType DBusObjectProxyGConnectionPropertyInfo = Gio.DBusConnection.DBusConnection
    type AttrGetType DBusObjectProxyGConnectionPropertyInfo = (Maybe Gio.DBusConnection.DBusConnection)
    type AttrLabel DBusObjectProxyGConnectionPropertyInfo = "g-connection"
    type AttrOrigin DBusObjectProxyGConnectionPropertyInfo = DBusObjectProxy
    attrGet = getDBusObjectProxyGConnection
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.DBusConnection.DBusConnection v
    attrConstruct = constructDBusObjectProxyGConnection
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectProxy.gConnection"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DBusObjectProxy.html#g:attr:gConnection"
        })
#endif

-- VVV Prop "g-object-path"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@g-object-path@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusObjectProxy #gObjectPath
-- @
getDBusObjectProxyGObjectPath :: (MonadIO m, IsDBusObjectProxy o) => o -> m (Maybe T.Text)
getDBusObjectProxyGObjectPath obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "g-object-path"

-- | Construct a `GValueConstruct` with valid value for the “@g-object-path@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDBusObjectProxyGObjectPath :: (IsDBusObjectProxy o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructDBusObjectProxyGObjectPath val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "g-object-path" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DBusObjectProxyGObjectPathPropertyInfo
instance AttrInfo DBusObjectProxyGObjectPathPropertyInfo where
    type AttrAllowedOps DBusObjectProxyGObjectPathPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DBusObjectProxyGObjectPathPropertyInfo = IsDBusObjectProxy
    type AttrSetTypeConstraint DBusObjectProxyGObjectPathPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint DBusObjectProxyGObjectPathPropertyInfo = (~) T.Text
    type AttrTransferType DBusObjectProxyGObjectPathPropertyInfo = T.Text
    type AttrGetType DBusObjectProxyGObjectPathPropertyInfo = (Maybe T.Text)
    type AttrLabel DBusObjectProxyGObjectPathPropertyInfo = "g-object-path"
    type AttrOrigin DBusObjectProxyGObjectPathPropertyInfo = DBusObjectProxy
    attrGet = getDBusObjectProxyGObjectPath
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDBusObjectProxyGObjectPath
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectProxy.gObjectPath"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DBusObjectProxy.html#g:attr:gObjectPath"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusObjectProxy
type instance O.AttributeList DBusObjectProxy = DBusObjectProxyAttributeList
type DBusObjectProxyAttributeList = ('[ '("gConnection", DBusObjectProxyGConnectionPropertyInfo), '("gObjectPath", DBusObjectProxyGObjectPathPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
dBusObjectProxyGConnection :: AttrLabelProxy "gConnection"
dBusObjectProxyGConnection = AttrLabelProxy

dBusObjectProxyGObjectPath :: AttrLabelProxy "gObjectPath"
dBusObjectProxyGObjectPath = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DBusObjectProxy = DBusObjectProxySignalList
type DBusObjectProxySignalList = ('[ '("interfaceAdded", Gio.DBusObject.DBusObjectInterfaceAddedSignalInfo), '("interfaceRemoved", Gio.DBusObject.DBusObjectInterfaceRemovedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DBusObjectProxy::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDBusConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the object path" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusObjectProxy" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_proxy_new" g_dbus_object_proxy_new :: 
    Ptr Gio.DBusConnection.DBusConnection -> -- connection : TInterface (Name {namespace = "Gio", name = "DBusConnection"})
    CString ->                              -- object_path : TBasicType TUTF8
    IO (Ptr DBusObjectProxy)

-- | Creates a new t'GI.Gio.Objects.DBusObjectProxy.DBusObjectProxy' for the given connection and
-- object path.
-- 
-- /Since: 2.30/
dBusObjectProxyNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    a
    -- ^ /@connection@/: a t'GI.Gio.Objects.DBusConnection.DBusConnection'
    -> T.Text
    -- ^ /@objectPath@/: the object path
    -> m DBusObjectProxy
    -- ^ __Returns:__ a new t'GI.Gio.Objects.DBusObjectProxy.DBusObjectProxy'
dBusObjectProxyNew connection objectPath = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    objectPath' <- textToCString objectPath
    result <- g_dbus_object_proxy_new connection' objectPath'
    checkUnexpectedReturnNULL "dBusObjectProxyNew" result
    result' <- (wrapObject DBusObjectProxy) result
    touchManagedPtr connection
    freeMem objectPath'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method DBusObjectProxy::get_connection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObjectProxy" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDBusObjectProxy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusConnection" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_proxy_get_connection" g_dbus_object_proxy_get_connection :: 
    Ptr DBusObjectProxy ->                  -- proxy : TInterface (Name {namespace = "Gio", name = "DBusObjectProxy"})
    IO (Ptr Gio.DBusConnection.DBusConnection)

-- | Gets the connection that /@proxy@/ is for.
-- 
-- /Since: 2.30/
dBusObjectProxyGetConnection ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectProxy a) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Objects.DBusObjectProxy.DBusObjectProxy'
    -> m Gio.DBusConnection.DBusConnection
    -- ^ __Returns:__ A t'GI.Gio.Objects.DBusConnection.DBusConnection'. Do not free, the
    --   object is owned by /@proxy@/.
dBusObjectProxyGetConnection proxy = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    result <- g_dbus_object_proxy_get_connection proxy'
    checkUnexpectedReturnNULL "dBusObjectProxyGetConnection" result
    result' <- (newObject Gio.DBusConnection.DBusConnection) result
    touchManagedPtr proxy
    return result'

#if defined(ENABLE_OVERLOADING)
data DBusObjectProxyGetConnectionMethodInfo
instance (signature ~ (m Gio.DBusConnection.DBusConnection), MonadIO m, IsDBusObjectProxy a) => O.OverloadedMethod DBusObjectProxyGetConnectionMethodInfo a signature where
    overloadedMethod = dBusObjectProxyGetConnection

instance O.OverloadedMethodInfo DBusObjectProxyGetConnectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectProxy.dBusObjectProxyGetConnection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-DBusObjectProxy.html#v:dBusObjectProxyGetConnection"
        })


#endif


