{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GDBusMenuModel@ is an implementation of t'GI.Gio.Objects.MenuModel.MenuModel' that can be
-- used as a proxy for a menu model that is exported over D-Bus with
-- 'GI.Gio.Objects.DBusConnection.dBusConnectionExportMenuModel'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.DBusMenuModel
    ( 

-- * Exported types
    DBusMenuModel(..)                       ,
    IsDBusMenuModel                         ,
    toDBusMenuModel                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isMutable]("GI.Gio.Objects.MenuModel#g:method:isMutable"), [itemsChanged]("GI.Gio.Objects.MenuModel#g:method:itemsChanged"), [iterateItemAttributes]("GI.Gio.Objects.MenuModel#g:method:iterateItemAttributes"), [iterateItemLinks]("GI.Gio.Objects.MenuModel#g:method:iterateItemLinks"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItemAttributeValue]("GI.Gio.Objects.MenuModel#g:method:getItemAttributeValue"), [getItemLink]("GI.Gio.Objects.MenuModel#g:method:getItemLink"), [getNItems]("GI.Gio.Objects.MenuModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDBusMenuModelMethod              ,
#endif

-- ** get #method:get#

    dBusMenuModelGet                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncInitable as Gio.AsyncInitable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusAuthObserver as Gio.DBusAuthObserver
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMessage as Gio.DBusMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuAttributeIter as Gio.MenuAttributeIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuLinkIter as Gio.MenuLinkIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.UnixFDList as Gio.UnixFDList
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusMethodInfo as Gio.DBusMethodInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusPropertyInfo as Gio.DBusPropertyInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSignalInfo as Gio.DBusSignalInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSubtreeVTable as Gio.DBusSubtreeVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel

#endif

-- | Memory-managed wrapper type.
newtype DBusMenuModel = DBusMenuModel (SP.ManagedPtr DBusMenuModel)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusMenuModel where
    toManagedPtr (DBusMenuModel p) = p

foreign import ccall "g_dbus_menu_model_get_type"
    c_g_dbus_menu_model_get_type :: IO B.Types.GType

instance B.Types.TypedObject DBusMenuModel where
    glibType = c_g_dbus_menu_model_get_type

instance B.Types.GObject DBusMenuModel

-- | Type class for types which can be safely cast to `DBusMenuModel`, for instance with `toDBusMenuModel`.
class (SP.GObject o, O.IsDescendantOf DBusMenuModel o) => IsDBusMenuModel o
instance (SP.GObject o, O.IsDescendantOf DBusMenuModel o) => IsDBusMenuModel o

instance O.HasParentTypes DBusMenuModel
type instance O.ParentTypes DBusMenuModel = '[Gio.MenuModel.MenuModel, GObject.Object.Object]

-- | Cast to `DBusMenuModel`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDBusMenuModel :: (MIO.MonadIO m, IsDBusMenuModel o) => o -> m DBusMenuModel
toDBusMenuModel = MIO.liftIO . B.ManagedPtr.unsafeCastTo DBusMenuModel

-- | Convert 'DBusMenuModel' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusMenuModel) where
    gvalueGType_ = c_g_dbus_menu_model_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DBusMenuModel)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DBusMenuModel)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DBusMenuModel ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusMenuModelMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusMenuModelMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDBusMenuModelMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDBusMenuModelMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDBusMenuModelMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDBusMenuModelMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDBusMenuModelMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDBusMenuModelMethod "isMutable" o = Gio.MenuModel.MenuModelIsMutableMethodInfo
    ResolveDBusMenuModelMethod "itemsChanged" o = Gio.MenuModel.MenuModelItemsChangedMethodInfo
    ResolveDBusMenuModelMethod "iterateItemAttributes" o = Gio.MenuModel.MenuModelIterateItemAttributesMethodInfo
    ResolveDBusMenuModelMethod "iterateItemLinks" o = Gio.MenuModel.MenuModelIterateItemLinksMethodInfo
    ResolveDBusMenuModelMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDBusMenuModelMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDBusMenuModelMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDBusMenuModelMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDBusMenuModelMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDBusMenuModelMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDBusMenuModelMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDBusMenuModelMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDBusMenuModelMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDBusMenuModelMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDBusMenuModelMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDBusMenuModelMethod "getItemAttributeValue" o = Gio.MenuModel.MenuModelGetItemAttributeValueMethodInfo
    ResolveDBusMenuModelMethod "getItemLink" o = Gio.MenuModel.MenuModelGetItemLinkMethodInfo
    ResolveDBusMenuModelMethod "getNItems" o = Gio.MenuModel.MenuModelGetNItemsMethodInfo
    ResolveDBusMenuModelMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDBusMenuModelMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDBusMenuModelMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDBusMenuModelMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDBusMenuModelMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDBusMenuModelMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusMenuModelMethod t DBusMenuModel, O.OverloadedMethod info DBusMenuModel p) => OL.IsLabel t (DBusMenuModel -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusMenuModelMethod t DBusMenuModel, O.OverloadedMethod info DBusMenuModel p, R.HasField t DBusMenuModel p) => R.HasField t DBusMenuModel p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusMenuModelMethod t DBusMenuModel, O.OverloadedMethodInfo info DBusMenuModel) => OL.IsLabel t (O.MethodProxy info DBusMenuModel) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusMenuModel
type instance O.AttributeList DBusMenuModel = DBusMenuModelAttributeList
type DBusMenuModelAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DBusMenuModel = DBusMenuModelSignalList
type DBusMenuModelSignalList = ('[ '("itemsChanged", Gio.MenuModel.MenuModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DBusMenuModel::get
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDBusConnection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bus_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the bus name which exports the menu model\n    or %NULL if @connection is not a message bus connection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the object path at which the menu model is exported"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusMenuModel" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_menu_model_get" g_dbus_menu_model_get :: 
    Ptr Gio.DBusConnection.DBusConnection -> -- connection : TInterface (Name {namespace = "Gio", name = "DBusConnection"})
    CString ->                              -- bus_name : TBasicType TUTF8
    CString ->                              -- object_path : TBasicType TUTF8
    IO (Ptr DBusMenuModel)

-- | Obtains a t'GI.Gio.Objects.DBusMenuModel.DBusMenuModel' for the menu model which is exported
-- at the given /@busName@/ and /@objectPath@/.
-- 
-- The thread default main context is taken at the time of this call.
-- All signals on the menu model (and any linked models) are reported
-- with respect to this context.  All calls on the returned menu model
-- (and linked models) must also originate from this same context, with
-- the thread default main context unchanged.
-- 
-- /Since: 2.32/
dBusMenuModelGet ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    a
    -- ^ /@connection@/: a t'GI.Gio.Objects.DBusConnection.DBusConnection'
    -> Maybe (T.Text)
    -- ^ /@busName@/: the bus name which exports the menu model
    --     or 'P.Nothing' if /@connection@/ is not a message bus connection
    -> T.Text
    -- ^ /@objectPath@/: the object path at which the menu model is exported
    -> m DBusMenuModel
    -- ^ __Returns:__ a t'GI.Gio.Objects.DBusMenuModel.DBusMenuModel' object. Free with
    --     'GI.GObject.Objects.Object.objectUnref'.
dBusMenuModelGet connection busName objectPath = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeBusName <- case busName of
        Nothing -> return FP.nullPtr
        Just jBusName -> do
            jBusName' <- textToCString jBusName
            return jBusName'
    objectPath' <- textToCString objectPath
    result <- g_dbus_menu_model_get connection' maybeBusName objectPath'
    checkUnexpectedReturnNULL "dBusMenuModelGet" result
    result' <- (wrapObject DBusMenuModel) result
    touchManagedPtr connection
    freeMem maybeBusName
    freeMem objectPath'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


