{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GCredentials@ type is a reference-counted wrapper for native
-- credentials.
-- 
-- The information in @GCredentials@ is typically used for identifying,
-- authenticating and authorizing other processes.
-- 
-- Some operating systems supports looking up the credentials of the remote
-- peer of a communication endpoint - see e.g. 'GI.Gio.Objects.Socket.socketGetCredentials'.
-- 
-- Some operating systems supports securely sending and receiving
-- credentials over a Unix Domain Socket, see t'GI.Gio.Objects.UnixCredentialsMessage.UnixCredentialsMessage',
-- 'GI.Gio.Objects.UnixConnection.unixConnectionSendCredentials' and
-- 'GI.Gio.Objects.UnixConnection.unixConnectionReceiveCredentials' for details.
-- 
-- On Linux, the native credential type is a @struct ucred@ - see the
-- <http://developer.gnome.org/gio/stable/man:unix(7 `unix(7)` man page>) for details. This corresponds to
-- @G_CREDENTIALS_TYPE_LINUX_UCRED@.
-- 
-- On Apple operating systems (including iOS, tvOS, and macOS), the native credential
-- type is a @struct xucred@. This corresponds to @G_CREDENTIALS_TYPE_APPLE_XUCRED@.
-- 
-- On FreeBSD, Debian GNU\/kFreeBSD, and GNU\/Hurd, the native credential type is a
-- @struct cmsgcred@. This corresponds to @G_CREDENTIALS_TYPE_FREEBSD_CMSGCRED@.
-- 
-- On NetBSD, the native credential type is a @struct unpcbid@.
-- This corresponds to @G_CREDENTIALS_TYPE_NETBSD_UNPCBID@.
-- 
-- On OpenBSD, the native credential type is a @struct sockpeercred@.
-- This corresponds to @G_CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED@.
-- 
-- On Solaris (including OpenSolaris and its derivatives), the native credential type
-- is a @ucred_t@. This corresponds to @G_CREDENTIALS_TYPE_SOLARIS_UCRED@.
-- 
-- Since GLib 2.72, on Windows, the native credentials may contain the PID of a
-- process. This corresponds to @G_CREDENTIALS_TYPE_WIN32_PID@.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.Credentials
    ( 

-- * Exported types
    Credentials(..)                         ,
    IsCredentials                           ,
    toCredentials                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isSameUser]("GI.Gio.Objects.Credentials#g:method:isSameUser"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Objects.Credentials#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getUnixPid]("GI.Gio.Objects.Credentials#g:method:getUnixPid"), [getUnixUser]("GI.Gio.Objects.Credentials#g:method:getUnixUser").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setNative]("GI.Gio.Objects.Credentials#g:method:setNative"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setUnixUser]("GI.Gio.Objects.Credentials#g:method:setUnixUser").

#if defined(ENABLE_OVERLOADING)
    ResolveCredentialsMethod                ,
#endif

-- ** getUnixPid #method:getUnixPid#

#if defined(ENABLE_OVERLOADING)
    CredentialsGetUnixPidMethodInfo         ,
#endif
    credentialsGetUnixPid                   ,


-- ** getUnixUser #method:getUnixUser#

#if defined(ENABLE_OVERLOADING)
    CredentialsGetUnixUserMethodInfo        ,
#endif
    credentialsGetUnixUser                  ,


-- ** isSameUser #method:isSameUser#

#if defined(ENABLE_OVERLOADING)
    CredentialsIsSameUserMethodInfo         ,
#endif
    credentialsIsSameUser                   ,


-- ** new #method:new#

    credentialsNew                          ,


-- ** setNative #method:setNative#

#if defined(ENABLE_OVERLOADING)
    CredentialsSetNativeMethodInfo          ,
#endif
    credentialsSetNative                    ,


-- ** setUnixUser #method:setUnixUser#

#if defined(ENABLE_OVERLOADING)
    CredentialsSetUnixUserMethodInfo        ,
#endif
    credentialsSetUnixUser                  ,


-- ** toString #method:toString#

#if defined(ENABLE_OVERLOADING)
    CredentialsToStringMethodInfo           ,
#endif
    credentialsToString                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums

#endif

-- | Memory-managed wrapper type.
newtype Credentials = Credentials (SP.ManagedPtr Credentials)
    deriving (Eq)

instance SP.ManagedPtrNewtype Credentials where
    toManagedPtr (Credentials p) = p

foreign import ccall "g_credentials_get_type"
    c_g_credentials_get_type :: IO B.Types.GType

instance B.Types.TypedObject Credentials where
    glibType = c_g_credentials_get_type

instance B.Types.GObject Credentials

-- | Type class for types which can be safely cast to `Credentials`, for instance with `toCredentials`.
class (SP.GObject o, O.IsDescendantOf Credentials o) => IsCredentials o
instance (SP.GObject o, O.IsDescendantOf Credentials o) => IsCredentials o

instance O.HasParentTypes Credentials
type instance O.ParentTypes Credentials = '[GObject.Object.Object]

-- | Cast to `Credentials`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toCredentials :: (MIO.MonadIO m, IsCredentials o) => o -> m Credentials
toCredentials = MIO.liftIO . B.ManagedPtr.unsafeCastTo Credentials

-- | Convert 'Credentials' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Credentials) where
    gvalueGType_ = c_g_credentials_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Credentials)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Credentials)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Credentials ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCredentialsMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCredentialsMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCredentialsMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCredentialsMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCredentialsMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCredentialsMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCredentialsMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCredentialsMethod "isSameUser" o = CredentialsIsSameUserMethodInfo
    ResolveCredentialsMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCredentialsMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCredentialsMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCredentialsMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCredentialsMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCredentialsMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCredentialsMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCredentialsMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCredentialsMethod "toString" o = CredentialsToStringMethodInfo
    ResolveCredentialsMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCredentialsMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCredentialsMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCredentialsMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCredentialsMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCredentialsMethod "getUnixPid" o = CredentialsGetUnixPidMethodInfo
    ResolveCredentialsMethod "getUnixUser" o = CredentialsGetUnixUserMethodInfo
    ResolveCredentialsMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCredentialsMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCredentialsMethod "setNative" o = CredentialsSetNativeMethodInfo
    ResolveCredentialsMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCredentialsMethod "setUnixUser" o = CredentialsSetUnixUserMethodInfo
    ResolveCredentialsMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCredentialsMethod t Credentials, O.OverloadedMethod info Credentials p) => OL.IsLabel t (Credentials -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCredentialsMethod t Credentials, O.OverloadedMethod info Credentials p, R.HasField t Credentials p) => R.HasField t Credentials p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCredentialsMethod t Credentials, O.OverloadedMethodInfo info Credentials) => OL.IsLabel t (O.MethodProxy info Credentials) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Credentials
type instance O.AttributeList Credentials = CredentialsAttributeList
type CredentialsAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Credentials = CredentialsSignalList
type CredentialsSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Credentials::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Credentials" })
-- throws : False
-- Skip return : False

foreign import ccall "g_credentials_new" g_credentials_new :: 
    IO (Ptr Credentials)

-- | Creates a new t'GI.Gio.Objects.Credentials.Credentials' object with credentials matching the
-- the current process.
-- 
-- /Since: 2.26/
credentialsNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Credentials
    -- ^ __Returns:__ A t'GI.Gio.Objects.Credentials.Credentials'. Free with 'GI.GObject.Objects.Object.objectUnref'.
credentialsNew  = liftIO $ do
    result <- g_credentials_new
    checkUnexpectedReturnNULL "credentialsNew" result
    result' <- (wrapObject Credentials) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Credentials::get_unix_pid
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "credentials"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Credentials" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCredentials" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType Tpid_t)
-- throws : True
-- Skip return : False

foreign import ccall "g_credentials_get_unix_pid" g_credentials_get_unix_pid :: 
    Ptr Credentials ->                      -- credentials : TInterface (Name {namespace = "Gio", name = "Credentials"})
    Ptr (Ptr GError) ->                     -- error
    IO DI.Int32

-- | Tries to get the UNIX process identifier from /@credentials@/. This
-- method is only available on UNIX platforms.
-- 
-- This operation can fail if t'GI.Gio.Objects.Credentials.Credentials' is not supported on the
-- OS or if the native credentials type does not contain information
-- about the UNIX process ID.
-- 
-- /Since: 2.36/
credentialsGetUnixPid ::
    (B.CallStack.HasCallStack, MonadIO m, IsCredentials a) =>
    a
    -- ^ /@credentials@/: A t'GI.Gio.Objects.Credentials.Credentials'
    -> m DI.Int32
    -- ^ __Returns:__ The UNIX process ID, or @-1@ if /@error@/ is set. /(Can throw 'Data.GI.Base.GError.GError')/
credentialsGetUnixPid credentials = liftIO $ do
    credentials' <- unsafeManagedPtrCastPtr credentials
    onException (do
        result <- propagateGError $ g_credentials_get_unix_pid credentials'
        touchManagedPtr credentials
        return result
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data CredentialsGetUnixPidMethodInfo
instance (signature ~ (m DI.Int32), MonadIO m, IsCredentials a) => O.OverloadedMethod CredentialsGetUnixPidMethodInfo a signature where
    overloadedMethod = credentialsGetUnixPid

instance O.OverloadedMethodInfo CredentialsGetUnixPidMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Credentials.credentialsGetUnixPid",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Credentials.html#v:credentialsGetUnixPid"
        })


#endif

-- method Credentials::get_unix_user
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "credentials"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Credentials" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCredentials" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType Tuid_t)
-- throws : True
-- Skip return : False

foreign import ccall "g_credentials_get_unix_user" g_credentials_get_unix_user :: 
    Ptr Credentials ->                      -- credentials : TInterface (Name {namespace = "Gio", name = "Credentials"})
    Ptr (Ptr GError) ->                     -- error
    IO DW.Word32

-- | Tries to get the UNIX user identifier from /@credentials@/. This
-- method is only available on UNIX platforms.
-- 
-- This operation can fail if t'GI.Gio.Objects.Credentials.Credentials' is not supported on the
-- OS or if the native credentials type does not contain information
-- about the UNIX user.
-- 
-- /Since: 2.26/
credentialsGetUnixUser ::
    (B.CallStack.HasCallStack, MonadIO m, IsCredentials a) =>
    a
    -- ^ /@credentials@/: A t'GI.Gio.Objects.Credentials.Credentials'
    -> m DW.Word32
    -- ^ __Returns:__ The UNIX user identifier or @-1@ if /@error@/ is set. /(Can throw 'Data.GI.Base.GError.GError')/
credentialsGetUnixUser credentials = liftIO $ do
    credentials' <- unsafeManagedPtrCastPtr credentials
    onException (do
        result <- propagateGError $ g_credentials_get_unix_user credentials'
        touchManagedPtr credentials
        return result
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data CredentialsGetUnixUserMethodInfo
instance (signature ~ (m DW.Word32), MonadIO m, IsCredentials a) => O.OverloadedMethod CredentialsGetUnixUserMethodInfo a signature where
    overloadedMethod = credentialsGetUnixUser

instance O.OverloadedMethodInfo CredentialsGetUnixUserMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Credentials.credentialsGetUnixUser",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Credentials.html#v:credentialsGetUnixUser"
        })


#endif

-- method Credentials::is_same_user
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "credentials"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Credentials" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCredentials." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "other_credentials"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Credentials" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCredentials." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_credentials_is_same_user" g_credentials_is_same_user :: 
    Ptr Credentials ->                      -- credentials : TInterface (Name {namespace = "Gio", name = "Credentials"})
    Ptr Credentials ->                      -- other_credentials : TInterface (Name {namespace = "Gio", name = "Credentials"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Checks if /@credentials@/ and /@otherCredentials@/ is the same user.
-- 
-- This operation can fail if t'GI.Gio.Objects.Credentials.Credentials' is not supported on the
-- the OS.
-- 
-- /Since: 2.26/
credentialsIsSameUser ::
    (B.CallStack.HasCallStack, MonadIO m, IsCredentials a, IsCredentials b) =>
    a
    -- ^ /@credentials@/: A t'GI.Gio.Objects.Credentials.Credentials'.
    -> b
    -- ^ /@otherCredentials@/: A t'GI.Gio.Objects.Credentials.Credentials'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
credentialsIsSameUser credentials otherCredentials = liftIO $ do
    credentials' <- unsafeManagedPtrCastPtr credentials
    otherCredentials' <- unsafeManagedPtrCastPtr otherCredentials
    onException (do
        _ <- propagateGError $ g_credentials_is_same_user credentials' otherCredentials'
        touchManagedPtr credentials
        touchManagedPtr otherCredentials
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data CredentialsIsSameUserMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsCredentials a, IsCredentials b) => O.OverloadedMethod CredentialsIsSameUserMethodInfo a signature where
    overloadedMethod = credentialsIsSameUser

instance O.OverloadedMethodInfo CredentialsIsSameUserMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Credentials.credentialsIsSameUser",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Credentials.html#v:credentialsIsSameUser"
        })


#endif

-- method Credentials::set_native
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "credentials"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Credentials" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCredentials." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "native_type"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "CredentialsType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The type of native credentials to set."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "native"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A pointer to native credentials."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_credentials_set_native" g_credentials_set_native :: 
    Ptr Credentials ->                      -- credentials : TInterface (Name {namespace = "Gio", name = "Credentials"})
    CUInt ->                                -- native_type : TInterface (Name {namespace = "Gio", name = "CredentialsType"})
    Ptr () ->                               -- native : TBasicType TPtr
    IO ()

-- | Copies the native credentials of type /@nativeType@/ from /@native@/
-- into /@credentials@/.
-- 
-- It is a programming error (which will cause a warning to be
-- logged) to use this method if there is no t'GI.Gio.Objects.Credentials.Credentials' support for
-- the OS or if /@nativeType@/ isn\'t supported by the OS.
-- 
-- /Since: 2.26/
credentialsSetNative ::
    (B.CallStack.HasCallStack, MonadIO m, IsCredentials a) =>
    a
    -- ^ /@credentials@/: A t'GI.Gio.Objects.Credentials.Credentials'.
    -> Gio.Enums.CredentialsType
    -- ^ /@nativeType@/: The type of native credentials to set.
    -> Ptr ()
    -- ^ /@native@/: A pointer to native credentials.
    -> m ()
credentialsSetNative credentials nativeType native = liftIO $ do
    credentials' <- unsafeManagedPtrCastPtr credentials
    let nativeType' = (fromIntegral . fromEnum) nativeType
    g_credentials_set_native credentials' nativeType' native
    touchManagedPtr credentials
    return ()

#if defined(ENABLE_OVERLOADING)
data CredentialsSetNativeMethodInfo
instance (signature ~ (Gio.Enums.CredentialsType -> Ptr () -> m ()), MonadIO m, IsCredentials a) => O.OverloadedMethod CredentialsSetNativeMethodInfo a signature where
    overloadedMethod = credentialsSetNative

instance O.OverloadedMethodInfo CredentialsSetNativeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Credentials.credentialsSetNative",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Credentials.html#v:credentialsSetNative"
        })


#endif

-- method Credentials::set_unix_user
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "credentials"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Credentials" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCredentials." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uid"
--           , argType = TBasicType Tuid_t
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The UNIX user identifier to set."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_credentials_set_unix_user" g_credentials_set_unix_user :: 
    Ptr Credentials ->                      -- credentials : TInterface (Name {namespace = "Gio", name = "Credentials"})
    DW.Word32 ->                            -- uid : TBasicType Tuid_t
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Tries to set the UNIX user identifier on /@credentials@/. This method
-- is only available on UNIX platforms.
-- 
-- This operation can fail if t'GI.Gio.Objects.Credentials.Credentials' is not supported on the
-- OS or if the native credentials type does not contain information
-- about the UNIX user. It can also fail if the OS does not allow the
-- use of \"spoofed\" credentials.
-- 
-- /Since: 2.26/
credentialsSetUnixUser ::
    (B.CallStack.HasCallStack, MonadIO m, IsCredentials a) =>
    a
    -- ^ /@credentials@/: A t'GI.Gio.Objects.Credentials.Credentials'.
    -> DW.Word32
    -- ^ /@uid@/: The UNIX user identifier to set.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
credentialsSetUnixUser credentials uid = liftIO $ do
    credentials' <- unsafeManagedPtrCastPtr credentials
    onException (do
        _ <- propagateGError $ g_credentials_set_unix_user credentials' uid
        touchManagedPtr credentials
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data CredentialsSetUnixUserMethodInfo
instance (signature ~ (DW.Word32 -> m ()), MonadIO m, IsCredentials a) => O.OverloadedMethod CredentialsSetUnixUserMethodInfo a signature where
    overloadedMethod = credentialsSetUnixUser

instance O.OverloadedMethodInfo CredentialsSetUnixUserMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Credentials.credentialsSetUnixUser",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Credentials.html#v:credentialsSetUnixUser"
        })


#endif

-- method Credentials::to_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "credentials"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Credentials" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCredentials object."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_credentials_to_string" g_credentials_to_string :: 
    Ptr Credentials ->                      -- credentials : TInterface (Name {namespace = "Gio", name = "Credentials"})
    IO CString

-- | Creates a human-readable textual representation of /@credentials@/
-- that can be used in logging and debug messages. The format of the
-- returned string may change in future GLib release.
-- 
-- /Since: 2.26/
credentialsToString ::
    (B.CallStack.HasCallStack, MonadIO m, IsCredentials a) =>
    a
    -- ^ /@credentials@/: A t'GI.Gio.Objects.Credentials.Credentials' object.
    -> m T.Text
    -- ^ __Returns:__ A string that should be freed with 'GI.GLib.Functions.free'.
credentialsToString credentials = liftIO $ do
    credentials' <- unsafeManagedPtrCastPtr credentials
    result <- g_credentials_to_string credentials'
    checkUnexpectedReturnNULL "credentialsToString" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr credentials
    return result'

#if defined(ENABLE_OVERLOADING)
data CredentialsToStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsCredentials a) => O.OverloadedMethod CredentialsToStringMethodInfo a signature where
    overloadedMethod = credentialsToString

instance O.OverloadedMethodInfo CredentialsToStringMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.Credentials.credentialsToString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-Credentials.html#v:credentialsToString"
        })


#endif


