{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Converter input stream implements t'GI.Gio.Objects.InputStream.InputStream' and allows
-- conversion of data of various types during reading.
-- 
-- As of GLib 2.34, @GConverterInputStream@ implements
-- t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.ConverterInputStream
    ( 

-- * Exported types
    ConverterInputStream(..)                ,
    IsConverterInputStream                  ,
    toConverterInputStream                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canPoll]("GI.Gio.Interfaces.PollableInputStream#g:method:canPoll"), [clearPending]("GI.Gio.Objects.InputStream#g:method:clearPending"), [close]("GI.Gio.Objects.InputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.InputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.InputStream#g:method:closeFinish"), [createSource]("GI.Gio.Interfaces.PollableInputStream#g:method:createSource"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.InputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.InputStream#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isReadable]("GI.Gio.Interfaces.PollableInputStream#g:method:isReadable"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [read]("GI.Gio.Objects.InputStream#g:method:read"), [readAll]("GI.Gio.Objects.InputStream#g:method:readAll"), [readAllAsync]("GI.Gio.Objects.InputStream#g:method:readAllAsync"), [readAllFinish]("GI.Gio.Objects.InputStream#g:method:readAllFinish"), [readAsync]("GI.Gio.Objects.InputStream#g:method:readAsync"), [readBytes]("GI.Gio.Objects.InputStream#g:method:readBytes"), [readBytesAsync]("GI.Gio.Objects.InputStream#g:method:readBytesAsync"), [readBytesFinish]("GI.Gio.Objects.InputStream#g:method:readBytesFinish"), [readFinish]("GI.Gio.Objects.InputStream#g:method:readFinish"), [readNonblocking]("GI.Gio.Interfaces.PollableInputStream#g:method:readNonblocking"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [skip]("GI.Gio.Objects.InputStream#g:method:skip"), [skipAsync]("GI.Gio.Objects.InputStream#g:method:skipAsync"), [skipFinish]("GI.Gio.Objects.InputStream#g:method:skipFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBaseStream]("GI.Gio.Objects.FilterInputStream#g:method:getBaseStream"), [getCloseBaseStream]("GI.Gio.Objects.FilterInputStream#g:method:getCloseBaseStream"), [getConverter]("GI.Gio.Objects.ConverterInputStream#g:method:getConverter"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setCloseBaseStream]("GI.Gio.Objects.FilterInputStream#g:method:setCloseBaseStream"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.InputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveConverterInputStreamMethod       ,
#endif

-- ** getConverter #method:getConverter#

#if defined(ENABLE_OVERLOADING)
    ConverterInputStreamGetConverterMethodInfo,
#endif
    converterInputStreamGetConverter        ,


-- ** new #method:new#

    converterInputStreamNew                 ,




 -- * Properties


-- ** converter #attr:converter#
-- | The converter object.

#if defined(ENABLE_OVERLOADING)
    ConverterInputStreamConverterPropertyInfo,
#endif
    constructConverterInputStreamConverter  ,
#if defined(ENABLE_OVERLOADING)
    converterInputStreamConverter           ,
#endif
    getConverterInputStreamConverter        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Converter as Gio.Converter
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableInputStream as Gio.PollableInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FilterInputStream as Gio.FilterInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Converter as Gio.Converter
import {-# SOURCE #-} qualified GI.Gio.Interfaces.PollableInputStream as Gio.PollableInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FilterInputStream as Gio.FilterInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#endif

-- | Memory-managed wrapper type.
newtype ConverterInputStream = ConverterInputStream (SP.ManagedPtr ConverterInputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype ConverterInputStream where
    toManagedPtr (ConverterInputStream p) = p

foreign import ccall "g_converter_input_stream_get_type"
    c_g_converter_input_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject ConverterInputStream where
    glibType = c_g_converter_input_stream_get_type

instance B.Types.GObject ConverterInputStream

-- | Type class for types which can be safely cast to `ConverterInputStream`, for instance with `toConverterInputStream`.
class (SP.GObject o, O.IsDescendantOf ConverterInputStream o) => IsConverterInputStream o
instance (SP.GObject o, O.IsDescendantOf ConverterInputStream o) => IsConverterInputStream o

instance O.HasParentTypes ConverterInputStream
type instance O.ParentTypes ConverterInputStream = '[Gio.FilterInputStream.FilterInputStream, Gio.InputStream.InputStream, GObject.Object.Object, Gio.PollableInputStream.PollableInputStream]

-- | Cast to `ConverterInputStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toConverterInputStream :: (MIO.MonadIO m, IsConverterInputStream o) => o -> m ConverterInputStream
toConverterInputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo ConverterInputStream

-- | Convert 'ConverterInputStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ConverterInputStream) where
    gvalueGType_ = c_g_converter_input_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ConverterInputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ConverterInputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ConverterInputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveConverterInputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveConverterInputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveConverterInputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveConverterInputStreamMethod "canPoll" o = Gio.PollableInputStream.PollableInputStreamCanPollMethodInfo
    ResolveConverterInputStreamMethod "clearPending" o = Gio.InputStream.InputStreamClearPendingMethodInfo
    ResolveConverterInputStreamMethod "close" o = Gio.InputStream.InputStreamCloseMethodInfo
    ResolveConverterInputStreamMethod "closeAsync" o = Gio.InputStream.InputStreamCloseAsyncMethodInfo
    ResolveConverterInputStreamMethod "closeFinish" o = Gio.InputStream.InputStreamCloseFinishMethodInfo
    ResolveConverterInputStreamMethod "createSource" o = Gio.PollableInputStream.PollableInputStreamCreateSourceMethodInfo
    ResolveConverterInputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveConverterInputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveConverterInputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveConverterInputStreamMethod "hasPending" o = Gio.InputStream.InputStreamHasPendingMethodInfo
    ResolveConverterInputStreamMethod "isClosed" o = Gio.InputStream.InputStreamIsClosedMethodInfo
    ResolveConverterInputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveConverterInputStreamMethod "isReadable" o = Gio.PollableInputStream.PollableInputStreamIsReadableMethodInfo
    ResolveConverterInputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveConverterInputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveConverterInputStreamMethod "read" o = Gio.InputStream.InputStreamReadMethodInfo
    ResolveConverterInputStreamMethod "readAll" o = Gio.InputStream.InputStreamReadAllMethodInfo
    ResolveConverterInputStreamMethod "readAllAsync" o = Gio.InputStream.InputStreamReadAllAsyncMethodInfo
    ResolveConverterInputStreamMethod "readAllFinish" o = Gio.InputStream.InputStreamReadAllFinishMethodInfo
    ResolveConverterInputStreamMethod "readAsync" o = Gio.InputStream.InputStreamReadAsyncMethodInfo
    ResolveConverterInputStreamMethod "readBytes" o = Gio.InputStream.InputStreamReadBytesMethodInfo
    ResolveConverterInputStreamMethod "readBytesAsync" o = Gio.InputStream.InputStreamReadBytesAsyncMethodInfo
    ResolveConverterInputStreamMethod "readBytesFinish" o = Gio.InputStream.InputStreamReadBytesFinishMethodInfo
    ResolveConverterInputStreamMethod "readFinish" o = Gio.InputStream.InputStreamReadFinishMethodInfo
    ResolveConverterInputStreamMethod "readNonblocking" o = Gio.PollableInputStream.PollableInputStreamReadNonblockingMethodInfo
    ResolveConverterInputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveConverterInputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveConverterInputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveConverterInputStreamMethod "skip" o = Gio.InputStream.InputStreamSkipMethodInfo
    ResolveConverterInputStreamMethod "skipAsync" o = Gio.InputStream.InputStreamSkipAsyncMethodInfo
    ResolveConverterInputStreamMethod "skipFinish" o = Gio.InputStream.InputStreamSkipFinishMethodInfo
    ResolveConverterInputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveConverterInputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveConverterInputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveConverterInputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveConverterInputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveConverterInputStreamMethod "getBaseStream" o = Gio.FilterInputStream.FilterInputStreamGetBaseStreamMethodInfo
    ResolveConverterInputStreamMethod "getCloseBaseStream" o = Gio.FilterInputStream.FilterInputStreamGetCloseBaseStreamMethodInfo
    ResolveConverterInputStreamMethod "getConverter" o = ConverterInputStreamGetConverterMethodInfo
    ResolveConverterInputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveConverterInputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveConverterInputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveConverterInputStreamMethod "setCloseBaseStream" o = Gio.FilterInputStream.FilterInputStreamSetCloseBaseStreamMethodInfo
    ResolveConverterInputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveConverterInputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveConverterInputStreamMethod "setPending" o = Gio.InputStream.InputStreamSetPendingMethodInfo
    ResolveConverterInputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveConverterInputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveConverterInputStreamMethod t ConverterInputStream, O.OverloadedMethod info ConverterInputStream p) => OL.IsLabel t (ConverterInputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveConverterInputStreamMethod t ConverterInputStream, O.OverloadedMethod info ConverterInputStream p, R.HasField t ConverterInputStream p) => R.HasField t ConverterInputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveConverterInputStreamMethod t ConverterInputStream, O.OverloadedMethodInfo info ConverterInputStream) => OL.IsLabel t (O.MethodProxy info ConverterInputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "converter"
   -- Type: TInterface (Name {namespace = "Gio", name = "Converter"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@converter@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' converterInputStream #converter
-- @
getConverterInputStreamConverter :: (MonadIO m, IsConverterInputStream o) => o -> m Gio.Converter.Converter
getConverterInputStreamConverter obj = MIO.liftIO $ checkUnexpectedNothing "getConverterInputStreamConverter" $ B.Properties.getObjectPropertyObject obj "converter" Gio.Converter.Converter

-- | Construct a `GValueConstruct` with valid value for the “@converter@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructConverterInputStreamConverter :: (IsConverterInputStream o, MIO.MonadIO m, Gio.Converter.IsConverter a) => a -> m (GValueConstruct o)
constructConverterInputStreamConverter val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "converter" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ConverterInputStreamConverterPropertyInfo
instance AttrInfo ConverterInputStreamConverterPropertyInfo where
    type AttrAllowedOps ConverterInputStreamConverterPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ConverterInputStreamConverterPropertyInfo = IsConverterInputStream
    type AttrSetTypeConstraint ConverterInputStreamConverterPropertyInfo = Gio.Converter.IsConverter
    type AttrTransferTypeConstraint ConverterInputStreamConverterPropertyInfo = Gio.Converter.IsConverter
    type AttrTransferType ConverterInputStreamConverterPropertyInfo = Gio.Converter.Converter
    type AttrGetType ConverterInputStreamConverterPropertyInfo = Gio.Converter.Converter
    type AttrLabel ConverterInputStreamConverterPropertyInfo = "converter"
    type AttrOrigin ConverterInputStreamConverterPropertyInfo = ConverterInputStream
    attrGet = getConverterInputStreamConverter
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.Converter.Converter v
    attrConstruct = constructConverterInputStreamConverter
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ConverterInputStream.converter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-ConverterInputStream.html#g:attr:converter"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ConverterInputStream
type instance O.AttributeList ConverterInputStream = ConverterInputStreamAttributeList
type ConverterInputStreamAttributeList = ('[ '("baseStream", Gio.FilterInputStream.FilterInputStreamBaseStreamPropertyInfo), '("closeBaseStream", Gio.FilterInputStream.FilterInputStreamCloseBaseStreamPropertyInfo), '("converter", ConverterInputStreamConverterPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
converterInputStreamConverter :: AttrLabelProxy "converter"
converterInputStreamConverter = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ConverterInputStream = ConverterInputStreamSignalList
type ConverterInputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ConverterInputStream::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "base_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInputStream" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "converter"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Converter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GConverter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "ConverterInputStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_converter_input_stream_new" g_converter_input_stream_new :: 
    Ptr Gio.InputStream.InputStream ->      -- base_stream : TInterface (Name {namespace = "Gio", name = "InputStream"})
    Ptr Gio.Converter.Converter ->          -- converter : TInterface (Name {namespace = "Gio", name = "Converter"})
    IO (Ptr ConverterInputStream)

-- | Creates a new converter input stream for the /@baseStream@/.
converterInputStreamNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Converter.IsConverter b) =>
    a
    -- ^ /@baseStream@/: a t'GI.Gio.Objects.InputStream.InputStream'
    -> b
    -- ^ /@converter@/: a t'GI.Gio.Interfaces.Converter.Converter'
    -> m ConverterInputStream
    -- ^ __Returns:__ a new t'GI.Gio.Objects.InputStream.InputStream'.
converterInputStreamNew baseStream converter = liftIO $ do
    baseStream' <- unsafeManagedPtrCastPtr baseStream
    converter' <- unsafeManagedPtrCastPtr converter
    result <- g_converter_input_stream_new baseStream' converter'
    checkUnexpectedReturnNULL "converterInputStreamNew" result
    result' <- (wrapObject ConverterInputStream) result
    touchManagedPtr baseStream
    touchManagedPtr converter
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ConverterInputStream::get_converter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "converter_stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "ConverterInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GConverterInputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Converter" })
-- throws : False
-- Skip return : False

foreign import ccall "g_converter_input_stream_get_converter" g_converter_input_stream_get_converter :: 
    Ptr ConverterInputStream ->             -- converter_stream : TInterface (Name {namespace = "Gio", name = "ConverterInputStream"})
    IO (Ptr Gio.Converter.Converter)

-- | Gets the t'GI.Gio.Interfaces.Converter.Converter' that is used by /@converterStream@/.
-- 
-- /Since: 2.24/
converterInputStreamGetConverter ::
    (B.CallStack.HasCallStack, MonadIO m, IsConverterInputStream a) =>
    a
    -- ^ /@converterStream@/: a t'GI.Gio.Objects.ConverterInputStream.ConverterInputStream'
    -> m Gio.Converter.Converter
    -- ^ __Returns:__ the converter of the converter input stream
converterInputStreamGetConverter converterStream = liftIO $ do
    converterStream' <- unsafeManagedPtrCastPtr converterStream
    result <- g_converter_input_stream_get_converter converterStream'
    checkUnexpectedReturnNULL "converterInputStreamGetConverter" result
    result' <- (newObject Gio.Converter.Converter) result
    touchManagedPtr converterStream
    return result'

#if defined(ENABLE_OVERLOADING)
data ConverterInputStreamGetConverterMethodInfo
instance (signature ~ (m Gio.Converter.Converter), MonadIO m, IsConverterInputStream a) => O.OverloadedMethod ConverterInputStreamGetConverterMethodInfo a signature where
    overloadedMethod = converterInputStreamGetConverter

instance O.OverloadedMethodInfo ConverterInputStreamGetConverterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ConverterInputStream.converterInputStreamGetConverter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Objects-ConverterInputStream.html#v:converterInputStreamGetConverter"
        })


#endif


