{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GTlsFileDatabase@ is implemented by t'GI.Gio.Objects.TlsDatabase.TlsDatabase' objects which
-- load their certificate information from a file. It is an interface which
-- TLS library specific subtypes implement.
-- 
-- /Since: 2.30/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.TlsFileDatabase
    ( 

-- * Exported types
    TlsFileDatabase(..)                     ,
    IsTlsFileDatabase                       ,
    toTlsFileDatabase                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [createCertificateHandle]("GI.Gio.Objects.TlsDatabase#g:method:createCertificateHandle"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [lookupCertificateForHandle]("GI.Gio.Objects.TlsDatabase#g:method:lookupCertificateForHandle"), [lookupCertificateForHandleAsync]("GI.Gio.Objects.TlsDatabase#g:method:lookupCertificateForHandleAsync"), [lookupCertificateForHandleFinish]("GI.Gio.Objects.TlsDatabase#g:method:lookupCertificateForHandleFinish"), [lookupCertificateIssuer]("GI.Gio.Objects.TlsDatabase#g:method:lookupCertificateIssuer"), [lookupCertificateIssuerAsync]("GI.Gio.Objects.TlsDatabase#g:method:lookupCertificateIssuerAsync"), [lookupCertificateIssuerFinish]("GI.Gio.Objects.TlsDatabase#g:method:lookupCertificateIssuerFinish"), [lookupCertificatesIssuedBy]("GI.Gio.Objects.TlsDatabase#g:method:lookupCertificatesIssuedBy"), [lookupCertificatesIssuedByAsync]("GI.Gio.Objects.TlsDatabase#g:method:lookupCertificatesIssuedByAsync"), [lookupCertificatesIssuedByFinish]("GI.Gio.Objects.TlsDatabase#g:method:lookupCertificatesIssuedByFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [verifyChain]("GI.Gio.Objects.TlsDatabase#g:method:verifyChain"), [verifyChainAsync]("GI.Gio.Objects.TlsDatabase#g:method:verifyChainAsync"), [verifyChainFinish]("GI.Gio.Objects.TlsDatabase#g:method:verifyChainFinish"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveTlsFileDatabaseMethod            ,
#endif

-- ** new #method:new#

    tlsFileDatabaseNew                      ,




 -- * Properties


-- ** anchors #attr:anchors#
-- | The path to a file containing PEM encoded certificate authority
-- root anchors. The certificates in this file will be treated as
-- root authorities for the purpose of verifying other certificates
-- via the 'GI.Gio.Objects.TlsDatabase.tlsDatabaseVerifyChain' operation.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    TlsFileDatabaseAnchorsPropertyInfo      ,
#endif
    clearTlsFileDatabaseAnchors             ,
    constructTlsFileDatabaseAnchors         ,
    getTlsFileDatabaseAnchors               ,
    setTlsFileDatabaseAnchors               ,
#if defined(ENABLE_OVERLOADING)
    tlsFileDatabaseAnchors                  ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsCertificate as Gio.TlsCertificate
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsConnection as Gio.TlsConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsDatabase as Gio.TlsDatabase
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsInteraction as Gio.TlsInteraction
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsPassword as Gio.TlsPassword
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsDatabase as Gio.TlsDatabase

#endif

-- interface TlsFileDatabase 
-- | Memory-managed wrapper type.
newtype TlsFileDatabase = TlsFileDatabase (SP.ManagedPtr TlsFileDatabase)
    deriving (Eq)

instance SP.ManagedPtrNewtype TlsFileDatabase where
    toManagedPtr (TlsFileDatabase p) = p

foreign import ccall "g_tls_file_database_get_type"
    c_g_tls_file_database_get_type :: IO B.Types.GType

instance B.Types.TypedObject TlsFileDatabase where
    glibType = c_g_tls_file_database_get_type

instance B.Types.GObject TlsFileDatabase

-- | Type class for types which can be safely cast to `TlsFileDatabase`, for instance with `toTlsFileDatabase`.
class (SP.GObject o, O.IsDescendantOf TlsFileDatabase o) => IsTlsFileDatabase o
instance (SP.GObject o, O.IsDescendantOf TlsFileDatabase o) => IsTlsFileDatabase o

instance O.HasParentTypes TlsFileDatabase
type instance O.ParentTypes TlsFileDatabase = '[GObject.Object.Object, Gio.TlsDatabase.TlsDatabase]

-- | Cast to `TlsFileDatabase`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toTlsFileDatabase :: (MIO.MonadIO m, IsTlsFileDatabase o) => o -> m TlsFileDatabase
toTlsFileDatabase = MIO.liftIO . B.ManagedPtr.unsafeCastTo TlsFileDatabase

-- | Convert 'TlsFileDatabase' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TlsFileDatabase) where
    gvalueGType_ = c_g_tls_file_database_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TlsFileDatabase)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TlsFileDatabase)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TlsFileDatabase ptr
        else return P.Nothing
        
    

-- VVV Prop "anchors"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@anchors@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsFileDatabase #anchors
-- @
getTlsFileDatabaseAnchors :: (MonadIO m, IsTlsFileDatabase o) => o -> m (Maybe T.Text)
getTlsFileDatabaseAnchors obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "anchors"

-- | Set the value of the “@anchors@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsFileDatabase [ #anchors 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsFileDatabaseAnchors :: (MonadIO m, IsTlsFileDatabase o) => o -> T.Text -> m ()
setTlsFileDatabaseAnchors obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "anchors" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@anchors@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsFileDatabaseAnchors :: (IsTlsFileDatabase o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructTlsFileDatabaseAnchors val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "anchors" (P.Just val)

-- | Set the value of the “@anchors@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #anchors
-- @
clearTlsFileDatabaseAnchors :: (MonadIO m, IsTlsFileDatabase o) => o -> m ()
clearTlsFileDatabaseAnchors obj = liftIO $ B.Properties.setObjectPropertyString obj "anchors" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data TlsFileDatabaseAnchorsPropertyInfo
instance AttrInfo TlsFileDatabaseAnchorsPropertyInfo where
    type AttrAllowedOps TlsFileDatabaseAnchorsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TlsFileDatabaseAnchorsPropertyInfo = IsTlsFileDatabase
    type AttrSetTypeConstraint TlsFileDatabaseAnchorsPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint TlsFileDatabaseAnchorsPropertyInfo = (~) T.Text
    type AttrTransferType TlsFileDatabaseAnchorsPropertyInfo = T.Text
    type AttrGetType TlsFileDatabaseAnchorsPropertyInfo = (Maybe T.Text)
    type AttrLabel TlsFileDatabaseAnchorsPropertyInfo = "anchors"
    type AttrOrigin TlsFileDatabaseAnchorsPropertyInfo = TlsFileDatabase
    attrGet = getTlsFileDatabaseAnchors
    attrSet = setTlsFileDatabaseAnchors
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsFileDatabaseAnchors
    attrClear = clearTlsFileDatabaseAnchors
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsFileDatabase.anchors"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsFileDatabase.html#g:attr:anchors"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TlsFileDatabase
type instance O.AttributeList TlsFileDatabase = TlsFileDatabaseAttributeList
type TlsFileDatabaseAttributeList = ('[ '("anchors", TlsFileDatabaseAnchorsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
tlsFileDatabaseAnchors :: AttrLabelProxy "anchors"
tlsFileDatabaseAnchors = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTlsFileDatabaseMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTlsFileDatabaseMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTlsFileDatabaseMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTlsFileDatabaseMethod "createCertificateHandle" o = Gio.TlsDatabase.TlsDatabaseCreateCertificateHandleMethodInfo
    ResolveTlsFileDatabaseMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTlsFileDatabaseMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTlsFileDatabaseMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTlsFileDatabaseMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTlsFileDatabaseMethod "lookupCertificateForHandle" o = Gio.TlsDatabase.TlsDatabaseLookupCertificateForHandleMethodInfo
    ResolveTlsFileDatabaseMethod "lookupCertificateForHandleAsync" o = Gio.TlsDatabase.TlsDatabaseLookupCertificateForHandleAsyncMethodInfo
    ResolveTlsFileDatabaseMethod "lookupCertificateForHandleFinish" o = Gio.TlsDatabase.TlsDatabaseLookupCertificateForHandleFinishMethodInfo
    ResolveTlsFileDatabaseMethod "lookupCertificateIssuer" o = Gio.TlsDatabase.TlsDatabaseLookupCertificateIssuerMethodInfo
    ResolveTlsFileDatabaseMethod "lookupCertificateIssuerAsync" o = Gio.TlsDatabase.TlsDatabaseLookupCertificateIssuerAsyncMethodInfo
    ResolveTlsFileDatabaseMethod "lookupCertificateIssuerFinish" o = Gio.TlsDatabase.TlsDatabaseLookupCertificateIssuerFinishMethodInfo
    ResolveTlsFileDatabaseMethod "lookupCertificatesIssuedBy" o = Gio.TlsDatabase.TlsDatabaseLookupCertificatesIssuedByMethodInfo
    ResolveTlsFileDatabaseMethod "lookupCertificatesIssuedByAsync" o = Gio.TlsDatabase.TlsDatabaseLookupCertificatesIssuedByAsyncMethodInfo
    ResolveTlsFileDatabaseMethod "lookupCertificatesIssuedByFinish" o = Gio.TlsDatabase.TlsDatabaseLookupCertificatesIssuedByFinishMethodInfo
    ResolveTlsFileDatabaseMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTlsFileDatabaseMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTlsFileDatabaseMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTlsFileDatabaseMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTlsFileDatabaseMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTlsFileDatabaseMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTlsFileDatabaseMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTlsFileDatabaseMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTlsFileDatabaseMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTlsFileDatabaseMethod "verifyChain" o = Gio.TlsDatabase.TlsDatabaseVerifyChainMethodInfo
    ResolveTlsFileDatabaseMethod "verifyChainAsync" o = Gio.TlsDatabase.TlsDatabaseVerifyChainAsyncMethodInfo
    ResolveTlsFileDatabaseMethod "verifyChainFinish" o = Gio.TlsDatabase.TlsDatabaseVerifyChainFinishMethodInfo
    ResolveTlsFileDatabaseMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTlsFileDatabaseMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTlsFileDatabaseMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTlsFileDatabaseMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTlsFileDatabaseMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTlsFileDatabaseMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTlsFileDatabaseMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTlsFileDatabaseMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTlsFileDatabaseMethod t TlsFileDatabase, O.OverloadedMethod info TlsFileDatabase p) => OL.IsLabel t (TlsFileDatabase -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTlsFileDatabaseMethod t TlsFileDatabase, O.OverloadedMethod info TlsFileDatabase p, R.HasField t TlsFileDatabase p) => R.HasField t TlsFileDatabase p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTlsFileDatabaseMethod t TlsFileDatabase, O.OverloadedMethodInfo info TlsFileDatabase) => OL.IsLabel t (O.MethodProxy info TlsFileDatabase) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method TlsFileDatabase::new
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "anchors"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "filename of anchor certificate authorities."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "TlsFileDatabase" })
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_file_database_new" g_tls_file_database_new :: 
    CString ->                              -- anchors : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr TlsFileDatabase)

-- | Creates a new t'GI.Gio.Interfaces.TlsFileDatabase.TlsFileDatabase' which uses anchor certificate authorities
-- in /@anchors@/ to verify certificate chains.
-- 
-- The certificates in /@anchors@/ must be PEM encoded.
-- 
-- /Since: 2.30/
tlsFileDatabaseNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@anchors@/: filename of anchor certificate authorities.
    -> m TlsFileDatabase
    -- ^ __Returns:__ the new
    -- t'GI.Gio.Interfaces.TlsFileDatabase.TlsFileDatabase', or 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
tlsFileDatabaseNew anchors = liftIO $ do
    anchors' <- stringToCString anchors
    onException (do
        result <- propagateGError $ g_tls_file_database_new anchors'
        checkUnexpectedReturnNULL "tlsFileDatabaseNew" result
        result' <- (wrapObject TlsFileDatabase) result
        freeMem anchors'
        return result'
     ) (do
        freeMem anchors'
     )

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TlsFileDatabase = TlsFileDatabaseSignalList
type TlsFileDatabaseSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


