{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GTlsClientConnection@ is the client-side subclass of
-- t'GI.Gio.Objects.TlsConnection.TlsConnection', representing a client-side TLS connection.
-- 
-- /Since: 2.28/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.TlsClientConnection
    ( 

-- * Exported types
    TlsClientConnection(..)                 ,
    IsTlsClientConnection                   ,
    toTlsClientConnection                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearPending]("GI.Gio.Objects.IOStream#g:method:clearPending"), [close]("GI.Gio.Objects.IOStream#g:method:close"), [closeAsync]("GI.Gio.Objects.IOStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.IOStream#g:method:closeFinish"), [copySessionState]("GI.Gio.Interfaces.TlsClientConnection#g:method:copySessionState"), [emitAcceptCertificate]("GI.Gio.Objects.TlsConnection#g:method:emitAcceptCertificate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [handshake]("GI.Gio.Objects.TlsConnection#g:method:handshake"), [handshakeAsync]("GI.Gio.Objects.TlsConnection#g:method:handshakeAsync"), [handshakeFinish]("GI.Gio.Objects.TlsConnection#g:method:handshakeFinish"), [hasPending]("GI.Gio.Objects.IOStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.IOStream#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [spliceAsync]("GI.Gio.Objects.IOStream#g:method:spliceAsync"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAcceptedCas]("GI.Gio.Interfaces.TlsClientConnection#g:method:getAcceptedCas"), [getCertificate]("GI.Gio.Objects.TlsConnection#g:method:getCertificate"), [getChannelBindingData]("GI.Gio.Objects.TlsConnection#g:method:getChannelBindingData"), [getCiphersuiteName]("GI.Gio.Objects.TlsConnection#g:method:getCiphersuiteName"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDatabase]("GI.Gio.Objects.TlsConnection#g:method:getDatabase"), [getInputStream]("GI.Gio.Objects.IOStream#g:method:getInputStream"), [getInteraction]("GI.Gio.Objects.TlsConnection#g:method:getInteraction"), [getNegotiatedProtocol]("GI.Gio.Objects.TlsConnection#g:method:getNegotiatedProtocol"), [getOutputStream]("GI.Gio.Objects.IOStream#g:method:getOutputStream"), [getPeerCertificate]("GI.Gio.Objects.TlsConnection#g:method:getPeerCertificate"), [getPeerCertificateErrors]("GI.Gio.Objects.TlsConnection#g:method:getPeerCertificateErrors"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getProtocolVersion]("GI.Gio.Objects.TlsConnection#g:method:getProtocolVersion"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRehandshakeMode]("GI.Gio.Objects.TlsConnection#g:method:getRehandshakeMode"), [getRequireCloseNotify]("GI.Gio.Objects.TlsConnection#g:method:getRequireCloseNotify"), [getServerIdentity]("GI.Gio.Interfaces.TlsClientConnection#g:method:getServerIdentity"), [getUseSsl3]("GI.Gio.Interfaces.TlsClientConnection#g:method:getUseSsl3"), [getUseSystemCertdb]("GI.Gio.Objects.TlsConnection#g:method:getUseSystemCertdb"), [getValidationFlags]("GI.Gio.Interfaces.TlsClientConnection#g:method:getValidationFlags").
-- 
-- ==== Setters
-- [setAdvertisedProtocols]("GI.Gio.Objects.TlsConnection#g:method:setAdvertisedProtocols"), [setCertificate]("GI.Gio.Objects.TlsConnection#g:method:setCertificate"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDatabase]("GI.Gio.Objects.TlsConnection#g:method:setDatabase"), [setInteraction]("GI.Gio.Objects.TlsConnection#g:method:setInteraction"), [setPending]("GI.Gio.Objects.IOStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRehandshakeMode]("GI.Gio.Objects.TlsConnection#g:method:setRehandshakeMode"), [setRequireCloseNotify]("GI.Gio.Objects.TlsConnection#g:method:setRequireCloseNotify"), [setServerIdentity]("GI.Gio.Interfaces.TlsClientConnection#g:method:setServerIdentity"), [setUseSsl3]("GI.Gio.Interfaces.TlsClientConnection#g:method:setUseSsl3"), [setUseSystemCertdb]("GI.Gio.Objects.TlsConnection#g:method:setUseSystemCertdb"), [setValidationFlags]("GI.Gio.Interfaces.TlsClientConnection#g:method:setValidationFlags").

#if defined(ENABLE_OVERLOADING)
    ResolveTlsClientConnectionMethod        ,
#endif

-- ** copySessionState #method:copySessionState#

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionCopySessionStateMethodInfo,
#endif
    tlsClientConnectionCopySessionState     ,


-- ** getAcceptedCas #method:getAcceptedCas#

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionGetAcceptedCasMethodInfo,
#endif
    tlsClientConnectionGetAcceptedCas       ,


-- ** getServerIdentity #method:getServerIdentity#

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionGetServerIdentityMethodInfo,
#endif
    tlsClientConnectionGetServerIdentity    ,


-- ** getUseSsl3 #method:getUseSsl3#

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionGetUseSsl3MethodInfo ,
#endif
    tlsClientConnectionGetUseSsl3           ,


-- ** getValidationFlags #method:getValidationFlags#

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionGetValidationFlagsMethodInfo,
#endif
    tlsClientConnectionGetValidationFlags   ,


-- ** new #method:new#

    tlsClientConnectionNew                  ,


-- ** setServerIdentity #method:setServerIdentity#

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionSetServerIdentityMethodInfo,
#endif
    tlsClientConnectionSetServerIdentity    ,


-- ** setUseSsl3 #method:setUseSsl3#

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionSetUseSsl3MethodInfo ,
#endif
    tlsClientConnectionSetUseSsl3           ,


-- ** setValidationFlags #method:setValidationFlags#

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionSetValidationFlagsMethodInfo,
#endif
    tlsClientConnectionSetValidationFlags   ,




 -- * Properties


-- ** acceptedCas #attr:acceptedCas#
-- | A list of the distinguished names of the Certificate Authorities
-- that the server will accept client certificates signed by. If the
-- server requests a client certificate during the handshake, then
-- this property will be set after the handshake completes.
-- 
-- Each item in the list is a t'GI.GLib.Structs.ByteArray.ByteArray' which contains the complete
-- subject DN of the certificate authority.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionAcceptedCasPropertyInfo,
#endif
    getTlsClientConnectionAcceptedCas       ,
#if defined(ENABLE_OVERLOADING)
    tlsClientConnectionAcceptedCas          ,
#endif


-- ** serverIdentity #attr:serverIdentity#
-- | A t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable' describing the identity of the server that
-- is expected on the other end of the connection.
-- 
-- If the 'GI.Gio.Flags.TlsCertificateFlagsBadIdentity' flag is set in
-- t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection':@/validation-flags/@, this object will be used
-- to determine the expected identify of the remote end of the
-- connection; if t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection':@/server-identity/@ is not set,
-- or does not match the identity presented by the server, then the
-- 'GI.Gio.Flags.TlsCertificateFlagsBadIdentity' validation will fail.
-- 
-- In addition to its use in verifying the server certificate,
-- this is also used to give a hint to the server about what
-- certificate we expect, which is useful for servers that serve
-- virtual hosts.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionServerIdentityPropertyInfo,
#endif
    constructTlsClientConnectionServerIdentity,
    getTlsClientConnectionServerIdentity    ,
    setTlsClientConnectionServerIdentity    ,
#if defined(ENABLE_OVERLOADING)
    tlsClientConnectionServerIdentity       ,
#endif


-- ** useSsl3 #attr:useSsl3#
-- | SSL 3.0 is no longer supported. See
-- 'GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionSetUseSsl3' for details.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionUseSsl3PropertyInfo  ,
#endif
    constructTlsClientConnectionUseSsl3     ,
    getTlsClientConnectionUseSsl3           ,
    setTlsClientConnectionUseSsl3           ,
#if defined(ENABLE_OVERLOADING)
    tlsClientConnectionUseSsl3              ,
#endif


-- ** validationFlags #attr:validationFlags#
-- | What steps to perform when validating a certificate received from
-- a server. Server certificates that fail to validate in any of the
-- ways indicated here will be rejected unless the application
-- overrides the default via [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate").
-- 
-- GLib guarantees that if certificate verification fails, at least one
-- flag will be set, but it does not guarantee that all possible flags
-- will be set. Accordingly, you may not safely decide to ignore any
-- particular type of error. For example, it would be incorrect to mask
-- 'GI.Gio.Flags.TlsCertificateFlagsExpired' if you want to allow expired certificates,
-- because this could potentially be the only error flag set even if
-- other problems exist with the certificate. Therefore, there is no
-- safe way to use this property. This is not a horrible problem,
-- though, because you should not be attempting to ignore validation
-- errors anyway. If you really must ignore TLS certificate errors,
-- connect to [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate").
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TlsClientConnectionValidationFlagsPropertyInfo,
#endif
    constructTlsClientConnectionValidationFlags,
    getTlsClientConnectionValidationFlags   ,
    setTlsClientConnectionValidationFlags   ,
#if defined(ENABLE_OVERLOADING)
    tlsClientConnectionValidationFlags      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsCertificate as Gio.TlsCertificate
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsConnection as Gio.TlsConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsDatabase as Gio.TlsDatabase
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsInteraction as Gio.TlsInteraction
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsPassword as Gio.TlsPassword
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsConnection as Gio.TlsConnection

#endif

-- interface TlsClientConnection 
-- | Memory-managed wrapper type.
newtype TlsClientConnection = TlsClientConnection (SP.ManagedPtr TlsClientConnection)
    deriving (Eq)

instance SP.ManagedPtrNewtype TlsClientConnection where
    toManagedPtr (TlsClientConnection p) = p

foreign import ccall "g_tls_client_connection_get_type"
    c_g_tls_client_connection_get_type :: IO B.Types.GType

instance B.Types.TypedObject TlsClientConnection where
    glibType = c_g_tls_client_connection_get_type

instance B.Types.GObject TlsClientConnection

-- | Type class for types which can be safely cast to `TlsClientConnection`, for instance with `toTlsClientConnection`.
class (SP.GObject o, O.IsDescendantOf TlsClientConnection o) => IsTlsClientConnection o
instance (SP.GObject o, O.IsDescendantOf TlsClientConnection o) => IsTlsClientConnection o

instance O.HasParentTypes TlsClientConnection
type instance O.ParentTypes TlsClientConnection = '[GObject.Object.Object, Gio.TlsConnection.TlsConnection, Gio.IOStream.IOStream]

-- | Cast to `TlsClientConnection`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toTlsClientConnection :: (MIO.MonadIO m, IsTlsClientConnection o) => o -> m TlsClientConnection
toTlsClientConnection = MIO.liftIO . B.ManagedPtr.unsafeCastTo TlsClientConnection

-- | Convert 'TlsClientConnection' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TlsClientConnection) where
    gvalueGType_ = c_g_tls_client_connection_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TlsClientConnection)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TlsClientConnection)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TlsClientConnection ptr
        else return P.Nothing
        
    

-- VVV Prop "accepted-cas"
   -- Type: TGList (TBasicType TPtr)
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accepted-cas@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsClientConnection #acceptedCas
-- @
getTlsClientConnectionAcceptedCas :: (MonadIO m, IsTlsClientConnection o) => o -> m ([Ptr ()])
getTlsClientConnectionAcceptedCas obj = MIO.liftIO $ B.Properties.getObjectPropertyPtrGList obj "accepted-cas"

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionAcceptedCasPropertyInfo
instance AttrInfo TlsClientConnectionAcceptedCasPropertyInfo where
    type AttrAllowedOps TlsClientConnectionAcceptedCasPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint TlsClientConnectionAcceptedCasPropertyInfo = IsTlsClientConnection
    type AttrSetTypeConstraint TlsClientConnectionAcceptedCasPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TlsClientConnectionAcceptedCasPropertyInfo = (~) ()
    type AttrTransferType TlsClientConnectionAcceptedCasPropertyInfo = ()
    type AttrGetType TlsClientConnectionAcceptedCasPropertyInfo = ([Ptr ()])
    type AttrLabel TlsClientConnectionAcceptedCasPropertyInfo = "accepted-cas"
    type AttrOrigin TlsClientConnectionAcceptedCasPropertyInfo = TlsClientConnection
    attrGet = getTlsClientConnectionAcceptedCas
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.acceptedCas"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#g:attr:acceptedCas"
        })
#endif

-- VVV Prop "server-identity"
   -- Type: TInterface (Name {namespace = "Gio", name = "SocketConnectable"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@server-identity@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsClientConnection #serverIdentity
-- @
getTlsClientConnectionServerIdentity :: (MonadIO m, IsTlsClientConnection o) => o -> m (Maybe Gio.SocketConnectable.SocketConnectable)
getTlsClientConnectionServerIdentity obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "server-identity" Gio.SocketConnectable.SocketConnectable

-- | Set the value of the “@server-identity@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsClientConnection [ #serverIdentity 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsClientConnectionServerIdentity :: (MonadIO m, IsTlsClientConnection o, Gio.SocketConnectable.IsSocketConnectable a) => o -> a -> m ()
setTlsClientConnectionServerIdentity obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "server-identity" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@server-identity@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsClientConnectionServerIdentity :: (IsTlsClientConnection o, MIO.MonadIO m, Gio.SocketConnectable.IsSocketConnectable a) => a -> m (GValueConstruct o)
constructTlsClientConnectionServerIdentity val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "server-identity" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionServerIdentityPropertyInfo
instance AttrInfo TlsClientConnectionServerIdentityPropertyInfo where
    type AttrAllowedOps TlsClientConnectionServerIdentityPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TlsClientConnectionServerIdentityPropertyInfo = IsTlsClientConnection
    type AttrSetTypeConstraint TlsClientConnectionServerIdentityPropertyInfo = Gio.SocketConnectable.IsSocketConnectable
    type AttrTransferTypeConstraint TlsClientConnectionServerIdentityPropertyInfo = Gio.SocketConnectable.IsSocketConnectable
    type AttrTransferType TlsClientConnectionServerIdentityPropertyInfo = Gio.SocketConnectable.SocketConnectable
    type AttrGetType TlsClientConnectionServerIdentityPropertyInfo = (Maybe Gio.SocketConnectable.SocketConnectable)
    type AttrLabel TlsClientConnectionServerIdentityPropertyInfo = "server-identity"
    type AttrOrigin TlsClientConnectionServerIdentityPropertyInfo = TlsClientConnection
    attrGet = getTlsClientConnectionServerIdentity
    attrSet = setTlsClientConnectionServerIdentity
    attrTransfer _ v = do
        unsafeCastTo Gio.SocketConnectable.SocketConnectable v
    attrConstruct = constructTlsClientConnectionServerIdentity
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.serverIdentity"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#g:attr:serverIdentity"
        })
#endif

-- VVV Prop "use-ssl3"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-ssl3@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsClientConnection #useSsl3
-- @
getTlsClientConnectionUseSsl3 :: (MonadIO m, IsTlsClientConnection o) => o -> m Bool
getTlsClientConnectionUseSsl3 obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-ssl3"

-- | Set the value of the “@use-ssl3@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsClientConnection [ #useSsl3 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsClientConnectionUseSsl3 :: (MonadIO m, IsTlsClientConnection o) => o -> Bool -> m ()
setTlsClientConnectionUseSsl3 obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-ssl3" val

-- | Construct a `GValueConstruct` with valid value for the “@use-ssl3@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsClientConnectionUseSsl3 :: (IsTlsClientConnection o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTlsClientConnectionUseSsl3 val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-ssl3" val

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionUseSsl3PropertyInfo
instance AttrInfo TlsClientConnectionUseSsl3PropertyInfo where
    type AttrAllowedOps TlsClientConnectionUseSsl3PropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TlsClientConnectionUseSsl3PropertyInfo = IsTlsClientConnection
    type AttrSetTypeConstraint TlsClientConnectionUseSsl3PropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TlsClientConnectionUseSsl3PropertyInfo = (~) Bool
    type AttrTransferType TlsClientConnectionUseSsl3PropertyInfo = Bool
    type AttrGetType TlsClientConnectionUseSsl3PropertyInfo = Bool
    type AttrLabel TlsClientConnectionUseSsl3PropertyInfo = "use-ssl3"
    type AttrOrigin TlsClientConnectionUseSsl3PropertyInfo = TlsClientConnection
    attrGet = getTlsClientConnectionUseSsl3
    attrSet = setTlsClientConnectionUseSsl3
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsClientConnectionUseSsl3
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.useSsl3"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#g:attr:useSsl3"
        })
#endif

-- VVV Prop "validation-flags"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsCertificateFlags"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@validation-flags@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tlsClientConnection #validationFlags
-- @
getTlsClientConnectionValidationFlags :: (MonadIO m, IsTlsClientConnection o) => o -> m [Gio.Flags.TlsCertificateFlags]
getTlsClientConnectionValidationFlags obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "validation-flags"

-- | Set the value of the “@validation-flags@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' tlsClientConnection [ #validationFlags 'Data.GI.Base.Attributes.:=' value ]
-- @
setTlsClientConnectionValidationFlags :: (MonadIO m, IsTlsClientConnection o) => o -> [Gio.Flags.TlsCertificateFlags] -> m ()
setTlsClientConnectionValidationFlags obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "validation-flags" val

-- | Construct a `GValueConstruct` with valid value for the “@validation-flags@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTlsClientConnectionValidationFlags :: (IsTlsClientConnection o, MIO.MonadIO m) => [Gio.Flags.TlsCertificateFlags] -> m (GValueConstruct o)
constructTlsClientConnectionValidationFlags val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "validation-flags" val

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionValidationFlagsPropertyInfo
instance AttrInfo TlsClientConnectionValidationFlagsPropertyInfo where
    type AttrAllowedOps TlsClientConnectionValidationFlagsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TlsClientConnectionValidationFlagsPropertyInfo = IsTlsClientConnection
    type AttrSetTypeConstraint TlsClientConnectionValidationFlagsPropertyInfo = (~) [Gio.Flags.TlsCertificateFlags]
    type AttrTransferTypeConstraint TlsClientConnectionValidationFlagsPropertyInfo = (~) [Gio.Flags.TlsCertificateFlags]
    type AttrTransferType TlsClientConnectionValidationFlagsPropertyInfo = [Gio.Flags.TlsCertificateFlags]
    type AttrGetType TlsClientConnectionValidationFlagsPropertyInfo = [Gio.Flags.TlsCertificateFlags]
    type AttrLabel TlsClientConnectionValidationFlagsPropertyInfo = "validation-flags"
    type AttrOrigin TlsClientConnectionValidationFlagsPropertyInfo = TlsClientConnection
    attrGet = getTlsClientConnectionValidationFlags
    attrSet = setTlsClientConnectionValidationFlags
    attrTransfer _ v = do
        return v
    attrConstruct = constructTlsClientConnectionValidationFlags
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.validationFlags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#g:attr:validationFlags"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TlsClientConnection
type instance O.AttributeList TlsClientConnection = TlsClientConnectionAttributeList
type TlsClientConnectionAttributeList = ('[ '("acceptedCas", TlsClientConnectionAcceptedCasPropertyInfo), '("advertisedProtocols", Gio.TlsConnection.TlsConnectionAdvertisedProtocolsPropertyInfo), '("baseIoStream", Gio.TlsConnection.TlsConnectionBaseIoStreamPropertyInfo), '("certificate", Gio.TlsConnection.TlsConnectionCertificatePropertyInfo), '("ciphersuiteName", Gio.TlsConnection.TlsConnectionCiphersuiteNamePropertyInfo), '("closed", Gio.IOStream.IOStreamClosedPropertyInfo), '("database", Gio.TlsConnection.TlsConnectionDatabasePropertyInfo), '("inputStream", Gio.IOStream.IOStreamInputStreamPropertyInfo), '("interaction", Gio.TlsConnection.TlsConnectionInteractionPropertyInfo), '("negotiatedProtocol", Gio.TlsConnection.TlsConnectionNegotiatedProtocolPropertyInfo), '("outputStream", Gio.IOStream.IOStreamOutputStreamPropertyInfo), '("peerCertificate", Gio.TlsConnection.TlsConnectionPeerCertificatePropertyInfo), '("peerCertificateErrors", Gio.TlsConnection.TlsConnectionPeerCertificateErrorsPropertyInfo), '("protocolVersion", Gio.TlsConnection.TlsConnectionProtocolVersionPropertyInfo), '("rehandshakeMode", Gio.TlsConnection.TlsConnectionRehandshakeModePropertyInfo), '("requireCloseNotify", Gio.TlsConnection.TlsConnectionRequireCloseNotifyPropertyInfo), '("serverIdentity", TlsClientConnectionServerIdentityPropertyInfo), '("useSsl3", TlsClientConnectionUseSsl3PropertyInfo), '("useSystemCertdb", Gio.TlsConnection.TlsConnectionUseSystemCertdbPropertyInfo), '("validationFlags", TlsClientConnectionValidationFlagsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
tlsClientConnectionAcceptedCas :: AttrLabelProxy "acceptedCas"
tlsClientConnectionAcceptedCas = AttrLabelProxy

tlsClientConnectionServerIdentity :: AttrLabelProxy "serverIdentity"
tlsClientConnectionServerIdentity = AttrLabelProxy

tlsClientConnectionUseSsl3 :: AttrLabelProxy "useSsl3"
tlsClientConnectionUseSsl3 = AttrLabelProxy

tlsClientConnectionValidationFlags :: AttrLabelProxy "validationFlags"
tlsClientConnectionValidationFlags = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTlsClientConnectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTlsClientConnectionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTlsClientConnectionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTlsClientConnectionMethod "clearPending" o = Gio.IOStream.IOStreamClearPendingMethodInfo
    ResolveTlsClientConnectionMethod "close" o = Gio.IOStream.IOStreamCloseMethodInfo
    ResolveTlsClientConnectionMethod "closeAsync" o = Gio.IOStream.IOStreamCloseAsyncMethodInfo
    ResolveTlsClientConnectionMethod "closeFinish" o = Gio.IOStream.IOStreamCloseFinishMethodInfo
    ResolveTlsClientConnectionMethod "copySessionState" o = TlsClientConnectionCopySessionStateMethodInfo
    ResolveTlsClientConnectionMethod "emitAcceptCertificate" o = Gio.TlsConnection.TlsConnectionEmitAcceptCertificateMethodInfo
    ResolveTlsClientConnectionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTlsClientConnectionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTlsClientConnectionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTlsClientConnectionMethod "handshake" o = Gio.TlsConnection.TlsConnectionHandshakeMethodInfo
    ResolveTlsClientConnectionMethod "handshakeAsync" o = Gio.TlsConnection.TlsConnectionHandshakeAsyncMethodInfo
    ResolveTlsClientConnectionMethod "handshakeFinish" o = Gio.TlsConnection.TlsConnectionHandshakeFinishMethodInfo
    ResolveTlsClientConnectionMethod "hasPending" o = Gio.IOStream.IOStreamHasPendingMethodInfo
    ResolveTlsClientConnectionMethod "isClosed" o = Gio.IOStream.IOStreamIsClosedMethodInfo
    ResolveTlsClientConnectionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTlsClientConnectionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTlsClientConnectionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTlsClientConnectionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTlsClientConnectionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTlsClientConnectionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTlsClientConnectionMethod "spliceAsync" o = Gio.IOStream.IOStreamSpliceAsyncMethodInfo
    ResolveTlsClientConnectionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTlsClientConnectionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTlsClientConnectionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTlsClientConnectionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTlsClientConnectionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTlsClientConnectionMethod "getAcceptedCas" o = TlsClientConnectionGetAcceptedCasMethodInfo
    ResolveTlsClientConnectionMethod "getCertificate" o = Gio.TlsConnection.TlsConnectionGetCertificateMethodInfo
    ResolveTlsClientConnectionMethod "getChannelBindingData" o = Gio.TlsConnection.TlsConnectionGetChannelBindingDataMethodInfo
    ResolveTlsClientConnectionMethod "getCiphersuiteName" o = Gio.TlsConnection.TlsConnectionGetCiphersuiteNameMethodInfo
    ResolveTlsClientConnectionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTlsClientConnectionMethod "getDatabase" o = Gio.TlsConnection.TlsConnectionGetDatabaseMethodInfo
    ResolveTlsClientConnectionMethod "getInputStream" o = Gio.IOStream.IOStreamGetInputStreamMethodInfo
    ResolveTlsClientConnectionMethod "getInteraction" o = Gio.TlsConnection.TlsConnectionGetInteractionMethodInfo
    ResolveTlsClientConnectionMethod "getNegotiatedProtocol" o = Gio.TlsConnection.TlsConnectionGetNegotiatedProtocolMethodInfo
    ResolveTlsClientConnectionMethod "getOutputStream" o = Gio.IOStream.IOStreamGetOutputStreamMethodInfo
    ResolveTlsClientConnectionMethod "getPeerCertificate" o = Gio.TlsConnection.TlsConnectionGetPeerCertificateMethodInfo
    ResolveTlsClientConnectionMethod "getPeerCertificateErrors" o = Gio.TlsConnection.TlsConnectionGetPeerCertificateErrorsMethodInfo
    ResolveTlsClientConnectionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTlsClientConnectionMethod "getProtocolVersion" o = Gio.TlsConnection.TlsConnectionGetProtocolVersionMethodInfo
    ResolveTlsClientConnectionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTlsClientConnectionMethod "getRehandshakeMode" o = Gio.TlsConnection.TlsConnectionGetRehandshakeModeMethodInfo
    ResolveTlsClientConnectionMethod "getRequireCloseNotify" o = Gio.TlsConnection.TlsConnectionGetRequireCloseNotifyMethodInfo
    ResolveTlsClientConnectionMethod "getServerIdentity" o = TlsClientConnectionGetServerIdentityMethodInfo
    ResolveTlsClientConnectionMethod "getUseSsl3" o = TlsClientConnectionGetUseSsl3MethodInfo
    ResolveTlsClientConnectionMethod "getUseSystemCertdb" o = Gio.TlsConnection.TlsConnectionGetUseSystemCertdbMethodInfo
    ResolveTlsClientConnectionMethod "getValidationFlags" o = TlsClientConnectionGetValidationFlagsMethodInfo
    ResolveTlsClientConnectionMethod "setAdvertisedProtocols" o = Gio.TlsConnection.TlsConnectionSetAdvertisedProtocolsMethodInfo
    ResolveTlsClientConnectionMethod "setCertificate" o = Gio.TlsConnection.TlsConnectionSetCertificateMethodInfo
    ResolveTlsClientConnectionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTlsClientConnectionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTlsClientConnectionMethod "setDatabase" o = Gio.TlsConnection.TlsConnectionSetDatabaseMethodInfo
    ResolveTlsClientConnectionMethod "setInteraction" o = Gio.TlsConnection.TlsConnectionSetInteractionMethodInfo
    ResolveTlsClientConnectionMethod "setPending" o = Gio.IOStream.IOStreamSetPendingMethodInfo
    ResolveTlsClientConnectionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTlsClientConnectionMethod "setRehandshakeMode" o = Gio.TlsConnection.TlsConnectionSetRehandshakeModeMethodInfo
    ResolveTlsClientConnectionMethod "setRequireCloseNotify" o = Gio.TlsConnection.TlsConnectionSetRequireCloseNotifyMethodInfo
    ResolveTlsClientConnectionMethod "setServerIdentity" o = TlsClientConnectionSetServerIdentityMethodInfo
    ResolveTlsClientConnectionMethod "setUseSsl3" o = TlsClientConnectionSetUseSsl3MethodInfo
    ResolveTlsClientConnectionMethod "setUseSystemCertdb" o = Gio.TlsConnection.TlsConnectionSetUseSystemCertdbMethodInfo
    ResolveTlsClientConnectionMethod "setValidationFlags" o = TlsClientConnectionSetValidationFlagsMethodInfo
    ResolveTlsClientConnectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTlsClientConnectionMethod t TlsClientConnection, O.OverloadedMethod info TlsClientConnection p) => OL.IsLabel t (TlsClientConnection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTlsClientConnectionMethod t TlsClientConnection, O.OverloadedMethod info TlsClientConnection p, R.HasField t TlsClientConnection p) => R.HasField t TlsClientConnection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTlsClientConnectionMethod t TlsClientConnection, O.OverloadedMethodInfo info TlsClientConnection) => OL.IsLabel t (O.MethodProxy info TlsClientConnection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method TlsClientConnection::copy_session_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_client_connection_copy_session_state" g_tls_client_connection_copy_session_state :: 
    Ptr TlsClientConnection ->              -- conn : TInterface (Name {namespace = "Gio", name = "TlsClientConnection"})
    Ptr TlsClientConnection ->              -- source : TInterface (Name {namespace = "Gio", name = "TlsClientConnection"})
    IO ()

-- | Possibly copies session state from one connection to another, for use
-- in TLS session resumption. This is not normally needed, but may be
-- used when the same session needs to be used between different
-- endpoints, as is required by some protocols, such as FTP over TLS.
-- /@source@/ should have already completed a handshake and, since TLS 1.3,
-- it should have been used to read data at least once. /@conn@/ should not
-- have completed a handshake.
-- 
-- It is not possible to know whether a call to this function will
-- actually do anything. Because session resumption is normally used
-- only for performance benefit, the TLS backend might not implement
-- this function. Even if implemented, it may not actually succeed in
-- allowing /@conn@/ to resume /@source@/\'s TLS session, because the server
-- may not have sent a session resumption token to /@source@/, or it may
-- refuse to accept the token from /@conn@/. There is no way to know
-- whether a call to this function is actually successful.
-- 
-- Using this function is not required to benefit from session
-- resumption. If the TLS backend supports session resumption, the
-- session will be resumed automatically if it is possible to do so
-- without weakening the privacy guarantees normally provided by TLS,
-- without need to call this function. For example, with TLS 1.3,
-- a session ticket will be automatically copied from any
-- t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection' that has previously received session tickets
-- from the server, provided a ticket is available that has not
-- previously been used for session resumption, since session ticket
-- reuse would be a privacy weakness. Using this function causes the
-- ticket to be copied without regard for privacy considerations.
-- 
-- /Since: 2.46/
tlsClientConnectionCopySessionState ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsClientConnection a, IsTlsClientConnection b) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
    -> b
    -- ^ /@source@/: a t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
    -> m ()
tlsClientConnectionCopySessionState conn source = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    source' <- unsafeManagedPtrCastPtr source
    g_tls_client_connection_copy_session_state conn' source'
    touchManagedPtr conn
    touchManagedPtr source
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionCopySessionStateMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsTlsClientConnection a, IsTlsClientConnection b) => O.OverloadedMethod TlsClientConnectionCopySessionStateMethodInfo a signature where
    overloadedMethod = tlsClientConnectionCopySessionState

instance O.OverloadedMethodInfo TlsClientConnectionCopySessionStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionCopySessionState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#v:tlsClientConnectionCopySessionState"
        })


#endif

-- method TlsClientConnection::get_accepted_cas
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TGList TByteArray)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_client_connection_get_accepted_cas" g_tls_client_connection_get_accepted_cas :: 
    Ptr TlsClientConnection ->              -- conn : TInterface (Name {namespace = "Gio", name = "TlsClientConnection"})
    IO (Ptr (GList (Ptr GByteArray)))

-- | Gets the list of distinguished names of the Certificate Authorities
-- that the server will accept certificates from. This will be set
-- during the TLS handshake if the server requests a certificate.
-- Otherwise, it will be 'P.Nothing'.
-- 
-- Each item in the list is a t'GI.GLib.Structs.ByteArray.ByteArray' which contains the complete
-- subject DN of the certificate authority.
-- 
-- /Since: 2.28/
tlsClientConnectionGetAcceptedCas ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsClientConnection a) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
    -> m [ByteString]
    -- ^ __Returns:__ the list of
    -- CA DNs. You should unref each element with 'GI.GLib.Functions.byteArrayUnref' and then
    -- the free the list with @/g_list_free()/@.
tlsClientConnectionGetAcceptedCas conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_client_connection_get_accepted_cas conn'
    result' <- unpackGList result
    result'' <- mapM unpackGByteArray result'
    mapGList unrefGByteArray result
    g_list_free result
    touchManagedPtr conn
    return result''

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionGetAcceptedCasMethodInfo
instance (signature ~ (m [ByteString]), MonadIO m, IsTlsClientConnection a) => O.OverloadedMethod TlsClientConnectionGetAcceptedCasMethodInfo a signature where
    overloadedMethod = tlsClientConnectionGetAcceptedCas

instance O.OverloadedMethodInfo TlsClientConnectionGetAcceptedCasMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionGetAcceptedCas",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#v:tlsClientConnectionGetAcceptedCas"
        })


#endif

-- method TlsClientConnection::get_server_identity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "SocketConnectable" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_client_connection_get_server_identity" g_tls_client_connection_get_server_identity :: 
    Ptr TlsClientConnection ->              -- conn : TInterface (Name {namespace = "Gio", name = "TlsClientConnection"})
    IO (Ptr Gio.SocketConnectable.SocketConnectable)

-- | Gets /@conn@/\'s expected server identity
-- 
-- /Since: 2.28/
tlsClientConnectionGetServerIdentity ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsClientConnection a) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
    -> m (Maybe Gio.SocketConnectable.SocketConnectable)
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable' describing the
    -- expected server identity, or 'P.Nothing' if the expected identity is not
    -- known.
tlsClientConnectionGetServerIdentity conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_client_connection_get_server_identity conn'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.SocketConnectable.SocketConnectable) result'
        return result''
    touchManagedPtr conn
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionGetServerIdentityMethodInfo
instance (signature ~ (m (Maybe Gio.SocketConnectable.SocketConnectable)), MonadIO m, IsTlsClientConnection a) => O.OverloadedMethod TlsClientConnectionGetServerIdentityMethodInfo a signature where
    overloadedMethod = tlsClientConnectionGetServerIdentity

instance O.OverloadedMethodInfo TlsClientConnectionGetServerIdentityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionGetServerIdentity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#v:tlsClientConnectionGetServerIdentity"
        })


#endif

-- method TlsClientConnection::get_use_ssl3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_client_connection_get_use_ssl3" g_tls_client_connection_get_use_ssl3 :: 
    Ptr TlsClientConnection ->              -- conn : TInterface (Name {namespace = "Gio", name = "TlsClientConnection"})
    IO CInt

{-# DEPRECATED tlsClientConnectionGetUseSsl3 ["(Since version 2.56)","SSL 3.0 is insecure."] #-}
-- | SSL 3.0 is no longer supported. See
-- 'GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionSetUseSsl3' for details.
-- 
-- /Since: 2.28/
tlsClientConnectionGetUseSsl3 ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsClientConnection a) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
    -> m Bool
    -- ^ __Returns:__ 'P.False'
tlsClientConnectionGetUseSsl3 conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_client_connection_get_use_ssl3 conn'
    let result' = (/= 0) result
    touchManagedPtr conn
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionGetUseSsl3MethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTlsClientConnection a) => O.OverloadedMethod TlsClientConnectionGetUseSsl3MethodInfo a signature where
    overloadedMethod = tlsClientConnectionGetUseSsl3

instance O.OverloadedMethodInfo TlsClientConnectionGetUseSsl3MethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionGetUseSsl3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#v:tlsClientConnectionGetUseSsl3"
        })


#endif

-- method TlsClientConnection::get_validation_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "TlsCertificateFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_client_connection_get_validation_flags" g_tls_client_connection_get_validation_flags :: 
    Ptr TlsClientConnection ->              -- conn : TInterface (Name {namespace = "Gio", name = "TlsClientConnection"})
    IO CUInt

{-# DEPRECATED tlsClientConnectionGetValidationFlags ["(Since version 2.72)","Do not attempt to ignore validation errors."] #-}
-- | Gets /@conn@/\'s validation flags
-- 
-- This function does not work as originally designed and is impossible
-- to use correctly. See t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection':@/validation-flags/@ for more
-- information.
-- 
-- /Since: 2.28/
tlsClientConnectionGetValidationFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsClientConnection a) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
    -> m [Gio.Flags.TlsCertificateFlags]
    -- ^ __Returns:__ the validation flags
tlsClientConnectionGetValidationFlags conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tls_client_connection_get_validation_flags conn'
    let result' = wordToGFlags result
    touchManagedPtr conn
    return result'

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionGetValidationFlagsMethodInfo
instance (signature ~ (m [Gio.Flags.TlsCertificateFlags]), MonadIO m, IsTlsClientConnection a) => O.OverloadedMethod TlsClientConnectionGetValidationFlagsMethodInfo a signature where
    overloadedMethod = tlsClientConnectionGetValidationFlags

instance O.OverloadedMethodInfo TlsClientConnectionGetValidationFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionGetValidationFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#v:tlsClientConnectionGetValidationFlags"
        })


#endif

-- method TlsClientConnection::set_server_identity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "identity"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketConnectable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GSocketConnectable describing the expected server identity"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_client_connection_set_server_identity" g_tls_client_connection_set_server_identity :: 
    Ptr TlsClientConnection ->              -- conn : TInterface (Name {namespace = "Gio", name = "TlsClientConnection"})
    Ptr Gio.SocketConnectable.SocketConnectable -> -- identity : TInterface (Name {namespace = "Gio", name = "SocketConnectable"})
    IO ()

-- | Sets /@conn@/\'s expected server identity, which is used both to tell
-- servers on virtual hosts which certificate to present, and also
-- to let /@conn@/ know what name to look for in the certificate when
-- performing 'GI.Gio.Flags.TlsCertificateFlagsBadIdentity' validation, if enabled.
-- 
-- /Since: 2.28/
tlsClientConnectionSetServerIdentity ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsClientConnection a, Gio.SocketConnectable.IsSocketConnectable b) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
    -> b
    -- ^ /@identity@/: a t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable' describing the expected server identity
    -> m ()
tlsClientConnectionSetServerIdentity conn identity = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    identity' <- unsafeManagedPtrCastPtr identity
    g_tls_client_connection_set_server_identity conn' identity'
    touchManagedPtr conn
    touchManagedPtr identity
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionSetServerIdentityMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsTlsClientConnection a, Gio.SocketConnectable.IsSocketConnectable b) => O.OverloadedMethod TlsClientConnectionSetServerIdentityMethodInfo a signature where
    overloadedMethod = tlsClientConnectionSetServerIdentity

instance O.OverloadedMethodInfo TlsClientConnectionSetServerIdentityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionSetServerIdentity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#v:tlsClientConnectionSetServerIdentity"
        })


#endif

-- method TlsClientConnection::set_use_ssl3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_ssl3"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #gboolean, ignored"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_client_connection_set_use_ssl3" g_tls_client_connection_set_use_ssl3 :: 
    Ptr TlsClientConnection ->              -- conn : TInterface (Name {namespace = "Gio", name = "TlsClientConnection"})
    CInt ->                                 -- use_ssl3 : TBasicType TBoolean
    IO ()

{-# DEPRECATED tlsClientConnectionSetUseSsl3 ["(Since version 2.56)","SSL 3.0 is insecure."] #-}
-- | Since GLib 2.42.1, SSL 3.0 is no longer supported.
-- 
-- From GLib 2.42.1 through GLib 2.62, this function could be used to
-- force use of TLS 1.0, the lowest-supported TLS protocol version at
-- the time. In the past, this was needed to connect to broken TLS
-- servers that exhibited protocol version intolerance. Such servers
-- are no longer common, and using TLS 1.0 is no longer considered
-- acceptable.
-- 
-- Since GLib 2.64, this function does nothing.
-- 
-- /Since: 2.28/
tlsClientConnectionSetUseSsl3 ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsClientConnection a) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
    -> Bool
    -- ^ /@useSsl3@/: a t'P.Bool', ignored
    -> m ()
tlsClientConnectionSetUseSsl3 conn useSsl3 = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    let useSsl3' = (P.fromIntegral . P.fromEnum) useSsl3
    g_tls_client_connection_set_use_ssl3 conn' useSsl3'
    touchManagedPtr conn
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionSetUseSsl3MethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTlsClientConnection a) => O.OverloadedMethod TlsClientConnectionSetUseSsl3MethodInfo a signature where
    overloadedMethod = tlsClientConnectionSetUseSsl3

instance O.OverloadedMethodInfo TlsClientConnectionSetUseSsl3MethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionSetUseSsl3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#v:tlsClientConnectionSetUseSsl3"
        })


#endif

-- method TlsClientConnection::set_validation_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsCertificateFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsCertificateFlags to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_tls_client_connection_set_validation_flags" g_tls_client_connection_set_validation_flags :: 
    Ptr TlsClientConnection ->              -- conn : TInterface (Name {namespace = "Gio", name = "TlsClientConnection"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "TlsCertificateFlags"})
    IO ()

{-# DEPRECATED tlsClientConnectionSetValidationFlags ["(Since version 2.72)","Do not attempt to ignore validation errors."] #-}
-- | Sets /@conn@/\'s validation flags, to override the default set of
-- checks performed when validating a server certificate. By default,
-- 'GI.Gio.Flags.TlsCertificateFlagsValidateAll' is used.
-- 
-- This function does not work as originally designed and is impossible
-- to use correctly. See t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection':@/validation-flags/@ for more
-- information.
-- 
-- /Since: 2.28/
tlsClientConnectionSetValidationFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsTlsClientConnection a) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection'
    -> [Gio.Flags.TlsCertificateFlags]
    -- ^ /@flags@/: the t'GI.Gio.Flags.TlsCertificateFlags' to use
    -> m ()
tlsClientConnectionSetValidationFlags conn flags = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    let flags' = gflagsToWord flags
    g_tls_client_connection_set_validation_flags conn' flags'
    touchManagedPtr conn
    return ()

#if defined(ENABLE_OVERLOADING)
data TlsClientConnectionSetValidationFlagsMethodInfo
instance (signature ~ ([Gio.Flags.TlsCertificateFlags] -> m ()), MonadIO m, IsTlsClientConnection a) => O.OverloadedMethod TlsClientConnectionSetValidationFlagsMethodInfo a signature where
    overloadedMethod = tlsClientConnectionSetValidationFlags

instance O.OverloadedMethodInfo TlsClientConnectionSetValidationFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.TlsClientConnection.tlsClientConnectionSetValidationFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-TlsClientConnection.html#v:tlsClientConnectionSetValidationFlags"
        })


#endif

-- method TlsClientConnection::new
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "base_io_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GIOStream to wrap"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "server_identity"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketConnectable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expected identity of the server"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "TlsClientConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_tls_client_connection_new" g_tls_client_connection_new :: 
    Ptr Gio.IOStream.IOStream ->            -- base_io_stream : TInterface (Name {namespace = "Gio", name = "IOStream"})
    Ptr Gio.SocketConnectable.SocketConnectable -> -- server_identity : TInterface (Name {namespace = "Gio", name = "SocketConnectable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr TlsClientConnection)

-- | Creates a new t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection' wrapping /@baseIoStream@/ (which
-- must have pollable input and output streams) which is assumed to
-- communicate with the server identified by /@serverIdentity@/.
-- 
-- See the documentation for [TlsConnection:baseIoStream]("GI.Gio.Objects.TlsConnection#g:attr:baseIoStream") for restrictions
-- on when application code can run operations on the /@baseIoStream@/ after
-- this function has returned.
-- 
-- /Since: 2.28/
tlsClientConnectionNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.IOStream.IsIOStream a, Gio.SocketConnectable.IsSocketConnectable b) =>
    a
    -- ^ /@baseIoStream@/: the t'GI.Gio.Objects.IOStream.IOStream' to wrap
    -> Maybe (b)
    -- ^ /@serverIdentity@/: the expected identity of the server
    -> m TlsClientConnection
    -- ^ __Returns:__ the new
    -- t'GI.Gio.Interfaces.TlsClientConnection.TlsClientConnection', or 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
tlsClientConnectionNew baseIoStream serverIdentity = liftIO $ do
    baseIoStream' <- unsafeManagedPtrCastPtr baseIoStream
    maybeServerIdentity <- case serverIdentity of
        Nothing -> return FP.nullPtr
        Just jServerIdentity -> do
            jServerIdentity' <- unsafeManagedPtrCastPtr jServerIdentity
            return jServerIdentity'
    onException (do
        result <- propagateGError $ g_tls_client_connection_new baseIoStream' maybeServerIdentity
        checkUnexpectedReturnNULL "tlsClientConnectionNew" result
        result' <- (wrapObject TlsClientConnection) result
        touchManagedPtr baseIoStream
        whenJust serverIdentity touchManagedPtr
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TlsClientConnection = TlsClientConnectionSignalList
type TlsClientConnectionSignalList = ('[ '("acceptCertificate", Gio.TlsConnection.TlsConnectionAcceptCertificateSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


