{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GRemoteActionGroup@ interface is implemented by t'GI.Gio.Interfaces.ActionGroup.ActionGroup'
-- instances that either transmit action invocations to other processes
-- or receive action invocations in the local process from other
-- processes.
-- 
-- The interface has @_full@ variants of the two
-- methods on t'GI.Gio.Interfaces.ActionGroup.ActionGroup' used to activate actions:
-- 'GI.Gio.Interfaces.ActionGroup.actionGroupActivateAction' and
-- 'GI.Gio.Interfaces.ActionGroup.actionGroupChangeActionState'. These variants allow a
-- ‘platform data’ [struct/@gLib@/.Variant] to be specified: a dictionary providing
-- context for the action invocation (for example: timestamps, startup
-- notification IDs, etc).
-- 
-- t'GI.Gio.Objects.DBusActionGroup.DBusActionGroup' implements @GRemoteActionGroup@.  This provides a
-- mechanism to send platform data for action invocations over D-Bus.
-- 
-- Additionally, 'GI.Gio.Objects.DBusConnection.dBusConnectionExportActionGroup' will check if
-- the exported t'GI.Gio.Interfaces.ActionGroup.ActionGroup' implements @GRemoteActionGroup@ and use
-- the @_full@ variants of the calls if available.  This
-- provides a mechanism by which to receive platform data for action
-- invocations that arrive by way of D-Bus.
-- 
-- /Since: 2.32/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.RemoteActionGroup
    ( 

-- * Exported types
    RemoteActionGroup(..)                   ,
    IsRemoteActionGroup                     ,
    toRemoteActionGroup                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionAdded]("GI.Gio.Interfaces.ActionGroup#g:method:actionAdded"), [actionEnabledChanged]("GI.Gio.Interfaces.ActionGroup#g:method:actionEnabledChanged"), [actionRemoved]("GI.Gio.Interfaces.ActionGroup#g:method:actionRemoved"), [actionStateChanged]("GI.Gio.Interfaces.ActionGroup#g:method:actionStateChanged"), [activateAction]("GI.Gio.Interfaces.ActionGroup#g:method:activateAction"), [activateActionFull]("GI.Gio.Interfaces.RemoteActionGroup#g:method:activateActionFull"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changeActionState]("GI.Gio.Interfaces.ActionGroup#g:method:changeActionState"), [changeActionStateFull]("GI.Gio.Interfaces.RemoteActionGroup#g:method:changeActionStateFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasAction]("GI.Gio.Interfaces.ActionGroup#g:method:hasAction"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listActions]("GI.Gio.Interfaces.ActionGroup#g:method:listActions"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [queryAction]("GI.Gio.Interfaces.ActionGroup#g:method:queryAction"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActionEnabled]("GI.Gio.Interfaces.ActionGroup#g:method:getActionEnabled"), [getActionParameterType]("GI.Gio.Interfaces.ActionGroup#g:method:getActionParameterType"), [getActionState]("GI.Gio.Interfaces.ActionGroup#g:method:getActionState"), [getActionStateHint]("GI.Gio.Interfaces.ActionGroup#g:method:getActionStateHint"), [getActionStateType]("GI.Gio.Interfaces.ActionGroup#g:method:getActionStateType"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveRemoteActionGroupMethod          ,
#endif

-- ** activateActionFull #method:activateActionFull#

#if defined(ENABLE_OVERLOADING)
    RemoteActionGroupActivateActionFullMethodInfo,
#endif
    remoteActionGroupActivateActionFull     ,


-- ** changeActionStateFull #method:changeActionStateFull#

#if defined(ENABLE_OVERLOADING)
    RemoteActionGroupChangeActionStateFullMethodInfo,
#endif
    remoteActionGroupChangeActionStateFull  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup

#endif

-- interface RemoteActionGroup 
-- | Memory-managed wrapper type.
newtype RemoteActionGroup = RemoteActionGroup (SP.ManagedPtr RemoteActionGroup)
    deriving (Eq)

instance SP.ManagedPtrNewtype RemoteActionGroup where
    toManagedPtr (RemoteActionGroup p) = p

foreign import ccall "g_remote_action_group_get_type"
    c_g_remote_action_group_get_type :: IO B.Types.GType

instance B.Types.TypedObject RemoteActionGroup where
    glibType = c_g_remote_action_group_get_type

instance B.Types.GObject RemoteActionGroup

-- | Type class for types which can be safely cast to `RemoteActionGroup`, for instance with `toRemoteActionGroup`.
class (SP.GObject o, O.IsDescendantOf RemoteActionGroup o) => IsRemoteActionGroup o
instance (SP.GObject o, O.IsDescendantOf RemoteActionGroup o) => IsRemoteActionGroup o

instance O.HasParentTypes RemoteActionGroup
type instance O.ParentTypes RemoteActionGroup = '[Gio.ActionGroup.ActionGroup, GObject.Object.Object]

-- | Cast to `RemoteActionGroup`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toRemoteActionGroup :: (MIO.MonadIO m, IsRemoteActionGroup o) => o -> m RemoteActionGroup
toRemoteActionGroup = MIO.liftIO . B.ManagedPtr.unsafeCastTo RemoteActionGroup

-- | Convert 'RemoteActionGroup' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe RemoteActionGroup) where
    gvalueGType_ = c_g_remote_action_group_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr RemoteActionGroup)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr RemoteActionGroup)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject RemoteActionGroup ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList RemoteActionGroup
type instance O.AttributeList RemoteActionGroup = RemoteActionGroupAttributeList
type RemoteActionGroupAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveRemoteActionGroupMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRemoteActionGroupMethod "actionAdded" o = Gio.ActionGroup.ActionGroupActionAddedMethodInfo
    ResolveRemoteActionGroupMethod "actionEnabledChanged" o = Gio.ActionGroup.ActionGroupActionEnabledChangedMethodInfo
    ResolveRemoteActionGroupMethod "actionRemoved" o = Gio.ActionGroup.ActionGroupActionRemovedMethodInfo
    ResolveRemoteActionGroupMethod "actionStateChanged" o = Gio.ActionGroup.ActionGroupActionStateChangedMethodInfo
    ResolveRemoteActionGroupMethod "activateAction" o = Gio.ActionGroup.ActionGroupActivateActionMethodInfo
    ResolveRemoteActionGroupMethod "activateActionFull" o = RemoteActionGroupActivateActionFullMethodInfo
    ResolveRemoteActionGroupMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveRemoteActionGroupMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveRemoteActionGroupMethod "changeActionState" o = Gio.ActionGroup.ActionGroupChangeActionStateMethodInfo
    ResolveRemoteActionGroupMethod "changeActionStateFull" o = RemoteActionGroupChangeActionStateFullMethodInfo
    ResolveRemoteActionGroupMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveRemoteActionGroupMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveRemoteActionGroupMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveRemoteActionGroupMethod "hasAction" o = Gio.ActionGroup.ActionGroupHasActionMethodInfo
    ResolveRemoteActionGroupMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveRemoteActionGroupMethod "listActions" o = Gio.ActionGroup.ActionGroupListActionsMethodInfo
    ResolveRemoteActionGroupMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveRemoteActionGroupMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveRemoteActionGroupMethod "queryAction" o = Gio.ActionGroup.ActionGroupQueryActionMethodInfo
    ResolveRemoteActionGroupMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveRemoteActionGroupMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveRemoteActionGroupMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveRemoteActionGroupMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveRemoteActionGroupMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveRemoteActionGroupMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveRemoteActionGroupMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveRemoteActionGroupMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveRemoteActionGroupMethod "getActionEnabled" o = Gio.ActionGroup.ActionGroupGetActionEnabledMethodInfo
    ResolveRemoteActionGroupMethod "getActionParameterType" o = Gio.ActionGroup.ActionGroupGetActionParameterTypeMethodInfo
    ResolveRemoteActionGroupMethod "getActionState" o = Gio.ActionGroup.ActionGroupGetActionStateMethodInfo
    ResolveRemoteActionGroupMethod "getActionStateHint" o = Gio.ActionGroup.ActionGroupGetActionStateHintMethodInfo
    ResolveRemoteActionGroupMethod "getActionStateType" o = Gio.ActionGroup.ActionGroupGetActionStateTypeMethodInfo
    ResolveRemoteActionGroupMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveRemoteActionGroupMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveRemoteActionGroupMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveRemoteActionGroupMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveRemoteActionGroupMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveRemoteActionGroupMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveRemoteActionGroupMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRemoteActionGroupMethod t RemoteActionGroup, O.OverloadedMethod info RemoteActionGroup p) => OL.IsLabel t (RemoteActionGroup -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRemoteActionGroupMethod t RemoteActionGroup, O.OverloadedMethod info RemoteActionGroup p, R.HasField t RemoteActionGroup p) => R.HasField t RemoteActionGroup p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRemoteActionGroupMethod t RemoteActionGroup, O.OverloadedMethodInfo info RemoteActionGroup) => OL.IsLabel t (O.MethodProxy info RemoteActionGroup) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method RemoteActionGroup::activate_action_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "remote"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "RemoteActionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDBusActionGroup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the action to activate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parameter"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the optional parameter to the activation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "platform_data"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the platform data to send"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_remote_action_group_activate_action_full" g_remote_action_group_activate_action_full :: 
    Ptr RemoteActionGroup ->                -- remote : TInterface (Name {namespace = "Gio", name = "RemoteActionGroup"})
    CString ->                              -- action_name : TBasicType TUTF8
    Ptr GVariant ->                         -- parameter : TVariant
    Ptr GVariant ->                         -- platform_data : TVariant
    IO ()

-- | Activates the remote action.
-- 
-- This is the same as 'GI.Gio.Interfaces.ActionGroup.actionGroupActivateAction' except that it
-- allows for provision of \"platform data\" to be sent along with the
-- activation request.  This typically contains details such as the user
-- interaction timestamp or startup notification information.
-- 
-- /@platformData@/ must be non-'P.Nothing' and must have the type
-- @/G_VARIANT_TYPE_VARDICT/@.  If it is floating, it will be consumed.
-- 
-- /Since: 2.32/
remoteActionGroupActivateActionFull ::
    (B.CallStack.HasCallStack, MonadIO m, IsRemoteActionGroup a) =>
    a
    -- ^ /@remote@/: a t'GI.Gio.Objects.DBusActionGroup.DBusActionGroup'
    -> T.Text
    -- ^ /@actionName@/: the name of the action to activate
    -> Maybe (GVariant)
    -- ^ /@parameter@/: the optional parameter to the activation
    -> GVariant
    -- ^ /@platformData@/: the platform data to send
    -> m ()
remoteActionGroupActivateActionFull remote actionName parameter platformData = liftIO $ do
    remote' <- unsafeManagedPtrCastPtr remote
    actionName' <- textToCString actionName
    maybeParameter <- case parameter of
        Nothing -> return FP.nullPtr
        Just jParameter -> do
            jParameter' <- unsafeManagedPtrGetPtr jParameter
            return jParameter'
    platformData' <- unsafeManagedPtrGetPtr platformData
    g_remote_action_group_activate_action_full remote' actionName' maybeParameter platformData'
    touchManagedPtr remote
    whenJust parameter touchManagedPtr
    touchManagedPtr platformData
    freeMem actionName'
    return ()

#if defined(ENABLE_OVERLOADING)
data RemoteActionGroupActivateActionFullMethodInfo
instance (signature ~ (T.Text -> Maybe (GVariant) -> GVariant -> m ()), MonadIO m, IsRemoteActionGroup a) => O.OverloadedMethod RemoteActionGroupActivateActionFullMethodInfo a signature where
    overloadedMethod = remoteActionGroupActivateActionFull

instance O.OverloadedMethodInfo RemoteActionGroupActivateActionFullMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.RemoteActionGroup.remoteActionGroupActivateActionFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-RemoteActionGroup.html#v:remoteActionGroupActivateActionFull"
        })


#endif

-- method RemoteActionGroup::change_action_state_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "remote"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "RemoteActionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GRemoteActionGroup"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the action to change the state of"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new requested value for the state"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "platform_data"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the platform data to send"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_remote_action_group_change_action_state_full" g_remote_action_group_change_action_state_full :: 
    Ptr RemoteActionGroup ->                -- remote : TInterface (Name {namespace = "Gio", name = "RemoteActionGroup"})
    CString ->                              -- action_name : TBasicType TUTF8
    Ptr GVariant ->                         -- value : TVariant
    Ptr GVariant ->                         -- platform_data : TVariant
    IO ()

-- | Changes the state of a remote action.
-- 
-- This is the same as 'GI.Gio.Interfaces.ActionGroup.actionGroupChangeActionState' except that
-- it allows for provision of \"platform data\" to be sent along with the
-- state change request.  This typically contains details such as the
-- user interaction timestamp or startup notification information.
-- 
-- /@platformData@/ must be non-'P.Nothing' and must have the type
-- @/G_VARIANT_TYPE_VARDICT/@.  If it is floating, it will be consumed.
-- 
-- /Since: 2.32/
remoteActionGroupChangeActionStateFull ::
    (B.CallStack.HasCallStack, MonadIO m, IsRemoteActionGroup a) =>
    a
    -- ^ /@remote@/: a t'GI.Gio.Interfaces.RemoteActionGroup.RemoteActionGroup'
    -> T.Text
    -- ^ /@actionName@/: the name of the action to change the state of
    -> GVariant
    -- ^ /@value@/: the new requested value for the state
    -> GVariant
    -- ^ /@platformData@/: the platform data to send
    -> m ()
remoteActionGroupChangeActionStateFull remote actionName value platformData = liftIO $ do
    remote' <- unsafeManagedPtrCastPtr remote
    actionName' <- textToCString actionName
    value' <- unsafeManagedPtrGetPtr value
    platformData' <- unsafeManagedPtrGetPtr platformData
    g_remote_action_group_change_action_state_full remote' actionName' value' platformData'
    touchManagedPtr remote
    touchManagedPtr value
    touchManagedPtr platformData
    freeMem actionName'
    return ()

#if defined(ENABLE_OVERLOADING)
data RemoteActionGroupChangeActionStateFullMethodInfo
instance (signature ~ (T.Text -> GVariant -> GVariant -> m ()), MonadIO m, IsRemoteActionGroup a) => O.OverloadedMethod RemoteActionGroupChangeActionStateFullMethodInfo a signature where
    overloadedMethod = remoteActionGroupChangeActionStateFull

instance O.OverloadedMethodInfo RemoteActionGroupChangeActionStateFullMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.RemoteActionGroup.remoteActionGroupChangeActionStateFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-RemoteActionGroup.html#v:remoteActionGroupChangeActionStateFull"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList RemoteActionGroup = RemoteActionGroupSignalList
type RemoteActionGroupSignalList = ('[ '("actionAdded", Gio.ActionGroup.ActionGroupActionAddedSignalInfo), '("actionEnabledChanged", Gio.ActionGroup.ActionGroupActionEnabledChangedSignalInfo), '("actionRemoved", Gio.ActionGroup.ActionGroupActionRemovedSignalInfo), '("actionStateChanged", Gio.ActionGroup.ActionGroupActionStateChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


