{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GProxy@ handles connecting to a remote host via a given type of
-- proxy server. It is implemented by the @gio-proxy@ extension point.
-- The extensions are named after their proxy protocol name. As an
-- example, a SOCKS5 proxy implementation can be retrieved with the
-- name @socks5@ using the function
-- 'GI.Gio.Structs.IOExtensionPoint.iOExtensionPointGetExtensionByName'.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.Proxy
    ( 

-- * Exported types
    Proxy(..)                               ,
    IsProxy                                 ,
    toProxy                                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [connect]("GI.Gio.Interfaces.Proxy#g:method:connect"), [connectAsync]("GI.Gio.Interfaces.Proxy#g:method:connectAsync"), [connectFinish]("GI.Gio.Interfaces.Proxy#g:method:connectFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [supportsHostname]("GI.Gio.Interfaces.Proxy#g:method:supportsHostname"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveProxyMethod                      ,
#endif

-- ** connect #method:connect#

#if defined(ENABLE_OVERLOADING)
    ProxyConnectMethodInfo                  ,
#endif
    proxyConnect                            ,


-- ** connectAsync #method:connectAsync#

#if defined(ENABLE_OVERLOADING)
    ProxyConnectAsyncMethodInfo             ,
#endif
    proxyConnectAsync                       ,


-- ** connectFinish #method:connectFinish#

#if defined(ENABLE_OVERLOADING)
    ProxyConnectFinishMethodInfo            ,
#endif
    proxyConnectFinish                      ,


-- ** getDefaultForProtocol #method:getDefaultForProtocol#

    proxyGetDefaultForProtocol              ,


-- ** supportsHostname #method:supportsHostname#

#if defined(ENABLE_OVERLOADING)
    ProxySupportsHostnameMethodInfo         ,
#endif
    proxySupportsHostname                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InetSocketAddress as Gio.InetSocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.ProxyAddress as Gio.ProxyAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.ProxyAddress as Gio.ProxyAddress

#endif

-- interface Proxy 
-- | Memory-managed wrapper type.
newtype Proxy = Proxy (SP.ManagedPtr Proxy)
    deriving (Eq)

instance SP.ManagedPtrNewtype Proxy where
    toManagedPtr (Proxy p) = p

foreign import ccall "g_proxy_get_type"
    c_g_proxy_get_type :: IO B.Types.GType

instance B.Types.TypedObject Proxy where
    glibType = c_g_proxy_get_type

instance B.Types.GObject Proxy

-- | Type class for types which can be safely cast to `Proxy`, for instance with `toProxy`.
class (SP.GObject o, O.IsDescendantOf Proxy o) => IsProxy o
instance (SP.GObject o, O.IsDescendantOf Proxy o) => IsProxy o

instance O.HasParentTypes Proxy
type instance O.ParentTypes Proxy = '[GObject.Object.Object]

-- | Cast to `Proxy`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toProxy :: (MIO.MonadIO m, IsProxy o) => o -> m Proxy
toProxy = MIO.liftIO . B.ManagedPtr.unsafeCastTo Proxy

-- | Convert 'Proxy' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Proxy) where
    gvalueGType_ = c_g_proxy_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Proxy)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Proxy)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Proxy ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Proxy
type instance O.AttributeList Proxy = ProxyAttributeList
type ProxyAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveProxyMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveProxyMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveProxyMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveProxyMethod "connect" o = ProxyConnectMethodInfo
    ResolveProxyMethod "connectAsync" o = ProxyConnectAsyncMethodInfo
    ResolveProxyMethod "connectFinish" o = ProxyConnectFinishMethodInfo
    ResolveProxyMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveProxyMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveProxyMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveProxyMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveProxyMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveProxyMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveProxyMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveProxyMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveProxyMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveProxyMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveProxyMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveProxyMethod "supportsHostname" o = ProxySupportsHostnameMethodInfo
    ResolveProxyMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveProxyMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveProxyMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveProxyMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveProxyMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveProxyMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveProxyMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveProxyMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveProxyMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveProxyMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveProxyMethod t Proxy, O.OverloadedMethod info Proxy p) => OL.IsLabel t (Proxy -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveProxyMethod t Proxy, O.OverloadedMethod info Proxy p, R.HasField t Proxy p) => R.HasField t Proxy p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveProxyMethod t Proxy, O.OverloadedMethodInfo info Proxy) => OL.IsLabel t (O.MethodProxy info Proxy) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method Proxy::connect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType = TInterface Name { namespace = "Gio" , name = "Proxy" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOStream" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "proxy_address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "IOStream" })
-- throws : True
-- Skip return : False

foreign import ccall "g_proxy_connect" g_proxy_connect :: 
    Ptr Proxy ->                            -- proxy : TInterface (Name {namespace = "Gio", name = "Proxy"})
    Ptr Gio.IOStream.IOStream ->            -- connection : TInterface (Name {namespace = "Gio", name = "IOStream"})
    Ptr Gio.ProxyAddress.ProxyAddress ->    -- proxy_address : TInterface (Name {namespace = "Gio", name = "ProxyAddress"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.IOStream.IOStream)

-- | Given /@connection@/ to communicate with a proxy (eg, a
-- t'GI.Gio.Objects.SocketConnection.SocketConnection' that is connected to the proxy server), this
-- does the necessary handshake to connect to /@proxyAddress@/, and if
-- required, wraps the t'GI.Gio.Objects.IOStream.IOStream' to handle proxy payload.
-- 
-- /Since: 2.26/
proxyConnect ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxy a, Gio.IOStream.IsIOStream b, Gio.ProxyAddress.IsProxyAddress c, Gio.Cancellable.IsCancellable d) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Interfaces.Proxy.Proxy'
    -> b
    -- ^ /@connection@/: a t'GI.Gio.Objects.IOStream.IOStream'
    -> c
    -- ^ /@proxyAddress@/: a t'GI.Gio.Objects.ProxyAddress.ProxyAddress'
    -> Maybe (d)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable'
    -> m Gio.IOStream.IOStream
    -- ^ __Returns:__ a t'GI.Gio.Objects.IOStream.IOStream' that will replace /@connection@/. This might
    --               be the same as /@connection@/, in which case a reference
    --               will be added. /(Can throw 'Data.GI.Base.GError.GError')/
proxyConnect proxy connection proxyAddress cancellable = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    connection' <- unsafeManagedPtrCastPtr connection
    proxyAddress' <- unsafeManagedPtrCastPtr proxyAddress
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_proxy_connect proxy' connection' proxyAddress' maybeCancellable
        checkUnexpectedReturnNULL "proxyConnect" result
        result' <- (wrapObject Gio.IOStream.IOStream) result
        touchManagedPtr proxy
        touchManagedPtr connection
        touchManagedPtr proxyAddress
        whenJust cancellable touchManagedPtr
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data ProxyConnectMethodInfo
instance (signature ~ (b -> c -> Maybe (d) -> m Gio.IOStream.IOStream), MonadIO m, IsProxy a, Gio.IOStream.IsIOStream b, Gio.ProxyAddress.IsProxyAddress c, Gio.Cancellable.IsCancellable d) => O.OverloadedMethod ProxyConnectMethodInfo a signature where
    overloadedMethod = proxyConnect

instance O.OverloadedMethodInfo ProxyConnectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Proxy.proxyConnect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Proxy.html#v:proxyConnect"
        })


#endif

-- method Proxy::connect_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType = TInterface Name { namespace = "Gio" , name = "Proxy" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOStream" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "proxy_address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "callback data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_connect_async" g_proxy_connect_async :: 
    Ptr Proxy ->                            -- proxy : TInterface (Name {namespace = "Gio", name = "Proxy"})
    Ptr Gio.IOStream.IOStream ->            -- connection : TInterface (Name {namespace = "Gio", name = "IOStream"})
    Ptr Gio.ProxyAddress.ProxyAddress ->    -- proxy_address : TInterface (Name {namespace = "Gio", name = "ProxyAddress"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronous version of 'GI.Gio.Interfaces.Proxy.proxyConnect'.
-- 
-- /Since: 2.26/
proxyConnectAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxy a, Gio.IOStream.IsIOStream b, Gio.ProxyAddress.IsProxyAddress c, Gio.Cancellable.IsCancellable d) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Interfaces.Proxy.Proxy'
    -> b
    -- ^ /@connection@/: a t'GI.Gio.Objects.IOStream.IOStream'
    -> c
    -- ^ /@proxyAddress@/: a t'GI.Gio.Objects.ProxyAddress.ProxyAddress'
    -> Maybe (d)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    -> m ()
proxyConnectAsync proxy connection proxyAddress cancellable callback = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    connection' <- unsafeManagedPtrCastPtr connection
    proxyAddress' <- unsafeManagedPtrCastPtr proxyAddress
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_proxy_connect_async proxy' connection' proxyAddress' maybeCancellable maybeCallback userData
    touchManagedPtr proxy
    touchManagedPtr connection
    touchManagedPtr proxyAddress
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ProxyConnectAsyncMethodInfo
instance (signature ~ (b -> c -> Maybe (d) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsProxy a, Gio.IOStream.IsIOStream b, Gio.ProxyAddress.IsProxyAddress c, Gio.Cancellable.IsCancellable d) => O.OverloadedMethod ProxyConnectAsyncMethodInfo a signature where
    overloadedMethod = proxyConnectAsync

instance O.OverloadedMethodInfo ProxyConnectAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Proxy.proxyConnectAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Proxy.html#v:proxyConnectAsync"
        })


#endif

-- method Proxy::connect_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType = TInterface Name { namespace = "Gio" , name = "Proxy" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "IOStream" })
-- throws : True
-- Skip return : False

foreign import ccall "g_proxy_connect_finish" g_proxy_connect_finish :: 
    Ptr Proxy ->                            -- proxy : TInterface (Name {namespace = "Gio", name = "Proxy"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.IOStream.IOStream)

-- | See 'GI.Gio.Interfaces.Proxy.proxyConnect'.
-- 
-- /Since: 2.26/
proxyConnectFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxy a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Interfaces.Proxy.Proxy'
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'
    -> m Gio.IOStream.IOStream
    -- ^ __Returns:__ a t'GI.Gio.Objects.IOStream.IOStream'. /(Can throw 'Data.GI.Base.GError.GError')/
proxyConnectFinish proxy result_ = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_proxy_connect_finish proxy' result_'
        checkUnexpectedReturnNULL "proxyConnectFinish" result
        result' <- (wrapObject Gio.IOStream.IOStream) result
        touchManagedPtr proxy
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data ProxyConnectFinishMethodInfo
instance (signature ~ (b -> m Gio.IOStream.IOStream), MonadIO m, IsProxy a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod ProxyConnectFinishMethodInfo a signature where
    overloadedMethod = proxyConnectFinish

instance O.OverloadedMethodInfo ProxyConnectFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Proxy.proxyConnectFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Proxy.html#v:proxyConnectFinish"
        })


#endif

-- method Proxy::supports_hostname
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType = TInterface Name { namespace = "Gio" , name = "Proxy" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxy" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_supports_hostname" g_proxy_supports_hostname :: 
    Ptr Proxy ->                            -- proxy : TInterface (Name {namespace = "Gio", name = "Proxy"})
    IO CInt

-- | Some proxy protocols expect to be passed a hostname, which they
-- will resolve to an IP address themselves. Others, like SOCKS4, do
-- not allow this. This function will return 'P.False' if /@proxy@/ is
-- implementing such a protocol. When 'P.False' is returned, the caller
-- should resolve the destination hostname first, and then pass a
-- t'GI.Gio.Objects.ProxyAddress.ProxyAddress' containing the stringified IP address to
-- 'GI.Gio.Interfaces.Proxy.proxyConnect' or 'GI.Gio.Interfaces.Proxy.proxyConnectAsync'.
-- 
-- /Since: 2.26/
proxySupportsHostname ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxy a) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Interfaces.Proxy.Proxy'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if hostname resolution is supported.
proxySupportsHostname proxy = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    result <- g_proxy_supports_hostname proxy'
    let result' = (/= 0) result
    touchManagedPtr proxy
    return result'

#if defined(ENABLE_OVERLOADING)
data ProxySupportsHostnameMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsProxy a) => O.OverloadedMethod ProxySupportsHostnameMethodInfo a signature where
    overloadedMethod = proxySupportsHostname

instance O.OverloadedMethodInfo ProxySupportsHostnameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Proxy.proxySupportsHostname",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Proxy.html#v:proxySupportsHostname"
        })


#endif

-- method Proxy::get_default_for_protocol
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "protocol"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the proxy protocol name (e.g. http, socks, etc)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Proxy" })
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_get_default_for_protocol" g_proxy_get_default_for_protocol :: 
    CString ->                              -- protocol : TBasicType TUTF8
    IO (Ptr Proxy)

-- | Find the @gio-proxy@ extension point for a proxy implementation that supports
-- the specified protocol.
-- 
-- /Since: 2.26/
proxyGetDefaultForProtocol ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@protocol@/: the proxy protocol name (e.g. http, socks, etc)
    -> m (Maybe Proxy)
    -- ^ __Returns:__ return a t'GI.Gio.Interfaces.Proxy.Proxy' or NULL if protocol
    --               is not supported.
proxyGetDefaultForProtocol protocol = liftIO $ do
    protocol' <- textToCString protocol
    result <- g_proxy_get_default_for_protocol protocol'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Proxy) result'
        return result''
    freeMem protocol'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Proxy = ProxySignalList
type ProxySignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


