{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GPollableOutputStream@ is implemented by t'GI.Gio.Objects.OutputStream.OutputStream's that
-- can be polled for readiness to write. This can be used when
-- interfacing with a non-GIO API that expects
-- UNIX-file-descriptor-style asynchronous I\/O rather than GIO-style.
-- 
-- Some classes may implement @GPollableOutputStream@ but have only certain
-- instances of that class be pollable. If 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCanPoll'
-- returns false, then the behavior of other @GPollableOutputStream@ methods is
-- undefined.
-- 
-- /Since: 2.28/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.PollableOutputStream
    ( 

-- * Exported types
    PollableOutputStream(..)                ,
    IsPollableOutputStream                  ,
    toPollableOutputStream                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canPoll]("GI.Gio.Interfaces.PollableOutputStream#g:method:canPoll"), [clearPending]("GI.Gio.Objects.OutputStream#g:method:clearPending"), [close]("GI.Gio.Objects.OutputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.OutputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.OutputStream#g:method:closeFinish"), [createSource]("GI.Gio.Interfaces.PollableOutputStream#g:method:createSource"), [flush]("GI.Gio.Objects.OutputStream#g:method:flush"), [flushAsync]("GI.Gio.Objects.OutputStream#g:method:flushAsync"), [flushFinish]("GI.Gio.Objects.OutputStream#g:method:flushFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.OutputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.OutputStream#g:method:isClosed"), [isClosing]("GI.Gio.Objects.OutputStream#g:method:isClosing"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isWritable]("GI.Gio.Interfaces.PollableOutputStream#g:method:isWritable"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [splice]("GI.Gio.Objects.OutputStream#g:method:splice"), [spliceAsync]("GI.Gio.Objects.OutputStream#g:method:spliceAsync"), [spliceFinish]("GI.Gio.Objects.OutputStream#g:method:spliceFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [write]("GI.Gio.Objects.OutputStream#g:method:write"), [writeAll]("GI.Gio.Objects.OutputStream#g:method:writeAll"), [writeAllAsync]("GI.Gio.Objects.OutputStream#g:method:writeAllAsync"), [writeAllFinish]("GI.Gio.Objects.OutputStream#g:method:writeAllFinish"), [writeAsync]("GI.Gio.Objects.OutputStream#g:method:writeAsync"), [writeBytes]("GI.Gio.Objects.OutputStream#g:method:writeBytes"), [writeBytesAsync]("GI.Gio.Objects.OutputStream#g:method:writeBytesAsync"), [writeBytesFinish]("GI.Gio.Objects.OutputStream#g:method:writeBytesFinish"), [writeFinish]("GI.Gio.Objects.OutputStream#g:method:writeFinish"), [writeNonblocking]("GI.Gio.Interfaces.PollableOutputStream#g:method:writeNonblocking"), [writev]("GI.Gio.Objects.OutputStream#g:method:writev"), [writevAll]("GI.Gio.Objects.OutputStream#g:method:writevAll"), [writevAllAsync]("GI.Gio.Objects.OutputStream#g:method:writevAllAsync"), [writevAllFinish]("GI.Gio.Objects.OutputStream#g:method:writevAllFinish"), [writevAsync]("GI.Gio.Objects.OutputStream#g:method:writevAsync"), [writevFinish]("GI.Gio.Objects.OutputStream#g:method:writevFinish"), [writevNonblocking]("GI.Gio.Interfaces.PollableOutputStream#g:method:writevNonblocking").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.OutputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolvePollableOutputStreamMethod       ,
#endif

-- ** canPoll #method:canPoll#

#if defined(ENABLE_OVERLOADING)
    PollableOutputStreamCanPollMethodInfo   ,
#endif
    pollableOutputStreamCanPoll             ,


-- ** createSource #method:createSource#

#if defined(ENABLE_OVERLOADING)
    PollableOutputStreamCreateSourceMethodInfo,
#endif
    pollableOutputStreamCreateSource        ,


-- ** isWritable #method:isWritable#

#if defined(ENABLE_OVERLOADING)
    PollableOutputStreamIsWritableMethodInfo,
#endif
    pollableOutputStreamIsWritable          ,


-- ** writeNonblocking #method:writeNonblocking#

#if defined(ENABLE_OVERLOADING)
    PollableOutputStreamWriteNonblockingMethodInfo,
#endif
    pollableOutputStreamWriteNonblocking    ,


-- ** writevNonblocking #method:writevNonblocking#

#if defined(ENABLE_OVERLOADING)
    PollableOutputStreamWritevNonblockingMethodInfo,
#endif
    pollableOutputStreamWritevNonblocking   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#endif

-- interface PollableOutputStream 
-- | Memory-managed wrapper type.
newtype PollableOutputStream = PollableOutputStream (SP.ManagedPtr PollableOutputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype PollableOutputStream where
    toManagedPtr (PollableOutputStream p) = p

foreign import ccall "g_pollable_output_stream_get_type"
    c_g_pollable_output_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject PollableOutputStream where
    glibType = c_g_pollable_output_stream_get_type

instance B.Types.GObject PollableOutputStream

-- | Type class for types which can be safely cast to `PollableOutputStream`, for instance with `toPollableOutputStream`.
class (SP.GObject o, O.IsDescendantOf PollableOutputStream o) => IsPollableOutputStream o
instance (SP.GObject o, O.IsDescendantOf PollableOutputStream o) => IsPollableOutputStream o

instance O.HasParentTypes PollableOutputStream
type instance O.ParentTypes PollableOutputStream = '[Gio.OutputStream.OutputStream, GObject.Object.Object]

-- | Cast to `PollableOutputStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toPollableOutputStream :: (MIO.MonadIO m, IsPollableOutputStream o) => o -> m PollableOutputStream
toPollableOutputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo PollableOutputStream

-- | Convert 'PollableOutputStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PollableOutputStream) where
    gvalueGType_ = c_g_pollable_output_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PollableOutputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PollableOutputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PollableOutputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PollableOutputStream
type instance O.AttributeList PollableOutputStream = PollableOutputStreamAttributeList
type PollableOutputStreamAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePollableOutputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePollableOutputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePollableOutputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePollableOutputStreamMethod "canPoll" o = PollableOutputStreamCanPollMethodInfo
    ResolvePollableOutputStreamMethod "clearPending" o = Gio.OutputStream.OutputStreamClearPendingMethodInfo
    ResolvePollableOutputStreamMethod "close" o = Gio.OutputStream.OutputStreamCloseMethodInfo
    ResolvePollableOutputStreamMethod "closeAsync" o = Gio.OutputStream.OutputStreamCloseAsyncMethodInfo
    ResolvePollableOutputStreamMethod "closeFinish" o = Gio.OutputStream.OutputStreamCloseFinishMethodInfo
    ResolvePollableOutputStreamMethod "createSource" o = PollableOutputStreamCreateSourceMethodInfo
    ResolvePollableOutputStreamMethod "flush" o = Gio.OutputStream.OutputStreamFlushMethodInfo
    ResolvePollableOutputStreamMethod "flushAsync" o = Gio.OutputStream.OutputStreamFlushAsyncMethodInfo
    ResolvePollableOutputStreamMethod "flushFinish" o = Gio.OutputStream.OutputStreamFlushFinishMethodInfo
    ResolvePollableOutputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePollableOutputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePollableOutputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePollableOutputStreamMethod "hasPending" o = Gio.OutputStream.OutputStreamHasPendingMethodInfo
    ResolvePollableOutputStreamMethod "isClosed" o = Gio.OutputStream.OutputStreamIsClosedMethodInfo
    ResolvePollableOutputStreamMethod "isClosing" o = Gio.OutputStream.OutputStreamIsClosingMethodInfo
    ResolvePollableOutputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePollableOutputStreamMethod "isWritable" o = PollableOutputStreamIsWritableMethodInfo
    ResolvePollableOutputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePollableOutputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePollableOutputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePollableOutputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePollableOutputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePollableOutputStreamMethod "splice" o = Gio.OutputStream.OutputStreamSpliceMethodInfo
    ResolvePollableOutputStreamMethod "spliceAsync" o = Gio.OutputStream.OutputStreamSpliceAsyncMethodInfo
    ResolvePollableOutputStreamMethod "spliceFinish" o = Gio.OutputStream.OutputStreamSpliceFinishMethodInfo
    ResolvePollableOutputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePollableOutputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePollableOutputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePollableOutputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePollableOutputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePollableOutputStreamMethod "write" o = Gio.OutputStream.OutputStreamWriteMethodInfo
    ResolvePollableOutputStreamMethod "writeAll" o = Gio.OutputStream.OutputStreamWriteAllMethodInfo
    ResolvePollableOutputStreamMethod "writeAllAsync" o = Gio.OutputStream.OutputStreamWriteAllAsyncMethodInfo
    ResolvePollableOutputStreamMethod "writeAllFinish" o = Gio.OutputStream.OutputStreamWriteAllFinishMethodInfo
    ResolvePollableOutputStreamMethod "writeAsync" o = Gio.OutputStream.OutputStreamWriteAsyncMethodInfo
    ResolvePollableOutputStreamMethod "writeBytes" o = Gio.OutputStream.OutputStreamWriteBytesMethodInfo
    ResolvePollableOutputStreamMethod "writeBytesAsync" o = Gio.OutputStream.OutputStreamWriteBytesAsyncMethodInfo
    ResolvePollableOutputStreamMethod "writeBytesFinish" o = Gio.OutputStream.OutputStreamWriteBytesFinishMethodInfo
    ResolvePollableOutputStreamMethod "writeFinish" o = Gio.OutputStream.OutputStreamWriteFinishMethodInfo
    ResolvePollableOutputStreamMethod "writeNonblocking" o = PollableOutputStreamWriteNonblockingMethodInfo
    ResolvePollableOutputStreamMethod "writev" o = Gio.OutputStream.OutputStreamWritevMethodInfo
    ResolvePollableOutputStreamMethod "writevAll" o = Gio.OutputStream.OutputStreamWritevAllMethodInfo
    ResolvePollableOutputStreamMethod "writevAllAsync" o = Gio.OutputStream.OutputStreamWritevAllAsyncMethodInfo
    ResolvePollableOutputStreamMethod "writevAllFinish" o = Gio.OutputStream.OutputStreamWritevAllFinishMethodInfo
    ResolvePollableOutputStreamMethod "writevAsync" o = Gio.OutputStream.OutputStreamWritevAsyncMethodInfo
    ResolvePollableOutputStreamMethod "writevFinish" o = Gio.OutputStream.OutputStreamWritevFinishMethodInfo
    ResolvePollableOutputStreamMethod "writevNonblocking" o = PollableOutputStreamWritevNonblockingMethodInfo
    ResolvePollableOutputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePollableOutputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePollableOutputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePollableOutputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePollableOutputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePollableOutputStreamMethod "setPending" o = Gio.OutputStream.OutputStreamSetPendingMethodInfo
    ResolvePollableOutputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePollableOutputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePollableOutputStreamMethod t PollableOutputStream, O.OverloadedMethod info PollableOutputStream p) => OL.IsLabel t (PollableOutputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePollableOutputStreamMethod t PollableOutputStream, O.OverloadedMethod info PollableOutputStream p, R.HasField t PollableOutputStream p) => R.HasField t PollableOutputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePollableOutputStreamMethod t PollableOutputStream, O.OverloadedMethodInfo info PollableOutputStream) => OL.IsLabel t (O.MethodProxy info PollableOutputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method PollableOutputStream::can_poll
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "PollableOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GPollableOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_pollable_output_stream_can_poll" g_pollable_output_stream_can_poll :: 
    Ptr PollableOutputStream ->             -- stream : TInterface (Name {namespace = "Gio", name = "PollableOutputStream"})
    IO CInt

-- | Checks if /@stream@/ is actually pollable. Some classes may implement
-- t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream' but have only certain instances of that
-- class be pollable. If this method returns 'P.False', then the behavior
-- of other t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream' methods is undefined.
-- 
-- For any given stream, the value returned by this method is constant;
-- a stream cannot switch from pollable to non-pollable or vice versa.
-- 
-- /Since: 2.28/
pollableOutputStreamCanPoll ::
    (B.CallStack.HasCallStack, MonadIO m, IsPollableOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@stream@/ is pollable, 'P.False' if not.
pollableOutputStreamCanPoll stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_pollable_output_stream_can_poll stream'
    let result' = (/= 0) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
data PollableOutputStreamCanPollMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPollableOutputStream a) => O.OverloadedMethod PollableOutputStreamCanPollMethodInfo a signature where
    overloadedMethod = pollableOutputStreamCanPoll

instance O.OverloadedMethodInfo PollableOutputStreamCanPollMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCanPoll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-PollableOutputStream.html#v:pollableOutputStreamCanPoll"
        })


#endif

-- method PollableOutputStream::create_source
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "PollableOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GPollableOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_pollable_output_stream_create_source" g_pollable_output_stream_create_source :: 
    Ptr PollableOutputStream ->             -- stream : TInterface (Name {namespace = "Gio", name = "PollableOutputStream"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    IO (Ptr GLib.Source.Source)

-- | Creates a t'GI.GLib.Structs.Source.Source' that triggers when /@stream@/ can be written, or
-- /@cancellable@/ is triggered or an error occurs. The callback on the
-- source is of the t'GI.Gio.Callbacks.PollableSourceFunc' type.
-- 
-- As with 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamIsWritable', it is possible that
-- the stream may not actually be writable even after the source
-- triggers, so you should use 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamWriteNonblocking'
-- rather than 'GI.Gio.Objects.OutputStream.outputStreamWrite' from the callback.
-- 
-- The behaviour of this method is undefined if
-- 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCanPoll' returns 'P.False' for /@stream@/.
-- 
-- /Since: 2.28/
pollableOutputStreamCreateSource ::
    (B.CallStack.HasCallStack, MonadIO m, IsPollableOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'.
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m GLib.Source.Source
    -- ^ __Returns:__ a new t'GI.GLib.Structs.Source.Source'
pollableOutputStreamCreateSource stream cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    result <- g_pollable_output_stream_create_source stream' maybeCancellable
    checkUnexpectedReturnNULL "pollableOutputStreamCreateSource" result
    result' <- (wrapBoxed GLib.Source.Source) result
    touchManagedPtr stream
    whenJust cancellable touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data PollableOutputStreamCreateSourceMethodInfo
instance (signature ~ (Maybe (b) -> m GLib.Source.Source), MonadIO m, IsPollableOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod PollableOutputStreamCreateSourceMethodInfo a signature where
    overloadedMethod = pollableOutputStreamCreateSource

instance O.OverloadedMethodInfo PollableOutputStreamCreateSourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCreateSource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-PollableOutputStream.html#v:pollableOutputStreamCreateSource"
        })


#endif

-- method PollableOutputStream::is_writable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "PollableOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GPollableOutputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_pollable_output_stream_is_writable" g_pollable_output_stream_is_writable :: 
    Ptr PollableOutputStream ->             -- stream : TInterface (Name {namespace = "Gio", name = "PollableOutputStream"})
    IO CInt

-- | Checks if /@stream@/ can be written.
-- 
-- Note that some stream types may not be able to implement this 100%
-- reliably, and it is possible that a call to 'GI.Gio.Objects.OutputStream.outputStreamWrite'
-- after this returns 'P.True' would still block. To guarantee
-- non-blocking behavior, you should always use
-- 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamWriteNonblocking', which will return a
-- 'GI.Gio.Enums.IOErrorEnumWouldBlock' error rather than blocking.
-- 
-- The behaviour of this method is undefined if
-- 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCanPoll' returns 'P.False' for /@stream@/.
-- 
-- /Since: 2.28/
pollableOutputStreamIsWritable ::
    (B.CallStack.HasCallStack, MonadIO m, IsPollableOutputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@stream@/ is writable, 'P.False' if not. If an error
    --   has occurred on /@stream@/, this will result in
    --   'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamIsWritable' returning 'P.True', and the
    --   next attempt to write will return the error.
pollableOutputStreamIsWritable stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_pollable_output_stream_is_writable stream'
    let result' = (/= 0) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
data PollableOutputStreamIsWritableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPollableOutputStream a) => O.OverloadedMethod PollableOutputStreamIsWritableMethodInfo a signature where
    overloadedMethod = pollableOutputStreamIsWritable

instance O.OverloadedMethodInfo PollableOutputStreamIsWritableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamIsWritable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-PollableOutputStream.html#v:pollableOutputStreamIsWritable"
        })


#endif

-- method PollableOutputStream::write_nonblocking
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "PollableOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GPollableOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a buffer to write\n    data from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes you want to write"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of bytes you want to write"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TSSize)
-- throws : True
-- Skip return : False

foreign import ccall "g_pollable_output_stream_write_nonblocking" g_pollable_output_stream_write_nonblocking :: 
    Ptr PollableOutputStream ->             -- stream : TInterface (Name {namespace = "Gio", name = "PollableOutputStream"})
    Ptr Word8 ->                            -- buffer : TCArray False (-1) 2 (TBasicType TUInt8)
    FCT.CSize ->                            -- count : TBasicType TSize
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO DI.Int64

-- | Attempts to write up to /@count@/ bytes from /@buffer@/ to /@stream@/, as
-- with 'GI.Gio.Objects.OutputStream.outputStreamWrite'. If /@stream@/ is not currently writable,
-- this will immediately return 'GI.Gio.Enums.IOErrorEnumWouldBlock', and you can
-- use 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCreateSource' to create a t'GI.GLib.Structs.Source.Source'
-- that will be triggered when /@stream@/ is writable.
-- 
-- Note that since this method never blocks, you cannot actually
-- use /@cancellable@/ to cancel it. However, it will return an error
-- if /@cancellable@/ has already been cancelled when you call, which
-- may happen if you call this method after a source triggers due
-- to having been cancelled.
-- 
-- Also note that if 'GI.Gio.Enums.IOErrorEnumWouldBlock' is returned some underlying
-- transports like D\/TLS require that you re-send the same /@buffer@/ and
-- /@count@/ in the next write call.
-- 
-- The behaviour of this method is undefined if
-- 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCanPoll' returns 'P.False' for /@stream@/.
pollableOutputStreamWriteNonblocking ::
    (B.CallStack.HasCallStack, MonadIO m, IsPollableOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'
    -> Maybe (ByteString)
    -- ^ /@buffer@/: a buffer to write
    --     data from
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m DI.Int64
    -- ^ __Returns:__ the number of bytes written, or -1 on error (including
    --   'GI.Gio.Enums.IOErrorEnumWouldBlock'). /(Can throw 'Data.GI.Base.GError.GError')/
pollableOutputStreamWriteNonblocking stream buffer cancellable = liftIO $ do
    let count = case buffer of
            Nothing -> 0
            Just jBuffer -> fromIntegral $ B.length jBuffer
    stream' <- unsafeManagedPtrCastPtr stream
    maybeBuffer <- case buffer of
        Nothing -> return FP.nullPtr
        Just jBuffer -> do
            jBuffer' <- packByteString jBuffer
            return jBuffer'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_pollable_output_stream_write_nonblocking stream' maybeBuffer count maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        freeMem maybeBuffer
        return result
     ) (do
        freeMem maybeBuffer
     )

#if defined(ENABLE_OVERLOADING)
data PollableOutputStreamWriteNonblockingMethodInfo
instance (signature ~ (Maybe (ByteString) -> Maybe (b) -> m DI.Int64), MonadIO m, IsPollableOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod PollableOutputStreamWriteNonblockingMethodInfo a signature where
    overloadedMethod = pollableOutputStreamWriteNonblocking

instance O.OverloadedMethodInfo PollableOutputStreamWriteNonblockingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamWriteNonblocking",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-PollableOutputStream.html#v:pollableOutputStreamWriteNonblocking"
        })


#endif

-- method PollableOutputStream::writev_nonblocking
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "PollableOutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GPollableOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vectors"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "Gio" , name = "OutputVector" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the buffer containing the #GOutputVectors to write."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_vectors"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of vectors to write"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes_written"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the number of bytes that were\n    written to the stream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_vectors"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of vectors to write"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "PollableReturn" })
-- throws : True
-- Skip return : False

foreign import ccall "g_pollable_output_stream_writev_nonblocking" g_pollable_output_stream_writev_nonblocking :: 
    Ptr PollableOutputStream ->             -- stream : TInterface (Name {namespace = "Gio", name = "PollableOutputStream"})
    Ptr Gio.OutputVector.OutputVector ->    -- vectors : TCArray False (-1) 2 (TInterface (Name {namespace = "Gio", name = "OutputVector"}))
    FCT.CSize ->                            -- n_vectors : TBasicType TSize
    Ptr FCT.CSize ->                        -- bytes_written : TBasicType TSize
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Attempts to write the bytes contained in the /@nVectors@/ /@vectors@/ to /@stream@/,
-- as with 'GI.Gio.Objects.OutputStream.outputStreamWritev'. If /@stream@/ is not currently writable,
-- this will immediately return %/@gPOLLABLERETURNWOULDBLOCK@/, and you can
-- use 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCreateSource' to create a t'GI.GLib.Structs.Source.Source'
-- that will be triggered when /@stream@/ is writable. /@error@/ will *not* be
-- set in that case.
-- 
-- Note that since this method never blocks, you cannot actually
-- use /@cancellable@/ to cancel it. However, it will return an error
-- if /@cancellable@/ has already been cancelled when you call, which
-- may happen if you call this method after a source triggers due
-- to having been cancelled.
-- 
-- Also note that if 'GI.Gio.Enums.PollableReturnWouldBlock' is returned some underlying
-- transports like D\/TLS require that you re-send the same /@vectors@/ and
-- /@nVectors@/ in the next write call.
-- 
-- The behaviour of this method is undefined if
-- 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCanPoll' returns 'P.False' for /@stream@/.
-- 
-- /Since: 2.60/
pollableOutputStreamWritevNonblocking ::
    (B.CallStack.HasCallStack, MonadIO m, IsPollableOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'
    -> [Gio.OutputVector.OutputVector]
    -- ^ /@vectors@/: the buffer containing the @/GOutputVectors/@ to write.
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m ((Gio.Enums.PollableReturn, FCT.CSize))
    -- ^ __Returns:__ %/@gPOLLABLERETURNOK@/ on success, 'GI.Gio.Enums.PollableReturnWouldBlock'
    -- if the stream is not currently writable (and /@error@/ is *not* set), or
    -- 'GI.Gio.Enums.PollableReturnFailed' if there was an error in which case /@error@/ will
    -- be set. /(Can throw 'Data.GI.Base.GError.GError')/
pollableOutputStreamWritevNonblocking stream vectors cancellable = liftIO $ do
    let nVectors = fromIntegral $ P.length vectors
    stream' <- unsafeManagedPtrCastPtr stream
    vectors' <- mapM unsafeManagedPtrGetPtr vectors
    vectors'' <- packBlockArray 16 vectors'
    bytesWritten <- allocMem :: IO (Ptr FCT.CSize)
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_pollable_output_stream_writev_nonblocking stream' vectors'' nVectors bytesWritten maybeCancellable
        let result' = (toEnum . fromIntegral) result
        bytesWritten' <- peek bytesWritten
        touchManagedPtr stream
        mapM_ touchManagedPtr vectors
        whenJust cancellable touchManagedPtr
        freeMem vectors''
        freeMem bytesWritten
        return (result', bytesWritten')
     ) (do
        freeMem vectors''
        freeMem bytesWritten
     )

#if defined(ENABLE_OVERLOADING)
data PollableOutputStreamWritevNonblockingMethodInfo
instance (signature ~ ([Gio.OutputVector.OutputVector] -> Maybe (b) -> m ((Gio.Enums.PollableReturn, FCT.CSize))), MonadIO m, IsPollableOutputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod PollableOutputStreamWritevNonblockingMethodInfo a signature where
    overloadedMethod = pollableOutputStreamWritevNonblocking

instance O.OverloadedMethodInfo PollableOutputStreamWritevNonblockingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamWritevNonblocking",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-PollableOutputStream.html#v:pollableOutputStreamWritevNonblocking"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PollableOutputStream = PollableOutputStreamSignalList
type PollableOutputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


