{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GPollableInputStream@ is implemented by t'GI.Gio.Objects.InputStream.InputStream's that
-- can be polled for readiness to read. This can be used when
-- interfacing with a non-GIO API that expects
-- UNIX-file-descriptor-style asynchronous I\/O rather than GIO-style.
-- 
-- Some classes may implement @GPollableInputStream@ but have only certain
-- instances of that class be pollable. If 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamCanPoll'
-- returns false, then the behavior of other @GPollableInputStream@ methods is
-- undefined.
-- 
-- /Since: 2.28/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.PollableInputStream
    ( 

-- * Exported types
    PollableInputStream(..)                 ,
    IsPollableInputStream                   ,
    toPollableInputStream                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canPoll]("GI.Gio.Interfaces.PollableInputStream#g:method:canPoll"), [clearPending]("GI.Gio.Objects.InputStream#g:method:clearPending"), [close]("GI.Gio.Objects.InputStream#g:method:close"), [closeAsync]("GI.Gio.Objects.InputStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.InputStream#g:method:closeFinish"), [createSource]("GI.Gio.Interfaces.PollableInputStream#g:method:createSource"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.InputStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.InputStream#g:method:isClosed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isReadable]("GI.Gio.Interfaces.PollableInputStream#g:method:isReadable"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [read]("GI.Gio.Objects.InputStream#g:method:read"), [readAll]("GI.Gio.Objects.InputStream#g:method:readAll"), [readAllAsync]("GI.Gio.Objects.InputStream#g:method:readAllAsync"), [readAllFinish]("GI.Gio.Objects.InputStream#g:method:readAllFinish"), [readAsync]("GI.Gio.Objects.InputStream#g:method:readAsync"), [readBytes]("GI.Gio.Objects.InputStream#g:method:readBytes"), [readBytesAsync]("GI.Gio.Objects.InputStream#g:method:readBytesAsync"), [readBytesFinish]("GI.Gio.Objects.InputStream#g:method:readBytesFinish"), [readFinish]("GI.Gio.Objects.InputStream#g:method:readFinish"), [readNonblocking]("GI.Gio.Interfaces.PollableInputStream#g:method:readNonblocking"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [skip]("GI.Gio.Objects.InputStream#g:method:skip"), [skipAsync]("GI.Gio.Objects.InputStream#g:method:skipAsync"), [skipFinish]("GI.Gio.Objects.InputStream#g:method:skipFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setPending]("GI.Gio.Objects.InputStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolvePollableInputStreamMethod        ,
#endif

-- ** canPoll #method:canPoll#

#if defined(ENABLE_OVERLOADING)
    PollableInputStreamCanPollMethodInfo    ,
#endif
    pollableInputStreamCanPoll              ,


-- ** createSource #method:createSource#

#if defined(ENABLE_OVERLOADING)
    PollableInputStreamCreateSourceMethodInfo,
#endif
    pollableInputStreamCreateSource         ,


-- ** isReadable #method:isReadable#

#if defined(ENABLE_OVERLOADING)
    PollableInputStreamIsReadableMethodInfo ,
#endif
    pollableInputStreamIsReadable           ,


-- ** readNonblocking #method:readNonblocking#

#if defined(ENABLE_OVERLOADING)
    PollableInputStreamReadNonblockingMethodInfo,
#endif
    pollableInputStreamReadNonblocking      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#else
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#endif

-- interface PollableInputStream 
-- | Memory-managed wrapper type.
newtype PollableInputStream = PollableInputStream (SP.ManagedPtr PollableInputStream)
    deriving (Eq)

instance SP.ManagedPtrNewtype PollableInputStream where
    toManagedPtr (PollableInputStream p) = p

foreign import ccall "g_pollable_input_stream_get_type"
    c_g_pollable_input_stream_get_type :: IO B.Types.GType

instance B.Types.TypedObject PollableInputStream where
    glibType = c_g_pollable_input_stream_get_type

instance B.Types.GObject PollableInputStream

-- | Type class for types which can be safely cast to `PollableInputStream`, for instance with `toPollableInputStream`.
class (SP.GObject o, O.IsDescendantOf PollableInputStream o) => IsPollableInputStream o
instance (SP.GObject o, O.IsDescendantOf PollableInputStream o) => IsPollableInputStream o

instance O.HasParentTypes PollableInputStream
type instance O.ParentTypes PollableInputStream = '[Gio.InputStream.InputStream, GObject.Object.Object]

-- | Cast to `PollableInputStream`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toPollableInputStream :: (MIO.MonadIO m, IsPollableInputStream o) => o -> m PollableInputStream
toPollableInputStream = MIO.liftIO . B.ManagedPtr.unsafeCastTo PollableInputStream

-- | Convert 'PollableInputStream' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PollableInputStream) where
    gvalueGType_ = c_g_pollable_input_stream_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PollableInputStream)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PollableInputStream)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PollableInputStream ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PollableInputStream
type instance O.AttributeList PollableInputStream = PollableInputStreamAttributeList
type PollableInputStreamAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePollableInputStreamMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePollableInputStreamMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePollableInputStreamMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePollableInputStreamMethod "canPoll" o = PollableInputStreamCanPollMethodInfo
    ResolvePollableInputStreamMethod "clearPending" o = Gio.InputStream.InputStreamClearPendingMethodInfo
    ResolvePollableInputStreamMethod "close" o = Gio.InputStream.InputStreamCloseMethodInfo
    ResolvePollableInputStreamMethod "closeAsync" o = Gio.InputStream.InputStreamCloseAsyncMethodInfo
    ResolvePollableInputStreamMethod "closeFinish" o = Gio.InputStream.InputStreamCloseFinishMethodInfo
    ResolvePollableInputStreamMethod "createSource" o = PollableInputStreamCreateSourceMethodInfo
    ResolvePollableInputStreamMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePollableInputStreamMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePollableInputStreamMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePollableInputStreamMethod "hasPending" o = Gio.InputStream.InputStreamHasPendingMethodInfo
    ResolvePollableInputStreamMethod "isClosed" o = Gio.InputStream.InputStreamIsClosedMethodInfo
    ResolvePollableInputStreamMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePollableInputStreamMethod "isReadable" o = PollableInputStreamIsReadableMethodInfo
    ResolvePollableInputStreamMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePollableInputStreamMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePollableInputStreamMethod "read" o = Gio.InputStream.InputStreamReadMethodInfo
    ResolvePollableInputStreamMethod "readAll" o = Gio.InputStream.InputStreamReadAllMethodInfo
    ResolvePollableInputStreamMethod "readAllAsync" o = Gio.InputStream.InputStreamReadAllAsyncMethodInfo
    ResolvePollableInputStreamMethod "readAllFinish" o = Gio.InputStream.InputStreamReadAllFinishMethodInfo
    ResolvePollableInputStreamMethod "readAsync" o = Gio.InputStream.InputStreamReadAsyncMethodInfo
    ResolvePollableInputStreamMethod "readBytes" o = Gio.InputStream.InputStreamReadBytesMethodInfo
    ResolvePollableInputStreamMethod "readBytesAsync" o = Gio.InputStream.InputStreamReadBytesAsyncMethodInfo
    ResolvePollableInputStreamMethod "readBytesFinish" o = Gio.InputStream.InputStreamReadBytesFinishMethodInfo
    ResolvePollableInputStreamMethod "readFinish" o = Gio.InputStream.InputStreamReadFinishMethodInfo
    ResolvePollableInputStreamMethod "readNonblocking" o = PollableInputStreamReadNonblockingMethodInfo
    ResolvePollableInputStreamMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePollableInputStreamMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePollableInputStreamMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePollableInputStreamMethod "skip" o = Gio.InputStream.InputStreamSkipMethodInfo
    ResolvePollableInputStreamMethod "skipAsync" o = Gio.InputStream.InputStreamSkipAsyncMethodInfo
    ResolvePollableInputStreamMethod "skipFinish" o = Gio.InputStream.InputStreamSkipFinishMethodInfo
    ResolvePollableInputStreamMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePollableInputStreamMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePollableInputStreamMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePollableInputStreamMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePollableInputStreamMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePollableInputStreamMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePollableInputStreamMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePollableInputStreamMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePollableInputStreamMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePollableInputStreamMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePollableInputStreamMethod "setPending" o = Gio.InputStream.InputStreamSetPendingMethodInfo
    ResolvePollableInputStreamMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePollableInputStreamMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePollableInputStreamMethod t PollableInputStream, O.OverloadedMethod info PollableInputStream p) => OL.IsLabel t (PollableInputStream -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePollableInputStreamMethod t PollableInputStream, O.OverloadedMethod info PollableInputStream p, R.HasField t PollableInputStream p) => R.HasField t PollableInputStream p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePollableInputStreamMethod t PollableInputStream, O.OverloadedMethodInfo info PollableInputStream) => OL.IsLabel t (O.MethodProxy info PollableInputStream) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method PollableInputStream::can_poll
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "PollableInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GPollableInputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_pollable_input_stream_can_poll" g_pollable_input_stream_can_poll :: 
    Ptr PollableInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "PollableInputStream"})
    IO CInt

-- | Checks if /@stream@/ is actually pollable. Some classes may implement
-- t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream' but have only certain instances of that class
-- be pollable. If this method returns 'P.False', then the behavior of
-- other t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream' methods is undefined.
-- 
-- For any given stream, the value returned by this method is constant;
-- a stream cannot switch from pollable to non-pollable or vice versa.
-- 
-- /Since: 2.28/
pollableInputStreamCanPoll ::
    (B.CallStack.HasCallStack, MonadIO m, IsPollableInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@stream@/ is pollable, 'P.False' if not.
pollableInputStreamCanPoll stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_pollable_input_stream_can_poll stream'
    let result' = (/= 0) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
data PollableInputStreamCanPollMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPollableInputStream a) => O.OverloadedMethod PollableInputStreamCanPollMethodInfo a signature where
    overloadedMethod = pollableInputStreamCanPoll

instance O.OverloadedMethodInfo PollableInputStreamCanPollMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PollableInputStream.pollableInputStreamCanPoll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-PollableInputStream.html#v:pollableInputStreamCanPoll"
        })


#endif

-- method PollableInputStream::create_source
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "PollableInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GPollableInputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_pollable_input_stream_create_source" g_pollable_input_stream_create_source :: 
    Ptr PollableInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "PollableInputStream"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    IO (Ptr GLib.Source.Source)

-- | Creates a t'GI.GLib.Structs.Source.Source' that triggers when /@stream@/ can be read, or
-- /@cancellable@/ is triggered or an error occurs. The callback on the
-- source is of the t'GI.Gio.Callbacks.PollableSourceFunc' type.
-- 
-- As with 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamIsReadable', it is possible that
-- the stream may not actually be readable even after the source
-- triggers, so you should use 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamReadNonblocking'
-- rather than 'GI.Gio.Objects.InputStream.inputStreamRead' from the callback.
-- 
-- The behaviour of this method is undefined if
-- 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamCanPoll' returns 'P.False' for /@stream@/.
-- 
-- /Since: 2.28/
pollableInputStreamCreateSource ::
    (B.CallStack.HasCallStack, MonadIO m, IsPollableInputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream'.
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m GLib.Source.Source
    -- ^ __Returns:__ a new t'GI.GLib.Structs.Source.Source'
pollableInputStreamCreateSource stream cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    result <- g_pollable_input_stream_create_source stream' maybeCancellable
    checkUnexpectedReturnNULL "pollableInputStreamCreateSource" result
    result' <- (wrapBoxed GLib.Source.Source) result
    touchManagedPtr stream
    whenJust cancellable touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data PollableInputStreamCreateSourceMethodInfo
instance (signature ~ (Maybe (b) -> m GLib.Source.Source), MonadIO m, IsPollableInputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod PollableInputStreamCreateSourceMethodInfo a signature where
    overloadedMethod = pollableInputStreamCreateSource

instance O.OverloadedMethodInfo PollableInputStreamCreateSourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PollableInputStream.pollableInputStreamCreateSource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-PollableInputStream.html#v:pollableInputStreamCreateSource"
        })


#endif

-- method PollableInputStream::is_readable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "PollableInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GPollableInputStream."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_pollable_input_stream_is_readable" g_pollable_input_stream_is_readable :: 
    Ptr PollableInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "PollableInputStream"})
    IO CInt

-- | Checks if /@stream@/ can be read.
-- 
-- Note that some stream types may not be able to implement this 100%
-- reliably, and it is possible that a call to 'GI.Gio.Objects.InputStream.inputStreamRead'
-- after this returns 'P.True' would still block. To guarantee
-- non-blocking behavior, you should always use
-- 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamReadNonblocking', which will return a
-- 'GI.Gio.Enums.IOErrorEnumWouldBlock' error rather than blocking.
-- 
-- The behaviour of this method is undefined if
-- 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamCanPoll' returns 'P.False' for /@stream@/.
-- 
-- /Since: 2.28/
pollableInputStreamIsReadable ::
    (B.CallStack.HasCallStack, MonadIO m, IsPollableInputStream a) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@stream@/ is readable, 'P.False' if not. If an error
    --   has occurred on /@stream@/, this will result in
    --   'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamIsReadable' returning 'P.True', and the
    --   next attempt to read will return the error.
pollableInputStreamIsReadable stream = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result <- g_pollable_input_stream_is_readable stream'
    let result' = (/= 0) result
    touchManagedPtr stream
    return result'

#if defined(ENABLE_OVERLOADING)
data PollableInputStreamIsReadableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPollableInputStream a) => O.OverloadedMethod PollableInputStreamIsReadableMethodInfo a signature where
    overloadedMethod = pollableInputStreamIsReadable

instance O.OverloadedMethodInfo PollableInputStreamIsReadableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PollableInputStream.pollableInputStreamIsReadable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-PollableInputStream.html#v:pollableInputStreamIsReadable"
        })


#endif

-- method PollableInputStream::read_nonblocking
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "PollableInputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GPollableInputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a\n    buffer to read data into (which should be at least @count bytes long)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes you want to read"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of bytes you want to read"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TSSize)
-- throws : True
-- Skip return : False

foreign import ccall "g_pollable_input_stream_read_nonblocking" g_pollable_input_stream_read_nonblocking :: 
    Ptr PollableInputStream ->              -- stream : TInterface (Name {namespace = "Gio", name = "PollableInputStream"})
    Ptr Word8 ->                            -- buffer : TCArray False (-1) 2 (TBasicType TUInt8)
    FCT.CSize ->                            -- count : TBasicType TSize
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO DI.Int64

-- | Attempts to read up to /@count@/ bytes from /@stream@/ into /@buffer@/, as
-- with 'GI.Gio.Objects.InputStream.inputStreamRead'. If /@stream@/ is not currently readable,
-- this will immediately return 'GI.Gio.Enums.IOErrorEnumWouldBlock', and you can
-- use 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamCreateSource' to create a t'GI.GLib.Structs.Source.Source'
-- that will be triggered when /@stream@/ is readable.
-- 
-- Note that since this method never blocks, you cannot actually
-- use /@cancellable@/ to cancel it. However, it will return an error
-- if /@cancellable@/ has already been cancelled when you call, which
-- may happen if you call this method after a source triggers due
-- to having been cancelled.
-- 
-- The behaviour of this method is undefined if
-- 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamCanPoll' returns 'P.False' for /@stream@/.
pollableInputStreamReadNonblocking ::
    (B.CallStack.HasCallStack, MonadIO m, IsPollableInputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream'
    -> Maybe (ByteString)
    -- ^ /@buffer@/: a
    --     buffer to read data into (which should be at least /@count@/ bytes long).
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m ((DI.Int64, Maybe ByteString))
    -- ^ __Returns:__ the number of bytes read, or -1 on error (including
    --   'GI.Gio.Enums.IOErrorEnumWouldBlock'). /(Can throw 'Data.GI.Base.GError.GError')/
pollableInputStreamReadNonblocking stream buffer cancellable = liftIO $ do
    let count = case buffer of
            Nothing -> 0
            Just jBuffer -> fromIntegral $ B.length jBuffer
    stream' <- unsafeManagedPtrCastPtr stream
    maybeBuffer <- case buffer of
        Nothing -> return FP.nullPtr
        Just jBuffer -> do
            jBuffer' <- packByteString jBuffer
            return jBuffer'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_pollable_input_stream_read_nonblocking stream' maybeBuffer count maybeCancellable
        maybeMaybeBuffer <- convertIfNonNull maybeBuffer $ \maybeBuffer' -> do
            maybeBuffer'' <- (unpackByteStringWithLength count) maybeBuffer'
            freeMem maybeBuffer'
            return maybeBuffer''
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return (result, maybeMaybeBuffer)
     ) (do
        freeMem maybeBuffer
     )

#if defined(ENABLE_OVERLOADING)
data PollableInputStreamReadNonblockingMethodInfo
instance (signature ~ (Maybe (ByteString) -> Maybe (b) -> m ((DI.Int64, Maybe ByteString))), MonadIO m, IsPollableInputStream a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod PollableInputStreamReadNonblockingMethodInfo a signature where
    overloadedMethod = pollableInputStreamReadNonblocking

instance O.OverloadedMethodInfo PollableInputStreamReadNonblockingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PollableInputStream.pollableInputStreamReadNonblocking",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-PollableInputStream.html#v:pollableInputStreamReadNonblocking"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PollableInputStream = PollableInputStreamSignalList
type PollableInputStreamSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


