{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @GMount@ interface represents a user-visible mount, such as a mounted
-- file system.
-- 
-- @GMount@ is a ‘mounted’ filesystem that you can access. Mounted is in
-- quotes because it’s not the same as a UNIX mount, it might be a GVFS
-- mount, but you can still access the files on it if you use GIO.
-- 
-- A @GMount@ might be associated with a t'GI.Gio.Interfaces.Volume.Volume' (such as a USB flash
-- drive) which hosts it.
-- 
-- Unmounting a @GMount@ instance is an asynchronous operation. For
-- more information about asynchronous operations, see t'GI.Gio.Interfaces.AsyncResult.AsyncResult'
-- and t'GI.Gio.Objects.Task.Task'. To unmount a @GMount@ instance, first call
-- 'GI.Gio.Interfaces.Mount.mountUnmountWithOperation' with (at least) the @GMount@
-- instance and a [type/@gio@/.AsyncReadyCallback].  The callback will be fired
-- when the operation has resolved (either with success or failure), and a
-- t'GI.Gio.Interfaces.AsyncResult.AsyncResult' structure will be passed to the callback.  That
-- callback should then call 'GI.Gio.Interfaces.Mount.mountUnmountWithOperationFinish'
-- with the @GMount@ and the t'GI.Gio.Interfaces.AsyncResult.AsyncResult' data to see if the
-- operation was completed successfully.  If an @error@ is present when
-- 'GI.Gio.Interfaces.Mount.mountUnmountWithOperationFinish' is called, then it will be
-- filled with any error information.
-- 
-- Note, when <http://developer.gnome.org/gio/stable/migrating-gnome-vfs.html porting from GnomeVFS>, @GMount@ is the
-- moral equivalent of @GnomeVFSVolume@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.Mount
    ( 

-- * Exported types
    Mount(..)                               ,
    IsMount                                 ,
    toMount                                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canEject]("GI.Gio.Interfaces.Mount#g:method:canEject"), [canUnmount]("GI.Gio.Interfaces.Mount#g:method:canUnmount"), [eject]("GI.Gio.Interfaces.Mount#g:method:eject"), [ejectFinish]("GI.Gio.Interfaces.Mount#g:method:ejectFinish"), [ejectWithOperation]("GI.Gio.Interfaces.Mount#g:method:ejectWithOperation"), [ejectWithOperationFinish]("GI.Gio.Interfaces.Mount#g:method:ejectWithOperationFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [guessContentType]("GI.Gio.Interfaces.Mount#g:method:guessContentType"), [guessContentTypeFinish]("GI.Gio.Interfaces.Mount#g:method:guessContentTypeFinish"), [guessContentTypeSync]("GI.Gio.Interfaces.Mount#g:method:guessContentTypeSync"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isShadowed]("GI.Gio.Interfaces.Mount#g:method:isShadowed"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remount]("GI.Gio.Interfaces.Mount#g:method:remount"), [remountFinish]("GI.Gio.Interfaces.Mount#g:method:remountFinish"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shadow]("GI.Gio.Interfaces.Mount#g:method:shadow"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unmount]("GI.Gio.Interfaces.Mount#g:method:unmount"), [unmountFinish]("GI.Gio.Interfaces.Mount#g:method:unmountFinish"), [unmountWithOperation]("GI.Gio.Interfaces.Mount#g:method:unmountWithOperation"), [unmountWithOperationFinish]("GI.Gio.Interfaces.Mount#g:method:unmountWithOperationFinish"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unshadow]("GI.Gio.Interfaces.Mount#g:method:unshadow"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultLocation]("GI.Gio.Interfaces.Mount#g:method:getDefaultLocation"), [getDrive]("GI.Gio.Interfaces.Mount#g:method:getDrive"), [getIcon]("GI.Gio.Interfaces.Mount#g:method:getIcon"), [getName]("GI.Gio.Interfaces.Mount#g:method:getName"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRoot]("GI.Gio.Interfaces.Mount#g:method:getRoot"), [getSortKey]("GI.Gio.Interfaces.Mount#g:method:getSortKey"), [getSymbolicIcon]("GI.Gio.Interfaces.Mount#g:method:getSymbolicIcon"), [getUuid]("GI.Gio.Interfaces.Mount#g:method:getUuid"), [getVolume]("GI.Gio.Interfaces.Mount#g:method:getVolume").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveMountMethod                      ,
#endif

-- ** canEject #method:canEject#

#if defined(ENABLE_OVERLOADING)
    MountCanEjectMethodInfo                 ,
#endif
    mountCanEject                           ,


-- ** canUnmount #method:canUnmount#

#if defined(ENABLE_OVERLOADING)
    MountCanUnmountMethodInfo               ,
#endif
    mountCanUnmount                         ,


-- ** eject #method:eject#

#if defined(ENABLE_OVERLOADING)
    MountEjectMethodInfo                    ,
#endif
    mountEject                              ,


-- ** ejectFinish #method:ejectFinish#

#if defined(ENABLE_OVERLOADING)
    MountEjectFinishMethodInfo              ,
#endif
    mountEjectFinish                        ,


-- ** ejectWithOperation #method:ejectWithOperation#

#if defined(ENABLE_OVERLOADING)
    MountEjectWithOperationMethodInfo       ,
#endif
    mountEjectWithOperation                 ,


-- ** ejectWithOperationFinish #method:ejectWithOperationFinish#

#if defined(ENABLE_OVERLOADING)
    MountEjectWithOperationFinishMethodInfo ,
#endif
    mountEjectWithOperationFinish           ,


-- ** getDefaultLocation #method:getDefaultLocation#

#if defined(ENABLE_OVERLOADING)
    MountGetDefaultLocationMethodInfo       ,
#endif
    mountGetDefaultLocation                 ,


-- ** getDrive #method:getDrive#

#if defined(ENABLE_OVERLOADING)
    MountGetDriveMethodInfo                 ,
#endif
    mountGetDrive                           ,


-- ** getIcon #method:getIcon#

#if defined(ENABLE_OVERLOADING)
    MountGetIconMethodInfo                  ,
#endif
    mountGetIcon                            ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    MountGetNameMethodInfo                  ,
#endif
    mountGetName                            ,


-- ** getRoot #method:getRoot#

#if defined(ENABLE_OVERLOADING)
    MountGetRootMethodInfo                  ,
#endif
    mountGetRoot                            ,


-- ** getSortKey #method:getSortKey#

#if defined(ENABLE_OVERLOADING)
    MountGetSortKeyMethodInfo               ,
#endif
    mountGetSortKey                         ,


-- ** getSymbolicIcon #method:getSymbolicIcon#

#if defined(ENABLE_OVERLOADING)
    MountGetSymbolicIconMethodInfo          ,
#endif
    mountGetSymbolicIcon                    ,


-- ** getUuid #method:getUuid#

#if defined(ENABLE_OVERLOADING)
    MountGetUuidMethodInfo                  ,
#endif
    mountGetUuid                            ,


-- ** getVolume #method:getVolume#

#if defined(ENABLE_OVERLOADING)
    MountGetVolumeMethodInfo                ,
#endif
    mountGetVolume                          ,


-- ** guessContentType #method:guessContentType#

#if defined(ENABLE_OVERLOADING)
    MountGuessContentTypeMethodInfo         ,
#endif
    mountGuessContentType                   ,


-- ** guessContentTypeFinish #method:guessContentTypeFinish#

#if defined(ENABLE_OVERLOADING)
    MountGuessContentTypeFinishMethodInfo   ,
#endif
    mountGuessContentTypeFinish             ,


-- ** guessContentTypeSync #method:guessContentTypeSync#

#if defined(ENABLE_OVERLOADING)
    MountGuessContentTypeSyncMethodInfo     ,
#endif
    mountGuessContentTypeSync               ,


-- ** isShadowed #method:isShadowed#

#if defined(ENABLE_OVERLOADING)
    MountIsShadowedMethodInfo               ,
#endif
    mountIsShadowed                         ,


-- ** remount #method:remount#

#if defined(ENABLE_OVERLOADING)
    MountRemountMethodInfo                  ,
#endif
    mountRemount                            ,


-- ** remountFinish #method:remountFinish#

#if defined(ENABLE_OVERLOADING)
    MountRemountFinishMethodInfo            ,
#endif
    mountRemountFinish                      ,


-- ** shadow #method:shadow#

#if defined(ENABLE_OVERLOADING)
    MountShadowMethodInfo                   ,
#endif
    mountShadow                             ,


-- ** unmount #method:unmount#

#if defined(ENABLE_OVERLOADING)
    MountUnmountMethodInfo                  ,
#endif
    mountUnmount                            ,


-- ** unmountFinish #method:unmountFinish#

#if defined(ENABLE_OVERLOADING)
    MountUnmountFinishMethodInfo            ,
#endif
    mountUnmountFinish                      ,


-- ** unmountWithOperation #method:unmountWithOperation#

#if defined(ENABLE_OVERLOADING)
    MountUnmountWithOperationMethodInfo     ,
#endif
    mountUnmountWithOperation               ,


-- ** unmountWithOperationFinish #method:unmountWithOperationFinish#

#if defined(ENABLE_OVERLOADING)
    MountUnmountWithOperationFinishMethodInfo,
#endif
    mountUnmountWithOperationFinish         ,


-- ** unshadow #method:unshadow#

#if defined(ENABLE_OVERLOADING)
    MountUnshadowMethodInfo                 ,
#endif
    mountUnshadow                           ,




 -- * Signals


-- ** changed #signal:changed#

    MountChangedCallback                    ,
#if defined(ENABLE_OVERLOADING)
    MountChangedSignalInfo                  ,
#endif
    afterMountChanged                       ,
    onMountChanged                          ,


-- ** preUnmount #signal:preUnmount#

    MountPreUnmountCallback                 ,
#if defined(ENABLE_OVERLOADING)
    MountPreUnmountSignalInfo               ,
#endif
    afterMountPreUnmount                    ,
    onMountPreUnmount                       ,


-- ** unmounted #signal:unmounted#

    MountUnmountedCallback                  ,
#if defined(ENABLE_OVERLOADING)
    MountUnmountedSignalInfo                ,
#endif
    afterMountUnmounted                     ,
    onMountUnmounted                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileEnumerator as Gio.FileEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileMonitor as Gio.FileMonitor
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation

#endif

-- interface Mount 
-- | Memory-managed wrapper type.
newtype Mount = Mount (SP.ManagedPtr Mount)
    deriving (Eq)

instance SP.ManagedPtrNewtype Mount where
    toManagedPtr (Mount p) = p

foreign import ccall "g_mount_get_type"
    c_g_mount_get_type :: IO B.Types.GType

instance B.Types.TypedObject Mount where
    glibType = c_g_mount_get_type

instance B.Types.GObject Mount

-- | Type class for types which can be safely cast to `Mount`, for instance with `toMount`.
class (SP.GObject o, O.IsDescendantOf Mount o) => IsMount o
instance (SP.GObject o, O.IsDescendantOf Mount o) => IsMount o

instance O.HasParentTypes Mount
type instance O.ParentTypes Mount = '[GObject.Object.Object]

-- | Cast to `Mount`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toMount :: (MIO.MonadIO m, IsMount o) => o -> m Mount
toMount = MIO.liftIO . B.ManagedPtr.unsafeCastTo Mount

-- | Convert 'Mount' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Mount) where
    gvalueGType_ = c_g_mount_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Mount)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Mount)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Mount ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Mount
type instance O.AttributeList Mount = MountAttributeList
type MountAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveMountMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveMountMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveMountMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveMountMethod "canEject" o = MountCanEjectMethodInfo
    ResolveMountMethod "canUnmount" o = MountCanUnmountMethodInfo
    ResolveMountMethod "eject" o = MountEjectMethodInfo
    ResolveMountMethod "ejectFinish" o = MountEjectFinishMethodInfo
    ResolveMountMethod "ejectWithOperation" o = MountEjectWithOperationMethodInfo
    ResolveMountMethod "ejectWithOperationFinish" o = MountEjectWithOperationFinishMethodInfo
    ResolveMountMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveMountMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveMountMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveMountMethod "guessContentType" o = MountGuessContentTypeMethodInfo
    ResolveMountMethod "guessContentTypeFinish" o = MountGuessContentTypeFinishMethodInfo
    ResolveMountMethod "guessContentTypeSync" o = MountGuessContentTypeSyncMethodInfo
    ResolveMountMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveMountMethod "isShadowed" o = MountIsShadowedMethodInfo
    ResolveMountMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveMountMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveMountMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveMountMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveMountMethod "remount" o = MountRemountMethodInfo
    ResolveMountMethod "remountFinish" o = MountRemountFinishMethodInfo
    ResolveMountMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveMountMethod "shadow" o = MountShadowMethodInfo
    ResolveMountMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveMountMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveMountMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveMountMethod "unmount" o = MountUnmountMethodInfo
    ResolveMountMethod "unmountFinish" o = MountUnmountFinishMethodInfo
    ResolveMountMethod "unmountWithOperation" o = MountUnmountWithOperationMethodInfo
    ResolveMountMethod "unmountWithOperationFinish" o = MountUnmountWithOperationFinishMethodInfo
    ResolveMountMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveMountMethod "unshadow" o = MountUnshadowMethodInfo
    ResolveMountMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveMountMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveMountMethod "getDefaultLocation" o = MountGetDefaultLocationMethodInfo
    ResolveMountMethod "getDrive" o = MountGetDriveMethodInfo
    ResolveMountMethod "getIcon" o = MountGetIconMethodInfo
    ResolveMountMethod "getName" o = MountGetNameMethodInfo
    ResolveMountMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveMountMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveMountMethod "getRoot" o = MountGetRootMethodInfo
    ResolveMountMethod "getSortKey" o = MountGetSortKeyMethodInfo
    ResolveMountMethod "getSymbolicIcon" o = MountGetSymbolicIconMethodInfo
    ResolveMountMethod "getUuid" o = MountGetUuidMethodInfo
    ResolveMountMethod "getVolume" o = MountGetVolumeMethodInfo
    ResolveMountMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveMountMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveMountMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveMountMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveMountMethod t Mount, O.OverloadedMethod info Mount p) => OL.IsLabel t (Mount -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveMountMethod t Mount, O.OverloadedMethod info Mount p, R.HasField t Mount p) => R.HasField t Mount p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveMountMethod t Mount, O.OverloadedMethodInfo info Mount) => OL.IsLabel t (O.MethodProxy info Mount) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method Mount::can_eject
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_can_eject" g_mount_can_eject :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO CInt

-- | Checks if /@mount@/ can be ejected.
mountCanEject ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the /@mount@/ can be ejected.
mountCanEject mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_can_eject mount'
    let result' = (/= 0) result
    touchManagedPtr mount
    return result'

#if defined(ENABLE_OVERLOADING)
data MountCanEjectMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMount a) => O.OverloadedMethod MountCanEjectMethodInfo a signature where
    overloadedMethod = mountCanEject

instance O.OverloadedMethodInfo MountCanEjectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountCanEject",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountCanEject"
        })


#endif

-- method Mount::can_unmount
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_can_unmount" g_mount_can_unmount :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO CInt

-- | Checks if /@mount@/ can be unmounted.
mountCanUnmount ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the /@mount@/ can be unmounted.
mountCanUnmount mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_can_unmount mount'
    let result' = (/= 0) result
    touchManagedPtr mount
    return result'

#if defined(ENABLE_OVERLOADING)
data MountCanUnmountMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMount a) => O.OverloadedMethod MountCanUnmountMethodInfo a signature where
    overloadedMethod = mountCanUnmount

instance O.OverloadedMethodInfo MountCanUnmountMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountCanUnmount",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountCanUnmount"
        })


#endif

-- method Mount::eject
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MountUnmountFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "flags affecting the unmount if required for eject"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_eject" g_mount_eject :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "MountUnmountFlags"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

{-# DEPRECATED mountEject ["(Since version 2.22)","Use 'GI.Gio.Interfaces.Mount.mountEjectWithOperation' instead."] #-}
-- | Ejects a mount. This is an asynchronous operation, and is
-- finished by calling 'GI.Gio.Interfaces.Mount.mountEjectFinish' with the /@mount@/
-- and t'GI.Gio.Interfaces.AsyncResult.AsyncResult' data returned in the /@callback@/.
mountEject ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> [Gio.Flags.MountUnmountFlags]
    -- ^ /@flags@/: flags affecting the unmount if required for eject
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback', or 'P.Nothing'.
    -> m ()
mountEject mount flags cancellable callback = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    let flags' = gflagsToWord flags
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_mount_eject mount' flags' maybeCancellable maybeCallback userData
    touchManagedPtr mount
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MountEjectMethodInfo
instance (signature ~ ([Gio.Flags.MountUnmountFlags] -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsMount a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod MountEjectMethodInfo a signature where
    overloadedMethod = mountEject

instance O.OverloadedMethodInfo MountEjectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountEject",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountEject"
        })


#endif

-- method Mount::eject_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_mount_eject_finish" g_mount_eject_finish :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

{-# DEPRECATED mountEjectFinish ["(Since version 2.22)","Use 'GI.Gio.Interfaces.Mount.mountEjectWithOperationFinish' instead."] #-}
-- | Finishes ejecting a mount. If any errors occurred during the operation,
-- /@error@/ will be set to contain the errors and 'P.False' will be returned.
mountEjectFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
mountEjectFinish mount result_ = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ g_mount_eject_finish mount' result_'
        touchManagedPtr mount
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data MountEjectFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod MountEjectFinishMethodInfo a signature where
    overloadedMethod = mountEjectFinish

instance O.OverloadedMethodInfo MountEjectFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountEjectFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountEjectFinish"
        })


#endif

-- method Mount::eject_with_operation
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MountUnmountFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "flags affecting the unmount if required for eject"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mount_operation"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MountOperation" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GMountOperation or %NULL to avoid\n    user interaction."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_eject_with_operation" g_mount_eject_with_operation :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "MountUnmountFlags"})
    Ptr Gio.MountOperation.MountOperation -> -- mount_operation : TInterface (Name {namespace = "Gio", name = "MountOperation"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Ejects a mount. This is an asynchronous operation, and is
-- finished by calling 'GI.Gio.Interfaces.Mount.mountEjectWithOperationFinish' with the /@mount@/
-- and t'GI.Gio.Interfaces.AsyncResult.AsyncResult' data returned in the /@callback@/.
-- 
-- /Since: 2.22/
mountEjectWithOperation ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.MountOperation.IsMountOperation b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> [Gio.Flags.MountUnmountFlags]
    -- ^ /@flags@/: flags affecting the unmount if required for eject
    -> Maybe (b)
    -- ^ /@mountOperation@/: a t'GI.Gio.Objects.MountOperation.MountOperation' or 'P.Nothing' to avoid
    --     user interaction.
    -> Maybe (c)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback', or 'P.Nothing'.
    -> m ()
mountEjectWithOperation mount flags mountOperation cancellable callback = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    let flags' = gflagsToWord flags
    maybeMountOperation <- case mountOperation of
        Nothing -> return FP.nullPtr
        Just jMountOperation -> do
            jMountOperation' <- unsafeManagedPtrCastPtr jMountOperation
            return jMountOperation'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_mount_eject_with_operation mount' flags' maybeMountOperation maybeCancellable maybeCallback userData
    touchManagedPtr mount
    whenJust mountOperation touchManagedPtr
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MountEjectWithOperationMethodInfo
instance (signature ~ ([Gio.Flags.MountUnmountFlags] -> Maybe (b) -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsMount a, Gio.MountOperation.IsMountOperation b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod MountEjectWithOperationMethodInfo a signature where
    overloadedMethod = mountEjectWithOperation

instance O.OverloadedMethodInfo MountEjectWithOperationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountEjectWithOperation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountEjectWithOperation"
        })


#endif

-- method Mount::eject_with_operation_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_mount_eject_with_operation_finish" g_mount_eject_with_operation_finish :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes ejecting a mount. If any errors occurred during the operation,
-- /@error@/ will be set to contain the errors and 'P.False' will be returned.
-- 
-- /Since: 2.22/
mountEjectWithOperationFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
mountEjectWithOperationFinish mount result_ = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ g_mount_eject_with_operation_finish mount' result_'
        touchManagedPtr mount
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data MountEjectWithOperationFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod MountEjectWithOperationFinishMethodInfo a signature where
    overloadedMethod = mountEjectWithOperationFinish

instance O.OverloadedMethodInfo MountEjectWithOperationFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountEjectWithOperationFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountEjectWithOperationFinish"
        })


#endif

-- method Mount::get_default_location
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_get_default_location" g_mount_get_default_location :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO (Ptr Gio.File.File)

-- | Gets the default location of /@mount@/. The default location of the given
-- /@mount@/ is a path that reflects the main entry point for the user (e.g.
-- the home directory, or the root of the volume).
mountGetDefaultLocation ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> m Gio.File.File
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.File.File'.
    --      The returned object should be unreffed with
    --      'GI.GObject.Objects.Object.objectUnref' when no longer needed.
mountGetDefaultLocation mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_get_default_location mount'
    checkUnexpectedReturnNULL "mountGetDefaultLocation" result
    result' <- (wrapObject Gio.File.File) result
    touchManagedPtr mount
    return result'

#if defined(ENABLE_OVERLOADING)
data MountGetDefaultLocationMethodInfo
instance (signature ~ (m Gio.File.File), MonadIO m, IsMount a) => O.OverloadedMethod MountGetDefaultLocationMethodInfo a signature where
    overloadedMethod = mountGetDefaultLocation

instance O.OverloadedMethodInfo MountGetDefaultLocationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGetDefaultLocation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGetDefaultLocation"
        })


#endif

-- method Mount::get_drive
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Drive" })
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_get_drive" g_mount_get_drive :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO (Ptr Gio.Drive.Drive)

-- | Gets the drive for the /@mount@/.
-- 
-- This is a convenience method for getting the t'GI.Gio.Interfaces.Volume.Volume' and then
-- using that object to get the t'GI.Gio.Interfaces.Drive.Drive'.
mountGetDrive ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> m (Maybe Gio.Drive.Drive)
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Drive.Drive' or 'P.Nothing' if /@mount@/ is not
    --      associated with a volume or a drive.
    --      The returned object should be unreffed with
    --      'GI.GObject.Objects.Object.objectUnref' when no longer needed.
mountGetDrive mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_get_drive mount'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.Drive.Drive) result'
        return result''
    touchManagedPtr mount
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MountGetDriveMethodInfo
instance (signature ~ (m (Maybe Gio.Drive.Drive)), MonadIO m, IsMount a) => O.OverloadedMethod MountGetDriveMethodInfo a signature where
    overloadedMethod = mountGetDrive

instance O.OverloadedMethodInfo MountGetDriveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGetDrive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGetDrive"
        })


#endif

-- method Mount::get_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_get_icon" g_mount_get_icon :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO (Ptr Gio.Icon.Icon)

-- | Gets the icon for /@mount@/.
mountGetIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> m Gio.Icon.Icon
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Icon.Icon'.
    --      The returned object should be unreffed with
    --      'GI.GObject.Objects.Object.objectUnref' when no longer needed.
mountGetIcon mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_get_icon mount'
    checkUnexpectedReturnNULL "mountGetIcon" result
    result' <- (wrapObject Gio.Icon.Icon) result
    touchManagedPtr mount
    return result'

#if defined(ENABLE_OVERLOADING)
data MountGetIconMethodInfo
instance (signature ~ (m Gio.Icon.Icon), MonadIO m, IsMount a) => O.OverloadedMethod MountGetIconMethodInfo a signature where
    overloadedMethod = mountGetIcon

instance O.OverloadedMethodInfo MountGetIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGetIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGetIcon"
        })


#endif

-- method Mount::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_get_name" g_mount_get_name :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO CString

-- | Gets the name of /@mount@/.
mountGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> m T.Text
    -- ^ __Returns:__ the name for the given /@mount@/.
    --     The returned string should be freed with 'GI.GLib.Functions.free'
    --     when no longer needed.
mountGetName mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_get_name mount'
    checkUnexpectedReturnNULL "mountGetName" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr mount
    return result'

#if defined(ENABLE_OVERLOADING)
data MountGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsMount a) => O.OverloadedMethod MountGetNameMethodInfo a signature where
    overloadedMethod = mountGetName

instance O.OverloadedMethodInfo MountGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGetName"
        })


#endif

-- method Mount::get_root
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_get_root" g_mount_get_root :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO (Ptr Gio.File.File)

-- | Gets the root directory on /@mount@/.
mountGetRoot ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> m Gio.File.File
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.File.File'.
    --      The returned object should be unreffed with
    --      'GI.GObject.Objects.Object.objectUnref' when no longer needed.
mountGetRoot mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_get_root mount'
    checkUnexpectedReturnNULL "mountGetRoot" result
    result' <- (wrapObject Gio.File.File) result
    touchManagedPtr mount
    return result'

#if defined(ENABLE_OVERLOADING)
data MountGetRootMethodInfo
instance (signature ~ (m Gio.File.File), MonadIO m, IsMount a) => O.OverloadedMethod MountGetRootMethodInfo a signature where
    overloadedMethod = mountGetRoot

instance O.OverloadedMethodInfo MountGetRootMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGetRoot",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGetRoot"
        })


#endif

-- method Mount::get_sort_key
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_get_sort_key" g_mount_get_sort_key :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO CString

-- | Gets the sort key for /@mount@/, if any.
-- 
-- /Since: 2.32/
mountGetSortKey ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: A t'GI.Gio.Interfaces.Mount.Mount'.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ Sorting key for /@mount@/ or 'P.Nothing' if no such key is available.
mountGetSortKey mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_get_sort_key mount'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr mount
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MountGetSortKeyMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsMount a) => O.OverloadedMethod MountGetSortKeyMethodInfo a signature where
    overloadedMethod = mountGetSortKey

instance O.OverloadedMethodInfo MountGetSortKeyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGetSortKey",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGetSortKey"
        })


#endif

-- method Mount::get_symbolic_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_get_symbolic_icon" g_mount_get_symbolic_icon :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO (Ptr Gio.Icon.Icon)

-- | Gets the symbolic icon for /@mount@/.
-- 
-- /Since: 2.34/
mountGetSymbolicIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> m Gio.Icon.Icon
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Icon.Icon'.
    --      The returned object should be unreffed with
    --      'GI.GObject.Objects.Object.objectUnref' when no longer needed.
mountGetSymbolicIcon mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_get_symbolic_icon mount'
    checkUnexpectedReturnNULL "mountGetSymbolicIcon" result
    result' <- (wrapObject Gio.Icon.Icon) result
    touchManagedPtr mount
    return result'

#if defined(ENABLE_OVERLOADING)
data MountGetSymbolicIconMethodInfo
instance (signature ~ (m Gio.Icon.Icon), MonadIO m, IsMount a) => O.OverloadedMethod MountGetSymbolicIconMethodInfo a signature where
    overloadedMethod = mountGetSymbolicIcon

instance O.OverloadedMethodInfo MountGetSymbolicIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGetSymbolicIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGetSymbolicIcon"
        })


#endif

-- method Mount::get_uuid
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_get_uuid" g_mount_get_uuid :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO CString

-- | Gets the UUID for the /@mount@/. The reference is typically based on
-- the file system UUID for the mount in question and should be
-- considered an opaque string. Returns 'P.Nothing' if there is no UUID
-- available.
mountGetUuid ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the UUID for /@mount@/ or 'P.Nothing' if no UUID
    --     can be computed.
    --     The returned string should be freed with 'GI.GLib.Functions.free'
    --     when no longer needed.
mountGetUuid mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_get_uuid mount'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr mount
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MountGetUuidMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsMount a) => O.OverloadedMethod MountGetUuidMethodInfo a signature where
    overloadedMethod = mountGetUuid

instance O.OverloadedMethodInfo MountGetUuidMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGetUuid",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGetUuid"
        })


#endif

-- method Mount::get_volume
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Volume" })
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_get_volume" g_mount_get_volume :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO (Ptr Gio.Volume.Volume)

-- | Gets the volume for the /@mount@/.
mountGetVolume ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> m (Maybe Gio.Volume.Volume)
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Volume.Volume' or 'P.Nothing' if /@mount@/ is not
    --      associated with a volume.
    --      The returned object should be unreffed with
    --      'GI.GObject.Objects.Object.objectUnref' when no longer needed.
mountGetVolume mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_get_volume mount'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.Volume.Volume) result'
        return result''
    touchManagedPtr mount
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data MountGetVolumeMethodInfo
instance (signature ~ (m (Maybe Gio.Volume.Volume)), MonadIO m, IsMount a) => O.OverloadedMethod MountGetVolumeMethodInfo a signature where
    overloadedMethod = mountGetVolume

instance O.OverloadedMethodInfo MountGetVolumeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGetVolume",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGetVolume"
        })


#endif

-- method Mount::guess_content_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "force_rescan"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Whether to force a rescan of the content.\n    Otherwise a cached result will be used if available"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_guess_content_type" g_mount_guess_content_type :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    CInt ->                                 -- force_rescan : TBasicType TBoolean
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Tries to guess the type of content stored on /@mount@/. Returns one or
-- more textual identifiers of well-known content types (typically
-- prefixed with \"x-content\/\"), e.g. x-content\/image-dcf for camera
-- memory cards. See the
-- <http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec shared-mime-info>
-- specification for more on x-content types.
-- 
-- This is an asynchronous operation (see
-- 'GI.Gio.Interfaces.Mount.mountGuessContentTypeSync' for the synchronous version), and
-- is finished by calling 'GI.Gio.Interfaces.Mount.mountGuessContentTypeFinish' with the
-- /@mount@/ and t'GI.Gio.Interfaces.AsyncResult.AsyncResult' data returned in the /@callback@/.
-- 
-- /Since: 2.18/
mountGuessContentType ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'
    -> Bool
    -- ^ /@forceRescan@/: Whether to force a rescan of the content.
    --     Otherwise a cached result will be used if available
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    -> m ()
mountGuessContentType mount forceRescan cancellable callback = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    let forceRescan' = (P.fromIntegral . P.fromEnum) forceRescan
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_mount_guess_content_type mount' forceRescan' maybeCancellable maybeCallback userData
    touchManagedPtr mount
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MountGuessContentTypeMethodInfo
instance (signature ~ (Bool -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsMount a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod MountGuessContentTypeMethodInfo a signature where
    overloadedMethod = mountGuessContentType

instance O.OverloadedMethodInfo MountGuessContentTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGuessContentType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGuessContentType"
        })


#endif

-- method Mount::guess_content_type_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : True
-- Skip return : False

foreign import ccall "g_mount_guess_content_type_finish" g_mount_guess_content_type_finish :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr CString)

-- | Finishes guessing content types of /@mount@/. If any errors occurred
-- during the operation, /@error@/ will be set to contain the errors and
-- 'P.False' will be returned. In particular, you may get an
-- 'GI.Gio.Enums.IOErrorEnumNotSupported' if the mount does not support content
-- guessing.
-- 
-- /Since: 2.18/
mountGuessContentTypeFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'
    -> m [T.Text]
    -- ^ __Returns:__ a 'P.Nothing'-terminated array of content types or 'P.Nothing' on error.
    --     Caller should free this array with 'GI.GLib.Functions.strfreev' when done with it. /(Can throw 'Data.GI.Base.GError.GError')/
mountGuessContentTypeFinish mount result_ = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_mount_guess_content_type_finish mount' result_'
        checkUnexpectedReturnNULL "mountGuessContentTypeFinish" result
        result' <- unpackZeroTerminatedUTF8CArray result
        mapZeroTerminatedCArray freeMem result
        freeMem result
        touchManagedPtr mount
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data MountGuessContentTypeFinishMethodInfo
instance (signature ~ (b -> m [T.Text]), MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod MountGuessContentTypeFinishMethodInfo a signature where
    overloadedMethod = mountGuessContentTypeFinish

instance O.OverloadedMethodInfo MountGuessContentTypeFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGuessContentTypeFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGuessContentTypeFinish"
        })


#endif

-- method Mount::guess_content_type_sync
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "force_rescan"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Whether to force a rescan of the content.\n    Otherwise a cached result will be used if available"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : True
-- Skip return : False

foreign import ccall "g_mount_guess_content_type_sync" g_mount_guess_content_type_sync :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    CInt ->                                 -- force_rescan : TBasicType TBoolean
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr CString)

-- | Tries to guess the type of content stored on /@mount@/. Returns one or
-- more textual identifiers of well-known content types (typically
-- prefixed with \"x-content\/\"), e.g. x-content\/image-dcf for camera
-- memory cards. See the
-- <http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec shared-mime-info>
-- specification for more on x-content types.
-- 
-- This is a synchronous operation and as such may block doing IO;
-- see 'GI.Gio.Interfaces.Mount.mountGuessContentType' for the asynchronous version.
-- 
-- /Since: 2.18/
mountGuessContentTypeSync ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'
    -> Bool
    -- ^ /@forceRescan@/: Whether to force a rescan of the content.
    --     Otherwise a cached result will be used if available
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore
    -> m [T.Text]
    -- ^ __Returns:__ a 'P.Nothing'-terminated array of content types or 'P.Nothing' on error.
    --     Caller should free this array with 'GI.GLib.Functions.strfreev' when done with it. /(Can throw 'Data.GI.Base.GError.GError')/
mountGuessContentTypeSync mount forceRescan cancellable = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    let forceRescan' = (P.fromIntegral . P.fromEnum) forceRescan
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_mount_guess_content_type_sync mount' forceRescan' maybeCancellable
        checkUnexpectedReturnNULL "mountGuessContentTypeSync" result
        result' <- unpackZeroTerminatedUTF8CArray result
        mapZeroTerminatedCArray freeMem result
        freeMem result
        touchManagedPtr mount
        whenJust cancellable touchManagedPtr
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data MountGuessContentTypeSyncMethodInfo
instance (signature ~ (Bool -> Maybe (b) -> m [T.Text]), MonadIO m, IsMount a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod MountGuessContentTypeSyncMethodInfo a signature where
    overloadedMethod = mountGuessContentTypeSync

instance O.OverloadedMethodInfo MountGuessContentTypeSyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountGuessContentTypeSync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountGuessContentTypeSync"
        })


#endif

-- method Mount::is_shadowed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_is_shadowed" g_mount_is_shadowed :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO CInt

-- | Determines if /@mount@/ is shadowed. Applications or libraries should
-- avoid displaying /@mount@/ in the user interface if it is shadowed.
-- 
-- A mount is said to be shadowed if there exists one or more user
-- visible objects (currently t'GI.Gio.Interfaces.Mount.Mount' objects) with a root that is
-- inside the root of /@mount@/.
-- 
-- One application of shadow mounts is when exposing a single file
-- system that is used to address several logical volumes. In this
-- situation, a t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor' implementation would create two
-- t'GI.Gio.Interfaces.Volume.Volume' objects (for example, one for the camera functionality of
-- the device and one for a SD card reader on the device) with
-- activation URIs @gphoto2:\/\/[usb:001,002]\/store1\/@
-- and @gphoto2:\/\/[usb:001,002]\/store2\/@. When the
-- underlying mount (with root
-- @gphoto2:\/\/[usb:001,002]\/@) is mounted, said
-- t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor' implementation would create two t'GI.Gio.Interfaces.Mount.Mount' objects
-- (each with their root matching the corresponding volume activation
-- root) that would shadow the original mount.
-- 
-- The proxy monitor in GVfs 2.26 and later, automatically creates and
-- manage shadow mounts (and shadows the underlying mount) if the
-- activation root on a t'GI.Gio.Interfaces.Volume.Volume' is set.
-- 
-- /Since: 2.20/
mountIsShadowed ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: A t'GI.Gio.Interfaces.Mount.Mount'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@mount@/ is shadowed.
mountIsShadowed mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result <- g_mount_is_shadowed mount'
    let result' = (/= 0) result
    touchManagedPtr mount
    return result'

#if defined(ENABLE_OVERLOADING)
data MountIsShadowedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsMount a) => O.OverloadedMethod MountIsShadowedMethodInfo a signature where
    overloadedMethod = mountIsShadowed

instance O.OverloadedMethodInfo MountIsShadowedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountIsShadowed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountIsShadowed"
        })


#endif

-- method Mount::remount
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MountMountFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags affecting the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mount_operation"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MountOperation" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GMountOperation or %NULL to avoid\n    user interaction."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_remount" g_mount_remount :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "MountMountFlags"})
    Ptr Gio.MountOperation.MountOperation -> -- mount_operation : TInterface (Name {namespace = "Gio", name = "MountOperation"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Remounts a mount. This is an asynchronous operation, and is
-- finished by calling 'GI.Gio.Interfaces.Mount.mountRemountFinish' with the /@mount@/
-- and @/GAsyncResults/@ data returned in the /@callback@/.
-- 
-- Remounting is useful when some setting affecting the operation
-- of the volume has been changed, as these may need a remount to
-- take affect. While this is semantically equivalent with unmounting
-- and then remounting not all backends might need to actually be
-- unmounted.
mountRemount ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.MountOperation.IsMountOperation b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> [Gio.Flags.MountMountFlags]
    -- ^ /@flags@/: flags affecting the operation
    -> Maybe (b)
    -- ^ /@mountOperation@/: a t'GI.Gio.Objects.MountOperation.MountOperation' or 'P.Nothing' to avoid
    --     user interaction.
    -> Maybe (c)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback', or 'P.Nothing'.
    -> m ()
mountRemount mount flags mountOperation cancellable callback = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    let flags' = gflagsToWord flags
    maybeMountOperation <- case mountOperation of
        Nothing -> return FP.nullPtr
        Just jMountOperation -> do
            jMountOperation' <- unsafeManagedPtrCastPtr jMountOperation
            return jMountOperation'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_mount_remount mount' flags' maybeMountOperation maybeCancellable maybeCallback userData
    touchManagedPtr mount
    whenJust mountOperation touchManagedPtr
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MountRemountMethodInfo
instance (signature ~ ([Gio.Flags.MountMountFlags] -> Maybe (b) -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsMount a, Gio.MountOperation.IsMountOperation b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod MountRemountMethodInfo a signature where
    overloadedMethod = mountRemount

instance O.OverloadedMethodInfo MountRemountMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountRemount",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountRemount"
        })


#endif

-- method Mount::remount_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_mount_remount_finish" g_mount_remount_finish :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes remounting a mount. If any errors occurred during the operation,
-- /@error@/ will be set to contain the errors and 'P.False' will be returned.
mountRemountFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
mountRemountFinish mount result_ = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ g_mount_remount_finish mount' result_'
        touchManagedPtr mount
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data MountRemountFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod MountRemountFinishMethodInfo a signature where
    overloadedMethod = mountRemountFinish

instance O.OverloadedMethodInfo MountRemountFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountRemountFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountRemountFinish"
        })


#endif

-- method Mount::shadow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_shadow" g_mount_shadow :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO ()

-- | Increments the shadow count on /@mount@/. Usually used by
-- t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor' implementations when creating a shadow mount for
-- /@mount@/, see 'GI.Gio.Interfaces.Mount.mountIsShadowed' for more information. The caller
-- will need to emit the [Mount::changed]("GI.Gio.Interfaces.Mount#g:signal:changed") signal on /@mount@/ manually.
-- 
-- /Since: 2.20/
mountShadow ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: A t'GI.Gio.Interfaces.Mount.Mount'.
    -> m ()
mountShadow mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    g_mount_shadow mount'
    touchManagedPtr mount
    return ()

#if defined(ENABLE_OVERLOADING)
data MountShadowMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMount a) => O.OverloadedMethod MountShadowMethodInfo a signature where
    overloadedMethod = mountShadow

instance O.OverloadedMethodInfo MountShadowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountShadow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountShadow"
        })


#endif

-- method Mount::unmount
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MountUnmountFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags affecting the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_unmount" g_mount_unmount :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "MountUnmountFlags"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

{-# DEPRECATED mountUnmount ["(Since version 2.22)","Use 'GI.Gio.Interfaces.Mount.mountUnmountWithOperation' instead."] #-}
-- | Unmounts a mount. This is an asynchronous operation, and is
-- finished by calling 'GI.Gio.Interfaces.Mount.mountUnmountFinish' with the /@mount@/
-- and t'GI.Gio.Interfaces.AsyncResult.AsyncResult' data returned in the /@callback@/.
mountUnmount ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> [Gio.Flags.MountUnmountFlags]
    -- ^ /@flags@/: flags affecting the operation
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback', or 'P.Nothing'.
    -> m ()
mountUnmount mount flags cancellable callback = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    let flags' = gflagsToWord flags
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_mount_unmount mount' flags' maybeCancellable maybeCallback userData
    touchManagedPtr mount
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MountUnmountMethodInfo
instance (signature ~ ([Gio.Flags.MountUnmountFlags] -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsMount a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod MountUnmountMethodInfo a signature where
    overloadedMethod = mountUnmount

instance O.OverloadedMethodInfo MountUnmountMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountUnmount",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountUnmount"
        })


#endif

-- method Mount::unmount_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_mount_unmount_finish" g_mount_unmount_finish :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

{-# DEPRECATED mountUnmountFinish ["(Since version 2.22)","Use 'GI.Gio.Interfaces.Mount.mountUnmountWithOperationFinish' instead."] #-}
-- | Finishes unmounting a mount. If any errors occurred during the operation,
-- /@error@/ will be set to contain the errors and 'P.False' will be returned.
mountUnmountFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
mountUnmountFinish mount result_ = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ g_mount_unmount_finish mount' result_'
        touchManagedPtr mount
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data MountUnmountFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod MountUnmountFinishMethodInfo a signature where
    overloadedMethod = mountUnmountFinish

instance O.OverloadedMethodInfo MountUnmountFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountUnmountFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountUnmountFinish"
        })


#endif

-- method Mount::unmount_with_operation
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MountUnmountFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags affecting the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mount_operation"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MountOperation" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GMountOperation or %NULL to avoid\n    user interaction."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_unmount_with_operation" g_mount_unmount_with_operation :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "MountUnmountFlags"})
    Ptr Gio.MountOperation.MountOperation -> -- mount_operation : TInterface (Name {namespace = "Gio", name = "MountOperation"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Unmounts a mount. This is an asynchronous operation, and is
-- finished by calling 'GI.Gio.Interfaces.Mount.mountUnmountWithOperationFinish' with the /@mount@/
-- and t'GI.Gio.Interfaces.AsyncResult.AsyncResult' data returned in the /@callback@/.
-- 
-- /Since: 2.22/
mountUnmountWithOperation ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.MountOperation.IsMountOperation b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> [Gio.Flags.MountUnmountFlags]
    -- ^ /@flags@/: flags affecting the operation
    -> Maybe (b)
    -- ^ /@mountOperation@/: a t'GI.Gio.Objects.MountOperation.MountOperation' or 'P.Nothing' to avoid
    --     user interaction.
    -> Maybe (c)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback', or 'P.Nothing'.
    -> m ()
mountUnmountWithOperation mount flags mountOperation cancellable callback = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    let flags' = gflagsToWord flags
    maybeMountOperation <- case mountOperation of
        Nothing -> return FP.nullPtr
        Just jMountOperation -> do
            jMountOperation' <- unsafeManagedPtrCastPtr jMountOperation
            return jMountOperation'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_mount_unmount_with_operation mount' flags' maybeMountOperation maybeCancellable maybeCallback userData
    touchManagedPtr mount
    whenJust mountOperation touchManagedPtr
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data MountUnmountWithOperationMethodInfo
instance (signature ~ ([Gio.Flags.MountUnmountFlags] -> Maybe (b) -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsMount a, Gio.MountOperation.IsMountOperation b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod MountUnmountWithOperationMethodInfo a signature where
    overloadedMethod = mountUnmountWithOperation

instance O.OverloadedMethodInfo MountUnmountWithOperationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountUnmountWithOperation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountUnmountWithOperation"
        })


#endif

-- method Mount::unmount_with_operation_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_mount_unmount_with_operation_finish" g_mount_unmount_with_operation_finish :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes unmounting a mount. If any errors occurred during the operation,
-- /@error@/ will be set to contain the errors and 'P.False' will be returned.
-- 
-- /Since: 2.22/
mountUnmountWithOperationFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@mount@/: a t'GI.Gio.Interfaces.Mount.Mount'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
mountUnmountWithOperationFinish mount result_ = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ g_mount_unmount_with_operation_finish mount' result_'
        touchManagedPtr mount
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data MountUnmountWithOperationFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsMount a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod MountUnmountWithOperationFinishMethodInfo a signature where
    overloadedMethod = mountUnmountWithOperationFinish

instance O.OverloadedMethodInfo MountUnmountWithOperationFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountUnmountWithOperationFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountUnmountWithOperationFinish"
        })


#endif

-- method Mount::unshadow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "mount"
--           , argType = TInterface Name { namespace = "Gio" , name = "Mount" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GMount." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_mount_unshadow" g_mount_unshadow :: 
    Ptr Mount ->                            -- mount : TInterface (Name {namespace = "Gio", name = "Mount"})
    IO ()

-- | Decrements the shadow count on /@mount@/. Usually used by
-- t'GI.Gio.Objects.VolumeMonitor.VolumeMonitor' implementations when destroying a shadow mount for
-- /@mount@/, see 'GI.Gio.Interfaces.Mount.mountIsShadowed' for more information. The caller
-- will need to emit the [Mount::changed]("GI.Gio.Interfaces.Mount#g:signal:changed") signal on /@mount@/ manually.
-- 
-- /Since: 2.20/
mountUnshadow ::
    (B.CallStack.HasCallStack, MonadIO m, IsMount a) =>
    a
    -- ^ /@mount@/: A t'GI.Gio.Interfaces.Mount.Mount'.
    -> m ()
mountUnshadow mount = liftIO $ do
    mount' <- unsafeManagedPtrCastPtr mount
    g_mount_unshadow mount'
    touchManagedPtr mount
    return ()

#if defined(ENABLE_OVERLOADING)
data MountUnshadowMethodInfo
instance (signature ~ (m ()), MonadIO m, IsMount a) => O.OverloadedMethod MountUnshadowMethodInfo a signature where
    overloadedMethod = mountUnshadow

instance O.OverloadedMethodInfo MountUnshadowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount.mountUnshadow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#v:mountUnshadow"
        })


#endif

-- signal Mount::changed
-- | Emitted when the mount has been changed.
type MountChangedCallback =
    IO ()

type C_MountChangedCallback =
    Ptr Mount ->                            -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MountChangedCallback`.
foreign import ccall "wrapper"
    mk_MountChangedCallback :: C_MountChangedCallback -> IO (FunPtr C_MountChangedCallback)

wrap_MountChangedCallback :: 
    GObject a => (a -> MountChangedCallback) ->
    C_MountChangedCallback
wrap_MountChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' mount #changed callback
-- @
-- 
-- 
onMountChanged :: (IsMount a, MonadIO m) => a -> ((?self :: a) => MountChangedCallback) -> m SignalHandlerId
onMountChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MountChangedCallback wrapped
    wrapped'' <- mk_MountChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' mount #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMountChanged :: (IsMount a, MonadIO m) => a -> ((?self :: a) => MountChangedCallback) -> m SignalHandlerId
afterMountChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MountChangedCallback wrapped
    wrapped'' <- mk_MountChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MountChangedSignalInfo
instance SignalInfo MountChangedSignalInfo where
    type HaskellCallbackType MountChangedSignalInfo = MountChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MountChangedCallback cb
        cb'' <- mk_MountChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#g:signal:changed"})

#endif

-- signal Mount::pre-unmount
-- | This signal may be emitted when the t'GI.Gio.Interfaces.Mount.Mount' is about to be
-- unmounted.
-- 
-- This signal depends on the backend and is only emitted if
-- GIO was used to unmount.
-- 
-- /Since: 2.22/
type MountPreUnmountCallback =
    IO ()

type C_MountPreUnmountCallback =
    Ptr Mount ->                            -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MountPreUnmountCallback`.
foreign import ccall "wrapper"
    mk_MountPreUnmountCallback :: C_MountPreUnmountCallback -> IO (FunPtr C_MountPreUnmountCallback)

wrap_MountPreUnmountCallback :: 
    GObject a => (a -> MountPreUnmountCallback) ->
    C_MountPreUnmountCallback
wrap_MountPreUnmountCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [preUnmount](#signal:preUnmount) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' mount #preUnmount callback
-- @
-- 
-- 
onMountPreUnmount :: (IsMount a, MonadIO m) => a -> ((?self :: a) => MountPreUnmountCallback) -> m SignalHandlerId
onMountPreUnmount obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MountPreUnmountCallback wrapped
    wrapped'' <- mk_MountPreUnmountCallback wrapped'
    connectSignalFunPtr obj "pre-unmount" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [preUnmount](#signal:preUnmount) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' mount #preUnmount callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMountPreUnmount :: (IsMount a, MonadIO m) => a -> ((?self :: a) => MountPreUnmountCallback) -> m SignalHandlerId
afterMountPreUnmount obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MountPreUnmountCallback wrapped
    wrapped'' <- mk_MountPreUnmountCallback wrapped'
    connectSignalFunPtr obj "pre-unmount" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MountPreUnmountSignalInfo
instance SignalInfo MountPreUnmountSignalInfo where
    type HaskellCallbackType MountPreUnmountSignalInfo = MountPreUnmountCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MountPreUnmountCallback cb
        cb'' <- mk_MountPreUnmountCallback cb'
        connectSignalFunPtr obj "pre-unmount" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount::pre-unmount"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#g:signal:preUnmount"})

#endif

-- signal Mount::unmounted
-- | This signal is emitted when the t'GI.Gio.Interfaces.Mount.Mount' have been
-- unmounted. If the recipient is holding references to the
-- object they should release them so the object can be
-- finalized.
type MountUnmountedCallback =
    IO ()

type C_MountUnmountedCallback =
    Ptr Mount ->                            -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_MountUnmountedCallback`.
foreign import ccall "wrapper"
    mk_MountUnmountedCallback :: C_MountUnmountedCallback -> IO (FunPtr C_MountUnmountedCallback)

wrap_MountUnmountedCallback :: 
    GObject a => (a -> MountUnmountedCallback) ->
    C_MountUnmountedCallback
wrap_MountUnmountedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [unmounted](#signal:unmounted) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' mount #unmounted callback
-- @
-- 
-- 
onMountUnmounted :: (IsMount a, MonadIO m) => a -> ((?self :: a) => MountUnmountedCallback) -> m SignalHandlerId
onMountUnmounted obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MountUnmountedCallback wrapped
    wrapped'' <- mk_MountUnmountedCallback wrapped'
    connectSignalFunPtr obj "unmounted" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [unmounted](#signal:unmounted) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' mount #unmounted callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterMountUnmounted :: (IsMount a, MonadIO m) => a -> ((?self :: a) => MountUnmountedCallback) -> m SignalHandlerId
afterMountUnmounted obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_MountUnmountedCallback wrapped
    wrapped'' <- mk_MountUnmountedCallback wrapped'
    connectSignalFunPtr obj "unmounted" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data MountUnmountedSignalInfo
instance SignalInfo MountUnmountedSignalInfo where
    type HaskellCallbackType MountUnmountedSignalInfo = MountUnmountedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_MountUnmountedCallback cb
        cb'' <- mk_MountUnmountedCallback cb'
        connectSignalFunPtr obj "unmounted" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Mount::unmounted"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-Mount.html#g:signal:unmounted"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Mount = MountSignalList
type MountSignalList = ('[ '("changed", MountChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("preUnmount", MountPreUnmountSignalInfo), '("unmounted", MountUnmountedSignalInfo)] :: [(Symbol, DK.Type)])

#endif


