{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GLoadableIcon@ extends the t'GI.Gio.Interfaces.Icon.Icon' interface and adds the ability
-- to load icons from streams.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.LoadableIcon
    ( 

-- * Exported types
    LoadableIcon(..)                        ,
    IsLoadableIcon                          ,
    toLoadableIcon                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [equal]("GI.Gio.Interfaces.Icon#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gio.Interfaces.Icon#g:method:hash"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [load]("GI.Gio.Interfaces.LoadableIcon#g:method:load"), [loadAsync]("GI.Gio.Interfaces.LoadableIcon#g:method:loadAsync"), [loadFinish]("GI.Gio.Interfaces.LoadableIcon#g:method:loadFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [serialize]("GI.Gio.Interfaces.Icon#g:method:serialize"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Interfaces.Icon#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveLoadableIconMethod               ,
#endif

-- ** load #method:load#

#if defined(ENABLE_OVERLOADING)
    LoadableIconLoadMethodInfo              ,
#endif
    loadableIconLoad                        ,


-- ** loadAsync #method:loadAsync#

#if defined(ENABLE_OVERLOADING)
    LoadableIconLoadAsyncMethodInfo         ,
#endif
    loadableIconLoadAsync                   ,


-- ** loadFinish #method:loadFinish#

#if defined(ENABLE_OVERLOADING)
    LoadableIconLoadFinishMethodInfo        ,
#endif
    loadableIconLoadFinish                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream

#endif

-- interface LoadableIcon 
-- | Memory-managed wrapper type.
newtype LoadableIcon = LoadableIcon (SP.ManagedPtr LoadableIcon)
    deriving (Eq)

instance SP.ManagedPtrNewtype LoadableIcon where
    toManagedPtr (LoadableIcon p) = p

foreign import ccall "g_loadable_icon_get_type"
    c_g_loadable_icon_get_type :: IO B.Types.GType

instance B.Types.TypedObject LoadableIcon where
    glibType = c_g_loadable_icon_get_type

instance B.Types.GObject LoadableIcon

-- | Type class for types which can be safely cast to `LoadableIcon`, for instance with `toLoadableIcon`.
class (SP.GObject o, O.IsDescendantOf LoadableIcon o) => IsLoadableIcon o
instance (SP.GObject o, O.IsDescendantOf LoadableIcon o) => IsLoadableIcon o

instance O.HasParentTypes LoadableIcon
type instance O.ParentTypes LoadableIcon = '[Gio.Icon.Icon, GObject.Object.Object]

-- | Cast to `LoadableIcon`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toLoadableIcon :: (MIO.MonadIO m, IsLoadableIcon o) => o -> m LoadableIcon
toLoadableIcon = MIO.liftIO . B.ManagedPtr.unsafeCastTo LoadableIcon

-- | Convert 'LoadableIcon' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe LoadableIcon) where
    gvalueGType_ = c_g_loadable_icon_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr LoadableIcon)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr LoadableIcon)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject LoadableIcon ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList LoadableIcon
type instance O.AttributeList LoadableIcon = LoadableIconAttributeList
type LoadableIconAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveLoadableIconMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveLoadableIconMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveLoadableIconMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveLoadableIconMethod "equal" o = Gio.Icon.IconEqualMethodInfo
    ResolveLoadableIconMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveLoadableIconMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveLoadableIconMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveLoadableIconMethod "hash" o = Gio.Icon.IconHashMethodInfo
    ResolveLoadableIconMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveLoadableIconMethod "load" o = LoadableIconLoadMethodInfo
    ResolveLoadableIconMethod "loadAsync" o = LoadableIconLoadAsyncMethodInfo
    ResolveLoadableIconMethod "loadFinish" o = LoadableIconLoadFinishMethodInfo
    ResolveLoadableIconMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveLoadableIconMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveLoadableIconMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveLoadableIconMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveLoadableIconMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveLoadableIconMethod "serialize" o = Gio.Icon.IconSerializeMethodInfo
    ResolveLoadableIconMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveLoadableIconMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveLoadableIconMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveLoadableIconMethod "toString" o = Gio.Icon.IconToStringMethodInfo
    ResolveLoadableIconMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveLoadableIconMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveLoadableIconMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveLoadableIconMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveLoadableIconMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveLoadableIconMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveLoadableIconMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveLoadableIconMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveLoadableIconMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveLoadableIconMethod t LoadableIcon, O.OverloadedMethod info LoadableIcon p) => OL.IsLabel t (LoadableIcon -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveLoadableIconMethod t LoadableIcon, O.OverloadedMethod info LoadableIcon p, R.HasField t LoadableIcon p) => R.HasField t LoadableIcon p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveLoadableIconMethod t LoadableIcon, O.OverloadedMethodInfo info LoadableIcon) => OL.IsLabel t (O.MethodProxy info LoadableIcon) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method LoadableIcon::load
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "LoadableIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GLoadableIcon." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an integer." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a location to store the type of the loaded\nicon, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to\nignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InputStream" })
-- throws : True
-- Skip return : False

foreign import ccall "g_loadable_icon_load" g_loadable_icon_load :: 
    Ptr LoadableIcon ->                     -- icon : TInterface (Name {namespace = "Gio", name = "LoadableIcon"})
    Int32 ->                                -- size : TBasicType TInt
    Ptr CString ->                          -- type : TBasicType TUTF8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.InputStream.InputStream)

-- | Loads a loadable icon. For the asynchronous version of this function,
-- see 'GI.Gio.Interfaces.LoadableIcon.loadableIconLoadAsync'.
loadableIconLoad ::
    (B.CallStack.HasCallStack, MonadIO m, IsLoadableIcon a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@icon@/: a t'GI.Gio.Interfaces.LoadableIcon.LoadableIcon'.
    -> Int32
    -- ^ /@size@/: an integer.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to
    -- ignore.
    -> m ((Gio.InputStream.InputStream, T.Text))
    -- ^ __Returns:__ a t'GI.Gio.Objects.InputStream.InputStream' to read the icon from. /(Can throw 'Data.GI.Base.GError.GError')/
loadableIconLoad icon size cancellable = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    type_ <- callocMem :: IO (Ptr CString)
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_loadable_icon_load icon' size type_ maybeCancellable
        checkUnexpectedReturnNULL "loadableIconLoad" result
        result' <- (wrapObject Gio.InputStream.InputStream) result
        type_' <- peek type_
        type_'' <- cstringToText type_'
        freeMem type_'
        touchManagedPtr icon
        whenJust cancellable touchManagedPtr
        freeMem type_
        return (result', type_'')
     ) (do
        freeMem type_
     )

#if defined(ENABLE_OVERLOADING)
data LoadableIconLoadMethodInfo
instance (signature ~ (Int32 -> Maybe (b) -> m ((Gio.InputStream.InputStream, T.Text))), MonadIO m, IsLoadableIcon a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod LoadableIconLoadMethodInfo a signature where
    overloadedMethod = loadableIconLoad

instance O.OverloadedMethodInfo LoadableIconLoadMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.LoadableIcon.loadableIconLoad",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-LoadableIcon.html#v:loadableIconLoad"
        })


#endif

-- method LoadableIcon::load_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "LoadableIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GLoadableIcon." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an integer." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncReadyCallback\n  to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_loadable_icon_load_async" g_loadable_icon_load_async :: 
    Ptr LoadableIcon ->                     -- icon : TInterface (Name {namespace = "Gio", name = "LoadableIcon"})
    Int32 ->                                -- size : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Loads an icon asynchronously. To finish this function, see
-- 'GI.Gio.Interfaces.LoadableIcon.loadableIconLoadFinish'. For the synchronous, blocking
-- version of this function, see 'GI.Gio.Interfaces.LoadableIcon.loadableIconLoad'.
loadableIconLoadAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsLoadableIcon a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@icon@/: a t'GI.Gio.Interfaces.LoadableIcon.LoadableIcon'.
    -> Int32
    -- ^ /@size@/: an integer.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> m ()
loadableIconLoadAsync icon size cancellable callback = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_loadable_icon_load_async icon' size maybeCancellable maybeCallback userData
    touchManagedPtr icon
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data LoadableIconLoadAsyncMethodInfo
instance (signature ~ (Int32 -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsLoadableIcon a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod LoadableIconLoadAsyncMethodInfo a signature where
    overloadedMethod = loadableIconLoadAsync

instance O.OverloadedMethodInfo LoadableIconLoadAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.LoadableIcon.loadableIconLoadAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-LoadableIcon.html#v:loadableIconLoadAsync"
        })


#endif

-- method LoadableIcon::load_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "LoadableIcon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GLoadableIcon." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a location to store the type of the loaded\n       icon, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InputStream" })
-- throws : True
-- Skip return : False

foreign import ccall "g_loadable_icon_load_finish" g_loadable_icon_load_finish :: 
    Ptr LoadableIcon ->                     -- icon : TInterface (Name {namespace = "Gio", name = "LoadableIcon"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- res : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr CString ->                          -- type : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.InputStream.InputStream)

-- | Finishes an asynchronous icon load started in 'GI.Gio.Interfaces.LoadableIcon.loadableIconLoadAsync'.
loadableIconLoadFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsLoadableIcon a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@icon@/: a t'GI.Gio.Interfaces.LoadableIcon.LoadableIcon'.
    -> b
    -- ^ /@res@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ((Gio.InputStream.InputStream, T.Text))
    -- ^ __Returns:__ a t'GI.Gio.Objects.InputStream.InputStream' to read the icon from. /(Can throw 'Data.GI.Base.GError.GError')/
loadableIconLoadFinish icon res = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    res' <- unsafeManagedPtrCastPtr res
    type_ <- callocMem :: IO (Ptr CString)
    onException (do
        result <- propagateGError $ g_loadable_icon_load_finish icon' res' type_
        checkUnexpectedReturnNULL "loadableIconLoadFinish" result
        result' <- (wrapObject Gio.InputStream.InputStream) result
        type_' <- peek type_
        type_'' <- cstringToText type_'
        freeMem type_'
        touchManagedPtr icon
        touchManagedPtr res
        freeMem type_
        return (result', type_'')
     ) (do
        freeMem type_
     )

#if defined(ENABLE_OVERLOADING)
data LoadableIconLoadFinishMethodInfo
instance (signature ~ (b -> m ((Gio.InputStream.InputStream, T.Text))), MonadIO m, IsLoadableIcon a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod LoadableIconLoadFinishMethodInfo a signature where
    overloadedMethod = loadableIconLoadFinish

instance O.OverloadedMethodInfo LoadableIconLoadFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.LoadableIcon.loadableIconLoadFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-LoadableIcon.html#v:loadableIconLoadFinish"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList LoadableIcon = LoadableIconSignalList
type LoadableIconSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


