{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GFileDescriptorBased@ is an interface for file descriptor based IO.
-- 
-- It is implemented by streams (implementations of t'GI.Gio.Objects.InputStream.InputStream' or
-- t'GI.Gio.Objects.OutputStream.OutputStream') that are based on file descriptors.
-- 
-- Note that @\<gio\/gfiledescriptorbased.h>@ belongs to the UNIX-specific
-- GIO interfaces, thus you have to use the @gio-unix-2.0.pc@ pkg-config
-- file or the @GioUnix-2.0@ GIR namespace when using it.
-- 
-- /Since: 2.24/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.FileDescriptorBased
    ( 

-- * Exported types
    FileDescriptorBased(..)                 ,
    IsFileDescriptorBased                   ,
    toFileDescriptorBased                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFd]("GI.Gio.Interfaces.FileDescriptorBased#g:method:getFd"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFileDescriptorBasedMethod        ,
#endif

-- ** getFd #method:getFd#

#if defined(ENABLE_OVERLOADING)
    FileDescriptorBasedGetFdMethodInfo      ,
#endif
    fileDescriptorBasedGetFd                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface FileDescriptorBased 
-- | Memory-managed wrapper type.
newtype FileDescriptorBased = FileDescriptorBased (SP.ManagedPtr FileDescriptorBased)
    deriving (Eq)

instance SP.ManagedPtrNewtype FileDescriptorBased where
    toManagedPtr (FileDescriptorBased p) = p

foreign import ccall "g_file_descriptor_based_get_type"
    c_g_file_descriptor_based_get_type :: IO B.Types.GType

instance B.Types.TypedObject FileDescriptorBased where
    glibType = c_g_file_descriptor_based_get_type

instance B.Types.GObject FileDescriptorBased

-- | Type class for types which can be safely cast to `FileDescriptorBased`, for instance with `toFileDescriptorBased`.
class (SP.GObject o, O.IsDescendantOf FileDescriptorBased o) => IsFileDescriptorBased o
instance (SP.GObject o, O.IsDescendantOf FileDescriptorBased o) => IsFileDescriptorBased o

instance O.HasParentTypes FileDescriptorBased
type instance O.ParentTypes FileDescriptorBased = '[GObject.Object.Object]

-- | Cast to `FileDescriptorBased`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toFileDescriptorBased :: (MIO.MonadIO m, IsFileDescriptorBased o) => o -> m FileDescriptorBased
toFileDescriptorBased = MIO.liftIO . B.ManagedPtr.unsafeCastTo FileDescriptorBased

-- | Convert 'FileDescriptorBased' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FileDescriptorBased) where
    gvalueGType_ = c_g_file_descriptor_based_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr FileDescriptorBased)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr FileDescriptorBased)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject FileDescriptorBased ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FileDescriptorBased
type instance O.AttributeList FileDescriptorBased = FileDescriptorBasedAttributeList
type FileDescriptorBasedAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFileDescriptorBasedMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFileDescriptorBasedMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFileDescriptorBasedMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFileDescriptorBasedMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFileDescriptorBasedMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFileDescriptorBasedMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFileDescriptorBasedMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFileDescriptorBasedMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFileDescriptorBasedMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFileDescriptorBasedMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFileDescriptorBasedMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFileDescriptorBasedMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFileDescriptorBasedMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFileDescriptorBasedMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFileDescriptorBasedMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFileDescriptorBasedMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFileDescriptorBasedMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFileDescriptorBasedMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFileDescriptorBasedMethod "getFd" o = FileDescriptorBasedGetFdMethodInfo
    ResolveFileDescriptorBasedMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFileDescriptorBasedMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFileDescriptorBasedMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFileDescriptorBasedMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFileDescriptorBasedMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFileDescriptorBasedMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFileDescriptorBasedMethod t FileDescriptorBased, O.OverloadedMethod info FileDescriptorBased p) => OL.IsLabel t (FileDescriptorBased -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFileDescriptorBasedMethod t FileDescriptorBased, O.OverloadedMethod info FileDescriptorBased p, R.HasField t FileDescriptorBased p) => R.HasField t FileDescriptorBased p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFileDescriptorBasedMethod t FileDescriptorBased, O.OverloadedMethodInfo info FileDescriptorBased) => OL.IsLabel t (O.MethodProxy info FileDescriptorBased) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method FileDescriptorBased::get_fd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "fd_based"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "FileDescriptorBased" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileDescriptorBased."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_file_descriptor_based_get_fd" g_file_descriptor_based_get_fd :: 
    Ptr FileDescriptorBased ->              -- fd_based : TInterface (Name {namespace = "Gio", name = "FileDescriptorBased"})
    IO Int32

-- | Gets the underlying file descriptor.
-- 
-- /Since: 2.24/
fileDescriptorBasedGetFd ::
    (B.CallStack.HasCallStack, MonadIO m, IsFileDescriptorBased a) =>
    a
    -- ^ /@fdBased@/: a t'GI.Gio.Interfaces.FileDescriptorBased.FileDescriptorBased'.
    -> m Int32
    -- ^ __Returns:__ The file descriptor
fileDescriptorBasedGetFd fdBased = liftIO $ do
    fdBased' <- unsafeManagedPtrCastPtr fdBased
    result <- g_file_descriptor_based_get_fd fdBased'
    touchManagedPtr fdBased
    return result

#if defined(ENABLE_OVERLOADING)
data FileDescriptorBasedGetFdMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsFileDescriptorBased a) => O.OverloadedMethod FileDescriptorBasedGetFdMethodInfo a signature where
    overloadedMethod = fileDescriptorBasedGetFd

instance O.OverloadedMethodInfo FileDescriptorBasedGetFdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.FileDescriptorBased.fileDescriptorBasedGetFd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-FileDescriptorBased.html#v:fileDescriptorBasedGetFd"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList FileDescriptorBased = FileDescriptorBasedSignalList
type FileDescriptorBasedSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


