{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GDtlsClientConnection@ is the client-side subclass of
-- t'GI.Gio.Interfaces.DtlsConnection.DtlsConnection', representing a client-side DTLS connection.
-- 
-- /Since: 2.48/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.DtlsClientConnection
    ( 

-- * Exported types
    DtlsClientConnection(..)                ,
    IsDtlsClientConnection                  ,
    toDtlsClientConnection                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [close]("GI.Gio.Interfaces.DtlsConnection#g:method:close"), [closeAsync]("GI.Gio.Interfaces.DtlsConnection#g:method:closeAsync"), [closeFinish]("GI.Gio.Interfaces.DtlsConnection#g:method:closeFinish"), [conditionCheck]("GI.Gio.Interfaces.DatagramBased#g:method:conditionCheck"), [conditionWait]("GI.Gio.Interfaces.DatagramBased#g:method:conditionWait"), [createSource]("GI.Gio.Interfaces.DatagramBased#g:method:createSource"), [emitAcceptCertificate]("GI.Gio.Interfaces.DtlsConnection#g:method:emitAcceptCertificate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [handshake]("GI.Gio.Interfaces.DtlsConnection#g:method:handshake"), [handshakeAsync]("GI.Gio.Interfaces.DtlsConnection#g:method:handshakeAsync"), [handshakeFinish]("GI.Gio.Interfaces.DtlsConnection#g:method:handshakeFinish"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [receiveMessages]("GI.Gio.Interfaces.DatagramBased#g:method:receiveMessages"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [sendMessages]("GI.Gio.Interfaces.DatagramBased#g:method:sendMessages"), [shutdown]("GI.Gio.Interfaces.DtlsConnection#g:method:shutdown"), [shutdownAsync]("GI.Gio.Interfaces.DtlsConnection#g:method:shutdownAsync"), [shutdownFinish]("GI.Gio.Interfaces.DtlsConnection#g:method:shutdownFinish"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAcceptedCas]("GI.Gio.Interfaces.DtlsClientConnection#g:method:getAcceptedCas"), [getCertificate]("GI.Gio.Interfaces.DtlsConnection#g:method:getCertificate"), [getChannelBindingData]("GI.Gio.Interfaces.DtlsConnection#g:method:getChannelBindingData"), [getCiphersuiteName]("GI.Gio.Interfaces.DtlsConnection#g:method:getCiphersuiteName"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDatabase]("GI.Gio.Interfaces.DtlsConnection#g:method:getDatabase"), [getInteraction]("GI.Gio.Interfaces.DtlsConnection#g:method:getInteraction"), [getNegotiatedProtocol]("GI.Gio.Interfaces.DtlsConnection#g:method:getNegotiatedProtocol"), [getPeerCertificate]("GI.Gio.Interfaces.DtlsConnection#g:method:getPeerCertificate"), [getPeerCertificateErrors]("GI.Gio.Interfaces.DtlsConnection#g:method:getPeerCertificateErrors"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getProtocolVersion]("GI.Gio.Interfaces.DtlsConnection#g:method:getProtocolVersion"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRehandshakeMode]("GI.Gio.Interfaces.DtlsConnection#g:method:getRehandshakeMode"), [getRequireCloseNotify]("GI.Gio.Interfaces.DtlsConnection#g:method:getRequireCloseNotify"), [getServerIdentity]("GI.Gio.Interfaces.DtlsClientConnection#g:method:getServerIdentity"), [getValidationFlags]("GI.Gio.Interfaces.DtlsClientConnection#g:method:getValidationFlags").
-- 
-- ==== Setters
-- [setAdvertisedProtocols]("GI.Gio.Interfaces.DtlsConnection#g:method:setAdvertisedProtocols"), [setCertificate]("GI.Gio.Interfaces.DtlsConnection#g:method:setCertificate"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDatabase]("GI.Gio.Interfaces.DtlsConnection#g:method:setDatabase"), [setInteraction]("GI.Gio.Interfaces.DtlsConnection#g:method:setInteraction"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRehandshakeMode]("GI.Gio.Interfaces.DtlsConnection#g:method:setRehandshakeMode"), [setRequireCloseNotify]("GI.Gio.Interfaces.DtlsConnection#g:method:setRequireCloseNotify"), [setServerIdentity]("GI.Gio.Interfaces.DtlsClientConnection#g:method:setServerIdentity"), [setValidationFlags]("GI.Gio.Interfaces.DtlsClientConnection#g:method:setValidationFlags").

#if defined(ENABLE_OVERLOADING)
    ResolveDtlsClientConnectionMethod       ,
#endif

-- ** getAcceptedCas #method:getAcceptedCas#

#if defined(ENABLE_OVERLOADING)
    DtlsClientConnectionGetAcceptedCasMethodInfo,
#endif
    dtlsClientConnectionGetAcceptedCas      ,


-- ** getServerIdentity #method:getServerIdentity#

#if defined(ENABLE_OVERLOADING)
    DtlsClientConnectionGetServerIdentityMethodInfo,
#endif
    dtlsClientConnectionGetServerIdentity   ,


-- ** getValidationFlags #method:getValidationFlags#

#if defined(ENABLE_OVERLOADING)
    DtlsClientConnectionGetValidationFlagsMethodInfo,
#endif
    dtlsClientConnectionGetValidationFlags  ,


-- ** new #method:new#

    dtlsClientConnectionNew                 ,


-- ** setServerIdentity #method:setServerIdentity#

#if defined(ENABLE_OVERLOADING)
    DtlsClientConnectionSetServerIdentityMethodInfo,
#endif
    dtlsClientConnectionSetServerIdentity   ,


-- ** setValidationFlags #method:setValidationFlags#

#if defined(ENABLE_OVERLOADING)
    DtlsClientConnectionSetValidationFlagsMethodInfo,
#endif
    dtlsClientConnectionSetValidationFlags  ,




 -- * Properties


-- ** acceptedCas #attr:acceptedCas#
-- | A list of the distinguished names of the Certificate Authorities
-- that the server will accept client certificates signed by. If the
-- server requests a client certificate during the handshake, then
-- this property will be set after the handshake completes.
-- 
-- Each item in the list is a t'GI.GLib.Structs.ByteArray.ByteArray' which contains the complete
-- subject DN of the certificate authority.
-- 
-- /Since: 2.48/

#if defined(ENABLE_OVERLOADING)
    DtlsClientConnectionAcceptedCasPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    dtlsClientConnectionAcceptedCas         ,
#endif
    getDtlsClientConnectionAcceptedCas      ,


-- ** serverIdentity #attr:serverIdentity#
-- | A t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable' describing the identity of the server that
-- is expected on the other end of the connection.
-- 
-- If the 'GI.Gio.Flags.TlsCertificateFlagsBadIdentity' flag is set in
-- t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection':@/validation-flags/@, this object will be used
-- to determine the expected identify of the remote end of the
-- connection; if t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection':@/server-identity/@ is not set,
-- or does not match the identity presented by the server, then the
-- 'GI.Gio.Flags.TlsCertificateFlagsBadIdentity' validation will fail.
-- 
-- In addition to its use in verifying the server certificate,
-- this is also used to give a hint to the server about what
-- certificate we expect, which is useful for servers that serve
-- virtual hosts.
-- 
-- /Since: 2.48/

#if defined(ENABLE_OVERLOADING)
    DtlsClientConnectionServerIdentityPropertyInfo,
#endif
    constructDtlsClientConnectionServerIdentity,
#if defined(ENABLE_OVERLOADING)
    dtlsClientConnectionServerIdentity      ,
#endif
    getDtlsClientConnectionServerIdentity   ,
    setDtlsClientConnectionServerIdentity   ,


-- ** validationFlags #attr:validationFlags#
-- | What steps to perform when validating a certificate received from
-- a server. Server certificates that fail to validate in any of the
-- ways indicated here will be rejected unless the application
-- overrides the default via [DtlsConnection::acceptCertificate]("GI.Gio.Interfaces.DtlsConnection#g:signal:acceptCertificate").
-- 
-- GLib guarantees that if certificate verification fails, at least one
-- flag will be set, but it does not guarantee that all possible flags
-- will be set. Accordingly, you may not safely decide to ignore any
-- particular type of error. For example, it would be incorrect to mask
-- 'GI.Gio.Flags.TlsCertificateFlagsExpired' if you want to allow expired certificates,
-- because this could potentially be the only error flag set even if
-- other problems exist with the certificate. Therefore, there is no
-- safe way to use this property. This is not a horrible problem,
-- though, because you should not be attempting to ignore validation
-- errors anyway. If you really must ignore TLS certificate errors,
-- connect to [DtlsConnection::acceptCertificate]("GI.Gio.Interfaces.DtlsConnection#g:signal:acceptCertificate").
-- 
-- /Since: 2.48/

#if defined(ENABLE_OVERLOADING)
    DtlsClientConnectionValidationFlagsPropertyInfo,
#endif
    constructDtlsClientConnectionValidationFlags,
#if defined(ENABLE_OVERLOADING)
    dtlsClientConnectionValidationFlags     ,
#endif
    getDtlsClientConnectionValidationFlags  ,
    setDtlsClientConnectionValidationFlags  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Flags as GLib.Flags
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DtlsConnection as Gio.DtlsConnection
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsCertificate as Gio.TlsCertificate
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsConnection as Gio.TlsConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsDatabase as Gio.TlsDatabase
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsInteraction as Gio.TlsInteraction
import {-# SOURCE #-} qualified GI.Gio.Objects.TlsPassword as Gio.TlsPassword
import {-# SOURCE #-} qualified GI.Gio.Structs.InputMessage as Gio.InputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputMessage as Gio.OutputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DtlsConnection as Gio.DtlsConnection
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable

#endif

-- interface DtlsClientConnection 
-- | Memory-managed wrapper type.
newtype DtlsClientConnection = DtlsClientConnection (SP.ManagedPtr DtlsClientConnection)
    deriving (Eq)

instance SP.ManagedPtrNewtype DtlsClientConnection where
    toManagedPtr (DtlsClientConnection p) = p

foreign import ccall "g_dtls_client_connection_get_type"
    c_g_dtls_client_connection_get_type :: IO B.Types.GType

instance B.Types.TypedObject DtlsClientConnection where
    glibType = c_g_dtls_client_connection_get_type

instance B.Types.GObject DtlsClientConnection

-- | Type class for types which can be safely cast to `DtlsClientConnection`, for instance with `toDtlsClientConnection`.
class (SP.GObject o, O.IsDescendantOf DtlsClientConnection o) => IsDtlsClientConnection o
instance (SP.GObject o, O.IsDescendantOf DtlsClientConnection o) => IsDtlsClientConnection o

instance O.HasParentTypes DtlsClientConnection
type instance O.ParentTypes DtlsClientConnection = '[Gio.DatagramBased.DatagramBased, Gio.DtlsConnection.DtlsConnection, GObject.Object.Object]

-- | Cast to `DtlsClientConnection`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDtlsClientConnection :: (MIO.MonadIO m, IsDtlsClientConnection o) => o -> m DtlsClientConnection
toDtlsClientConnection = MIO.liftIO . B.ManagedPtr.unsafeCastTo DtlsClientConnection

-- | Convert 'DtlsClientConnection' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DtlsClientConnection) where
    gvalueGType_ = c_g_dtls_client_connection_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DtlsClientConnection)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DtlsClientConnection)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DtlsClientConnection ptr
        else return P.Nothing
        
    

-- VVV Prop "accepted-cas"
   -- Type: TGList (TBasicType TPtr)
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accepted-cas@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dtlsClientConnection #acceptedCas
-- @
getDtlsClientConnectionAcceptedCas :: (MonadIO m, IsDtlsClientConnection o) => o -> m ([Ptr ()])
getDtlsClientConnectionAcceptedCas obj = MIO.liftIO $ B.Properties.getObjectPropertyPtrGList obj "accepted-cas"

#if defined(ENABLE_OVERLOADING)
data DtlsClientConnectionAcceptedCasPropertyInfo
instance AttrInfo DtlsClientConnectionAcceptedCasPropertyInfo where
    type AttrAllowedOps DtlsClientConnectionAcceptedCasPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DtlsClientConnectionAcceptedCasPropertyInfo = IsDtlsClientConnection
    type AttrSetTypeConstraint DtlsClientConnectionAcceptedCasPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DtlsClientConnectionAcceptedCasPropertyInfo = (~) ()
    type AttrTransferType DtlsClientConnectionAcceptedCasPropertyInfo = ()
    type AttrGetType DtlsClientConnectionAcceptedCasPropertyInfo = ([Ptr ()])
    type AttrLabel DtlsClientConnectionAcceptedCasPropertyInfo = "accepted-cas"
    type AttrOrigin DtlsClientConnectionAcceptedCasPropertyInfo = DtlsClientConnection
    attrGet = getDtlsClientConnectionAcceptedCas
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DtlsClientConnection.acceptedCas"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-DtlsClientConnection.html#g:attr:acceptedCas"
        })
#endif

-- VVV Prop "server-identity"
   -- Type: TInterface (Name {namespace = "Gio", name = "SocketConnectable"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@server-identity@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dtlsClientConnection #serverIdentity
-- @
getDtlsClientConnectionServerIdentity :: (MonadIO m, IsDtlsClientConnection o) => o -> m Gio.SocketConnectable.SocketConnectable
getDtlsClientConnectionServerIdentity obj = MIO.liftIO $ checkUnexpectedNothing "getDtlsClientConnectionServerIdentity" $ B.Properties.getObjectPropertyObject obj "server-identity" Gio.SocketConnectable.SocketConnectable

-- | Set the value of the “@server-identity@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dtlsClientConnection [ #serverIdentity 'Data.GI.Base.Attributes.:=' value ]
-- @
setDtlsClientConnectionServerIdentity :: (MonadIO m, IsDtlsClientConnection o, Gio.SocketConnectable.IsSocketConnectable a) => o -> a -> m ()
setDtlsClientConnectionServerIdentity obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "server-identity" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@server-identity@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDtlsClientConnectionServerIdentity :: (IsDtlsClientConnection o, MIO.MonadIO m, Gio.SocketConnectable.IsSocketConnectable a) => a -> m (GValueConstruct o)
constructDtlsClientConnectionServerIdentity val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "server-identity" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DtlsClientConnectionServerIdentityPropertyInfo
instance AttrInfo DtlsClientConnectionServerIdentityPropertyInfo where
    type AttrAllowedOps DtlsClientConnectionServerIdentityPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DtlsClientConnectionServerIdentityPropertyInfo = IsDtlsClientConnection
    type AttrSetTypeConstraint DtlsClientConnectionServerIdentityPropertyInfo = Gio.SocketConnectable.IsSocketConnectable
    type AttrTransferTypeConstraint DtlsClientConnectionServerIdentityPropertyInfo = Gio.SocketConnectable.IsSocketConnectable
    type AttrTransferType DtlsClientConnectionServerIdentityPropertyInfo = Gio.SocketConnectable.SocketConnectable
    type AttrGetType DtlsClientConnectionServerIdentityPropertyInfo = Gio.SocketConnectable.SocketConnectable
    type AttrLabel DtlsClientConnectionServerIdentityPropertyInfo = "server-identity"
    type AttrOrigin DtlsClientConnectionServerIdentityPropertyInfo = DtlsClientConnection
    attrGet = getDtlsClientConnectionServerIdentity
    attrSet = setDtlsClientConnectionServerIdentity
    attrTransfer _ v = do
        unsafeCastTo Gio.SocketConnectable.SocketConnectable v
    attrConstruct = constructDtlsClientConnectionServerIdentity
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DtlsClientConnection.serverIdentity"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-DtlsClientConnection.html#g:attr:serverIdentity"
        })
#endif

-- VVV Prop "validation-flags"
   -- Type: TInterface (Name {namespace = "Gio", name = "TlsCertificateFlags"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@validation-flags@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dtlsClientConnection #validationFlags
-- @
getDtlsClientConnectionValidationFlags :: (MonadIO m, IsDtlsClientConnection o) => o -> m [Gio.Flags.TlsCertificateFlags]
getDtlsClientConnectionValidationFlags obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "validation-flags"

-- | Set the value of the “@validation-flags@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dtlsClientConnection [ #validationFlags 'Data.GI.Base.Attributes.:=' value ]
-- @
setDtlsClientConnectionValidationFlags :: (MonadIO m, IsDtlsClientConnection o) => o -> [Gio.Flags.TlsCertificateFlags] -> m ()
setDtlsClientConnectionValidationFlags obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "validation-flags" val

-- | Construct a `GValueConstruct` with valid value for the “@validation-flags@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDtlsClientConnectionValidationFlags :: (IsDtlsClientConnection o, MIO.MonadIO m) => [Gio.Flags.TlsCertificateFlags] -> m (GValueConstruct o)
constructDtlsClientConnectionValidationFlags val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "validation-flags" val

#if defined(ENABLE_OVERLOADING)
data DtlsClientConnectionValidationFlagsPropertyInfo
instance AttrInfo DtlsClientConnectionValidationFlagsPropertyInfo where
    type AttrAllowedOps DtlsClientConnectionValidationFlagsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DtlsClientConnectionValidationFlagsPropertyInfo = IsDtlsClientConnection
    type AttrSetTypeConstraint DtlsClientConnectionValidationFlagsPropertyInfo = (~) [Gio.Flags.TlsCertificateFlags]
    type AttrTransferTypeConstraint DtlsClientConnectionValidationFlagsPropertyInfo = (~) [Gio.Flags.TlsCertificateFlags]
    type AttrTransferType DtlsClientConnectionValidationFlagsPropertyInfo = [Gio.Flags.TlsCertificateFlags]
    type AttrGetType DtlsClientConnectionValidationFlagsPropertyInfo = [Gio.Flags.TlsCertificateFlags]
    type AttrLabel DtlsClientConnectionValidationFlagsPropertyInfo = "validation-flags"
    type AttrOrigin DtlsClientConnectionValidationFlagsPropertyInfo = DtlsClientConnection
    attrGet = getDtlsClientConnectionValidationFlags
    attrSet = setDtlsClientConnectionValidationFlags
    attrTransfer _ v = do
        return v
    attrConstruct = constructDtlsClientConnectionValidationFlags
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DtlsClientConnection.validationFlags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-DtlsClientConnection.html#g:attr:validationFlags"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DtlsClientConnection
type instance O.AttributeList DtlsClientConnection = DtlsClientConnectionAttributeList
type DtlsClientConnectionAttributeList = ('[ '("acceptedCas", DtlsClientConnectionAcceptedCasPropertyInfo), '("advertisedProtocols", Gio.DtlsConnection.DtlsConnectionAdvertisedProtocolsPropertyInfo), '("baseSocket", Gio.DtlsConnection.DtlsConnectionBaseSocketPropertyInfo), '("certificate", Gio.DtlsConnection.DtlsConnectionCertificatePropertyInfo), '("ciphersuiteName", Gio.DtlsConnection.DtlsConnectionCiphersuiteNamePropertyInfo), '("database", Gio.DtlsConnection.DtlsConnectionDatabasePropertyInfo), '("interaction", Gio.DtlsConnection.DtlsConnectionInteractionPropertyInfo), '("negotiatedProtocol", Gio.DtlsConnection.DtlsConnectionNegotiatedProtocolPropertyInfo), '("peerCertificate", Gio.DtlsConnection.DtlsConnectionPeerCertificatePropertyInfo), '("peerCertificateErrors", Gio.DtlsConnection.DtlsConnectionPeerCertificateErrorsPropertyInfo), '("protocolVersion", Gio.DtlsConnection.DtlsConnectionProtocolVersionPropertyInfo), '("rehandshakeMode", Gio.DtlsConnection.DtlsConnectionRehandshakeModePropertyInfo), '("requireCloseNotify", Gio.DtlsConnection.DtlsConnectionRequireCloseNotifyPropertyInfo), '("serverIdentity", DtlsClientConnectionServerIdentityPropertyInfo), '("validationFlags", DtlsClientConnectionValidationFlagsPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
dtlsClientConnectionAcceptedCas :: AttrLabelProxy "acceptedCas"
dtlsClientConnectionAcceptedCas = AttrLabelProxy

dtlsClientConnectionServerIdentity :: AttrLabelProxy "serverIdentity"
dtlsClientConnectionServerIdentity = AttrLabelProxy

dtlsClientConnectionValidationFlags :: AttrLabelProxy "validationFlags"
dtlsClientConnectionValidationFlags = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDtlsClientConnectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDtlsClientConnectionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDtlsClientConnectionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDtlsClientConnectionMethod "close" o = Gio.DtlsConnection.DtlsConnectionCloseMethodInfo
    ResolveDtlsClientConnectionMethod "closeAsync" o = Gio.DtlsConnection.DtlsConnectionCloseAsyncMethodInfo
    ResolveDtlsClientConnectionMethod "closeFinish" o = Gio.DtlsConnection.DtlsConnectionCloseFinishMethodInfo
    ResolveDtlsClientConnectionMethod "conditionCheck" o = Gio.DatagramBased.DatagramBasedConditionCheckMethodInfo
    ResolveDtlsClientConnectionMethod "conditionWait" o = Gio.DatagramBased.DatagramBasedConditionWaitMethodInfo
    ResolveDtlsClientConnectionMethod "createSource" o = Gio.DatagramBased.DatagramBasedCreateSourceMethodInfo
    ResolveDtlsClientConnectionMethod "emitAcceptCertificate" o = Gio.DtlsConnection.DtlsConnectionEmitAcceptCertificateMethodInfo
    ResolveDtlsClientConnectionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDtlsClientConnectionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDtlsClientConnectionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDtlsClientConnectionMethod "handshake" o = Gio.DtlsConnection.DtlsConnectionHandshakeMethodInfo
    ResolveDtlsClientConnectionMethod "handshakeAsync" o = Gio.DtlsConnection.DtlsConnectionHandshakeAsyncMethodInfo
    ResolveDtlsClientConnectionMethod "handshakeFinish" o = Gio.DtlsConnection.DtlsConnectionHandshakeFinishMethodInfo
    ResolveDtlsClientConnectionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDtlsClientConnectionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDtlsClientConnectionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDtlsClientConnectionMethod "receiveMessages" o = Gio.DatagramBased.DatagramBasedReceiveMessagesMethodInfo
    ResolveDtlsClientConnectionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDtlsClientConnectionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDtlsClientConnectionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDtlsClientConnectionMethod "sendMessages" o = Gio.DatagramBased.DatagramBasedSendMessagesMethodInfo
    ResolveDtlsClientConnectionMethod "shutdown" o = Gio.DtlsConnection.DtlsConnectionShutdownMethodInfo
    ResolveDtlsClientConnectionMethod "shutdownAsync" o = Gio.DtlsConnection.DtlsConnectionShutdownAsyncMethodInfo
    ResolveDtlsClientConnectionMethod "shutdownFinish" o = Gio.DtlsConnection.DtlsConnectionShutdownFinishMethodInfo
    ResolveDtlsClientConnectionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDtlsClientConnectionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDtlsClientConnectionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDtlsClientConnectionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDtlsClientConnectionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDtlsClientConnectionMethod "getAcceptedCas" o = DtlsClientConnectionGetAcceptedCasMethodInfo
    ResolveDtlsClientConnectionMethod "getCertificate" o = Gio.DtlsConnection.DtlsConnectionGetCertificateMethodInfo
    ResolveDtlsClientConnectionMethod "getChannelBindingData" o = Gio.DtlsConnection.DtlsConnectionGetChannelBindingDataMethodInfo
    ResolveDtlsClientConnectionMethod "getCiphersuiteName" o = Gio.DtlsConnection.DtlsConnectionGetCiphersuiteNameMethodInfo
    ResolveDtlsClientConnectionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDtlsClientConnectionMethod "getDatabase" o = Gio.DtlsConnection.DtlsConnectionGetDatabaseMethodInfo
    ResolveDtlsClientConnectionMethod "getInteraction" o = Gio.DtlsConnection.DtlsConnectionGetInteractionMethodInfo
    ResolveDtlsClientConnectionMethod "getNegotiatedProtocol" o = Gio.DtlsConnection.DtlsConnectionGetNegotiatedProtocolMethodInfo
    ResolveDtlsClientConnectionMethod "getPeerCertificate" o = Gio.DtlsConnection.DtlsConnectionGetPeerCertificateMethodInfo
    ResolveDtlsClientConnectionMethod "getPeerCertificateErrors" o = Gio.DtlsConnection.DtlsConnectionGetPeerCertificateErrorsMethodInfo
    ResolveDtlsClientConnectionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDtlsClientConnectionMethod "getProtocolVersion" o = Gio.DtlsConnection.DtlsConnectionGetProtocolVersionMethodInfo
    ResolveDtlsClientConnectionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDtlsClientConnectionMethod "getRehandshakeMode" o = Gio.DtlsConnection.DtlsConnectionGetRehandshakeModeMethodInfo
    ResolveDtlsClientConnectionMethod "getRequireCloseNotify" o = Gio.DtlsConnection.DtlsConnectionGetRequireCloseNotifyMethodInfo
    ResolveDtlsClientConnectionMethod "getServerIdentity" o = DtlsClientConnectionGetServerIdentityMethodInfo
    ResolveDtlsClientConnectionMethod "getValidationFlags" o = DtlsClientConnectionGetValidationFlagsMethodInfo
    ResolveDtlsClientConnectionMethod "setAdvertisedProtocols" o = Gio.DtlsConnection.DtlsConnectionSetAdvertisedProtocolsMethodInfo
    ResolveDtlsClientConnectionMethod "setCertificate" o = Gio.DtlsConnection.DtlsConnectionSetCertificateMethodInfo
    ResolveDtlsClientConnectionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDtlsClientConnectionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDtlsClientConnectionMethod "setDatabase" o = Gio.DtlsConnection.DtlsConnectionSetDatabaseMethodInfo
    ResolveDtlsClientConnectionMethod "setInteraction" o = Gio.DtlsConnection.DtlsConnectionSetInteractionMethodInfo
    ResolveDtlsClientConnectionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDtlsClientConnectionMethod "setRehandshakeMode" o = Gio.DtlsConnection.DtlsConnectionSetRehandshakeModeMethodInfo
    ResolveDtlsClientConnectionMethod "setRequireCloseNotify" o = Gio.DtlsConnection.DtlsConnectionSetRequireCloseNotifyMethodInfo
    ResolveDtlsClientConnectionMethod "setServerIdentity" o = DtlsClientConnectionSetServerIdentityMethodInfo
    ResolveDtlsClientConnectionMethod "setValidationFlags" o = DtlsClientConnectionSetValidationFlagsMethodInfo
    ResolveDtlsClientConnectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDtlsClientConnectionMethod t DtlsClientConnection, O.OverloadedMethod info DtlsClientConnection p) => OL.IsLabel t (DtlsClientConnection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDtlsClientConnectionMethod t DtlsClientConnection, O.OverloadedMethod info DtlsClientConnection p, R.HasField t DtlsClientConnection p) => R.HasField t DtlsClientConnection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDtlsClientConnectionMethod t DtlsClientConnection, O.OverloadedMethodInfo info DtlsClientConnection) => OL.IsLabel t (O.MethodProxy info DtlsClientConnection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method DtlsClientConnection::get_accepted_cas
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DtlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GDtlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TGList TByteArray)
-- throws : False
-- Skip return : False

foreign import ccall "g_dtls_client_connection_get_accepted_cas" g_dtls_client_connection_get_accepted_cas :: 
    Ptr DtlsClientConnection ->             -- conn : TInterface (Name {namespace = "Gio", name = "DtlsClientConnection"})
    IO (Ptr (GList (Ptr GByteArray)))

-- | Gets the list of distinguished names of the Certificate Authorities
-- that the server will accept certificates from. This will be set
-- during the TLS handshake if the server requests a certificate.
-- Otherwise, it will be 'P.Nothing'.
-- 
-- Each item in the list is a t'GI.GLib.Structs.ByteArray.ByteArray' which contains the complete
-- subject DN of the certificate authority.
-- 
-- /Since: 2.48/
dtlsClientConnectionGetAcceptedCas ::
    (B.CallStack.HasCallStack, MonadIO m, IsDtlsClientConnection a) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection'
    -> m [ByteString]
    -- ^ __Returns:__ the list of
    -- CA DNs. You should unref each element with 'GI.GLib.Functions.byteArrayUnref' and then
    -- the free the list with @/g_list_free()/@.
dtlsClientConnectionGetAcceptedCas conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_dtls_client_connection_get_accepted_cas conn'
    result' <- unpackGList result
    result'' <- mapM unpackGByteArray result'
    mapGList unrefGByteArray result
    g_list_free result
    touchManagedPtr conn
    return result''

#if defined(ENABLE_OVERLOADING)
data DtlsClientConnectionGetAcceptedCasMethodInfo
instance (signature ~ (m [ByteString]), MonadIO m, IsDtlsClientConnection a) => O.OverloadedMethod DtlsClientConnectionGetAcceptedCasMethodInfo a signature where
    overloadedMethod = dtlsClientConnectionGetAcceptedCas

instance O.OverloadedMethodInfo DtlsClientConnectionGetAcceptedCasMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DtlsClientConnection.dtlsClientConnectionGetAcceptedCas",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-DtlsClientConnection.html#v:dtlsClientConnectionGetAcceptedCas"
        })


#endif

-- method DtlsClientConnection::get_server_identity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DtlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GDtlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "SocketConnectable" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dtls_client_connection_get_server_identity" g_dtls_client_connection_get_server_identity :: 
    Ptr DtlsClientConnection ->             -- conn : TInterface (Name {namespace = "Gio", name = "DtlsClientConnection"})
    IO (Ptr Gio.SocketConnectable.SocketConnectable)

-- | Gets /@conn@/\'s expected server identity
-- 
-- /Since: 2.48/
dtlsClientConnectionGetServerIdentity ::
    (B.CallStack.HasCallStack, MonadIO m, IsDtlsClientConnection a) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection'
    -> m Gio.SocketConnectable.SocketConnectable
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable' describing the
    -- expected server identity, or 'P.Nothing' if the expected identity is not
    -- known.
dtlsClientConnectionGetServerIdentity conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_dtls_client_connection_get_server_identity conn'
    checkUnexpectedReturnNULL "dtlsClientConnectionGetServerIdentity" result
    result' <- (newObject Gio.SocketConnectable.SocketConnectable) result
    touchManagedPtr conn
    return result'

#if defined(ENABLE_OVERLOADING)
data DtlsClientConnectionGetServerIdentityMethodInfo
instance (signature ~ (m Gio.SocketConnectable.SocketConnectable), MonadIO m, IsDtlsClientConnection a) => O.OverloadedMethod DtlsClientConnectionGetServerIdentityMethodInfo a signature where
    overloadedMethod = dtlsClientConnectionGetServerIdentity

instance O.OverloadedMethodInfo DtlsClientConnectionGetServerIdentityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DtlsClientConnection.dtlsClientConnectionGetServerIdentity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-DtlsClientConnection.html#v:dtlsClientConnectionGetServerIdentity"
        })


#endif

-- method DtlsClientConnection::get_validation_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DtlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GDtlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "TlsCertificateFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dtls_client_connection_get_validation_flags" g_dtls_client_connection_get_validation_flags :: 
    Ptr DtlsClientConnection ->             -- conn : TInterface (Name {namespace = "Gio", name = "DtlsClientConnection"})
    IO CUInt

{-# DEPRECATED dtlsClientConnectionGetValidationFlags ["(Since version 2.74)","Do not attempt to ignore validation errors."] #-}
-- | Gets /@conn@/\'s validation flags
-- 
-- This function does not work as originally designed and is impossible
-- to use correctly. See t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection':@/validation-flags/@ for more
-- information.
-- 
-- /Since: 2.48/
dtlsClientConnectionGetValidationFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsDtlsClientConnection a) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection'
    -> m [Gio.Flags.TlsCertificateFlags]
    -- ^ __Returns:__ the validation flags
dtlsClientConnectionGetValidationFlags conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_dtls_client_connection_get_validation_flags conn'
    let result' = wordToGFlags result
    touchManagedPtr conn
    return result'

#if defined(ENABLE_OVERLOADING)
data DtlsClientConnectionGetValidationFlagsMethodInfo
instance (signature ~ (m [Gio.Flags.TlsCertificateFlags]), MonadIO m, IsDtlsClientConnection a) => O.OverloadedMethod DtlsClientConnectionGetValidationFlagsMethodInfo a signature where
    overloadedMethod = dtlsClientConnectionGetValidationFlags

instance O.OverloadedMethodInfo DtlsClientConnectionGetValidationFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DtlsClientConnection.dtlsClientConnectionGetValidationFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-DtlsClientConnection.html#v:dtlsClientConnectionGetValidationFlags"
        })


#endif

-- method DtlsClientConnection::set_server_identity
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DtlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GDtlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "identity"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketConnectable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GSocketConnectable describing the expected server identity"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dtls_client_connection_set_server_identity" g_dtls_client_connection_set_server_identity :: 
    Ptr DtlsClientConnection ->             -- conn : TInterface (Name {namespace = "Gio", name = "DtlsClientConnection"})
    Ptr Gio.SocketConnectable.SocketConnectable -> -- identity : TInterface (Name {namespace = "Gio", name = "SocketConnectable"})
    IO ()

-- | Sets /@conn@/\'s expected server identity, which is used both to tell
-- servers on virtual hosts which certificate to present, and also
-- to let /@conn@/ know what name to look for in the certificate when
-- performing 'GI.Gio.Flags.TlsCertificateFlagsBadIdentity' validation, if enabled.
-- 
-- /Since: 2.48/
dtlsClientConnectionSetServerIdentity ::
    (B.CallStack.HasCallStack, MonadIO m, IsDtlsClientConnection a, Gio.SocketConnectable.IsSocketConnectable b) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection'
    -> b
    -- ^ /@identity@/: a t'GI.Gio.Interfaces.SocketConnectable.SocketConnectable' describing the expected server identity
    -> m ()
dtlsClientConnectionSetServerIdentity conn identity = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    identity' <- unsafeManagedPtrCastPtr identity
    g_dtls_client_connection_set_server_identity conn' identity'
    touchManagedPtr conn
    touchManagedPtr identity
    return ()

#if defined(ENABLE_OVERLOADING)
data DtlsClientConnectionSetServerIdentityMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsDtlsClientConnection a, Gio.SocketConnectable.IsSocketConnectable b) => O.OverloadedMethod DtlsClientConnectionSetServerIdentityMethodInfo a signature where
    overloadedMethod = dtlsClientConnectionSetServerIdentity

instance O.OverloadedMethodInfo DtlsClientConnectionSetServerIdentityMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DtlsClientConnection.dtlsClientConnectionSetServerIdentity",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-DtlsClientConnection.html#v:dtlsClientConnectionSetServerIdentity"
        })


#endif

-- method DtlsClientConnection::set_validation_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DtlsClientConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GDtlsClientConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TlsCertificateFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTlsCertificateFlags to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dtls_client_connection_set_validation_flags" g_dtls_client_connection_set_validation_flags :: 
    Ptr DtlsClientConnection ->             -- conn : TInterface (Name {namespace = "Gio", name = "DtlsClientConnection"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "TlsCertificateFlags"})
    IO ()

{-# DEPRECATED dtlsClientConnectionSetValidationFlags ["(Since version 2.74)","Do not attempt to ignore validation errors."] #-}
-- | Sets /@conn@/\'s validation flags, to override the default set of
-- checks performed when validating a server certificate. By default,
-- 'GI.Gio.Flags.TlsCertificateFlagsValidateAll' is used.
-- 
-- This function does not work as originally designed and is impossible
-- to use correctly. See t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection':@/validation-flags/@ for more
-- information.
-- 
-- /Since: 2.48/
dtlsClientConnectionSetValidationFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsDtlsClientConnection a) =>
    a
    -- ^ /@conn@/: the t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection'
    -> [Gio.Flags.TlsCertificateFlags]
    -- ^ /@flags@/: the t'GI.Gio.Flags.TlsCertificateFlags' to use
    -> m ()
dtlsClientConnectionSetValidationFlags conn flags = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    let flags' = gflagsToWord flags
    g_dtls_client_connection_set_validation_flags conn' flags'
    touchManagedPtr conn
    return ()

#if defined(ENABLE_OVERLOADING)
data DtlsClientConnectionSetValidationFlagsMethodInfo
instance (signature ~ ([Gio.Flags.TlsCertificateFlags] -> m ()), MonadIO m, IsDtlsClientConnection a) => O.OverloadedMethod DtlsClientConnectionSetValidationFlagsMethodInfo a signature where
    overloadedMethod = dtlsClientConnectionSetValidationFlags

instance O.OverloadedMethodInfo DtlsClientConnectionSetValidationFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DtlsClientConnection.dtlsClientConnectionSetValidationFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-DtlsClientConnection.html#v:dtlsClientConnectionSetValidationFlags"
        })


#endif

-- method DtlsClientConnection::new
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "base_socket"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DatagramBased" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GDatagramBased to wrap"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "server_identity"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketConnectable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the expected identity of the server"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "DtlsClientConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_dtls_client_connection_new" g_dtls_client_connection_new :: 
    Ptr Gio.DatagramBased.DatagramBased ->  -- base_socket : TInterface (Name {namespace = "Gio", name = "DatagramBased"})
    Ptr Gio.SocketConnectable.SocketConnectable -> -- server_identity : TInterface (Name {namespace = "Gio", name = "SocketConnectable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr DtlsClientConnection)

-- | Creates a new t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection' wrapping /@baseSocket@/ which is
-- assumed to communicate with the server identified by /@serverIdentity@/.
-- 
-- /Since: 2.48/
dtlsClientConnectionNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DatagramBased.IsDatagramBased a, Gio.SocketConnectable.IsSocketConnectable b) =>
    a
    -- ^ /@baseSocket@/: the t'GI.Gio.Interfaces.DatagramBased.DatagramBased' to wrap
    -> Maybe (b)
    -- ^ /@serverIdentity@/: the expected identity of the server
    -> m DtlsClientConnection
    -- ^ __Returns:__ the new
    --   t'GI.Gio.Interfaces.DtlsClientConnection.DtlsClientConnection', or 'P.Nothing' on error /(Can throw 'Data.GI.Base.GError.GError')/
dtlsClientConnectionNew baseSocket serverIdentity = liftIO $ do
    baseSocket' <- unsafeManagedPtrCastPtr baseSocket
    maybeServerIdentity <- case serverIdentity of
        Nothing -> return FP.nullPtr
        Just jServerIdentity -> do
            jServerIdentity' <- unsafeManagedPtrCastPtr jServerIdentity
            return jServerIdentity'
    onException (do
        result <- propagateGError $ g_dtls_client_connection_new baseSocket' maybeServerIdentity
        checkUnexpectedReturnNULL "dtlsClientConnectionNew" result
        result' <- (wrapObject DtlsClientConnection) result
        touchManagedPtr baseSocket
        whenJust serverIdentity touchManagedPtr
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DtlsClientConnection = DtlsClientConnectionSignalList
type DtlsClientConnectionSignalList = ('[ '("acceptCertificate", Gio.DtlsConnection.DtlsConnectionAcceptCertificateSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


