{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gio.Interfaces.DesktopAppInfoLookup.DesktopAppInfoLookup' is an opaque data structure and can only be accessed
-- using the following functions.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.DesktopAppInfoLookup
    ( 

-- * Exported types
    DesktopAppInfoLookup(..)                ,
    IsDesktopAppInfoLookup                  ,
    toDesktopAppInfoLookup                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultForUriScheme]("GI.Gio.Interfaces.DesktopAppInfoLookup#g:method:getDefaultForUriScheme"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDesktopAppInfoLookupMethod       ,
#endif

-- ** getDefaultForUriScheme #method:getDefaultForUriScheme#

#if defined(ENABLE_OVERLOADING)
    DesktopAppInfoLookupGetDefaultForUriSchemeMethodInfo,
#endif
    desktopAppInfoLookupGetDefaultForUriScheme,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileEnumerator as Gio.FileEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileMonitor as Gio.FileMonitor
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo

#endif

-- interface DesktopAppInfoLookup 
-- | Memory-managed wrapper type.
{-# DEPRECATED DesktopAppInfoLookup ["(Since version 2.28)","The t'GI.Gio.Interfaces.DesktopAppInfoLookup.DesktopAppInfoLookup' interface is","  deprecated and unused by GIO."] #-}
newtype DesktopAppInfoLookup = DesktopAppInfoLookup (SP.ManagedPtr DesktopAppInfoLookup)
    deriving (Eq)

instance SP.ManagedPtrNewtype DesktopAppInfoLookup where
    toManagedPtr (DesktopAppInfoLookup p) = p

foreign import ccall "g_desktop_app_info_lookup_get_type"
    c_g_desktop_app_info_lookup_get_type :: IO B.Types.GType

instance B.Types.TypedObject DesktopAppInfoLookup where
    glibType = c_g_desktop_app_info_lookup_get_type

instance B.Types.GObject DesktopAppInfoLookup

-- | Type class for types which can be safely cast to `DesktopAppInfoLookup`, for instance with `toDesktopAppInfoLookup`.
class (SP.GObject o, O.IsDescendantOf DesktopAppInfoLookup o) => IsDesktopAppInfoLookup o
instance (SP.GObject o, O.IsDescendantOf DesktopAppInfoLookup o) => IsDesktopAppInfoLookup o

instance O.HasParentTypes DesktopAppInfoLookup
type instance O.ParentTypes DesktopAppInfoLookup = '[GObject.Object.Object]

-- | Cast to `DesktopAppInfoLookup`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDesktopAppInfoLookup :: (MIO.MonadIO m, IsDesktopAppInfoLookup o) => o -> m DesktopAppInfoLookup
toDesktopAppInfoLookup = MIO.liftIO . B.ManagedPtr.unsafeCastTo DesktopAppInfoLookup

-- | Convert 'DesktopAppInfoLookup' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DesktopAppInfoLookup) where
    gvalueGType_ = c_g_desktop_app_info_lookup_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DesktopAppInfoLookup)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DesktopAppInfoLookup)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DesktopAppInfoLookup ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DesktopAppInfoLookup
type instance O.AttributeList DesktopAppInfoLookup = DesktopAppInfoLookupAttributeList
type DesktopAppInfoLookupAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDesktopAppInfoLookupMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDesktopAppInfoLookupMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDesktopAppInfoLookupMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDesktopAppInfoLookupMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDesktopAppInfoLookupMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDesktopAppInfoLookupMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDesktopAppInfoLookupMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDesktopAppInfoLookupMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDesktopAppInfoLookupMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDesktopAppInfoLookupMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDesktopAppInfoLookupMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDesktopAppInfoLookupMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDesktopAppInfoLookupMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDesktopAppInfoLookupMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDesktopAppInfoLookupMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDesktopAppInfoLookupMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDesktopAppInfoLookupMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDesktopAppInfoLookupMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDesktopAppInfoLookupMethod "getDefaultForUriScheme" o = DesktopAppInfoLookupGetDefaultForUriSchemeMethodInfo
    ResolveDesktopAppInfoLookupMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDesktopAppInfoLookupMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDesktopAppInfoLookupMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDesktopAppInfoLookupMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDesktopAppInfoLookupMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDesktopAppInfoLookupMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDesktopAppInfoLookupMethod t DesktopAppInfoLookup, O.OverloadedMethod info DesktopAppInfoLookup p) => OL.IsLabel t (DesktopAppInfoLookup -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDesktopAppInfoLookupMethod t DesktopAppInfoLookup, O.OverloadedMethod info DesktopAppInfoLookup p, R.HasField t DesktopAppInfoLookup p) => R.HasField t DesktopAppInfoLookup p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDesktopAppInfoLookupMethod t DesktopAppInfoLookup, O.OverloadedMethodInfo info DesktopAppInfoLookup) => OL.IsLabel t (O.MethodProxy info DesktopAppInfoLookup) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method DesktopAppInfoLookup::get_default_for_uri_scheme
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "lookup"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DesktopAppInfoLookup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [iface@Gio.DesktopAppInfoLookup]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri_scheme"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string containing a URI scheme."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "AppInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_desktop_app_info_lookup_get_default_for_uri_scheme" g_desktop_app_info_lookup_get_default_for_uri_scheme :: 
    Ptr DesktopAppInfoLookup ->             -- lookup : TInterface (Name {namespace = "Gio", name = "DesktopAppInfoLookup"})
    CString ->                              -- uri_scheme : TBasicType TUTF8
    IO (Ptr Gio.AppInfo.AppInfo)

{-# DEPRECATED desktopAppInfoLookupGetDefaultForUriScheme ["(Since version 2.28)","The t'GI.Gio.Interfaces.DesktopAppInfoLookup.DesktopAppInfoLookup' interface is","  deprecated and unused by GIO."] #-}
-- | Gets the default application for launching applications
-- using this URI scheme for a particular t'GI.Gio.Interfaces.DesktopAppInfoLookup.DesktopAppInfoLookup'
-- implementation.
-- 
-- The t'GI.Gio.Interfaces.DesktopAppInfoLookup.DesktopAppInfoLookup' interface and this function is used
-- to implement [func/@gio@/.AppInfo.get_default_for_uri_scheme] backends
-- in a GIO module. There is no reason for applications to use it
-- directly. Applications should use
-- [func/@gio@/.AppInfo.get_default_for_uri_scheme].
desktopAppInfoLookupGetDefaultForUriScheme ::
    (B.CallStack.HasCallStack, MonadIO m, IsDesktopAppInfoLookup a) =>
    a
    -- ^ /@lookup@/: a t'GI.Gio.Interfaces.DesktopAppInfoLookup.DesktopAppInfoLookup'
    -> T.Text
    -- ^ /@uriScheme@/: a string containing a URI scheme.
    -> m (Maybe Gio.AppInfo.AppInfo)
    -- ^ __Returns:__ t'GI.Gio.Interfaces.AppInfo.AppInfo' for given
    --   /@uriScheme@/ or @NULL@ on error.
desktopAppInfoLookupGetDefaultForUriScheme lookup uriScheme = liftIO $ do
    lookup' <- unsafeManagedPtrCastPtr lookup
    uriScheme' <- textToCString uriScheme
    result <- g_desktop_app_info_lookup_get_default_for_uri_scheme lookup' uriScheme'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.AppInfo.AppInfo) result'
        return result''
    touchManagedPtr lookup
    freeMem uriScheme'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DesktopAppInfoLookupGetDefaultForUriSchemeMethodInfo
instance (signature ~ (T.Text -> m (Maybe Gio.AppInfo.AppInfo)), MonadIO m, IsDesktopAppInfoLookup a) => O.OverloadedMethod DesktopAppInfoLookupGetDefaultForUriSchemeMethodInfo a signature where
    overloadedMethod = desktopAppInfoLookupGetDefaultForUriScheme

instance O.OverloadedMethodInfo DesktopAppInfoLookupGetDefaultForUriSchemeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.DesktopAppInfoLookup.desktopAppInfoLookupGetDefaultForUriScheme",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-DesktopAppInfoLookup.html#v:desktopAppInfoLookupGetDefaultForUriScheme"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DesktopAppInfoLookup = DesktopAppInfoLookupSignalList
type DesktopAppInfoLookupSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


