{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Information about an installed application and methods to launch
-- it (with file arguments).
-- 
-- @GAppInfo@ and @GAppLaunchContext@ are used for describing and launching
-- applications installed on the system.
-- 
-- As of GLib 2.20, URIs will always be converted to POSIX paths
-- (using 'GI.Gio.Interfaces.File.fileGetPath') when using 'GI.Gio.Interfaces.AppInfo.appInfoLaunch'
-- even if the application requested an URI and not a POSIX path. For example
-- for a desktop-file based application with the following Exec key:
-- 
-- >Exec=totem %U
-- 
-- 
-- and a single URI, @sftp:\/\/foo\/file.avi@, then
-- @\/home\/user\/.gvfs\/sftp on foo\/file.avi@ will be passed. This will only work
-- if a set of suitable GIO extensions (such as GVfs 2.26 compiled with FUSE
-- support), is available and operational; if this is not the case, the URI
-- will be passed unmodified to the application. Some URIs, such as @mailto:@,
-- of course cannot be mapped to a POSIX path (in GVfs there’s no FUSE mount
-- for it); such URIs will be passed unmodified to the application.
-- 
-- Specifically for GVfs 2.26 and later, the POSIX URI will be mapped
-- back to the GIO URI in the t'GI.Gio.Interfaces.File.File' constructors (since GVfs
-- implements the GVfs extension point). As such, if the application
-- needs to examine the URI, it needs to use 'GI.Gio.Interfaces.File.fileGetUri'
-- or similar on t'GI.Gio.Interfaces.File.File'. In other words, an application cannot
-- assume that the URI passed to e.g. [func/@gio@/.File.new_for_commandline_arg]
-- is equal to the result of 'GI.Gio.Interfaces.File.fileGetUri'. The following snippet
-- illustrates this:
-- 
-- 
-- === /c code/
-- >GFile *f;
-- >char *uri;
-- >
-- >file = g_file_new_for_commandline_arg (uri_from_commandline);
-- >
-- >uri = g_file_get_uri (file);
-- >strcmp (uri, uri_from_commandline) == 0;
-- >g_free (uri);
-- >
-- >if (g_file_has_uri_scheme (file, "cdda"))
-- >  {
-- >    // do something special with uri
-- >  }
-- >g_object_unref (file);
-- 
-- 
-- This code will work when both @cdda:\/\/sr0\/Track 1.wav@ and
-- @\/home\/user\/.gvfs\/cdda on sr0\/Track 1.wav@ is passed to the
-- application. It should be noted that it’s generally not safe
-- for applications to rely on the format of a particular URIs.
-- Different launcher applications (e.g. file managers) may have
-- different ideas of what a given URI means.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.AppInfo
    ( 

-- * Exported types
    AppInfo(..)                             ,
    IsAppInfo                               ,
    toAppInfo                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addSupportsType]("GI.Gio.Interfaces.AppInfo#g:method:addSupportsType"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [canDelete]("GI.Gio.Interfaces.AppInfo#g:method:canDelete"), [canRemoveSupportsType]("GI.Gio.Interfaces.AppInfo#g:method:canRemoveSupportsType"), [delete]("GI.Gio.Interfaces.AppInfo#g:method:delete"), [dup]("GI.Gio.Interfaces.AppInfo#g:method:dup"), [equal]("GI.Gio.Interfaces.AppInfo#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [launch]("GI.Gio.Interfaces.AppInfo#g:method:launch"), [launchUris]("GI.Gio.Interfaces.AppInfo#g:method:launchUris"), [launchUrisAsync]("GI.Gio.Interfaces.AppInfo#g:method:launchUrisAsync"), [launchUrisFinish]("GI.Gio.Interfaces.AppInfo#g:method:launchUrisFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeSupportsType]("GI.Gio.Interfaces.AppInfo#g:method:removeSupportsType"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldShow]("GI.Gio.Interfaces.AppInfo#g:method:shouldShow"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [supportsFiles]("GI.Gio.Interfaces.AppInfo#g:method:supportsFiles"), [supportsUris]("GI.Gio.Interfaces.AppInfo#g:method:supportsUris"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCommandline]("GI.Gio.Interfaces.AppInfo#g:method:getCommandline"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDescription]("GI.Gio.Interfaces.AppInfo#g:method:getDescription"), [getDisplayName]("GI.Gio.Interfaces.AppInfo#g:method:getDisplayName"), [getExecutable]("GI.Gio.Interfaces.AppInfo#g:method:getExecutable"), [getIcon]("GI.Gio.Interfaces.AppInfo#g:method:getIcon"), [getId]("GI.Gio.Interfaces.AppInfo#g:method:getId"), [getName]("GI.Gio.Interfaces.AppInfo#g:method:getName"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSupportedTypes]("GI.Gio.Interfaces.AppInfo#g:method:getSupportedTypes").
-- 
-- ==== Setters
-- [setAsDefaultForExtension]("GI.Gio.Interfaces.AppInfo#g:method:setAsDefaultForExtension"), [setAsDefaultForType]("GI.Gio.Interfaces.AppInfo#g:method:setAsDefaultForType"), [setAsLastUsedForType]("GI.Gio.Interfaces.AppInfo#g:method:setAsLastUsedForType"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveAppInfoMethod                    ,
#endif

-- ** addSupportsType #method:addSupportsType#

#if defined(ENABLE_OVERLOADING)
    AppInfoAddSupportsTypeMethodInfo        ,
#endif
    appInfoAddSupportsType                  ,


-- ** canDelete #method:canDelete#

#if defined(ENABLE_OVERLOADING)
    AppInfoCanDeleteMethodInfo              ,
#endif
    appInfoCanDelete                        ,


-- ** canRemoveSupportsType #method:canRemoveSupportsType#

#if defined(ENABLE_OVERLOADING)
    AppInfoCanRemoveSupportsTypeMethodInfo  ,
#endif
    appInfoCanRemoveSupportsType            ,


-- ** createFromCommandline #method:createFromCommandline#

    appInfoCreateFromCommandline            ,


-- ** delete #method:delete#

#if defined(ENABLE_OVERLOADING)
    AppInfoDeleteMethodInfo                 ,
#endif
    appInfoDelete                           ,


-- ** dup #method:dup#

#if defined(ENABLE_OVERLOADING)
    AppInfoDupMethodInfo                    ,
#endif
    appInfoDup                              ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    AppInfoEqualMethodInfo                  ,
#endif
    appInfoEqual                            ,


-- ** getAll #method:getAll#

    appInfoGetAll                           ,


-- ** getAllForType #method:getAllForType#

    appInfoGetAllForType                    ,


-- ** getCommandline #method:getCommandline#

#if defined(ENABLE_OVERLOADING)
    AppInfoGetCommandlineMethodInfo         ,
#endif
    appInfoGetCommandline                   ,


-- ** getDefaultForType #method:getDefaultForType#

    appInfoGetDefaultForType                ,


-- ** getDefaultForTypeAsync #method:getDefaultForTypeAsync#

    appInfoGetDefaultForTypeAsync           ,


-- ** getDefaultForTypeFinish #method:getDefaultForTypeFinish#

    appInfoGetDefaultForTypeFinish          ,


-- ** getDefaultForUriScheme #method:getDefaultForUriScheme#

    appInfoGetDefaultForUriScheme           ,


-- ** getDefaultForUriSchemeAsync #method:getDefaultForUriSchemeAsync#

    appInfoGetDefaultForUriSchemeAsync      ,


-- ** getDefaultForUriSchemeFinish #method:getDefaultForUriSchemeFinish#

    appInfoGetDefaultForUriSchemeFinish     ,


-- ** getDescription #method:getDescription#

#if defined(ENABLE_OVERLOADING)
    AppInfoGetDescriptionMethodInfo         ,
#endif
    appInfoGetDescription                   ,


-- ** getDisplayName #method:getDisplayName#

#if defined(ENABLE_OVERLOADING)
    AppInfoGetDisplayNameMethodInfo         ,
#endif
    appInfoGetDisplayName                   ,


-- ** getExecutable #method:getExecutable#

#if defined(ENABLE_OVERLOADING)
    AppInfoGetExecutableMethodInfo          ,
#endif
    appInfoGetExecutable                    ,


-- ** getFallbackForType #method:getFallbackForType#

    appInfoGetFallbackForType               ,


-- ** getIcon #method:getIcon#

#if defined(ENABLE_OVERLOADING)
    AppInfoGetIconMethodInfo                ,
#endif
    appInfoGetIcon                          ,


-- ** getId #method:getId#

#if defined(ENABLE_OVERLOADING)
    AppInfoGetIdMethodInfo                  ,
#endif
    appInfoGetId                            ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    AppInfoGetNameMethodInfo                ,
#endif
    appInfoGetName                          ,


-- ** getRecommendedForType #method:getRecommendedForType#

    appInfoGetRecommendedForType            ,


-- ** getSupportedTypes #method:getSupportedTypes#

#if defined(ENABLE_OVERLOADING)
    AppInfoGetSupportedTypesMethodInfo      ,
#endif
    appInfoGetSupportedTypes                ,


-- ** launch #method:launch#

#if defined(ENABLE_OVERLOADING)
    AppInfoLaunchMethodInfo                 ,
#endif
    appInfoLaunch                           ,


-- ** launchDefaultForUri #method:launchDefaultForUri#

    appInfoLaunchDefaultForUri              ,


-- ** launchDefaultForUriAsync #method:launchDefaultForUriAsync#

    appInfoLaunchDefaultForUriAsync         ,


-- ** launchDefaultForUriFinish #method:launchDefaultForUriFinish#

    appInfoLaunchDefaultForUriFinish        ,


-- ** launchUris #method:launchUris#

#if defined(ENABLE_OVERLOADING)
    AppInfoLaunchUrisMethodInfo             ,
#endif
    appInfoLaunchUris                       ,


-- ** launchUrisAsync #method:launchUrisAsync#

#if defined(ENABLE_OVERLOADING)
    AppInfoLaunchUrisAsyncMethodInfo        ,
#endif
    appInfoLaunchUrisAsync                  ,


-- ** launchUrisFinish #method:launchUrisFinish#

#if defined(ENABLE_OVERLOADING)
    AppInfoLaunchUrisFinishMethodInfo       ,
#endif
    appInfoLaunchUrisFinish                 ,


-- ** removeSupportsType #method:removeSupportsType#

#if defined(ENABLE_OVERLOADING)
    AppInfoRemoveSupportsTypeMethodInfo     ,
#endif
    appInfoRemoveSupportsType               ,


-- ** resetTypeAssociations #method:resetTypeAssociations#

    appInfoResetTypeAssociations            ,


-- ** setAsDefaultForExtension #method:setAsDefaultForExtension#

#if defined(ENABLE_OVERLOADING)
    AppInfoSetAsDefaultForExtensionMethodInfo,
#endif
    appInfoSetAsDefaultForExtension         ,


-- ** setAsDefaultForType #method:setAsDefaultForType#

#if defined(ENABLE_OVERLOADING)
    AppInfoSetAsDefaultForTypeMethodInfo    ,
#endif
    appInfoSetAsDefaultForType              ,


-- ** setAsLastUsedForType #method:setAsLastUsedForType#

#if defined(ENABLE_OVERLOADING)
    AppInfoSetAsLastUsedForTypeMethodInfo   ,
#endif
    appInfoSetAsLastUsedForType             ,


-- ** shouldShow #method:shouldShow#

#if defined(ENABLE_OVERLOADING)
    AppInfoShouldShowMethodInfo             ,
#endif
    appInfoShouldShow                       ,


-- ** supportsFiles #method:supportsFiles#

#if defined(ENABLE_OVERLOADING)
    AppInfoSupportsFilesMethodInfo          ,
#endif
    appInfoSupportsFiles                    ,


-- ** supportsUris #method:supportsUris#

#if defined(ENABLE_OVERLOADING)
    AppInfoSupportsUrisMethodInfo           ,
#endif
    appInfoSupportsUris                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.FileEnumerator as Gio.FileEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileMonitor as Gio.FileMonitor
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable

#endif

-- interface AppInfo 
-- | Memory-managed wrapper type.
newtype AppInfo = AppInfo (SP.ManagedPtr AppInfo)
    deriving (Eq)

instance SP.ManagedPtrNewtype AppInfo where
    toManagedPtr (AppInfo p) = p

foreign import ccall "g_app_info_get_type"
    c_g_app_info_get_type :: IO B.Types.GType

instance B.Types.TypedObject AppInfo where
    glibType = c_g_app_info_get_type

instance B.Types.GObject AppInfo

-- | Type class for types which can be safely cast to `AppInfo`, for instance with `toAppInfo`.
class (SP.GObject o, O.IsDescendantOf AppInfo o) => IsAppInfo o
instance (SP.GObject o, O.IsDescendantOf AppInfo o) => IsAppInfo o

instance O.HasParentTypes AppInfo
type instance O.ParentTypes AppInfo = '[GObject.Object.Object]

-- | Cast to `AppInfo`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toAppInfo :: (MIO.MonadIO m, IsAppInfo o) => o -> m AppInfo
toAppInfo = MIO.liftIO . B.ManagedPtr.unsafeCastTo AppInfo

-- | Convert 'AppInfo' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AppInfo) where
    gvalueGType_ = c_g_app_info_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AppInfo)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AppInfo)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AppInfo ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AppInfo
type instance O.AttributeList AppInfo = AppInfoAttributeList
type AppInfoAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAppInfoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAppInfoMethod "addSupportsType" o = AppInfoAddSupportsTypeMethodInfo
    ResolveAppInfoMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAppInfoMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAppInfoMethod "canDelete" o = AppInfoCanDeleteMethodInfo
    ResolveAppInfoMethod "canRemoveSupportsType" o = AppInfoCanRemoveSupportsTypeMethodInfo
    ResolveAppInfoMethod "delete" o = AppInfoDeleteMethodInfo
    ResolveAppInfoMethod "dup" o = AppInfoDupMethodInfo
    ResolveAppInfoMethod "equal" o = AppInfoEqualMethodInfo
    ResolveAppInfoMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAppInfoMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAppInfoMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAppInfoMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAppInfoMethod "launch" o = AppInfoLaunchMethodInfo
    ResolveAppInfoMethod "launchUris" o = AppInfoLaunchUrisMethodInfo
    ResolveAppInfoMethod "launchUrisAsync" o = AppInfoLaunchUrisAsyncMethodInfo
    ResolveAppInfoMethod "launchUrisFinish" o = AppInfoLaunchUrisFinishMethodInfo
    ResolveAppInfoMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAppInfoMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAppInfoMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAppInfoMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAppInfoMethod "removeSupportsType" o = AppInfoRemoveSupportsTypeMethodInfo
    ResolveAppInfoMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAppInfoMethod "shouldShow" o = AppInfoShouldShowMethodInfo
    ResolveAppInfoMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAppInfoMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAppInfoMethod "supportsFiles" o = AppInfoSupportsFilesMethodInfo
    ResolveAppInfoMethod "supportsUris" o = AppInfoSupportsUrisMethodInfo
    ResolveAppInfoMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAppInfoMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAppInfoMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAppInfoMethod "getCommandline" o = AppInfoGetCommandlineMethodInfo
    ResolveAppInfoMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAppInfoMethod "getDescription" o = AppInfoGetDescriptionMethodInfo
    ResolveAppInfoMethod "getDisplayName" o = AppInfoGetDisplayNameMethodInfo
    ResolveAppInfoMethod "getExecutable" o = AppInfoGetExecutableMethodInfo
    ResolveAppInfoMethod "getIcon" o = AppInfoGetIconMethodInfo
    ResolveAppInfoMethod "getId" o = AppInfoGetIdMethodInfo
    ResolveAppInfoMethod "getName" o = AppInfoGetNameMethodInfo
    ResolveAppInfoMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAppInfoMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAppInfoMethod "getSupportedTypes" o = AppInfoGetSupportedTypesMethodInfo
    ResolveAppInfoMethod "setAsDefaultForExtension" o = AppInfoSetAsDefaultForExtensionMethodInfo
    ResolveAppInfoMethod "setAsDefaultForType" o = AppInfoSetAsDefaultForTypeMethodInfo
    ResolveAppInfoMethod "setAsLastUsedForType" o = AppInfoSetAsLastUsedForTypeMethodInfo
    ResolveAppInfoMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAppInfoMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAppInfoMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAppInfoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAppInfoMethod t AppInfo, O.OverloadedMethod info AppInfo p) => OL.IsLabel t (AppInfo -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAppInfoMethod t AppInfo, O.OverloadedMethod info AppInfo p, R.HasField t AppInfo p) => R.HasField t AppInfo p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAppInfoMethod t AppInfo, O.OverloadedMethodInfo info AppInfo) => OL.IsLabel t (O.MethodProxy info AppInfo) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method AppInfo::add_supports_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_add_supports_type" g_app_info_add_supports_type :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    CString ->                              -- content_type : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Adds a content type to the application information to indicate the
-- application is capable of opening files with the given content type.
appInfoAddSupportsType ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> T.Text
    -- ^ /@contentType@/: a string.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
appInfoAddSupportsType appinfo contentType = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    contentType' <- textToCString contentType
    onException (do
        _ <- propagateGError $ g_app_info_add_supports_type appinfo' contentType'
        touchManagedPtr appinfo
        freeMem contentType'
        return ()
     ) (do
        freeMem contentType'
     )

#if defined(ENABLE_OVERLOADING)
data AppInfoAddSupportsTypeMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoAddSupportsTypeMethodInfo a signature where
    overloadedMethod = appInfoAddSupportsType

instance O.OverloadedMethodInfo AppInfoAddSupportsTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoAddSupportsType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoAddSupportsType"
        })


#endif

-- method AppInfo::can_delete
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_can_delete" g_app_info_can_delete :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CInt

-- | Obtains the information whether the t'GI.Gio.Interfaces.AppInfo.AppInfo' can be deleted.
-- See 'GI.Gio.Interfaces.AppInfo.appInfoDelete'.
-- 
-- /Since: 2.20/
appInfoCanDelete ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if /@appinfo@/ can be deleted
appInfoCanDelete appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_can_delete appinfo'
    let result' = (/= 0) result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoCanDeleteMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoCanDeleteMethodInfo a signature where
    overloadedMethod = appInfoCanDelete

instance O.OverloadedMethodInfo AppInfoCanDeleteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoCanDelete",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoCanDelete"
        })


#endif

-- method AppInfo::can_remove_supports_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_can_remove_supports_type" g_app_info_can_remove_supports_type :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CInt

-- | Checks if a supported content type can be removed from an application.
appInfoCanRemoveSupportsType ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if it is possible to remove supported content types from a
    --   given /@appinfo@/, @FALSE@ if not.
appInfoCanRemoveSupportsType appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_can_remove_supports_type appinfo'
    let result' = (/= 0) result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoCanRemoveSupportsTypeMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoCanRemoveSupportsTypeMethodInfo a signature where
    overloadedMethod = appInfoCanRemoveSupportsType

instance O.OverloadedMethodInfo AppInfoCanRemoveSupportsTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoCanRemoveSupportsType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoCanRemoveSupportsType"
        })


#endif

-- method AppInfo::delete
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_delete" g_app_info_delete :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CInt

-- | Tries to delete a t'GI.Gio.Interfaces.AppInfo.AppInfo'.
-- 
-- On some platforms, there may be a difference between user-defined
-- t'GI.Gio.Interfaces.AppInfo.AppInfo's which can be deleted, and system-wide ones which cannot.
-- See 'GI.Gio.Interfaces.AppInfo.appInfoCanDelete'.
-- 
-- /Since: 2.20/
appInfoDelete ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if /@appinfo@/ has been deleted
appInfoDelete appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_delete appinfo'
    let result' = (/= 0) result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoDeleteMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoDeleteMethodInfo a signature where
    overloadedMethod = appInfoDelete

instance O.OverloadedMethodInfo AppInfoDeleteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoDelete",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoDelete"
        })


#endif

-- method AppInfo::dup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "AppInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_dup" g_app_info_dup :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO (Ptr AppInfo)

-- | Creates a duplicate of a t'GI.Gio.Interfaces.AppInfo.AppInfo'.
appInfoDup ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m AppInfo
    -- ^ __Returns:__ a duplicate of /@appinfo@/.
appInfoDup appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_dup appinfo'
    checkUnexpectedReturnNULL "appInfoDup" result
    result' <- (wrapObject AppInfo) result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoDupMethodInfo
instance (signature ~ (m AppInfo), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoDupMethodInfo a signature where
    overloadedMethod = appInfoDup

instance O.OverloadedMethodInfo AppInfoDupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoDup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoDup"
        })


#endif

-- method AppInfo::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo1"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the first [iface@Gio.AppInfo]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "appinfo2"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the second [iface@Gio.AppInfo]."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_equal" g_app_info_equal :: 
    Ptr AppInfo ->                          -- appinfo1 : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    Ptr AppInfo ->                          -- appinfo2 : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CInt

-- | Checks if two t'GI.Gio.Interfaces.AppInfo.AppInfo's are equal.
-- 
-- Note that the check *may not* compare each individual field, and only does
-- an identity check. In case detecting changes in the contents is needed,
-- program code must additionally compare relevant fields.
appInfoEqual ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a, IsAppInfo b) =>
    a
    -- ^ /@appinfo1@/: the first t'GI.Gio.Interfaces.AppInfo.AppInfo'.
    -> b
    -- ^ /@appinfo2@/: the second t'GI.Gio.Interfaces.AppInfo.AppInfo'.
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if /@appinfo1@/ is equal to /@appinfo2@/. @FALSE@ otherwise.
appInfoEqual appinfo1 appinfo2 = liftIO $ do
    appinfo1' <- unsafeManagedPtrCastPtr appinfo1
    appinfo2' <- unsafeManagedPtrCastPtr appinfo2
    result <- g_app_info_equal appinfo1' appinfo2'
    let result' = (/= 0) result
    touchManagedPtr appinfo1
    touchManagedPtr appinfo2
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoEqualMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsAppInfo a, IsAppInfo b) => O.OverloadedMethod AppInfoEqualMethodInfo a signature where
    overloadedMethod = appInfoEqual

instance O.OverloadedMethodInfo AppInfoEqualMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoEqual"
        })


#endif

-- method AppInfo::get_commandline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_commandline" g_app_info_get_commandline :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CString

-- | Gets the commandline with which the application will be
-- started.
-- 
-- /Since: 2.20/
appInfoGetCommandline ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m (Maybe [Char])
    -- ^ __Returns:__ a string containing the /@appinfo@/’s
    --   commandline, or @NULL@ if this information is not available
appInfoGetCommandline appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_get_commandline appinfo'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToString result'
        return result''
    touchManagedPtr appinfo
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AppInfoGetCommandlineMethodInfo
instance (signature ~ (m (Maybe [Char])), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoGetCommandlineMethodInfo a signature where
    overloadedMethod = appInfoGetCommandline

instance O.OverloadedMethodInfo AppInfoGetCommandlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoGetCommandline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoGetCommandline"
        })


#endif

-- method AppInfo::get_description
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_description" g_app_info_get_description :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CString

-- | Gets a human-readable description of an installed application.
appInfoGetDescription ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a string containing a description of the
    -- application /@appinfo@/, or @NULL@ if none.
appInfoGetDescription appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_get_description appinfo'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr appinfo
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AppInfoGetDescriptionMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoGetDescriptionMethodInfo a signature where
    overloadedMethod = appInfoGetDescription

instance O.OverloadedMethodInfo AppInfoGetDescriptionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoGetDescription",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoGetDescription"
        })


#endif

-- method AppInfo::get_display_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_display_name" g_app_info_get_display_name :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CString

-- | Gets the display name of the application. The display name is often more
-- descriptive to the user than the name itself.
-- 
-- /Since: 2.24/
appInfoGetDisplayName ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m T.Text
    -- ^ __Returns:__ the display name of the application for /@appinfo@/, or the name if
    -- no display name is available.
appInfoGetDisplayName appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_get_display_name appinfo'
    checkUnexpectedReturnNULL "appInfoGetDisplayName" result
    result' <- cstringToText result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoGetDisplayNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoGetDisplayNameMethodInfo a signature where
    overloadedMethod = appInfoGetDisplayName

instance O.OverloadedMethodInfo AppInfoGetDisplayNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoGetDisplayName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoGetDisplayName"
        })


#endif

-- method AppInfo::get_executable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_executable" g_app_info_get_executable :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CString

-- | Gets the executable’s name for the installed application.
-- 
-- This is intended to be used for debugging or labelling what program is going
-- to be run. To launch the executable, use 'GI.Gio.Interfaces.AppInfo.appInfoLaunch' and related
-- functions, rather than spawning the return value from this function.
appInfoGetExecutable ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m [Char]
    -- ^ __Returns:__ a string containing the /@appinfo@/’s application
    -- binaries name
appInfoGetExecutable appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_get_executable appinfo'
    checkUnexpectedReturnNULL "appInfoGetExecutable" result
    result' <- cstringToString result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoGetExecutableMethodInfo
instance (signature ~ (m [Char]), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoGetExecutableMethodInfo a signature where
    overloadedMethod = appInfoGetExecutable

instance O.OverloadedMethodInfo AppInfoGetExecutableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoGetExecutable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoGetExecutable"
        })


#endif

-- method AppInfo::get_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_icon" g_app_info_get_icon :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO (Ptr Gio.Icon.Icon)

-- | Gets the icon for the application.
appInfoGetIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m (Maybe Gio.Icon.Icon)
    -- ^ __Returns:__ the default t'GI.Gio.Interfaces.Icon.Icon' for
    --   /@appinfo@/ or @NULL@ if there is no default icon.
appInfoGetIcon appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_get_icon appinfo'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.Icon.Icon) result'
        return result''
    touchManagedPtr appinfo
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AppInfoGetIconMethodInfo
instance (signature ~ (m (Maybe Gio.Icon.Icon)), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoGetIconMethodInfo a signature where
    overloadedMethod = appInfoGetIcon

instance O.OverloadedMethodInfo AppInfoGetIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoGetIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoGetIcon"
        })


#endif

-- method AppInfo::get_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_id" g_app_info_get_id :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CString

-- | Gets the ID of an application. An id is a string that identifies the
-- application. The exact format of the id is platform dependent. For instance,
-- on Unix this is the desktop file id from the xdg menu specification.
-- 
-- Note that the returned ID may be @NULL@, depending on how the /@appinfo@/ has
-- been constructed.
appInfoGetId ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a string containing the application’s ID.
appInfoGetId appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_get_id appinfo'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr appinfo
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AppInfoGetIdMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoGetIdMethodInfo a signature where
    overloadedMethod = appInfoGetId

instance O.OverloadedMethodInfo AppInfoGetIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoGetId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoGetId"
        })


#endif

-- method AppInfo::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_name" g_app_info_get_name :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CString

-- | Gets the installed name of the application.
appInfoGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m T.Text
    -- ^ __Returns:__ the name of the application for /@appinfo@/.
appInfoGetName appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_get_name appinfo'
    checkUnexpectedReturnNULL "appInfoGetName" result
    result' <- cstringToText result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoGetNameMethodInfo a signature where
    overloadedMethod = appInfoGetName

instance O.OverloadedMethodInfo AppInfoGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoGetName"
        })


#endif

-- method AppInfo::get_supported_types
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an app info that can handle files"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_supported_types" g_app_info_get_supported_types :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO (Ptr CString)

-- | Retrieves the list of content types that /@appInfo@/ claims to support.
-- If this information is not provided by the environment, this function
-- will return @NULL@.
-- 
-- This function does not take in consideration associations added with
-- 'GI.Gio.Interfaces.AppInfo.appInfoAddSupportsType', but only those exported directly by
-- the application.
-- 
-- /Since: 2.34/
appInfoGetSupportedTypes ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: an app info that can handle files
    -> m [T.Text]
    -- ^ __Returns:__ 
    --   a list of content types.
appInfoGetSupportedTypes appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_get_supported_types appinfo'
    checkUnexpectedReturnNULL "appInfoGetSupportedTypes" result
    result' <- unpackZeroTerminatedUTF8CArray result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoGetSupportedTypesMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoGetSupportedTypesMethodInfo a signature where
    overloadedMethod = appInfoGetSupportedTypes

instance O.OverloadedMethodInfo AppInfoGetSupportedTypesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoGetSupportedTypes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoGetSupportedTypes"
        })


#endif

-- method AppInfo::launch
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "files"
--           , argType =
--               TGList (TInterface Name { namespace = "Gio" , name = "File" })
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a list of [iface@Gio.File] objects"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppLaunchContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the launch context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_launch" g_app_info_launch :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    Ptr (GList (Ptr Gio.File.File)) ->      -- files : TGList (TInterface (Name {namespace = "Gio", name = "File"}))
    Ptr Gio.AppLaunchContext.AppLaunchContext -> -- context : TInterface (Name {namespace = "Gio", name = "AppLaunchContext"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Launches the application. Passes /@files@/ to the launched application
-- as arguments, using the optional /@context@/ to get information
-- about the details of the launcher (like what screen it is on).
-- On error, /@error@/ will be set accordingly.
-- 
-- To launch the application without arguments pass a @NULL@ /@files@/ list.
-- 
-- Note that even if the launch is successful the application launched
-- can fail to start if it runs into problems during startup. There is
-- no way to detect this.
-- 
-- Some URIs can be changed when passed through a GFile (for instance
-- unsupported URIs with strange formats like mailto:), so if you have
-- a textual URI you want to pass in as argument, consider using
-- 'GI.Gio.Interfaces.AppInfo.appInfoLaunchUris' instead.
-- 
-- The launched application inherits the environment of the launching
-- process, but it can be modified with 'GI.Gio.Objects.AppLaunchContext.appLaunchContextSetenv'
-- and 'GI.Gio.Objects.AppLaunchContext.appLaunchContextUnsetenv'.
-- 
-- On UNIX, this function sets the @GIO_LAUNCHED_DESKTOP_FILE@
-- environment variable with the path of the launched desktop file and
-- @GIO_LAUNCHED_DESKTOP_FILE_PID@ to the process id of the launched
-- process. This can be used to ignore @GIO_LAUNCHED_DESKTOP_FILE@,
-- should it be inherited by further processes. The @DISPLAY@,
-- @XDG_ACTIVATION_TOKEN@ and @DESKTOP_STARTUP_ID@ environment
-- variables are also set, based on information provided in /@context@/.
appInfoLaunch ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a, Gio.File.IsFile b, Gio.AppLaunchContext.IsAppLaunchContext c) =>
    a
    -- ^ /@appinfo@/: the app info
    -> [b]
    -- ^ /@files@/: a list of t'GI.Gio.Interfaces.File.File' objects
    -> Maybe (c)
    -- ^ /@context@/: the launch context
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
appInfoLaunch appinfo files context = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    files' <- mapM unsafeManagedPtrCastPtr files
    files'' <- packGList files'
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrCastPtr jContext
            return jContext'
    onException (do
        _ <- propagateGError $ g_app_info_launch appinfo' files'' maybeContext
        touchManagedPtr appinfo
        mapM_ touchManagedPtr files
        whenJust context touchManagedPtr
        g_list_free files''
        return ()
     ) (do
        g_list_free files''
     )

#if defined(ENABLE_OVERLOADING)
data AppInfoLaunchMethodInfo
instance (signature ~ ([b] -> Maybe (c) -> m ()), MonadIO m, IsAppInfo a, Gio.File.IsFile b, Gio.AppLaunchContext.IsAppLaunchContext c) => O.OverloadedMethod AppInfoLaunchMethodInfo a signature where
    overloadedMethod = appInfoLaunch

instance O.OverloadedMethodInfo AppInfoLaunchMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoLaunch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoLaunch"
        })


#endif

-- method AppInfo::launch_uris
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uris"
--           , argType = TGList (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a list of URIs to launch."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppLaunchContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the launch context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_launch_uris" g_app_info_launch_uris :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    Ptr (GList CString) ->                  -- uris : TGList (TBasicType TUTF8)
    Ptr Gio.AppLaunchContext.AppLaunchContext -> -- context : TInterface (Name {namespace = "Gio", name = "AppLaunchContext"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Launches the application. This passes the /@uris@/ to the launched application
-- as arguments, using the optional /@context@/ to get information
-- about the details of the launcher (like what screen it is on).
-- On error, /@error@/ will be set accordingly. If the application only supports
-- one URI per invocation as part of their command-line, multiple instances
-- of the application will be spawned.
-- 
-- To launch the application without arguments pass a @NULL@ /@uris@/ list.
-- 
-- Note that even if the launch is successful the application launched
-- can fail to start if it runs into problems during startup. There is
-- no way to detect this.
appInfoLaunchUris ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a, Gio.AppLaunchContext.IsAppLaunchContext b) =>
    a
    -- ^ /@appinfo@/: the app info
    -> [T.Text]
    -- ^ /@uris@/: a list of URIs to launch.
    -> Maybe (b)
    -- ^ /@context@/: the launch context
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
appInfoLaunchUris appinfo uris context = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    uris' <- mapM textToCString uris
    uris'' <- packGList uris'
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrCastPtr jContext
            return jContext'
    onException (do
        _ <- propagateGError $ g_app_info_launch_uris appinfo' uris'' maybeContext
        touchManagedPtr appinfo
        whenJust context touchManagedPtr
        mapGList freeMem uris''
        g_list_free uris''
        return ()
     ) (do
        mapGList freeMem uris''
        g_list_free uris''
     )

#if defined(ENABLE_OVERLOADING)
data AppInfoLaunchUrisMethodInfo
instance (signature ~ ([T.Text] -> Maybe (b) -> m ()), MonadIO m, IsAppInfo a, Gio.AppLaunchContext.IsAppLaunchContext b) => O.OverloadedMethod AppInfoLaunchUrisMethodInfo a signature where
    overloadedMethod = appInfoLaunchUris

instance O.OverloadedMethodInfo AppInfoLaunchUrisMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoLaunchUris",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoLaunchUris"
        })


#endif

-- method AppInfo::launch_uris_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uris"
--           , argType = TGList (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a list of URIs to launch."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppLaunchContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the launch context" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.Cancellable]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a [type@Gio.AsyncReadyCallback] to call\n  when the request is done"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_launch_uris_async" g_app_info_launch_uris_async :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    Ptr (GList CString) ->                  -- uris : TGList (TBasicType TUTF8)
    Ptr Gio.AppLaunchContext.AppLaunchContext -> -- context : TInterface (Name {namespace = "Gio", name = "AppLaunchContext"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Async version of 'GI.Gio.Interfaces.AppInfo.appInfoLaunchUris'.
-- 
-- The /@callback@/ is invoked immediately after the application launch, but it
-- waits for activation in case of D-Bus–activated applications and also provides
-- extended error information for sandboxed applications, see notes for
-- [func/@gio@/.AppInfo.launch_default_for_uri_async].
-- 
-- /Since: 2.60/
appInfoLaunchUrisAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a, Gio.AppLaunchContext.IsAppLaunchContext b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@appinfo@/: the app info
    -> [T.Text]
    -- ^ /@uris@/: a list of URIs to launch.
    -> Maybe (b)
    -- ^ /@context@/: the launch context
    -> Maybe (c)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a [type/@gio@/.AsyncReadyCallback] to call
    --   when the request is done
    -> m ()
appInfoLaunchUrisAsync appinfo uris context cancellable callback = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    uris' <- mapM textToCString uris
    uris'' <- packGList uris'
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrCastPtr jContext
            return jContext'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_app_info_launch_uris_async appinfo' uris'' maybeContext maybeCancellable maybeCallback userData
    touchManagedPtr appinfo
    whenJust context touchManagedPtr
    whenJust cancellable touchManagedPtr
    mapGList freeMem uris''
    g_list_free uris''
    return ()

#if defined(ENABLE_OVERLOADING)
data AppInfoLaunchUrisAsyncMethodInfo
instance (signature ~ ([T.Text] -> Maybe (b) -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsAppInfo a, Gio.AppLaunchContext.IsAppLaunchContext b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod AppInfoLaunchUrisAsyncMethodInfo a signature where
    overloadedMethod = appInfoLaunchUrisAsync

instance O.OverloadedMethodInfo AppInfoLaunchUrisAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoLaunchUrisAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoLaunchUrisAsync"
        })


#endif

-- method AppInfo::launch_uris_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the async result" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_launch_uris_finish" g_app_info_launch_uris_finish :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes a 'GI.Gio.Interfaces.AppInfo.appInfoLaunchUrisAsync' operation.
-- 
-- /Since: 2.60/
appInfoLaunchUrisFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@appinfo@/: the app info
    -> b
    -- ^ /@result@/: the async result
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
appInfoLaunchUrisFinish appinfo result_ = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ g_app_info_launch_uris_finish appinfo' result_'
        touchManagedPtr appinfo
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data AppInfoLaunchUrisFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsAppInfo a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod AppInfoLaunchUrisFinishMethodInfo a signature where
    overloadedMethod = appInfoLaunchUrisFinish

instance O.OverloadedMethodInfo AppInfoLaunchUrisFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoLaunchUrisFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoLaunchUrisFinish"
        })


#endif

-- method AppInfo::remove_supports_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_remove_supports_type" g_app_info_remove_supports_type :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    CString ->                              -- content_type : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Removes a supported type from an application, if possible.
appInfoRemoveSupportsType ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> T.Text
    -- ^ /@contentType@/: a string.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
appInfoRemoveSupportsType appinfo contentType = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    contentType' <- textToCString contentType
    onException (do
        _ <- propagateGError $ g_app_info_remove_supports_type appinfo' contentType'
        touchManagedPtr appinfo
        freeMem contentType'
        return ()
     ) (do
        freeMem contentType'
     )

#if defined(ENABLE_OVERLOADING)
data AppInfoRemoveSupportsTypeMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoRemoveSupportsTypeMethodInfo a signature where
    overloadedMethod = appInfoRemoveSupportsType

instance O.OverloadedMethodInfo AppInfoRemoveSupportsTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoRemoveSupportsType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoRemoveSupportsType"
        })


#endif

-- method AppInfo::set_as_default_for_extension
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "extension"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a string containing the file extension (without\n  the dot)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_set_as_default_for_extension" g_app_info_set_as_default_for_extension :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    CString ->                              -- extension : TBasicType TFileName
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Sets the application as the default handler for the given file extension.
appInfoSetAsDefaultForExtension ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> [Char]
    -- ^ /@extension@/: a string containing the file extension (without
    --   the dot).
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
appInfoSetAsDefaultForExtension appinfo extension = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    extension' <- stringToCString extension
    onException (do
        _ <- propagateGError $ g_app_info_set_as_default_for_extension appinfo' extension'
        touchManagedPtr appinfo
        freeMem extension'
        return ()
     ) (do
        freeMem extension'
     )

#if defined(ENABLE_OVERLOADING)
data AppInfoSetAsDefaultForExtensionMethodInfo
instance (signature ~ ([Char] -> m ()), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoSetAsDefaultForExtensionMethodInfo a signature where
    overloadedMethod = appInfoSetAsDefaultForExtension

instance O.OverloadedMethodInfo AppInfoSetAsDefaultForExtensionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoSetAsDefaultForExtension",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoSetAsDefaultForExtension"
        })


#endif

-- method AppInfo::set_as_default_for_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the content type." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_set_as_default_for_type" g_app_info_set_as_default_for_type :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    CString ->                              -- content_type : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Sets the application as the default handler for a given type.
appInfoSetAsDefaultForType ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> T.Text
    -- ^ /@contentType@/: the content type.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
appInfoSetAsDefaultForType appinfo contentType = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    contentType' <- textToCString contentType
    onException (do
        _ <- propagateGError $ g_app_info_set_as_default_for_type appinfo' contentType'
        touchManagedPtr appinfo
        freeMem contentType'
        return ()
     ) (do
        freeMem contentType'
     )

#if defined(ENABLE_OVERLOADING)
data AppInfoSetAsDefaultForTypeMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoSetAsDefaultForTypeMethodInfo a signature where
    overloadedMethod = appInfoSetAsDefaultForType

instance O.OverloadedMethodInfo AppInfoSetAsDefaultForTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoSetAsDefaultForType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoSetAsDefaultForType"
        })


#endif

-- method AppInfo::set_as_last_used_for_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the content type." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_set_as_last_used_for_type" g_app_info_set_as_last_used_for_type :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    CString ->                              -- content_type : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Sets the application as the last used application for a given type. This
-- will make the application appear as first in the list returned by
-- [func/@gio@/.AppInfo.get_recommended_for_type], regardless of the default
-- application for that content type.
appInfoSetAsLastUsedForType ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> T.Text
    -- ^ /@contentType@/: the content type.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
appInfoSetAsLastUsedForType appinfo contentType = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    contentType' <- textToCString contentType
    onException (do
        _ <- propagateGError $ g_app_info_set_as_last_used_for_type appinfo' contentType'
        touchManagedPtr appinfo
        freeMem contentType'
        return ()
     ) (do
        freeMem contentType'
     )

#if defined(ENABLE_OVERLOADING)
data AppInfoSetAsLastUsedForTypeMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoSetAsLastUsedForTypeMethodInfo a signature where
    overloadedMethod = appInfoSetAsLastUsedForType

instance O.OverloadedMethodInfo AppInfoSetAsLastUsedForTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoSetAsLastUsedForType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoSetAsLastUsedForType"
        })


#endif

-- method AppInfo::should_show
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_should_show" g_app_info_should_show :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CInt

-- | Checks if the application info should be shown in menus that
-- list available applications.
appInfoShouldShow ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the /@appinfo@/ should be shown, @FALSE@ otherwise.
appInfoShouldShow appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_should_show appinfo'
    let result' = (/= 0) result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoShouldShowMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoShouldShowMethodInfo a signature where
    overloadedMethod = appInfoShouldShow

instance O.OverloadedMethodInfo AppInfoShouldShowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoShouldShow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoShouldShow"
        })


#endif

-- method AppInfo::supports_files
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_supports_files" g_app_info_supports_files :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CInt

-- | Checks if the application accepts files as arguments.
appInfoSupportsFiles ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the /@appinfo@/ supports files.
appInfoSupportsFiles appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_supports_files appinfo'
    let result' = (/= 0) result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoSupportsFilesMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoSupportsFilesMethodInfo a signature where
    overloadedMethod = appInfoSupportsFiles

instance O.OverloadedMethodInfo AppInfoSupportsFilesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoSupportsFiles",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoSupportsFiles"
        })


#endif

-- method AppInfo::supports_uris
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the app info" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_supports_uris" g_app_info_supports_uris :: 
    Ptr AppInfo ->                          -- appinfo : TInterface (Name {namespace = "Gio", name = "AppInfo"})
    IO CInt

-- | Checks if the application supports reading files and directories from URIs.
appInfoSupportsUris ::
    (B.CallStack.HasCallStack, MonadIO m, IsAppInfo a) =>
    a
    -- ^ /@appinfo@/: the app info
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the /@appinfo@/ supports URIs.
appInfoSupportsUris appinfo = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    result <- g_app_info_supports_uris appinfo'
    let result' = (/= 0) result
    touchManagedPtr appinfo
    return result'

#if defined(ENABLE_OVERLOADING)
data AppInfoSupportsUrisMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAppInfo a) => O.OverloadedMethod AppInfoSupportsUrisMethodInfo a signature where
    overloadedMethod = appInfoSupportsUris

instance O.OverloadedMethodInfo AppInfoSupportsUrisMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.AppInfo.appInfoSupportsUris",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.35/docs/GI-Gio-Interfaces-AppInfo.html#v:appInfoSupportsUris"
        })


#endif

-- method AppInfo::create_from_commandline
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "commandline"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the command line to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "application_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the application name, or `NULL` to use @commandline"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppInfoCreateFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "flags that can specify details of the created [iface@Gio.AppInfo]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "AppInfo" })
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_create_from_commandline" g_app_info_create_from_commandline :: 
    CString ->                              -- commandline : TBasicType TFileName
    CString ->                              -- application_name : TBasicType TUTF8
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "AppInfoCreateFlags"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr AppInfo)

-- | Creates a new t'GI.Gio.Interfaces.AppInfo.AppInfo' from the given information.
-- 
-- Note that for /@commandline@/, the quoting rules of the @Exec@ key of the
-- <http://freedesktop.org/Standards/desktop-entry-spec freedesktop.org Desktop Entry Specification>
-- are applied. For example, if the /@commandline@/ contains
-- percent-encoded URIs, the percent-character must be doubled in order to prevent it from
-- being swallowed by @Exec@ key unquoting. See
-- <https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s07.html the specification>
-- for exact quoting rules.
appInfoCreateFromCommandline ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@commandline@/: the command line to use
    -> Maybe (T.Text)
    -- ^ /@applicationName@/: the application name, or @NULL@ to use /@commandline@/
    -> [Gio.Flags.AppInfoCreateFlags]
    -- ^ /@flags@/: flags that can specify details of the created t'GI.Gio.Interfaces.AppInfo.AppInfo'
    -> m AppInfo
    -- ^ __Returns:__ new t'GI.Gio.Interfaces.AppInfo.AppInfo' for given command. /(Can throw 'Data.GI.Base.GError.GError')/
appInfoCreateFromCommandline commandline applicationName flags = liftIO $ do
    commandline' <- stringToCString commandline
    maybeApplicationName <- case applicationName of
        Nothing -> return FP.nullPtr
        Just jApplicationName -> do
            jApplicationName' <- textToCString jApplicationName
            return jApplicationName'
    let flags' = gflagsToWord flags
    onException (do
        result <- propagateGError $ g_app_info_create_from_commandline commandline' maybeApplicationName flags'
        checkUnexpectedReturnNULL "appInfoCreateFromCommandline" result
        result' <- (wrapObject AppInfo) result
        freeMem commandline'
        freeMem maybeApplicationName
        return result'
     ) (do
        freeMem commandline'
        freeMem maybeApplicationName
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::get_all
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gio" , name = "AppInfo" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_all" g_app_info_get_all :: 
    IO (Ptr (GList (Ptr AppInfo)))

-- | Gets a list of all of the applications currently registered
-- on this system.
-- 
-- For desktop files, this includes applications that have
-- <https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s06.html#key-nodisplay `NoDisplay=true`>
-- set or are excluded from display by means of
-- <https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s06.html#key-onlyshowin `OnlyShowIn`>
-- or <https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s06.html#key-notshowin `NotShowIn`>.
-- See 'GI.Gio.Interfaces.AppInfo.appInfoShouldShow'.
-- 
-- The returned list does not include applications which have the
-- <https://specifications.freedesktop.org/desktop-entry-spec/latest/ar01s06.html#key-hidden `Hidden` key>
-- set.
appInfoGetAll ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [AppInfo]
    -- ^ __Returns:__ a newly allocated
    --   list of references to t'GI.Gio.Interfaces.AppInfo.AppInfo's.
appInfoGetAll  = liftIO $ do
    result <- g_app_info_get_all
    result' <- unpackGList result
    result'' <- mapM (wrapObject AppInfo) result'
    g_list_free result
    return result''

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::get_all_for_type
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the content type to find a [iface@Gio.AppInfo] for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gio" , name = "AppInfo" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_all_for_type" g_app_info_get_all_for_type :: 
    CString ->                              -- content_type : TBasicType TUTF8
    IO (Ptr (GList (Ptr AppInfo)))

-- | Gets a list of all t'GI.Gio.Interfaces.AppInfo.AppInfo's for a given content type,
-- including the recommended and fallback t'GI.Gio.Interfaces.AppInfo.AppInfo's. See
-- [func/@gio@/.AppInfo.get_recommended_for_type] and
-- [func/@gio@/.AppInfo.get_fallback_for_type].
appInfoGetAllForType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@contentType@/: the content type to find a t'GI.Gio.Interfaces.AppInfo.AppInfo' for
    -> m [AppInfo]
    -- ^ __Returns:__ list of
    --   t'GI.Gio.Interfaces.AppInfo.AppInfo's for given /@contentType@/.
appInfoGetAllForType contentType = liftIO $ do
    contentType' <- textToCString contentType
    result <- g_app_info_get_all_for_type contentType'
    result' <- unpackGList result
    result'' <- mapM (wrapObject AppInfo) result'
    g_list_free result
    freeMem contentType'
    return result''

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::get_default_for_type
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the content type to find a [iface@Gio.AppInfo] for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "must_support_uris"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if `TRUE`, the [iface@Gio.AppInfo] is expected to\n  support URIs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "AppInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_default_for_type" g_app_info_get_default_for_type :: 
    CString ->                              -- content_type : TBasicType TUTF8
    CInt ->                                 -- must_support_uris : TBasicType TBoolean
    IO (Ptr AppInfo)

-- | Gets the default t'GI.Gio.Interfaces.AppInfo.AppInfo' for a given content type.
appInfoGetDefaultForType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@contentType@/: the content type to find a t'GI.Gio.Interfaces.AppInfo.AppInfo' for
    -> Bool
    -- ^ /@mustSupportUris@/: if @TRUE@, the t'GI.Gio.Interfaces.AppInfo.AppInfo' is expected to
    --   support URIs
    -> m (Maybe AppInfo)
    -- ^ __Returns:__ t'GI.Gio.Interfaces.AppInfo.AppInfo' for given
    --   /@contentType@/ or @NULL@ on error.
appInfoGetDefaultForType contentType mustSupportUris = liftIO $ do
    contentType' <- textToCString contentType
    let mustSupportUris' = (P.fromIntegral . P.fromEnum) mustSupportUris
    result <- g_app_info_get_default_for_type contentType' mustSupportUris'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject AppInfo) result'
        return result''
    freeMem contentType'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::get_default_for_type_async
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the content type to find a [iface@Gio.AppInfo] for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "must_support_uris"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if `TRUE`, the [iface@Gio.AppInfo] is expected to\n  support URIs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.Cancellable]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a [type@Gio.AsyncReadyCallback] to call\n  when the request is done"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_default_for_type_async" g_app_info_get_default_for_type_async :: 
    CString ->                              -- content_type : TBasicType TUTF8
    CInt ->                                 -- must_support_uris : TBasicType TBoolean
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously gets the default t'GI.Gio.Interfaces.AppInfo.AppInfo' for a given content
-- type.
-- 
-- /Since: 2.74/
appInfoGetDefaultForTypeAsync ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Cancellable.IsCancellable a) =>
    T.Text
    -- ^ /@contentType@/: the content type to find a t'GI.Gio.Interfaces.AppInfo.AppInfo' for
    -> Bool
    -- ^ /@mustSupportUris@/: if @TRUE@, the t'GI.Gio.Interfaces.AppInfo.AppInfo' is expected to
    --   support URIs
    -> Maybe (a)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a [type/@gio@/.AsyncReadyCallback] to call
    --   when the request is done
    -> m ()
appInfoGetDefaultForTypeAsync contentType mustSupportUris cancellable callback = liftIO $ do
    contentType' <- textToCString contentType
    let mustSupportUris' = (P.fromIntegral . P.fromEnum) mustSupportUris
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_app_info_get_default_for_type_async contentType' mustSupportUris' maybeCancellable maybeCallback userData
    whenJust cancellable touchManagedPtr
    freeMem contentType'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::get_default_for_type_finish
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the async result" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "AppInfo" })
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_get_default_for_type_finish" g_app_info_get_default_for_type_finish :: 
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr AppInfo)

-- | Finishes a default t'GI.Gio.Interfaces.AppInfo.AppInfo' lookup started by
-- [func/@gio@/.AppInfo.get_default_for_type_async].
-- 
-- If no #t'GI.Gio.Interfaces.AppInfo.AppInfo' is found, then /@error@/ will be set to
-- [error/@gio@/.IOErrorEnum.NOT_FOUND].
-- 
-- /Since: 2.74/
appInfoGetDefaultForTypeFinish ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AsyncResult.IsAsyncResult a) =>
    a
    -- ^ /@result@/: the async result
    -> m AppInfo
    -- ^ __Returns:__ t'GI.Gio.Interfaces.AppInfo.AppInfo' for given /@contentType@/ or
    --   @NULL@ on error. /(Can throw 'Data.GI.Base.GError.GError')/
appInfoGetDefaultForTypeFinish result_ = liftIO $ do
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_app_info_get_default_for_type_finish result_'
        checkUnexpectedReturnNULL "appInfoGetDefaultForTypeFinish" result
        result' <- (wrapObject AppInfo) result
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::get_default_for_uri_scheme
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "uri_scheme"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string containing a URI scheme."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "AppInfo" })
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_default_for_uri_scheme" g_app_info_get_default_for_uri_scheme :: 
    CString ->                              -- uri_scheme : TBasicType TUTF8
    IO (Ptr AppInfo)

-- | Gets the default application for handling URIs with the given URI scheme.
-- 
-- A URI scheme is the initial part of the URI, up to but not including the @:@.
-- For example, @http@, @ftp@ or @sip@.
appInfoGetDefaultForUriScheme ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@uriScheme@/: a string containing a URI scheme.
    -> m (Maybe AppInfo)
    -- ^ __Returns:__ t'GI.Gio.Interfaces.AppInfo.AppInfo' for given
    --   /@uriScheme@/ or @NULL@ on error.
appInfoGetDefaultForUriScheme uriScheme = liftIO $ do
    uriScheme' <- textToCString uriScheme
    result <- g_app_info_get_default_for_uri_scheme uriScheme'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject AppInfo) result'
        return result''
    freeMem uriScheme'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::get_default_for_uri_scheme_async
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "uri_scheme"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string containing a URI scheme."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.Cancellable]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a [type@Gio.AsyncReadyCallback] to call\n  when the request is done"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_default_for_uri_scheme_async" g_app_info_get_default_for_uri_scheme_async :: 
    CString ->                              -- uri_scheme : TBasicType TUTF8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously gets the default application for handling URIs with
-- the given URI scheme. A URI scheme is the initial part
-- of the URI, up to but not including the @:@, e.g. @http@,
-- @ftp@ or @sip@.
-- 
-- /Since: 2.74/
appInfoGetDefaultForUriSchemeAsync ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Cancellable.IsCancellable a) =>
    T.Text
    -- ^ /@uriScheme@/: a string containing a URI scheme.
    -> Maybe (a)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a [type/@gio@/.AsyncReadyCallback] to call
    --   when the request is done
    -> m ()
appInfoGetDefaultForUriSchemeAsync uriScheme cancellable callback = liftIO $ do
    uriScheme' <- textToCString uriScheme
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_app_info_get_default_for_uri_scheme_async uriScheme' maybeCancellable maybeCallback userData
    whenJust cancellable touchManagedPtr
    freeMem uriScheme'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::get_default_for_uri_scheme_finish
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the async result" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "AppInfo" })
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_get_default_for_uri_scheme_finish" g_app_info_get_default_for_uri_scheme_finish :: 
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr AppInfo)

-- | Finishes a default t'GI.Gio.Interfaces.AppInfo.AppInfo' lookup started by
-- [func/@gio@/.AppInfo.get_default_for_uri_scheme_async].
-- 
-- If no t'GI.Gio.Interfaces.AppInfo.AppInfo' is found, then /@error@/ will be set to
-- [error/@gio@/.IOErrorEnum.NOT_FOUND].
-- 
-- /Since: 2.74/
appInfoGetDefaultForUriSchemeFinish ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AsyncResult.IsAsyncResult a) =>
    a
    -- ^ /@result@/: the async result
    -> m AppInfo
    -- ^ __Returns:__ t'GI.Gio.Interfaces.AppInfo.AppInfo' for given /@uriScheme@/ or
    --   @NULL@ on error. /(Can throw 'Data.GI.Base.GError.GError')/
appInfoGetDefaultForUriSchemeFinish result_ = liftIO $ do
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ g_app_info_get_default_for_uri_scheme_finish result_'
        checkUnexpectedReturnNULL "appInfoGetDefaultForUriSchemeFinish" result
        result' <- (wrapObject AppInfo) result
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::get_fallback_for_type
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the content type to find a [iface@Gio.AppInfo] for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gio" , name = "AppInfo" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_fallback_for_type" g_app_info_get_fallback_for_type :: 
    CString ->                              -- content_type : TBasicType TUTF8
    IO (Ptr (GList (Ptr AppInfo)))

-- | Gets a list of fallback t'GI.Gio.Interfaces.AppInfo.AppInfo's for a given content type, i.e.
-- those applications which claim to support the given content type by MIME
-- type subclassing and not directly.
-- 
-- /Since: 2.28/
appInfoGetFallbackForType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@contentType@/: the content type to find a t'GI.Gio.Interfaces.AppInfo.AppInfo' for
    -> m [AppInfo]
    -- ^ __Returns:__ list of t'GI.Gio.Interfaces.AppInfo.AppInfo's
    --     for given /@contentType@/ or @NULL@ on error.
appInfoGetFallbackForType contentType = liftIO $ do
    contentType' <- textToCString contentType
    result <- g_app_info_get_fallback_for_type contentType'
    result' <- unpackGList result
    result'' <- mapM (wrapObject AppInfo) result'
    g_list_free result
    freeMem contentType'
    return result''

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::get_recommended_for_type
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the content type to find a [iface@Gio.AppInfo] for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gio" , name = "AppInfo" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_get_recommended_for_type" g_app_info_get_recommended_for_type :: 
    CString ->                              -- content_type : TBasicType TUTF8
    IO (Ptr (GList (Ptr AppInfo)))

-- | Gets a list of recommended t'GI.Gio.Interfaces.AppInfo.AppInfo's for a given content type,
-- i.e. those applications which claim to support the given content type
-- exactly, and not by MIME type subclassing.
-- 
-- Note that the first application of the list is the last used one, i.e.
-- the last one for which 'GI.Gio.Interfaces.AppInfo.appInfoSetAsLastUsedForType' has
-- been called.
-- 
-- /Since: 2.28/
appInfoGetRecommendedForType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@contentType@/: the content type to find a t'GI.Gio.Interfaces.AppInfo.AppInfo' for
    -> m [AppInfo]
    -- ^ __Returns:__ list of
    --   t'GI.Gio.Interfaces.AppInfo.AppInfo's for given /@contentType@/ or @NULL@ on error.
appInfoGetRecommendedForType contentType = liftIO $ do
    contentType' <- textToCString contentType
    result <- g_app_info_get_recommended_for_type contentType'
    result' <- unpackGList result
    result'' <- mapM (wrapObject AppInfo) result'
    g_list_free result
    freeMem contentType'
    return result''

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::launch_default_for_uri
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the uri to show" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppLaunchContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional launch context"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_launch_default_for_uri" g_app_info_launch_default_for_uri :: 
    CString ->                              -- uri : TBasicType TUTF8
    Ptr Gio.AppLaunchContext.AppLaunchContext -> -- context : TInterface (Name {namespace = "Gio", name = "AppLaunchContext"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Utility function that launches the default application registered to handle
-- the specified uri. Synchronous I\/O is done on the uri to detect the type of
-- the file if required.
-- 
-- The D-Bus–activated applications don’t have to be started if your application
-- terminates too soon after this function. To prevent this, use
-- [func/@gio@/.AppInfo.launch_default_for_uri_async] instead.
appInfoLaunchDefaultForUri ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AppLaunchContext.IsAppLaunchContext a) =>
    T.Text
    -- ^ /@uri@/: the uri to show
    -> Maybe (a)
    -- ^ /@context@/: optional launch context
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
appInfoLaunchDefaultForUri uri context = liftIO $ do
    uri' <- textToCString uri
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrCastPtr jContext
            return jContext'
    onException (do
        _ <- propagateGError $ g_app_info_launch_default_for_uri uri' maybeContext
        whenJust context touchManagedPtr
        freeMem uri'
        return ()
     ) (do
        freeMem uri'
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::launch_default_for_uri_async
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the uri to show" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AppLaunchContext" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional launch context"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [class@Gio.Cancellable]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a [type@Gio.AsyncReadyCallback] to call\n  when the request is done"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_launch_default_for_uri_async" g_app_info_launch_default_for_uri_async :: 
    CString ->                              -- uri : TBasicType TUTF8
    Ptr Gio.AppLaunchContext.AppLaunchContext -> -- context : TInterface (Name {namespace = "Gio", name = "AppLaunchContext"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Async version of [func/@gio@/.AppInfo.launch_default_for_uri].
-- 
-- This version is useful if you are interested in receiving error information
-- in the case where the application is sandboxed and the portal may present an
-- application chooser dialog to the user.
-- 
-- This is also useful if you want to be sure that the D-Bus–activated
-- applications are really started before termination and if you are interested
-- in receiving error information from their activation.
-- 
-- /Since: 2.50/
appInfoLaunchDefaultForUriAsync ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AppLaunchContext.IsAppLaunchContext a, Gio.Cancellable.IsCancellable b) =>
    T.Text
    -- ^ /@uri@/: the uri to show
    -> Maybe (a)
    -- ^ /@context@/: optional launch context
    -> Maybe (b)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a [type/@gio@/.AsyncReadyCallback] to call
    --   when the request is done
    -> m ()
appInfoLaunchDefaultForUriAsync uri context cancellable callback = liftIO $ do
    uri' <- textToCString uri
    maybeContext <- case context of
        Nothing -> return FP.nullPtr
        Just jContext -> do
            jContext' <- unsafeManagedPtrCastPtr jContext
            return jContext'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_app_info_launch_default_for_uri_async uri' maybeContext maybeCancellable maybeCallback userData
    whenJust context touchManagedPtr
    whenJust cancellable touchManagedPtr
    freeMem uri'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::launch_default_for_uri_finish
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the async result" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_app_info_launch_default_for_uri_finish" g_app_info_launch_default_for_uri_finish :: 
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes an asynchronous launch-default-for-uri operation.
-- 
-- /Since: 2.50/
appInfoLaunchDefaultForUriFinish ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AsyncResult.IsAsyncResult a) =>
    a
    -- ^ /@result@/: the async result
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
appInfoLaunchDefaultForUriFinish result_ = liftIO $ do
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ g_app_info_launch_default_for_uri_finish result_'
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
#endif

-- method AppInfo::reset_type_associations
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "content_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_app_info_reset_type_associations" g_app_info_reset_type_associations :: 
    CString ->                              -- content_type : TBasicType TUTF8
    IO ()

-- | Removes all changes to the type associations done by
-- 'GI.Gio.Interfaces.AppInfo.appInfoSetAsDefaultForType',
-- 'GI.Gio.Interfaces.AppInfo.appInfoSetAsDefaultForExtension',
-- 'GI.Gio.Interfaces.AppInfo.appInfoAddSupportsType' or
-- 'GI.Gio.Interfaces.AppInfo.appInfoRemoveSupportsType'.
-- 
-- /Since: 2.20/
appInfoResetTypeAssociations ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@contentType@/: a content type
    -> m ()
appInfoResetTypeAssociations contentType = liftIO $ do
    contentType' <- textToCString contentType
    g_app_info_reset_type_associations contentType'
    freeMem contentType'
    return ()

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AppInfo = AppInfoSignalList
type AppInfoSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


