

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Functions
    ( 

 -- * Methods


-- ** busGet #method:busGet#

    busGet                                  ,


-- ** busGetFinish #method:busGetFinish#

    busGetFinish                            ,


-- ** busGetSync #method:busGetSync#

    busGetSync                              ,


-- ** busOwnName #method:busOwnName#

    busOwnName                              ,


-- ** busOwnNameOnConnection #method:busOwnNameOnConnection#

    busOwnNameOnConnection                  ,


-- ** busUnownName #method:busUnownName#

    busUnownName                            ,


-- ** busUnwatchName #method:busUnwatchName#

    busUnwatchName                          ,


-- ** busWatchName #method:busWatchName#

    busWatchName                            ,


-- ** busWatchNameOnConnection #method:busWatchNameOnConnection#

    busWatchNameOnConnection                ,


-- ** contentTypeCanBeExecutable #method:contentTypeCanBeExecutable#

    contentTypeCanBeExecutable              ,


-- ** contentTypeEquals #method:contentTypeEquals#

    contentTypeEquals                       ,


-- ** contentTypeFromMimeType #method:contentTypeFromMimeType#

    contentTypeFromMimeType                 ,


-- ** contentTypeGetDescription #method:contentTypeGetDescription#

    contentTypeGetDescription               ,


-- ** contentTypeGetGenericIconName #method:contentTypeGetGenericIconName#

    contentTypeGetGenericIconName           ,


-- ** contentTypeGetIcon #method:contentTypeGetIcon#

    contentTypeGetIcon                      ,


-- ** contentTypeGetMimeDirs #method:contentTypeGetMimeDirs#

    contentTypeGetMimeDirs                  ,


-- ** contentTypeGetMimeType #method:contentTypeGetMimeType#

    contentTypeGetMimeType                  ,


-- ** contentTypeGetSymbolicIcon #method:contentTypeGetSymbolicIcon#

    contentTypeGetSymbolicIcon              ,


-- ** contentTypeGuess #method:contentTypeGuess#

    contentTypeGuess                        ,


-- ** contentTypeGuessForTree #method:contentTypeGuessForTree#

    contentTypeGuessForTree                 ,


-- ** contentTypeIsA #method:contentTypeIsA#

    contentTypeIsA                          ,


-- ** contentTypeIsMimeType #method:contentTypeIsMimeType#

    contentTypeIsMimeType                   ,


-- ** contentTypeIsUnknown #method:contentTypeIsUnknown#

    contentTypeIsUnknown                    ,


-- ** contentTypeSetMimeDirs #method:contentTypeSetMimeDirs#

    contentTypeSetMimeDirs                  ,


-- ** contentTypesGetRegistered #method:contentTypesGetRegistered#

    contentTypesGetRegistered               ,


-- ** dbusAddressEscapeValue #method:dbusAddressEscapeValue#

    dbusAddressEscapeValue                  ,


-- ** dbusAddressGetForBusSync #method:dbusAddressGetForBusSync#

    dbusAddressGetForBusSync                ,


-- ** dbusAddressGetStream #method:dbusAddressGetStream#

    dbusAddressGetStream                    ,


-- ** dbusAddressGetStreamFinish #method:dbusAddressGetStreamFinish#

    dbusAddressGetStreamFinish              ,


-- ** dbusAddressGetStreamSync #method:dbusAddressGetStreamSync#

    dbusAddressGetStreamSync                ,


-- ** dbusEscapeObjectPath #method:dbusEscapeObjectPath#

    dbusEscapeObjectPath                    ,


-- ** dbusEscapeObjectPathBytestring #method:dbusEscapeObjectPathBytestring#

    dbusEscapeObjectPathBytestring          ,


-- ** dbusGenerateGuid #method:dbusGenerateGuid#

    dbusGenerateGuid                        ,


-- ** dbusGvalueToGvariant #method:dbusGvalueToGvariant#

    dbusGvalueToGvariant                    ,


-- ** dbusGvariantToGvalue #method:dbusGvariantToGvalue#

    dbusGvariantToGvalue                    ,


-- ** dbusIsAddress #method:dbusIsAddress#

    dbusIsAddress                           ,


-- ** dbusIsErrorName #method:dbusIsErrorName#

    dbusIsErrorName                         ,


-- ** dbusIsGuid #method:dbusIsGuid#

    dbusIsGuid                              ,


-- ** dbusIsInterfaceName #method:dbusIsInterfaceName#

    dbusIsInterfaceName                     ,


-- ** dbusIsMemberName #method:dbusIsMemberName#

    dbusIsMemberName                        ,


-- ** dbusIsName #method:dbusIsName#

    dbusIsName                              ,


-- ** dbusIsSupportedAddress #method:dbusIsSupportedAddress#

    dbusIsSupportedAddress                  ,


-- ** dbusIsUniqueName #method:dbusIsUniqueName#

    dbusIsUniqueName                        ,


-- ** dbusUnescapeObjectPath #method:dbusUnescapeObjectPath#

    dbusUnescapeObjectPath                  ,


-- ** ioErrorFromErrno #method:ioErrorFromErrno#

    ioErrorFromErrno                        ,


-- ** ioErrorFromFileError #method:ioErrorFromFileError#

    ioErrorFromFileError                    ,


-- ** ioErrorQuark #method:ioErrorQuark#

    ioErrorQuark                            ,


-- ** ioModulesScanAllInDirectory #method:ioModulesScanAllInDirectory#

    ioModulesScanAllInDirectory             ,


-- ** ioModulesScanAllInDirectoryWithScope #method:ioModulesScanAllInDirectoryWithScope#

    ioModulesScanAllInDirectoryWithScope    ,


-- ** ioSchedulerCancelAllJobs #method:ioSchedulerCancelAllJobs#

    ioSchedulerCancelAllJobs                ,


-- ** ioSchedulerPushJob #method:ioSchedulerPushJob#

    ioSchedulerPushJob                      ,


-- ** keyfileSettingsBackendNew #method:keyfileSettingsBackendNew#

    keyfileSettingsBackendNew               ,


-- ** memorySettingsBackendNew #method:memorySettingsBackendNew#

    memorySettingsBackendNew                ,


-- ** networkingInit #method:networkingInit#

    networkingInit                          ,


-- ** nullSettingsBackendNew #method:nullSettingsBackendNew#

    nullSettingsBackendNew                  ,


-- ** pollableSourceNew #method:pollableSourceNew#

    pollableSourceNew                       ,


-- ** pollableSourceNewFull #method:pollableSourceNewFull#

    pollableSourceNewFull                   ,


-- ** pollableStreamRead #method:pollableStreamRead#

    pollableStreamRead                      ,


-- ** pollableStreamWrite #method:pollableStreamWrite#

    pollableStreamWrite                     ,


-- ** pollableStreamWriteAll #method:pollableStreamWriteAll#

    pollableStreamWriteAll                  ,


-- ** resourcesEnumerateChildren #method:resourcesEnumerateChildren#

    resourcesEnumerateChildren              ,


-- ** resourcesGetInfo #method:resourcesGetInfo#

    resourcesGetInfo                        ,


-- ** resourcesHasChildren #method:resourcesHasChildren#

    resourcesHasChildren                    ,


-- ** resourcesLookupData #method:resourcesLookupData#

    resourcesLookupData                     ,


-- ** resourcesOpenStream #method:resourcesOpenStream#

    resourcesOpenStream                     ,


-- ** resourcesRegister #method:resourcesRegister#

    resourcesRegister                       ,


-- ** resourcesUnregister #method:resourcesUnregister#

    resourcesUnregister                     ,


-- ** simpleAsyncReportGerrorInIdle #method:simpleAsyncReportGerrorInIdle#

    simpleAsyncReportGerrorInIdle           ,


-- ** unixIsMountPathSystemInternal #method:unixIsMountPathSystemInternal#

    unixIsMountPathSystemInternal           ,


-- ** unixIsSystemDevicePath #method:unixIsSystemDevicePath#

    unixIsSystemDevicePath                  ,


-- ** unixIsSystemFsType #method:unixIsSystemFsType#

    unixIsSystemFsType                      ,


-- ** unixMountAt #method:unixMountAt#

    unixMountAt                             ,


-- ** unixMountCompare #method:unixMountCompare#

    unixMountCompare                        ,


-- ** unixMountCopy #method:unixMountCopy#

    unixMountCopy                           ,


-- ** unixMountEntriesChangedSince #method:unixMountEntriesChangedSince#

    unixMountEntriesChangedSince            ,


-- ** unixMountEntriesGet #method:unixMountEntriesGet#

    unixMountEntriesGet                     ,


-- ** unixMountFor #method:unixMountFor#

    unixMountFor                            ,


-- ** unixMountFree #method:unixMountFree#

    unixMountFree                           ,


-- ** unixMountGetDevicePath #method:unixMountGetDevicePath#

    unixMountGetDevicePath                  ,


-- ** unixMountGetFsType #method:unixMountGetFsType#

    unixMountGetFsType                      ,


-- ** unixMountGetMountPath #method:unixMountGetMountPath#

    unixMountGetMountPath                   ,


-- ** unixMountGetOptions #method:unixMountGetOptions#

    unixMountGetOptions                     ,


-- ** unixMountGetRootPath #method:unixMountGetRootPath#

    unixMountGetRootPath                    ,


-- ** unixMountGuessCanEject #method:unixMountGuessCanEject#

    unixMountGuessCanEject                  ,


-- ** unixMountGuessIcon #method:unixMountGuessIcon#

    unixMountGuessIcon                      ,


-- ** unixMountGuessName #method:unixMountGuessName#

    unixMountGuessName                      ,


-- ** unixMountGuessShouldDisplay #method:unixMountGuessShouldDisplay#

    unixMountGuessShouldDisplay             ,


-- ** unixMountGuessSymbolicIcon #method:unixMountGuessSymbolicIcon#

    unixMountGuessSymbolicIcon              ,


-- ** unixMountIsReadonly #method:unixMountIsReadonly#

    unixMountIsReadonly                     ,


-- ** unixMountIsSystemInternal #method:unixMountIsSystemInternal#

    unixMountIsSystemInternal               ,


-- ** unixMountPointsChangedSince #method:unixMountPointsChangedSince#

    unixMountPointsChangedSince             ,


-- ** unixMountPointsGet #method:unixMountPointsGet#

    unixMountPointsGet                      ,


-- ** unixMountsChangedSince #method:unixMountsChangedSince#

    unixMountsChangedSince                  ,


-- ** unixMountsGet #method:unixMountsGet#

    unixMountsGet                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GLib.Structs.Tree as GLib.Tree
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncInitable as Gio.AsyncInitable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusAuthObserver as Gio.DBusAuthObserver
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMessage as Gio.DBusMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.FileEnumerator as Gio.FileEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileMonitor as Gio.FileMonitor
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuAttributeIter as Gio.MenuAttributeIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuLinkIter as Gio.MenuLinkIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SettingsBackend as Gio.SettingsBackend
import {-# SOURCE #-} qualified GI.Gio.Objects.UnixFDList as Gio.UnixFDList
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusMethodInfo as Gio.DBusMethodInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusPropertyInfo as Gio.DBusPropertyInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSignalInfo as Gio.DBusSignalInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSubtreeVTable as Gio.DBusSubtreeVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.IOModuleScope as Gio.IOModuleScope
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector
import {-# SOURCE #-} qualified GI.Gio.Structs.Resource as Gio.Resource
import {-# SOURCE #-} qualified GI.Gio.Structs.UnixMountEntry as Gio.UnixMountEntry
import {-# SOURCE #-} qualified GI.Gio.Structs.UnixMountPoint as Gio.UnixMountPoint

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SettingsBackend as Gio.SettingsBackend
import {-# SOURCE #-} qualified GI.Gio.Structs.IOModuleScope as Gio.IOModuleScope
import {-# SOURCE #-} qualified GI.Gio.Structs.Resource as Gio.Resource
import {-# SOURCE #-} qualified GI.Gio.Structs.UnixMountEntry as Gio.UnixMountEntry
import {-# SOURCE #-} qualified GI.Gio.Structs.UnixMountPoint as Gio.UnixMountPoint

#endif

-- function unix_mounts_get_from_file
-- XXX Could not generate function unix_mounts_get_from_file

-- Not implemented: Don't know how to allocate "time_read_out" of type TBasicType TUInt64

-- function unix_mounts_get
-- Args: [ Arg
--           { argCName = "time_read"
--           , argType = TBasicType TUInt64
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a timestamp"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mounts_get" g_unix_mounts_get :: 
    Ptr Word64 ->                           -- time_read : TBasicType TUInt64
    IO (Ptr (GList (Ptr Gio.UnixMountEntry.UnixMountEntry)))

{-# DEPRECATED unixMountsGet ["(Since version 2.84)","Use @/GioUnix.mount_entries_get/@ instead."] #-}
-- | Gets a list of [struct/@gioUnix@/.MountEntry] instances representing the Unix
-- mounts.
-- 
-- If /@timeRead@/ is set, it will be filled with the mount timestamp, allowing
-- for checking if the mounts have changed with
-- @/GioUnix.mount_entries_changed_since/@.
unixMountsGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (([Gio.UnixMountEntry.UnixMountEntry], Word64))
    -- ^ __Returns:__ a list of the
    --    Unix mounts
unixMountsGet  = liftIO $ do
    timeRead <- allocMem :: IO (Ptr Word64)
    result <- g_unix_mounts_get timeRead
    result' <- unpackGList result
    result'' <- mapM (wrapBoxed Gio.UnixMountEntry.UnixMountEntry) result'
    g_list_free result
    timeRead' <- peek timeRead
    freeMem timeRead
    return (result'', timeRead')


-- function unix_mounts_changed_since
-- Args: [ Arg
--           { argCName = "time"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a timestamp" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mounts_changed_since" g_unix_mounts_changed_since :: 
    Word64 ->                               -- time : TBasicType TUInt64
    IO CInt

{-# DEPRECATED unixMountsChangedSince ["(Since version 2.84)","Use @/GioUnix.mount_entries_changed_since/@ instead."] #-}
-- | Checks if the Unix mounts have changed since a given Unix time.
unixMountsChangedSince ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word64
    -- ^ /@time@/: a timestamp
    -> m Bool
    -- ^ __Returns:__ true if the mounts have changed since /@time@/; false otherwise
unixMountsChangedSince time = liftIO $ do
    result <- g_unix_mounts_changed_since time
    let result' = (/= 0) result
    return result'


-- function unix_mount_points_get_from_file
-- XXX Could not generate function unix_mount_points_get_from_file

-- Not implemented: Don't know how to allocate "time_read_out" of type TBasicType TUInt64

-- function unix_mount_points_get
-- Args: [ Arg
--           { argCName = "time_read"
--           , argType = TBasicType TUInt64
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a timestamp"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gio" , name = "UnixMountPoint" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_points_get" g_unix_mount_points_get :: 
    Ptr Word64 ->                           -- time_read : TBasicType TUInt64
    IO (Ptr (GList (Ptr Gio.UnixMountPoint.UnixMountPoint)))

-- | Gets a list of [struct/@gioUnix@/.MountPoint] instances representing the Unix
-- mount points.
-- 
-- If /@timeRead@/ is set, it will be filled with the mount timestamp, allowing
-- for checking if the mounts have changed with
-- @/GioUnix.mount_points_changed_since/@.
unixMountPointsGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (([Gio.UnixMountPoint.UnixMountPoint], Word64))
    -- ^ __Returns:__ a list of the Unix
    --    mount points
unixMountPointsGet  = liftIO $ do
    timeRead <- allocMem :: IO (Ptr Word64)
    result <- g_unix_mount_points_get timeRead
    result' <- unpackGList result
    result'' <- mapM (wrapBoxed Gio.UnixMountPoint.UnixMountPoint) result'
    g_list_free result
    timeRead' <- peek timeRead
    freeMem timeRead
    return (result'', timeRead')


-- function unix_mount_points_changed_since
-- Args: [ Arg
--           { argCName = "time"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a timestamp" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_points_changed_since" g_unix_mount_points_changed_since :: 
    Word64 ->                               -- time : TBasicType TUInt64
    IO CInt

-- | Checks if the Unix mount points have changed since a given Unix time.
-- 
-- Unlike @/GioUnix.mount_entries_changed_since/@, this function can work
-- reliably without a @/GioUnix.MountMonitor/@ running, as it accesses the
-- static mount point information (such as @\/etc\/fstab@ on Linux), which has a
-- valid modification time.
-- 
-- It is more efficient to use @/GioUnix.MountMonitor::mountpoints-changed/@
-- to be signalled of changes to the mount points, rather than polling using
-- this function. This function is more appropriate for infrequently determining
-- cache validity.
unixMountPointsChangedSince ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word64
    -- ^ /@time@/: a timestamp
    -> m Bool
    -- ^ __Returns:__ true if the mount points have changed since /@time@/; false otherwise
unixMountPointsChangedSince time = liftIO $ do
    result <- g_unix_mount_points_changed_since time
    let result' = (/= 0) result
    return result'


-- function unix_mount_is_system_internal
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_is_system_internal" g_unix_mount_is_system_internal :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO CInt

{-# DEPRECATED unixMountIsSystemInternal ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.is_system_internal] instead."] #-}
-- | Checks if a Unix mount is a system mount.
-- 
-- This is the Boolean OR of
-- @/GioUnix.is_system_fs_type/@, @/GioUnix.is_system_device_path/@ and
-- @/GioUnix.is_mount_path_system_internal/@ on /@mountEntry@/’s properties.
-- 
-- The definition of what a ‘system’ mount entry is may change over time as new
-- file system types and device paths are ignored.
unixMountIsSystemInternal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m Bool
    -- ^ __Returns:__ true if the Unix mount is for a system path; false otherwise
unixMountIsSystemInternal mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_is_system_internal mountEntry'
    let result' = (/= 0) result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_is_readonly
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_is_readonly" g_unix_mount_is_readonly :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO CInt

{-# DEPRECATED unixMountIsReadonly ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.is_readonly] instead."] #-}
-- | Checks if a Unix mount is mounted read only.
unixMountIsReadonly ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m Bool
    -- ^ __Returns:__ true if /@mountEntry@/ is read only; false otherwise
unixMountIsReadonly mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_is_readonly mountEntry'
    let result' = (/= 0) result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_guess_symbolic_icon
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_guess_symbolic_icon" g_unix_mount_guess_symbolic_icon :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO (Ptr Gio.Icon.Icon)

{-# DEPRECATED unixMountGuessSymbolicIcon ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.guess_symbolic_icon] instead."] #-}
-- | Guesses the symbolic icon of a Unix mount entry.
-- 
-- /Since: 2.34/
unixMountGuessSymbolicIcon ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m Gio.Icon.Icon
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Icon.Icon'
unixMountGuessSymbolicIcon mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_guess_symbolic_icon mountEntry'
    checkUnexpectedReturnNULL "unixMountGuessSymbolicIcon" result
    result' <- (wrapObject Gio.Icon.Icon) result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_guess_should_display
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_guess_should_display" g_unix_mount_guess_should_display :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO CInt

{-# DEPRECATED unixMountGuessShouldDisplay ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.guess_should_display] instead."] #-}
-- | Guesses whether a Unix mount entry should be displayed in the UI.
unixMountGuessShouldDisplay ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m Bool
    -- ^ __Returns:__ true if /@mountEntry@/ is deemed to be displayable; false otherwise
unixMountGuessShouldDisplay mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_guess_should_display mountEntry'
    let result' = (/= 0) result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_guess_name
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_guess_name" g_unix_mount_guess_name :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO CString

{-# DEPRECATED unixMountGuessName ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.guess_name] instead."] #-}
-- | Guesses the name of a Unix mount entry.
-- 
-- The result is a translated string.
unixMountGuessName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m T.Text
    -- ^ __Returns:__ a newly allocated translated string
unixMountGuessName mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_guess_name mountEntry'
    checkUnexpectedReturnNULL "unixMountGuessName" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_guess_icon
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_guess_icon" g_unix_mount_guess_icon :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO (Ptr Gio.Icon.Icon)

{-# DEPRECATED unixMountGuessIcon ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.guess_icon] instead."] #-}
-- | Guesses the icon of a Unix mount entry.
unixMountGuessIcon ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m Gio.Icon.Icon
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Icon.Icon'
unixMountGuessIcon mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_guess_icon mountEntry'
    checkUnexpectedReturnNULL "unixMountGuessIcon" result
    result' <- (wrapObject Gio.Icon.Icon) result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_guess_can_eject
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_guess_can_eject" g_unix_mount_guess_can_eject :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO CInt

{-# DEPRECATED unixMountGuessCanEject ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.guess_can_eject] instead."] #-}
-- | Guesses whether a Unix mount entry can be ejected.
unixMountGuessCanEject ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m Bool
    -- ^ __Returns:__ true if /@mountEntry@/ is deemed to be ejectable; false otherwise
unixMountGuessCanEject mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_guess_can_eject mountEntry'
    let result' = (/= 0) result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_get_root_path
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_get_root_path" g_unix_mount_get_root_path :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO CString

{-# DEPRECATED unixMountGetRootPath ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.get_root_path] instead."] #-}
-- | Gets the root of the mount within the filesystem. This is useful e.g. for
-- mounts created by bind operation, or btrfs subvolumes.
-- 
-- For example, the root path is equal to @\/@ for a mount created by
-- @mount \/dev\/sda1 \/mnt\/foo@ and @\/bar@ for
-- @mount --bind \/mnt\/foo\/bar \/mnt\/bar@.
-- 
-- /Since: 2.60/
unixMountGetRootPath ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a string containing the root, or @NULL@ if not supported
unixMountGetRootPath mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_get_root_path mountEntry'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr mountEntry
    return maybeResult


-- function unix_mount_get_options
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_get_options" g_unix_mount_get_options :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO CString

{-# DEPRECATED unixMountGetOptions ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.get_options] instead."] #-}
-- | Gets a comma separated list of mount options for the Unix mount.
-- 
-- For example: @rw,relatime,seclabel,data=ordered@.
-- 
-- This is similar to [func/@gioUnix@/.MountPoint.get_options], but it takes
-- a [struct/@gioUnix@/.MountEntry] as an argument.
-- 
-- /Since: 2.58/
unixMountGetOptions ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m (Maybe T.Text)
    -- ^ __Returns:__ a string containing the options, or @NULL@ if not
    --    available.
unixMountGetOptions mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_get_options mountEntry'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr mountEntry
    return maybeResult


-- function unix_mount_get_mount_path
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a [struct@GioUnix.MountEntry] to get the mount path for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_get_mount_path" g_unix_mount_get_mount_path :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO CString

{-# DEPRECATED unixMountGetMountPath ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.get_mount_path] instead."] #-}
-- | Gets the mount path for a Unix mount.
unixMountGetMountPath ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry] to get the mount path for
    -> m [Char]
    -- ^ __Returns:__ the mount path for /@mountEntry@/
unixMountGetMountPath mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_get_mount_path mountEntry'
    checkUnexpectedReturnNULL "unixMountGetMountPath" result
    result' <- cstringToString result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_get_fs_type
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_get_fs_type" g_unix_mount_get_fs_type :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO CString

{-# DEPRECATED unixMountGetFsType ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.get_fs_type] instead."] #-}
-- | Gets the filesystem type for the Unix mount.
unixMountGetFsType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m T.Text
    -- ^ __Returns:__ a string containing the file system type
unixMountGetFsType mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_get_fs_type mountEntry'
    checkUnexpectedReturnNULL "unixMountGetFsType" result
    result' <- cstringToText result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_get_device_path
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFileName)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_get_device_path" g_unix_mount_get_device_path :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO CString

{-# DEPRECATED unixMountGetDevicePath ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.get_device_path] instead."] #-}
-- | Gets the device path for a Unix mount.
unixMountGetDevicePath ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m [Char]
    -- ^ __Returns:__ a string containing the device path
unixMountGetDevicePath mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_get_device_path mountEntry'
    checkUnexpectedReturnNULL "unixMountGetDevicePath" result
    result' <- cstringToString result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_free
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_free" g_unix_mount_free :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO ()

{-# DEPRECATED unixMountFree ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.free] instead."] #-}
-- | Frees a Unix mount.
unixMountFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m ()
unixMountFree mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    g_unix_mount_free mountEntry'
    touchManagedPtr mountEntry
    return ()


-- function unix_mount_for
-- Args: [ Arg
--           { argCName = "file_path"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "file path on some Unix mount"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_read"
--           , argType = TBasicType TUInt64
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a timestamp"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "UnixMountEntry" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_for" g_unix_mount_for :: 
    CString ->                              -- file_path : TBasicType TFileName
    Ptr Word64 ->                           -- time_read : TBasicType TUInt64
    IO (Ptr Gio.UnixMountEntry.UnixMountEntry)

{-# DEPRECATED unixMountFor ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.for] instead."] #-}
-- | Gets a [struct/@gioUnix@/.MountEntry] for a given file path.
-- 
-- If /@timeRead@/ is set, it will be filled with a Unix timestamp for checking
-- if the mounts have changed since with
-- @/GioUnix.mount_entries_changed_since/@.
-- 
-- If more mounts have the same mount path, the last matching mount
-- is returned.
-- 
-- This will return @NULL@ if looking up the mount entry fails, if
-- /@filePath@/ doesn’t exist or there is an I\/O error.
-- 
-- /Since: 2.52/
unixMountFor ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@filePath@/: file path on some Unix mount
    -> m ((Maybe Gio.UnixMountEntry.UnixMountEntry, Word64))
    -- ^ __Returns:__ a [struct/@gioUnix@/.MountEntry]
unixMountFor filePath = liftIO $ do
    filePath' <- stringToCString filePath
    timeRead <- allocMem :: IO (Ptr Word64)
    result <- g_unix_mount_for filePath' timeRead
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Gio.UnixMountEntry.UnixMountEntry) result'
        return result''
    timeRead' <- peek timeRead
    freeMem filePath'
    freeMem timeRead
    return (maybeResult, timeRead')


-- function unix_mount_entries_get_from_file
-- XXX Could not generate function unix_mount_entries_get_from_file

-- Not implemented: Don't know how to allocate "time_read_out" of type TBasicType TUInt64

-- function unix_mount_entries_get
-- Args: [ Arg
--           { argCName = "time_read"
--           , argType = TBasicType TUInt64
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a timestamp"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList
--                  (TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }))
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_entries_get" g_unix_mount_entries_get :: 
    Ptr Word64 ->                           -- time_read : TBasicType TUInt64
    IO (Ptr (GList (Ptr Gio.UnixMountEntry.UnixMountEntry)))

-- | Gets a list of [struct/@gioUnix@/.MountEntry] instances representing the Unix
-- mounts.
-- 
-- If /@timeRead@/ is set, it will be filled with the mount timestamp, allowing
-- for checking if the mounts have changed with
-- @/GioUnix.mount_entries_changed_since/@.
-- 
-- /Since: 2.84/
unixMountEntriesGet ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (([Gio.UnixMountEntry.UnixMountEntry], Word64))
    -- ^ __Returns:__ a list of the
    --    Unix mounts
unixMountEntriesGet  = liftIO $ do
    timeRead <- allocMem :: IO (Ptr Word64)
    result <- g_unix_mount_entries_get timeRead
    result' <- unpackGList result
    result'' <- mapM (wrapBoxed Gio.UnixMountEntry.UnixMountEntry) result'
    g_list_free result
    timeRead' <- peek timeRead
    freeMem timeRead
    return (result'', timeRead')


-- function unix_mount_entries_changed_since
-- Args: [ Arg
--           { argCName = "time"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a timestamp" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_entries_changed_since" g_unix_mount_entries_changed_since :: 
    Word64 ->                               -- time : TBasicType TUInt64
    IO CInt

-- | Checks if the Unix mounts have changed since a given Unix time.
-- 
-- This can only work reliably if a @/GioUnix.MountMonitor/@ is running in
-- the process, otherwise changes in the mount entries file (such as
-- @\/proc\/self\/mountinfo@ on Linux) cannot be detected and, as a result, this
-- function has to conservatively always return @TRUE@.
-- 
-- It is more efficient to use @/GioUnix.MountMonitor::mounts-changed/@ to
-- be signalled of changes to the mount entries, rather than polling using this
-- function. This function is more appropriate for infrequently determining
-- cache validity.
unixMountEntriesChangedSince ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word64
    -- ^ /@time@/: a timestamp
    -> m Bool
    -- ^ __Returns:__ true if the mounts have changed since /@time@/; false otherwise
    -- Since 2.84
unixMountEntriesChangedSince time = liftIO $ do
    result <- g_unix_mount_entries_changed_since time
    let result' = (/= 0) result
    return result'


-- function unix_mount_copy
-- Args: [ Arg
--           { argCName = "mount_entry"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@GioUnix.MountEntry]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "UnixMountEntry" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_copy" g_unix_mount_copy :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount_entry : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO (Ptr Gio.UnixMountEntry.UnixMountEntry)

{-# DEPRECATED unixMountCopy ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.copy] instead."] #-}
-- | Makes a copy of /@mountEntry@/.
-- 
-- /Since: 2.54/
unixMountCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mountEntry@/: a [struct/@gioUnix@/.MountEntry]
    -> m Gio.UnixMountEntry.UnixMountEntry
    -- ^ __Returns:__ a new [struct/@gioUnix@/.MountEntry]
unixMountCopy mountEntry = liftIO $ do
    mountEntry' <- unsafeManagedPtrGetPtr mountEntry
    result <- g_unix_mount_copy mountEntry'
    checkUnexpectedReturnNULL "unixMountCopy" result
    result' <- (wrapBoxed Gio.UnixMountEntry.UnixMountEntry) result
    touchManagedPtr mountEntry
    return result'


-- function unix_mount_compare
-- Args: [ Arg
--           { argCName = "mount1"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "first [struct@GioUnix.MountEntry] to compare"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mount2"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "UnixMountEntry" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "second [struct@GioUnix.MountEntry] to compare"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_compare" g_unix_mount_compare :: 
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount1 : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    Ptr Gio.UnixMountEntry.UnixMountEntry -> -- mount2 : TInterface (Name {namespace = "Gio", name = "UnixMountEntry"})
    IO Int32

{-# DEPRECATED unixMountCompare ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.compare] instead."] #-}
-- | Compares two Unix mounts.
unixMountCompare ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mount1@/: first [struct/@gioUnix@/.MountEntry] to compare
    -> Gio.UnixMountEntry.UnixMountEntry
    -- ^ /@mount2@/: second [struct/@gioUnix@/.MountEntry] to compare
    -> m Int32
    -- ^ __Returns:__ @1@, @0@ or @-1@ if /@mount1@/ is greater than, equal to,
    --    or less than /@mount2@/, respectively
unixMountCompare mount1 mount2 = liftIO $ do
    mount1' <- unsafeManagedPtrGetPtr mount1
    mount2' <- unsafeManagedPtrGetPtr mount2
    result <- g_unix_mount_compare mount1' mount2'
    touchManagedPtr mount1
    touchManagedPtr mount2
    return result


-- function unix_mount_at
-- Args: [ Arg
--           { argCName = "mount_path"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "path for a possible Unix mount"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_read"
--           , argType = TBasicType TUInt64
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a timestamp"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "UnixMountEntry" })
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_mount_at" g_unix_mount_at :: 
    CString ->                              -- mount_path : TBasicType TFileName
    Ptr Word64 ->                           -- time_read : TBasicType TUInt64
    IO (Ptr Gio.UnixMountEntry.UnixMountEntry)

{-# DEPRECATED unixMountAt ["(Since version 2.84)","Use [func/@gioUnix@/.MountEntry.at] instead."] #-}
-- | Gets a [struct/@gioUnix@/.MountEntry] for a given mount path.
-- 
-- If /@timeRead@/ is set, it will be filled with a Unix timestamp for checking
-- if the mounts have changed since with
-- @/GioUnix.mount_entries_changed_since/@.
-- 
-- If more mounts have the same mount path, the last matching mount
-- is returned.
-- 
-- This will return @NULL@ if there is no mount point at /@mountPath@/.
unixMountAt ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@mountPath@/: path for a possible Unix mount
    -> m ((Maybe Gio.UnixMountEntry.UnixMountEntry, Word64))
    -- ^ __Returns:__ a [struct/@gioUnix@/.MountEntry]
unixMountAt mountPath = liftIO $ do
    mountPath' <- stringToCString mountPath
    timeRead <- allocMem :: IO (Ptr Word64)
    result <- g_unix_mount_at mountPath' timeRead
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Gio.UnixMountEntry.UnixMountEntry) result'
        return result''
    timeRead' <- peek timeRead
    freeMem mountPath'
    freeMem timeRead
    return (maybeResult, timeRead')


-- function unix_is_system_fs_type
-- Args: [ Arg
--           { argCName = "fs_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a file system type, e.g. `procfs` or `tmpfs`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_is_system_fs_type" g_unix_is_system_fs_type :: 
    CString ->                              -- fs_type : TBasicType TUTF8
    IO CInt

-- | Determines if /@fsType@/ is considered a type of file system which is only
-- used in implementation of the OS.
-- 
-- This is primarily used for hiding mounted volumes that are intended as APIs
-- for programs to read, and system administrators at a shell; rather than
-- something that should, for example, appear in a GUI. For example, the Linux
-- @\/proc@ filesystem.
-- 
-- The list of file system types considered ‘system’ ones may change over time.
-- 
-- /Since: 2.56/
unixIsSystemFsType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@fsType@/: a file system type, e.g. @procfs@ or @tmpfs@
    -> m Bool
    -- ^ __Returns:__ true if /@fsType@/ is considered an implementation detail of the OS;
    --    false otherwise
unixIsSystemFsType fsType = liftIO $ do
    fsType' <- textToCString fsType
    result <- g_unix_is_system_fs_type fsType'
    let result' = (/= 0) result
    freeMem fsType'
    return result'


-- function unix_is_system_device_path
-- Args: [ Arg
--           { argCName = "device_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a device path, e.g. `/dev/loop0` or `nfsd`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_is_system_device_path" g_unix_is_system_device_path :: 
    CString ->                              -- device_path : TBasicType TUTF8
    IO CInt

-- | Determines if /@devicePath@/ is considered a block device path which is only
-- used in implementation of the OS.
-- 
-- This is primarily used for hiding mounted volumes that are intended as APIs
-- for programs to read, and system administrators at a shell; rather than
-- something that should, for example, appear in a GUI. For example, the Linux
-- @\/proc@ filesystem.
-- 
-- The list of device paths considered ‘system’ ones may change over time.
-- 
-- /Since: 2.56/
unixIsSystemDevicePath ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@devicePath@/: a device path, e.g. @\/dev\/loop0@ or @nfsd@
    -> m Bool
    -- ^ __Returns:__ true if /@devicePath@/ is considered an implementation detail of
    --    the OS; false otherwise
unixIsSystemDevicePath devicePath = liftIO $ do
    devicePath' <- textToCString devicePath
    result <- g_unix_is_system_device_path devicePath'
    let result' = (/= 0) result
    freeMem devicePath'
    return result'


-- function unix_is_mount_path_system_internal
-- Args: [ Arg
--           { argCName = "mount_path"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a mount path, e.g. `/media/disk` or `/usr`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_unix_is_mount_path_system_internal" g_unix_is_mount_path_system_internal :: 
    CString ->                              -- mount_path : TBasicType TFileName
    IO CInt

-- | Determines if /@mountPath@/ is considered an implementation of the
-- OS.
-- 
-- This is primarily used for hiding mountable and mounted volumes
-- that only are used in the OS and has little to no relevance to the
-- casual user.
unixIsMountPathSystemInternal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@mountPath@/: a mount path, e.g. @\/media\/disk@ or @\/usr@
    -> m Bool
    -- ^ __Returns:__ true if /@mountPath@/ is considered an implementation detail
    --    of the OS; false otherwise
unixIsMountPathSystemInternal mountPath = liftIO $ do
    mountPath' <- stringToCString mountPath
    result <- g_unix_is_mount_path_system_internal mountPath'
    let result' = (/= 0) result
    freeMem mountPath'
    return result'


-- function simple_async_report_gerror_in_idle
-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObject, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncReadyCallback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GError to report"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_async_report_gerror_in_idle" g_simple_async_report_gerror_in_idle :: 
    Ptr GObject.Object.Object ->            -- object : TInterface (Name {namespace = "GObject", name = "Object"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    Ptr GError ->                           -- error : TError
    IO ()

{-# DEPRECATED simpleAsyncReportGerrorInIdle ["(Since version 2.46)","Use 'GI.Gio.Objects.Task.taskReportError'."] #-}
-- | Reports an error in an idle function. Similar to
-- @/g_simple_async_report_error_in_idle()/@, but takes a t'GError' rather
-- than building a new one.
simpleAsyncReportGerrorInIdle ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    Maybe (a)
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object', or 'P.Nothing'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'.
    -> GError
    -- ^ /@error@/: the t'GError' to report
    -> m ()
simpleAsyncReportGerrorInIdle object callback error_ = liftIO $ do
    maybeObject <- case object of
        Nothing -> return FP.nullPtr
        Just jObject -> do
            jObject' <- unsafeManagedPtrCastPtr jObject
            return jObject'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    error_' <- unsafeManagedPtrGetPtr error_
    let userData = nullPtr
    g_simple_async_report_gerror_in_idle maybeObject maybeCallback userData error_'
    whenJust object touchManagedPtr
    touchManagedPtr error_
    return ()


-- function resources_unregister
-- Args: [ Arg
--           { argCName = "resource"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Resource" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A [struct@Gio.Resource]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_resources_unregister" g_resources_unregister :: 
    Ptr Gio.Resource.Resource ->            -- resource : TInterface (Name {namespace = "Gio", name = "Resource"})
    IO ()

-- | Unregisters the resource from the process-global set of resources.
-- 
-- /Since: 2.32/
resourcesUnregister ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.Resource.Resource
    -- ^ /@resource@/: A [struct/@gio@/.Resource]
    -> m ()
resourcesUnregister resource = liftIO $ do
    resource' <- unsafeManagedPtrGetPtr resource
    g_resources_unregister resource'
    touchManagedPtr resource
    return ()


-- function resources_register
-- Args: [ Arg
--           { argCName = "resource"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Resource" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A [struct@Gio.Resource]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_resources_register" g_resources_register :: 
    Ptr Gio.Resource.Resource ->            -- resource : TInterface (Name {namespace = "Gio", name = "Resource"})
    IO ()

-- | Registers the resource with the process-global set of resources.
-- 
-- Once a resource is registered the files in it can be accessed
-- with the global resource lookup functions like
-- 'GI.Gio.Functions.resourcesLookupData'.
-- 
-- /Since: 2.32/
resourcesRegister ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.Resource.Resource
    -- ^ /@resource@/: A [struct/@gio@/.Resource]
    -> m ()
resourcesRegister resource = liftIO $ do
    resource' <- unsafeManagedPtrGetPtr resource
    g_resources_register resource'
    touchManagedPtr resource
    return ()


-- function resources_open_stream
-- Args: [ Arg
--           { argCName = "path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A path name inside the resource"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lookup_flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "ResourceLookupFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A [flags@Gio.ResourceLookupFlags]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InputStream" })
-- throws : True
-- Skip return : False

foreign import ccall "g_resources_open_stream" g_resources_open_stream :: 
    CString ->                              -- path : TBasicType TUTF8
    CUInt ->                                -- lookup_flags : TInterface (Name {namespace = "Gio", name = "ResourceLookupFlags"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.InputStream.InputStream)

-- | Looks for a file at the specified /@path@/ in the set of
-- globally registered resources and returns a t'GI.Gio.Objects.InputStream.InputStream'
-- that lets you read the data.
-- 
-- /@lookupFlags@/ controls the behaviour of the lookup.
-- 
-- /Since: 2.32/
resourcesOpenStream ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@path@/: A path name inside the resource
    -> [Gio.Flags.ResourceLookupFlags]
    -- ^ /@lookupFlags@/: A [flags/@gio@/.ResourceLookupFlags]
    -> m Gio.InputStream.InputStream
    -- ^ __Returns:__ t'GI.Gio.Objects.InputStream.InputStream' or @NULL@ on error /(Can throw 'Data.GI.Base.GError.GError')/
resourcesOpenStream path lookupFlags = liftIO $ do
    path' <- textToCString path
    let lookupFlags' = gflagsToWord lookupFlags
    onException (do
        result <- propagateGError $ g_resources_open_stream path' lookupFlags'
        checkUnexpectedReturnNULL "resourcesOpenStream" result
        result' <- (wrapObject Gio.InputStream.InputStream) result
        freeMem path'
        return result'
     ) (do
        freeMem path'
     )


-- function resources_lookup_data
-- Args: [ Arg
--           { argCName = "path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A path name inside the resource"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lookup_flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "ResourceLookupFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A [flags@Gio.ResourceLookupFlags]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Bytes" })
-- throws : True
-- Skip return : False

foreign import ccall "g_resources_lookup_data" g_resources_lookup_data :: 
    CString ->                              -- path : TBasicType TUTF8
    CUInt ->                                -- lookup_flags : TInterface (Name {namespace = "Gio", name = "ResourceLookupFlags"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr GLib.Bytes.Bytes)

-- | Looks for a file at the specified /@path@/ in the set of
-- globally registered resources and returns a [struct/@gLib@/.Bytes] that
-- lets you directly access the data in memory.
-- 
-- The data is always followed by a zero byte, so you
-- can safely use the data as a C string. However, that byte
-- is not included in the size of the [struct/@gLib@/.Bytes].
-- 
-- For uncompressed resource files this is a pointer directly into
-- the resource bundle, which is typically in some read-only data section
-- in the program binary. For compressed files we allocate memory on
-- the heap and automatically uncompress the data.
-- 
-- /@lookupFlags@/ controls the behaviour of the lookup.
-- 
-- /Since: 2.32/
resourcesLookupData ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@path@/: A path name inside the resource
    -> [Gio.Flags.ResourceLookupFlags]
    -- ^ /@lookupFlags@/: A [flags/@gio@/.ResourceLookupFlags]
    -> m GLib.Bytes.Bytes
    -- ^ __Returns:__ [struct/@gLib@/.Bytes] or @NULL@ on error /(Can throw 'Data.GI.Base.GError.GError')/
resourcesLookupData path lookupFlags = liftIO $ do
    path' <- textToCString path
    let lookupFlags' = gflagsToWord lookupFlags
    onException (do
        result <- propagateGError $ g_resources_lookup_data path' lookupFlags'
        checkUnexpectedReturnNULL "resourcesLookupData" result
        result' <- (wrapBoxed GLib.Bytes.Bytes) result
        freeMem path'
        return result'
     ) (do
        freeMem path'
     )


-- function resources_has_children
-- Args: [ Arg
--           { argCName = "path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A pathname" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_resources_has_children" g_resources_has_children :: 
    CString ->                              -- path : TBasicType TUTF8
    IO CInt

-- | Returns whether the specified /@path@/ in the set of
-- globally registered resources has children.
-- 
-- /Since: 2.84/
resourcesHasChildren ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@path@/: A pathname
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@patch@/ has children
resourcesHasChildren path = liftIO $ do
    path' <- textToCString path
    result <- g_resources_has_children path'
    let result' = (/= 0) result
    freeMem path'
    return result'


-- function resources_get_info
-- Args: [ Arg
--           { argCName = "path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A path name inside the resource"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lookup_flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "ResourceLookupFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A [flags@Gio.ResourceLookupFlags]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a location to place the length of the contents of the file,\n   or `NULL` if the length is not needed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "flags"
--           , argType = TBasicType TUInt32
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a location to place the [flags@Gio.ResourceFlags] about the file,\n   or `NULL` if the flags are not needed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_resources_get_info" g_resources_get_info :: 
    CString ->                              -- path : TBasicType TUTF8
    CUInt ->                                -- lookup_flags : TInterface (Name {namespace = "Gio", name = "ResourceLookupFlags"})
    Ptr FCT.CSize ->                        -- size : TBasicType TSize
    Ptr Word32 ->                           -- flags : TBasicType TUInt32
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Looks for a file at the specified /@path@/ in the set of
-- globally registered resources and if found returns information about it.
-- 
-- /@lookupFlags@/ controls the behaviour of the lookup.
-- 
-- /Since: 2.32/
resourcesGetInfo ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@path@/: A path name inside the resource
    -> [Gio.Flags.ResourceLookupFlags]
    -- ^ /@lookupFlags@/: A [flags/@gio@/.ResourceLookupFlags]
    -> m ((FCT.CSize, Word32))
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
resourcesGetInfo path lookupFlags = liftIO $ do
    path' <- textToCString path
    let lookupFlags' = gflagsToWord lookupFlags
    size <- allocMem :: IO (Ptr FCT.CSize)
    flags <- allocMem :: IO (Ptr Word32)
    onException (do
        _ <- propagateGError $ g_resources_get_info path' lookupFlags' size flags
        size' <- peek size
        flags' <- peek flags
        freeMem path'
        freeMem size
        freeMem flags
        return (size', flags')
     ) (do
        freeMem path'
        freeMem size
        freeMem flags
     )


-- function resources_enumerate_children
-- Args: [ Arg
--           { argCName = "path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A path name inside the resource"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "lookup_flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "ResourceLookupFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A [flags@Gio.ResourceLookupFlags]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : True
-- Skip return : False

foreign import ccall "g_resources_enumerate_children" g_resources_enumerate_children :: 
    CString ->                              -- path : TBasicType TUTF8
    CUInt ->                                -- lookup_flags : TInterface (Name {namespace = "Gio", name = "ResourceLookupFlags"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr CString)

-- | Returns all the names of children at the specified /@path@/ in the set of
-- globally registered resources.
-- 
-- The return result is a @NULL@ terminated list of strings which should
-- be released with 'GI.GLib.Functions.strfreev'.
-- 
-- /@lookupFlags@/ controls the behaviour of the lookup.
-- 
-- /Since: 2.32/
resourcesEnumerateChildren ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@path@/: A path name inside the resource
    -> [Gio.Flags.ResourceLookupFlags]
    -- ^ /@lookupFlags@/: A [flags/@gio@/.ResourceLookupFlags]
    -> m [T.Text]
    -- ^ __Returns:__ an array of constant strings /(Can throw 'Data.GI.Base.GError.GError')/
resourcesEnumerateChildren path lookupFlags = liftIO $ do
    path' <- textToCString path
    let lookupFlags' = gflagsToWord lookupFlags
    onException (do
        result <- propagateGError $ g_resources_enumerate_children path' lookupFlags'
        checkUnexpectedReturnNULL "resourcesEnumerateChildren" result
        result' <- unpackZeroTerminatedUTF8CArray result
        mapZeroTerminatedCArray freeMem result
        freeMem result
        freeMem path'
        return result'
     ) (do
        freeMem path'
     )


-- function pollable_stream_write_all
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "OutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOutputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the buffer\n  containing the data to write."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes to write"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blocking"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to do blocking I/O"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes_written"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the number of bytes that was\n  written to the stream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of bytes to write"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_pollable_stream_write_all" g_pollable_stream_write_all :: 
    Ptr Gio.OutputStream.OutputStream ->    -- stream : TInterface (Name {namespace = "Gio", name = "OutputStream"})
    Ptr Word8 ->                            -- buffer : TCArray False (-1) 2 (TBasicType TUInt8)
    FCT.CSize ->                            -- count : TBasicType TSize
    CInt ->                                 -- blocking : TBasicType TBoolean
    Ptr FCT.CSize ->                        -- bytes_written : TBasicType TSize
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Tries to write /@count@/ bytes to /@stream@/, as with
-- 'GI.Gio.Objects.OutputStream.outputStreamWriteAll', but using 'GI.Gio.Functions.pollableStreamWrite'
-- rather than 'GI.Gio.Objects.OutputStream.outputStreamWrite'.
-- 
-- On a successful write of /@count@/ bytes, 'P.True' is returned, and
-- /@bytesWritten@/ is set to /@count@/.
-- 
-- If there is an error during the operation (including
-- 'GI.Gio.Enums.IOErrorEnumWouldBlock' in the non-blocking case), 'P.False' is
-- returned and /@error@/ is set to indicate the error status,
-- /@bytesWritten@/ is updated to contain the number of bytes written
-- into the stream before the error occurred.
-- 
-- As with 'GI.Gio.Functions.pollableStreamWrite', if /@blocking@/ is 'P.False', then
-- /@stream@/ must be a t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream' for which
-- 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCanPoll' returns 'P.True' or else the
-- behavior is undefined. If /@blocking@/ is 'P.True', then /@stream@/ does not
-- need to be a t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'.
-- 
-- /Since: 2.34/
pollableStreamWriteAll ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.OutputStream.IsOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.OutputStream.OutputStream'.
    -> ByteString
    -- ^ /@buffer@/: the buffer
    --   containing the data to write.
    -> Bool
    -- ^ /@blocking@/: whether to do blocking I\/O
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m (FCT.CSize)
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
pollableStreamWriteAll stream buffer blocking cancellable = liftIO $ do
    let count = fromIntegral $ B.length buffer
    stream' <- unsafeManagedPtrCastPtr stream
    buffer' <- packByteString buffer
    let blocking' = (P.fromIntegral . P.fromEnum) blocking
    bytesWritten <- allocMem :: IO (Ptr FCT.CSize)
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ g_pollable_stream_write_all stream' buffer' count blocking' bytesWritten maybeCancellable
        bytesWritten' <- peek bytesWritten
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        freeMem buffer'
        freeMem bytesWritten
        return bytesWritten'
     ) (do
        freeMem buffer'
        freeMem bytesWritten
     )


-- function pollable_stream_write
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "OutputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GOutputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the buffer\n  containing the data to write."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes to write"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blocking"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to do blocking I/O"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of bytes to write"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TSSize)
-- throws : True
-- Skip return : False

foreign import ccall "g_pollable_stream_write" g_pollable_stream_write :: 
    Ptr Gio.OutputStream.OutputStream ->    -- stream : TInterface (Name {namespace = "Gio", name = "OutputStream"})
    Ptr Word8 ->                            -- buffer : TCArray False (-1) 2 (TBasicType TUInt8)
    FCT.CSize ->                            -- count : TBasicType TSize
    CInt ->                                 -- blocking : TBasicType TBoolean
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO DI.Int64

-- | Tries to write to /@stream@/, as with 'GI.Gio.Objects.OutputStream.outputStreamWrite' (if
-- /@blocking@/ is 'P.True') or 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamWriteNonblocking'
-- (if /@blocking@/ is 'P.False'). This can be used to more easily share
-- code between blocking and non-blocking implementations of a method.
-- 
-- If /@blocking@/ is 'P.False', then /@stream@/ must be a
-- t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream' for which
-- 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCanPoll' returns 'P.True' or else the
-- behavior is undefined. If /@blocking@/ is 'P.True', then /@stream@/ does not
-- need to be a t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'.
-- 
-- /Since: 2.34/
pollableStreamWrite ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.OutputStream.IsOutputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.OutputStream.OutputStream'.
    -> ByteString
    -- ^ /@buffer@/: the buffer
    --   containing the data to write.
    -> Bool
    -- ^ /@blocking@/: whether to do blocking I\/O
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m DI.Int64
    -- ^ __Returns:__ the number of bytes written, or -1 on error. /(Can throw 'Data.GI.Base.GError.GError')/
pollableStreamWrite stream buffer blocking cancellable = liftIO $ do
    let count = fromIntegral $ B.length buffer
    stream' <- unsafeManagedPtrCastPtr stream
    buffer' <- packByteString buffer
    let blocking' = (P.fromIntegral . P.fromEnum) blocking
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_pollable_stream_write stream' buffer' count blocking' maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        freeMem buffer'
        return result
     ) (do
        freeMem buffer'
     )


-- function pollable_stream_read
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInputStream" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a buffer to\n  read data into"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of bytes to read"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "blocking"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to do blocking I/O"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of bytes to read"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TSSize)
-- throws : True
-- Skip return : False

foreign import ccall "g_pollable_stream_read" g_pollable_stream_read :: 
    Ptr Gio.InputStream.InputStream ->      -- stream : TInterface (Name {namespace = "Gio", name = "InputStream"})
    Ptr Word8 ->                            -- buffer : TCArray False (-1) 2 (TBasicType TUInt8)
    FCT.CSize ->                            -- count : TBasicType TSize
    CInt ->                                 -- blocking : TBasicType TBoolean
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO DI.Int64

-- | Tries to read from /@stream@/, as with 'GI.Gio.Objects.InputStream.inputStreamRead' (if
-- /@blocking@/ is 'P.True') or 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamReadNonblocking'
-- (if /@blocking@/ is 'P.False'). This can be used to more easily share
-- code between blocking and non-blocking implementations of a method.
-- 
-- If /@blocking@/ is 'P.False', then /@stream@/ must be a
-- t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream' for which 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamCanPoll'
-- returns 'P.True', or else the behavior is undefined. If /@blocking@/ is
-- 'P.True', then /@stream@/ does not need to be a t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream'.
-- 
-- /Since: 2.34/
pollableStreamRead ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@stream@/: a t'GI.Gio.Objects.InputStream.InputStream'
    -> ByteString
    -- ^ /@buffer@/: a buffer to
    --   read data into
    -> Bool
    -- ^ /@blocking@/: whether to do blocking I\/O
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m DI.Int64
    -- ^ __Returns:__ the number of bytes read, or -1 on error. /(Can throw 'Data.GI.Base.GError.GError')/
pollableStreamRead stream buffer blocking cancellable = liftIO $ do
    let count = fromIntegral $ B.length buffer
    stream' <- unsafeManagedPtrCastPtr stream
    buffer' <- packByteString buffer
    let blocking' = (P.fromIntegral . P.fromEnum) blocking
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_pollable_stream_read stream' buffer' count blocking' maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        freeMem buffer'
        return result
     ) (do
        freeMem buffer'
     )


-- function pollable_source_new_full
-- Args: [ Arg
--           { argCName = "pollable_stream"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the stream associated with the\n  new source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child_source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional child source to attach"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional #GCancellable to attach"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_pollable_source_new_full" g_pollable_source_new_full :: 
    Ptr GObject.Object.Object ->            -- pollable_stream : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr GLib.Source.Source ->               -- child_source : TInterface (Name {namespace = "GLib", name = "Source"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    IO (Ptr GLib.Source.Source)

-- | Utility method for t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream' and t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'
-- implementations. Creates a new t'GI.GLib.Structs.Source.Source', as with
-- 'GI.Gio.Functions.pollableSourceNew', but also attaching /@childSource@/ (with a
-- dummy callback), and /@cancellable@/, if they are non-'P.Nothing'.
-- 
-- /Since: 2.34/
pollableSourceNewFull ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@pollableStream@/: the stream associated with the
    --   new source
    -> Maybe (GLib.Source.Source)
    -- ^ /@childSource@/: optional child source to attach
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' to attach
    -> m GLib.Source.Source
    -- ^ __Returns:__ the new t'GI.GLib.Structs.Source.Source'.
pollableSourceNewFull pollableStream childSource cancellable = liftIO $ do
    pollableStream' <- unsafeManagedPtrCastPtr pollableStream
    maybeChildSource <- case childSource of
        Nothing -> return FP.nullPtr
        Just jChildSource -> do
            jChildSource' <- unsafeManagedPtrGetPtr jChildSource
            return jChildSource'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    result <- g_pollable_source_new_full pollableStream' maybeChildSource maybeCancellable
    checkUnexpectedReturnNULL "pollableSourceNewFull" result
    result' <- (wrapBoxed GLib.Source.Source) result
    touchManagedPtr pollableStream
    whenJust childSource touchManagedPtr
    whenJust cancellable touchManagedPtr
    return result'


-- function pollable_source_new
-- Args: [ Arg
--           { argCName = "pollable_stream"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the stream associated with the new source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "g_pollable_source_new" g_pollable_source_new :: 
    Ptr GObject.Object.Object ->            -- pollable_stream : TInterface (Name {namespace = "GObject", name = "Object"})
    IO (Ptr GLib.Source.Source)

-- | Utility method for t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream' and t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'
-- implementations. Creates a new t'GI.GLib.Structs.Source.Source' that expects a callback of
-- type t'GI.Gio.Callbacks.PollableSourceFunc'. The new source does not actually do
-- anything on its own; use 'GI.GLib.Structs.Source.sourceAddChildSource' to add other
-- sources to it to cause it to trigger.
-- 
-- /Since: 2.28/
pollableSourceNew ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@pollableStream@/: the stream associated with the new source
    -> m GLib.Source.Source
    -- ^ __Returns:__ the new t'GI.GLib.Structs.Source.Source'.
pollableSourceNew pollableStream = liftIO $ do
    pollableStream' <- unsafeManagedPtrCastPtr pollableStream
    result <- g_pollable_source_new pollableStream'
    checkUnexpectedReturnNULL "pollableSourceNew" result
    result' <- (wrapBoxed GLib.Source.Source) result
    touchManagedPtr pollableStream
    return result'


-- function null_settings_backend_new
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SettingsBackend" })
-- throws : False
-- Skip return : False

foreign import ccall "g_null_settings_backend_new" g_null_settings_backend_new :: 
    IO (Ptr Gio.SettingsBackend.SettingsBackend)

-- | Creates a readonly t'GI.Gio.Objects.SettingsBackend.SettingsBackend'.
-- 
-- This backend does not allow changes to settings, so all settings
-- will always have their default values.
-- 
-- /Since: 2.28/
nullSettingsBackendNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Gio.SettingsBackend.SettingsBackend
    -- ^ __Returns:__ a newly created t'GI.Gio.Objects.SettingsBackend.SettingsBackend'
nullSettingsBackendNew  = liftIO $ do
    result <- g_null_settings_backend_new
    checkUnexpectedReturnNULL "nullSettingsBackendNew" result
    result' <- (wrapObject Gio.SettingsBackend.SettingsBackend) result
    return result'


-- function networking_init
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_networking_init" g_networking_init :: 
    IO ()

-- | Initializes the platform networking libraries (eg, on Windows, this
-- calls @/WSAStartup()/@). GLib will call this itself if it is needed, so
-- you only need to call it if you directly call system networking
-- functions (without calling any GLib networking functions first).
-- 
-- /Since: 2.36/
networkingInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
networkingInit  = liftIO $ do
    g_networking_init
    return ()


-- function memory_settings_backend_new
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SettingsBackend" })
-- throws : False
-- Skip return : False

foreign import ccall "g_memory_settings_backend_new" g_memory_settings_backend_new :: 
    IO (Ptr Gio.SettingsBackend.SettingsBackend)

-- | Creates a memory-backed t'GI.Gio.Objects.SettingsBackend.SettingsBackend'.
-- 
-- This backend allows changes to settings, but does not write them
-- to any backing storage, so the next time you run your application,
-- the memory backend will start out with the default values again.
-- 
-- /Since: 2.28/
memorySettingsBackendNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Gio.SettingsBackend.SettingsBackend
    -- ^ __Returns:__ a newly created t'GI.Gio.Objects.SettingsBackend.SettingsBackend'
memorySettingsBackendNew  = liftIO $ do
    result <- g_memory_settings_backend_new
    checkUnexpectedReturnNULL "memorySettingsBackendNew" result
    result' <- (wrapObject Gio.SettingsBackend.SettingsBackend) result
    return result'


-- function keyfile_settings_backend_new
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the filename of the keyfile"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the path under which all settings keys appear"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "root_group"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the group name corresponding to @root_path, or\n   `NULL` to disallow storing keys directly beneath @root_path"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SettingsBackend" })
-- throws : False
-- Skip return : False

foreign import ccall "g_keyfile_settings_backend_new" g_keyfile_settings_backend_new :: 
    CString ->                              -- filename : TBasicType TUTF8
    CString ->                              -- root_path : TBasicType TUTF8
    CString ->                              -- root_group : TBasicType TUTF8
    IO (Ptr Gio.SettingsBackend.SettingsBackend)

-- | Creates a keyfile-backed t'GI.Gio.Objects.SettingsBackend.SettingsBackend'.
-- 
-- The filename of the keyfile to use is given by /@filename@/.
-- 
-- All settings read to or written from the backend must fall under the
-- path given in /@rootPath@/ (which must start and end with a slash and
-- not contain two consecutive slashes).  /@rootPath@/ may be @\"\/\"@.
-- 
-- If /@rootGroup@/ is non-@NULL@ then it specifies the name of the keyfile
-- group used for keys that are written directly below /@rootPath@/.  For
-- example, if /@rootPath@/ is @\"\/apps\/example\/\"@ and /@rootGroup@/ is
-- @\"toplevel\"@, then setting the key @\"\/apps\/example\/enabled\"@ to true will
-- cause the following to appear in the keyfile:
-- 
-- >[toplevel]
-- >enabled=true
-- 
-- 
-- If /@rootGroup@/ is @NULL@ then it is not permitted to store keys
-- directly below the /@rootPath@/.
-- 
-- For keys not stored directly below /@rootPath@/ (ie: in a sub-path),
-- the name of the subpath (with the final slash stripped) is used as
-- the name of the keyfile group.  To continue the example, if
-- @\"\/apps\/example\/profiles\/default\/font-size\"@ were set to
-- @12@ then the following would appear in the keyfile:
-- 
-- >[profiles/default]
-- >font-size=12
-- 
-- 
-- The backend will refuse writes (and return writability as being
-- false) for keys outside of /@rootPath@/ and, in the event that
-- /@rootGroup@/ is @NULL@, also for keys directly under /@rootPath@/.
-- Writes will also be refused if the backend detects that it has the
-- inability to rewrite the keyfile (ie: the containing directory is not
-- writable).
-- 
-- There is no checking done for your key namespace clashing with the
-- syntax of the key file format.  For example, if you have @[@ or @]@
-- characters in your path names or @=@ in your key names you may be in
-- trouble.
-- 
-- The backend reads default values from a keyfile called @defaults@ in
-- the directory specified by the @GKeyfileSettingsBackend:defaults-dir@
-- property, and a list of locked keys from a text file with the name @locks@ in
-- the same location.
keyfileSettingsBackendNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@filename@/: the filename of the keyfile
    -> T.Text
    -- ^ /@rootPath@/: the path under which all settings keys appear
    -> Maybe (T.Text)
    -- ^ /@rootGroup@/: the group name corresponding to /@rootPath@/, or
    --    @NULL@ to disallow storing keys directly beneath /@rootPath@/
    -> m Gio.SettingsBackend.SettingsBackend
    -- ^ __Returns:__ a keyfile-backed t'GI.Gio.Objects.SettingsBackend.SettingsBackend'
keyfileSettingsBackendNew filename rootPath rootGroup = liftIO $ do
    filename' <- textToCString filename
    rootPath' <- textToCString rootPath
    maybeRootGroup <- case rootGroup of
        Nothing -> return FP.nullPtr
        Just jRootGroup -> do
            jRootGroup' <- textToCString jRootGroup
            return jRootGroup'
    result <- g_keyfile_settings_backend_new filename' rootPath' maybeRootGroup
    checkUnexpectedReturnNULL "keyfileSettingsBackendNew" result
    result' <- (wrapObject Gio.SettingsBackend.SettingsBackend) result
    freeMem filename'
    freeMem rootPath'
    freeMem maybeRootGroup
    return result'


-- function io_scheduler_push_job
-- Args: [ Arg
--           { argCName = "job_func"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOSchedulerJobFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOSchedulerJobFunc."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = 1
--           , argDestroy = 2
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @job_func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "notify"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDestroyNotify for @user_data, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the [I/O priority](iface.AsyncResult.html#io-priority)\nof the request."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_io_scheduler_push_job" g_io_scheduler_push_job :: 
    FunPtr Gio.Callbacks.C_IOSchedulerJobFunc -> -- job_func : TInterface (Name {namespace = "Gio", name = "IOSchedulerJobFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- notify : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    IO ()

{-# DEPRECATED ioSchedulerPushJob ["(Since version 2.36)","use t'GI.GLib.Structs.ThreadPool.ThreadPool' or 'GI.Gio.Objects.Task.taskRunInThread'"] #-}
-- | Schedules the I\/O job to run in another thread.
-- 
-- /@notify@/ will be called on /@userData@/ after /@jobFunc@/ has returned,
-- regardless whether the job was cancelled or has run to completion.
-- 
-- If /@cancellable@/ is not 'P.Nothing', it can be used to cancel the I\/O job
-- by calling 'GI.Gio.Objects.Cancellable.cancellableCancel' or by calling
-- 'GI.Gio.Functions.ioSchedulerCancelAllJobs'.
ioSchedulerPushJob ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Cancellable.IsCancellable a) =>
    Gio.Callbacks.IOSchedulerJobFunc
    -- ^ /@jobFunc@/: a t'GI.Gio.Callbacks.IOSchedulerJobFunc'.
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority>
    -- of the request.
    -> Maybe (a)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
ioSchedulerPushJob jobFunc ioPriority cancellable = liftIO $ do
    jobFunc' <- Gio.Callbacks.mk_IOSchedulerJobFunc (Gio.Callbacks.wrap_IOSchedulerJobFunc Nothing (Gio.Callbacks.drop_closures_IOSchedulerJobFunc jobFunc))
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    let userData = castFunPtrToPtr jobFunc'
    let notify = SP.safeFreeFunPtrPtr
    g_io_scheduler_push_job jobFunc' userData notify ioPriority maybeCancellable
    whenJust cancellable touchManagedPtr
    return ()


-- function io_scheduler_cancel_all_jobs
-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_io_scheduler_cancel_all_jobs" g_io_scheduler_cancel_all_jobs :: 
    IO ()

{-# DEPRECATED ioSchedulerCancelAllJobs ["(Since version 2.36)","You should never call this function, since you don\\'t","know how other libraries in your program might be making use of","gioscheduler."] #-}
-- | Cancels all cancellable I\/O jobs.
-- 
-- A job is cancellable if a t'GI.Gio.Objects.Cancellable.Cancellable' was passed into
-- 'GI.Gio.Functions.ioSchedulerPushJob'.
ioSchedulerCancelAllJobs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ()
ioSchedulerCancelAllJobs  = liftIO $ do
    g_io_scheduler_cancel_all_jobs
    return ()


-- function io_modules_scan_all_in_directory_with_scope
-- Args: [ Arg
--           { argCName = "dirname"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pathname for a directory containing modules\n    to scan."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scope"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOModuleScope" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a scope to use when scanning the modules"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_io_modules_scan_all_in_directory_with_scope" g_io_modules_scan_all_in_directory_with_scope :: 
    CString ->                              -- dirname : TBasicType TFileName
    Ptr Gio.IOModuleScope.IOModuleScope ->  -- scope : TInterface (Name {namespace = "Gio", name = "IOModuleScope"})
    IO ()

-- | Scans all the modules in the specified directory, ensuring that
-- any extension point implemented by a module is registered.
-- 
-- This may not actually load and initialize all the types in each
-- module, some modules may be lazily loaded and initialized when
-- an extension point it implements is used with e.g.
-- 'GI.Gio.Structs.IOExtensionPoint.iOExtensionPointGetExtensions' or
-- 'GI.Gio.Structs.IOExtensionPoint.iOExtensionPointGetExtensionByName'.
-- 
-- If you need to guarantee that all types are loaded in all the modules,
-- use @/g_io_modules_load_all_in_directory()/@.
-- 
-- /Since: 2.30/
ioModulesScanAllInDirectoryWithScope ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@dirname@/: pathname for a directory containing modules
    --     to scan.
    -> Gio.IOModuleScope.IOModuleScope
    -- ^ /@scope@/: a scope to use when scanning the modules
    -> m ()
ioModulesScanAllInDirectoryWithScope dirname scope = liftIO $ do
    dirname' <- stringToCString dirname
    scope' <- unsafeManagedPtrGetPtr scope
    g_io_modules_scan_all_in_directory_with_scope dirname' scope'
    touchManagedPtr scope
    freeMem dirname'
    return ()


-- function io_modules_scan_all_in_directory
-- Args: [ Arg
--           { argCName = "dirname"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "pathname for a directory containing modules\n    to scan."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_io_modules_scan_all_in_directory" g_io_modules_scan_all_in_directory :: 
    CString ->                              -- dirname : TBasicType TFileName
    IO ()

-- | Scans all the modules in the specified directory, ensuring that
-- any extension point implemented by a module is registered.
-- 
-- This may not actually load and initialize all the types in each
-- module, some modules may be lazily loaded and initialized when
-- an extension point it implements is used with e.g.
-- 'GI.Gio.Structs.IOExtensionPoint.iOExtensionPointGetExtensions' or
-- 'GI.Gio.Structs.IOExtensionPoint.iOExtensionPointGetExtensionByName'.
-- 
-- If you need to guarantee that all types are loaded in all the modules,
-- use @/g_io_modules_load_all_in_directory()/@.
-- 
-- /Since: 2.24/
ioModulesScanAllInDirectory ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    [Char]
    -- ^ /@dirname@/: pathname for a directory containing modules
    --     to scan.
    -> m ()
ioModulesScanAllInDirectory dirname = liftIO $ do
    dirname' <- stringToCString dirname
    g_io_modules_scan_all_in_directory dirname'
    freeMem dirname'
    return ()


-- function io_error_quark
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "g_io_error_quark" g_io_error_quark :: 
    IO Word32

-- | Gets the GIO Error Quark.
ioErrorQuark ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Word32
    -- ^ __Returns:__ a @/GQuark/@.
ioErrorQuark  = liftIO $ do
    result <- g_io_error_quark
    return result


-- function io_error_from_file_error
-- Args: [ Arg
--           { argCName = "file_error"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "FileError" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GFileError." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "IOErrorEnum" })
-- throws : False
-- Skip return : False

foreign import ccall "g_io_error_from_file_error" g_io_error_from_file_error :: 
    CUInt ->                                -- file_error : TInterface (Name {namespace = "GLib", name = "FileError"})
    IO CUInt

-- | Converts t'GI.GLib.Enums.FileError' error codes into GIO error codes.
-- 
-- /Since: 2.74/
ioErrorFromFileError ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GLib.Enums.FileError
    -- ^ /@fileError@/: a t'GI.GLib.Enums.FileError'.
    -> m Gio.Enums.IOErrorEnum
    -- ^ __Returns:__ t'GI.Gio.Enums.IOErrorEnum' value for the given t'GI.GLib.Enums.FileError' error value.
ioErrorFromFileError fileError = liftIO $ do
    let fileError' = (fromIntegral . fromEnum) fileError
    result <- g_io_error_from_file_error fileError'
    let result' = (toEnum . fromIntegral) result
    return result'


-- function io_error_from_errno
-- Args: [ Arg
--           { argCName = "err_no"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Error number as defined in errno.h."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "IOErrorEnum" })
-- throws : False
-- Skip return : False

foreign import ccall "g_io_error_from_errno" g_io_error_from_errno :: 
    Int32 ->                                -- err_no : TBasicType TInt
    IO CUInt

-- | Converts @errno.h@ error codes into GIO error codes.
-- 
-- The fallback value 'GI.Gio.Enums.IOErrorEnumFailed' is returned for error codes not
-- currently handled (but note that future GLib releases may return a more
-- specific value instead).
-- 
-- As @errno@ is global and may be modified by intermediate function
-- calls, you should save its value immediately after the call returns,
-- and use the saved value instead of @errno@:
-- 
-- 
-- 
-- === /C code/
-- >
-- >  int saved_errno;
-- >
-- >  ret = read (blah);
-- >  saved_errno = errno;
-- >
-- >  g_io_error_from_errno (saved_errno);
ioErrorFromErrno ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@errNo@/: Error number as defined in errno.h.
    -> m Gio.Enums.IOErrorEnum
    -- ^ __Returns:__ t'GI.Gio.Enums.IOErrorEnum' value for the given @errno.h@ error number
ioErrorFromErrno errNo = liftIO $ do
    result <- g_io_error_from_errno errNo
    let result' = (toEnum . fromIntegral) result
    return result'


-- function dbus_unescape_object_path
-- Args: [ Arg
--           { argCName = "s"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to unescape"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUInt8))
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_unescape_object_path" g_dbus_unescape_object_path :: 
    CString ->                              -- s : TBasicType TUTF8
    IO (Ptr Word8)

-- | Unescapes an string that was previously escaped with
-- 'GI.Gio.Functions.dbusEscapeObjectPath'. If the string is in a format that could
-- not have been returned by 'GI.Gio.Functions.dbusEscapeObjectPath', this function
-- returns 'P.Nothing'.
-- 
-- Encoding alphanumeric characters which do not need to be
-- encoded is not allowed (e.g @_63@ is not valid, the string
-- should contain @c@ instead).
-- 
-- /Since: 2.68/
dbusUnescapeObjectPath ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@s@/: the string to unescape
    -> m (Maybe ByteString)
    -- ^ __Returns:__ an
    --   unescaped version of /@s@/, or 'P.Nothing' if /@s@/ is not a string returned
    --   from 'GI.Gio.Functions.dbusEscapeObjectPath'. Free with 'GI.GLib.Functions.free'.
dbusUnescapeObjectPath s = liftIO $ do
    s' <- textToCString s
    result <- g_dbus_unescape_object_path s'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackZeroTerminatedByteString result'
        return result''
    freeMem s'
    return maybeResult


-- function dbus_is_unique_name
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The string to check."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_is_unique_name" g_dbus_is_unique_name :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CInt

-- | Checks if /@string@/ is a valid D-Bus unique bus name.
-- 
-- /Since: 2.26/
dbusIsUniqueName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: The string to check.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if valid, 'P.False' otherwise.
dbusIsUniqueName string = liftIO $ do
    string' <- textToCString string
    result <- g_dbus_is_unique_name string'
    let result' = (/= 0) result
    freeMem string'
    return result'


-- function dbus_is_supported_address
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A string." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_dbus_is_supported_address" g_dbus_is_supported_address :: 
    CString ->                              -- string : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Like 'GI.Gio.Functions.dbusIsAddress' but also checks if the library supports the
-- transports in /@string@/ and that key\/value pairs for each transport
-- are valid. See the specification of the
-- <https://dbus.freedesktop.org/doc/dbus-specification.html#addresses D-Bus address format>.
-- 
-- /Since: 2.26/
dbusIsSupportedAddress ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: A string.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dbusIsSupportedAddress string = liftIO $ do
    string' <- textToCString string
    onException (do
        _ <- propagateGError $ g_dbus_is_supported_address string'
        freeMem string'
        return ()
     ) (do
        freeMem string'
     )


-- function dbus_is_name
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The string to check."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_is_name" g_dbus_is_name :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CInt

-- | Checks if /@string@/ is a valid D-Bus bus name (either unique or well-known).
-- 
-- /Since: 2.26/
dbusIsName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: The string to check.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if valid, 'P.False' otherwise.
dbusIsName string = liftIO $ do
    string' <- textToCString string
    result <- g_dbus_is_name string'
    let result' = (/= 0) result
    freeMem string'
    return result'


-- function dbus_is_member_name
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The string to check."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_is_member_name" g_dbus_is_member_name :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CInt

-- | Checks if /@string@/ is a valid D-Bus member (e.g. signal or method) name.
-- 
-- /Since: 2.26/
dbusIsMemberName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: The string to check.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if valid, 'P.False' otherwise.
dbusIsMemberName string = liftIO $ do
    string' <- textToCString string
    result <- g_dbus_is_member_name string'
    let result' = (/= 0) result
    freeMem string'
    return result'


-- function dbus_is_interface_name
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The string to check."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_is_interface_name" g_dbus_is_interface_name :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CInt

-- | Checks if /@string@/ is a valid D-Bus interface name.
-- 
-- /Since: 2.26/
dbusIsInterfaceName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: The string to check.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if valid, 'P.False' otherwise.
dbusIsInterfaceName string = liftIO $ do
    string' <- textToCString string
    result <- g_dbus_is_interface_name string'
    let result' = (/= 0) result
    freeMem string'
    return result'


-- function dbus_is_guid
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The string to check."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_is_guid" g_dbus_is_guid :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CInt

-- | Checks if /@string@/ is a D-Bus GUID.
-- 
-- See the documentation for 'GI.Gio.Functions.dbusGenerateGuid' for more information about
-- the format of a GUID.
-- 
-- /Since: 2.26/
dbusIsGuid ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: The string to check.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@string@/ is a GUID, 'P.False' otherwise.
dbusIsGuid string = liftIO $ do
    string' <- textToCString string
    result <- g_dbus_is_guid string'
    let result' = (/= 0) result
    freeMem string'
    return result'


-- function dbus_is_error_name
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The string to check."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_is_error_name" g_dbus_is_error_name :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CInt

-- | Check whether /@string@/ is a valid D-Bus error name.
-- 
-- This function returns the same result as 'GI.Gio.Functions.dbusIsInterfaceName',
-- because D-Bus error names are defined to have exactly the
-- same syntax as interface names.
-- 
-- /Since: 2.70/
dbusIsErrorName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: The string to check.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if valid, 'P.False' otherwise.
dbusIsErrorName string = liftIO $ do
    string' <- textToCString string
    result <- g_dbus_is_error_name string'
    let result' = (/= 0) result
    freeMem string'
    return result'


-- function dbus_is_address
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A string." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_is_address" g_dbus_is_address :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CInt

-- | Checks if /@string@/ is a
-- <https://dbus.freedesktop.org/doc/dbus-specification.html#addresses D-Bus address>.
-- 
-- This doesn\'t check if /@string@/ is actually supported by t'GI.Gio.Objects.DBusServer.DBusServer'
-- or t'GI.Gio.Objects.DBusConnection.DBusConnection' - use 'GI.Gio.Functions.dbusIsSupportedAddress' to do more
-- checks.
-- 
-- /Since: 2.26/
dbusIsAddress ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: A string.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@string@/ is a valid D-Bus address, 'P.False' otherwise.
dbusIsAddress string = liftIO $ do
    string' <- textToCString string
    result <- g_dbus_is_address string'
    let result' = (/= 0) result
    freeMem string'
    return result'


-- function dbus_gvariant_to_gvalue
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GVariant." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "out_gvalue"
--           , argType = TGValue
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Return location pointing to a zero-filled (uninitialized) #GValue."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_gvariant_to_gvalue" g_dbus_gvariant_to_gvalue :: 
    Ptr GVariant ->                         -- value : TVariant
    Ptr GValue ->                           -- out_gvalue : TGValue
    IO ()

-- | Converts a t'GVariant' to a t'GI.GObject.Structs.Value.Value'. If /@value@/ is floating, it is consumed.
-- 
-- The rules specified in the 'GI.Gio.Functions.dbusGvalueToGvariant' function are
-- used - this function is essentially its reverse form. So, a t'GVariant'
-- containing any basic or string array type will be converted to a t'GI.GObject.Structs.Value.Value'
-- containing a basic value or string array. Any other t'GVariant' (handle,
-- variant, tuple, dict entry) will be converted to a t'GI.GObject.Structs.Value.Value' containing that
-- t'GVariant'.
-- 
-- The conversion never fails - a valid t'GI.GObject.Structs.Value.Value' is always returned in
-- /@outGvalue@/.
-- 
-- /Since: 2.30/
dbusGvariantToGvalue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GVariant
    -- ^ /@value@/: A t'GVariant'.
    -> m (GValue)
dbusGvariantToGvalue value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    outGvalue <- SP.callocBytes 24 :: IO (Ptr GValue)
    g_dbus_gvariant_to_gvalue value' outGvalue
    outGvalue' <- B.GValue.wrapGValuePtr outGvalue
    touchManagedPtr value
    return outGvalue'


-- function dbus_gvalue_to_gvariant
-- Args: [ Arg
--           { argCName = "gvalue"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GValue to convert to a #GVariant"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GVariantType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_gvalue_to_gvariant" g_dbus_gvalue_to_gvariant :: 
    Ptr GValue ->                           -- gvalue : TGValue
    Ptr GLib.VariantType.VariantType ->     -- type : TInterface (Name {namespace = "GLib", name = "VariantType"})
    IO (Ptr GVariant)

-- | Converts a t'GI.GObject.Structs.Value.Value' to a t'GVariant' of the type indicated by the /@type@/
-- parameter.
-- 
-- The conversion is using the following rules:
-- 
-- * @G_TYPE_STRING@: \'s\', \'o\', \'g\' or \'ay\'
-- * @G_TYPE_STRV@: \'as\', \'ao\' or \'aay\'
-- * @G_TYPE_BOOLEAN@: \'b\'
-- * @G_TYPE_UCHAR@: \'y\'
-- * @G_TYPE_INT@: \'i\', \'n\'
-- * @G_TYPE_UINT@: \'u\', \'q\'
-- * @G_TYPE_INT64@: \'x\'
-- * @G_TYPE_UINT64@: \'t\'
-- * @G_TYPE_DOUBLE@: \'d\'
-- * @G_TYPE_VARIANT@: Any t'GI.GLib.Structs.VariantType.VariantType'
-- 
-- 
-- This can fail if e.g. /@gvalue@/ is of type @/G_TYPE_STRING/@ and /@type@/
-- is \'i\', i.e. @/G_VARIANT_TYPE_INT32/@. It will also fail for any t'GType'
-- (including e.g. @/G_TYPE_OBJECT/@ and @/G_TYPE_BOXED/@ derived-types) not
-- in the table above.
-- 
-- Note that if /@gvalue@/ is of type @/G_TYPE_VARIANT/@ and its value is
-- 'P.Nothing', the empty t'GVariant' instance (never 'P.Nothing') for /@type@/ is
-- returned (e.g. 0 for scalar types, the empty string for string types,
-- \'\/\' for object path types, the empty array for any array type and so on).
-- 
-- See the 'GI.Gio.Functions.dbusGvariantToGvalue' function for how to convert a
-- t'GVariant' to a t'GI.GObject.Structs.Value.Value'.
-- 
-- /Since: 2.30/
dbusGvalueToGvariant ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -- ^ /@gvalue@/: A t'GI.GObject.Structs.Value.Value' to convert to a t'GVariant'
    -> GLib.VariantType.VariantType
    -- ^ /@type@/: A t'GI.GLib.Structs.VariantType.VariantType'
    -> m GVariant
    -- ^ __Returns:__ A t'GVariant' (never floating) of
    --     t'GI.GLib.Structs.VariantType.VariantType' /@type@/ holding the data from /@gvalue@/ or an empty t'GVariant'
    --     in case of failure. Free with 'GI.GLib.Structs.Variant.variantUnref'.
dbusGvalueToGvariant gvalue type_ = liftIO $ do
    gvalue' <- unsafeManagedPtrGetPtr gvalue
    type_' <- unsafeManagedPtrGetPtr type_
    result <- g_dbus_gvalue_to_gvariant gvalue' type_'
    checkUnexpectedReturnNULL "dbusGvalueToGvariant" result
    result' <- B.GVariant.wrapGVariantPtr result
    touchManagedPtr gvalue
    touchManagedPtr type_
    return result'


-- function dbus_generate_guid
-- Args: []
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_generate_guid" g_dbus_generate_guid :: 
    IO CString

-- | Generate a D-Bus GUID that can be used with
-- e.g. 'GI.Gio.Objects.DBusConnection.dBusConnectionNew'.
-- 
-- See the
-- <https://dbus.freedesktop.org/doc/dbus-specification.html#uuids D-Bus specification>
-- regarding what strings are valid D-Bus GUIDs. The specification refers to
-- these as ‘UUIDs’ whereas GLib (for historical reasons) refers to them as
-- ‘GUIDs’. The terms are interchangeable.
-- 
-- Note that D-Bus GUIDs do not follow
-- <https://datatracker.ietf.org/doc/html/rfc4122 RFC 4122>.
-- 
-- /Since: 2.26/
dbusGenerateGuid ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m T.Text
    -- ^ __Returns:__ A valid D-Bus GUID. Free with 'GI.GLib.Functions.free'.
dbusGenerateGuid  = liftIO $ do
    result <- g_dbus_generate_guid
    checkUnexpectedReturnNULL "dbusGenerateGuid" result
    result' <- cstringToText result
    freeMem result
    return result'


-- function dbus_escape_object_path_bytestring
-- Args: [ Arg
--           { argCName = "bytes"
--           , argType = TCArray True (-1) (-1) (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string of bytes to escape"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_escape_object_path_bytestring" g_dbus_escape_object_path_bytestring :: 
    Ptr Word8 ->                            -- bytes : TCArray True (-1) (-1) (TBasicType TUInt8)
    IO CString

-- | Escapes /@bytes@/ for use in a D-Bus object path component.
-- /@bytes@/ is an array of zero or more nonzero bytes in an
-- unspecified encoding, followed by a single zero byte.
-- 
-- The escaping method consists of replacing all non-alphanumeric
-- characters (see @/g_ascii_isalnum()/@) with their hexadecimal value
-- preceded by an underscore (@_@). For example:
-- @foo.bar.baz@ will become @foo_2ebar_2ebaz@.
-- 
-- This method is appropriate to use when the input is nearly
-- a valid object path component but is not when your input
-- is far from being a valid object path component.
-- Other escaping algorithms are also valid to use with
-- D-Bus object paths.
-- 
-- This can be reversed with 'GI.Gio.Functions.dbusUnescapeObjectPath'.
-- 
-- /Since: 2.68/
dbusEscapeObjectPathBytestring ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ByteString
    -- ^ /@bytes@/: the string of bytes to escape
    -> m T.Text
    -- ^ __Returns:__ an escaped version of /@bytes@/. Free with 'GI.GLib.Functions.free'.
dbusEscapeObjectPathBytestring bytes = liftIO $ do
    bytes' <- packZeroTerminatedByteString bytes
    result <- g_dbus_escape_object_path_bytestring bytes'
    checkUnexpectedReturnNULL "dbusEscapeObjectPathBytestring" result
    result' <- cstringToText result
    freeMem result
    freeMem bytes'
    return result'


-- function dbus_escape_object_path
-- Args: [ Arg
--           { argCName = "s"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the string to escape"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_escape_object_path" g_dbus_escape_object_path :: 
    CString ->                              -- s : TBasicType TUTF8
    IO CString

-- | This is a language binding friendly version of 'GI.Gio.Functions.dbusEscapeObjectPathBytestring'.
-- 
-- /Since: 2.68/
dbusEscapeObjectPath ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@s@/: the string to escape
    -> m T.Text
    -- ^ __Returns:__ an escaped version of /@s@/. Free with 'GI.GLib.Functions.free'.
dbusEscapeObjectPath s = liftIO $ do
    s' <- textToCString s
    result <- g_dbus_escape_object_path s'
    checkUnexpectedReturnNULL "dbusEscapeObjectPath" result
    result' <- cstringToText result
    freeMem result
    freeMem s'
    return result'


-- function dbus_address_get_stream_sync
-- Args: [ Arg
--           { argCName = "address"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A valid D-Bus address."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "out_guid"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%NULL or return location to store the GUID extracted from @address, if any."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCancellable or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "IOStream" })
-- throws : True
-- Skip return : False

foreign import ccall "g_dbus_address_get_stream_sync" g_dbus_address_get_stream_sync :: 
    CString ->                              -- address : TBasicType TUTF8
    Ptr CString ->                          -- out_guid : TBasicType TUTF8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.IOStream.IOStream)

-- | Synchronously connects to an endpoint specified by /@address@/ and
-- sets up the connection so it is in a state to run the client-side
-- of the D-Bus authentication conversation. /@address@/ must be in the
-- <https://dbus.freedesktop.org/doc/dbus-specification.html#addresses D-Bus address format>.
-- 
-- A server is not required to set a GUID, so /@outGuid@/ may be set to 'P.Nothing'
-- even on success.
-- 
-- This is a synchronous failable function. See
-- 'GI.Gio.Functions.dbusAddressGetStream' for the asynchronous version.
-- 
-- /Since: 2.26/
dbusAddressGetStreamSync ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Cancellable.IsCancellable a) =>
    T.Text
    -- ^ /@address@/: A valid D-Bus address.
    -> Maybe (a)
    -- ^ /@cancellable@/: A t'GI.Gio.Objects.Cancellable.Cancellable' or 'P.Nothing'.
    -> m ((Gio.IOStream.IOStream, Maybe T.Text))
    -- ^ __Returns:__ A t'GI.Gio.Objects.IOStream.IOStream' or 'P.Nothing' if /@error@/ is set. /(Can throw 'Data.GI.Base.GError.GError')/
dbusAddressGetStreamSync address cancellable = liftIO $ do
    address' <- textToCString address
    outGuid <- callocMem :: IO (Ptr CString)
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_dbus_address_get_stream_sync address' outGuid maybeCancellable
        checkUnexpectedReturnNULL "dbusAddressGetStreamSync" result
        result' <- (wrapObject Gio.IOStream.IOStream) result
        outGuid' <- peek outGuid
        maybeOutGuid' <- convertIfNonNull outGuid' $ \outGuid'' -> do
            outGuid''' <- cstringToText outGuid''
            return outGuid'''
        freeMem outGuid'
        whenJust cancellable touchManagedPtr
        freeMem address'
        freeMem outGuid
        return (result', maybeOutGuid')
     ) (do
        freeMem address'
        freeMem outGuid
     )


-- function dbus_address_get_stream_finish
-- Args: [ Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GAsyncResult obtained from the GAsyncReadyCallback passed to g_dbus_address_get_stream()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "out_guid"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%NULL or return location to store the GUID extracted from @address, if any."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "IOStream" })
-- throws : True
-- Skip return : False

foreign import ccall "g_dbus_address_get_stream_finish" g_dbus_address_get_stream_finish :: 
    Ptr Gio.AsyncResult.AsyncResult ->      -- res : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr CString ->                          -- out_guid : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.IOStream.IOStream)

-- | Finishes an operation started with 'GI.Gio.Functions.dbusAddressGetStream'.
-- 
-- A server is not required to set a GUID, so /@outGuid@/ may be set to 'P.Nothing'
-- even on success.
-- 
-- /Since: 2.26/
dbusAddressGetStreamFinish ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AsyncResult.IsAsyncResult a) =>
    a
    -- ^ /@res@/: A t'GI.Gio.Interfaces.AsyncResult.AsyncResult' obtained from the GAsyncReadyCallback passed to 'GI.Gio.Functions.dbusAddressGetStream'.
    -> m ((Gio.IOStream.IOStream, Maybe T.Text))
    -- ^ __Returns:__ A t'GI.Gio.Objects.IOStream.IOStream' or 'P.Nothing' if /@error@/ is set. /(Can throw 'Data.GI.Base.GError.GError')/
dbusAddressGetStreamFinish res = liftIO $ do
    res' <- unsafeManagedPtrCastPtr res
    outGuid <- callocMem :: IO (Ptr CString)
    onException (do
        result <- propagateGError $ g_dbus_address_get_stream_finish res' outGuid
        checkUnexpectedReturnNULL "dbusAddressGetStreamFinish" result
        result' <- (wrapObject Gio.IOStream.IOStream) result
        outGuid' <- peek outGuid
        maybeOutGuid' <- convertIfNonNull outGuid' $ \outGuid'' -> do
            outGuid''' <- cstringToText outGuid''
            return outGuid'''
        freeMem outGuid'
        touchManagedPtr res
        freeMem outGuid
        return (result', maybeOutGuid')
     ) (do
        freeMem outGuid
     )


-- function dbus_address_get_stream
-- Args: [ Arg
--           { argCName = "address"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A valid D-Bus address."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GCancellable or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GAsyncReadyCallback to call when the request is satisfied."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Data to pass to @callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_address_get_stream" g_dbus_address_get_stream :: 
    CString ->                              -- address : TBasicType TUTF8
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously connects to an endpoint specified by /@address@/ and
-- sets up the connection so it is in a state to run the client-side
-- of the D-Bus authentication conversation. /@address@/ must be in the
-- <https://dbus.freedesktop.org/doc/dbus-specification.html#addresses D-Bus address format>.
-- 
-- When the operation is finished, /@callback@/ will be invoked. You can
-- then call 'GI.Gio.Functions.dbusAddressGetStreamFinish' to get the result of
-- the operation.
-- 
-- This is an asynchronous failable function. See
-- 'GI.Gio.Functions.dbusAddressGetStreamSync' for the synchronous version.
-- 
-- /Since: 2.26/
dbusAddressGetStream ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Cancellable.IsCancellable a) =>
    T.Text
    -- ^ /@address@/: A valid D-Bus address.
    -> Maybe (a)
    -- ^ /@cancellable@/: A t'GI.Gio.Objects.Cancellable.Cancellable' or 'P.Nothing'.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: A t'GI.Gio.Callbacks.AsyncReadyCallback' to call when the request is satisfied.
    -> m ()
dbusAddressGetStream address cancellable callback = liftIO $ do
    address' <- textToCString address
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_dbus_address_get_stream address' maybeCancellable maybeCallback userData
    whenJust cancellable touchManagedPtr
    freeMem address'
    return ()


-- function dbus_address_get_for_bus_sync
-- Args: [ Arg
--           { argCName = "bus_type"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "BusType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GBusType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : True
-- Skip return : False

foreign import ccall "g_dbus_address_get_for_bus_sync" g_dbus_address_get_for_bus_sync :: 
    CInt ->                                 -- bus_type : TInterface (Name {namespace = "Gio", name = "BusType"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO CString

-- | Synchronously looks up the D-Bus address for the well-known message
-- bus instance specified by /@busType@/. This may involve using various
-- platform specific mechanisms.
-- 
-- The returned address will be in the
-- <https://dbus.freedesktop.org/doc/dbus-specification.html#addresses D-Bus address format>.
-- 
-- /Since: 2.26/
dbusAddressGetForBusSync ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Cancellable.IsCancellable a) =>
    Gio.Enums.BusType
    -- ^ /@busType@/: a t'GI.Gio.Enums.BusType'
    -> Maybe (a)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable' or 'P.Nothing'
    -> m T.Text
    -- ^ __Returns:__ a valid D-Bus address string for /@busType@/ or
    --     'P.Nothing' if /@error@/ is set /(Can throw 'Data.GI.Base.GError.GError')/
dbusAddressGetForBusSync busType cancellable = liftIO $ do
    let busType' = (fromIntegral . fromEnum) busType
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_dbus_address_get_for_bus_sync busType' maybeCancellable
        checkUnexpectedReturnNULL "dbusAddressGetForBusSync" result
        result' <- cstringToText result
        freeMem result
        whenJust cancellable touchManagedPtr
        return result'
     ) (do
        return ()
     )


-- function dbus_address_escape_value
-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "an unescaped string to be included in a D-Bus address\n    as the value in a key-value pair"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_address_escape_value" g_dbus_address_escape_value :: 
    CString ->                              -- string : TBasicType TUTF8
    IO CString

-- | Escape /@string@/ so it can appear in a D-Bus address as the value
-- part of a key-value pair.
-- 
-- For instance, if /@string@/ is @\/run\/bus-for-:0@,
-- this function would return @\/run\/bus-for-%3A0@,
-- which could be used in a D-Bus address like
-- @unix:nonce-tcp:host=127.0.0.1,port=42,noncefile=\/run\/bus-for-%3A0@.
-- 
-- /Since: 2.36/
dbusAddressEscapeValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@string@/: an unescaped string to be included in a D-Bus address
    --     as the value in a key-value pair
    -> m T.Text
    -- ^ __Returns:__ a copy of /@string@/ with all
    --     non-optionally-escaped bytes escaped
dbusAddressEscapeValue string = liftIO $ do
    string' <- textToCString string
    result <- g_dbus_address_escape_value string'
    checkUnexpectedReturnNULL "dbusAddressEscapeValue" result
    result' <- cstringToText result
    freeMem result
    freeMem string'
    return result'


-- function content_types_get_registered
-- Args: []
-- Lengths: []
-- returnType: Just (TGList (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_content_types_get_registered" g_content_types_get_registered :: 
    IO (Ptr (GList CString))

-- | Gets a list of strings containing all the registered content types
-- known to the system. The list and its data should be freed using
-- @g_list_free_full (list, g_free)@.
contentTypesGetRegistered ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [T.Text]
    -- ^ __Returns:__ list of the registered
    --     content types
contentTypesGetRegistered  = liftIO $ do
    result <- g_content_types_get_registered
    result' <- unpackGList result
    result'' <- mapM cstringToText result'
    mapGList freeMem result
    g_list_free result
    return result''


-- function content_type_set_mime_dirs
-- Args: [ Arg
--           { argCName = "dirs"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%NULL-terminated list of\n   directories to load MIME data from, including any `mime/` subdirectory,\n   and with the first directory to try listed first"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_set_mime_dirs" g_content_type_set_mime_dirs :: 
    Ptr CString ->                          -- dirs : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Set the list of directories used by GIO to load the MIME database.
-- If /@dirs@/ is 'P.Nothing', the directories used are the default:
-- 
--  - the @mime@ subdirectory of the directory in @$XDG_DATA_HOME@
--  - the @mime@ subdirectory of every directory in @$XDG_DATA_DIRS@
-- 
-- This function is intended to be used when writing tests that depend on
-- information stored in the MIME database, in order to control the data.
-- 
-- Typically, in case your tests use 'GI.GLib.Constants.TEST_OPTION_ISOLATE_DIRS', but they
-- depend on the system’s MIME database, you should call this function
-- with /@dirs@/ set to 'P.Nothing' before calling @/g_test_init()/@, for instance:
-- 
-- 
-- === /C code/
-- >
-- >  // Load MIME data from the system
-- >  g_content_type_set_mime_dirs (NULL);
-- >  // Isolate the environment
-- >  g_test_init (&argc, &argv, G_TEST_OPTION_ISOLATE_DIRS, NULL);
-- >
-- >  …
-- >
-- >  return g_test_run ();
-- 
-- 
-- /Since: 2.60/
contentTypeSetMimeDirs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([T.Text])
    -- ^ /@dirs@/: 'P.Nothing'-terminated list of
    --    directories to load MIME data from, including any @mime\/@ subdirectory,
    --    and with the first directory to try listed first
    -> m ()
contentTypeSetMimeDirs dirs = liftIO $ do
    maybeDirs <- case dirs of
        Nothing -> return FP.nullPtr
        Just jDirs -> do
            jDirs' <- packZeroTerminatedUTF8CArray jDirs
            return jDirs'
    g_content_type_set_mime_dirs maybeDirs
    mapZeroTerminatedCArray freeMem maybeDirs
    freeMem maybeDirs
    return ()


-- function content_type_is_unknown
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_is_unknown" g_content_type_is_unknown :: 
    CString ->                              -- type : TBasicType TUTF8
    IO CInt

-- | Checks if the content type is the generic \"unknown\" type.
-- On UNIX this is the \"application\/octet-stream\" mimetype,
-- while on win32 it is \"*\" and on OSX it is a dynamic type
-- or octet-stream.
contentTypeIsUnknown ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@type@/: a content type string
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the type is the unknown type.
contentTypeIsUnknown type_ = liftIO $ do
    type_' <- textToCString type_
    result <- g_content_type_is_unknown type_'
    let result' = (/= 0) result
    freeMem type_'
    return result'


-- function content_type_is_mime_type
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a mime type string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_is_mime_type" g_content_type_is_mime_type :: 
    CString ->                              -- type : TBasicType TUTF8
    CString ->                              -- mime_type : TBasicType TUTF8
    IO CInt

-- | Determines if /@type@/ is a subset of /@mimeType@/.
-- Convenience wrapper around 'GI.Gio.Functions.contentTypeIsA'.
-- 
-- /Since: 2.52/
contentTypeIsMimeType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@type@/: a content type string
    -> T.Text
    -- ^ /@mimeType@/: a mime type string
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@type@/ is a kind of /@mimeType@/,
    --     'P.False' otherwise.
contentTypeIsMimeType type_ mimeType = liftIO $ do
    type_' <- textToCString type_
    mimeType' <- textToCString mimeType
    result <- g_content_type_is_mime_type type_' mimeType'
    let result' = (/= 0) result
    freeMem type_'
    freeMem mimeType'
    return result'


-- function content_type_is_a
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "supertype"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_is_a" g_content_type_is_a :: 
    CString ->                              -- type : TBasicType TUTF8
    CString ->                              -- supertype : TBasicType TUTF8
    IO CInt

-- | Determines if /@type@/ is a subset of /@supertype@/.
contentTypeIsA ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@type@/: a content type string
    -> T.Text
    -- ^ /@supertype@/: a content type string
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@type@/ is a kind of /@supertype@/,
    --     'P.False' otherwise.
contentTypeIsA type_ supertype = liftIO $ do
    type_' <- textToCString type_
    supertype' <- textToCString supertype
    result <- g_content_type_is_a type_' supertype'
    let result' = (/= 0) result
    freeMem type_'
    freeMem supertype'
    return result'


-- function content_type_guess_for_tree
-- Args: [ Arg
--           { argCName = "root"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the root of the tree to guess a type for"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_guess_for_tree" g_content_type_guess_for_tree :: 
    Ptr Gio.File.File ->                    -- root : TInterface (Name {namespace = "Gio", name = "File"})
    IO (Ptr CString)

-- | Tries to guess the type of the tree with root /@root@/, by
-- looking at the files it contains. The result is an array
-- of content types, with the best guess coming first.
-- 
-- The types returned all have the form x-content\/foo, e.g.
-- x-content\/audio-cdda (for audio CDs) or x-content\/image-dcf
-- (for a camera memory card). See the
-- <http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec shared-mime-info>
-- specification for more on x-content types.
-- 
-- This function is useful in the implementation of
-- 'GI.Gio.Interfaces.Mount.mountGuessContentType'.
-- 
-- /Since: 2.18/
contentTypeGuessForTree ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.File.IsFile a) =>
    a
    -- ^ /@root@/: the root of the tree to guess a type for
    -> m [T.Text]
    -- ^ __Returns:__ an 'P.Nothing'-terminated
    --     array of zero or more content types. Free with 'GI.GLib.Functions.strfreev'
contentTypeGuessForTree root = liftIO $ do
    root' <- unsafeManagedPtrCastPtr root
    result <- g_content_type_guess_for_tree root'
    checkUnexpectedReturnNULL "contentTypeGuessForTree" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    touchManagedPtr root
    return result'


-- function content_type_guess
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a path, or %NULL" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a stream of data, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data_size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of @data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result_uncertain"
--           , argType = TBasicType TBoolean
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the certainty\n    of the result, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "data_size"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the size of @data" , sinceVersion = Nothing }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_guess" g_content_type_guess :: 
    CString ->                              -- filename : TBasicType TFileName
    Ptr Word8 ->                            -- data : TCArray False (-1) 2 (TBasicType TUInt8)
    FCT.CSize ->                            -- data_size : TBasicType TSize
    Ptr CInt ->                             -- result_uncertain : TBasicType TBoolean
    IO CString

-- | Guesses the content type based on example data. If the function is
-- uncertain, /@resultUncertain@/ will be set to 'P.True'. Either /@filename@/
-- or /@data@/ may be 'P.Nothing', in which case the guess will be based solely
-- on the other argument.
contentTypeGuess ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([Char])
    -- ^ /@filename@/: a path, or 'P.Nothing'
    -> Maybe (ByteString)
    -- ^ /@data@/: a stream of data, or 'P.Nothing'
    -> m ((T.Text, Bool))
    -- ^ __Returns:__ a string indicating a guessed content type for the
    --     given data. Free with 'GI.GLib.Functions.free'
contentTypeGuess filename data_ = liftIO $ do
    let dataSize = case data_ of
            Nothing -> 0
            Just jData_ -> fromIntegral $ B.length jData_
    maybeFilename <- case filename of
        Nothing -> return FP.nullPtr
        Just jFilename -> do
            jFilename' <- stringToCString jFilename
            return jFilename'
    maybeData_ <- case data_ of
        Nothing -> return FP.nullPtr
        Just jData_ -> do
            jData_' <- packByteString jData_
            return jData_'
    resultUncertain <- allocMem :: IO (Ptr CInt)
    result <- g_content_type_guess maybeFilename maybeData_ dataSize resultUncertain
    checkUnexpectedReturnNULL "contentTypeGuess" result
    result' <- cstringToText result
    freeMem result
    resultUncertain' <- peek resultUncertain
    let resultUncertain'' = (/= 0) resultUncertain'
    freeMem maybeFilename
    freeMem maybeData_
    freeMem resultUncertain
    return (result', resultUncertain'')


-- function content_type_get_symbolic_icon
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_get_symbolic_icon" g_content_type_get_symbolic_icon :: 
    CString ->                              -- type : TBasicType TUTF8
    IO (Ptr Gio.Icon.Icon)

-- | Gets the symbolic icon for a content type.
-- 
-- /Since: 2.34/
contentTypeGetSymbolicIcon ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@type@/: a content type string
    -> m Gio.Icon.Icon
    -- ^ __Returns:__ symbolic t'GI.Gio.Interfaces.Icon.Icon' corresponding to the content type.
    --     Free the returned object with 'GI.GObject.Objects.Object.objectUnref'
contentTypeGetSymbolicIcon type_ = liftIO $ do
    type_' <- textToCString type_
    result <- g_content_type_get_symbolic_icon type_'
    checkUnexpectedReturnNULL "contentTypeGetSymbolicIcon" result
    result' <- (wrapObject Gio.Icon.Icon) result
    freeMem type_'
    return result'


-- function content_type_get_mime_type
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_get_mime_type" g_content_type_get_mime_type :: 
    CString ->                              -- type : TBasicType TUTF8
    IO CString

-- | Gets the mime type for the content type, if one is registered.
contentTypeGetMimeType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@type@/: a content type string
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the registered mime type for the
    --     given /@type@/, or 'P.Nothing' if unknown; free with 'GI.GLib.Functions.free'.
contentTypeGetMimeType type_ = liftIO $ do
    type_' <- textToCString type_
    result <- g_content_type_get_mime_type type_'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    freeMem type_'
    return maybeResult


-- function content_type_get_mime_dirs
-- Args: []
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_get_mime_dirs" g_content_type_get_mime_dirs :: 
    IO (Ptr CString)

-- | Get the list of directories which MIME data is loaded from. See
-- 'GI.Gio.Functions.contentTypeSetMimeDirs' for details.
-- 
-- /Since: 2.60/
contentTypeGetMimeDirs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m [T.Text]
    -- ^ __Returns:__ 'P.Nothing'-terminated list of
    --    directories to load MIME data from, including any @mime\/@ subdirectory,
    --    and with the first directory to try listed first
contentTypeGetMimeDirs  = liftIO $ do
    result <- g_content_type_get_mime_dirs
    checkUnexpectedReturnNULL "contentTypeGetMimeDirs" result
    result' <- unpackZeroTerminatedUTF8CArray result
    return result'


-- function content_type_get_icon
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_get_icon" g_content_type_get_icon :: 
    CString ->                              -- type : TBasicType TUTF8
    IO (Ptr Gio.Icon.Icon)

-- | Gets the icon for a content type.
contentTypeGetIcon ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@type@/: a content type string
    -> m Gio.Icon.Icon
    -- ^ __Returns:__ t'GI.Gio.Interfaces.Icon.Icon' corresponding to the content type. Free the returned
    --     object with 'GI.GObject.Objects.Object.objectUnref'
contentTypeGetIcon type_ = liftIO $ do
    type_' <- textToCString type_
    result <- g_content_type_get_icon type_'
    checkUnexpectedReturnNULL "contentTypeGetIcon" result
    result' <- (wrapObject Gio.Icon.Icon) result
    freeMem type_'
    return result'


-- function content_type_get_generic_icon_name
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_get_generic_icon_name" g_content_type_get_generic_icon_name :: 
    CString ->                              -- type : TBasicType TUTF8
    IO CString

-- | Gets the generic icon name for a content type.
-- 
-- See the
-- <http://www.freedesktop.org/wiki/Specifications/shared-mime-info-spec shared-mime-info>
-- specification for more on the generic icon name.
-- 
-- /Since: 2.34/
contentTypeGetGenericIconName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@type@/: a content type string
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the registered generic icon name for the given /@type@/,
    --     or 'P.Nothing' if unknown. Free with 'GI.GLib.Functions.free'
contentTypeGetGenericIconName type_ = liftIO $ do
    type_' <- textToCString type_
    result <- g_content_type_get_generic_icon_name type_'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    freeMem type_'
    return maybeResult


-- function content_type_get_description
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_get_description" g_content_type_get_description :: 
    CString ->                              -- type : TBasicType TUTF8
    IO CString

-- | Gets the human readable description of the content type.
contentTypeGetDescription ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@type@/: a content type string
    -> m T.Text
    -- ^ __Returns:__ a short description of the content type /@type@/. Free the
    --     returned string with 'GI.GLib.Functions.free'
contentTypeGetDescription type_ = liftIO $ do
    type_' <- textToCString type_
    result <- g_content_type_get_description type_'
    checkUnexpectedReturnNULL "contentTypeGetDescription" result
    result' <- cstringToText result
    freeMem result
    freeMem type_'
    return result'


-- function content_type_from_mime_type
-- Args: [ Arg
--           { argCName = "mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a mime type string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_from_mime_type" g_content_type_from_mime_type :: 
    CString ->                              -- mime_type : TBasicType TUTF8
    IO CString

-- | Tries to find a content type based on the mime type name.
-- 
-- /Since: 2.18/
contentTypeFromMimeType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@mimeType@/: a mime type string
    -> m (Maybe T.Text)
    -- ^ __Returns:__ Newly allocated string with content type or
    --     'P.Nothing'. Free with 'GI.GLib.Functions.free'
contentTypeFromMimeType mimeType = liftIO $ do
    mimeType' <- textToCString mimeType
    result <- g_content_type_from_mime_type mimeType'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    freeMem mimeType'
    return maybeResult


-- function content_type_equals
-- Args: [ Arg
--           { argCName = "type1"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type2"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_equals" g_content_type_equals :: 
    CString ->                              -- type1 : TBasicType TUTF8
    CString ->                              -- type2 : TBasicType TUTF8
    IO CInt

-- | Compares two content types for equality.
contentTypeEquals ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@type1@/: a content type string
    -> T.Text
    -- ^ /@type2@/: a content type string
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the two strings are identical or equivalent,
    --     'P.False' otherwise.
contentTypeEquals type1 type2 = liftIO $ do
    type1' <- textToCString type1
    type2' <- textToCString type2
    result <- g_content_type_equals type1' type2'
    let result' = (/= 0) result
    freeMem type1'
    freeMem type2'
    return result'


-- function content_type_can_be_executable
-- Args: [ Arg
--           { argCName = "type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a content type string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_content_type_can_be_executable" g_content_type_can_be_executable :: 
    CString ->                              -- type : TBasicType TUTF8
    IO CInt

-- | Checks if a content type can be executable. Note that for instance
-- things like text files can be executables (i.e. scripts and batch files).
contentTypeCanBeExecutable ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@type@/: a content type string
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the file type corresponds to a type that
    --     can be executable, 'P.False' otherwise.
contentTypeCanBeExecutable type_ = liftIO $ do
    type_' <- textToCString type_
    result <- g_content_type_can_be_executable type_'
    let result' = (/= 0) result
    freeMem type_'
    return result'


-- function bus_watch_name_on_connection
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name (well-known or unique) to watch."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BusNameWatcherFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Flags from the #GBusNameWatcherFlags enumeration."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name_appeared_closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "#GClosure to invoke when @name is known\nto exist or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name_vanished_closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "#GClosure to invoke when @name is known\nto not exist or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_bus_watch_name_on_connection_with_closures" g_bus_watch_name_on_connection_with_closures :: 
    Ptr Gio.DBusConnection.DBusConnection -> -- connection : TInterface (Name {namespace = "Gio", name = "DBusConnection"})
    CString ->                              -- name : TBasicType TUTF8
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "BusNameWatcherFlags"})
    Ptr (GClosure ()) ->                    -- name_appeared_closure : TGClosure Nothing
    Ptr (GClosure ()) ->                    -- name_vanished_closure : TGClosure Nothing
    IO Word32

-- | Version of @/g_bus_watch_name_on_connection()/@ using closures instead of callbacks for
-- easier binding in other languages.
-- 
-- /Since: 2.26/
busWatchNameOnConnection ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    a
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> T.Text
    -- ^ /@name@/: The name (well-known or unique) to watch.
    -> [Gio.Flags.BusNameWatcherFlags]
    -- ^ /@flags@/: Flags from the t'GI.Gio.Flags.BusNameWatcherFlags' enumeration.
    -> Maybe (GClosure b)
    -- ^ /@nameAppearedClosure@/: t'GI.GObject.Structs.Closure.Closure' to invoke when /@name@/ is known
    -- to exist or 'P.Nothing'.
    -> Maybe (GClosure c)
    -- ^ /@nameVanishedClosure@/: t'GI.GObject.Structs.Closure.Closure' to invoke when /@name@/ is known
    -- to not exist or 'P.Nothing'.
    -> m Word32
    -- ^ __Returns:__ An identifier (never 0) that can be used with
    -- 'GI.Gio.Functions.busUnwatchName' to stop watching the name.
busWatchNameOnConnection connection name flags nameAppearedClosure nameVanishedClosure = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    name' <- textToCString name
    let flags' = gflagsToWord flags
    maybeNameAppearedClosure <- case nameAppearedClosure of
        Nothing -> return FP.nullPtr
        Just jNameAppearedClosure -> do
            jNameAppearedClosure' <- unsafeManagedPtrCastPtr jNameAppearedClosure
            return jNameAppearedClosure'
    maybeNameVanishedClosure <- case nameVanishedClosure of
        Nothing -> return FP.nullPtr
        Just jNameVanishedClosure -> do
            jNameVanishedClosure' <- unsafeManagedPtrCastPtr jNameVanishedClosure
            return jNameVanishedClosure'
    result <- g_bus_watch_name_on_connection_with_closures connection' name' flags' maybeNameAppearedClosure maybeNameVanishedClosure
    touchManagedPtr connection
    whenJust nameAppearedClosure touchManagedPtr
    whenJust nameVanishedClosure touchManagedPtr
    freeMem name'
    return result


-- function bus_watch_name
-- Args: [ Arg
--           { argCName = "bus_type"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "BusType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The type of bus to watch a name on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name (well-known or unique) to watch."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "BusNameWatcherFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Flags from the #GBusNameWatcherFlags enumeration."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name_appeared_closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "#GClosure to invoke when @name is known\nto exist or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name_vanished_closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "#GClosure to invoke when @name is known\nto not exist or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_bus_watch_name_with_closures" g_bus_watch_name_with_closures :: 
    CInt ->                                 -- bus_type : TInterface (Name {namespace = "Gio", name = "BusType"})
    CString ->                              -- name : TBasicType TUTF8
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "BusNameWatcherFlags"})
    Ptr (GClosure ()) ->                    -- name_appeared_closure : TGClosure Nothing
    Ptr (GClosure ()) ->                    -- name_vanished_closure : TGClosure Nothing
    IO Word32

-- | Version of @/g_bus_watch_name()/@ using closures instead of callbacks for
-- easier binding in other languages.
-- 
-- /Since: 2.26/
busWatchName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.Enums.BusType
    -- ^ /@busType@/: The type of bus to watch a name on.
    -> T.Text
    -- ^ /@name@/: The name (well-known or unique) to watch.
    -> [Gio.Flags.BusNameWatcherFlags]
    -- ^ /@flags@/: Flags from the t'GI.Gio.Flags.BusNameWatcherFlags' enumeration.
    -> Maybe (GClosure a)
    -- ^ /@nameAppearedClosure@/: t'GI.GObject.Structs.Closure.Closure' to invoke when /@name@/ is known
    -- to exist or 'P.Nothing'.
    -> Maybe (GClosure b)
    -- ^ /@nameVanishedClosure@/: t'GI.GObject.Structs.Closure.Closure' to invoke when /@name@/ is known
    -- to not exist or 'P.Nothing'.
    -> m Word32
    -- ^ __Returns:__ An identifier (never 0) that can be used with
    -- 'GI.Gio.Functions.busUnwatchName' to stop watching the name.
busWatchName busType name flags nameAppearedClosure nameVanishedClosure = liftIO $ do
    let busType' = (fromIntegral . fromEnum) busType
    name' <- textToCString name
    let flags' = gflagsToWord flags
    maybeNameAppearedClosure <- case nameAppearedClosure of
        Nothing -> return FP.nullPtr
        Just jNameAppearedClosure -> do
            jNameAppearedClosure' <- unsafeManagedPtrCastPtr jNameAppearedClosure
            return jNameAppearedClosure'
    maybeNameVanishedClosure <- case nameVanishedClosure of
        Nothing -> return FP.nullPtr
        Just jNameVanishedClosure -> do
            jNameVanishedClosure' <- unsafeManagedPtrCastPtr jNameVanishedClosure
            return jNameVanishedClosure'
    result <- g_bus_watch_name_with_closures busType' name' flags' maybeNameAppearedClosure maybeNameVanishedClosure
    whenJust nameAppearedClosure touchManagedPtr
    whenJust nameVanishedClosure touchManagedPtr
    freeMem name'
    return result


-- function bus_unwatch_name
-- Args: [ Arg
--           { argCName = "watcher_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "An identifier obtained from g_bus_watch_name()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_bus_unwatch_name" g_bus_unwatch_name :: 
    Word32 ->                               -- watcher_id : TBasicType TUInt
    IO ()

-- | Stops watching a name.
-- 
-- Note that there may still be D-Bus traffic to process (relating to watching
-- and unwatching the name) in the current thread-default t'GI.GLib.Structs.MainContext.MainContext' after
-- this function has returned. You should continue to iterate the t'GI.GLib.Structs.MainContext.MainContext'
-- until the t'GI.GLib.Callbacks.DestroyNotify' function passed to @/g_bus_watch_name()/@ is called, in
-- order to avoid memory leaks through callbacks queued on the t'GI.GLib.Structs.MainContext.MainContext'
-- after it’s stopped being iterated.
-- 
-- /Since: 2.26/
busUnwatchName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@watcherId@/: An identifier obtained from @/g_bus_watch_name()/@
    -> m ()
busUnwatchName watcherId = liftIO $ do
    g_bus_unwatch_name watcherId
    return ()


-- function bus_unown_name
-- Args: [ Arg
--           { argCName = "owner_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "an identifier obtained from [func@Gio.bus_own_name]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_bus_unown_name" g_bus_unown_name :: 
    Word32 ->                               -- owner_id : TBasicType TUInt
    IO ()

-- | Stops owning a name.
-- 
-- Note that there may still be D-Bus traffic to process (relating to owning
-- and unowning the name) in the current thread-default
-- [struct/@gLib@/.MainContext] after this function has returned. You should
-- continue to iterate the [struct/@gLib@/.MainContext] until the
-- [callback/@gLib@/.DestroyNotify] function passed to 'GI.Gio.Functions.busOwnName' is
-- called, in order to avoid memory leaks through callbacks queued on the
-- [struct/@gLib@/.MainContext] after it’s stopped being iterated.
-- 
-- /Since: 2.26/
busUnownName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Word32
    -- ^ /@ownerId@/: an identifier obtained from 'GI.Gio.Functions.busOwnName'
    -> m ()
busUnownName ownerId = liftIO $ do
    g_bus_unown_name ownerId
    return ()


-- function bus_own_name_on_connection
-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a bus connection" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the well-known name to own"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "BusNameOwnerFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a set of flags with ownership options"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name_acquired_closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "closure to invoke when @name is\n  acquired, or `NULL` to ignore"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name_lost_closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "closure to invoke when @name is lost,\n  or `NULL` to ignore"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_bus_own_name_on_connection_with_closures" g_bus_own_name_on_connection_with_closures :: 
    Ptr Gio.DBusConnection.DBusConnection -> -- connection : TInterface (Name {namespace = "Gio", name = "DBusConnection"})
    CString ->                              -- name : TBasicType TUTF8
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "BusNameOwnerFlags"})
    Ptr (GClosure ()) ->                    -- name_acquired_closure : TGClosure Nothing
    Ptr (GClosure ()) ->                    -- name_lost_closure : TGClosure Nothing
    IO Word32

-- | Version of 'GI.Gio.Functions.busOwnNameOnConnection' using closures instead of
-- callbacks for easier binding in other languages.
-- 
-- /Since: 2.26/
busOwnNameOnConnection ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    a
    -- ^ /@connection@/: a bus connection
    -> T.Text
    -- ^ /@name@/: the well-known name to own
    -> [Gio.Flags.BusNameOwnerFlags]
    -- ^ /@flags@/: a set of flags with ownership options
    -> Maybe (GClosure b)
    -- ^ /@nameAcquiredClosure@/: closure to invoke when /@name@/ is
    --   acquired, or @NULL@ to ignore
    -> Maybe (GClosure c)
    -- ^ /@nameLostClosure@/: closure to invoke when /@name@/ is lost,
    --   or @NULL@ to ignore
    -> m Word32
    -- ^ __Returns:__ an identifier (never 0) that can be used with
    --   'GI.Gio.Functions.busUnownName' to stop owning the name.
busOwnNameOnConnection connection name flags nameAcquiredClosure nameLostClosure = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    name' <- textToCString name
    let flags' = gflagsToWord flags
    maybeNameAcquiredClosure <- case nameAcquiredClosure of
        Nothing -> return FP.nullPtr
        Just jNameAcquiredClosure -> do
            jNameAcquiredClosure' <- unsafeManagedPtrCastPtr jNameAcquiredClosure
            return jNameAcquiredClosure'
    maybeNameLostClosure <- case nameLostClosure of
        Nothing -> return FP.nullPtr
        Just jNameLostClosure -> do
            jNameLostClosure' <- unsafeManagedPtrCastPtr jNameLostClosure
            return jNameLostClosure'
    result <- g_bus_own_name_on_connection_with_closures connection' name' flags' maybeNameAcquiredClosure maybeNameLostClosure
    touchManagedPtr connection
    whenJust nameAcquiredClosure touchManagedPtr
    whenJust nameLostClosure touchManagedPtr
    freeMem name'
    return result


-- function bus_own_name
-- Args: [ Arg
--           { argCName = "bus_type"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "BusType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type of bus to own a name on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the well-known name to own"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "BusNameOwnerFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a set of flags with ownership options"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bus_acquired_closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "closure to invoke when connected to\n  the bus of type @bus_type, or `NULL` to ignore"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name_acquired_closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "closure to invoke when @name is\n  acquired, or `NULL` to ignore"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name_lost_closure"
--           , argType = TGClosure Nothing
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "closure to invoke when @name is lost, or\n  `NULL` to ignore"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_bus_own_name_with_closures" g_bus_own_name_with_closures :: 
    CInt ->                                 -- bus_type : TInterface (Name {namespace = "Gio", name = "BusType"})
    CString ->                              -- name : TBasicType TUTF8
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gio", name = "BusNameOwnerFlags"})
    Ptr (GClosure ()) ->                    -- bus_acquired_closure : TGClosure Nothing
    Ptr (GClosure ()) ->                    -- name_acquired_closure : TGClosure Nothing
    Ptr (GClosure ()) ->                    -- name_lost_closure : TGClosure Nothing
    IO Word32

-- | Version of [func/@gio@/.bus_own_name using closures instead of callbacks for
-- easier binding in other languages.
-- 
-- /Since: 2.26/
busOwnName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gio.Enums.BusType
    -- ^ /@busType@/: the type of bus to own a name on
    -> T.Text
    -- ^ /@name@/: the well-known name to own
    -> [Gio.Flags.BusNameOwnerFlags]
    -- ^ /@flags@/: a set of flags with ownership options
    -> Maybe (GClosure a)
    -- ^ /@busAcquiredClosure@/: closure to invoke when connected to
    --   the bus of type /@busType@/, or @NULL@ to ignore
    -> Maybe (GClosure b)
    -- ^ /@nameAcquiredClosure@/: closure to invoke when /@name@/ is
    --   acquired, or @NULL@ to ignore
    -> Maybe (GClosure c)
    -- ^ /@nameLostClosure@/: closure to invoke when /@name@/ is lost, or
    --   @NULL@ to ignore
    -> m Word32
    -- ^ __Returns:__ an identifier (never 0) that can be used with
    --   'GI.Gio.Functions.busUnownName' to stop owning the name.
busOwnName busType name flags busAcquiredClosure nameAcquiredClosure nameLostClosure = liftIO $ do
    let busType' = (fromIntegral . fromEnum) busType
    name' <- textToCString name
    let flags' = gflagsToWord flags
    maybeBusAcquiredClosure <- case busAcquiredClosure of
        Nothing -> return FP.nullPtr
        Just jBusAcquiredClosure -> do
            jBusAcquiredClosure' <- unsafeManagedPtrCastPtr jBusAcquiredClosure
            return jBusAcquiredClosure'
    maybeNameAcquiredClosure <- case nameAcquiredClosure of
        Nothing -> return FP.nullPtr
        Just jNameAcquiredClosure -> do
            jNameAcquiredClosure' <- unsafeManagedPtrCastPtr jNameAcquiredClosure
            return jNameAcquiredClosure'
    maybeNameLostClosure <- case nameLostClosure of
        Nothing -> return FP.nullPtr
        Just jNameLostClosure -> do
            jNameLostClosure' <- unsafeManagedPtrCastPtr jNameLostClosure
            return jNameLostClosure'
    result <- g_bus_own_name_with_closures busType' name' flags' maybeBusAcquiredClosure maybeNameAcquiredClosure maybeNameLostClosure
    whenJust busAcquiredClosure touchManagedPtr
    whenJust nameAcquiredClosure touchManagedPtr
    whenJust nameLostClosure touchManagedPtr
    freeMem name'
    return result


-- function bus_get_sync
-- Args: [ Arg
--           { argCName = "bus_type"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "BusType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GBusType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_bus_get_sync" g_bus_get_sync :: 
    CInt ->                                 -- bus_type : TInterface (Name {namespace = "Gio", name = "BusType"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.DBusConnection.DBusConnection)

-- | Synchronously connects to the message bus specified by /@busType@/.
-- Note that the returned object may shared with other callers,
-- e.g. if two separate parts of a process calls this function with
-- the same /@busType@/, they will share the same object.
-- 
-- This is a synchronous failable function. See 'GI.Gio.Functions.busGet' and
-- 'GI.Gio.Functions.busGetFinish' for the asynchronous version.
-- 
-- The returned object is a singleton, that is, shared with other
-- callers of 'GI.Gio.Functions.busGet' and 'GI.Gio.Functions.busGetSync' for /@busType@/. In the
-- event that you need a private message bus connection, use
-- 'GI.Gio.Functions.dbusAddressGetForBusSync' and
-- 'GI.Gio.Objects.DBusConnection.dBusConnectionNewForAddress' with
-- G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT and
-- G_DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION flags.
-- 
-- Note that the returned t'GI.Gio.Objects.DBusConnection.DBusConnection' object will (usually) have
-- the [DBusConnection:exitOnClose]("GI.Gio.Objects.DBusConnection#g:attr:exitOnClose") property set to 'P.True'.
-- 
-- /Since: 2.26/
busGetSync ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Cancellable.IsCancellable a) =>
    Gio.Enums.BusType
    -- ^ /@busType@/: a t'GI.Gio.Enums.BusType'
    -> Maybe (a)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable' or 'P.Nothing'
    -> m Gio.DBusConnection.DBusConnection
    -- ^ __Returns:__ a t'GI.Gio.Objects.DBusConnection.DBusConnection' or 'P.Nothing' if /@error@/ is set.
    --     Free with 'GI.GObject.Objects.Object.objectUnref'. /(Can throw 'Data.GI.Base.GError.GError')/
busGetSync busType cancellable = liftIO $ do
    let busType' = (fromIntegral . fromEnum) busType
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ g_bus_get_sync busType' maybeCancellable
        checkUnexpectedReturnNULL "busGetSync" result
        result' <- (wrapObject Gio.DBusConnection.DBusConnection) result
        whenJust cancellable touchManagedPtr
        return result'
     ) (do
        return ()
     )


-- function bus_get_finish
-- Args: [ Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncResult obtained from the #GAsyncReadyCallback passed\n    to g_bus_get()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "DBusConnection" })
-- throws : True
-- Skip return : False

foreign import ccall "g_bus_get_finish" g_bus_get_finish :: 
    Ptr Gio.AsyncResult.AsyncResult ->      -- res : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.DBusConnection.DBusConnection)

-- | Finishes an operation started with 'GI.Gio.Functions.busGet'.
-- 
-- The returned object is a singleton, that is, shared with other
-- callers of 'GI.Gio.Functions.busGet' and 'GI.Gio.Functions.busGetSync' for /@busType@/. In the
-- event that you need a private message bus connection, use
-- 'GI.Gio.Functions.dbusAddressGetForBusSync' and
-- 'GI.Gio.Objects.DBusConnection.dBusConnectionNewForAddress' with
-- G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT and
-- G_DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION flags.
-- 
-- Note that the returned t'GI.Gio.Objects.DBusConnection.DBusConnection' object will (usually) have
-- the [DBusConnection:exitOnClose]("GI.Gio.Objects.DBusConnection#g:attr:exitOnClose") property set to 'P.True'.
-- 
-- /Since: 2.26/
busGetFinish ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.AsyncResult.IsAsyncResult a) =>
    a
    -- ^ /@res@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult' obtained from the t'GI.Gio.Callbacks.AsyncReadyCallback' passed
    --     to 'GI.Gio.Functions.busGet'
    -> m Gio.DBusConnection.DBusConnection
    -- ^ __Returns:__ a t'GI.Gio.Objects.DBusConnection.DBusConnection' or 'P.Nothing' if /@error@/ is set.
    --     Free with 'GI.GObject.Objects.Object.objectUnref'. /(Can throw 'Data.GI.Base.GError.GError')/
busGetFinish res = liftIO $ do
    res' <- unsafeManagedPtrCastPtr res
    onException (do
        result <- propagateGError $ g_bus_get_finish res'
        checkUnexpectedReturnNULL "busGetFinish" result
        result' <- (wrapObject Gio.DBusConnection.DBusConnection) result
        touchManagedPtr res
        return result'
     ) (do
        return ()
     )


-- function bus_get
-- Args: [ Arg
--           { argCName = "bus_type"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "BusType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GBusType" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCancellable or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GAsyncReadyCallback to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_bus_get" g_bus_get :: 
    CInt ->                                 -- bus_type : TInterface (Name {namespace = "Gio", name = "BusType"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously connects to the message bus specified by /@busType@/.
-- 
-- When the operation is finished, /@callback@/ will be invoked. You can
-- then call 'GI.Gio.Functions.busGetFinish' to get the result of the operation.
-- 
-- This is an asynchronous failable function. See 'GI.Gio.Functions.busGetSync' for
-- the synchronous version.
-- 
-- /Since: 2.26/
busGet ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Cancellable.IsCancellable a) =>
    Gio.Enums.BusType
    -- ^ /@busType@/: a t'GI.Gio.Enums.BusType'
    -> Maybe (a)
    -- ^ /@cancellable@/: a t'GI.Gio.Objects.Cancellable.Cancellable' or 'P.Nothing'
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback' to call when the request is satisfied
    -> m ()
busGet busType cancellable callback = liftIO $ do
    let busType' = (fromIntegral . fromEnum) busType
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    g_bus_get busType' maybeCancellable maybeCallback userData
    whenJust cancellable touchManagedPtr
    return ()



