

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Flags
    ( 

 -- * Flags


-- ** AppInfoCreateFlags #flag:AppInfoCreateFlags#

    AppInfoCreateFlags(..)                  ,


-- ** ApplicationFlags #flag:ApplicationFlags#

    ApplicationFlags(..)                    ,


-- ** AskPasswordFlags #flag:AskPasswordFlags#

    AskPasswordFlags(..)                    ,


-- ** BusNameOwnerFlags #flag:BusNameOwnerFlags#

    BusNameOwnerFlags(..)                   ,


-- ** BusNameWatcherFlags #flag:BusNameWatcherFlags#

    BusNameWatcherFlags(..)                 ,


-- ** ConverterFlags #flag:ConverterFlags#

    ConverterFlags(..)                      ,


-- ** DBusCallFlags #flag:DBusCallFlags#

    DBusCallFlags(..)                       ,


-- ** DBusCapabilityFlags #flag:DBusCapabilityFlags#

    DBusCapabilityFlags(..)                 ,


-- ** DBusConnectionFlags #flag:DBusConnectionFlags#

    DBusConnectionFlags(..)                 ,


-- ** DBusInterfaceSkeletonFlags #flag:DBusInterfaceSkeletonFlags#

    DBusInterfaceSkeletonFlags(..)          ,


-- ** DBusMessageFlags #flag:DBusMessageFlags#

    DBusMessageFlags(..)                    ,


-- ** DBusObjectManagerClientFlags #flag:DBusObjectManagerClientFlags#

    DBusObjectManagerClientFlags(..)        ,


-- ** DBusPropertyInfoFlags #flag:DBusPropertyInfoFlags#

    DBusPropertyInfoFlags(..)               ,


-- ** DBusProxyFlags #flag:DBusProxyFlags#

    DBusProxyFlags(..)                      ,


-- ** DBusSendMessageFlags #flag:DBusSendMessageFlags#

    DBusSendMessageFlags(..)                ,


-- ** DBusServerFlags #flag:DBusServerFlags#

    DBusServerFlags(..)                     ,


-- ** DBusSignalFlags #flag:DBusSignalFlags#

    DBusSignalFlags(..)                     ,


-- ** DBusSubtreeFlags #flag:DBusSubtreeFlags#

    DBusSubtreeFlags(..)                    ,


-- ** DriveStartFlags #flag:DriveStartFlags#

    DriveStartFlags(..)                     ,


-- ** FileAttributeInfoFlags #flag:FileAttributeInfoFlags#

    FileAttributeInfoFlags(..)              ,


-- ** FileCopyFlags #flag:FileCopyFlags#

    FileCopyFlags(..)                       ,


-- ** FileCreateFlags #flag:FileCreateFlags#

    FileCreateFlags(..)                     ,


-- ** FileMeasureFlags #flag:FileMeasureFlags#

    FileMeasureFlags(..)                    ,


-- ** FileMonitorFlags #flag:FileMonitorFlags#

    FileMonitorFlags(..)                    ,


-- ** FileQueryInfoFlags #flag:FileQueryInfoFlags#

    FileQueryInfoFlags(..)                  ,


-- ** IOStreamSpliceFlags #flag:IOStreamSpliceFlags#

    IOStreamSpliceFlags(..)                 ,


-- ** MountMountFlags #flag:MountMountFlags#

    MountMountFlags(..)                     ,


-- ** MountUnmountFlags #flag:MountUnmountFlags#

    MountUnmountFlags(..)                   ,


-- ** OutputStreamSpliceFlags #flag:OutputStreamSpliceFlags#

    OutputStreamSpliceFlags(..)             ,


-- ** ResolverNameLookupFlags #flag:ResolverNameLookupFlags#

    ResolverNameLookupFlags(..)             ,


-- ** ResourceFlags #flag:ResourceFlags#

    ResourceFlags(..)                       ,


-- ** ResourceLookupFlags #flag:ResourceLookupFlags#

    ResourceLookupFlags(..)                 ,


-- ** SettingsBindFlags #flag:SettingsBindFlags#

    SettingsBindFlags(..)                   ,


-- ** SocketMsgFlags #flag:SocketMsgFlags#

    SocketMsgFlags(..)                      ,


-- ** SubprocessFlags #flag:SubprocessFlags#

    SubprocessFlags(..)                     ,


-- ** TestDBusFlags #flag:TestDBusFlags#

    TestDBusFlags(..)                       ,


-- ** TlsCertificateFlags #flag:TlsCertificateFlags#

    TlsCertificateFlags(..)                 ,


-- ** TlsDatabaseVerifyFlags #flag:TlsDatabaseVerifyFlags#

    TlsDatabaseVerifyFlags(..)              ,


-- ** TlsPasswordFlags #flag:TlsPasswordFlags#

    TlsPasswordFlags(..)                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Flags TlsPasswordFlags
-- | Various flags for the password.
-- 
-- /Since: 2.30/
data TlsPasswordFlags = 
      TlsPasswordFlagsNone
    -- ^ No flags
    | TlsPasswordFlagsRetry
    -- ^ The password was wrong, and the user should retry.
    | TlsPasswordFlagsManyTries
    -- ^ Hint to the user that the password has been
    --    wrong many times, and the user may not have many chances left.
    | TlsPasswordFlagsFinalTry
    -- ^ Hint to the user that this is the last try to get
    --    this password right.
    | TlsPasswordFlagsPkcs11User
    -- ^ For PKCS @/11/@, the user PIN is required.
    --    Since: 2.70.
    | TlsPasswordFlagsPkcs11SecurityOfficer
    -- ^ For PKCS @/11/@, the security officer
    --    PIN is required. Since: 2.70.
    | TlsPasswordFlagsPkcs11ContextSpecific
    -- ^ For PKCS @/11/@, the context-specific
    --    PIN is required. Since: 2.70.
    | AnotherTlsPasswordFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsPasswordFlags where
    fromEnum TlsPasswordFlagsNone = 0
    fromEnum TlsPasswordFlagsRetry = 2
    fromEnum TlsPasswordFlagsManyTries = 4
    fromEnum TlsPasswordFlagsFinalTry = 8
    fromEnum TlsPasswordFlagsPkcs11User = 16
    fromEnum TlsPasswordFlagsPkcs11SecurityOfficer = 32
    fromEnum TlsPasswordFlagsPkcs11ContextSpecific = 64
    fromEnum (AnotherTlsPasswordFlags k) = k

    toEnum 0 = TlsPasswordFlagsNone
    toEnum 2 = TlsPasswordFlagsRetry
    toEnum 4 = TlsPasswordFlagsManyTries
    toEnum 8 = TlsPasswordFlagsFinalTry
    toEnum 16 = TlsPasswordFlagsPkcs11User
    toEnum 32 = TlsPasswordFlagsPkcs11SecurityOfficer
    toEnum 64 = TlsPasswordFlagsPkcs11ContextSpecific
    toEnum k = AnotherTlsPasswordFlags k

instance P.Ord TlsPasswordFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TlsPasswordFlags = '[]
instance O.HasParentTypes TlsPasswordFlags

foreign import ccall "g_tls_password_flags_get_type" c_g_tls_password_flags_get_type :: 
    IO GType

instance B.Types.TypedObject TlsPasswordFlags where
    glibType = c_g_tls_password_flags_get_type

instance B.Types.BoxedFlags TlsPasswordFlags

instance IsGFlag TlsPasswordFlags

-- Flags TlsDatabaseVerifyFlags
-- | Flags for 'GI.Gio.Objects.TlsDatabase.tlsDatabaseVerifyChain'.
-- 
-- /Since: 2.30/
data TlsDatabaseVerifyFlags = 
      TlsDatabaseVerifyFlagsNone
    -- ^ No verification flags
    | AnotherTlsDatabaseVerifyFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsDatabaseVerifyFlags where
    fromEnum TlsDatabaseVerifyFlagsNone = 0
    fromEnum (AnotherTlsDatabaseVerifyFlags k) = k

    toEnum 0 = TlsDatabaseVerifyFlagsNone
    toEnum k = AnotherTlsDatabaseVerifyFlags k

instance P.Ord TlsDatabaseVerifyFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TlsDatabaseVerifyFlags = '[]
instance O.HasParentTypes TlsDatabaseVerifyFlags

foreign import ccall "g_tls_database_verify_flags_get_type" c_g_tls_database_verify_flags_get_type :: 
    IO GType

instance B.Types.TypedObject TlsDatabaseVerifyFlags where
    glibType = c_g_tls_database_verify_flags_get_type

instance B.Types.BoxedFlags TlsDatabaseVerifyFlags

instance IsGFlag TlsDatabaseVerifyFlags

-- Flags TlsCertificateFlags
-- | A set of flags describing TLS certification validation. This can be
-- used to describe why a particular certificate was rejected (for
-- example, in [TlsConnection::acceptCertificate]("GI.Gio.Objects.TlsConnection#g:signal:acceptCertificate")).
-- 
-- GLib guarantees that if certificate verification fails, at least one
-- flag will be set, but it does not guarantee that all possible flags
-- will be set. Accordingly, you may not safely decide to ignore any
-- particular type of error. For example, it would be incorrect to mask
-- 'GI.Gio.Flags.TlsCertificateFlagsExpired' if you want to allow expired certificates,
-- because this could potentially be the only error flag set even if
-- other problems exist with the certificate.
-- 
-- /Since: 2.28/
data TlsCertificateFlags = 
      TlsCertificateFlagsNoFlags
    -- ^ No flags set. Since: 2.74
    | TlsCertificateFlagsUnknownCa
    -- ^ The signing certificate authority is
    --   not known.
    | TlsCertificateFlagsBadIdentity
    -- ^ The certificate does not match the
    --   expected identity of the site that it was retrieved from.
    | TlsCertificateFlagsNotActivated
    -- ^ The certificate\'s activation time
    --   is still in the future
    | TlsCertificateFlagsExpired
    -- ^ The certificate has expired
    | TlsCertificateFlagsRevoked
    -- ^ The certificate has been revoked
    --   according to the t'GI.Gio.Objects.TlsConnection.TlsConnection'\'s certificate revocation list.
    | TlsCertificateFlagsInsecure
    -- ^ The certificate\'s algorithm is
    --   considered insecure.
    | TlsCertificateFlagsGenericError
    -- ^ Some other error occurred validating
    --   the certificate
    | TlsCertificateFlagsValidateAll
    -- ^ the combination of all of the above
    --   flags
    | AnotherTlsCertificateFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TlsCertificateFlags where
    fromEnum TlsCertificateFlagsNoFlags = 0
    fromEnum TlsCertificateFlagsUnknownCa = 1
    fromEnum TlsCertificateFlagsBadIdentity = 2
    fromEnum TlsCertificateFlagsNotActivated = 4
    fromEnum TlsCertificateFlagsExpired = 8
    fromEnum TlsCertificateFlagsRevoked = 16
    fromEnum TlsCertificateFlagsInsecure = 32
    fromEnum TlsCertificateFlagsGenericError = 64
    fromEnum TlsCertificateFlagsValidateAll = 127
    fromEnum (AnotherTlsCertificateFlags k) = k

    toEnum 0 = TlsCertificateFlagsNoFlags
    toEnum 1 = TlsCertificateFlagsUnknownCa
    toEnum 2 = TlsCertificateFlagsBadIdentity
    toEnum 4 = TlsCertificateFlagsNotActivated
    toEnum 8 = TlsCertificateFlagsExpired
    toEnum 16 = TlsCertificateFlagsRevoked
    toEnum 32 = TlsCertificateFlagsInsecure
    toEnum 64 = TlsCertificateFlagsGenericError
    toEnum 127 = TlsCertificateFlagsValidateAll
    toEnum k = AnotherTlsCertificateFlags k

instance P.Ord TlsCertificateFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TlsCertificateFlags = '[]
instance O.HasParentTypes TlsCertificateFlags

foreign import ccall "g_tls_certificate_flags_get_type" c_g_tls_certificate_flags_get_type :: 
    IO GType

instance B.Types.TypedObject TlsCertificateFlags where
    glibType = c_g_tls_certificate_flags_get_type

instance B.Types.BoxedFlags TlsCertificateFlags

instance IsGFlag TlsCertificateFlags

-- Flags TestDBusFlags
-- | Flags to define future t'GI.Gio.Objects.TestDBus.TestDBus' behaviour.
-- 
-- /Since: 2.34/
data TestDBusFlags = 
      TestDBusFlagsNone
    -- ^ No flags.
    | AnotherTestDBusFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum TestDBusFlags where
    fromEnum TestDBusFlagsNone = 0
    fromEnum (AnotherTestDBusFlags k) = k

    toEnum 0 = TestDBusFlagsNone
    toEnum k = AnotherTestDBusFlags k

instance P.Ord TestDBusFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes TestDBusFlags = '[]
instance O.HasParentTypes TestDBusFlags

foreign import ccall "g_test_dbus_flags_get_type" c_g_test_dbus_flags_get_type :: 
    IO GType

instance B.Types.TypedObject TestDBusFlags where
    glibType = c_g_test_dbus_flags_get_type

instance B.Types.BoxedFlags TestDBusFlags

instance IsGFlag TestDBusFlags

-- Flags SubprocessFlags
-- | Flags to define the behaviour of a t'GI.Gio.Objects.Subprocess.Subprocess'.
-- 
-- Note that the default for stdin is to redirect from @\/dev\/null@.  For
-- stdout and stderr the default are for them to inherit the
-- corresponding descriptor from the calling process.
-- 
-- Note that it is a programmer error to mix \'incompatible\' flags.  For
-- example, you may not request both 'GI.Gio.Flags.SubprocessFlagsStdoutPipe' and
-- 'GI.Gio.Flags.SubprocessFlagsStdoutSilence'.
-- 
-- /Since: 2.40/
data SubprocessFlags = 
      SubprocessFlagsNone
    -- ^ No flags.
    | SubprocessFlagsStdinPipe
    -- ^ create a pipe for the stdin of the
    --   spawned process that can be accessed with
    --   'GI.Gio.Objects.Subprocess.subprocessGetStdinPipe'.
    | SubprocessFlagsStdinInherit
    -- ^ stdin is inherited from the
    --   calling process.
    | SubprocessFlagsStdoutPipe
    -- ^ create a pipe for the stdout of the
    --   spawned process that can be accessed with
    --   'GI.Gio.Objects.Subprocess.subprocessGetStdoutPipe'.
    | SubprocessFlagsStdoutSilence
    -- ^ silence the stdout of the spawned
    --   process (ie: redirect to @\/dev\/null@).
    | SubprocessFlagsStderrPipe
    -- ^ create a pipe for the stderr of the
    --   spawned process that can be accessed with
    --   'GI.Gio.Objects.Subprocess.subprocessGetStderrPipe'.
    | SubprocessFlagsStderrSilence
    -- ^ silence the stderr of the spawned
    --   process (ie: redirect to @\/dev\/null@).
    | SubprocessFlagsStderrMerge
    -- ^ merge the stderr of the spawned
    --   process with whatever the stdout happens to be.  This is a good way
    --   of directing both streams to a common log file, for example.
    | SubprocessFlagsInheritFds
    -- ^ spawned processes will inherit the
    --   file descriptors of their parent, unless those descriptors have
    --   been explicitly marked as close-on-exec.  This flag has no effect
    --   over the \"standard\" file descriptors (stdin, stdout, stderr).
    | SubprocessFlagsSearchPathFromEnvp
    -- ^ if path searching is
    --   needed when spawning the subprocess, use the @PATH@ in the launcher
    --   environment. (Since: 2.72)
    | AnotherSubprocessFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SubprocessFlags where
    fromEnum SubprocessFlagsNone = 0
    fromEnum SubprocessFlagsStdinPipe = 1
    fromEnum SubprocessFlagsStdinInherit = 2
    fromEnum SubprocessFlagsStdoutPipe = 4
    fromEnum SubprocessFlagsStdoutSilence = 8
    fromEnum SubprocessFlagsStderrPipe = 16
    fromEnum SubprocessFlagsStderrSilence = 32
    fromEnum SubprocessFlagsStderrMerge = 64
    fromEnum SubprocessFlagsInheritFds = 128
    fromEnum SubprocessFlagsSearchPathFromEnvp = 256
    fromEnum (AnotherSubprocessFlags k) = k

    toEnum 0 = SubprocessFlagsNone
    toEnum 1 = SubprocessFlagsStdinPipe
    toEnum 2 = SubprocessFlagsStdinInherit
    toEnum 4 = SubprocessFlagsStdoutPipe
    toEnum 8 = SubprocessFlagsStdoutSilence
    toEnum 16 = SubprocessFlagsStderrPipe
    toEnum 32 = SubprocessFlagsStderrSilence
    toEnum 64 = SubprocessFlagsStderrMerge
    toEnum 128 = SubprocessFlagsInheritFds
    toEnum 256 = SubprocessFlagsSearchPathFromEnvp
    toEnum k = AnotherSubprocessFlags k

instance P.Ord SubprocessFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SubprocessFlags = '[]
instance O.HasParentTypes SubprocessFlags

foreign import ccall "g_subprocess_flags_get_type" c_g_subprocess_flags_get_type :: 
    IO GType

instance B.Types.TypedObject SubprocessFlags where
    glibType = c_g_subprocess_flags_get_type

instance B.Types.BoxedFlags SubprocessFlags

instance IsGFlag SubprocessFlags

-- Flags SocketMsgFlags
-- | Flags used in 'GI.Gio.Objects.Socket.socketReceiveMessage' and 'GI.Gio.Objects.Socket.socketSendMessage'.
-- The flags listed in the enum are some commonly available flags, but the
-- values used for them are the same as on the platform, and any other flags
-- are passed in\/out as is. So to use a platform specific flag, just include
-- the right system header and pass in the flag.
-- 
-- /Since: 2.22/
data SocketMsgFlags = 
      SocketMsgFlagsNone
    -- ^ No flags.
    | SocketMsgFlagsOob
    -- ^ Request to send\/receive out of band data.
    | SocketMsgFlagsPeek
    -- ^ Read data from the socket without removing it from
    --     the queue.
    | SocketMsgFlagsDontroute
    -- ^ Don\'t use a gateway to send out the packet,
    --     only send to hosts on directly connected networks.
    | AnotherSocketMsgFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SocketMsgFlags where
    fromEnum SocketMsgFlagsNone = 0
    fromEnum SocketMsgFlagsOob = 1
    fromEnum SocketMsgFlagsPeek = 2
    fromEnum SocketMsgFlagsDontroute = 4
    fromEnum (AnotherSocketMsgFlags k) = k

    toEnum 0 = SocketMsgFlagsNone
    toEnum 1 = SocketMsgFlagsOob
    toEnum 2 = SocketMsgFlagsPeek
    toEnum 4 = SocketMsgFlagsDontroute
    toEnum k = AnotherSocketMsgFlags k

instance P.Ord SocketMsgFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SocketMsgFlags = '[]
instance O.HasParentTypes SocketMsgFlags

foreign import ccall "g_socket_msg_flags_get_type" c_g_socket_msg_flags_get_type :: 
    IO GType

instance B.Types.TypedObject SocketMsgFlags where
    glibType = c_g_socket_msg_flags_get_type

instance B.Types.BoxedFlags SocketMsgFlags

instance IsGFlag SocketMsgFlags

-- Flags SettingsBindFlags
-- | Flags used when creating a binding.
-- 
-- These flags determine in which direction the binding works. The default is to
-- synchronize in both directions.
data SettingsBindFlags = 
      SettingsBindFlagsDefault
    -- ^ Equivalent to @G_SETTINGS_BIND_GET|G_SETTINGS_BIND_SET@
    | SettingsBindFlagsGet
    -- ^ Update the t'GI.GObject.Objects.Object.Object' property when the setting changes.
    --   It is an error to use this flag if the property is not writable.
    | SettingsBindFlagsSet
    -- ^ Update the setting when the t'GI.GObject.Objects.Object.Object' property changes.
    --   It is an error to use this flag if the property is not readable.
    | SettingsBindFlagsNoSensitivity
    -- ^ Do not try to bind a ‘sensitivity’ property to the writability of the setting
    | SettingsBindFlagsGetNoChanges
    -- ^ When set in addition to [flags/@gio@/.SettingsBindFlags.GET],
    --   set the t'GI.GObject.Objects.Object.Object' property
    --   value initially from the setting, but do not listen for changes of the setting
    | SettingsBindFlagsInvertBoolean
    -- ^ When passed to 'GI.Gio.Objects.Settings.settingsBind',
    --   uses a pair of mapping functions that invert
    --   the boolean value when mapping between the setting and the property.  The setting and property must both
    --   be booleans.  You cannot pass this flag to 'GI.Gio.Objects.Settings.settingsBindWithMapping'.
    | AnotherSettingsBindFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SettingsBindFlags where
    fromEnum SettingsBindFlagsDefault = 0
    fromEnum SettingsBindFlagsGet = 1
    fromEnum SettingsBindFlagsSet = 2
    fromEnum SettingsBindFlagsNoSensitivity = 4
    fromEnum SettingsBindFlagsGetNoChanges = 8
    fromEnum SettingsBindFlagsInvertBoolean = 16
    fromEnum (AnotherSettingsBindFlags k) = k

    toEnum 0 = SettingsBindFlagsDefault
    toEnum 1 = SettingsBindFlagsGet
    toEnum 2 = SettingsBindFlagsSet
    toEnum 4 = SettingsBindFlagsNoSensitivity
    toEnum 8 = SettingsBindFlagsGetNoChanges
    toEnum 16 = SettingsBindFlagsInvertBoolean
    toEnum k = AnotherSettingsBindFlags k

instance P.Ord SettingsBindFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SettingsBindFlags = '[]
instance O.HasParentTypes SettingsBindFlags

foreign import ccall "g_settings_bind_flags_get_type" c_g_settings_bind_flags_get_type :: 
    IO GType

instance B.Types.TypedObject SettingsBindFlags where
    glibType = c_g_settings_bind_flags_get_type

instance B.Types.BoxedFlags SettingsBindFlags

instance IsGFlag SettingsBindFlags

-- Flags ResourceLookupFlags
-- | GResourceLookupFlags determine how resource path lookups are handled.
-- 
-- /Since: 2.32/
data ResourceLookupFlags = 
      ResourceLookupFlagsNone
    -- ^ No flags set.
    | AnotherResourceLookupFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ResourceLookupFlags where
    fromEnum ResourceLookupFlagsNone = 0
    fromEnum (AnotherResourceLookupFlags k) = k

    toEnum 0 = ResourceLookupFlagsNone
    toEnum k = AnotherResourceLookupFlags k

instance P.Ord ResourceLookupFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ResourceLookupFlags = '[]
instance O.HasParentTypes ResourceLookupFlags

foreign import ccall "g_resource_lookup_flags_get_type" c_g_resource_lookup_flags_get_type :: 
    IO GType

instance B.Types.TypedObject ResourceLookupFlags where
    glibType = c_g_resource_lookup_flags_get_type

instance B.Types.BoxedFlags ResourceLookupFlags

instance IsGFlag ResourceLookupFlags

-- Flags ResourceFlags
-- | GResourceFlags give information about a particular file inside a resource
-- bundle.
-- 
-- /Since: 2.32/
data ResourceFlags = 
      ResourceFlagsNone
    -- ^ No flags set.
    | ResourceFlagsCompressed
    -- ^ The file is compressed.
    | AnotherResourceFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ResourceFlags where
    fromEnum ResourceFlagsNone = 0
    fromEnum ResourceFlagsCompressed = 1
    fromEnum (AnotherResourceFlags k) = k

    toEnum 0 = ResourceFlagsNone
    toEnum 1 = ResourceFlagsCompressed
    toEnum k = AnotherResourceFlags k

instance P.Ord ResourceFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ResourceFlags = '[]
instance O.HasParentTypes ResourceFlags

foreign import ccall "g_resource_flags_get_type" c_g_resource_flags_get_type :: 
    IO GType

instance B.Types.TypedObject ResourceFlags where
    glibType = c_g_resource_flags_get_type

instance B.Types.BoxedFlags ResourceFlags

instance IsGFlag ResourceFlags

-- Flags ResolverNameLookupFlags
-- | Flags to modify lookup behavior.
-- 
-- /Since: 2.60/
data ResolverNameLookupFlags = 
      ResolverNameLookupFlagsDefault
    -- ^ default behavior (same as 'GI.Gio.Objects.Resolver.resolverLookupByName')
    | ResolverNameLookupFlagsIpv4Only
    -- ^ only resolve ipv4 addresses
    | ResolverNameLookupFlagsIpv6Only
    -- ^ only resolve ipv6 addresses
    | AnotherResolverNameLookupFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ResolverNameLookupFlags where
    fromEnum ResolverNameLookupFlagsDefault = 0
    fromEnum ResolverNameLookupFlagsIpv4Only = 1
    fromEnum ResolverNameLookupFlagsIpv6Only = 2
    fromEnum (AnotherResolverNameLookupFlags k) = k

    toEnum 0 = ResolverNameLookupFlagsDefault
    toEnum 1 = ResolverNameLookupFlagsIpv4Only
    toEnum 2 = ResolverNameLookupFlagsIpv6Only
    toEnum k = AnotherResolverNameLookupFlags k

instance P.Ord ResolverNameLookupFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ResolverNameLookupFlags = '[]
instance O.HasParentTypes ResolverNameLookupFlags

foreign import ccall "g_resolver_name_lookup_flags_get_type" c_g_resolver_name_lookup_flags_get_type :: 
    IO GType

instance B.Types.TypedObject ResolverNameLookupFlags where
    glibType = c_g_resolver_name_lookup_flags_get_type

instance B.Types.BoxedFlags ResolverNameLookupFlags

instance IsGFlag ResolverNameLookupFlags

-- Flags OutputStreamSpliceFlags
-- | GOutputStreamSpliceFlags determine how streams should be spliced.
data OutputStreamSpliceFlags = 
      OutputStreamSpliceFlagsNone
    -- ^ Do not close either stream.
    | OutputStreamSpliceFlagsCloseSource
    -- ^ Close the source stream after
    --     the splice.
    | OutputStreamSpliceFlagsCloseTarget
    -- ^ Close the target stream after
    --     the splice.
    | AnotherOutputStreamSpliceFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum OutputStreamSpliceFlags where
    fromEnum OutputStreamSpliceFlagsNone = 0
    fromEnum OutputStreamSpliceFlagsCloseSource = 1
    fromEnum OutputStreamSpliceFlagsCloseTarget = 2
    fromEnum (AnotherOutputStreamSpliceFlags k) = k

    toEnum 0 = OutputStreamSpliceFlagsNone
    toEnum 1 = OutputStreamSpliceFlagsCloseSource
    toEnum 2 = OutputStreamSpliceFlagsCloseTarget
    toEnum k = AnotherOutputStreamSpliceFlags k

instance P.Ord OutputStreamSpliceFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes OutputStreamSpliceFlags = '[]
instance O.HasParentTypes OutputStreamSpliceFlags

foreign import ccall "g_output_stream_splice_flags_get_type" c_g_output_stream_splice_flags_get_type :: 
    IO GType

instance B.Types.TypedObject OutputStreamSpliceFlags where
    glibType = c_g_output_stream_splice_flags_get_type

instance B.Types.BoxedFlags OutputStreamSpliceFlags

instance IsGFlag OutputStreamSpliceFlags

-- Flags MountUnmountFlags
-- | Flags used when an unmounting a mount.
data MountUnmountFlags = 
      MountUnmountFlagsNone
    -- ^ No flags set.
    | MountUnmountFlagsForce
    -- ^ Unmount even if there are outstanding
    --  file operations on the mount.
    | AnotherMountUnmountFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MountUnmountFlags where
    fromEnum MountUnmountFlagsNone = 0
    fromEnum MountUnmountFlagsForce = 1
    fromEnum (AnotherMountUnmountFlags k) = k

    toEnum 0 = MountUnmountFlagsNone
    toEnum 1 = MountUnmountFlagsForce
    toEnum k = AnotherMountUnmountFlags k

instance P.Ord MountUnmountFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes MountUnmountFlags = '[]
instance O.HasParentTypes MountUnmountFlags

foreign import ccall "g_mount_unmount_flags_get_type" c_g_mount_unmount_flags_get_type :: 
    IO GType

instance B.Types.TypedObject MountUnmountFlags where
    glibType = c_g_mount_unmount_flags_get_type

instance B.Types.BoxedFlags MountUnmountFlags

instance IsGFlag MountUnmountFlags

-- Flags MountMountFlags
-- | Flags used when mounting a mount.
data MountMountFlags = 
      MountMountFlagsNone
    -- ^ No flags set.
    | AnotherMountMountFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum MountMountFlags where
    fromEnum MountMountFlagsNone = 0
    fromEnum (AnotherMountMountFlags k) = k

    toEnum 0 = MountMountFlagsNone
    toEnum k = AnotherMountMountFlags k

instance P.Ord MountMountFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes MountMountFlags = '[]
instance O.HasParentTypes MountMountFlags

foreign import ccall "g_mount_mount_flags_get_type" c_g_mount_mount_flags_get_type :: 
    IO GType

instance B.Types.TypedObject MountMountFlags where
    glibType = c_g_mount_mount_flags_get_type

instance B.Types.BoxedFlags MountMountFlags

instance IsGFlag MountMountFlags

-- Flags IOStreamSpliceFlags
-- | GIOStreamSpliceFlags determine how streams should be spliced.
-- 
-- /Since: 2.28/
data IOStreamSpliceFlags = 
      IOStreamSpliceFlagsNone
    -- ^ Do not close either stream.
    | IOStreamSpliceFlagsCloseStream1
    -- ^ Close the first stream after
    --     the splice.
    | IOStreamSpliceFlagsCloseStream2
    -- ^ Close the second stream after
    --     the splice.
    | IOStreamSpliceFlagsWaitForBoth
    -- ^ Wait for both splice operations to finish
    --     before calling the callback.
    | AnotherIOStreamSpliceFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum IOStreamSpliceFlags where
    fromEnum IOStreamSpliceFlagsNone = 0
    fromEnum IOStreamSpliceFlagsCloseStream1 = 1
    fromEnum IOStreamSpliceFlagsCloseStream2 = 2
    fromEnum IOStreamSpliceFlagsWaitForBoth = 4
    fromEnum (AnotherIOStreamSpliceFlags k) = k

    toEnum 0 = IOStreamSpliceFlagsNone
    toEnum 1 = IOStreamSpliceFlagsCloseStream1
    toEnum 2 = IOStreamSpliceFlagsCloseStream2
    toEnum 4 = IOStreamSpliceFlagsWaitForBoth
    toEnum k = AnotherIOStreamSpliceFlags k

instance P.Ord IOStreamSpliceFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes IOStreamSpliceFlags = '[]
instance O.HasParentTypes IOStreamSpliceFlags

foreign import ccall "g_io_stream_splice_flags_get_type" c_g_io_stream_splice_flags_get_type :: 
    IO GType

instance B.Types.TypedObject IOStreamSpliceFlags where
    glibType = c_g_io_stream_splice_flags_get_type

instance B.Types.BoxedFlags IOStreamSpliceFlags

instance IsGFlag IOStreamSpliceFlags

-- Flags FileQueryInfoFlags
-- | Flags used when querying a t'GI.Gio.Objects.FileInfo.FileInfo'.
data FileQueryInfoFlags = 
      FileQueryInfoFlagsNone
    -- ^ No flags set.
    | FileQueryInfoFlagsNofollowSymlinks
    -- ^ Don\'t follow symlinks.
    | AnotherFileQueryInfoFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileQueryInfoFlags where
    fromEnum FileQueryInfoFlagsNone = 0
    fromEnum FileQueryInfoFlagsNofollowSymlinks = 1
    fromEnum (AnotherFileQueryInfoFlags k) = k

    toEnum 0 = FileQueryInfoFlagsNone
    toEnum 1 = FileQueryInfoFlagsNofollowSymlinks
    toEnum k = AnotherFileQueryInfoFlags k

instance P.Ord FileQueryInfoFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileQueryInfoFlags = '[]
instance O.HasParentTypes FileQueryInfoFlags

foreign import ccall "g_file_query_info_flags_get_type" c_g_file_query_info_flags_get_type :: 
    IO GType

instance B.Types.TypedObject FileQueryInfoFlags where
    glibType = c_g_file_query_info_flags_get_type

instance B.Types.BoxedFlags FileQueryInfoFlags

instance IsGFlag FileQueryInfoFlags

-- Flags FileMonitorFlags
-- | Flags used to set what a t'GI.Gio.Objects.FileMonitor.FileMonitor' will watch for.
data FileMonitorFlags = 
      FileMonitorFlagsNone
    -- ^ No flags set.
    | FileMonitorFlagsWatchMounts
    -- ^ Watch for mount events.
    | FileMonitorFlagsSendMoved
    -- ^ Pair DELETED and CREATED events caused
    --   by file renames (moves) and send a single G_FILE_MONITOR_EVENT_MOVED
    --   event instead (NB: not supported on all backends; the default
    --   behaviour -without specifying this flag- is to send single DELETED
    --   and CREATED events).  Deprecated since 2.46: use
    --   'GI.Gio.Flags.FileMonitorFlagsWatchMoves' instead.
    | FileMonitorFlagsWatchHardLinks
    -- ^ Watch for changes to the file made
    --   via another hard link. Since 2.36.
    | FileMonitorFlagsWatchMoves
    -- ^ Watch for rename operations on a
    --   monitored directory.  This causes 'GI.Gio.Enums.FileMonitorEventRenamed',
    --   'GI.Gio.Enums.FileMonitorEventMovedIn' and 'GI.Gio.Enums.FileMonitorEventMovedOut'
    --   events to be emitted when possible.  Since: 2.46.
    | AnotherFileMonitorFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileMonitorFlags where
    fromEnum FileMonitorFlagsNone = 0
    fromEnum FileMonitorFlagsWatchMounts = 1
    fromEnum FileMonitorFlagsSendMoved = 2
    fromEnum FileMonitorFlagsWatchHardLinks = 4
    fromEnum FileMonitorFlagsWatchMoves = 8
    fromEnum (AnotherFileMonitorFlags k) = k

    toEnum 0 = FileMonitorFlagsNone
    toEnum 1 = FileMonitorFlagsWatchMounts
    toEnum 2 = FileMonitorFlagsSendMoved
    toEnum 4 = FileMonitorFlagsWatchHardLinks
    toEnum 8 = FileMonitorFlagsWatchMoves
    toEnum k = AnotherFileMonitorFlags k

instance P.Ord FileMonitorFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileMonitorFlags = '[]
instance O.HasParentTypes FileMonitorFlags

foreign import ccall "g_file_monitor_flags_get_type" c_g_file_monitor_flags_get_type :: 
    IO GType

instance B.Types.TypedObject FileMonitorFlags where
    glibType = c_g_file_monitor_flags_get_type

instance B.Types.BoxedFlags FileMonitorFlags

instance IsGFlag FileMonitorFlags

-- Flags FileMeasureFlags
-- | Flags that can be used with 'GI.Gio.Interfaces.File.fileMeasureDiskUsage'.
-- 
-- /Since: 2.38/
data FileMeasureFlags = 
      FileMeasureFlagsNone
    -- ^ No flags set.
    | FileMeasureFlagsReportAnyError
    -- ^ Report any error encountered
    --   while traversing the directory tree.  Normally errors are only
    --   reported for the toplevel file.
    | FileMeasureFlagsApparentSize
    -- ^ Tally usage based on apparent file
    --   sizes.  Normally, the block-size is used, if available, as this is a
    --   more accurate representation of disk space used.
    --   Compare with @du --apparent-size@.
    --   Since GLib 2.78. and similarly to @du@ since GNU Coreutils 9.2, this will
    --   ignore the sizes of file types other than regular files and links, as the
    --   sizes of other file types are not specified in a standard way.
    | FileMeasureFlagsNoXdev
    -- ^ Do not cross mount point boundaries.
    --   Compare with @du -x@.
    | AnotherFileMeasureFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileMeasureFlags where
    fromEnum FileMeasureFlagsNone = 0
    fromEnum FileMeasureFlagsReportAnyError = 2
    fromEnum FileMeasureFlagsApparentSize = 4
    fromEnum FileMeasureFlagsNoXdev = 8
    fromEnum (AnotherFileMeasureFlags k) = k

    toEnum 0 = FileMeasureFlagsNone
    toEnum 2 = FileMeasureFlagsReportAnyError
    toEnum 4 = FileMeasureFlagsApparentSize
    toEnum 8 = FileMeasureFlagsNoXdev
    toEnum k = AnotherFileMeasureFlags k

instance P.Ord FileMeasureFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileMeasureFlags = '[]
instance O.HasParentTypes FileMeasureFlags

foreign import ccall "g_file_measure_flags_get_type" c_g_file_measure_flags_get_type :: 
    IO GType

instance B.Types.TypedObject FileMeasureFlags where
    glibType = c_g_file_measure_flags_get_type

instance B.Types.BoxedFlags FileMeasureFlags

instance IsGFlag FileMeasureFlags

-- Flags FileCreateFlags
-- | Flags used when an operation may create a file.
data FileCreateFlags = 
      FileCreateFlagsNone
    -- ^ No flags set.
    | FileCreateFlagsPrivate
    -- ^ Create a file that can only be
    --    accessed by the current user.
    | FileCreateFlagsReplaceDestination
    -- ^ Replace the destination
    --    as if it didn\'t exist before. Don\'t try to keep any old
    --    permissions, replace instead of following links. This
    --    is generally useful if you\'re doing a \"copy over\"
    --    rather than a \"save new version of\" replace operation.
    --    You can think of it as \"unlink destination\" before
    --    writing to it, although the implementation may not
    --    be exactly like that. This flag can only be used with
    --    'GI.Gio.Interfaces.File.fileReplace' and its variants, including 'GI.Gio.Interfaces.File.fileReplaceContents'.
    --    Since 2.20
    | AnotherFileCreateFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileCreateFlags where
    fromEnum FileCreateFlagsNone = 0
    fromEnum FileCreateFlagsPrivate = 1
    fromEnum FileCreateFlagsReplaceDestination = 2
    fromEnum (AnotherFileCreateFlags k) = k

    toEnum 0 = FileCreateFlagsNone
    toEnum 1 = FileCreateFlagsPrivate
    toEnum 2 = FileCreateFlagsReplaceDestination
    toEnum k = AnotherFileCreateFlags k

instance P.Ord FileCreateFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileCreateFlags = '[]
instance O.HasParentTypes FileCreateFlags

foreign import ccall "g_file_create_flags_get_type" c_g_file_create_flags_get_type :: 
    IO GType

instance B.Types.TypedObject FileCreateFlags where
    glibType = c_g_file_create_flags_get_type

instance B.Types.BoxedFlags FileCreateFlags

instance IsGFlag FileCreateFlags

-- Flags FileCopyFlags
-- | Flags used when copying or moving files.
data FileCopyFlags = 
      FileCopyFlagsNone
    -- ^ No flags set.
    | FileCopyFlagsOverwrite
    -- ^ Overwrite any existing files
    | FileCopyFlagsBackup
    -- ^ Make a backup of any existing files.
    | FileCopyFlagsNofollowSymlinks
    -- ^ Don\'t follow symlinks.
    | FileCopyFlagsAllMetadata
    -- ^ Copy all file metadata instead of just default set used for copy (see t'GI.Gio.Objects.FileInfo.FileInfo').
    | FileCopyFlagsNoFallbackForMove
    -- ^ Don\'t use copy and delete fallback if native move not supported.
    | FileCopyFlagsTargetDefaultPerms
    -- ^ Leaves target file with default perms, instead of setting the source file perms.
    | FileCopyFlagsTargetDefaultModifiedTime
    -- ^ Use default modification
    --     timestamps instead of copying them from the source file. Since 2.80
    | AnotherFileCopyFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileCopyFlags where
    fromEnum FileCopyFlagsNone = 0
    fromEnum FileCopyFlagsOverwrite = 1
    fromEnum FileCopyFlagsBackup = 2
    fromEnum FileCopyFlagsNofollowSymlinks = 4
    fromEnum FileCopyFlagsAllMetadata = 8
    fromEnum FileCopyFlagsNoFallbackForMove = 16
    fromEnum FileCopyFlagsTargetDefaultPerms = 32
    fromEnum FileCopyFlagsTargetDefaultModifiedTime = 64
    fromEnum (AnotherFileCopyFlags k) = k

    toEnum 0 = FileCopyFlagsNone
    toEnum 1 = FileCopyFlagsOverwrite
    toEnum 2 = FileCopyFlagsBackup
    toEnum 4 = FileCopyFlagsNofollowSymlinks
    toEnum 8 = FileCopyFlagsAllMetadata
    toEnum 16 = FileCopyFlagsNoFallbackForMove
    toEnum 32 = FileCopyFlagsTargetDefaultPerms
    toEnum 64 = FileCopyFlagsTargetDefaultModifiedTime
    toEnum k = AnotherFileCopyFlags k

instance P.Ord FileCopyFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileCopyFlags = '[]
instance O.HasParentTypes FileCopyFlags

foreign import ccall "g_file_copy_flags_get_type" c_g_file_copy_flags_get_type :: 
    IO GType

instance B.Types.TypedObject FileCopyFlags where
    glibType = c_g_file_copy_flags_get_type

instance B.Types.BoxedFlags FileCopyFlags

instance IsGFlag FileCopyFlags

-- Flags FileAttributeInfoFlags
-- | Flags specifying the behaviour of an attribute.
data FileAttributeInfoFlags = 
      FileAttributeInfoFlagsNone
    -- ^ no flags set.
    | FileAttributeInfoFlagsCopyWithFile
    -- ^ copy the attribute values when the file is copied.
    | FileAttributeInfoFlagsCopyWhenMoved
    -- ^ copy the attribute values when the file is moved.
    | AnotherFileAttributeInfoFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FileAttributeInfoFlags where
    fromEnum FileAttributeInfoFlagsNone = 0
    fromEnum FileAttributeInfoFlagsCopyWithFile = 1
    fromEnum FileAttributeInfoFlagsCopyWhenMoved = 2
    fromEnum (AnotherFileAttributeInfoFlags k) = k

    toEnum 0 = FileAttributeInfoFlagsNone
    toEnum 1 = FileAttributeInfoFlagsCopyWithFile
    toEnum 2 = FileAttributeInfoFlagsCopyWhenMoved
    toEnum k = AnotherFileAttributeInfoFlags k

instance P.Ord FileAttributeInfoFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FileAttributeInfoFlags = '[]
instance O.HasParentTypes FileAttributeInfoFlags

foreign import ccall "g_file_attribute_info_flags_get_type" c_g_file_attribute_info_flags_get_type :: 
    IO GType

instance B.Types.TypedObject FileAttributeInfoFlags where
    glibType = c_g_file_attribute_info_flags_get_type

instance B.Types.BoxedFlags FileAttributeInfoFlags

instance IsGFlag FileAttributeInfoFlags

-- Flags DriveStartFlags
-- | Flags used when starting a drive.
-- 
-- /Since: 2.22/
data DriveStartFlags = 
      DriveStartFlagsNone
    -- ^ No flags set.
    | AnotherDriveStartFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DriveStartFlags where
    fromEnum DriveStartFlagsNone = 0
    fromEnum (AnotherDriveStartFlags k) = k

    toEnum 0 = DriveStartFlagsNone
    toEnum k = AnotherDriveStartFlags k

instance P.Ord DriveStartFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DriveStartFlags = '[]
instance O.HasParentTypes DriveStartFlags

foreign import ccall "g_drive_start_flags_get_type" c_g_drive_start_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DriveStartFlags where
    glibType = c_g_drive_start_flags_get_type

instance B.Types.BoxedFlags DriveStartFlags

instance IsGFlag DriveStartFlags

-- Flags DBusSubtreeFlags
-- | Flags passed to 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
-- 
-- /Since: 2.26/
data DBusSubtreeFlags = 
      DBusSubtreeFlagsNone
    -- ^ No flags set.
    | DBusSubtreeFlagsDispatchToUnenumeratedNodes
    -- ^ Method calls to objects not in the enumerated range
    --                                                       will still be dispatched. This is useful if you want
    --                                                       to dynamically spawn objects in the subtree.
    | AnotherDBusSubtreeFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusSubtreeFlags where
    fromEnum DBusSubtreeFlagsNone = 0
    fromEnum DBusSubtreeFlagsDispatchToUnenumeratedNodes = 1
    fromEnum (AnotherDBusSubtreeFlags k) = k

    toEnum 0 = DBusSubtreeFlagsNone
    toEnum 1 = DBusSubtreeFlagsDispatchToUnenumeratedNodes
    toEnum k = AnotherDBusSubtreeFlags k

instance P.Ord DBusSubtreeFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusSubtreeFlags = '[]
instance O.HasParentTypes DBusSubtreeFlags

foreign import ccall "g_dbus_subtree_flags_get_type" c_g_dbus_subtree_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusSubtreeFlags where
    glibType = c_g_dbus_subtree_flags_get_type

instance B.Types.BoxedFlags DBusSubtreeFlags

instance IsGFlag DBusSubtreeFlags

-- Flags DBusSignalFlags
-- | Flags used when subscribing to signals via 'GI.Gio.Objects.DBusConnection.dBusConnectionSignalSubscribe'.
-- 
-- /Since: 2.26/
data DBusSignalFlags = 
      DBusSignalFlagsNone
    -- ^ No flags set.
    | DBusSignalFlagsNoMatchRule
    -- ^ Don\'t actually send the AddMatch
    -- D-Bus call for this signal subscription.  This gives you more control
    -- over which match rules you add (but you must add them manually).
    | DBusSignalFlagsMatchArg0Namespace
    -- ^ Match first arguments that
    -- contain a bus or interface name with the given namespace.
    | DBusSignalFlagsMatchArg0Path
    -- ^ Match first arguments that
    -- contain an object path that is either equivalent to the given path,
    -- or one of the paths is a subpath of the other.
    | AnotherDBusSignalFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusSignalFlags where
    fromEnum DBusSignalFlagsNone = 0
    fromEnum DBusSignalFlagsNoMatchRule = 1
    fromEnum DBusSignalFlagsMatchArg0Namespace = 2
    fromEnum DBusSignalFlagsMatchArg0Path = 4
    fromEnum (AnotherDBusSignalFlags k) = k

    toEnum 0 = DBusSignalFlagsNone
    toEnum 1 = DBusSignalFlagsNoMatchRule
    toEnum 2 = DBusSignalFlagsMatchArg0Namespace
    toEnum 4 = DBusSignalFlagsMatchArg0Path
    toEnum k = AnotherDBusSignalFlags k

instance P.Ord DBusSignalFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusSignalFlags = '[]
instance O.HasParentTypes DBusSignalFlags

foreign import ccall "g_dbus_signal_flags_get_type" c_g_dbus_signal_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusSignalFlags where
    glibType = c_g_dbus_signal_flags_get_type

instance B.Types.BoxedFlags DBusSignalFlags

instance IsGFlag DBusSignalFlags

-- Flags DBusServerFlags
-- | Flags used when creating a t'GI.Gio.Objects.DBusServer.DBusServer'.
-- 
-- /Since: 2.26/
data DBusServerFlags = 
      DBusServerFlagsNone
    -- ^ No flags set.
    | DBusServerFlagsRunInThread
    -- ^ All [DBusServer::newConnection]("GI.Gio.Objects.DBusServer#g:signal:newConnection")
    -- signals will run in separated dedicated threads (see signal for
    -- details).
    | DBusServerFlagsAuthenticationAllowAnonymous
    -- ^ Allow the anonymous
    -- authentication method.
    | DBusServerFlagsAuthenticationRequireSameUser
    -- ^ Require the UID of the
    -- peer to be the same as the UID of the server when authenticating. (Since: 2.68)
    | AnotherDBusServerFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusServerFlags where
    fromEnum DBusServerFlagsNone = 0
    fromEnum DBusServerFlagsRunInThread = 1
    fromEnum DBusServerFlagsAuthenticationAllowAnonymous = 2
    fromEnum DBusServerFlagsAuthenticationRequireSameUser = 4
    fromEnum (AnotherDBusServerFlags k) = k

    toEnum 0 = DBusServerFlagsNone
    toEnum 1 = DBusServerFlagsRunInThread
    toEnum 2 = DBusServerFlagsAuthenticationAllowAnonymous
    toEnum 4 = DBusServerFlagsAuthenticationRequireSameUser
    toEnum k = AnotherDBusServerFlags k

instance P.Ord DBusServerFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusServerFlags = '[]
instance O.HasParentTypes DBusServerFlags

foreign import ccall "g_dbus_server_flags_get_type" c_g_dbus_server_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusServerFlags where
    glibType = c_g_dbus_server_flags_get_type

instance B.Types.BoxedFlags DBusServerFlags

instance IsGFlag DBusServerFlags

-- Flags DBusSendMessageFlags
-- | Flags used when sending @/GDBusMessages/@ on a t'GI.Gio.Objects.DBusConnection.DBusConnection'.
-- 
-- /Since: 2.26/
data DBusSendMessageFlags = 
      DBusSendMessageFlagsNone
    -- ^ No flags set.
    | DBusSendMessageFlagsPreserveSerial
    -- ^ Do not automatically
    -- assign a serial number from the t'GI.Gio.Objects.DBusConnection.DBusConnection' object when
    -- sending a message.
    | AnotherDBusSendMessageFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusSendMessageFlags where
    fromEnum DBusSendMessageFlagsNone = 0
    fromEnum DBusSendMessageFlagsPreserveSerial = 1
    fromEnum (AnotherDBusSendMessageFlags k) = k

    toEnum 0 = DBusSendMessageFlagsNone
    toEnum 1 = DBusSendMessageFlagsPreserveSerial
    toEnum k = AnotherDBusSendMessageFlags k

instance P.Ord DBusSendMessageFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusSendMessageFlags = '[]
instance O.HasParentTypes DBusSendMessageFlags

foreign import ccall "g_dbus_send_message_flags_get_type" c_g_dbus_send_message_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusSendMessageFlags where
    glibType = c_g_dbus_send_message_flags_get_type

instance B.Types.BoxedFlags DBusSendMessageFlags

instance IsGFlag DBusSendMessageFlags

-- Flags DBusProxyFlags
-- | Flags used when constructing an instance of a t'GI.Gio.Objects.DBusProxy.DBusProxy' derived class.
-- 
-- /Since: 2.26/
data DBusProxyFlags = 
      DBusProxyFlagsNone
    -- ^ No flags set.
    | DBusProxyFlagsDoNotLoadProperties
    -- ^ Don\'t load properties.
    | DBusProxyFlagsDoNotConnectSignals
    -- ^ Don\'t connect to signals on the remote object.
    | DBusProxyFlagsDoNotAutoStart
    -- ^ If the proxy is for a well-known name,
    -- do not ask the bus to launch an owner during proxy initialization or a method call.
    -- This flag is only meaningful in proxies for well-known names.
    | DBusProxyFlagsGetInvalidatedProperties
    -- ^ If set, the property value for any __invalidated property__ will be (asynchronously) retrieved upon receiving the <http://dbus.freedesktop.org/doc/dbus-specification.html#standard-interfaces-properties `PropertiesChanged`> D-Bus signal and the property will not cause emission of the [DBusProxy::gPropertiesChanged]("GI.Gio.Objects.DBusProxy#g:signal:gPropertiesChanged") signal. When the value is received the [DBusProxy::gPropertiesChanged]("GI.Gio.Objects.DBusProxy#g:signal:gPropertiesChanged") signal is emitted for the property along with the retrieved value. Since 2.32.
    | DBusProxyFlagsDoNotAutoStartAtConstruction
    -- ^ If the proxy is for a well-known name,
    -- do not ask the bus to launch an owner during proxy initialization, but allow it to be
    -- autostarted by a method call. This flag is only meaningful in proxies for well-known names,
    -- and only if 'GI.Gio.Flags.DBusProxyFlagsDoNotAutoStart' is not also specified.
    | DBusProxyFlagsNoMatchRule
    -- ^ Don\'t actually send the AddMatch D-Bus
    --    call for this signal subscription. This gives you more control
    --    over which match rules you add (but you must add them manually). (Since: 2.72)
    | AnotherDBusProxyFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusProxyFlags where
    fromEnum DBusProxyFlagsNone = 0
    fromEnum DBusProxyFlagsDoNotLoadProperties = 1
    fromEnum DBusProxyFlagsDoNotConnectSignals = 2
    fromEnum DBusProxyFlagsDoNotAutoStart = 4
    fromEnum DBusProxyFlagsGetInvalidatedProperties = 8
    fromEnum DBusProxyFlagsDoNotAutoStartAtConstruction = 16
    fromEnum DBusProxyFlagsNoMatchRule = 32
    fromEnum (AnotherDBusProxyFlags k) = k

    toEnum 0 = DBusProxyFlagsNone
    toEnum 1 = DBusProxyFlagsDoNotLoadProperties
    toEnum 2 = DBusProxyFlagsDoNotConnectSignals
    toEnum 4 = DBusProxyFlagsDoNotAutoStart
    toEnum 8 = DBusProxyFlagsGetInvalidatedProperties
    toEnum 16 = DBusProxyFlagsDoNotAutoStartAtConstruction
    toEnum 32 = DBusProxyFlagsNoMatchRule
    toEnum k = AnotherDBusProxyFlags k

instance P.Ord DBusProxyFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusProxyFlags = '[]
instance O.HasParentTypes DBusProxyFlags

foreign import ccall "g_dbus_proxy_flags_get_type" c_g_dbus_proxy_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusProxyFlags where
    glibType = c_g_dbus_proxy_flags_get_type

instance B.Types.BoxedFlags DBusProxyFlags

instance IsGFlag DBusProxyFlags

-- Flags DBusPropertyInfoFlags
-- | Flags describing the access control of a D-Bus property.
-- 
-- /Since: 2.26/
data DBusPropertyInfoFlags = 
      DBusPropertyInfoFlagsNone
    -- ^ No flags set.
    | DBusPropertyInfoFlagsReadable
    -- ^ Property is readable.
    | DBusPropertyInfoFlagsWritable
    -- ^ Property is writable.
    | AnotherDBusPropertyInfoFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusPropertyInfoFlags where
    fromEnum DBusPropertyInfoFlagsNone = 0
    fromEnum DBusPropertyInfoFlagsReadable = 1
    fromEnum DBusPropertyInfoFlagsWritable = 2
    fromEnum (AnotherDBusPropertyInfoFlags k) = k

    toEnum 0 = DBusPropertyInfoFlagsNone
    toEnum 1 = DBusPropertyInfoFlagsReadable
    toEnum 2 = DBusPropertyInfoFlagsWritable
    toEnum k = AnotherDBusPropertyInfoFlags k

instance P.Ord DBusPropertyInfoFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusPropertyInfoFlags = '[]
instance O.HasParentTypes DBusPropertyInfoFlags

foreign import ccall "g_dbus_property_info_flags_get_type" c_g_dbus_property_info_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusPropertyInfoFlags where
    glibType = c_g_dbus_property_info_flags_get_type

instance B.Types.BoxedFlags DBusPropertyInfoFlags

instance IsGFlag DBusPropertyInfoFlags

-- Flags DBusObjectManagerClientFlags
-- | Flags used when constructing a t'GI.Gio.Objects.DBusObjectManagerClient.DBusObjectManagerClient'.
-- 
-- /Since: 2.30/
data DBusObjectManagerClientFlags = 
      DBusObjectManagerClientFlagsNone
    -- ^ No flags set.
    | DBusObjectManagerClientFlagsDoNotAutoStart
    -- ^ If not set and the
    --   manager is for a well-known name, then request the bus to launch
    --   an owner for the name if no-one owns the name. This flag can only
    --   be used in managers for well-known names.
    | AnotherDBusObjectManagerClientFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusObjectManagerClientFlags where
    fromEnum DBusObjectManagerClientFlagsNone = 0
    fromEnum DBusObjectManagerClientFlagsDoNotAutoStart = 1
    fromEnum (AnotherDBusObjectManagerClientFlags k) = k

    toEnum 0 = DBusObjectManagerClientFlagsNone
    toEnum 1 = DBusObjectManagerClientFlagsDoNotAutoStart
    toEnum k = AnotherDBusObjectManagerClientFlags k

instance P.Ord DBusObjectManagerClientFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusObjectManagerClientFlags = '[]
instance O.HasParentTypes DBusObjectManagerClientFlags

foreign import ccall "g_dbus_object_manager_client_flags_get_type" c_g_dbus_object_manager_client_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusObjectManagerClientFlags where
    glibType = c_g_dbus_object_manager_client_flags_get_type

instance B.Types.BoxedFlags DBusObjectManagerClientFlags

instance IsGFlag DBusObjectManagerClientFlags

-- Flags DBusMessageFlags
-- | Message flags used in t'GI.Gio.Objects.DBusMessage.DBusMessage'.
-- 
-- /Since: 2.26/
data DBusMessageFlags = 
      DBusMessageFlagsNone
    -- ^ No flags set.
    | DBusMessageFlagsNoReplyExpected
    -- ^ A reply is not expected.
    | DBusMessageFlagsNoAutoStart
    -- ^ The bus must not launch an
    -- owner for the destination name in response to this message.
    | DBusMessageFlagsAllowInteractiveAuthorization
    -- ^ If set on a method
    -- call, this flag means that the caller is prepared to wait for interactive
    -- authorization. Since 2.46.
    | AnotherDBusMessageFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusMessageFlags where
    fromEnum DBusMessageFlagsNone = 0
    fromEnum DBusMessageFlagsNoReplyExpected = 1
    fromEnum DBusMessageFlagsNoAutoStart = 2
    fromEnum DBusMessageFlagsAllowInteractiveAuthorization = 4
    fromEnum (AnotherDBusMessageFlags k) = k

    toEnum 0 = DBusMessageFlagsNone
    toEnum 1 = DBusMessageFlagsNoReplyExpected
    toEnum 2 = DBusMessageFlagsNoAutoStart
    toEnum 4 = DBusMessageFlagsAllowInteractiveAuthorization
    toEnum k = AnotherDBusMessageFlags k

instance P.Ord DBusMessageFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusMessageFlags = '[]
instance O.HasParentTypes DBusMessageFlags

foreign import ccall "g_dbus_message_flags_get_type" c_g_dbus_message_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusMessageFlags where
    glibType = c_g_dbus_message_flags_get_type

instance B.Types.BoxedFlags DBusMessageFlags

instance IsGFlag DBusMessageFlags

-- Flags DBusInterfaceSkeletonFlags
-- | Flags describing the behavior of a t'GI.Gio.Objects.DBusInterfaceSkeleton.DBusInterfaceSkeleton' instance.
-- 
-- /Since: 2.30/
data DBusInterfaceSkeletonFlags = 
      DBusInterfaceSkeletonFlagsNone
    -- ^ No flags set.
    | DBusInterfaceSkeletonFlagsHandleMethodInvocationsInThread
    -- ^ Each method invocation is handled in
    --   a thread dedicated to the invocation. This means that the method implementation can use blocking IO
    --   without blocking any other part of the process. It also means that the method implementation must
    --   use locking to access data structures used by other threads.
    | AnotherDBusInterfaceSkeletonFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusInterfaceSkeletonFlags where
    fromEnum DBusInterfaceSkeletonFlagsNone = 0
    fromEnum DBusInterfaceSkeletonFlagsHandleMethodInvocationsInThread = 1
    fromEnum (AnotherDBusInterfaceSkeletonFlags k) = k

    toEnum 0 = DBusInterfaceSkeletonFlagsNone
    toEnum 1 = DBusInterfaceSkeletonFlagsHandleMethodInvocationsInThread
    toEnum k = AnotherDBusInterfaceSkeletonFlags k

instance P.Ord DBusInterfaceSkeletonFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusInterfaceSkeletonFlags = '[]
instance O.HasParentTypes DBusInterfaceSkeletonFlags

foreign import ccall "g_dbus_interface_skeleton_flags_get_type" c_g_dbus_interface_skeleton_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusInterfaceSkeletonFlags where
    glibType = c_g_dbus_interface_skeleton_flags_get_type

instance B.Types.BoxedFlags DBusInterfaceSkeletonFlags

instance IsGFlag DBusInterfaceSkeletonFlags

-- Flags DBusConnectionFlags
-- | Flags used when creating a new t'GI.Gio.Objects.DBusConnection.DBusConnection'.
-- 
-- /Since: 2.26/
data DBusConnectionFlags = 
      DBusConnectionFlagsNone
    -- ^ No flags set.
    | DBusConnectionFlagsAuthenticationClient
    -- ^ Perform authentication against server.
    | DBusConnectionFlagsAuthenticationServer
    -- ^ Perform authentication against client.
    | DBusConnectionFlagsAuthenticationAllowAnonymous
    -- ^ When
    -- authenticating as a server, allow the anonymous authentication
    -- method.
    | DBusConnectionFlagsMessageBusConnection
    -- ^ Pass this flag if connecting to a peer that is a
    -- message bus. This means that the @/Hello()/@ method will be invoked as part of the connection setup.
    | DBusConnectionFlagsDelayMessageProcessing
    -- ^ If set, processing of D-Bus messages is
    -- delayed until 'GI.Gio.Objects.DBusConnection.dBusConnectionStartMessageProcessing' is called.
    | DBusConnectionFlagsAuthenticationRequireSameUser
    -- ^ When authenticating
    -- as a server, require the UID of the peer to be the same as the UID of the server. (Since: 2.68)
    | DBusConnectionFlagsCrossNamespace
    -- ^ When authenticating, try to use
    --  protocols that work across a Linux user namespace boundary, even if this
    --  reduces interoperability with older D-Bus implementations. This currently
    --  affects client-side @EXTERNAL@ authentication, for which this flag makes
    --  connections to a server in another user namespace succeed, but causes
    --  a deadlock when connecting to a GDBus server older than 2.73.3. Since: 2.74
    | AnotherDBusConnectionFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusConnectionFlags where
    fromEnum DBusConnectionFlagsNone = 0
    fromEnum DBusConnectionFlagsAuthenticationClient = 1
    fromEnum DBusConnectionFlagsAuthenticationServer = 2
    fromEnum DBusConnectionFlagsAuthenticationAllowAnonymous = 4
    fromEnum DBusConnectionFlagsMessageBusConnection = 8
    fromEnum DBusConnectionFlagsDelayMessageProcessing = 16
    fromEnum DBusConnectionFlagsAuthenticationRequireSameUser = 32
    fromEnum DBusConnectionFlagsCrossNamespace = 64
    fromEnum (AnotherDBusConnectionFlags k) = k

    toEnum 0 = DBusConnectionFlagsNone
    toEnum 1 = DBusConnectionFlagsAuthenticationClient
    toEnum 2 = DBusConnectionFlagsAuthenticationServer
    toEnum 4 = DBusConnectionFlagsAuthenticationAllowAnonymous
    toEnum 8 = DBusConnectionFlagsMessageBusConnection
    toEnum 16 = DBusConnectionFlagsDelayMessageProcessing
    toEnum 32 = DBusConnectionFlagsAuthenticationRequireSameUser
    toEnum 64 = DBusConnectionFlagsCrossNamespace
    toEnum k = AnotherDBusConnectionFlags k

instance P.Ord DBusConnectionFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusConnectionFlags = '[]
instance O.HasParentTypes DBusConnectionFlags

foreign import ccall "g_dbus_connection_flags_get_type" c_g_dbus_connection_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusConnectionFlags where
    glibType = c_g_dbus_connection_flags_get_type

instance B.Types.BoxedFlags DBusConnectionFlags

instance IsGFlag DBusConnectionFlags

-- Flags DBusCapabilityFlags
-- | Capabilities negotiated with the remote peer.
-- 
-- /Since: 2.26/
data DBusCapabilityFlags = 
      DBusCapabilityFlagsNone
    -- ^ No flags set.
    | DBusCapabilityFlagsUnixFdPassing
    -- ^ The connection
    -- supports exchanging UNIX file descriptors with the remote peer.
    | AnotherDBusCapabilityFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusCapabilityFlags where
    fromEnum DBusCapabilityFlagsNone = 0
    fromEnum DBusCapabilityFlagsUnixFdPassing = 1
    fromEnum (AnotherDBusCapabilityFlags k) = k

    toEnum 0 = DBusCapabilityFlagsNone
    toEnum 1 = DBusCapabilityFlagsUnixFdPassing
    toEnum k = AnotherDBusCapabilityFlags k

instance P.Ord DBusCapabilityFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusCapabilityFlags = '[]
instance O.HasParentTypes DBusCapabilityFlags

foreign import ccall "g_dbus_capability_flags_get_type" c_g_dbus_capability_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusCapabilityFlags where
    glibType = c_g_dbus_capability_flags_get_type

instance B.Types.BoxedFlags DBusCapabilityFlags

instance IsGFlag DBusCapabilityFlags

-- Flags DBusCallFlags
-- | Flags used in 'GI.Gio.Objects.DBusConnection.dBusConnectionCall' and similar APIs.
-- 
-- /Since: 2.26/
data DBusCallFlags = 
      DBusCallFlagsNone
    -- ^ No flags set.
    | DBusCallFlagsNoAutoStart
    -- ^ The bus must not launch
    -- an owner for the destination name in response to this method
    -- invocation.
    | DBusCallFlagsAllowInteractiveAuthorization
    -- ^ the caller is prepared to
    -- wait for interactive authorization. Since 2.46.
    | AnotherDBusCallFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DBusCallFlags where
    fromEnum DBusCallFlagsNone = 0
    fromEnum DBusCallFlagsNoAutoStart = 1
    fromEnum DBusCallFlagsAllowInteractiveAuthorization = 2
    fromEnum (AnotherDBusCallFlags k) = k

    toEnum 0 = DBusCallFlagsNone
    toEnum 1 = DBusCallFlagsNoAutoStart
    toEnum 2 = DBusCallFlagsAllowInteractiveAuthorization
    toEnum k = AnotherDBusCallFlags k

instance P.Ord DBusCallFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DBusCallFlags = '[]
instance O.HasParentTypes DBusCallFlags

foreign import ccall "g_dbus_call_flags_get_type" c_g_dbus_call_flags_get_type :: 
    IO GType

instance B.Types.TypedObject DBusCallFlags where
    glibType = c_g_dbus_call_flags_get_type

instance B.Types.BoxedFlags DBusCallFlags

instance IsGFlag DBusCallFlags

-- Flags ConverterFlags
-- | Flags used when calling a 'GI.Gio.Interfaces.Converter.converterConvert'.
-- 
-- /Since: 2.24/
data ConverterFlags = 
      ConverterFlagsNone
    -- ^ No flags.
    | ConverterFlagsInputAtEnd
    -- ^ At end of input data
    | ConverterFlagsFlush
    -- ^ Flush data
    | AnotherConverterFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ConverterFlags where
    fromEnum ConverterFlagsNone = 0
    fromEnum ConverterFlagsInputAtEnd = 1
    fromEnum ConverterFlagsFlush = 2
    fromEnum (AnotherConverterFlags k) = k

    toEnum 0 = ConverterFlagsNone
    toEnum 1 = ConverterFlagsInputAtEnd
    toEnum 2 = ConverterFlagsFlush
    toEnum k = AnotherConverterFlags k

instance P.Ord ConverterFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ConverterFlags = '[]
instance O.HasParentTypes ConverterFlags

foreign import ccall "g_converter_flags_get_type" c_g_converter_flags_get_type :: 
    IO GType

instance B.Types.TypedObject ConverterFlags where
    glibType = c_g_converter_flags_get_type

instance B.Types.BoxedFlags ConverterFlags

instance IsGFlag ConverterFlags

-- Flags BusNameWatcherFlags
-- | Flags used in @/g_bus_watch_name()/@.
-- 
-- /Since: 2.26/
data BusNameWatcherFlags = 
      BusNameWatcherFlagsNone
    -- ^ No flags set.
    | BusNameWatcherFlagsAutoStart
    -- ^ If no-one owns the name when
    -- beginning to watch the name, ask the bus to launch an owner for the
    -- name.
    | AnotherBusNameWatcherFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BusNameWatcherFlags where
    fromEnum BusNameWatcherFlagsNone = 0
    fromEnum BusNameWatcherFlagsAutoStart = 1
    fromEnum (AnotherBusNameWatcherFlags k) = k

    toEnum 0 = BusNameWatcherFlagsNone
    toEnum 1 = BusNameWatcherFlagsAutoStart
    toEnum k = AnotherBusNameWatcherFlags k

instance P.Ord BusNameWatcherFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BusNameWatcherFlags = '[]
instance O.HasParentTypes BusNameWatcherFlags

foreign import ccall "g_bus_name_watcher_flags_get_type" c_g_bus_name_watcher_flags_get_type :: 
    IO GType

instance B.Types.TypedObject BusNameWatcherFlags where
    glibType = c_g_bus_name_watcher_flags_get_type

instance B.Types.BoxedFlags BusNameWatcherFlags

instance IsGFlag BusNameWatcherFlags

-- Flags BusNameOwnerFlags
-- | Flags used in @/g_bus_own_name()/@.
-- 
-- /Since: 2.26/
data BusNameOwnerFlags = 
      BusNameOwnerFlagsNone
    -- ^ No flags set.
    | BusNameOwnerFlagsAllowReplacement
    -- ^ Allow another message bus connection to claim the name.
    | BusNameOwnerFlagsReplace
    -- ^ If another message bus connection owns the name and have
    -- specified 'GI.Gio.Flags.BusNameOwnerFlagsAllowReplacement', then take the name from the other connection.
    | BusNameOwnerFlagsDoNotQueue
    -- ^ If another message bus connection owns the name, immediately
    -- return an error from @/g_bus_own_name()/@ rather than entering the waiting queue for that name. (Since 2.54)
    | AnotherBusNameOwnerFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum BusNameOwnerFlags where
    fromEnum BusNameOwnerFlagsNone = 0
    fromEnum BusNameOwnerFlagsAllowReplacement = 1
    fromEnum BusNameOwnerFlagsReplace = 2
    fromEnum BusNameOwnerFlagsDoNotQueue = 4
    fromEnum (AnotherBusNameOwnerFlags k) = k

    toEnum 0 = BusNameOwnerFlagsNone
    toEnum 1 = BusNameOwnerFlagsAllowReplacement
    toEnum 2 = BusNameOwnerFlagsReplace
    toEnum 4 = BusNameOwnerFlagsDoNotQueue
    toEnum k = AnotherBusNameOwnerFlags k

instance P.Ord BusNameOwnerFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes BusNameOwnerFlags = '[]
instance O.HasParentTypes BusNameOwnerFlags

foreign import ccall "g_bus_name_owner_flags_get_type" c_g_bus_name_owner_flags_get_type :: 
    IO GType

instance B.Types.TypedObject BusNameOwnerFlags where
    glibType = c_g_bus_name_owner_flags_get_type

instance B.Types.BoxedFlags BusNameOwnerFlags

instance IsGFlag BusNameOwnerFlags

-- Flags AskPasswordFlags
-- | t'GI.Gio.Flags.AskPasswordFlags' are used to request specific information from the
-- user, or to notify the user of their choices in an authentication
-- situation.
data AskPasswordFlags = 
      AskPasswordFlagsNeedPassword
    -- ^ operation requires a password.
    | AskPasswordFlagsNeedUsername
    -- ^ operation requires a username.
    | AskPasswordFlagsNeedDomain
    -- ^ operation requires a domain.
    | AskPasswordFlagsSavingSupported
    -- ^ operation supports saving settings.
    | AskPasswordFlagsAnonymousSupported
    -- ^ operation supports anonymous users.
    | AskPasswordFlagsTcrypt
    -- ^ operation takes TCRYPT parameters (Since: 2.58)
    | AnotherAskPasswordFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AskPasswordFlags where
    fromEnum AskPasswordFlagsNeedPassword = 1
    fromEnum AskPasswordFlagsNeedUsername = 2
    fromEnum AskPasswordFlagsNeedDomain = 4
    fromEnum AskPasswordFlagsSavingSupported = 8
    fromEnum AskPasswordFlagsAnonymousSupported = 16
    fromEnum AskPasswordFlagsTcrypt = 32
    fromEnum (AnotherAskPasswordFlags k) = k

    toEnum 1 = AskPasswordFlagsNeedPassword
    toEnum 2 = AskPasswordFlagsNeedUsername
    toEnum 4 = AskPasswordFlagsNeedDomain
    toEnum 8 = AskPasswordFlagsSavingSupported
    toEnum 16 = AskPasswordFlagsAnonymousSupported
    toEnum 32 = AskPasswordFlagsTcrypt
    toEnum k = AnotherAskPasswordFlags k

instance P.Ord AskPasswordFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AskPasswordFlags = '[]
instance O.HasParentTypes AskPasswordFlags

foreign import ccall "g_ask_password_flags_get_type" c_g_ask_password_flags_get_type :: 
    IO GType

instance B.Types.TypedObject AskPasswordFlags where
    glibType = c_g_ask_password_flags_get_type

instance B.Types.BoxedFlags AskPasswordFlags

instance IsGFlag AskPasswordFlags

-- Flags ApplicationFlags
-- | Flags used to define the behaviour of a t'GI.Gio.Objects.Application.Application'.
-- 
-- /Since: 2.28/
data ApplicationFlags = 
      ApplicationFlagsFlagsNone
    -- ^ Default flags.
    | ApplicationFlagsDefaultFlags
    -- ^ Default flags.
    -- 
    -- /Since: 2.74/
    | ApplicationFlagsIsService
    -- ^ Run as a service. In this mode, registration
    --      fails if the service is already running, and the application
    --      will initially wait up to 10 seconds for an initial activation
    --      message to arrive.
    | ApplicationFlagsIsLauncher
    -- ^ Don\'t try to become the primary instance.
    | ApplicationFlagsHandlesOpen
    -- ^ This application handles opening files (in
    --     the primary instance). Note that this flag only affects the default
    --     implementation of @/local_command_line()/@, and has no effect if
    --     'GI.Gio.Flags.ApplicationFlagsHandlesCommandLine' is given.
    --     See 'GI.Gio.Objects.Application.applicationRun' for details.
    | ApplicationFlagsHandlesCommandLine
    -- ^ This application handles command line
    --     arguments (in the primary instance). Note that this flag only affect
    --     the default implementation of @/local_command_line()/@.
    --     See 'GI.Gio.Objects.Application.applicationRun' for details.
    | ApplicationFlagsSendEnvironment
    -- ^ Send the environment of the
    --     launching process to the primary instance. Set this flag if your
    --     application is expected to behave differently depending on certain
    --     environment variables. For instance, an editor might be expected
    --     to use the @GIT_COMMITTER_NAME@ environment variable
    --     when editing a git commit message. The environment is available
    --     to the [Application::commandLine]("GI.Gio.Objects.Application#g:signal:commandLine") signal handler, via
    --     'GI.Gio.Objects.ApplicationCommandLine.applicationCommandLineGetenv'.
    | ApplicationFlagsNonUnique
    -- ^ Make no attempts to do any of the typical
    --     single-instance application negotiation, even if the application
    --     ID is given.  The application neither attempts to become the
    --     owner of the application ID nor does it check if an existing
    --     owner already exists.  Everything occurs in the local process.
    --     Since: 2.30.
    | ApplicationFlagsCanOverrideAppId
    -- ^ Allow users to override the
    --     application ID from the command line with @--gapplication-app-id@.
    --     Since: 2.48
    | ApplicationFlagsAllowReplacement
    -- ^ Allow another instance to take over
    --     the bus name. Since: 2.60
    | ApplicationFlagsReplace
    -- ^ Take over from another instance. This flag is
    --     usually set by passing @--gapplication-replace@ on the commandline.
    --     Since: 2.60
    | AnotherApplicationFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ApplicationFlags where
    fromEnum ApplicationFlagsFlagsNone = 0
    fromEnum ApplicationFlagsDefaultFlags = 0
    fromEnum ApplicationFlagsIsService = 1
    fromEnum ApplicationFlagsIsLauncher = 2
    fromEnum ApplicationFlagsHandlesOpen = 4
    fromEnum ApplicationFlagsHandlesCommandLine = 8
    fromEnum ApplicationFlagsSendEnvironment = 16
    fromEnum ApplicationFlagsNonUnique = 32
    fromEnum ApplicationFlagsCanOverrideAppId = 64
    fromEnum ApplicationFlagsAllowReplacement = 128
    fromEnum ApplicationFlagsReplace = 256
    fromEnum (AnotherApplicationFlags k) = k

    toEnum 0 = ApplicationFlagsFlagsNone
    toEnum 1 = ApplicationFlagsIsService
    toEnum 2 = ApplicationFlagsIsLauncher
    toEnum 4 = ApplicationFlagsHandlesOpen
    toEnum 8 = ApplicationFlagsHandlesCommandLine
    toEnum 16 = ApplicationFlagsSendEnvironment
    toEnum 32 = ApplicationFlagsNonUnique
    toEnum 64 = ApplicationFlagsCanOverrideAppId
    toEnum 128 = ApplicationFlagsAllowReplacement
    toEnum 256 = ApplicationFlagsReplace
    toEnum k = AnotherApplicationFlags k

instance P.Ord ApplicationFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ApplicationFlags = '[]
instance O.HasParentTypes ApplicationFlags

foreign import ccall "g_application_flags_get_type" c_g_application_flags_get_type :: 
    IO GType

instance B.Types.TypedObject ApplicationFlags where
    glibType = c_g_application_flags_get_type

instance B.Types.BoxedFlags ApplicationFlags

instance IsGFlag ApplicationFlags

-- Flags AppInfoCreateFlags
-- | Flags used when creating a t'GI.Gio.Interfaces.AppInfo.AppInfo'.
data AppInfoCreateFlags = 
      AppInfoCreateFlagsNone
    -- ^ No flags.
    | AppInfoCreateFlagsNeedsTerminal
    -- ^ Application opens in a terminal window.
    | AppInfoCreateFlagsSupportsUris
    -- ^ Application supports URI arguments.
    | AppInfoCreateFlagsSupportsStartupNotification
    -- ^ Application supports startup notification. Since 2.26
    | AnotherAppInfoCreateFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AppInfoCreateFlags where
    fromEnum AppInfoCreateFlagsNone = 0
    fromEnum AppInfoCreateFlagsNeedsTerminal = 1
    fromEnum AppInfoCreateFlagsSupportsUris = 2
    fromEnum AppInfoCreateFlagsSupportsStartupNotification = 4
    fromEnum (AnotherAppInfoCreateFlags k) = k

    toEnum 0 = AppInfoCreateFlagsNone
    toEnum 1 = AppInfoCreateFlagsNeedsTerminal
    toEnum 2 = AppInfoCreateFlagsSupportsUris
    toEnum 4 = AppInfoCreateFlagsSupportsStartupNotification
    toEnum k = AnotherAppInfoCreateFlags k

instance P.Ord AppInfoCreateFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AppInfoCreateFlags = '[]
instance O.HasParentTypes AppInfoCreateFlags

foreign import ccall "g_app_info_create_flags_get_type" c_g_app_info_create_flags_get_type :: 
    IO GType

instance B.Types.TypedObject AppInfoCreateFlags where
    glibType = c_g_app_info_create_flags_get_type

instance B.Types.BoxedFlags AppInfoCreateFlags

instance IsGFlag AppInfoCreateFlags


