

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Callbacks
    ( 

 -- * Signals


-- ** ActionEntryActivateFieldCallback #signal:ActionEntryActivateFieldCallback#

    ActionEntryActivateFieldCallback        ,
    ActionEntryActivateFieldCallback_WithClosures,
    C_ActionEntryActivateFieldCallback      ,
    drop_closures_ActionEntryActivateFieldCallback,
    dynamic_ActionEntryActivateFieldCallback,
    genClosure_ActionEntryActivateFieldCallback,
    mk_ActionEntryActivateFieldCallback     ,
    noActionEntryActivateFieldCallback      ,
    noActionEntryActivateFieldCallback_WithClosures,
    wrap_ActionEntryActivateFieldCallback   ,


-- ** ActionEntryChangeStateFieldCallback #signal:ActionEntryChangeStateFieldCallback#

    ActionEntryChangeStateFieldCallback     ,
    ActionEntryChangeStateFieldCallback_WithClosures,
    C_ActionEntryChangeStateFieldCallback   ,
    drop_closures_ActionEntryChangeStateFieldCallback,
    dynamic_ActionEntryChangeStateFieldCallback,
    genClosure_ActionEntryChangeStateFieldCallback,
    mk_ActionEntryChangeStateFieldCallback  ,
    noActionEntryChangeStateFieldCallback   ,
    noActionEntryChangeStateFieldCallback_WithClosures,
    wrap_ActionEntryChangeStateFieldCallback,


-- ** AsyncReadyCallback #signal:AsyncReadyCallback#

    AsyncReadyCallback                      ,
    AsyncReadyCallback_WithClosures         ,
    C_AsyncReadyCallback                    ,
    drop_closures_AsyncReadyCallback        ,
    dynamic_AsyncReadyCallback              ,
    genClosure_AsyncReadyCallback           ,
    mk_AsyncReadyCallback                   ,
    noAsyncReadyCallback                    ,
    noAsyncReadyCallback_WithClosures       ,
    wrap_AsyncReadyCallback                 ,


-- ** BusAcquiredCallback #signal:BusAcquiredCallback#

    BusAcquiredCallback                     ,
    BusAcquiredCallback_WithClosures        ,
    C_BusAcquiredCallback                   ,
    drop_closures_BusAcquiredCallback       ,
    dynamic_BusAcquiredCallback             ,
    genClosure_BusAcquiredCallback          ,
    mk_BusAcquiredCallback                  ,
    noBusAcquiredCallback                   ,
    noBusAcquiredCallback_WithClosures      ,
    wrap_BusAcquiredCallback                ,


-- ** BusNameAcquiredCallback #signal:BusNameAcquiredCallback#

    BusNameAcquiredCallback                 ,
    BusNameAcquiredCallback_WithClosures    ,
    C_BusNameAcquiredCallback               ,
    drop_closures_BusNameAcquiredCallback   ,
    dynamic_BusNameAcquiredCallback         ,
    genClosure_BusNameAcquiredCallback      ,
    mk_BusNameAcquiredCallback              ,
    noBusNameAcquiredCallback               ,
    noBusNameAcquiredCallback_WithClosures  ,
    wrap_BusNameAcquiredCallback            ,


-- ** BusNameAppearedCallback #signal:BusNameAppearedCallback#

    BusNameAppearedCallback                 ,
    BusNameAppearedCallback_WithClosures    ,
    C_BusNameAppearedCallback               ,
    drop_closures_BusNameAppearedCallback   ,
    dynamic_BusNameAppearedCallback         ,
    genClosure_BusNameAppearedCallback      ,
    mk_BusNameAppearedCallback              ,
    noBusNameAppearedCallback               ,
    noBusNameAppearedCallback_WithClosures  ,
    wrap_BusNameAppearedCallback            ,


-- ** BusNameLostCallback #signal:BusNameLostCallback#

    BusNameLostCallback                     ,
    BusNameLostCallback_WithClosures        ,
    C_BusNameLostCallback                   ,
    drop_closures_BusNameLostCallback       ,
    dynamic_BusNameLostCallback             ,
    genClosure_BusNameLostCallback          ,
    mk_BusNameLostCallback                  ,
    noBusNameLostCallback                   ,
    noBusNameLostCallback_WithClosures      ,
    wrap_BusNameLostCallback                ,


-- ** BusNameVanishedCallback #signal:BusNameVanishedCallback#

    BusNameVanishedCallback                 ,
    BusNameVanishedCallback_WithClosures    ,
    C_BusNameVanishedCallback               ,
    drop_closures_BusNameVanishedCallback   ,
    dynamic_BusNameVanishedCallback         ,
    genClosure_BusNameVanishedCallback      ,
    mk_BusNameVanishedCallback              ,
    noBusNameVanishedCallback               ,
    noBusNameVanishedCallback_WithClosures  ,
    wrap_BusNameVanishedCallback            ,


-- ** CancellableSourceFunc #signal:CancellableSourceFunc#

    C_CancellableSourceFunc                 ,
    CancellableSourceFunc                   ,
    CancellableSourceFunc_WithClosures      ,
    drop_closures_CancellableSourceFunc     ,
    dynamic_CancellableSourceFunc           ,
    genClosure_CancellableSourceFunc        ,
    mk_CancellableSourceFunc                ,
    noCancellableSourceFunc                 ,
    noCancellableSourceFunc_WithClosures    ,
    wrap_CancellableSourceFunc              ,


-- ** DBusInterfaceGetPropertyFunc #signal:DBusInterfaceGetPropertyFunc#

    C_DBusInterfaceGetPropertyFunc          ,
    DBusInterfaceGetPropertyFunc            ,
    DBusInterfaceGetPropertyFunc_WithClosures,
    drop_closures_DBusInterfaceGetPropertyFunc,
    dynamic_DBusInterfaceGetPropertyFunc    ,
    genClosure_DBusInterfaceGetPropertyFunc ,
    mk_DBusInterfaceGetPropertyFunc         ,
    noDBusInterfaceGetPropertyFunc          ,
    noDBusInterfaceGetPropertyFunc_WithClosures,
    wrap_DBusInterfaceGetPropertyFunc       ,


-- ** DBusInterfaceMethodCallFunc #signal:DBusInterfaceMethodCallFunc#

    C_DBusInterfaceMethodCallFunc           ,
    DBusInterfaceMethodCallFunc             ,
    DBusInterfaceMethodCallFunc_WithClosures,
    drop_closures_DBusInterfaceMethodCallFunc,
    dynamic_DBusInterfaceMethodCallFunc     ,
    genClosure_DBusInterfaceMethodCallFunc  ,
    mk_DBusInterfaceMethodCallFunc          ,
    noDBusInterfaceMethodCallFunc           ,
    noDBusInterfaceMethodCallFunc_WithClosures,
    wrap_DBusInterfaceMethodCallFunc        ,


-- ** DBusInterfaceSetPropertyFunc #signal:DBusInterfaceSetPropertyFunc#

    C_DBusInterfaceSetPropertyFunc          ,
    DBusInterfaceSetPropertyFunc            ,
    DBusInterfaceSetPropertyFunc_WithClosures,
    drop_closures_DBusInterfaceSetPropertyFunc,
    dynamic_DBusInterfaceSetPropertyFunc    ,
    genClosure_DBusInterfaceSetPropertyFunc ,
    mk_DBusInterfaceSetPropertyFunc         ,
    noDBusInterfaceSetPropertyFunc          ,
    noDBusInterfaceSetPropertyFunc_WithClosures,
    wrap_DBusInterfaceSetPropertyFunc       ,


-- ** DBusMessageFilterFunction #signal:DBusMessageFilterFunction#

    C_DBusMessageFilterFunction             ,
    DBusMessageFilterFunction               ,
    DBusMessageFilterFunction_WithClosures  ,
    drop_closures_DBusMessageFilterFunction ,
    dynamic_DBusMessageFilterFunction       ,
    genClosure_DBusMessageFilterFunction    ,
    mk_DBusMessageFilterFunction            ,
    noDBusMessageFilterFunction             ,
    noDBusMessageFilterFunction_WithClosures,
    wrap_DBusMessageFilterFunction          ,


-- ** DBusProxyTypeFunc #signal:DBusProxyTypeFunc#

    C_DBusProxyTypeFunc                     ,
    DBusProxyTypeFunc                       ,
    DBusProxyTypeFunc_WithClosures          ,
    drop_closures_DBusProxyTypeFunc         ,
    dynamic_DBusProxyTypeFunc               ,
    genClosure_DBusProxyTypeFunc            ,
    mk_DBusProxyTypeFunc                    ,
    noDBusProxyTypeFunc                     ,
    noDBusProxyTypeFunc_WithClosures        ,
    wrap_DBusProxyTypeFunc                  ,


-- ** DBusSignalCallback #signal:DBusSignalCallback#

    C_DBusSignalCallback                    ,
    DBusSignalCallback                      ,
    DBusSignalCallback_WithClosures         ,
    drop_closures_DBusSignalCallback        ,
    dynamic_DBusSignalCallback              ,
    genClosure_DBusSignalCallback           ,
    mk_DBusSignalCallback                   ,
    noDBusSignalCallback                    ,
    noDBusSignalCallback_WithClosures       ,
    wrap_DBusSignalCallback                 ,


-- ** DBusSubtreeDispatchFunc #signal:DBusSubtreeDispatchFunc#

    C_DBusSubtreeDispatchFunc               ,
    DBusSubtreeDispatchFunc                 ,
    DBusSubtreeDispatchFunc_WithClosures    ,
    drop_closures_DBusSubtreeDispatchFunc   ,
    dynamic_DBusSubtreeDispatchFunc         ,
    genClosure_DBusSubtreeDispatchFunc      ,
    mk_DBusSubtreeDispatchFunc              ,
    noDBusSubtreeDispatchFunc               ,
    noDBusSubtreeDispatchFunc_WithClosures  ,
    wrap_DBusSubtreeDispatchFunc            ,


-- ** DBusSubtreeEnumerateFunc #signal:DBusSubtreeEnumerateFunc#

    C_DBusSubtreeEnumerateFunc              ,
    DBusSubtreeEnumerateFunc                ,
    DBusSubtreeEnumerateFunc_WithClosures   ,
    drop_closures_DBusSubtreeEnumerateFunc  ,
    dynamic_DBusSubtreeEnumerateFunc        ,
    genClosure_DBusSubtreeEnumerateFunc     ,
    mk_DBusSubtreeEnumerateFunc             ,
    noDBusSubtreeEnumerateFunc              ,
    noDBusSubtreeEnumerateFunc_WithClosures ,
    wrap_DBusSubtreeEnumerateFunc           ,


-- ** DBusSubtreeIntrospectFunc #signal:DBusSubtreeIntrospectFunc#

    C_DBusSubtreeIntrospectFunc             ,
    DBusSubtreeIntrospectFunc               ,
    DBusSubtreeIntrospectFunc_WithClosures  ,
    drop_closures_DBusSubtreeIntrospectFunc ,
    dynamic_DBusSubtreeIntrospectFunc       ,
    genClosure_DBusSubtreeIntrospectFunc    ,
    mk_DBusSubtreeIntrospectFunc            ,
    noDBusSubtreeIntrospectFunc             ,
    noDBusSubtreeIntrospectFunc_WithClosures,
    wrap_DBusSubtreeIntrospectFunc          ,


-- ** DatagramBasedSourceFunc #signal:DatagramBasedSourceFunc#

    C_DatagramBasedSourceFunc               ,
    DatagramBasedSourceFunc                 ,
    DatagramBasedSourceFunc_WithClosures    ,
    drop_closures_DatagramBasedSourceFunc   ,
    dynamic_DatagramBasedSourceFunc         ,
    genClosure_DatagramBasedSourceFunc      ,
    mk_DatagramBasedSourceFunc              ,
    noDatagramBasedSourceFunc               ,
    noDatagramBasedSourceFunc_WithClosures  ,
    wrap_DatagramBasedSourceFunc            ,


-- ** DesktopAppLaunchCallback #signal:DesktopAppLaunchCallback#

    C_DesktopAppLaunchCallback              ,
    DesktopAppLaunchCallback                ,
    DesktopAppLaunchCallback_WithClosures   ,
    drop_closures_DesktopAppLaunchCallback  ,
    dynamic_DesktopAppLaunchCallback        ,
    genClosure_DesktopAppLaunchCallback     ,
    mk_DesktopAppLaunchCallback             ,
    noDesktopAppLaunchCallback              ,
    noDesktopAppLaunchCallback_WithClosures ,
    wrap_DesktopAppLaunchCallback           ,


-- ** FileMeasureProgressCallback #signal:FileMeasureProgressCallback#

    C_FileMeasureProgressCallback           ,
    FileMeasureProgressCallback             ,
    FileMeasureProgressCallback_WithClosures,
    drop_closures_FileMeasureProgressCallback,
    dynamic_FileMeasureProgressCallback     ,
    genClosure_FileMeasureProgressCallback  ,
    mk_FileMeasureProgressCallback          ,
    noFileMeasureProgressCallback           ,
    noFileMeasureProgressCallback_WithClosures,
    wrap_FileMeasureProgressCallback        ,


-- ** FileProgressCallback #signal:FileProgressCallback#

    C_FileProgressCallback                  ,
    FileProgressCallback                    ,
    FileProgressCallback_WithClosures       ,
    drop_closures_FileProgressCallback      ,
    dynamic_FileProgressCallback            ,
    genClosure_FileProgressCallback         ,
    mk_FileProgressCallback                 ,
    noFileProgressCallback                  ,
    noFileProgressCallback_WithClosures     ,
    wrap_FileProgressCallback               ,


-- ** FileReadMoreCallback #signal:FileReadMoreCallback#

    C_FileReadMoreCallback                  ,
    FileReadMoreCallback                    ,
    FileReadMoreCallback_WithClosures       ,
    drop_closures_FileReadMoreCallback      ,
    dynamic_FileReadMoreCallback            ,
    genClosure_FileReadMoreCallback         ,
    mk_FileReadMoreCallback                 ,
    noFileReadMoreCallback                  ,
    noFileReadMoreCallback_WithClosures     ,
    wrap_FileReadMoreCallback               ,


-- ** IOSchedulerJobFunc #signal:IOSchedulerJobFunc#

    C_IOSchedulerJobFunc                    ,
    IOSchedulerJobFunc                      ,
    IOSchedulerJobFunc_WithClosures         ,
    drop_closures_IOSchedulerJobFunc        ,
    dynamic_IOSchedulerJobFunc              ,
    genClosure_IOSchedulerJobFunc           ,
    mk_IOSchedulerJobFunc                   ,
    noIOSchedulerJobFunc                    ,
    noIOSchedulerJobFunc_WithClosures       ,
    wrap_IOSchedulerJobFunc                 ,


-- ** InputStreamClassCloseAsyncFieldCallback #signal:InputStreamClassCloseAsyncFieldCallback#

    C_InputStreamClassCloseAsyncFieldCallback,
    InputStreamClassCloseAsyncFieldCallback ,
    InputStreamClassCloseAsyncFieldCallback_WithClosures,
    drop_closures_InputStreamClassCloseAsyncFieldCallback,
    dynamic_InputStreamClassCloseAsyncFieldCallback,
    genClosure_InputStreamClassCloseAsyncFieldCallback,
    mk_InputStreamClassCloseAsyncFieldCallback,
    noInputStreamClassCloseAsyncFieldCallback,
    noInputStreamClassCloseAsyncFieldCallback_WithClosures,
    wrap_InputStreamClassCloseAsyncFieldCallback,


-- ** InputStreamClassCloseFinishFieldCallback #signal:InputStreamClassCloseFinishFieldCallback#

    C_InputStreamClassCloseFinishFieldCallback,
    InputStreamClassCloseFinishFieldCallback,
    dynamic_InputStreamClassCloseFinishFieldCallback,
    mk_InputStreamClassCloseFinishFieldCallback,
    noInputStreamClassCloseFinishFieldCallback,


-- ** InputStreamClassCloseFnFieldCallback #signal:InputStreamClassCloseFnFieldCallback#

    C_InputStreamClassCloseFnFieldCallback  ,
    InputStreamClassCloseFnFieldCallback    ,
    dynamic_InputStreamClassCloseFnFieldCallback,
    mk_InputStreamClassCloseFnFieldCallback ,
    noInputStreamClassCloseFnFieldCallback  ,


-- ** InputStreamClassReadAsyncFieldCallback #signal:InputStreamClassReadAsyncFieldCallback#

    C_InputStreamClassReadAsyncFieldCallback,
    InputStreamClassReadAsyncFieldCallback  ,
    InputStreamClassReadAsyncFieldCallback_WithClosures,
    drop_closures_InputStreamClassReadAsyncFieldCallback,
    dynamic_InputStreamClassReadAsyncFieldCallback,
    genClosure_InputStreamClassReadAsyncFieldCallback,
    mk_InputStreamClassReadAsyncFieldCallback,
    noInputStreamClassReadAsyncFieldCallback,
    noInputStreamClassReadAsyncFieldCallback_WithClosures,
    wrap_InputStreamClassReadAsyncFieldCallback,


-- ** InputStreamClassReadFinishFieldCallback #signal:InputStreamClassReadFinishFieldCallback#

    C_InputStreamClassReadFinishFieldCallback,
    InputStreamClassReadFinishFieldCallback ,
    dynamic_InputStreamClassReadFinishFieldCallback,
    mk_InputStreamClassReadFinishFieldCallback,
    noInputStreamClassReadFinishFieldCallback,


-- ** InputStreamClassReadFnFieldCallback #signal:InputStreamClassReadFnFieldCallback#

    C_InputStreamClassReadFnFieldCallback   ,
    InputStreamClassReadFnFieldCallback     ,
    dynamic_InputStreamClassReadFnFieldCallback,
    mk_InputStreamClassReadFnFieldCallback  ,
    noInputStreamClassReadFnFieldCallback   ,


-- ** InputStreamClassSkipAsyncFieldCallback #signal:InputStreamClassSkipAsyncFieldCallback#

    C_InputStreamClassSkipAsyncFieldCallback,
    InputStreamClassSkipAsyncFieldCallback  ,
    InputStreamClassSkipAsyncFieldCallback_WithClosures,
    drop_closures_InputStreamClassSkipAsyncFieldCallback,
    dynamic_InputStreamClassSkipAsyncFieldCallback,
    genClosure_InputStreamClassSkipAsyncFieldCallback,
    mk_InputStreamClassSkipAsyncFieldCallback,
    noInputStreamClassSkipAsyncFieldCallback,
    noInputStreamClassSkipAsyncFieldCallback_WithClosures,
    wrap_InputStreamClassSkipAsyncFieldCallback,


-- ** InputStreamClassSkipFieldCallback #signal:InputStreamClassSkipFieldCallback#

    C_InputStreamClassSkipFieldCallback     ,
    InputStreamClassSkipFieldCallback       ,
    dynamic_InputStreamClassSkipFieldCallback,
    mk_InputStreamClassSkipFieldCallback    ,
    noInputStreamClassSkipFieldCallback     ,


-- ** InputStreamClassSkipFinishFieldCallback #signal:InputStreamClassSkipFinishFieldCallback#

    C_InputStreamClassSkipFinishFieldCallback,
    InputStreamClassSkipFinishFieldCallback ,
    dynamic_InputStreamClassSkipFinishFieldCallback,
    mk_InputStreamClassSkipFinishFieldCallback,
    noInputStreamClassSkipFinishFieldCallback,


-- ** PollableSourceFunc #signal:PollableSourceFunc#

    C_PollableSourceFunc                    ,
    PollableSourceFunc                      ,
    PollableSourceFunc_WithClosures         ,
    drop_closures_PollableSourceFunc        ,
    dynamic_PollableSourceFunc              ,
    genClosure_PollableSourceFunc           ,
    mk_PollableSourceFunc                   ,
    noPollableSourceFunc                    ,
    noPollableSourceFunc_WithClosures       ,
    wrap_PollableSourceFunc                 ,


-- ** ReallocFunc #signal:ReallocFunc#

    C_ReallocFunc                           ,
    ReallocFunc                             ,
    dynamic_ReallocFunc                     ,
    genClosure_ReallocFunc                  ,
    mk_ReallocFunc                          ,
    noReallocFunc                           ,
    wrap_ReallocFunc                        ,


-- ** SeekableIfaceCanSeekFieldCallback #signal:SeekableIfaceCanSeekFieldCallback#

    C_SeekableIfaceCanSeekFieldCallback     ,
    SeekableIfaceCanSeekFieldCallback       ,
    dynamic_SeekableIfaceCanSeekFieldCallback,
    genClosure_SeekableIfaceCanSeekFieldCallback,
    mk_SeekableIfaceCanSeekFieldCallback    ,
    noSeekableIfaceCanSeekFieldCallback     ,
    wrap_SeekableIfaceCanSeekFieldCallback  ,


-- ** SeekableIfaceCanTruncateFieldCallback #signal:SeekableIfaceCanTruncateFieldCallback#

    C_SeekableIfaceCanTruncateFieldCallback ,
    SeekableIfaceCanTruncateFieldCallback   ,
    dynamic_SeekableIfaceCanTruncateFieldCallback,
    genClosure_SeekableIfaceCanTruncateFieldCallback,
    mk_SeekableIfaceCanTruncateFieldCallback,
    noSeekableIfaceCanTruncateFieldCallback ,
    wrap_SeekableIfaceCanTruncateFieldCallback,


-- ** SeekableIfaceSeekFieldCallback #signal:SeekableIfaceSeekFieldCallback#

    C_SeekableIfaceSeekFieldCallback        ,
    SeekableIfaceSeekFieldCallback          ,
    dynamic_SeekableIfaceSeekFieldCallback  ,
    mk_SeekableIfaceSeekFieldCallback       ,
    noSeekableIfaceSeekFieldCallback        ,


-- ** SeekableIfaceTellFieldCallback #signal:SeekableIfaceTellFieldCallback#

    C_SeekableIfaceTellFieldCallback        ,
    SeekableIfaceTellFieldCallback          ,
    dynamic_SeekableIfaceTellFieldCallback  ,
    genClosure_SeekableIfaceTellFieldCallback,
    mk_SeekableIfaceTellFieldCallback       ,
    noSeekableIfaceTellFieldCallback        ,
    wrap_SeekableIfaceTellFieldCallback     ,


-- ** SeekableIfaceTruncateFnFieldCallback #signal:SeekableIfaceTruncateFnFieldCallback#

    C_SeekableIfaceTruncateFnFieldCallback  ,
    SeekableIfaceTruncateFnFieldCallback    ,
    dynamic_SeekableIfaceTruncateFnFieldCallback,
    mk_SeekableIfaceTruncateFnFieldCallback ,
    noSeekableIfaceTruncateFnFieldCallback  ,


-- ** SettingsBindGetMapping #signal:SettingsBindGetMapping#

    C_SettingsBindGetMapping                ,
    SettingsBindGetMapping                  ,
    SettingsBindGetMapping_WithClosures     ,
    drop_closures_SettingsBindGetMapping    ,
    dynamic_SettingsBindGetMapping          ,
    genClosure_SettingsBindGetMapping       ,
    mk_SettingsBindGetMapping               ,
    noSettingsBindGetMapping                ,
    noSettingsBindGetMapping_WithClosures   ,
    wrap_SettingsBindGetMapping             ,


-- ** SettingsBindSetMapping #signal:SettingsBindSetMapping#

    C_SettingsBindSetMapping                ,
    SettingsBindSetMapping                  ,
    SettingsBindSetMapping_WithClosures     ,
    drop_closures_SettingsBindSetMapping    ,
    dynamic_SettingsBindSetMapping          ,
    genClosure_SettingsBindSetMapping       ,
    mk_SettingsBindSetMapping               ,
    noSettingsBindSetMapping                ,
    noSettingsBindSetMapping_WithClosures   ,
    wrap_SettingsBindSetMapping             ,


-- ** SettingsGetMapping #signal:SettingsGetMapping#

    C_SettingsGetMapping                    ,
    SettingsGetMapping                      ,
    SettingsGetMapping_WithClosures         ,
    drop_closures_SettingsGetMapping        ,
    dynamic_SettingsGetMapping              ,
    genClosure_SettingsGetMapping           ,
    mk_SettingsGetMapping                   ,
    noSettingsGetMapping                    ,
    noSettingsGetMapping_WithClosures       ,
    wrap_SettingsGetMapping                 ,


-- ** SimpleAsyncThreadFunc #signal:SimpleAsyncThreadFunc#

    C_SimpleAsyncThreadFunc                 ,
    SimpleAsyncThreadFunc                   ,
    dynamic_SimpleAsyncThreadFunc           ,
    genClosure_SimpleAsyncThreadFunc        ,
    mk_SimpleAsyncThreadFunc                ,
    noSimpleAsyncThreadFunc                 ,
    wrap_SimpleAsyncThreadFunc              ,


-- ** SocketSourceFunc #signal:SocketSourceFunc#

    C_SocketSourceFunc                      ,
    SocketSourceFunc                        ,
    SocketSourceFunc_WithClosures           ,
    drop_closures_SocketSourceFunc          ,
    dynamic_SocketSourceFunc                ,
    genClosure_SocketSourceFunc             ,
    mk_SocketSourceFunc                     ,
    noSocketSourceFunc                      ,
    noSocketSourceFunc_WithClosures         ,
    wrap_SocketSourceFunc                   ,


-- ** TaskThreadFunc #signal:TaskThreadFunc#

    C_TaskThreadFunc                        ,
    TaskThreadFunc                          ,
    dynamic_TaskThreadFunc                  ,
    genClosure_TaskThreadFunc               ,
    mk_TaskThreadFunc                       ,
    noTaskThreadFunc                        ,
    wrap_TaskThreadFunc                     ,


-- ** VfsFileLookupFunc #signal:VfsFileLookupFunc#

    C_VfsFileLookupFunc                     ,
    VfsFileLookupFunc                       ,
    VfsFileLookupFunc_WithClosures          ,
    drop_closures_VfsFileLookupFunc         ,
    dynamic_VfsFileLookupFunc               ,
    genClosure_VfsFileLookupFunc            ,
    mk_VfsFileLookupFunc                    ,
    noVfsFileLookupFunc                     ,
    noVfsFileLookupFunc_WithClosures        ,
    wrap_VfsFileLookupFunc                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Flags as GLib.Flags
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GLib.Structs.KeyFile as GLib.KeyFile
import qualified GI.GLib.Structs.MainContext as GLib.MainContext
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Action as Gio.Action
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AppInfo as Gio.AppInfo
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncInitable as Gio.AsyncInitable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusInterface as Gio.DBusInterface
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObject as Gio.DBusObject
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObjectManager as Gio.DBusObjectManager
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Drive as Gio.Drive
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Mount as Gio.Mount
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Volume as Gio.Volume
import {-# SOURCE #-} qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusAuthObserver as Gio.DBusAuthObserver
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMessage as Gio.DBusMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMethodInvocation as Gio.DBusMethodInvocation
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusObjectManagerClient as Gio.DBusObjectManagerClient
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusObjectProxy as Gio.DBusObjectProxy
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusProxy as Gio.DBusProxy
import {-# SOURCE #-} qualified GI.Gio.Objects.DesktopAppInfo as Gio.DesktopAppInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileEnumerator as Gio.FileEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.FileIOStream as Gio.FileIOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInfo as Gio.FileInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.FileInputStream as Gio.FileInputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.FileMonitor as Gio.FileMonitor
import {-# SOURCE #-} qualified GI.Gio.Objects.FileOutputStream as Gio.FileOutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuAttributeIter as Gio.MenuAttributeIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuLinkIter as Gio.MenuLinkIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import {-# SOURCE #-} qualified GI.Gio.Objects.MountOperation as Gio.MountOperation
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SimpleAction as Gio.SimpleAction
import {-# SOURCE #-} qualified GI.Gio.Objects.SimpleAsyncResult as Gio.SimpleAsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketControlMessage as Gio.SocketControlMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.Task as Gio.Task
import {-# SOURCE #-} qualified GI.Gio.Objects.UnixFDList as Gio.UnixFDList
import {-# SOURCE #-} qualified GI.Gio.Objects.Vfs as Gio.Vfs
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceVTable as Gio.DBusInterfaceVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusMethodInfo as Gio.DBusMethodInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusPropertyInfo as Gio.DBusPropertyInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSignalInfo as Gio.DBusSignalInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSubtreeVTable as Gio.DBusSubtreeVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfo as Gio.FileAttributeInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeInfoList as Gio.FileAttributeInfoList
import {-# SOURCE #-} qualified GI.Gio.Structs.FileAttributeMatcher as Gio.FileAttributeMatcher
import {-# SOURCE #-} qualified GI.Gio.Structs.IOSchedulerJob as Gio.IOSchedulerJob
import {-# SOURCE #-} qualified GI.Gio.Structs.InputMessage as Gio.InputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputVector as Gio.InputVector
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputMessage as Gio.OutputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GLib.Enums as GLib.Enums
import qualified GI.GLib.Flags as GLib.Flags
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Seekable as Gio.Seekable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMessage as Gio.DBusMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMethodInvocation as Gio.DBusMethodInvocation
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusObjectManagerClient as Gio.DBusObjectManagerClient
import {-# SOURCE #-} qualified GI.Gio.Objects.DesktopAppInfo as Gio.DesktopAppInfo
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.SimpleAction as Gio.SimpleAction
import {-# SOURCE #-} qualified GI.Gio.Objects.SimpleAsyncResult as Gio.SimpleAsyncResult
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.Task as Gio.Task
import {-# SOURCE #-} qualified GI.Gio.Objects.Vfs as Gio.Vfs
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceVTable as Gio.DBusInterfaceVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.IOSchedulerJob as Gio.IOSchedulerJob

#endif

-- callback VfsFileLookupFunc
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "Gio" , name = "File" })
  , returnMayBeNull = True
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText = Just "a #GFile for @identifier."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "vfs"
          , argType = TInterface Name { namespace = "Gio" , name = "Vfs" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GVfs" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "identifier"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the identifier to look up a #GFile for. This can either\n    be a URI or a parse name as returned by g_file_get_parse_name()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to the function, or %NULL"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This function type is used by g_vfs_register_uri_scheme() to make it\npossible for a client to associate a URI scheme to a different #GFile\nimplementation.\n\nThe client should return a reference to the new file that has been\ncreated for @uri, or %NULL to continue with the default implementation."
        , sinceVersion = Just "2.50"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_VfsFileLookupFunc =
    Ptr Gio.Vfs.Vfs ->
    CString ->
    Ptr () ->
    IO (Ptr Gio.File.File)

-- Args: [ Arg
--           { argCName = "vfs"
--           , argType = TInterface Name { namespace = "Gio" , name = "Vfs" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVfs" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "identifier"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the identifier to look up a #GFile for. This can either\n    be a URI or a parse name as returned by g_file_get_parse_name()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to the function, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_VfsFileLookupFunc :: FunPtr C_VfsFileLookupFunc -> C_VfsFileLookupFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_VfsFileLookupFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Vfs.IsVfs a) =>
    FunPtr C_VfsFileLookupFunc
    -> a
    -- ^ /@vfs@/: a t'GI.Gio.Objects.Vfs.Vfs'
    -> T.Text
    -- ^ /@identifier@/: the identifier to look up a t'GI.Gio.Interfaces.File.File' for. This can either
    --     be a URI or a parse name as returned by 'GI.Gio.Interfaces.File.fileGetParseName'
    -> Ptr ()
    -- ^ /@userData@/: user data passed to the function, or 'P.Nothing'
    -> m (Maybe Gio.File.File)
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.File.File' for /@identifier@/.
dynamic_VfsFileLookupFunc __funPtr vfs identifier userData = liftIO $ do
    vfs' <- unsafeManagedPtrCastPtr vfs
    identifier' <- textToCString identifier
    result <- (__dynamic_C_VfsFileLookupFunc __funPtr) vfs' identifier' userData
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.File.File) result'
        return result''
    touchManagedPtr vfs
    freeMem identifier'
    return maybeResult

-- | Generate a function pointer callable from C code, from a `C_VfsFileLookupFunc`.
foreign import ccall "wrapper"
    mk_VfsFileLookupFunc :: C_VfsFileLookupFunc -> IO (FunPtr C_VfsFileLookupFunc)

-- | This function type is used by 'GI.Gio.Objects.Vfs.vfsRegisterUriScheme' to make it
-- possible for a client to associate a URI scheme to a different t'GI.Gio.Interfaces.File.File'
-- implementation.
-- 
-- The client should return a reference to the new file that has been
-- created for /@uri@/, or 'P.Nothing' to continue with the default implementation.
-- 
-- /Since: 2.50/
type VfsFileLookupFunc =
    Gio.Vfs.Vfs
    -- ^ /@vfs@/: a t'GI.Gio.Objects.Vfs.Vfs'
    -> T.Text
    -- ^ /@identifier@/: the identifier to look up a t'GI.Gio.Interfaces.File.File' for. This can either
    --     be a URI or a parse name as returned by 'GI.Gio.Interfaces.File.fileGetParseName'
    -> IO (Maybe Gio.File.File)
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.File.File' for /@identifier@/.

-- | A convenience synonym for @`Nothing` :: `Maybe` `VfsFileLookupFunc`@.
noVfsFileLookupFunc :: Maybe VfsFileLookupFunc
noVfsFileLookupFunc = Nothing

-- | This function type is used by 'GI.Gio.Objects.Vfs.vfsRegisterUriScheme' to make it
-- possible for a client to associate a URI scheme to a different t'GI.Gio.Interfaces.File.File'
-- implementation.
-- 
-- The client should return a reference to the new file that has been
-- created for /@uri@/, or 'P.Nothing' to continue with the default implementation.
-- 
-- /Since: 2.50/
type VfsFileLookupFunc_WithClosures =
    Gio.Vfs.Vfs
    -- ^ /@vfs@/: a t'GI.Gio.Objects.Vfs.Vfs'
    -> T.Text
    -- ^ /@identifier@/: the identifier to look up a t'GI.Gio.Interfaces.File.File' for. This can either
    --     be a URI or a parse name as returned by 'GI.Gio.Interfaces.File.fileGetParseName'
    -> Ptr ()
    -- ^ /@userData@/: user data passed to the function, or 'P.Nothing'
    -> IO (Maybe Gio.File.File)
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.File.File' for /@identifier@/.

-- | A convenience synonym for @`Nothing` :: `Maybe` `VfsFileLookupFunc_WithClosures`@.
noVfsFileLookupFunc_WithClosures :: Maybe VfsFileLookupFunc_WithClosures
noVfsFileLookupFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_VfsFileLookupFunc :: VfsFileLookupFunc -> VfsFileLookupFunc_WithClosures
drop_closures_VfsFileLookupFunc _f vfs identifier _ = _f vfs identifier

-- | Wrap the callback into a `GClosure`.
genClosure_VfsFileLookupFunc :: MonadIO m => VfsFileLookupFunc -> m (GClosure C_VfsFileLookupFunc)
genClosure_VfsFileLookupFunc cb = liftIO $ do
    let cb' = drop_closures_VfsFileLookupFunc cb
    let cb'' = wrap_VfsFileLookupFunc Nothing cb'
    mk_VfsFileLookupFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `VfsFileLookupFunc` into a `C_VfsFileLookupFunc`.
wrap_VfsFileLookupFunc :: 
    Maybe (Ptr (FunPtr C_VfsFileLookupFunc)) ->
    VfsFileLookupFunc_WithClosures ->
    C_VfsFileLookupFunc
wrap_VfsFileLookupFunc gi'funptrptr gi'cb vfs identifier userData = do
    vfs' <- (newObject Gio.Vfs.Vfs) vfs
    identifier' <- cstringToText identifier
    result <- gi'cb  vfs' identifier' userData
    maybeReleaseFunPtr gi'funptrptr
    maybeM FP.nullPtr result $ \result' -> do
        result'' <- B.ManagedPtr.disownObject result'
        return result''


-- callback TaskThreadFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "task"
          , argType = TInterface Name { namespace = "Gio" , name = "Task" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GTask" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "source_object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "@task's source object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "task_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@task's task data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "@task's #GCancellable, or %NULL"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The prototype for a task function to be run in a thread via\ng_task_run_in_thread() or g_task_run_in_thread_sync().\n\nIf the return-on-cancel flag is set on @task, and @cancellable gets\ncancelled, then the #GTask will be completed immediately (as though\ng_task_return_error_if_cancelled() had been called), without\nwaiting for the task function to complete. However, the task\nfunction will continue running in its thread in the background. The\nfunction therefore needs to be careful about how it uses\nexternally-visible state in this case. See\ng_task_set_return_on_cancel() for more details.\n\nOther than in that case, @task will be completed when the\n#GTaskThreadFunc returns, not when it calls a\n`g_task_return_` function."
        , sinceVersion = Just "2.36"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TaskThreadFunc =
    Ptr Gio.Task.Task ->
    Ptr GObject.Object.Object ->
    Ptr () ->
    Ptr Gio.Cancellable.Cancellable ->
    IO ()

-- Args: [ Arg
--           { argCName = "task"
--           , argType = TInterface Name { namespace = "Gio" , name = "Task" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GTask" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@task's source object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "task_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@task's task data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "@task's #GCancellable, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TaskThreadFunc :: FunPtr C_TaskThreadFunc -> C_TaskThreadFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TaskThreadFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Task.IsTask a, GObject.Object.IsObject b, Gio.Cancellable.IsCancellable c) =>
    FunPtr C_TaskThreadFunc
    -> a
    -- ^ /@task@/: the t'GI.Gio.Objects.Task.Task'
    -> b
    -- ^ /@sourceObject@/: /@task@/\'s source object
    -> Ptr ()
    -- ^ /@taskData@/: /@task@/\'s task data
    -> Maybe (c)
    -- ^ /@cancellable@/: /@task@/\'s t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> m ()
dynamic_TaskThreadFunc __funPtr task sourceObject taskData cancellable = liftIO $ do
    task' <- unsafeManagedPtrCastPtr task
    sourceObject' <- unsafeManagedPtrCastPtr sourceObject
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    (__dynamic_C_TaskThreadFunc __funPtr) task' sourceObject' taskData maybeCancellable
    touchManagedPtr task
    touchManagedPtr sourceObject
    whenJust cancellable touchManagedPtr
    return ()

-- | Generate a function pointer callable from C code, from a `C_TaskThreadFunc`.
foreign import ccall "wrapper"
    mk_TaskThreadFunc :: C_TaskThreadFunc -> IO (FunPtr C_TaskThreadFunc)

-- | The prototype for a task function to be run in a thread via
-- 'GI.Gio.Objects.Task.taskRunInThread' or 'GI.Gio.Objects.Task.taskRunInThreadSync'.
-- 
-- If the return-on-cancel flag is set on /@task@/, and /@cancellable@/ gets
-- cancelled, then the t'GI.Gio.Objects.Task.Task' will be completed immediately (as though
-- 'GI.Gio.Objects.Task.taskReturnErrorIfCancelled' had been called), without
-- waiting for the task function to complete. However, the task
-- function will continue running in its thread in the background. The
-- function therefore needs to be careful about how it uses
-- externally-visible state in this case. See
-- 'GI.Gio.Objects.Task.taskSetReturnOnCancel' for more details.
-- 
-- Other than in that case, /@task@/ will be completed when the
-- t'GI.Gio.Callbacks.TaskThreadFunc' returns, not when it calls a
-- @g_task_return_@ function.
-- 
-- /Since: 2.36/
type TaskThreadFunc =
    Gio.Task.Task
    -- ^ /@task@/: the t'GI.Gio.Objects.Task.Task'
    -> GObject.Object.Object
    -- ^ /@sourceObject@/: /@task@/\'s source object
    -> Ptr ()
    -- ^ /@taskData@/: /@task@/\'s task data
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: /@task@/\'s t'GI.Gio.Objects.Cancellable.Cancellable', or 'P.Nothing'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TaskThreadFunc`@.
noTaskThreadFunc :: Maybe TaskThreadFunc
noTaskThreadFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TaskThreadFunc :: MonadIO m => TaskThreadFunc -> m (GClosure C_TaskThreadFunc)
genClosure_TaskThreadFunc cb = liftIO $ do
    let cb' = wrap_TaskThreadFunc Nothing cb
    mk_TaskThreadFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TaskThreadFunc` into a `C_TaskThreadFunc`.
wrap_TaskThreadFunc :: 
    Maybe (Ptr (FunPtr C_TaskThreadFunc)) ->
    TaskThreadFunc ->
    C_TaskThreadFunc
wrap_TaskThreadFunc gi'funptrptr gi'cb task sourceObject taskData cancellable = do
    task' <- (newObject Gio.Task.Task) task
    sourceObject' <- (newObject GObject.Object.Object) sourceObject
    maybeCancellable <-
        if cancellable == FP.nullPtr
        then return Nothing
        else do
            cancellable' <- (newObject Gio.Cancellable.Cancellable) cancellable
            return $ Just cancellable'
    gi'cb  task' sourceObject' taskData maybeCancellable
    maybeReleaseFunPtr gi'funptrptr


-- callback SocketSourceFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "it should return %FALSE if the source should be removed."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "socket"
          , argType = TInterface Name { namespace = "Gio" , name = "Socket" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GSocket" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "condition"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOCondition" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the current condition at the source fired."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed in by the user."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This is the function type of the callback used for the #GSource\nreturned by g_socket_create_source()."
        , sinceVersion = Just "2.22"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SocketSourceFunc =
    Ptr Gio.Socket.Socket ->
    CUInt ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "socket"
--           , argType = TInterface Name { namespace = "Gio" , name = "Socket" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GSocket" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "condition"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the current condition at the source fired."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed in by the user."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SocketSourceFunc :: FunPtr C_SocketSourceFunc -> C_SocketSourceFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SocketSourceFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Socket.IsSocket a) =>
    FunPtr C_SocketSourceFunc
    -> a
    -- ^ /@socket@/: the t'GI.Gio.Objects.Socket.Socket'
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the current condition at the source fired.
    -> Ptr ()
    -- ^ /@data@/: data passed in by the user.
    -> m Bool
    -- ^ __Returns:__ it should return 'P.False' if the source should be removed.
dynamic_SocketSourceFunc __funPtr socket condition data_ = liftIO $ do
    socket' <- unsafeManagedPtrCastPtr socket
    let condition' = gflagsToWord condition
    result <- (__dynamic_C_SocketSourceFunc __funPtr) socket' condition' data_
    let result' = (/= 0) result
    touchManagedPtr socket
    return result'

-- | Generate a function pointer callable from C code, from a `C_SocketSourceFunc`.
foreign import ccall "wrapper"
    mk_SocketSourceFunc :: C_SocketSourceFunc -> IO (FunPtr C_SocketSourceFunc)

-- | This is the function type of the callback used for the t'GI.GLib.Structs.Source.Source'
-- returned by @/g_socket_create_source()/@.
-- 
-- /Since: 2.22/
type SocketSourceFunc =
    Gio.Socket.Socket
    -- ^ /@socket@/: the t'GI.Gio.Objects.Socket.Socket'
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the current condition at the source fired.
    -> IO Bool
    -- ^ __Returns:__ it should return 'P.False' if the source should be removed.

-- | A convenience synonym for @`Nothing` :: `Maybe` `SocketSourceFunc`@.
noSocketSourceFunc :: Maybe SocketSourceFunc
noSocketSourceFunc = Nothing

-- | This is the function type of the callback used for the t'GI.GLib.Structs.Source.Source'
-- returned by @/g_socket_create_source()/@.
-- 
-- /Since: 2.22/
type SocketSourceFunc_WithClosures =
    Gio.Socket.Socket
    -- ^ /@socket@/: the t'GI.Gio.Objects.Socket.Socket'
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the current condition at the source fired.
    -> Ptr ()
    -- ^ /@data@/: data passed in by the user.
    -> IO Bool
    -- ^ __Returns:__ it should return 'P.False' if the source should be removed.

-- | A convenience synonym for @`Nothing` :: `Maybe` `SocketSourceFunc_WithClosures`@.
noSocketSourceFunc_WithClosures :: Maybe SocketSourceFunc_WithClosures
noSocketSourceFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_SocketSourceFunc :: SocketSourceFunc -> SocketSourceFunc_WithClosures
drop_closures_SocketSourceFunc _f socket condition _ = _f socket condition

-- | Wrap the callback into a `GClosure`.
genClosure_SocketSourceFunc :: MonadIO m => SocketSourceFunc -> m (GClosure C_SocketSourceFunc)
genClosure_SocketSourceFunc cb = liftIO $ do
    let cb' = drop_closures_SocketSourceFunc cb
    let cb'' = wrap_SocketSourceFunc Nothing cb'
    mk_SocketSourceFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `SocketSourceFunc` into a `C_SocketSourceFunc`.
wrap_SocketSourceFunc :: 
    Maybe (Ptr (FunPtr C_SocketSourceFunc)) ->
    SocketSourceFunc_WithClosures ->
    C_SocketSourceFunc
wrap_SocketSourceFunc gi'funptrptr gi'cb socket condition data_ = do
    socket' <- (newObject Gio.Socket.Socket) socket
    let condition' = wordToGFlags condition
    result <- gi'cb  socket' condition' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback SimpleAsyncThreadFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "res"
          , argType =
              TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GSimpleAsyncResult."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GObject." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "optional #GCancellable object, %NULL to ignore."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Simple thread function that runs an asynchronous operation and\nchecks for cancellation."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SimpleAsyncThreadFunc =
    Ptr Gio.SimpleAsyncResult.SimpleAsyncResult ->
    Ptr GObject.Object.Object ->
    Ptr Gio.Cancellable.Cancellable ->
    IO ()

-- Args: [ Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAsyncResult."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObject." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SimpleAsyncThreadFunc :: FunPtr C_SimpleAsyncThreadFunc -> C_SimpleAsyncThreadFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SimpleAsyncThreadFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.SimpleAsyncResult.IsSimpleAsyncResult a, GObject.Object.IsObject b, Gio.Cancellable.IsCancellable c) =>
    FunPtr C_SimpleAsyncThreadFunc
    -> a
    -- ^ /@res@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> b
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object'.
    -> Maybe (c)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
dynamic_SimpleAsyncThreadFunc __funPtr res object cancellable = liftIO $ do
    res' <- unsafeManagedPtrCastPtr res
    object' <- unsafeManagedPtrCastPtr object
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    (__dynamic_C_SimpleAsyncThreadFunc __funPtr) res' object' maybeCancellable
    touchManagedPtr res
    touchManagedPtr object
    whenJust cancellable touchManagedPtr
    return ()

-- | Generate a function pointer callable from C code, from a `C_SimpleAsyncThreadFunc`.
foreign import ccall "wrapper"
    mk_SimpleAsyncThreadFunc :: C_SimpleAsyncThreadFunc -> IO (FunPtr C_SimpleAsyncThreadFunc)

-- | Simple thread function that runs an asynchronous operation and
-- checks for cancellation.
type SimpleAsyncThreadFunc =
    Gio.SimpleAsyncResult.SimpleAsyncResult
    -- ^ /@res@/: a t'GI.Gio.Objects.SimpleAsyncResult.SimpleAsyncResult'.
    -> GObject.Object.Object
    -- ^ /@object@/: a t'GI.GObject.Objects.Object.Object'.
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SimpleAsyncThreadFunc`@.
noSimpleAsyncThreadFunc :: Maybe SimpleAsyncThreadFunc
noSimpleAsyncThreadFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SimpleAsyncThreadFunc :: MonadIO m => SimpleAsyncThreadFunc -> m (GClosure C_SimpleAsyncThreadFunc)
genClosure_SimpleAsyncThreadFunc cb = liftIO $ do
    let cb' = wrap_SimpleAsyncThreadFunc Nothing cb
    mk_SimpleAsyncThreadFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `SimpleAsyncThreadFunc` into a `C_SimpleAsyncThreadFunc`.
wrap_SimpleAsyncThreadFunc :: 
    Maybe (Ptr (FunPtr C_SimpleAsyncThreadFunc)) ->
    SimpleAsyncThreadFunc ->
    C_SimpleAsyncThreadFunc
wrap_SimpleAsyncThreadFunc gi'funptrptr gi'cb res object cancellable = do
    res' <- (newObject Gio.SimpleAsyncResult.SimpleAsyncResult) res
    object' <- (newObject GObject.Object.Object) object
    maybeCancellable <-
        if cancellable == FP.nullPtr
        then return Nothing
        else do
            cancellable' <- (newObject Gio.Cancellable.Cancellable) cancellable
            return $ Just cancellable'
    gi'cb  res' object' maybeCancellable
    maybeReleaseFunPtr gi'funptrptr


-- callback SettingsGetMapping
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "true if the conversion succeeded, false in case of an error"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "value"
          , argType = TVariant
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "variant to map to the application value"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "result"
          , argType = TBasicType TPtr
          , direction = DirectionOut
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the result of the mapping"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the user data that was passed to\n  [method@Gio.Settings.get_mapped]"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the function that is used to convert from a value stored\nin a [class@Gio.Settings] to a value that is useful to the application.\n\nIf the value is successfully mapped, the result should be stored at\n@result and true returned.  If mapping fails (for example, if @value\nis not in the right format) then false should be returned.\n\nIf @value is `NULL` then it means that the mapping function is being\ngiven a \8216last chance\8217 to successfully return a valid value.  True\nmust be returned in this case."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SettingsGetMapping =
    Ptr GVariant ->
    Ptr (Ptr ()) ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "variant to map to the application value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType = TBasicType TPtr
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the result of the mapping"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the user data that was passed to\n  [method@Gio.Settings.get_mapped]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SettingsGetMapping :: FunPtr C_SettingsGetMapping -> C_SettingsGetMapping

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SettingsGetMapping ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SettingsGetMapping
    -> Maybe (GVariant)
    -- ^ /@value@/: variant to map to the application value
    -> Ptr ()
    -- ^ /@userData@/: the user data that was passed to
    --   'GI.Gio.Objects.Settings.settingsGetMapped'
    -> m ((Bool, Ptr ()))
    -- ^ __Returns:__ true if the conversion succeeded, false in case of an error
dynamic_SettingsGetMapping __funPtr value userData = liftIO $ do
    maybeValue <- case value of
        Nothing -> return FP.nullPtr
        Just jValue -> do
            jValue' <- unsafeManagedPtrGetPtr jValue
            return jValue'
    result_ <- callocMem :: IO (Ptr (Ptr ()))
    result <- (__dynamic_C_SettingsGetMapping __funPtr) maybeValue result_ userData
    let result' = (/= 0) result
    result_' <- peek result_
    whenJust value touchManagedPtr
    freeMem result_
    return (result', result_')

-- | Generate a function pointer callable from C code, from a `C_SettingsGetMapping`.
foreign import ccall "wrapper"
    mk_SettingsGetMapping :: C_SettingsGetMapping -> IO (FunPtr C_SettingsGetMapping)

-- | The type of the function that is used to convert from a value stored
-- in a t'GI.Gio.Objects.Settings.Settings' to a value that is useful to the application.
-- 
-- If the value is successfully mapped, the result should be stored at
-- /@result@/ and true returned.  If mapping fails (for example, if /@value@/
-- is not in the right format) then false should be returned.
-- 
-- If /@value@/ is @NULL@ then it means that the mapping function is being
-- given a ‘last chance’ to successfully return a valid value.  True
-- must be returned in this case.
type SettingsGetMapping =
    Maybe GVariant
    -- ^ /@value@/: variant to map to the application value
    -> IO ((Bool, Ptr ()))
    -- ^ __Returns:__ true if the conversion succeeded, false in case of an error

-- | A convenience synonym for @`Nothing` :: `Maybe` `SettingsGetMapping`@.
noSettingsGetMapping :: Maybe SettingsGetMapping
noSettingsGetMapping = Nothing

-- | The type of the function that is used to convert from a value stored
-- in a t'GI.Gio.Objects.Settings.Settings' to a value that is useful to the application.
-- 
-- If the value is successfully mapped, the result should be stored at
-- /@result@/ and true returned.  If mapping fails (for example, if /@value@/
-- is not in the right format) then false should be returned.
-- 
-- If /@value@/ is @NULL@ then it means that the mapping function is being
-- given a ‘last chance’ to successfully return a valid value.  True
-- must be returned in this case.
type SettingsGetMapping_WithClosures =
    Maybe GVariant
    -- ^ /@value@/: variant to map to the application value
    -> Ptr ()
    -- ^ /@userData@/: the user data that was passed to
    --   'GI.Gio.Objects.Settings.settingsGetMapped'
    -> IO ((Bool, Ptr ()))
    -- ^ __Returns:__ true if the conversion succeeded, false in case of an error

-- | A convenience synonym for @`Nothing` :: `Maybe` `SettingsGetMapping_WithClosures`@.
noSettingsGetMapping_WithClosures :: Maybe SettingsGetMapping_WithClosures
noSettingsGetMapping_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_SettingsGetMapping :: SettingsGetMapping -> SettingsGetMapping_WithClosures
drop_closures_SettingsGetMapping _f value _ = _f value

-- | Wrap the callback into a `GClosure`.
genClosure_SettingsGetMapping :: MonadIO m => SettingsGetMapping -> m (GClosure C_SettingsGetMapping)
genClosure_SettingsGetMapping cb = liftIO $ do
    let cb' = drop_closures_SettingsGetMapping cb
    let cb'' = wrap_SettingsGetMapping Nothing cb'
    mk_SettingsGetMapping cb'' >>= B.GClosure.newGClosure


-- | Wrap a `SettingsGetMapping` into a `C_SettingsGetMapping`.
wrap_SettingsGetMapping :: 
    Maybe (Ptr (FunPtr C_SettingsGetMapping)) ->
    SettingsGetMapping_WithClosures ->
    C_SettingsGetMapping
wrap_SettingsGetMapping gi'funptrptr gi'cb value result_ userData = do
    maybeValue <-
        if value == FP.nullPtr
        then return Nothing
        else do
            value' <- B.GVariant.newGVariantFromPtr value
            return $ Just value'
    (result, outresult_) <- gi'cb  maybeValue userData
    poke result_ outresult_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback SettingsBindSetMapping
{- Callable
  { returnType = Just TVariant
  , returnMayBeNull = True
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "a new [struct@GLib.Variant] holding the data from @value,\n  or `NULL` in case of an error"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the property value to map"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "expected_type"
          , argType =
              TInterface Name { namespace = "GLib" , name = "VariantType" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "expected type of the result"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data that was specified when the binding was created"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type for the function that is used to convert an object property\nvalue to a [struct@GLib.Variant] for storing it in [class@Gio.Settings]."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SettingsBindSetMapping =
    Ptr GValue ->
    Ptr GLib.VariantType.VariantType ->
    Ptr () ->
    IO (Ptr GVariant)

-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the property value to map"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expected_type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "expected type of the result"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data that was specified when the binding was created"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SettingsBindSetMapping :: FunPtr C_SettingsBindSetMapping -> C_SettingsBindSetMapping

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SettingsBindSetMapping ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SettingsBindSetMapping
    -> GValue
    -- ^ /@value@/: the property value to map
    -> GLib.VariantType.VariantType
    -- ^ /@expectedType@/: expected type of the result
    -> Ptr ()
    -- ^ /@userData@/: user data that was specified when the binding was created
    -> m (Maybe GVariant)
    -- ^ __Returns:__ a new [struct/@gLib@/.Variant] holding the data from /@value@/,
    --   or @NULL@ in case of an error
dynamic_SettingsBindSetMapping __funPtr value expectedType userData = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    expectedType' <- unsafeManagedPtrGetPtr expectedType
    result <- (__dynamic_C_SettingsBindSetMapping __funPtr) value' expectedType' userData
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- B.GVariant.wrapGVariantPtr result'
        return result''
    touchManagedPtr value
    touchManagedPtr expectedType
    return maybeResult

-- | Generate a function pointer callable from C code, from a `C_SettingsBindSetMapping`.
foreign import ccall "wrapper"
    mk_SettingsBindSetMapping :: C_SettingsBindSetMapping -> IO (FunPtr C_SettingsBindSetMapping)

-- | The type for the function that is used to convert an object property
-- value to a [struct/@gLib@/.Variant] for storing it in t'GI.Gio.Objects.Settings.Settings'.
type SettingsBindSetMapping =
    GValue
    -- ^ /@value@/: the property value to map
    -> GLib.VariantType.VariantType
    -- ^ /@expectedType@/: expected type of the result
    -> IO (Maybe GVariant)
    -- ^ __Returns:__ a new [struct/@gLib@/.Variant] holding the data from /@value@/,
    --   or @NULL@ in case of an error

-- | A convenience synonym for @`Nothing` :: `Maybe` `SettingsBindSetMapping`@.
noSettingsBindSetMapping :: Maybe SettingsBindSetMapping
noSettingsBindSetMapping = Nothing

-- | The type for the function that is used to convert an object property
-- value to a [struct/@gLib@/.Variant] for storing it in t'GI.Gio.Objects.Settings.Settings'.
type SettingsBindSetMapping_WithClosures =
    GValue
    -- ^ /@value@/: the property value to map
    -> GLib.VariantType.VariantType
    -- ^ /@expectedType@/: expected type of the result
    -> Ptr ()
    -- ^ /@userData@/: user data that was specified when the binding was created
    -> IO (Maybe GVariant)
    -- ^ __Returns:__ a new [struct/@gLib@/.Variant] holding the data from /@value@/,
    --   or @NULL@ in case of an error

-- | A convenience synonym for @`Nothing` :: `Maybe` `SettingsBindSetMapping_WithClosures`@.
noSettingsBindSetMapping_WithClosures :: Maybe SettingsBindSetMapping_WithClosures
noSettingsBindSetMapping_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_SettingsBindSetMapping :: SettingsBindSetMapping -> SettingsBindSetMapping_WithClosures
drop_closures_SettingsBindSetMapping _f value expectedType _ = _f value expectedType

-- | Wrap the callback into a `GClosure`.
genClosure_SettingsBindSetMapping :: MonadIO m => SettingsBindSetMapping -> m (GClosure C_SettingsBindSetMapping)
genClosure_SettingsBindSetMapping cb = liftIO $ do
    let cb' = drop_closures_SettingsBindSetMapping cb
    let cb'' = wrap_SettingsBindSetMapping Nothing cb'
    mk_SettingsBindSetMapping cb'' >>= B.GClosure.newGClosure


-- | Wrap a `SettingsBindSetMapping` into a `C_SettingsBindSetMapping`.
wrap_SettingsBindSetMapping :: 
    Maybe (Ptr (FunPtr C_SettingsBindSetMapping)) ->
    SettingsBindSetMapping_WithClosures ->
    C_SettingsBindSetMapping
wrap_SettingsBindSetMapping gi'funptrptr gi'cb value expectedType userData = do
    value' <- B.GValue.newGValueFromPtr value
    B.ManagedPtr.withTransient  expectedType $ \expectedType' -> do
        result <- gi'cb  value' expectedType' userData
        maybeReleaseFunPtr gi'funptrptr
        maybeM FP.nullPtr result $ \result' -> do
            result'' <- B.GVariant.disownGVariant result'
            return result''


-- callback SettingsBindGetMapping
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "true if the conversion succeeded, false in case of an error"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "value"
          , argType = TGValue
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "return location for the property value"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "variant"
          , argType = TVariant
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "variant to map to the property value"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data that was specified when the binding was created"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type for the function that is used to convert from [class@Gio.Settings]\nto an object property.\n\nThe @value is already initialized to hold values of the appropriate type."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SettingsBindGetMapping =
    Ptr GValue ->
    Ptr GVariant ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the property value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "variant"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "variant to map to the property value"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data that was specified when the binding was created"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SettingsBindGetMapping :: FunPtr C_SettingsBindGetMapping -> C_SettingsBindGetMapping

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SettingsBindGetMapping ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SettingsBindGetMapping
    -> GValue
    -- ^ /@value@/: return location for the property value
    -> GVariant
    -- ^ /@variant@/: variant to map to the property value
    -> Ptr ()
    -- ^ /@userData@/: user data that was specified when the binding was created
    -> m Bool
    -- ^ __Returns:__ true if the conversion succeeded, false in case of an error
dynamic_SettingsBindGetMapping __funPtr value variant userData = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    variant' <- unsafeManagedPtrGetPtr variant
    result <- (__dynamic_C_SettingsBindGetMapping __funPtr) value' variant' userData
    let result' = (/= 0) result
    touchManagedPtr value
    touchManagedPtr variant
    return result'

-- | Generate a function pointer callable from C code, from a `C_SettingsBindGetMapping`.
foreign import ccall "wrapper"
    mk_SettingsBindGetMapping :: C_SettingsBindGetMapping -> IO (FunPtr C_SettingsBindGetMapping)

-- | The type for the function that is used to convert from t'GI.Gio.Objects.Settings.Settings'
-- to an object property.
-- 
-- The /@value@/ is already initialized to hold values of the appropriate type.
type SettingsBindGetMapping =
    GValue
    -- ^ /@value@/: return location for the property value
    -> GVariant
    -- ^ /@variant@/: variant to map to the property value
    -> IO Bool
    -- ^ __Returns:__ true if the conversion succeeded, false in case of an error

-- | A convenience synonym for @`Nothing` :: `Maybe` `SettingsBindGetMapping`@.
noSettingsBindGetMapping :: Maybe SettingsBindGetMapping
noSettingsBindGetMapping = Nothing

-- | The type for the function that is used to convert from t'GI.Gio.Objects.Settings.Settings'
-- to an object property.
-- 
-- The /@value@/ is already initialized to hold values of the appropriate type.
type SettingsBindGetMapping_WithClosures =
    GValue
    -- ^ /@value@/: return location for the property value
    -> GVariant
    -- ^ /@variant@/: variant to map to the property value
    -> Ptr ()
    -- ^ /@userData@/: user data that was specified when the binding was created
    -> IO Bool
    -- ^ __Returns:__ true if the conversion succeeded, false in case of an error

-- | A convenience synonym for @`Nothing` :: `Maybe` `SettingsBindGetMapping_WithClosures`@.
noSettingsBindGetMapping_WithClosures :: Maybe SettingsBindGetMapping_WithClosures
noSettingsBindGetMapping_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_SettingsBindGetMapping :: SettingsBindGetMapping -> SettingsBindGetMapping_WithClosures
drop_closures_SettingsBindGetMapping _f value variant _ = _f value variant

-- | Wrap the callback into a `GClosure`.
genClosure_SettingsBindGetMapping :: MonadIO m => SettingsBindGetMapping -> m (GClosure C_SettingsBindGetMapping)
genClosure_SettingsBindGetMapping cb = liftIO $ do
    let cb' = drop_closures_SettingsBindGetMapping cb
    let cb'' = wrap_SettingsBindGetMapping Nothing cb'
    mk_SettingsBindGetMapping cb'' >>= B.GClosure.newGClosure


-- | Wrap a `SettingsBindGetMapping` into a `C_SettingsBindGetMapping`.
wrap_SettingsBindGetMapping :: 
    Maybe (Ptr (FunPtr C_SettingsBindGetMapping)) ->
    SettingsBindGetMapping_WithClosures ->
    C_SettingsBindGetMapping
wrap_SettingsBindGetMapping gi'funptrptr gi'cb value variant userData = do
    value' <- B.GValue.newGValueFromPtr value
    variant' <- B.GVariant.newGVariantFromPtr variant
    result <- gi'cb  value' variant' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback SeekableIfaceTruncateFnFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE if successful. If an error\n    has occurred, this function will return %FALSE and set @error\n    appropriately if present."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "seekable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Seekable" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GSeekable." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "offset"
          , argType = TBasicType TInt64
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "new length for @seekable, in bytes."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "optional #GCancellable object, %NULL to ignore."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SeekableIfaceTruncateFnFieldCallback =
    Ptr Gio.Seekable.Seekable ->
    Int64 ->
    Ptr Gio.Cancellable.Cancellable ->
    Ptr (Ptr GError) ->
    IO CInt

-- Args: [ Arg
--           { argCName = "seekable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Seekable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSeekable." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new length for @seekable, in bytes."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SeekableIfaceTruncateFnFieldCallback :: FunPtr C_SeekableIfaceTruncateFnFieldCallback -> C_SeekableIfaceTruncateFnFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SeekableIfaceTruncateFnFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Seekable.IsSeekable a, Gio.Cancellable.IsCancellable b) =>
    FunPtr C_SeekableIfaceTruncateFnFieldCallback
    -> a
    -- ^ /@seekable@/: a t'GI.Gio.Interfaces.Seekable.Seekable'.
    -> Int64
    -- ^ /@offset@/: new length for /@seekable@/, in bytes.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_SeekableIfaceTruncateFnFieldCallback __funPtr seekable offset cancellable = liftIO $ do
    seekable' <- unsafeManagedPtrCastPtr seekable
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ (__dynamic_C_SeekableIfaceTruncateFnFieldCallback __funPtr) seekable' offset maybeCancellable
        touchManagedPtr seekable
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_SeekableIfaceTruncateFnFieldCallback`.
foreign import ccall "wrapper"
    mk_SeekableIfaceTruncateFnFieldCallback :: C_SeekableIfaceTruncateFnFieldCallback -> IO (FunPtr C_SeekableIfaceTruncateFnFieldCallback)

-- | /No description available in the introspection data./
type SeekableIfaceTruncateFnFieldCallback =
    Gio.Seekable.Seekable
    -- ^ /@seekable@/: a t'GI.Gio.Interfaces.Seekable.Seekable'.
    -> Int64
    -- ^ /@offset@/: new length for /@seekable@/, in bytes.
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> IO ()
    -- ^ __Returns:__ 'P.True' if successful. If an error
    --     has occurred, this function will return 'P.False' and set /@error@/
    --     appropriately if present. /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `SeekableIfaceTruncateFnFieldCallback`@.
noSeekableIfaceTruncateFnFieldCallback :: Maybe SeekableIfaceTruncateFnFieldCallback
noSeekableIfaceTruncateFnFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback SeekableIfaceTellFieldCallback
{- Callable
  { returnType = Just (TBasicType TInt64)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "the (positive or zero) offset from the beginning of the\nbuffer, zero if the target is not seekable."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "seekable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Seekable" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GSeekable." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SeekableIfaceTellFieldCallback =
    Ptr Gio.Seekable.Seekable ->
    IO Int64

-- Args: [ Arg
--           { argCName = "seekable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Seekable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSeekable." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt64)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SeekableIfaceTellFieldCallback :: FunPtr C_SeekableIfaceTellFieldCallback -> C_SeekableIfaceTellFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SeekableIfaceTellFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Seekable.IsSeekable a) =>
    FunPtr C_SeekableIfaceTellFieldCallback
    -> a
    -- ^ /@seekable@/: a t'GI.Gio.Interfaces.Seekable.Seekable'.
    -> m Int64
    -- ^ __Returns:__ the (positive or zero) offset from the beginning of the
    -- buffer, zero if the target is not seekable.
dynamic_SeekableIfaceTellFieldCallback __funPtr seekable = liftIO $ do
    seekable' <- unsafeManagedPtrCastPtr seekable
    result <- (__dynamic_C_SeekableIfaceTellFieldCallback __funPtr) seekable'
    touchManagedPtr seekable
    return result

-- | Generate a function pointer callable from C code, from a `C_SeekableIfaceTellFieldCallback`.
foreign import ccall "wrapper"
    mk_SeekableIfaceTellFieldCallback :: C_SeekableIfaceTellFieldCallback -> IO (FunPtr C_SeekableIfaceTellFieldCallback)

-- | /No description available in the introspection data./
type SeekableIfaceTellFieldCallback =
    Gio.Seekable.Seekable
    -- ^ /@seekable@/: a t'GI.Gio.Interfaces.Seekable.Seekable'.
    -> IO Int64
    -- ^ __Returns:__ the (positive or zero) offset from the beginning of the
    -- buffer, zero if the target is not seekable.

-- | A convenience synonym for @`Nothing` :: `Maybe` `SeekableIfaceTellFieldCallback`@.
noSeekableIfaceTellFieldCallback :: Maybe SeekableIfaceTellFieldCallback
noSeekableIfaceTellFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SeekableIfaceTellFieldCallback :: MonadIO m => SeekableIfaceTellFieldCallback -> m (GClosure C_SeekableIfaceTellFieldCallback)
genClosure_SeekableIfaceTellFieldCallback cb = liftIO $ do
    let cb' = wrap_SeekableIfaceTellFieldCallback Nothing cb
    mk_SeekableIfaceTellFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `SeekableIfaceTellFieldCallback` into a `C_SeekableIfaceTellFieldCallback`.
wrap_SeekableIfaceTellFieldCallback :: 
    Maybe (Ptr (FunPtr C_SeekableIfaceTellFieldCallback)) ->
    SeekableIfaceTellFieldCallback ->
    C_SeekableIfaceTellFieldCallback
wrap_SeekableIfaceTellFieldCallback gi'funptrptr gi'cb seekable = do
    seekable' <- (newObject Gio.Seekable.Seekable) seekable
    result <- gi'cb  seekable'
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback SeekableIfaceSeekFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE if successful. If an error\n    has occurred, this function will return %FALSE and set @error\n    appropriately if present."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "seekable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Seekable" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GSeekable." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "offset"
          , argType = TBasicType TInt64
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #goffset." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "type"
          , argType =
              TInterface Name { namespace = "GLib" , name = "SeekType" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GSeekType." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "optional #GCancellable object, %NULL to ignore."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SeekableIfaceSeekFieldCallback =
    Ptr Gio.Seekable.Seekable ->
    Int64 ->
    CUInt ->
    Ptr Gio.Cancellable.Cancellable ->
    Ptr (Ptr GError) ->
    IO CInt

-- Args: [ Arg
--           { argCName = "seekable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Seekable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSeekable." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #goffset." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SeekType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSeekType." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SeekableIfaceSeekFieldCallback :: FunPtr C_SeekableIfaceSeekFieldCallback -> C_SeekableIfaceSeekFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SeekableIfaceSeekFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Seekable.IsSeekable a, Gio.Cancellable.IsCancellable b) =>
    FunPtr C_SeekableIfaceSeekFieldCallback
    -> a
    -- ^ /@seekable@/: a t'GI.Gio.Interfaces.Seekable.Seekable'.
    -> Int64
    -- ^ /@offset@/: a @/goffset/@.
    -> GLib.Enums.SeekType
    -- ^ /@type@/: a t'GI.GLib.Enums.SeekType'.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_SeekableIfaceSeekFieldCallback __funPtr seekable offset type_ cancellable = liftIO $ do
    seekable' <- unsafeManagedPtrCastPtr seekable
    let type_' = (fromIntegral . fromEnum) type_
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ (__dynamic_C_SeekableIfaceSeekFieldCallback __funPtr) seekable' offset type_' maybeCancellable
        touchManagedPtr seekable
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_SeekableIfaceSeekFieldCallback`.
foreign import ccall "wrapper"
    mk_SeekableIfaceSeekFieldCallback :: C_SeekableIfaceSeekFieldCallback -> IO (FunPtr C_SeekableIfaceSeekFieldCallback)

-- | /No description available in the introspection data./
type SeekableIfaceSeekFieldCallback =
    Gio.Seekable.Seekable
    -- ^ /@seekable@/: a t'GI.Gio.Interfaces.Seekable.Seekable'.
    -> Int64
    -- ^ /@offset@/: a @/goffset/@.
    -> GLib.Enums.SeekType
    -- ^ /@type@/: a t'GI.GLib.Enums.SeekType'.
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> IO ()
    -- ^ __Returns:__ 'P.True' if successful. If an error
    --     has occurred, this function will return 'P.False' and set /@error@/
    --     appropriately if present. /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `SeekableIfaceSeekFieldCallback`@.
noSeekableIfaceSeekFieldCallback :: Maybe SeekableIfaceSeekFieldCallback
noSeekableIfaceSeekFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback SeekableIfaceCanTruncateFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%TRUE if the stream can be truncated, %FALSE otherwise."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "seekable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Seekable" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GSeekable." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SeekableIfaceCanTruncateFieldCallback =
    Ptr Gio.Seekable.Seekable ->
    IO CInt

-- Args: [ Arg
--           { argCName = "seekable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Seekable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSeekable." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SeekableIfaceCanTruncateFieldCallback :: FunPtr C_SeekableIfaceCanTruncateFieldCallback -> C_SeekableIfaceCanTruncateFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SeekableIfaceCanTruncateFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Seekable.IsSeekable a) =>
    FunPtr C_SeekableIfaceCanTruncateFieldCallback
    -> a
    -- ^ /@seekable@/: a t'GI.Gio.Interfaces.Seekable.Seekable'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the stream can be truncated, 'P.False' otherwise.
dynamic_SeekableIfaceCanTruncateFieldCallback __funPtr seekable = liftIO $ do
    seekable' <- unsafeManagedPtrCastPtr seekable
    result <- (__dynamic_C_SeekableIfaceCanTruncateFieldCallback __funPtr) seekable'
    let result' = (/= 0) result
    touchManagedPtr seekable
    return result'

-- | Generate a function pointer callable from C code, from a `C_SeekableIfaceCanTruncateFieldCallback`.
foreign import ccall "wrapper"
    mk_SeekableIfaceCanTruncateFieldCallback :: C_SeekableIfaceCanTruncateFieldCallback -> IO (FunPtr C_SeekableIfaceCanTruncateFieldCallback)

-- | /No description available in the introspection data./
type SeekableIfaceCanTruncateFieldCallback =
    Gio.Seekable.Seekable
    -- ^ /@seekable@/: a t'GI.Gio.Interfaces.Seekable.Seekable'.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the stream can be truncated, 'P.False' otherwise.

-- | A convenience synonym for @`Nothing` :: `Maybe` `SeekableIfaceCanTruncateFieldCallback`@.
noSeekableIfaceCanTruncateFieldCallback :: Maybe SeekableIfaceCanTruncateFieldCallback
noSeekableIfaceCanTruncateFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SeekableIfaceCanTruncateFieldCallback :: MonadIO m => SeekableIfaceCanTruncateFieldCallback -> m (GClosure C_SeekableIfaceCanTruncateFieldCallback)
genClosure_SeekableIfaceCanTruncateFieldCallback cb = liftIO $ do
    let cb' = wrap_SeekableIfaceCanTruncateFieldCallback Nothing cb
    mk_SeekableIfaceCanTruncateFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `SeekableIfaceCanTruncateFieldCallback` into a `C_SeekableIfaceCanTruncateFieldCallback`.
wrap_SeekableIfaceCanTruncateFieldCallback :: 
    Maybe (Ptr (FunPtr C_SeekableIfaceCanTruncateFieldCallback)) ->
    SeekableIfaceCanTruncateFieldCallback ->
    C_SeekableIfaceCanTruncateFieldCallback
wrap_SeekableIfaceCanTruncateFieldCallback gi'funptrptr gi'cb seekable = do
    seekable' <- (newObject Gio.Seekable.Seekable) seekable
    result <- gi'cb  seekable'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback SeekableIfaceCanSeekFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%TRUE if @seekable can be seeked. %FALSE otherwise."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "seekable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Seekable" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GSeekable." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SeekableIfaceCanSeekFieldCallback =
    Ptr Gio.Seekable.Seekable ->
    IO CInt

-- Args: [ Arg
--           { argCName = "seekable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Seekable" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSeekable." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SeekableIfaceCanSeekFieldCallback :: FunPtr C_SeekableIfaceCanSeekFieldCallback -> C_SeekableIfaceCanSeekFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SeekableIfaceCanSeekFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Seekable.IsSeekable a) =>
    FunPtr C_SeekableIfaceCanSeekFieldCallback
    -> a
    -- ^ /@seekable@/: a t'GI.Gio.Interfaces.Seekable.Seekable'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@seekable@/ can be seeked. 'P.False' otherwise.
dynamic_SeekableIfaceCanSeekFieldCallback __funPtr seekable = liftIO $ do
    seekable' <- unsafeManagedPtrCastPtr seekable
    result <- (__dynamic_C_SeekableIfaceCanSeekFieldCallback __funPtr) seekable'
    let result' = (/= 0) result
    touchManagedPtr seekable
    return result'

-- | Generate a function pointer callable from C code, from a `C_SeekableIfaceCanSeekFieldCallback`.
foreign import ccall "wrapper"
    mk_SeekableIfaceCanSeekFieldCallback :: C_SeekableIfaceCanSeekFieldCallback -> IO (FunPtr C_SeekableIfaceCanSeekFieldCallback)

-- | /No description available in the introspection data./
type SeekableIfaceCanSeekFieldCallback =
    Gio.Seekable.Seekable
    -- ^ /@seekable@/: a t'GI.Gio.Interfaces.Seekable.Seekable'.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if /@seekable@/ can be seeked. 'P.False' otherwise.

-- | A convenience synonym for @`Nothing` :: `Maybe` `SeekableIfaceCanSeekFieldCallback`@.
noSeekableIfaceCanSeekFieldCallback :: Maybe SeekableIfaceCanSeekFieldCallback
noSeekableIfaceCanSeekFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SeekableIfaceCanSeekFieldCallback :: MonadIO m => SeekableIfaceCanSeekFieldCallback -> m (GClosure C_SeekableIfaceCanSeekFieldCallback)
genClosure_SeekableIfaceCanSeekFieldCallback cb = liftIO $ do
    let cb' = wrap_SeekableIfaceCanSeekFieldCallback Nothing cb
    mk_SeekableIfaceCanSeekFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `SeekableIfaceCanSeekFieldCallback` into a `C_SeekableIfaceCanSeekFieldCallback`.
wrap_SeekableIfaceCanSeekFieldCallback :: 
    Maybe (Ptr (FunPtr C_SeekableIfaceCanSeekFieldCallback)) ->
    SeekableIfaceCanSeekFieldCallback ->
    C_SeekableIfaceCanSeekFieldCallback
wrap_SeekableIfaceCanSeekFieldCallback gi'funptrptr gi'cb seekable = do
    seekable' <- (newObject Gio.Seekable.Seekable) seekable
    result <- gi'cb  seekable'
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback ReallocFunc
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = True
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "a pointer to the reallocated memory"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "memory block to reallocate"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "size"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "size to reallocate @data to"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Changes the size of the memory block pointed to by @data to\n@size bytes.\n\nThe function should have the same semantics as realloc()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ReallocFunc =
    Ptr () ->
    FCT.CSize ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "memory block to reallocate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "size to reallocate @data to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ReallocFunc :: FunPtr C_ReallocFunc -> C_ReallocFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ReallocFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ReallocFunc
    -> Ptr ()
    -- ^ /@data@/: memory block to reallocate
    -> FCT.CSize
    -- ^ /@size@/: size to reallocate /@data@/ to
    -> m (Ptr ())
    -- ^ __Returns:__ a pointer to the reallocated memory
dynamic_ReallocFunc __funPtr data_ size = liftIO $ do
    result <- (__dynamic_C_ReallocFunc __funPtr) data_ size
    return result

-- | Generate a function pointer callable from C code, from a `C_ReallocFunc`.
foreign import ccall "wrapper"
    mk_ReallocFunc :: C_ReallocFunc -> IO (FunPtr C_ReallocFunc)

-- | Changes the size of the memory block pointed to by /@data@/ to
-- /@size@/ bytes.
-- 
-- The function should have the same semantics as @/realloc()/@.
type ReallocFunc =
    Ptr ()
    -- ^ /@data@/: memory block to reallocate
    -> FCT.CSize
    -- ^ /@size@/: size to reallocate /@data@/ to
    -> IO (Ptr ())
    -- ^ __Returns:__ a pointer to the reallocated memory

-- | A convenience synonym for @`Nothing` :: `Maybe` `ReallocFunc`@.
noReallocFunc :: Maybe ReallocFunc
noReallocFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ReallocFunc :: MonadIO m => ReallocFunc -> m (GClosure C_ReallocFunc)
genClosure_ReallocFunc cb = liftIO $ do
    let cb' = wrap_ReallocFunc Nothing cb
    mk_ReallocFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ReallocFunc` into a `C_ReallocFunc`.
wrap_ReallocFunc :: 
    Maybe (Ptr (FunPtr C_ReallocFunc)) ->
    ReallocFunc ->
    C_ReallocFunc
wrap_ReallocFunc gi'funptrptr gi'cb data_ size = do
    result <- gi'cb  data_ size
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback PollableSourceFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "it should return %FALSE if the source should be removed."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "pollable_stream"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the #GPollableInputStream or #GPollableOutputStream"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed in by the user."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This is the function type of the callback used for the #GSource\nreturned by g_pollable_input_stream_create_source() and\ng_pollable_output_stream_create_source()."
        , sinceVersion = Just "2.28"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PollableSourceFunc =
    Ptr GObject.Object.Object ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "pollable_stream"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GPollableInputStream or #GPollableOutputStream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed in by the user."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PollableSourceFunc :: FunPtr C_PollableSourceFunc -> C_PollableSourceFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PollableSourceFunc ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    FunPtr C_PollableSourceFunc
    -> a
    -- ^ /@pollableStream@/: the t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream' or t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'
    -> Ptr ()
    -- ^ /@data@/: data passed in by the user.
    -> m Bool
    -- ^ __Returns:__ it should return 'P.False' if the source should be removed.
dynamic_PollableSourceFunc __funPtr pollableStream data_ = liftIO $ do
    pollableStream' <- unsafeManagedPtrCastPtr pollableStream
    result <- (__dynamic_C_PollableSourceFunc __funPtr) pollableStream' data_
    let result' = (/= 0) result
    touchManagedPtr pollableStream
    return result'

-- | Generate a function pointer callable from C code, from a `C_PollableSourceFunc`.
foreign import ccall "wrapper"
    mk_PollableSourceFunc :: C_PollableSourceFunc -> IO (FunPtr C_PollableSourceFunc)

-- | This is the function type of the callback used for the t'GI.GLib.Structs.Source.Source'
-- returned by 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamCreateSource' and
-- 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCreateSource'.
-- 
-- /Since: 2.28/
type PollableSourceFunc =
    GObject.Object.Object
    -- ^ /@pollableStream@/: the t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream' or t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'
    -> IO Bool
    -- ^ __Returns:__ it should return 'P.False' if the source should be removed.

-- | A convenience synonym for @`Nothing` :: `Maybe` `PollableSourceFunc`@.
noPollableSourceFunc :: Maybe PollableSourceFunc
noPollableSourceFunc = Nothing

-- | This is the function type of the callback used for the t'GI.GLib.Structs.Source.Source'
-- returned by 'GI.Gio.Interfaces.PollableInputStream.pollableInputStreamCreateSource' and
-- 'GI.Gio.Interfaces.PollableOutputStream.pollableOutputStreamCreateSource'.
-- 
-- /Since: 2.28/
type PollableSourceFunc_WithClosures =
    GObject.Object.Object
    -- ^ /@pollableStream@/: the t'GI.Gio.Interfaces.PollableInputStream.PollableInputStream' or t'GI.Gio.Interfaces.PollableOutputStream.PollableOutputStream'
    -> Ptr ()
    -- ^ /@data@/: data passed in by the user.
    -> IO Bool
    -- ^ __Returns:__ it should return 'P.False' if the source should be removed.

-- | A convenience synonym for @`Nothing` :: `Maybe` `PollableSourceFunc_WithClosures`@.
noPollableSourceFunc_WithClosures :: Maybe PollableSourceFunc_WithClosures
noPollableSourceFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_PollableSourceFunc :: PollableSourceFunc -> PollableSourceFunc_WithClosures
drop_closures_PollableSourceFunc _f pollableStream _ = _f pollableStream

-- | Wrap the callback into a `GClosure`.
genClosure_PollableSourceFunc :: MonadIO m => PollableSourceFunc -> m (GClosure C_PollableSourceFunc)
genClosure_PollableSourceFunc cb = liftIO $ do
    let cb' = drop_closures_PollableSourceFunc cb
    let cb'' = wrap_PollableSourceFunc Nothing cb'
    mk_PollableSourceFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `PollableSourceFunc` into a `C_PollableSourceFunc`.
wrap_PollableSourceFunc :: 
    Maybe (Ptr (FunPtr C_PollableSourceFunc)) ->
    PollableSourceFunc_WithClosures ->
    C_PollableSourceFunc
wrap_PollableSourceFunc gi'funptrptr gi'cb pollableStream data_ = do
    pollableStream' <- (newObject GObject.Object.Object) pollableStream
    result <- gi'cb  pollableStream' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback InputStreamClassSkipFinishFieldCallback
{- Callable
  { returnType = Just (TBasicType TSSize)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "the size of the bytes skipped, or `-1` on error."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "stream"
          , argType =
              TInterface Name { namespace = "Gio" , name = "InputStream" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GInputStream." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "result"
          , argType =
              TInterface Name { namespace = "Gio" , name = "AsyncResult" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InputStreamClassSkipFinishFieldCallback =
    Ptr Gio.InputStream.InputStream ->
    Ptr Gio.AsyncResult.AsyncResult ->
    Ptr (Ptr GError) ->
    IO DI.Int64

-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSSize)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InputStreamClassSkipFinishFieldCallback :: FunPtr C_InputStreamClassSkipFinishFieldCallback -> C_InputStreamClassSkipFinishFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InputStreamClassSkipFinishFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.AsyncResult.IsAsyncResult b) =>
    FunPtr C_InputStreamClassSkipFinishFieldCallback
    -> a
    -- ^ /@stream@/: a t'GI.Gio.Objects.InputStream.InputStream'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m DI.Int64
    -- ^ __Returns:__ the size of the bytes skipped, or @-1@ on error. /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_InputStreamClassSkipFinishFieldCallback __funPtr stream result_ = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ (__dynamic_C_InputStreamClassSkipFinishFieldCallback __funPtr) stream' result_'
        touchManagedPtr stream
        touchManagedPtr result_
        return result
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_InputStreamClassSkipFinishFieldCallback`.
foreign import ccall "wrapper"
    mk_InputStreamClassSkipFinishFieldCallback :: C_InputStreamClassSkipFinishFieldCallback -> IO (FunPtr C_InputStreamClassSkipFinishFieldCallback)

-- | /No description available in the introspection data./
type InputStreamClassSkipFinishFieldCallback =
    Gio.InputStream.InputStream
    -- ^ /@stream@/: a t'GI.Gio.Objects.InputStream.InputStream'.
    -> Gio.AsyncResult.AsyncResult
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> IO DI.Int64
    -- ^ __Returns:__ the size of the bytes skipped, or @-1@ on error. /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassSkipFinishFieldCallback`@.
noInputStreamClassSkipFinishFieldCallback :: Maybe InputStreamClassSkipFinishFieldCallback
noInputStreamClassSkipFinishFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback InputStreamClassSkipFieldCallback
{- Callable
  { returnType = Just (TBasicType TSSize)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "Number of bytes skipped, or -1 on error"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "stream"
          , argType =
              TInterface Name { namespace = "Gio" , name = "InputStream" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GInputStream." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the number of bytes that will be skipped from the stream"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "optional #GCancellable object, %NULL to ignore."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InputStreamClassSkipFieldCallback =
    Ptr Gio.InputStream.InputStream ->
    FCT.CSize ->
    Ptr Gio.Cancellable.Cancellable ->
    Ptr (Ptr GError) ->
    IO DI.Int64

-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of bytes that will be skipped from the stream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSSize)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InputStreamClassSkipFieldCallback :: FunPtr C_InputStreamClassSkipFieldCallback -> C_InputStreamClassSkipFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InputStreamClassSkipFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Cancellable.IsCancellable b) =>
    FunPtr C_InputStreamClassSkipFieldCallback
    -> a
    -- ^ /@stream@/: a t'GI.Gio.Objects.InputStream.InputStream'.
    -> FCT.CSize
    -- ^ /@count@/: the number of bytes that will be skipped from the stream
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> m DI.Int64
    -- ^ __Returns:__ Number of bytes skipped, or -1 on error /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_InputStreamClassSkipFieldCallback __funPtr stream count cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ (__dynamic_C_InputStreamClassSkipFieldCallback __funPtr) stream' count maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return result
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_InputStreamClassSkipFieldCallback`.
foreign import ccall "wrapper"
    mk_InputStreamClassSkipFieldCallback :: C_InputStreamClassSkipFieldCallback -> IO (FunPtr C_InputStreamClassSkipFieldCallback)

-- | /No description available in the introspection data./
type InputStreamClassSkipFieldCallback =
    Gio.InputStream.InputStream
    -- ^ /@stream@/: a t'GI.Gio.Objects.InputStream.InputStream'.
    -> FCT.CSize
    -- ^ /@count@/: the number of bytes that will be skipped from the stream
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> IO DI.Int64
    -- ^ __Returns:__ Number of bytes skipped, or -1 on error /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassSkipFieldCallback`@.
noInputStreamClassSkipFieldCallback :: Maybe InputStreamClassSkipFieldCallback
noInputStreamClassSkipFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback InputStreamClassSkipAsyncFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "stream"
          , argType =
              TInterface Name { namespace = "Gio" , name = "InputStream" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GInputStream." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the number of bytes that will be skipped from the stream"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "io_priority"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the [I/O priority](iface.AsyncResult.html#io-priority) of the request"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "optional #GCancellable object, %NULL to ignore."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "callback"
          , argType =
              TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "a #GAsyncReadyCallback\n  to call when the request is satisfied"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeAsync
          , argClosure = 5
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data to pass to callback function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InputStreamClassSkipAsyncFieldCallback =
    Ptr Gio.InputStream.InputStream ->
    FCT.CSize ->
    Int32 ->
    Ptr Gio.Cancellable.Cancellable ->
    FunPtr C_AsyncReadyCallback ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GInputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of bytes that will be skipped from the stream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the [I/O priority](iface.AsyncResult.html#io-priority) of the request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncReadyCallback\n  to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InputStreamClassSkipAsyncFieldCallback :: FunPtr C_InputStreamClassSkipAsyncFieldCallback -> C_InputStreamClassSkipAsyncFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InputStreamClassSkipAsyncFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Cancellable.IsCancellable b) =>
    FunPtr C_InputStreamClassSkipAsyncFieldCallback
    -> a
    -- ^ /@stream@/: A t'GI.Gio.Objects.InputStream.InputStream'.
    -> FCT.CSize
    -- ^ /@count@/: the number of bytes that will be skipped from the stream
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the request
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (AsyncReadyCallback_WithClosures)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> Ptr ()
    -- ^ /@userData@/: the data to pass to callback function
    -> m ()
dynamic_InputStreamClassSkipAsyncFieldCallback __funPtr stream count ioPriority cancellable callback userData = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr C_AsyncReadyCallback))
            jCallback' <- mk_AsyncReadyCallback (wrap_AsyncReadyCallback (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    (__dynamic_C_InputStreamClassSkipAsyncFieldCallback __funPtr) stream' count ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr stream
    whenJust cancellable touchManagedPtr
    return ()

-- | Generate a function pointer callable from C code, from a `C_InputStreamClassSkipAsyncFieldCallback`.
foreign import ccall "wrapper"
    mk_InputStreamClassSkipAsyncFieldCallback :: C_InputStreamClassSkipAsyncFieldCallback -> IO (FunPtr C_InputStreamClassSkipAsyncFieldCallback)

-- | /No description available in the introspection data./
type InputStreamClassSkipAsyncFieldCallback =
    Gio.InputStream.InputStream
    -- ^ /@stream@/: A t'GI.Gio.Objects.InputStream.InputStream'.
    -> FCT.CSize
    -- ^ /@count@/: the number of bytes that will be skipped from the stream
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the request
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe AsyncReadyCallback_WithClosures
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassSkipAsyncFieldCallback`@.
noInputStreamClassSkipAsyncFieldCallback :: Maybe InputStreamClassSkipAsyncFieldCallback
noInputStreamClassSkipAsyncFieldCallback = Nothing

-- | /No description available in the introspection data./
type InputStreamClassSkipAsyncFieldCallback_WithClosures =
    Gio.InputStream.InputStream
    -- ^ /@stream@/: A t'GI.Gio.Objects.InputStream.InputStream'.
    -> FCT.CSize
    -- ^ /@count@/: the number of bytes that will be skipped from the stream
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the request
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe AsyncReadyCallback_WithClosures
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> Ptr ()
    -- ^ /@userData@/: the data to pass to callback function
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassSkipAsyncFieldCallback_WithClosures`@.
noInputStreamClassSkipAsyncFieldCallback_WithClosures :: Maybe InputStreamClassSkipAsyncFieldCallback_WithClosures
noInputStreamClassSkipAsyncFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_InputStreamClassSkipAsyncFieldCallback :: InputStreamClassSkipAsyncFieldCallback -> InputStreamClassSkipAsyncFieldCallback_WithClosures
drop_closures_InputStreamClassSkipAsyncFieldCallback _f stream count ioPriority cancellable callback _ = _f stream count ioPriority cancellable callback

-- | Wrap the callback into a `GClosure`.
genClosure_InputStreamClassSkipAsyncFieldCallback :: MonadIO m => InputStreamClassSkipAsyncFieldCallback -> m (GClosure C_InputStreamClassSkipAsyncFieldCallback)
genClosure_InputStreamClassSkipAsyncFieldCallback cb = liftIO $ do
    let cb' = drop_closures_InputStreamClassSkipAsyncFieldCallback cb
    let cb'' = wrap_InputStreamClassSkipAsyncFieldCallback Nothing cb'
    mk_InputStreamClassSkipAsyncFieldCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `InputStreamClassSkipAsyncFieldCallback` into a `C_InputStreamClassSkipAsyncFieldCallback`.
wrap_InputStreamClassSkipAsyncFieldCallback :: 
    Maybe (Ptr (FunPtr C_InputStreamClassSkipAsyncFieldCallback)) ->
    InputStreamClassSkipAsyncFieldCallback_WithClosures ->
    C_InputStreamClassSkipAsyncFieldCallback
wrap_InputStreamClassSkipAsyncFieldCallback gi'funptrptr gi'cb stream count ioPriority cancellable callback userData = do
    stream' <- (newObject Gio.InputStream.InputStream) stream
    maybeCancellable <-
        if cancellable == FP.nullPtr
        then return Nothing
        else do
            cancellable' <- (newObject Gio.Cancellable.Cancellable) cancellable
            return $ Just cancellable'
    maybeCallback <-
        if callback == FP.nullFunPtr
        then return Nothing
        else do
            let callback' = dynamic_AsyncReadyCallback callback
            return $ Just callback'
    gi'cb  stream' count ioPriority maybeCancellable maybeCallback userData
    maybeReleaseFunPtr gi'funptrptr


-- callback InputStreamClassReadFnFieldCallback
{- Callable
  { returnType = Just (TBasicType TSSize)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "stream"
          , argType =
              TInterface Name { namespace = "Gio" , name = "InputStream" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "buffer"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InputStreamClassReadFnFieldCallback =
    Ptr Gio.InputStream.InputStream ->
    Ptr () ->
    FCT.CSize ->
    Ptr Gio.Cancellable.Cancellable ->
    Ptr (Ptr GError) ->
    IO DI.Int64

-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSSize)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InputStreamClassReadFnFieldCallback :: FunPtr C_InputStreamClassReadFnFieldCallback -> C_InputStreamClassReadFnFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InputStreamClassReadFnFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Cancellable.IsCancellable b) =>
    FunPtr C_InputStreamClassReadFnFieldCallback
    -> a
    -> Ptr ()
    -> FCT.CSize
    -> Maybe (b)
    -> m DI.Int64
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_InputStreamClassReadFnFieldCallback __funPtr stream buffer count cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        result <- propagateGError $ (__dynamic_C_InputStreamClassReadFnFieldCallback __funPtr) stream' buffer count maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return result
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_InputStreamClassReadFnFieldCallback`.
foreign import ccall "wrapper"
    mk_InputStreamClassReadFnFieldCallback :: C_InputStreamClassReadFnFieldCallback -> IO (FunPtr C_InputStreamClassReadFnFieldCallback)

-- | /No description available in the introspection data./
type InputStreamClassReadFnFieldCallback =
    Gio.InputStream.InputStream
    -> Ptr ()
    -> FCT.CSize
    -> Maybe Gio.Cancellable.Cancellable
    -> IO DI.Int64
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassReadFnFieldCallback`@.
noInputStreamClassReadFnFieldCallback :: Maybe InputStreamClassReadFnFieldCallback
noInputStreamClassReadFnFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback InputStreamClassReadFinishFieldCallback
{- Callable
  { returnType = Just (TBasicType TSSize)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "number of bytes read in, or -1 on error, or 0 on end of file."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "stream"
          , argType =
              TInterface Name { namespace = "Gio" , name = "InputStream" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GInputStream." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "result"
          , argType =
              TInterface Name { namespace = "Gio" , name = "AsyncResult" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InputStreamClassReadFinishFieldCallback =
    Ptr Gio.InputStream.InputStream ->
    Ptr Gio.AsyncResult.AsyncResult ->
    Ptr (Ptr GError) ->
    IO DI.Int64

-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSSize)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InputStreamClassReadFinishFieldCallback :: FunPtr C_InputStreamClassReadFinishFieldCallback -> C_InputStreamClassReadFinishFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InputStreamClassReadFinishFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.AsyncResult.IsAsyncResult b) =>
    FunPtr C_InputStreamClassReadFinishFieldCallback
    -> a
    -- ^ /@stream@/: a t'GI.Gio.Objects.InputStream.InputStream'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m DI.Int64
    -- ^ __Returns:__ number of bytes read in, or -1 on error, or 0 on end of file. /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_InputStreamClassReadFinishFieldCallback __funPtr stream result_ = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ (__dynamic_C_InputStreamClassReadFinishFieldCallback __funPtr) stream' result_'
        touchManagedPtr stream
        touchManagedPtr result_
        return result
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_InputStreamClassReadFinishFieldCallback`.
foreign import ccall "wrapper"
    mk_InputStreamClassReadFinishFieldCallback :: C_InputStreamClassReadFinishFieldCallback -> IO (FunPtr C_InputStreamClassReadFinishFieldCallback)

-- | /No description available in the introspection data./
type InputStreamClassReadFinishFieldCallback =
    Gio.InputStream.InputStream
    -- ^ /@stream@/: a t'GI.Gio.Objects.InputStream.InputStream'.
    -> Gio.AsyncResult.AsyncResult
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> IO DI.Int64
    -- ^ __Returns:__ number of bytes read in, or -1 on error, or 0 on end of file. /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassReadFinishFieldCallback`@.
noInputStreamClassReadFinishFieldCallback :: Maybe InputStreamClassReadFinishFieldCallback
noInputStreamClassReadFinishFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback InputStreamClassReadAsyncFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "stream"
          , argType =
              TInterface Name { namespace = "Gio" , name = "InputStream" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GInputStream." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "buffer"
          , argType = TCArray False (-1) 2 (TBasicType TUInt8)
          , direction = DirectionInout
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "\n  a buffer to read data into (which should be at least count bytes long)."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = True
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the number of bytes that will be read from the stream"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "io_priority"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the [I/O priority](iface.AsyncResult.html#io-priority)\nof the request."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "optional #GCancellable object, %NULL to ignore."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "callback"
          , argType =
              TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "a #GAsyncReadyCallback\n  to call when the request is satisfied"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeAsync
          , argClosure = 6
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data to pass to callback function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InputStreamClassReadAsyncFieldCallback =
    Ptr Gio.InputStream.InputStream ->
    Ptr Word8 ->
    FCT.CSize ->
    Int32 ->
    Ptr Gio.Cancellable.Cancellable ->
    FunPtr C_AsyncReadyCallback ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GInputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer"
--           , argType = TCArray False (-1) 2 (TBasicType TUInt8)
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "\n  a buffer to read data into (which should be at least count bytes long)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of bytes that will be read from the stream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the [I/O priority](iface.AsyncResult.html#io-priority)\nof the request."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncReadyCallback\n  to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 6
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "count"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "the number of bytes that will be read from the stream"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InputStreamClassReadAsyncFieldCallback :: FunPtr C_InputStreamClassReadAsyncFieldCallback -> C_InputStreamClassReadAsyncFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InputStreamClassReadAsyncFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Cancellable.IsCancellable b) =>
    FunPtr C_InputStreamClassReadAsyncFieldCallback
    -> a
    -- ^ /@stream@/: A t'GI.Gio.Objects.InputStream.InputStream'.
    -> Maybe (ByteString)
    -- ^ /@buffer@/: 
    --   a buffer to read data into (which should be at least count bytes long).
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority>
    -- of the request.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe (AsyncReadyCallback_WithClosures)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> Ptr ()
    -- ^ /@userData@/: the data to pass to callback function
    -> m ((Maybe ByteString))
dynamic_InputStreamClassReadAsyncFieldCallback __funPtr stream buffer ioPriority cancellable callback userData = liftIO $ do
    let count = case buffer of
            Nothing -> 0
            Just jBuffer -> fromIntegral $ B.length jBuffer
    stream' <- unsafeManagedPtrCastPtr stream
    maybeBuffer <- case buffer of
        Nothing -> return FP.nullPtr
        Just jBuffer -> do
            jBuffer' <- packByteString jBuffer
            return jBuffer'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr C_AsyncReadyCallback))
            jCallback' <- mk_AsyncReadyCallback (wrap_AsyncReadyCallback (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    (__dynamic_C_InputStreamClassReadAsyncFieldCallback __funPtr) stream' maybeBuffer count ioPriority maybeCancellable maybeCallback userData
    maybeMaybeBuffer <- convertIfNonNull maybeBuffer $ \maybeBuffer' -> do
        maybeBuffer'' <- (unpackByteStringWithLength count) maybeBuffer'
        freeMem maybeBuffer'
        return maybeBuffer''
    touchManagedPtr stream
    whenJust cancellable touchManagedPtr
    return maybeMaybeBuffer

-- | Generate a function pointer callable from C code, from a `C_InputStreamClassReadAsyncFieldCallback`.
foreign import ccall "wrapper"
    mk_InputStreamClassReadAsyncFieldCallback :: C_InputStreamClassReadAsyncFieldCallback -> IO (FunPtr C_InputStreamClassReadAsyncFieldCallback)

-- | /No description available in the introspection data./
type InputStreamClassReadAsyncFieldCallback =
    Gio.InputStream.InputStream
    -- ^ /@stream@/: A t'GI.Gio.Objects.InputStream.InputStream'.
    -> Maybe ByteString
    -- ^ /@buffer@/: 
    --   a buffer to read data into (which should be at least count bytes long).
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority>
    -- of the request.
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe AsyncReadyCallback_WithClosures
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> IO ((Maybe ByteString))

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassReadAsyncFieldCallback`@.
noInputStreamClassReadAsyncFieldCallback :: Maybe InputStreamClassReadAsyncFieldCallback
noInputStreamClassReadAsyncFieldCallback = Nothing

-- | /No description available in the introspection data./
type InputStreamClassReadAsyncFieldCallback_WithClosures =
    Gio.InputStream.InputStream
    -- ^ /@stream@/: A t'GI.Gio.Objects.InputStream.InputStream'.
    -> Maybe ByteString
    -- ^ /@buffer@/: 
    --   a buffer to read data into (which should be at least count bytes long).
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority>
    -- of the request.
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Maybe AsyncReadyCallback_WithClosures
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> Ptr ()
    -- ^ /@userData@/: the data to pass to callback function
    -> IO ((Maybe ByteString))

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassReadAsyncFieldCallback_WithClosures`@.
noInputStreamClassReadAsyncFieldCallback_WithClosures :: Maybe InputStreamClassReadAsyncFieldCallback_WithClosures
noInputStreamClassReadAsyncFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_InputStreamClassReadAsyncFieldCallback :: InputStreamClassReadAsyncFieldCallback -> InputStreamClassReadAsyncFieldCallback_WithClosures
drop_closures_InputStreamClassReadAsyncFieldCallback _f stream buffer ioPriority cancellable callback _ = _f stream buffer ioPriority cancellable callback

-- | Wrap the callback into a `GClosure`.
genClosure_InputStreamClassReadAsyncFieldCallback :: MonadIO m => InputStreamClassReadAsyncFieldCallback -> m (GClosure C_InputStreamClassReadAsyncFieldCallback)
genClosure_InputStreamClassReadAsyncFieldCallback cb = liftIO $ do
    let cb' = drop_closures_InputStreamClassReadAsyncFieldCallback cb
    let cb'' = wrap_InputStreamClassReadAsyncFieldCallback Nothing cb'
    mk_InputStreamClassReadAsyncFieldCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `InputStreamClassReadAsyncFieldCallback` into a `C_InputStreamClassReadAsyncFieldCallback`.
wrap_InputStreamClassReadAsyncFieldCallback :: 
    Maybe (Ptr (FunPtr C_InputStreamClassReadAsyncFieldCallback)) ->
    InputStreamClassReadAsyncFieldCallback_WithClosures ->
    C_InputStreamClassReadAsyncFieldCallback
wrap_InputStreamClassReadAsyncFieldCallback gi'funptrptr gi'cb stream buffer count ioPriority cancellable callback userData = do
    -- XXX Could not generate callback wrapper for InputStreamClassReadAsyncFieldCallback
    -- Not implemented: Don't know how to unpack C array of type TCArray False (-1) 2 (TBasicType TUInt8)
    P.error "The bindings for wrap_InputStreamClassReadAsyncFieldCallback could not be generated, function unsupported."


-- callback InputStreamClassCloseFnFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "stream"
          , argType =
              TInterface Name { namespace = "Gio" , name = "InputStream" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InputStreamClassCloseFnFieldCallback =
    Ptr Gio.InputStream.InputStream ->
    Ptr Gio.Cancellable.Cancellable ->
    Ptr (Ptr GError) ->
    IO CInt

-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InputStreamClassCloseFnFieldCallback :: FunPtr C_InputStreamClassCloseFnFieldCallback -> C_InputStreamClassCloseFnFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InputStreamClassCloseFnFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Cancellable.IsCancellable b) =>
    FunPtr C_InputStreamClassCloseFnFieldCallback
    -> a
    -> Maybe (b)
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_InputStreamClassCloseFnFieldCallback __funPtr stream cancellable = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    onException (do
        _ <- propagateGError $ (__dynamic_C_InputStreamClassCloseFnFieldCallback __funPtr) stream' maybeCancellable
        touchManagedPtr stream
        whenJust cancellable touchManagedPtr
        return ()
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_InputStreamClassCloseFnFieldCallback`.
foreign import ccall "wrapper"
    mk_InputStreamClassCloseFnFieldCallback :: C_InputStreamClassCloseFnFieldCallback -> IO (FunPtr C_InputStreamClassCloseFnFieldCallback)

-- | /No description available in the introspection data./
type InputStreamClassCloseFnFieldCallback =
    Gio.InputStream.InputStream
    -> Maybe Gio.Cancellable.Cancellable
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassCloseFnFieldCallback`@.
noInputStreamClassCloseFnFieldCallback :: Maybe InputStreamClassCloseFnFieldCallback
noInputStreamClassCloseFnFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback InputStreamClassCloseFinishFieldCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE if the stream was closed successfully."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "stream"
          , argType =
              TInterface Name { namespace = "Gio" , name = "InputStream" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GInputStream." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "result"
          , argType =
              TInterface Name { namespace = "Gio" , name = "AsyncResult" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InputStreamClassCloseFinishFieldCallback =
    Ptr Gio.InputStream.InputStream ->
    Ptr Gio.AsyncResult.AsyncResult ->
    Ptr (Ptr GError) ->
    IO CInt

-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GInputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InputStreamClassCloseFinishFieldCallback :: FunPtr C_InputStreamClassCloseFinishFieldCallback -> C_InputStreamClassCloseFinishFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InputStreamClassCloseFinishFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.AsyncResult.IsAsyncResult b) =>
    FunPtr C_InputStreamClassCloseFinishFieldCallback
    -> a
    -- ^ /@stream@/: a t'GI.Gio.Objects.InputStream.InputStream'.
    -> b
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_InputStreamClassCloseFinishFieldCallback __funPtr stream result_ = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ (__dynamic_C_InputStreamClassCloseFinishFieldCallback __funPtr) stream' result_'
        touchManagedPtr stream
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_InputStreamClassCloseFinishFieldCallback`.
foreign import ccall "wrapper"
    mk_InputStreamClassCloseFinishFieldCallback :: C_InputStreamClassCloseFinishFieldCallback -> IO (FunPtr C_InputStreamClassCloseFinishFieldCallback)

-- | /No description available in the introspection data./
type InputStreamClassCloseFinishFieldCallback =
    Gio.InputStream.InputStream
    -- ^ /@stream@/: a t'GI.Gio.Objects.InputStream.InputStream'.
    -> Gio.AsyncResult.AsyncResult
    -- ^ /@result@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> IO ()
    -- ^ __Returns:__ 'P.True' if the stream was closed successfully. /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassCloseFinishFieldCallback`@.
noInputStreamClassCloseFinishFieldCallback :: Maybe InputStreamClassCloseFinishFieldCallback
noInputStreamClassCloseFinishFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback InputStreamClassCloseAsyncFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "stream"
          , argType =
              TInterface Name { namespace = "Gio" , name = "InputStream" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GInputStream." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "io_priority"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the [I/O priority](iface.AsyncResult.html#io-priority) of the request"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "optional cancellable object"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "callback"
          , argType =
              TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "a #GAsyncReadyCallback\n  to call when the request is satisfied"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeAsync
          , argClosure = 4
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data to pass to callback function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_InputStreamClassCloseAsyncFieldCallback =
    Ptr Gio.InputStream.InputStream ->
    Int32 ->
    Ptr Gio.Cancellable.Cancellable ->
    FunPtr C_AsyncReadyCallback ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InputStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GInputStream." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the [I/O priority](iface.AsyncResult.html#io-priority) of the request"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional cancellable object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GAsyncReadyCallback\n  to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_InputStreamClassCloseAsyncFieldCallback :: FunPtr C_InputStreamClassCloseAsyncFieldCallback -> C_InputStreamClassCloseAsyncFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_InputStreamClassCloseAsyncFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InputStream.IsInputStream a, Gio.Cancellable.IsCancellable b) =>
    FunPtr C_InputStreamClassCloseAsyncFieldCallback
    -> a
    -- ^ /@stream@/: A t'GI.Gio.Objects.InputStream.InputStream'.
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the request
    -> Maybe (b)
    -- ^ /@cancellable@/: optional cancellable object
    -> Maybe (AsyncReadyCallback_WithClosures)
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> Ptr ()
    -- ^ /@userData@/: the data to pass to callback function
    -> m ()
dynamic_InputStreamClassCloseAsyncFieldCallback __funPtr stream ioPriority cancellable callback userData = liftIO $ do
    stream' <- unsafeManagedPtrCastPtr stream
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr C_AsyncReadyCallback))
            jCallback' <- mk_AsyncReadyCallback (wrap_AsyncReadyCallback (Just ptrcallback) jCallback)
            poke ptrcallback jCallback'
            return jCallback'
    (__dynamic_C_InputStreamClassCloseAsyncFieldCallback __funPtr) stream' ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr stream
    whenJust cancellable touchManagedPtr
    return ()

-- | Generate a function pointer callable from C code, from a `C_InputStreamClassCloseAsyncFieldCallback`.
foreign import ccall "wrapper"
    mk_InputStreamClassCloseAsyncFieldCallback :: C_InputStreamClassCloseAsyncFieldCallback -> IO (FunPtr C_InputStreamClassCloseAsyncFieldCallback)

-- | /No description available in the introspection data./
type InputStreamClassCloseAsyncFieldCallback =
    Gio.InputStream.InputStream
    -- ^ /@stream@/: A t'GI.Gio.Objects.InputStream.InputStream'.
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the request
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional cancellable object
    -> Maybe AsyncReadyCallback_WithClosures
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassCloseAsyncFieldCallback`@.
noInputStreamClassCloseAsyncFieldCallback :: Maybe InputStreamClassCloseAsyncFieldCallback
noInputStreamClassCloseAsyncFieldCallback = Nothing

-- | /No description available in the introspection data./
type InputStreamClassCloseAsyncFieldCallback_WithClosures =
    Gio.InputStream.InputStream
    -- ^ /@stream@/: A t'GI.Gio.Objects.InputStream.InputStream'.
    -> Int32
    -- ^ /@ioPriority@/: the <http://developer.gnome.org/gio/stable/iface.AsyncResult.html#io-priority I/O priority> of the request
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional cancellable object
    -> Maybe AsyncReadyCallback_WithClosures
    -- ^ /@callback@/: a t'GI.Gio.Callbacks.AsyncReadyCallback'
    --   to call when the request is satisfied
    -> Ptr ()
    -- ^ /@userData@/: the data to pass to callback function
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `InputStreamClassCloseAsyncFieldCallback_WithClosures`@.
noInputStreamClassCloseAsyncFieldCallback_WithClosures :: Maybe InputStreamClassCloseAsyncFieldCallback_WithClosures
noInputStreamClassCloseAsyncFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_InputStreamClassCloseAsyncFieldCallback :: InputStreamClassCloseAsyncFieldCallback -> InputStreamClassCloseAsyncFieldCallback_WithClosures
drop_closures_InputStreamClassCloseAsyncFieldCallback _f stream ioPriority cancellable callback _ = _f stream ioPriority cancellable callback

-- | Wrap the callback into a `GClosure`.
genClosure_InputStreamClassCloseAsyncFieldCallback :: MonadIO m => InputStreamClassCloseAsyncFieldCallback -> m (GClosure C_InputStreamClassCloseAsyncFieldCallback)
genClosure_InputStreamClassCloseAsyncFieldCallback cb = liftIO $ do
    let cb' = drop_closures_InputStreamClassCloseAsyncFieldCallback cb
    let cb'' = wrap_InputStreamClassCloseAsyncFieldCallback Nothing cb'
    mk_InputStreamClassCloseAsyncFieldCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `InputStreamClassCloseAsyncFieldCallback` into a `C_InputStreamClassCloseAsyncFieldCallback`.
wrap_InputStreamClassCloseAsyncFieldCallback :: 
    Maybe (Ptr (FunPtr C_InputStreamClassCloseAsyncFieldCallback)) ->
    InputStreamClassCloseAsyncFieldCallback_WithClosures ->
    C_InputStreamClassCloseAsyncFieldCallback
wrap_InputStreamClassCloseAsyncFieldCallback gi'funptrptr gi'cb stream ioPriority cancellable callback userData = do
    stream' <- (newObject Gio.InputStream.InputStream) stream
    maybeCancellable <-
        if cancellable == FP.nullPtr
        then return Nothing
        else do
            cancellable' <- (newObject Gio.Cancellable.Cancellable) cancellable
            return $ Just cancellable'
    maybeCallback <-
        if callback == FP.nullFunPtr
        then return Nothing
        else do
            let callback' = dynamic_AsyncReadyCallback callback
            return $ Just callback'
    gi'cb  stream' ioPriority maybeCancellable maybeCallback userData
    maybeReleaseFunPtr gi'funptrptr


-- callback IOSchedulerJobFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE if this function should be called again to\n   complete the job, %FALSE if the job is complete (or cancelled)"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "job"
          , argType =
              TInterface Name { namespace = "Gio" , name = "IOSchedulerJob" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GIOSchedulerJob."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "optional #GCancellable object, %NULL to ignore."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed to the callback function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "2.36"
          , deprecationMessage =
              Just
                "Use [struct@GLib.ThreadPool] or\n  [method@Gio.Task.run_in_thread]"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "I/O Job function.\n\nLong-running jobs should periodically check the @cancellable\nto see if they have been cancelled."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IOSchedulerJobFunc =
    Ptr Gio.IOSchedulerJob.IOSchedulerJob ->
    Ptr Gio.Cancellable.Cancellable ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "job"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOSchedulerJob" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIOSchedulerJob."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional #GCancellable object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed to the callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IOSchedulerJobFunc :: FunPtr C_IOSchedulerJobFunc -> C_IOSchedulerJobFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IOSchedulerJobFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Cancellable.IsCancellable a) =>
    FunPtr C_IOSchedulerJobFunc
    -> Gio.IOSchedulerJob.IOSchedulerJob
    -- ^ /@job@/: a t'GI.Gio.Structs.IOSchedulerJob.IOSchedulerJob'.
    -> Maybe (a)
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Ptr ()
    -- ^ /@data@/: data passed to the callback function
    -> m Bool
    -- ^ __Returns:__ 'P.True' if this function should be called again to
    --    complete the job, 'P.False' if the job is complete (or cancelled)
dynamic_IOSchedulerJobFunc __funPtr job cancellable data_ = liftIO $ do
    job' <- unsafeManagedPtrGetPtr job
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    result <- (__dynamic_C_IOSchedulerJobFunc __funPtr) job' maybeCancellable data_
    let result' = (/= 0) result
    touchManagedPtr job
    whenJust cancellable touchManagedPtr
    return result'

-- | Generate a function pointer callable from C code, from a `C_IOSchedulerJobFunc`.
foreign import ccall "wrapper"
    mk_IOSchedulerJobFunc :: C_IOSchedulerJobFunc -> IO (FunPtr C_IOSchedulerJobFunc)

{-# DEPRECATED IOSchedulerJobFunc ["(Since version 2.36)","Use [struct/@gLib@/.ThreadPool] or","  'GI.Gio.Objects.Task.taskRunInThread'"] #-}
-- | I\/O Job function.
-- 
-- Long-running jobs should periodically check the /@cancellable@/
-- to see if they have been cancelled.
type IOSchedulerJobFunc =
    Gio.IOSchedulerJob.IOSchedulerJob
    -- ^ /@job@/: a t'GI.Gio.Structs.IOSchedulerJob.IOSchedulerJob'.
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if this function should be called again to
    --    complete the job, 'P.False' if the job is complete (or cancelled)

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOSchedulerJobFunc`@.
noIOSchedulerJobFunc :: Maybe IOSchedulerJobFunc
noIOSchedulerJobFunc = Nothing

-- | I\/O Job function.
-- 
-- Long-running jobs should periodically check the /@cancellable@/
-- to see if they have been cancelled.
type IOSchedulerJobFunc_WithClosures =
    Gio.IOSchedulerJob.IOSchedulerJob
    -- ^ /@job@/: a t'GI.Gio.Structs.IOSchedulerJob.IOSchedulerJob'.
    -> Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: optional t'GI.Gio.Objects.Cancellable.Cancellable' object, 'P.Nothing' to ignore.
    -> Ptr ()
    -- ^ /@data@/: data passed to the callback function
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if this function should be called again to
    --    complete the job, 'P.False' if the job is complete (or cancelled)

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOSchedulerJobFunc_WithClosures`@.
noIOSchedulerJobFunc_WithClosures :: Maybe IOSchedulerJobFunc_WithClosures
noIOSchedulerJobFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_IOSchedulerJobFunc :: IOSchedulerJobFunc -> IOSchedulerJobFunc_WithClosures
drop_closures_IOSchedulerJobFunc _f job cancellable _ = _f job cancellable

-- | Wrap the callback into a `GClosure`.
genClosure_IOSchedulerJobFunc :: MonadIO m => IOSchedulerJobFunc -> m (GClosure C_IOSchedulerJobFunc)
genClosure_IOSchedulerJobFunc cb = liftIO $ do
    let cb' = drop_closures_IOSchedulerJobFunc cb
    let cb'' = wrap_IOSchedulerJobFunc Nothing cb'
    mk_IOSchedulerJobFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `IOSchedulerJobFunc` into a `C_IOSchedulerJobFunc`.
wrap_IOSchedulerJobFunc :: 
    Maybe (Ptr (FunPtr C_IOSchedulerJobFunc)) ->
    IOSchedulerJobFunc_WithClosures ->
    C_IOSchedulerJobFunc
wrap_IOSchedulerJobFunc gi'funptrptr gi'cb job cancellable data_ = do
    job' <- (newPtr Gio.IOSchedulerJob.IOSchedulerJob) job
    maybeCancellable <-
        if cancellable == FP.nullPtr
        then return Nothing
        else do
            cancellable' <- (newObject Gio.Cancellable.Cancellable) cancellable
            return $ Just cancellable'
    result <- gi'cb  job' maybeCancellable data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback FileReadMoreCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%TRUE if more data should be read back. %FALSE otherwise."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "file_contents"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the data as currently read."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "file_size"
          , argType = TBasicType TInt64
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the size of the data currently read."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "callback_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed to the callback."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "When loading the partial contents of a file with g_file_load_partial_contents_async(),\nit may become necessary to determine if any more data from the file should be loaded.\nA #GFileReadMoreCallback function facilitates this by returning %TRUE if more data\nshould be read, or %FALSE otherwise."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FileReadMoreCallback =
    CString ->
    Int64 ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "file_contents"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data as currently read."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file_size"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the size of the data currently read."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed to the callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FileReadMoreCallback :: FunPtr C_FileReadMoreCallback -> C_FileReadMoreCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FileReadMoreCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FileReadMoreCallback
    -> T.Text
    -- ^ /@fileContents@/: the data as currently read.
    -> Int64
    -- ^ /@fileSize@/: the size of the data currently read.
    -> Ptr ()
    -- ^ /@callbackData@/: data passed to the callback.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if more data should be read back. 'P.False' otherwise.
dynamic_FileReadMoreCallback __funPtr fileContents fileSize callbackData = liftIO $ do
    fileContents' <- textToCString fileContents
    result <- (__dynamic_C_FileReadMoreCallback __funPtr) fileContents' fileSize callbackData
    let result' = (/= 0) result
    freeMem fileContents'
    return result'

-- | Generate a function pointer callable from C code, from a `C_FileReadMoreCallback`.
foreign import ccall "wrapper"
    mk_FileReadMoreCallback :: C_FileReadMoreCallback -> IO (FunPtr C_FileReadMoreCallback)

-- | When loading the partial contents of a file with @/g_file_load_partial_contents_async()/@,
-- it may become necessary to determine if any more data from the file should be loaded.
-- A t'GI.Gio.Callbacks.FileReadMoreCallback' function facilitates this by returning 'P.True' if more data
-- should be read, or 'P.False' otherwise.
type FileReadMoreCallback =
    T.Text
    -- ^ /@fileContents@/: the data as currently read.
    -> Int64
    -- ^ /@fileSize@/: the size of the data currently read.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if more data should be read back. 'P.False' otherwise.

-- | A convenience synonym for @`Nothing` :: `Maybe` `FileReadMoreCallback`@.
noFileReadMoreCallback :: Maybe FileReadMoreCallback
noFileReadMoreCallback = Nothing

-- | When loading the partial contents of a file with @/g_file_load_partial_contents_async()/@,
-- it may become necessary to determine if any more data from the file should be loaded.
-- A t'GI.Gio.Callbacks.FileReadMoreCallback' function facilitates this by returning 'P.True' if more data
-- should be read, or 'P.False' otherwise.
type FileReadMoreCallback_WithClosures =
    T.Text
    -- ^ /@fileContents@/: the data as currently read.
    -> Int64
    -- ^ /@fileSize@/: the size of the data currently read.
    -> Ptr ()
    -- ^ /@callbackData@/: data passed to the callback.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if more data should be read back. 'P.False' otherwise.

-- | A convenience synonym for @`Nothing` :: `Maybe` `FileReadMoreCallback_WithClosures`@.
noFileReadMoreCallback_WithClosures :: Maybe FileReadMoreCallback_WithClosures
noFileReadMoreCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FileReadMoreCallback :: FileReadMoreCallback -> FileReadMoreCallback_WithClosures
drop_closures_FileReadMoreCallback _f fileContents fileSize _ = _f fileContents fileSize

-- | Wrap the callback into a `GClosure`.
genClosure_FileReadMoreCallback :: MonadIO m => FileReadMoreCallback -> m (GClosure C_FileReadMoreCallback)
genClosure_FileReadMoreCallback cb = liftIO $ do
    let cb' = drop_closures_FileReadMoreCallback cb
    let cb'' = wrap_FileReadMoreCallback Nothing cb'
    mk_FileReadMoreCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FileReadMoreCallback` into a `C_FileReadMoreCallback`.
wrap_FileReadMoreCallback :: 
    Maybe (Ptr (FunPtr C_FileReadMoreCallback)) ->
    FileReadMoreCallback_WithClosures ->
    C_FileReadMoreCallback
wrap_FileReadMoreCallback gi'funptrptr gi'cb fileContents fileSize callbackData = do
    fileContents' <- cstringToText fileContents
    result <- gi'cb  fileContents' fileSize callbackData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback FileProgressCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "current_num_bytes"
          , argType = TBasicType TInt64
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the current number of bytes in the operation."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "total_num_bytes"
          , argType = TBasicType TInt64
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the total number of bytes in the operation."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to the callback."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "When doing file operations that may take a while, such as moving\na file or copying a file, a progress callback is used to pass how\nfar along that operation is to the application."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FileProgressCallback =
    Int64 ->
    Int64 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "current_num_bytes"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the current number of bytes in the operation."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "total_num_bytes"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the total number of bytes in the operation."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to the callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FileProgressCallback :: FunPtr C_FileProgressCallback -> C_FileProgressCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FileProgressCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FileProgressCallback
    -> Int64
    -- ^ /@currentNumBytes@/: the current number of bytes in the operation.
    -> Int64
    -- ^ /@totalNumBytes@/: the total number of bytes in the operation.
    -> Ptr ()
    -- ^ /@data@/: user data passed to the callback.
    -> m ()
dynamic_FileProgressCallback __funPtr currentNumBytes totalNumBytes data_ = liftIO $ do
    (__dynamic_C_FileProgressCallback __funPtr) currentNumBytes totalNumBytes data_
    return ()

-- | Generate a function pointer callable from C code, from a `C_FileProgressCallback`.
foreign import ccall "wrapper"
    mk_FileProgressCallback :: C_FileProgressCallback -> IO (FunPtr C_FileProgressCallback)

-- | When doing file operations that may take a while, such as moving
-- a file or copying a file, a progress callback is used to pass how
-- far along that operation is to the application.
type FileProgressCallback =
    Int64
    -- ^ /@currentNumBytes@/: the current number of bytes in the operation.
    -> Int64
    -- ^ /@totalNumBytes@/: the total number of bytes in the operation.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FileProgressCallback`@.
noFileProgressCallback :: Maybe FileProgressCallback
noFileProgressCallback = Nothing

-- | When doing file operations that may take a while, such as moving
-- a file or copying a file, a progress callback is used to pass how
-- far along that operation is to the application.
type FileProgressCallback_WithClosures =
    Int64
    -- ^ /@currentNumBytes@/: the current number of bytes in the operation.
    -> Int64
    -- ^ /@totalNumBytes@/: the total number of bytes in the operation.
    -> Ptr ()
    -- ^ /@data@/: user data passed to the callback.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FileProgressCallback_WithClosures`@.
noFileProgressCallback_WithClosures :: Maybe FileProgressCallback_WithClosures
noFileProgressCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FileProgressCallback :: FileProgressCallback -> FileProgressCallback_WithClosures
drop_closures_FileProgressCallback _f currentNumBytes totalNumBytes _ = _f currentNumBytes totalNumBytes

-- | Wrap the callback into a `GClosure`.
genClosure_FileProgressCallback :: MonadIO m => FileProgressCallback -> m (GClosure C_FileProgressCallback)
genClosure_FileProgressCallback cb = liftIO $ do
    let cb' = drop_closures_FileProgressCallback cb
    let cb'' = wrap_FileProgressCallback Nothing cb'
    mk_FileProgressCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FileProgressCallback` into a `C_FileProgressCallback`.
wrap_FileProgressCallback :: 
    Maybe (Ptr (FunPtr C_FileProgressCallback)) ->
    FileProgressCallback_WithClosures ->
    C_FileProgressCallback
wrap_FileProgressCallback gi'funptrptr gi'cb currentNumBytes totalNumBytes data_ = do
    gi'cb  currentNumBytes totalNumBytes data_
    maybeReleaseFunPtr gi'funptrptr


-- callback FileMeasureProgressCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "reporting"
          , argType = TBasicType TBoolean
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "%TRUE if more reports will come"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "current_size"
          , argType = TBasicType TUInt64
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the current cumulative size measurement"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "num_dirs"
          , argType = TBasicType TUInt64
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the number of directories visited so far"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "num_files"
          , argType = TBasicType TUInt64
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the number of non-directory files encountered"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the data passed to the original request for this callback"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This callback type is used by g_file_measure_disk_usage() to make\nperiodic progress reports when measuring the amount of disk spaced\nused by a directory.\n\nThese calls are made on a best-effort basis and not all types of\n#GFile will support them.  At the minimum, however, one call will\nalways be made immediately.\n\nIn the case that there is no support, @reporting will be set to\n%FALSE (and the other values undefined) and no further calls will be\nmade.  Otherwise, the @reporting will be %TRUE and the other values\nall-zeros during the first (immediate) call.  In this way, you can\nknow which type of progress UI to show without a delay.\n\nFor g_file_measure_disk_usage() the callback is made directly.  For\ng_file_measure_disk_usage_async() the callback is made via the\ndefault main context of the calling thread (ie: the same way that the\nfinal async result would be reported).\n\n@current_size is in the same units as requested by the operation (see\n%G_FILE_MEASURE_APPARENT_SIZE).\n\nThe frequency of the updates is implementation defined, but is\nideally about once every 200ms.\n\nThe last progress callback may or may not be equal to the final\nresult.  Always check the async result to get the final value."
        , sinceVersion = Just "2.38"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FileMeasureProgressCallback =
    CInt ->
    Word64 ->
    Word64 ->
    Word64 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "reporting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE if more reports will come"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "current_size"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the current cumulative size measurement"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "num_dirs"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of directories visited so far"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "num_files"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of non-directory files encountered"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the data passed to the original request for this callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FileMeasureProgressCallback :: FunPtr C_FileMeasureProgressCallback -> C_FileMeasureProgressCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FileMeasureProgressCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FileMeasureProgressCallback
    -> Bool
    -- ^ /@reporting@/: 'P.True' if more reports will come
    -> Word64
    -- ^ /@currentSize@/: the current cumulative size measurement
    -> Word64
    -- ^ /@numDirs@/: the number of directories visited so far
    -> Word64
    -- ^ /@numFiles@/: the number of non-directory files encountered
    -> Ptr ()
    -- ^ /@data@/: the data passed to the original request for this callback
    -> m ()
dynamic_FileMeasureProgressCallback __funPtr reporting currentSize numDirs numFiles data_ = liftIO $ do
    let reporting' = (P.fromIntegral . P.fromEnum) reporting
    (__dynamic_C_FileMeasureProgressCallback __funPtr) reporting' currentSize numDirs numFiles data_
    return ()

-- | Generate a function pointer callable from C code, from a `C_FileMeasureProgressCallback`.
foreign import ccall "wrapper"
    mk_FileMeasureProgressCallback :: C_FileMeasureProgressCallback -> IO (FunPtr C_FileMeasureProgressCallback)

-- | This callback type is used by 'GI.Gio.Interfaces.File.fileMeasureDiskUsage' to make
-- periodic progress reports when measuring the amount of disk spaced
-- used by a directory.
-- 
-- These calls are made on a best-effort basis and not all types of
-- t'GI.Gio.Interfaces.File.File' will support them.  At the minimum, however, one call will
-- always be made immediately.
-- 
-- In the case that there is no support, /@reporting@/ will be set to
-- 'P.False' (and the other values undefined) and no further calls will be
-- made.  Otherwise, the /@reporting@/ will be 'P.True' and the other values
-- all-zeros during the first (immediate) call.  In this way, you can
-- know which type of progress UI to show without a delay.
-- 
-- For 'GI.Gio.Interfaces.File.fileMeasureDiskUsage' the callback is made directly.  For
-- @/g_file_measure_disk_usage_async()/@ the callback is made via the
-- default main context of the calling thread (ie: the same way that the
-- final async result would be reported).
-- 
-- /@currentSize@/ is in the same units as requested by the operation (see
-- 'GI.Gio.Flags.FileMeasureFlagsApparentSize').
-- 
-- The frequency of the updates is implementation defined, but is
-- ideally about once every 200ms.
-- 
-- The last progress callback may or may not be equal to the final
-- result.  Always check the async result to get the final value.
-- 
-- /Since: 2.38/
type FileMeasureProgressCallback =
    Bool
    -- ^ /@reporting@/: 'P.True' if more reports will come
    -> Word64
    -- ^ /@currentSize@/: the current cumulative size measurement
    -> Word64
    -- ^ /@numDirs@/: the number of directories visited so far
    -> Word64
    -- ^ /@numFiles@/: the number of non-directory files encountered
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FileMeasureProgressCallback`@.
noFileMeasureProgressCallback :: Maybe FileMeasureProgressCallback
noFileMeasureProgressCallback = Nothing

-- | This callback type is used by 'GI.Gio.Interfaces.File.fileMeasureDiskUsage' to make
-- periodic progress reports when measuring the amount of disk spaced
-- used by a directory.
-- 
-- These calls are made on a best-effort basis and not all types of
-- t'GI.Gio.Interfaces.File.File' will support them.  At the minimum, however, one call will
-- always be made immediately.
-- 
-- In the case that there is no support, /@reporting@/ will be set to
-- 'P.False' (and the other values undefined) and no further calls will be
-- made.  Otherwise, the /@reporting@/ will be 'P.True' and the other values
-- all-zeros during the first (immediate) call.  In this way, you can
-- know which type of progress UI to show without a delay.
-- 
-- For 'GI.Gio.Interfaces.File.fileMeasureDiskUsage' the callback is made directly.  For
-- @/g_file_measure_disk_usage_async()/@ the callback is made via the
-- default main context of the calling thread (ie: the same way that the
-- final async result would be reported).
-- 
-- /@currentSize@/ is in the same units as requested by the operation (see
-- 'GI.Gio.Flags.FileMeasureFlagsApparentSize').
-- 
-- The frequency of the updates is implementation defined, but is
-- ideally about once every 200ms.
-- 
-- The last progress callback may or may not be equal to the final
-- result.  Always check the async result to get the final value.
-- 
-- /Since: 2.38/
type FileMeasureProgressCallback_WithClosures =
    Bool
    -- ^ /@reporting@/: 'P.True' if more reports will come
    -> Word64
    -- ^ /@currentSize@/: the current cumulative size measurement
    -> Word64
    -- ^ /@numDirs@/: the number of directories visited so far
    -> Word64
    -- ^ /@numFiles@/: the number of non-directory files encountered
    -> Ptr ()
    -- ^ /@data@/: the data passed to the original request for this callback
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FileMeasureProgressCallback_WithClosures`@.
noFileMeasureProgressCallback_WithClosures :: Maybe FileMeasureProgressCallback_WithClosures
noFileMeasureProgressCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_FileMeasureProgressCallback :: FileMeasureProgressCallback -> FileMeasureProgressCallback_WithClosures
drop_closures_FileMeasureProgressCallback _f reporting currentSize numDirs numFiles _ = _f reporting currentSize numDirs numFiles

-- | Wrap the callback into a `GClosure`.
genClosure_FileMeasureProgressCallback :: MonadIO m => FileMeasureProgressCallback -> m (GClosure C_FileMeasureProgressCallback)
genClosure_FileMeasureProgressCallback cb = liftIO $ do
    let cb' = drop_closures_FileMeasureProgressCallback cb
    let cb'' = wrap_FileMeasureProgressCallback Nothing cb'
    mk_FileMeasureProgressCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `FileMeasureProgressCallback` into a `C_FileMeasureProgressCallback`.
wrap_FileMeasureProgressCallback :: 
    Maybe (Ptr (FunPtr C_FileMeasureProgressCallback)) ->
    FileMeasureProgressCallback_WithClosures ->
    C_FileMeasureProgressCallback
wrap_FileMeasureProgressCallback gi'funptrptr gi'cb reporting currentSize numDirs numFiles data_ = do
    let reporting' = (/= 0) reporting
    gi'cb  reporting' currentSize numDirs numFiles data_
    maybeReleaseFunPtr gi'funptrptr


-- callback DesktopAppLaunchCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "appinfo"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DesktopAppInfo" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GDesktopAppInfo" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "pid"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Process identifier" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "During invocation, g_desktop_app_info_launch_uris_as_manager() may\ncreate one or more child processes.  This callback is invoked once\nfor each, providing the process ID."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DesktopAppLaunchCallback =
    Ptr Gio.DesktopAppInfo.DesktopAppInfo ->
    Int32 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "appinfo"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DesktopAppInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GDesktopAppInfo" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pid"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Process identifier" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DesktopAppLaunchCallback :: FunPtr C_DesktopAppLaunchCallback -> C_DesktopAppLaunchCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DesktopAppLaunchCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DesktopAppInfo.IsDesktopAppInfo a) =>
    FunPtr C_DesktopAppLaunchCallback
    -> a
    -- ^ /@appinfo@/: a t'GI.Gio.Objects.DesktopAppInfo.DesktopAppInfo'
    -> Int32
    -- ^ /@pid@/: Process identifier
    -> Ptr ()
    -- ^ /@userData@/: User data
    -> m ()
dynamic_DesktopAppLaunchCallback __funPtr appinfo pid userData = liftIO $ do
    appinfo' <- unsafeManagedPtrCastPtr appinfo
    (__dynamic_C_DesktopAppLaunchCallback __funPtr) appinfo' pid userData
    touchManagedPtr appinfo
    return ()

-- | Generate a function pointer callable from C code, from a `C_DesktopAppLaunchCallback`.
foreign import ccall "wrapper"
    mk_DesktopAppLaunchCallback :: C_DesktopAppLaunchCallback -> IO (FunPtr C_DesktopAppLaunchCallback)

-- | During invocation, 'GI.Gio.Objects.DesktopAppInfo.desktopAppInfoLaunchUrisAsManager' may
-- create one or more child processes.  This callback is invoked once
-- for each, providing the process ID.
type DesktopAppLaunchCallback =
    Gio.DesktopAppInfo.DesktopAppInfo
    -- ^ /@appinfo@/: a t'GI.Gio.Objects.DesktopAppInfo.DesktopAppInfo'
    -> Int32
    -- ^ /@pid@/: Process identifier
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DesktopAppLaunchCallback`@.
noDesktopAppLaunchCallback :: Maybe DesktopAppLaunchCallback
noDesktopAppLaunchCallback = Nothing

-- | During invocation, 'GI.Gio.Objects.DesktopAppInfo.desktopAppInfoLaunchUrisAsManager' may
-- create one or more child processes.  This callback is invoked once
-- for each, providing the process ID.
type DesktopAppLaunchCallback_WithClosures =
    Gio.DesktopAppInfo.DesktopAppInfo
    -- ^ /@appinfo@/: a t'GI.Gio.Objects.DesktopAppInfo.DesktopAppInfo'
    -> Int32
    -- ^ /@pid@/: Process identifier
    -> Ptr ()
    -- ^ /@userData@/: User data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DesktopAppLaunchCallback_WithClosures`@.
noDesktopAppLaunchCallback_WithClosures :: Maybe DesktopAppLaunchCallback_WithClosures
noDesktopAppLaunchCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DesktopAppLaunchCallback :: DesktopAppLaunchCallback -> DesktopAppLaunchCallback_WithClosures
drop_closures_DesktopAppLaunchCallback _f appinfo pid _ = _f appinfo pid

-- | Wrap the callback into a `GClosure`.
genClosure_DesktopAppLaunchCallback :: MonadIO m => DesktopAppLaunchCallback -> m (GClosure C_DesktopAppLaunchCallback)
genClosure_DesktopAppLaunchCallback cb = liftIO $ do
    let cb' = drop_closures_DesktopAppLaunchCallback cb
    let cb'' = wrap_DesktopAppLaunchCallback Nothing cb'
    mk_DesktopAppLaunchCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DesktopAppLaunchCallback` into a `C_DesktopAppLaunchCallback`.
wrap_DesktopAppLaunchCallback :: 
    Maybe (Ptr (FunPtr C_DesktopAppLaunchCallback)) ->
    DesktopAppLaunchCallback_WithClosures ->
    C_DesktopAppLaunchCallback
wrap_DesktopAppLaunchCallback gi'funptrptr gi'cb appinfo pid userData = do
    appinfo' <- (newObject Gio.DesktopAppInfo.DesktopAppInfo) appinfo
    gi'cb  appinfo' pid userData
    maybeReleaseFunPtr gi'funptrptr


-- callback DatagramBasedSourceFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%G_SOURCE_REMOVE if the source should be removed,\n  %G_SOURCE_CONTINUE otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "datagram_based"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DatagramBased" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GDatagramBased"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "condition"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOCondition" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the current condition at the source fired"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed in by the user"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This is the function type of the callback used for the #GSource\nreturned by g_datagram_based_create_source()."
        , sinceVersion = Just "2.48"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DatagramBasedSourceFunc =
    Ptr Gio.DatagramBased.DatagramBased ->
    CUInt ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "datagram_based"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DatagramBased" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GDatagramBased"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "condition"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the current condition at the source fired"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed in by the user"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DatagramBasedSourceFunc :: FunPtr C_DatagramBasedSourceFunc -> C_DatagramBasedSourceFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DatagramBasedSourceFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DatagramBased.IsDatagramBased a) =>
    FunPtr C_DatagramBasedSourceFunc
    -> a
    -- ^ /@datagramBased@/: the t'GI.Gio.Interfaces.DatagramBased.DatagramBased'
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the current condition at the source fired
    -> Ptr ()
    -- ^ /@data@/: data passed in by the user
    -> m Bool
    -- ^ __Returns:__ 'GI.GLib.Constants.SOURCE_REMOVE' if the source should be removed,
    --   'GI.GLib.Constants.SOURCE_CONTINUE' otherwise
dynamic_DatagramBasedSourceFunc __funPtr datagramBased condition data_ = liftIO $ do
    datagramBased' <- unsafeManagedPtrCastPtr datagramBased
    let condition' = gflagsToWord condition
    result <- (__dynamic_C_DatagramBasedSourceFunc __funPtr) datagramBased' condition' data_
    let result' = (/= 0) result
    touchManagedPtr datagramBased
    return result'

-- | Generate a function pointer callable from C code, from a `C_DatagramBasedSourceFunc`.
foreign import ccall "wrapper"
    mk_DatagramBasedSourceFunc :: C_DatagramBasedSourceFunc -> IO (FunPtr C_DatagramBasedSourceFunc)

-- | This is the function type of the callback used for the t'GI.GLib.Structs.Source.Source'
-- returned by 'GI.Gio.Interfaces.DatagramBased.datagramBasedCreateSource'.
-- 
-- /Since: 2.48/
type DatagramBasedSourceFunc =
    Gio.DatagramBased.DatagramBased
    -- ^ /@datagramBased@/: the t'GI.Gio.Interfaces.DatagramBased.DatagramBased'
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the current condition at the source fired
    -> IO Bool
    -- ^ __Returns:__ 'GI.GLib.Constants.SOURCE_REMOVE' if the source should be removed,
    --   'GI.GLib.Constants.SOURCE_CONTINUE' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `DatagramBasedSourceFunc`@.
noDatagramBasedSourceFunc :: Maybe DatagramBasedSourceFunc
noDatagramBasedSourceFunc = Nothing

-- | This is the function type of the callback used for the t'GI.GLib.Structs.Source.Source'
-- returned by 'GI.Gio.Interfaces.DatagramBased.datagramBasedCreateSource'.
-- 
-- /Since: 2.48/
type DatagramBasedSourceFunc_WithClosures =
    Gio.DatagramBased.DatagramBased
    -- ^ /@datagramBased@/: the t'GI.Gio.Interfaces.DatagramBased.DatagramBased'
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the current condition at the source fired
    -> Ptr ()
    -- ^ /@data@/: data passed in by the user
    -> IO Bool
    -- ^ __Returns:__ 'GI.GLib.Constants.SOURCE_REMOVE' if the source should be removed,
    --   'GI.GLib.Constants.SOURCE_CONTINUE' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `DatagramBasedSourceFunc_WithClosures`@.
noDatagramBasedSourceFunc_WithClosures :: Maybe DatagramBasedSourceFunc_WithClosures
noDatagramBasedSourceFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DatagramBasedSourceFunc :: DatagramBasedSourceFunc -> DatagramBasedSourceFunc_WithClosures
drop_closures_DatagramBasedSourceFunc _f datagramBased condition _ = _f datagramBased condition

-- | Wrap the callback into a `GClosure`.
genClosure_DatagramBasedSourceFunc :: MonadIO m => DatagramBasedSourceFunc -> m (GClosure C_DatagramBasedSourceFunc)
genClosure_DatagramBasedSourceFunc cb = liftIO $ do
    let cb' = drop_closures_DatagramBasedSourceFunc cb
    let cb'' = wrap_DatagramBasedSourceFunc Nothing cb'
    mk_DatagramBasedSourceFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DatagramBasedSourceFunc` into a `C_DatagramBasedSourceFunc`.
wrap_DatagramBasedSourceFunc :: 
    Maybe (Ptr (FunPtr C_DatagramBasedSourceFunc)) ->
    DatagramBasedSourceFunc_WithClosures ->
    C_DatagramBasedSourceFunc
wrap_DatagramBasedSourceFunc gi'funptrptr gi'cb datagramBased condition data_ = do
    datagramBased' <- (newObject Gio.DatagramBased.DatagramBased) datagramBased
    let condition' = wordToGFlags condition
    result <- gi'cb  datagramBased' condition' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback DBusSubtreeIntrospectFunc
{- Callable
  { returnType =
      Just
        (TCArray
           True
           (-1)
           (-1)
           (TInterface
              Name { namespace = "Gio" , name = "DBusInterfaceInfo" }))
  , returnMayBeNull = True
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "A %NULL-terminated array of pointers to #GDBusInterfaceInfo, or %NULL."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GDBusConnection."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "sender"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The unique bus name of the remote caller."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "object_path"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The object path that was registered with g_dbus_connection_register_subtree()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "node"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "A node that is a child of @object_path (relative to @object_path) or %NULL for the root of the subtree."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The @user_data #gpointer passed to g_dbus_connection_register_subtree()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the @introspect function in #GDBusSubtreeVTable.\n\nSubtrees are flat.  @node, if non-%NULL, is always exactly one\nsegment of the object path (ie: it never contains a slash).\n\nThis function should return %NULL to indicate that there is no object\nat this node.\n\nIf this function returns non-%NULL, the return value is expected to\nbe a %NULL-terminated array of pointers to #GDBusInterfaceInfo\nstructures describing the interfaces implemented by @node.  This\narray will have g_dbus_interface_info_unref() called on each item\nbefore being freed with g_free().\n\nThe difference between returning %NULL and an array containing zero\nitems is that the standard DBus interfaces will returned to the\nremote introspector in the empty array case, but not in the %NULL\ncase."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DBusSubtreeIntrospectFunc =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    CString ->
    CString ->
    Ptr () ->
    IO (Ptr (Ptr Gio.DBusInterfaceInfo.DBusInterfaceInfo))

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sender"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The unique bus name of the remote caller."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The object path that was registered with g_dbus_connection_register_subtree()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "node"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A node that is a child of @object_path (relative to @object_path) or %NULL for the root of the subtree."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The @user_data #gpointer passed to g_dbus_connection_register_subtree()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TCArray
--                  True
--                  (-1)
--                  (-1)
--                  (TInterface
--                     Name { namespace = "Gio" , name = "DBusInterfaceInfo" }))
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DBusSubtreeIntrospectFunc :: FunPtr C_DBusSubtreeIntrospectFunc -> C_DBusSubtreeIntrospectFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DBusSubtreeIntrospectFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_DBusSubtreeIntrospectFunc
    -> a
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller.
    -> T.Text
    -- ^ /@objectPath@/: The object path that was registered with 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> T.Text
    -- ^ /@node@/: A node that is a child of /@objectPath@/ (relative to /@objectPath@/) or 'P.Nothing' for the root of the subtree.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> m (Maybe [Gio.DBusInterfaceInfo.DBusInterfaceInfo])
    -- ^ __Returns:__ A 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusInterfaceInfo.DBusInterfaceInfo', or 'P.Nothing'.
dynamic_DBusSubtreeIntrospectFunc __funPtr connection sender objectPath node userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    sender' <- textToCString sender
    objectPath' <- textToCString objectPath
    node' <- textToCString node
    result <- (__dynamic_C_DBusSubtreeIntrospectFunc __funPtr) connection' sender' objectPath' node' userData
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- unpackZeroTerminatedPtrArray result'
        result''' <- mapM (wrapBoxed Gio.DBusInterfaceInfo.DBusInterfaceInfo) result''
        freeMem result'
        return result'''
    touchManagedPtr connection
    freeMem sender'
    freeMem objectPath'
    freeMem node'
    return maybeResult

-- | Generate a function pointer callable from C code, from a `C_DBusSubtreeIntrospectFunc`.
foreign import ccall "wrapper"
    mk_DBusSubtreeIntrospectFunc :: C_DBusSubtreeIntrospectFunc -> IO (FunPtr C_DBusSubtreeIntrospectFunc)

-- | The type of the /@introspect@/ function in t'GI.Gio.Structs.DBusSubtreeVTable.DBusSubtreeVTable'.
-- 
-- Subtrees are flat.  /@node@/, if non-'P.Nothing', is always exactly one
-- segment of the object path (ie: it never contains a slash).
-- 
-- This function should return 'P.Nothing' to indicate that there is no object
-- at this node.
-- 
-- If this function returns non-'P.Nothing', the return value is expected to
-- be a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusInterfaceInfo.DBusInterfaceInfo'
-- structures describing the interfaces implemented by /@node@/.  This
-- array will have 'GI.Gio.Structs.DBusInterfaceInfo.dBusInterfaceInfoUnref' called on each item
-- before being freed with 'GI.GLib.Functions.free'.
-- 
-- The difference between returning 'P.Nothing' and an array containing zero
-- items is that the standard DBus interfaces will returned to the
-- remote introspector in the empty array case, but not in the 'P.Nothing'
-- case.
-- 
-- /Since: 2.26/
type DBusSubtreeIntrospectFunc =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller.
    -> T.Text
    -- ^ /@objectPath@/: The object path that was registered with 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> T.Text
    -- ^ /@node@/: A node that is a child of /@objectPath@/ (relative to /@objectPath@/) or 'P.Nothing' for the root of the subtree.
    -> IO (Maybe [Gio.DBusInterfaceInfo.DBusInterfaceInfo])
    -- ^ __Returns:__ A 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusInterfaceInfo.DBusInterfaceInfo', or 'P.Nothing'.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusSubtreeIntrospectFunc`@.
noDBusSubtreeIntrospectFunc :: Maybe DBusSubtreeIntrospectFunc
noDBusSubtreeIntrospectFunc = Nothing

-- | The type of the /@introspect@/ function in t'GI.Gio.Structs.DBusSubtreeVTable.DBusSubtreeVTable'.
-- 
-- Subtrees are flat.  /@node@/, if non-'P.Nothing', is always exactly one
-- segment of the object path (ie: it never contains a slash).
-- 
-- This function should return 'P.Nothing' to indicate that there is no object
-- at this node.
-- 
-- If this function returns non-'P.Nothing', the return value is expected to
-- be a 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusInterfaceInfo.DBusInterfaceInfo'
-- structures describing the interfaces implemented by /@node@/.  This
-- array will have 'GI.Gio.Structs.DBusInterfaceInfo.dBusInterfaceInfoUnref' called on each item
-- before being freed with 'GI.GLib.Functions.free'.
-- 
-- The difference between returning 'P.Nothing' and an array containing zero
-- items is that the standard DBus interfaces will returned to the
-- remote introspector in the empty array case, but not in the 'P.Nothing'
-- case.
-- 
-- /Since: 2.26/
type DBusSubtreeIntrospectFunc_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller.
    -> T.Text
    -- ^ /@objectPath@/: The object path that was registered with 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> T.Text
    -- ^ /@node@/: A node that is a child of /@objectPath@/ (relative to /@objectPath@/) or 'P.Nothing' for the root of the subtree.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> IO (Maybe [Gio.DBusInterfaceInfo.DBusInterfaceInfo])
    -- ^ __Returns:__ A 'P.Nothing'-terminated array of pointers to t'GI.Gio.Structs.DBusInterfaceInfo.DBusInterfaceInfo', or 'P.Nothing'.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusSubtreeIntrospectFunc_WithClosures`@.
noDBusSubtreeIntrospectFunc_WithClosures :: Maybe DBusSubtreeIntrospectFunc_WithClosures
noDBusSubtreeIntrospectFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DBusSubtreeIntrospectFunc :: DBusSubtreeIntrospectFunc -> DBusSubtreeIntrospectFunc_WithClosures
drop_closures_DBusSubtreeIntrospectFunc _f connection sender objectPath node _ = _f connection sender objectPath node

-- | Wrap the callback into a `GClosure`.
genClosure_DBusSubtreeIntrospectFunc :: MonadIO m => DBusSubtreeIntrospectFunc -> m (GClosure C_DBusSubtreeIntrospectFunc)
genClosure_DBusSubtreeIntrospectFunc cb = liftIO $ do
    let cb' = drop_closures_DBusSubtreeIntrospectFunc cb
    let cb'' = wrap_DBusSubtreeIntrospectFunc Nothing cb'
    mk_DBusSubtreeIntrospectFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DBusSubtreeIntrospectFunc` into a `C_DBusSubtreeIntrospectFunc`.
wrap_DBusSubtreeIntrospectFunc :: 
    Maybe (Ptr (FunPtr C_DBusSubtreeIntrospectFunc)) ->
    DBusSubtreeIntrospectFunc_WithClosures ->
    C_DBusSubtreeIntrospectFunc
wrap_DBusSubtreeIntrospectFunc gi'funptrptr gi'cb connection sender objectPath node userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    sender' <- cstringToText sender
    objectPath' <- cstringToText objectPath
    node' <- cstringToText node
    result <- gi'cb  connection' sender' objectPath' node' userData
    maybeReleaseFunPtr gi'funptrptr
    maybeM FP.nullPtr result $ \result' -> do
        result'' <- mapM B.ManagedPtr.disownBoxed result'
        result''' <- packZeroTerminatedPtrArray result''
        return result'''


-- callback DBusSubtreeEnumerateFunc
{- Callable
  { returnType = Just (TCArray True (-1) (-1) (TBasicType TUTF8))
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "A newly allocated array of strings for node names that are children of @object_path."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GDBusConnection."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "sender"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The unique bus name of the remote caller."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "object_path"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The object path that was registered with g_dbus_connection_register_subtree()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The @user_data #gpointer passed to g_dbus_connection_register_subtree()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the @enumerate function in #GDBusSubtreeVTable.\n\nThis function is called when generating introspection data and also\nwhen preparing to dispatch incoming messages in the event that the\n%G_DBUS_SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES flag is not\nspecified (ie: to verify that the object path is valid).\n\nHierarchies are not supported; the items that you return should not\ncontain the `/` character.\n\nThe return value will be freed with g_strfreev()."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DBusSubtreeEnumerateFunc =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    CString ->
    Ptr () ->
    IO (Ptr CString)

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sender"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The unique bus name of the remote caller."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The object path that was registered with g_dbus_connection_register_subtree()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The @user_data #gpointer passed to g_dbus_connection_register_subtree()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DBusSubtreeEnumerateFunc :: FunPtr C_DBusSubtreeEnumerateFunc -> C_DBusSubtreeEnumerateFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DBusSubtreeEnumerateFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_DBusSubtreeEnumerateFunc
    -> a
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller.
    -> T.Text
    -- ^ /@objectPath@/: The object path that was registered with 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> m [T.Text]
    -- ^ __Returns:__ A newly allocated array of strings for node names that are children of /@objectPath@/.
dynamic_DBusSubtreeEnumerateFunc __funPtr connection sender objectPath userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    sender' <- textToCString sender
    objectPath' <- textToCString objectPath
    result <- (__dynamic_C_DBusSubtreeEnumerateFunc __funPtr) connection' sender' objectPath' userData
    checkUnexpectedReturnNULL "dBusSubtreeEnumerateFunc" result
    result' <- unpackZeroTerminatedUTF8CArray result
    mapZeroTerminatedCArray freeMem result
    freeMem result
    touchManagedPtr connection
    freeMem sender'
    freeMem objectPath'
    return result'

-- | Generate a function pointer callable from C code, from a `C_DBusSubtreeEnumerateFunc`.
foreign import ccall "wrapper"
    mk_DBusSubtreeEnumerateFunc :: C_DBusSubtreeEnumerateFunc -> IO (FunPtr C_DBusSubtreeEnumerateFunc)

-- | The type of the /@enumerate@/ function in t'GI.Gio.Structs.DBusSubtreeVTable.DBusSubtreeVTable'.
-- 
-- This function is called when generating introspection data and also
-- when preparing to dispatch incoming messages in the event that the
-- 'GI.Gio.Flags.DBusSubtreeFlagsDispatchToUnenumeratedNodes' flag is not
-- specified (ie: to verify that the object path is valid).
-- 
-- Hierarchies are not supported; the items that you return should not
-- contain the @\/@ character.
-- 
-- The return value will be freed with 'GI.GLib.Functions.strfreev'.
-- 
-- /Since: 2.26/
type DBusSubtreeEnumerateFunc =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller.
    -> T.Text
    -- ^ /@objectPath@/: The object path that was registered with 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> IO [T.Text]
    -- ^ __Returns:__ A newly allocated array of strings for node names that are children of /@objectPath@/.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusSubtreeEnumerateFunc`@.
noDBusSubtreeEnumerateFunc :: Maybe DBusSubtreeEnumerateFunc
noDBusSubtreeEnumerateFunc = Nothing

-- | The type of the /@enumerate@/ function in t'GI.Gio.Structs.DBusSubtreeVTable.DBusSubtreeVTable'.
-- 
-- This function is called when generating introspection data and also
-- when preparing to dispatch incoming messages in the event that the
-- 'GI.Gio.Flags.DBusSubtreeFlagsDispatchToUnenumeratedNodes' flag is not
-- specified (ie: to verify that the object path is valid).
-- 
-- Hierarchies are not supported; the items that you return should not
-- contain the @\/@ character.
-- 
-- The return value will be freed with 'GI.GLib.Functions.strfreev'.
-- 
-- /Since: 2.26/
type DBusSubtreeEnumerateFunc_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller.
    -> T.Text
    -- ^ /@objectPath@/: The object path that was registered with 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> IO [T.Text]
    -- ^ __Returns:__ A newly allocated array of strings for node names that are children of /@objectPath@/.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusSubtreeEnumerateFunc_WithClosures`@.
noDBusSubtreeEnumerateFunc_WithClosures :: Maybe DBusSubtreeEnumerateFunc_WithClosures
noDBusSubtreeEnumerateFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DBusSubtreeEnumerateFunc :: DBusSubtreeEnumerateFunc -> DBusSubtreeEnumerateFunc_WithClosures
drop_closures_DBusSubtreeEnumerateFunc _f connection sender objectPath _ = _f connection sender objectPath

-- | Wrap the callback into a `GClosure`.
genClosure_DBusSubtreeEnumerateFunc :: MonadIO m => DBusSubtreeEnumerateFunc -> m (GClosure C_DBusSubtreeEnumerateFunc)
genClosure_DBusSubtreeEnumerateFunc cb = liftIO $ do
    let cb' = drop_closures_DBusSubtreeEnumerateFunc cb
    let cb'' = wrap_DBusSubtreeEnumerateFunc Nothing cb'
    mk_DBusSubtreeEnumerateFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DBusSubtreeEnumerateFunc` into a `C_DBusSubtreeEnumerateFunc`.
wrap_DBusSubtreeEnumerateFunc :: 
    Maybe (Ptr (FunPtr C_DBusSubtreeEnumerateFunc)) ->
    DBusSubtreeEnumerateFunc_WithClosures ->
    C_DBusSubtreeEnumerateFunc
wrap_DBusSubtreeEnumerateFunc gi'funptrptr gi'cb connection sender objectPath userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    sender' <- cstringToText sender
    objectPath' <- cstringToText objectPath
    result <- gi'cb  connection' sender' objectPath' userData
    maybeReleaseFunPtr gi'funptrptr
    result' <- packZeroTerminatedUTF8CArray result
    return result'


-- callback DBusSubtreeDispatchFunc
{- Callable
  { returnType =
      Just
        (TInterface
           Name { namespace = "Gio" , name = "DBusInterfaceVTable" })
  , returnMayBeNull = True
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "A #GDBusInterfaceVTable or %NULL if you don't want to handle the methods."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GDBusConnection."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "sender"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The unique bus name of the remote caller."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "object_path"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The object path that was registered with g_dbus_connection_register_subtree()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "interface_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The D-Bus interface name that the method call or property access is for."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "node"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "A node that is a child of @object_path (relative to @object_path) or %NULL for the root of the subtree."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "out_user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "Return location for user data to pass to functions in the returned #GDBusInterfaceVTable."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The @user_data #gpointer passed to g_dbus_connection_register_subtree()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the @dispatch function in #GDBusSubtreeVTable.\n\nSubtrees are flat.  @node, if non-%NULL, is always exactly one\nsegment of the object path (ie: it never contains a slash)."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DBusSubtreeDispatchFunc =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    CString ->
    CString ->
    CString ->
    Ptr () ->
    Ptr () ->
    IO (Ptr Gio.DBusInterfaceVTable.DBusInterfaceVTable)

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sender"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The unique bus name of the remote caller."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The object path that was registered with g_dbus_connection_register_subtree()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The D-Bus interface name that the method call or property access is for."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "node"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A node that is a child of @object_path (relative to @object_path) or %NULL for the root of the subtree."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "out_user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Return location for user data to pass to functions in the returned #GDBusInterfaceVTable."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The @user_data #gpointer passed to g_dbus_connection_register_subtree()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "DBusInterfaceVTable" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DBusSubtreeDispatchFunc :: FunPtr C_DBusSubtreeDispatchFunc -> C_DBusSubtreeDispatchFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DBusSubtreeDispatchFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_DBusSubtreeDispatchFunc
    -> a
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller.
    -> T.Text
    -- ^ /@objectPath@/: The object path that was registered with 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name that the method call or property access is for.
    -> T.Text
    -- ^ /@node@/: A node that is a child of /@objectPath@/ (relative to /@objectPath@/) or 'P.Nothing' for the root of the subtree.
    -> Ptr ()
    -- ^ /@outUserData@/: Return location for user data to pass to functions in the returned t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable'.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> m (Maybe Gio.DBusInterfaceVTable.DBusInterfaceVTable)
    -- ^ __Returns:__ A t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable' or 'P.Nothing' if you don\'t want to handle the methods.
dynamic_DBusSubtreeDispatchFunc __funPtr connection sender objectPath interfaceName node outUserData userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    sender' <- textToCString sender
    objectPath' <- textToCString objectPath
    interfaceName' <- textToCString interfaceName
    node' <- textToCString node
    result <- (__dynamic_C_DBusSubtreeDispatchFunc __funPtr) connection' sender' objectPath' interfaceName' node' outUserData userData
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Gio.DBusInterfaceVTable.DBusInterfaceVTable) result'
        return result''
    touchManagedPtr connection
    freeMem sender'
    freeMem objectPath'
    freeMem interfaceName'
    freeMem node'
    return maybeResult

-- | Generate a function pointer callable from C code, from a `C_DBusSubtreeDispatchFunc`.
foreign import ccall "wrapper"
    mk_DBusSubtreeDispatchFunc :: C_DBusSubtreeDispatchFunc -> IO (FunPtr C_DBusSubtreeDispatchFunc)

-- | The type of the /@dispatch@/ function in t'GI.Gio.Structs.DBusSubtreeVTable.DBusSubtreeVTable'.
-- 
-- Subtrees are flat.  /@node@/, if non-'P.Nothing', is always exactly one
-- segment of the object path (ie: it never contains a slash).
-- 
-- /Since: 2.26/
type DBusSubtreeDispatchFunc =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller.
    -> T.Text
    -- ^ /@objectPath@/: The object path that was registered with 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name that the method call or property access is for.
    -> T.Text
    -- ^ /@node@/: A node that is a child of /@objectPath@/ (relative to /@objectPath@/) or 'P.Nothing' for the root of the subtree.
    -> Ptr ()
    -- ^ /@outUserData@/: Return location for user data to pass to functions in the returned t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable'.
    -> IO (Maybe Gio.DBusInterfaceVTable.DBusInterfaceVTable)
    -- ^ __Returns:__ A t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable' or 'P.Nothing' if you don\'t want to handle the methods.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusSubtreeDispatchFunc`@.
noDBusSubtreeDispatchFunc :: Maybe DBusSubtreeDispatchFunc
noDBusSubtreeDispatchFunc = Nothing

-- | The type of the /@dispatch@/ function in t'GI.Gio.Structs.DBusSubtreeVTable.DBusSubtreeVTable'.
-- 
-- Subtrees are flat.  /@node@/, if non-'P.Nothing', is always exactly one
-- segment of the object path (ie: it never contains a slash).
-- 
-- /Since: 2.26/
type DBusSubtreeDispatchFunc_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller.
    -> T.Text
    -- ^ /@objectPath@/: The object path that was registered with 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name that the method call or property access is for.
    -> T.Text
    -- ^ /@node@/: A node that is a child of /@objectPath@/ (relative to /@objectPath@/) or 'P.Nothing' for the root of the subtree.
    -> Ptr ()
    -- ^ /@outUserData@/: Return location for user data to pass to functions in the returned t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable'.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to 'GI.Gio.Objects.DBusConnection.dBusConnectionRegisterSubtree'.
    -> IO (Maybe Gio.DBusInterfaceVTable.DBusInterfaceVTable)
    -- ^ __Returns:__ A t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable' or 'P.Nothing' if you don\'t want to handle the methods.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusSubtreeDispatchFunc_WithClosures`@.
noDBusSubtreeDispatchFunc_WithClosures :: Maybe DBusSubtreeDispatchFunc_WithClosures
noDBusSubtreeDispatchFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DBusSubtreeDispatchFunc :: DBusSubtreeDispatchFunc -> DBusSubtreeDispatchFunc_WithClosures
drop_closures_DBusSubtreeDispatchFunc _f connection sender objectPath interfaceName node outUserData _ = _f connection sender objectPath interfaceName node outUserData

-- | Wrap the callback into a `GClosure`.
genClosure_DBusSubtreeDispatchFunc :: MonadIO m => DBusSubtreeDispatchFunc -> m (GClosure C_DBusSubtreeDispatchFunc)
genClosure_DBusSubtreeDispatchFunc cb = liftIO $ do
    let cb' = drop_closures_DBusSubtreeDispatchFunc cb
    let cb'' = wrap_DBusSubtreeDispatchFunc Nothing cb'
    mk_DBusSubtreeDispatchFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DBusSubtreeDispatchFunc` into a `C_DBusSubtreeDispatchFunc`.
wrap_DBusSubtreeDispatchFunc :: 
    Maybe (Ptr (FunPtr C_DBusSubtreeDispatchFunc)) ->
    DBusSubtreeDispatchFunc_WithClosures ->
    C_DBusSubtreeDispatchFunc
wrap_DBusSubtreeDispatchFunc gi'funptrptr gi'cb connection sender objectPath interfaceName node outUserData userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    sender' <- cstringToText sender
    objectPath' <- cstringToText objectPath
    interfaceName' <- cstringToText interfaceName
    node' <- cstringToText node
    result <- gi'cb  connection' sender' objectPath' interfaceName' node' outUserData userData
    maybeReleaseFunPtr gi'funptrptr
    maybeM FP.nullPtr result $ \result' -> do
        result'' <- unsafeManagedPtrGetPtr result'
        return result''


-- callback DBusSignalCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GDBusConnection."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "sender_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The unique bus name of the sender of the signal,\n   or %NULL on a peer-to-peer D-Bus connection."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "object_path"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The object path that the signal was emitted on."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "interface_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The name of the interface."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "signal_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The name of the signal."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "parameters"
          , argType = TVariant
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "A #GVariant tuple with parameters for the signal."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "User data passed when subscribing to the signal."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Signature for callback function used in g_dbus_connection_signal_subscribe()."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DBusSignalCallback =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    CString ->
    CString ->
    CString ->
    Ptr GVariant ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sender_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The unique bus name of the sender of the signal,\n   or %NULL on a peer-to-peer D-Bus connection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The object path that the signal was emitted on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name of the interface."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name of the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parameters"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "A #GVariant tuple with parameters for the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "User data passed when subscribing to the signal."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DBusSignalCallback :: FunPtr C_DBusSignalCallback -> C_DBusSignalCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DBusSignalCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_DBusSignalCallback
    -> a
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe (T.Text)
    -- ^ /@senderName@/: The unique bus name of the sender of the signal,
    --    or 'P.Nothing' on a peer-to-peer D-Bus connection.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the signal was emitted on.
    -> T.Text
    -- ^ /@interfaceName@/: The name of the interface.
    -> T.Text
    -- ^ /@signalName@/: The name of the signal.
    -> GVariant
    -- ^ /@parameters@/: A t'GVariant' tuple with parameters for the signal.
    -> Ptr ()
    -- ^ /@userData@/: User data passed when subscribing to the signal.
    -> m ()
dynamic_DBusSignalCallback __funPtr connection senderName objectPath interfaceName signalName parameters userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeSenderName <- case senderName of
        Nothing -> return FP.nullPtr
        Just jSenderName -> do
            jSenderName' <- textToCString jSenderName
            return jSenderName'
    objectPath' <- textToCString objectPath
    interfaceName' <- textToCString interfaceName
    signalName' <- textToCString signalName
    parameters' <- unsafeManagedPtrGetPtr parameters
    (__dynamic_C_DBusSignalCallback __funPtr) connection' maybeSenderName objectPath' interfaceName' signalName' parameters' userData
    touchManagedPtr connection
    touchManagedPtr parameters
    freeMem maybeSenderName
    freeMem objectPath'
    freeMem interfaceName'
    freeMem signalName'
    return ()

-- | Generate a function pointer callable from C code, from a `C_DBusSignalCallback`.
foreign import ccall "wrapper"
    mk_DBusSignalCallback :: C_DBusSignalCallback -> IO (FunPtr C_DBusSignalCallback)

-- | Signature for callback function used in 'GI.Gio.Objects.DBusConnection.dBusConnectionSignalSubscribe'.
-- 
-- /Since: 2.26/
type DBusSignalCallback =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe T.Text
    -- ^ /@senderName@/: The unique bus name of the sender of the signal,
    --    or 'P.Nothing' on a peer-to-peer D-Bus connection.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the signal was emitted on.
    -> T.Text
    -- ^ /@interfaceName@/: The name of the interface.
    -> T.Text
    -- ^ /@signalName@/: The name of the signal.
    -> GVariant
    -- ^ /@parameters@/: A t'GVariant' tuple with parameters for the signal.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusSignalCallback`@.
noDBusSignalCallback :: Maybe DBusSignalCallback
noDBusSignalCallback = Nothing

-- | Signature for callback function used in 'GI.Gio.Objects.DBusConnection.dBusConnectionSignalSubscribe'.
-- 
-- /Since: 2.26/
type DBusSignalCallback_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe T.Text
    -- ^ /@senderName@/: The unique bus name of the sender of the signal,
    --    or 'P.Nothing' on a peer-to-peer D-Bus connection.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the signal was emitted on.
    -> T.Text
    -- ^ /@interfaceName@/: The name of the interface.
    -> T.Text
    -- ^ /@signalName@/: The name of the signal.
    -> GVariant
    -- ^ /@parameters@/: A t'GVariant' tuple with parameters for the signal.
    -> Ptr ()
    -- ^ /@userData@/: User data passed when subscribing to the signal.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusSignalCallback_WithClosures`@.
noDBusSignalCallback_WithClosures :: Maybe DBusSignalCallback_WithClosures
noDBusSignalCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DBusSignalCallback :: DBusSignalCallback -> DBusSignalCallback_WithClosures
drop_closures_DBusSignalCallback _f connection senderName objectPath interfaceName signalName parameters _ = _f connection senderName objectPath interfaceName signalName parameters

-- | Wrap the callback into a `GClosure`.
genClosure_DBusSignalCallback :: MonadIO m => DBusSignalCallback -> m (GClosure C_DBusSignalCallback)
genClosure_DBusSignalCallback cb = liftIO $ do
    let cb' = drop_closures_DBusSignalCallback cb
    let cb'' = wrap_DBusSignalCallback Nothing cb'
    mk_DBusSignalCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DBusSignalCallback` into a `C_DBusSignalCallback`.
wrap_DBusSignalCallback :: 
    Maybe (Ptr (FunPtr C_DBusSignalCallback)) ->
    DBusSignalCallback_WithClosures ->
    C_DBusSignalCallback
wrap_DBusSignalCallback gi'funptrptr gi'cb connection senderName objectPath interfaceName signalName parameters userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    maybeSenderName <-
        if senderName == FP.nullPtr
        then return Nothing
        else do
            senderName' <- cstringToText senderName
            return $ Just senderName'
    objectPath' <- cstringToText objectPath
    interfaceName' <- cstringToText interfaceName
    signalName' <- cstringToText signalName
    parameters' <- B.GVariant.newGVariantFromPtr parameters
    gi'cb  connection' maybeSenderName objectPath' interfaceName' signalName' parameters' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback DBusProxyTypeFunc
{- Callable
  { returnType = Just (TBasicType TGType)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "A #GType to use for the remote object. The returned type\n  must be a #GDBusProxy or #GDBusObjectProxy -derived\n  type."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "manager"
          , argType =
              TInterface
                Name { namespace = "Gio" , name = "DBusObjectManagerClient" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GDBusObjectManagerClient."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "object_path"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The object path of the remote object."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "interface_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The interface name of the remote object or %NULL if a #GDBusObjectProxy #GType is requested."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed in by the user."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Function signature for a function used to determine the #GType to\nuse for an interface proxy (if @interface_name is not %NULL) or\nobject proxy (if @interface_name is %NULL).\n\nThis function is called in the thread-default main context\n(see [method@GLib.MainContext.push_thread_default])\nthat @manager was constructed in."
        , sinceVersion = Just "2.30"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DBusProxyTypeFunc =
    Ptr Gio.DBusObjectManagerClient.DBusObjectManagerClient ->
    CString ->
    CString ->
    Ptr () ->
    IO CGType

-- Args: [ Arg
--           { argCName = "manager"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DBusObjectManagerClient" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectManagerClient."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The object path of the remote object."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The interface name of the remote object or %NULL if a #GDBusObjectProxy #GType is requested."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed in by the user."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DBusProxyTypeFunc :: FunPtr C_DBusProxyTypeFunc -> C_DBusProxyTypeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DBusProxyTypeFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusObjectManagerClient.IsDBusObjectManagerClient a) =>
    FunPtr C_DBusProxyTypeFunc
    -> a
    -- ^ /@manager@/: A t'GI.Gio.Objects.DBusObjectManagerClient.DBusObjectManagerClient'.
    -> T.Text
    -- ^ /@objectPath@/: The object path of the remote object.
    -> Maybe (T.Text)
    -- ^ /@interfaceName@/: The interface name of the remote object or 'P.Nothing' if a t'GI.Gio.Objects.DBusObjectProxy.DBusObjectProxy' t'GType' is requested.
    -> Ptr ()
    -- ^ /@data@/: data passed in by the user.
    -> m GType
    -- ^ __Returns:__ A t'GType' to use for the remote object. The returned type
    --   must be a t'GI.Gio.Objects.DBusProxy.DBusProxy' or t'GI.Gio.Objects.DBusObjectProxy.DBusObjectProxy' -derived
    --   type.
dynamic_DBusProxyTypeFunc __funPtr manager objectPath interfaceName data_ = liftIO $ do
    manager' <- unsafeManagedPtrCastPtr manager
    objectPath' <- textToCString objectPath
    maybeInterfaceName <- case interfaceName of
        Nothing -> return FP.nullPtr
        Just jInterfaceName -> do
            jInterfaceName' <- textToCString jInterfaceName
            return jInterfaceName'
    result <- (__dynamic_C_DBusProxyTypeFunc __funPtr) manager' objectPath' maybeInterfaceName data_
    let result' = GType result
    touchManagedPtr manager
    freeMem objectPath'
    freeMem maybeInterfaceName
    return result'

-- | Generate a function pointer callable from C code, from a `C_DBusProxyTypeFunc`.
foreign import ccall "wrapper"
    mk_DBusProxyTypeFunc :: C_DBusProxyTypeFunc -> IO (FunPtr C_DBusProxyTypeFunc)

-- | Function signature for a function used to determine the t'GType' to
-- use for an interface proxy (if /@interfaceName@/ is not 'P.Nothing') or
-- object proxy (if /@interfaceName@/ is 'P.Nothing').
-- 
-- This function is called in the thread-default main context
-- (see 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault')
-- that /@manager@/ was constructed in.
-- 
-- /Since: 2.30/
type DBusProxyTypeFunc =
    Gio.DBusObjectManagerClient.DBusObjectManagerClient
    -- ^ /@manager@/: A t'GI.Gio.Objects.DBusObjectManagerClient.DBusObjectManagerClient'.
    -> T.Text
    -- ^ /@objectPath@/: The object path of the remote object.
    -> Maybe T.Text
    -- ^ /@interfaceName@/: The interface name of the remote object or 'P.Nothing' if a t'GI.Gio.Objects.DBusObjectProxy.DBusObjectProxy' t'GType' is requested.
    -> IO GType
    -- ^ __Returns:__ A t'GType' to use for the remote object. The returned type
    --   must be a t'GI.Gio.Objects.DBusProxy.DBusProxy' or t'GI.Gio.Objects.DBusObjectProxy.DBusObjectProxy' -derived
    --   type.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusProxyTypeFunc`@.
noDBusProxyTypeFunc :: Maybe DBusProxyTypeFunc
noDBusProxyTypeFunc = Nothing

-- | Function signature for a function used to determine the t'GType' to
-- use for an interface proxy (if /@interfaceName@/ is not 'P.Nothing') or
-- object proxy (if /@interfaceName@/ is 'P.Nothing').
-- 
-- This function is called in the thread-default main context
-- (see 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault')
-- that /@manager@/ was constructed in.
-- 
-- /Since: 2.30/
type DBusProxyTypeFunc_WithClosures =
    Gio.DBusObjectManagerClient.DBusObjectManagerClient
    -- ^ /@manager@/: A t'GI.Gio.Objects.DBusObjectManagerClient.DBusObjectManagerClient'.
    -> T.Text
    -- ^ /@objectPath@/: The object path of the remote object.
    -> Maybe T.Text
    -- ^ /@interfaceName@/: The interface name of the remote object or 'P.Nothing' if a t'GI.Gio.Objects.DBusObjectProxy.DBusObjectProxy' t'GType' is requested.
    -> Ptr ()
    -- ^ /@data@/: data passed in by the user.
    -> IO GType
    -- ^ __Returns:__ A t'GType' to use for the remote object. The returned type
    --   must be a t'GI.Gio.Objects.DBusProxy.DBusProxy' or t'GI.Gio.Objects.DBusObjectProxy.DBusObjectProxy' -derived
    --   type.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusProxyTypeFunc_WithClosures`@.
noDBusProxyTypeFunc_WithClosures :: Maybe DBusProxyTypeFunc_WithClosures
noDBusProxyTypeFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DBusProxyTypeFunc :: DBusProxyTypeFunc -> DBusProxyTypeFunc_WithClosures
drop_closures_DBusProxyTypeFunc _f manager objectPath interfaceName _ = _f manager objectPath interfaceName

-- | Wrap the callback into a `GClosure`.
genClosure_DBusProxyTypeFunc :: MonadIO m => DBusProxyTypeFunc -> m (GClosure C_DBusProxyTypeFunc)
genClosure_DBusProxyTypeFunc cb = liftIO $ do
    let cb' = drop_closures_DBusProxyTypeFunc cb
    let cb'' = wrap_DBusProxyTypeFunc Nothing cb'
    mk_DBusProxyTypeFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DBusProxyTypeFunc` into a `C_DBusProxyTypeFunc`.
wrap_DBusProxyTypeFunc :: 
    Maybe (Ptr (FunPtr C_DBusProxyTypeFunc)) ->
    DBusProxyTypeFunc_WithClosures ->
    C_DBusProxyTypeFunc
wrap_DBusProxyTypeFunc gi'funptrptr gi'cb manager objectPath interfaceName data_ = do
    manager' <- (newObject Gio.DBusObjectManagerClient.DBusObjectManagerClient) manager
    objectPath' <- cstringToText objectPath
    maybeInterfaceName <-
        if interfaceName == FP.nullPtr
        then return Nothing
        else do
            interfaceName' <- cstringToText interfaceName
            return $ Just interfaceName'
    result <- gi'cb  manager' objectPath' maybeInterfaceName data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = gtypeToCGType result
    return result'


-- callback DBusMessageFilterFunction
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "Gio" , name = "DBusMessage" })
  , returnMayBeNull = True
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "A #GDBusMessage that will be freed with\ng_object_unref() or %NULL to drop the message. Passive filter\nfunctions can simply return the passed @message object."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GDBusConnection."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "message"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusMessage" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "A locked #GDBusMessage that the filter function takes ownership of."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "incoming"
          , argType = TBasicType TBoolean
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "%TRUE if it is a message received from the other peer, %FALSE if it is\na message to be sent to the other peer."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data passed when adding the filter."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Signature for function used in g_dbus_connection_add_filter().\n\nA filter function is passed a #GDBusMessage and expected to return\na #GDBusMessage too. Passive filter functions that don't modify the\nmessage can simply return the @message object:\n|[\nstatic GDBusMessage *\npassive_filter (GDBusConnection *connection\n                GDBusMessage    *message,\n                gboolean         incoming,\n                gpointer         user_data)\n{\n  // inspect @message\n  return message;\n}\n]|\nFilter functions that wants to drop a message can simply return %NULL:\n|[\nstatic GDBusMessage *\ndrop_filter (GDBusConnection *connection\n             GDBusMessage    *message,\n             gboolean         incoming,\n             gpointer         user_data)\n{\n  if (should_drop_message)\n    {\n      g_object_unref (message);\n      message = NULL;\n    }\n  return message;\n}\n]|\nFinally, a filter function may modify a message by copying it:\n|[\nstatic GDBusMessage *\nmodifying_filter (GDBusConnection *connection\n                  GDBusMessage    *message,\n                  gboolean         incoming,\n                  gpointer         user_data)\n{\n  GDBusMessage *copy;\n  GError *error;\n\n  error = NULL;\n  copy = g_dbus_message_copy (message, &error);\n  // handle @error being set\n  g_object_unref (message);\n\n  // modify @copy\n\n  return copy;\n}\n]|\nIf the returned #GDBusMessage is different from @message and cannot\nbe sent on @connection (it could use features, such as file\ndescriptors, not compatible with @connection), then a warning is\nlogged to standard error. Applications can\ncheck this ahead of time using g_dbus_message_to_blob() passing a\n#GDBusCapabilityFlags value obtained from @connection."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DBusMessageFilterFunction =
    Ptr Gio.DBusConnection.DBusConnection ->
    Ptr Gio.DBusMessage.DBusMessage ->
    CInt ->
    Ptr () ->
    IO (Ptr Gio.DBusMessage.DBusMessage)

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "message"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusMessage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A locked #GDBusMessage that the filter function takes ownership of."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "incoming"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%TRUE if it is a message received from the other peer, %FALSE if it is\na message to be sent to the other peer."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data passed when adding the filter."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "DBusMessage" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DBusMessageFilterFunction :: FunPtr C_DBusMessageFilterFunction -> C_DBusMessageFilterFunction

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DBusMessageFilterFunction ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a, Gio.DBusMessage.IsDBusMessage b) =>
    FunPtr C_DBusMessageFilterFunction
    -> a
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> b
    -- ^ /@message@/: A locked t'GI.Gio.Objects.DBusMessage.DBusMessage' that the filter function takes ownership of.
    -> Bool
    -- ^ /@incoming@/: 'P.True' if it is a message received from the other peer, 'P.False' if it is
    -- a message to be sent to the other peer.
    -> Ptr ()
    -- ^ /@userData@/: User data passed when adding the filter.
    -> m (Maybe Gio.DBusMessage.DBusMessage)
    -- ^ __Returns:__ A t'GI.Gio.Objects.DBusMessage.DBusMessage' that will be freed with
    -- 'GI.GObject.Objects.Object.objectUnref' or 'P.Nothing' to drop the message. Passive filter
    -- functions can simply return the passed /@message@/ object.
dynamic_DBusMessageFilterFunction __funPtr connection message incoming userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    message' <- B.ManagedPtr.disownObject message
    let incoming' = (P.fromIntegral . P.fromEnum) incoming
    result <- (__dynamic_C_DBusMessageFilterFunction __funPtr) connection' message' incoming' userData
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gio.DBusMessage.DBusMessage) result'
        return result''
    touchManagedPtr connection
    touchManagedPtr message
    return maybeResult

-- | Generate a function pointer callable from C code, from a `C_DBusMessageFilterFunction`.
foreign import ccall "wrapper"
    mk_DBusMessageFilterFunction :: C_DBusMessageFilterFunction -> IO (FunPtr C_DBusMessageFilterFunction)

-- | Signature for function used in 'GI.Gio.Objects.DBusConnection.dBusConnectionAddFilter'.
-- 
-- A filter function is passed a t'GI.Gio.Objects.DBusMessage.DBusMessage' and expected to return
-- a t'GI.Gio.Objects.DBusMessage.DBusMessage' too. Passive filter functions that don\'t modify the
-- message can simply return the /@message@/ object:
-- >
-- >static GDBusMessage *
-- >passive_filter (GDBusConnection *connection
-- >                GDBusMessage    *message,
-- >                gboolean         incoming,
-- >                gpointer         user_data)
-- >{
-- >  // inspect @message
-- >  return message;
-- >}
-- 
-- Filter functions that wants to drop a message can simply return 'P.Nothing':
-- >
-- >static GDBusMessage *
-- >drop_filter (GDBusConnection *connection
-- >             GDBusMessage    *message,
-- >             gboolean         incoming,
-- >             gpointer         user_data)
-- >{
-- >  if (should_drop_message)
-- >    {
-- >      g_object_unref (message);
-- >      message = NULL;
-- >    }
-- >  return message;
-- >}
-- 
-- Finally, a filter function may modify a message by copying it:
-- >
-- >static GDBusMessage *
-- >modifying_filter (GDBusConnection *connection
-- >                  GDBusMessage    *message,
-- >                  gboolean         incoming,
-- >                  gpointer         user_data)
-- >{
-- >  GDBusMessage *copy;
-- >  GError *error;
-- >
-- >  error = NULL;
-- >  copy = g_dbus_message_copy (message, &error);
-- >  // handle @error being set
-- >  g_object_unref (message);
-- >
-- >  // modify @copy
-- >
-- >  return copy;
-- >}
-- 
-- If the returned t'GI.Gio.Objects.DBusMessage.DBusMessage' is different from /@message@/ and cannot
-- be sent on /@connection@/ (it could use features, such as file
-- descriptors, not compatible with /@connection@/), then a warning is
-- logged to standard error. Applications can
-- check this ahead of time using 'GI.Gio.Objects.DBusMessage.dBusMessageToBlob' passing a
-- t'GI.Gio.Flags.DBusCapabilityFlags' value obtained from /@connection@/.
-- 
-- /Since: 2.26/
type DBusMessageFilterFunction =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Gio.DBusMessage.DBusMessage
    -- ^ /@message@/: A locked t'GI.Gio.Objects.DBusMessage.DBusMessage' that the filter function takes ownership of.
    -> Bool
    -- ^ /@incoming@/: 'P.True' if it is a message received from the other peer, 'P.False' if it is
    -- a message to be sent to the other peer.
    -> IO (Maybe Gio.DBusMessage.DBusMessage)
    -- ^ __Returns:__ A t'GI.Gio.Objects.DBusMessage.DBusMessage' that will be freed with
    -- 'GI.GObject.Objects.Object.objectUnref' or 'P.Nothing' to drop the message. Passive filter
    -- functions can simply return the passed /@message@/ object.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusMessageFilterFunction`@.
noDBusMessageFilterFunction :: Maybe DBusMessageFilterFunction
noDBusMessageFilterFunction = Nothing

-- | Signature for function used in 'GI.Gio.Objects.DBusConnection.dBusConnectionAddFilter'.
-- 
-- A filter function is passed a t'GI.Gio.Objects.DBusMessage.DBusMessage' and expected to return
-- a t'GI.Gio.Objects.DBusMessage.DBusMessage' too. Passive filter functions that don\'t modify the
-- message can simply return the /@message@/ object:
-- >
-- >static GDBusMessage *
-- >passive_filter (GDBusConnection *connection
-- >                GDBusMessage    *message,
-- >                gboolean         incoming,
-- >                gpointer         user_data)
-- >{
-- >  // inspect @message
-- >  return message;
-- >}
-- 
-- Filter functions that wants to drop a message can simply return 'P.Nothing':
-- >
-- >static GDBusMessage *
-- >drop_filter (GDBusConnection *connection
-- >             GDBusMessage    *message,
-- >             gboolean         incoming,
-- >             gpointer         user_data)
-- >{
-- >  if (should_drop_message)
-- >    {
-- >      g_object_unref (message);
-- >      message = NULL;
-- >    }
-- >  return message;
-- >}
-- 
-- Finally, a filter function may modify a message by copying it:
-- >
-- >static GDBusMessage *
-- >modifying_filter (GDBusConnection *connection
-- >                  GDBusMessage    *message,
-- >                  gboolean         incoming,
-- >                  gpointer         user_data)
-- >{
-- >  GDBusMessage *copy;
-- >  GError *error;
-- >
-- >  error = NULL;
-- >  copy = g_dbus_message_copy (message, &error);
-- >  // handle @error being set
-- >  g_object_unref (message);
-- >
-- >  // modify @copy
-- >
-- >  return copy;
-- >}
-- 
-- If the returned t'GI.Gio.Objects.DBusMessage.DBusMessage' is different from /@message@/ and cannot
-- be sent on /@connection@/ (it could use features, such as file
-- descriptors, not compatible with /@connection@/), then a warning is
-- logged to standard error. Applications can
-- check this ahead of time using 'GI.Gio.Objects.DBusMessage.dBusMessageToBlob' passing a
-- t'GI.Gio.Flags.DBusCapabilityFlags' value obtained from /@connection@/.
-- 
-- /Since: 2.26/
type DBusMessageFilterFunction_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Gio.DBusMessage.DBusMessage
    -- ^ /@message@/: A locked t'GI.Gio.Objects.DBusMessage.DBusMessage' that the filter function takes ownership of.
    -> Bool
    -- ^ /@incoming@/: 'P.True' if it is a message received from the other peer, 'P.False' if it is
    -- a message to be sent to the other peer.
    -> Ptr ()
    -- ^ /@userData@/: User data passed when adding the filter.
    -> IO (Maybe Gio.DBusMessage.DBusMessage)
    -- ^ __Returns:__ A t'GI.Gio.Objects.DBusMessage.DBusMessage' that will be freed with
    -- 'GI.GObject.Objects.Object.objectUnref' or 'P.Nothing' to drop the message. Passive filter
    -- functions can simply return the passed /@message@/ object.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusMessageFilterFunction_WithClosures`@.
noDBusMessageFilterFunction_WithClosures :: Maybe DBusMessageFilterFunction_WithClosures
noDBusMessageFilterFunction_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DBusMessageFilterFunction :: DBusMessageFilterFunction -> DBusMessageFilterFunction_WithClosures
drop_closures_DBusMessageFilterFunction _f connection message incoming _ = _f connection message incoming

-- | Wrap the callback into a `GClosure`.
genClosure_DBusMessageFilterFunction :: MonadIO m => DBusMessageFilterFunction -> m (GClosure C_DBusMessageFilterFunction)
genClosure_DBusMessageFilterFunction cb = liftIO $ do
    let cb' = drop_closures_DBusMessageFilterFunction cb
    let cb'' = wrap_DBusMessageFilterFunction Nothing cb'
    mk_DBusMessageFilterFunction cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DBusMessageFilterFunction` into a `C_DBusMessageFilterFunction`.
wrap_DBusMessageFilterFunction :: 
    Maybe (Ptr (FunPtr C_DBusMessageFilterFunction)) ->
    DBusMessageFilterFunction_WithClosures ->
    C_DBusMessageFilterFunction
wrap_DBusMessageFilterFunction gi'funptrptr gi'cb connection message incoming userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    message' <- (wrapObject Gio.DBusMessage.DBusMessage) message
    let incoming' = (/= 0) incoming
    result <- gi'cb  connection' message' incoming' userData
    maybeReleaseFunPtr gi'funptrptr
    maybeM FP.nullPtr result $ \result' -> do
        result'' <- B.ManagedPtr.disownObject result'
        return result''


-- callback DBusInterfaceSetPropertyFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE if the property was set to @value, %FALSE if @error is set."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GDBusConnection."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "sender"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The unique bus name of the remote caller or %NULL if\n    not specified by the caller, e.g. on peer-to-peer connections."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "object_path"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The object path that the method was invoked on."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "interface_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The D-Bus interface name for the property."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "property_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The name of the property to get the value of."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TVariant
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The value to set the property to."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "error"
          , argType = TError
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Return location for error."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The @user_data #gpointer passed to g_dbus_connection_register_object()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the @set_property function in #GDBusInterfaceVTable."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DBusInterfaceSetPropertyFunc =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    CString ->
    CString ->
    CString ->
    Ptr GVariant ->
    Ptr GError ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sender"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The unique bus name of the remote caller or %NULL if\n    not specified by the caller, e.g. on peer-to-peer connections."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The object path that the method was invoked on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The D-Bus interface name for the property."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name of the property to get the value of."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The value to set the property to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return location for error."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The @user_data #gpointer passed to g_dbus_connection_register_object()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DBusInterfaceSetPropertyFunc :: FunPtr C_DBusInterfaceSetPropertyFunc -> C_DBusInterfaceSetPropertyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DBusInterfaceSetPropertyFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_DBusInterfaceSetPropertyFunc
    -> a
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe (T.Text)
    -- ^ /@sender@/: The unique bus name of the remote caller or 'P.Nothing' if
    --     not specified by the caller, e.g. on peer-to-peer connections.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the method was invoked on.
    -> T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name for the property.
    -> T.Text
    -- ^ /@propertyName@/: The name of the property to get the value of.
    -> GVariant
    -- ^ /@value@/: The value to set the property to.
    -> GError
    -- ^ /@error@/: Return location for error.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to @/g_dbus_connection_register_object()/@.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the property was set to /@value@/, 'P.False' if /@error@/ is set.
dynamic_DBusInterfaceSetPropertyFunc __funPtr connection sender objectPath interfaceName propertyName value error_ userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeSender <- case sender of
        Nothing -> return FP.nullPtr
        Just jSender -> do
            jSender' <- textToCString jSender
            return jSender'
    objectPath' <- textToCString objectPath
    interfaceName' <- textToCString interfaceName
    propertyName' <- textToCString propertyName
    value' <- unsafeManagedPtrGetPtr value
    error_' <- unsafeManagedPtrGetPtr error_
    result <- (__dynamic_C_DBusInterfaceSetPropertyFunc __funPtr) connection' maybeSender objectPath' interfaceName' propertyName' value' error_' userData
    let result' = (/= 0) result
    touchManagedPtr connection
    touchManagedPtr value
    touchManagedPtr error_
    freeMem maybeSender
    freeMem objectPath'
    freeMem interfaceName'
    freeMem propertyName'
    return result'

-- | Generate a function pointer callable from C code, from a `C_DBusInterfaceSetPropertyFunc`.
foreign import ccall "wrapper"
    mk_DBusInterfaceSetPropertyFunc :: C_DBusInterfaceSetPropertyFunc -> IO (FunPtr C_DBusInterfaceSetPropertyFunc)

-- | The type of the /@setProperty@/ function in t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable'.
-- 
-- /Since: 2.26/
type DBusInterfaceSetPropertyFunc =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller or 'P.Nothing' if
    --     not specified by the caller, e.g. on peer-to-peer connections.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the method was invoked on.
    -> T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name for the property.
    -> T.Text
    -- ^ /@propertyName@/: The name of the property to get the value of.
    -> GVariant
    -- ^ /@value@/: The value to set the property to.
    -> GError
    -- ^ /@error@/: Return location for error.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the property was set to /@value@/, 'P.False' if /@error@/ is set.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusInterfaceSetPropertyFunc`@.
noDBusInterfaceSetPropertyFunc :: Maybe DBusInterfaceSetPropertyFunc
noDBusInterfaceSetPropertyFunc = Nothing

-- | The type of the /@setProperty@/ function in t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable'.
-- 
-- /Since: 2.26/
type DBusInterfaceSetPropertyFunc_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller or 'P.Nothing' if
    --     not specified by the caller, e.g. on peer-to-peer connections.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the method was invoked on.
    -> T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name for the property.
    -> T.Text
    -- ^ /@propertyName@/: The name of the property to get the value of.
    -> GVariant
    -- ^ /@value@/: The value to set the property to.
    -> GError
    -- ^ /@error@/: Return location for error.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to @/g_dbus_connection_register_object()/@.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the property was set to /@value@/, 'P.False' if /@error@/ is set.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusInterfaceSetPropertyFunc_WithClosures`@.
noDBusInterfaceSetPropertyFunc_WithClosures :: Maybe DBusInterfaceSetPropertyFunc_WithClosures
noDBusInterfaceSetPropertyFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DBusInterfaceSetPropertyFunc :: DBusInterfaceSetPropertyFunc -> DBusInterfaceSetPropertyFunc_WithClosures
drop_closures_DBusInterfaceSetPropertyFunc _f connection sender objectPath interfaceName propertyName value error_ _ = _f connection sender objectPath interfaceName propertyName value error_

-- | Wrap the callback into a `GClosure`.
genClosure_DBusInterfaceSetPropertyFunc :: MonadIO m => DBusInterfaceSetPropertyFunc -> m (GClosure C_DBusInterfaceSetPropertyFunc)
genClosure_DBusInterfaceSetPropertyFunc cb = liftIO $ do
    let cb' = drop_closures_DBusInterfaceSetPropertyFunc cb
    let cb'' = wrap_DBusInterfaceSetPropertyFunc Nothing cb'
    mk_DBusInterfaceSetPropertyFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DBusInterfaceSetPropertyFunc` into a `C_DBusInterfaceSetPropertyFunc`.
wrap_DBusInterfaceSetPropertyFunc :: 
    Maybe (Ptr (FunPtr C_DBusInterfaceSetPropertyFunc)) ->
    DBusInterfaceSetPropertyFunc_WithClosures ->
    C_DBusInterfaceSetPropertyFunc
wrap_DBusInterfaceSetPropertyFunc gi'funptrptr gi'cb connection sender objectPath interfaceName propertyName value error_ userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    maybeSender <-
        if sender == FP.nullPtr
        then return Nothing
        else do
            sender' <- cstringToText sender
            return $ Just sender'
    objectPath' <- cstringToText objectPath
    interfaceName' <- cstringToText interfaceName
    propertyName' <- cstringToText propertyName
    value' <- B.GVariant.newGVariantFromPtr value
    error_' <- (newBoxed GError) error_
    result <- gi'cb  connection' maybeSender objectPath' interfaceName' propertyName' value' error_' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback DBusInterfaceMethodCallFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GDBusConnection."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "sender"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The unique bus name of the remote caller, or `NULL` if\n    not specified by the caller, e.g. on peer-to-peer connections."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "object_path"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The object path that the method was invoked on."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "interface_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The D-Bus interface name the method was invoked on,\n    or `NULL` if not specified by the sender."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "method_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The name of the method that was invoked."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "parameters"
          , argType = TVariant
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GVariant tuple with parameters."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "invocation"
          , argType =
              TInterface
                Name { namespace = "Gio" , name = "DBusMethodInvocation" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "A #GDBusMethodInvocation object that must be used to return a value or error."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The @user_data #gpointer passed to g_dbus_connection_register_object()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the @method_call function in #GDBusInterfaceVTable.\n\n@interface_name may be `NULL` if not specified by the sender, although it\8217s\nencouraged for the sender to set it. If unset, and the object has only one\nmethod (across all interfaces) matching @method_name, that method is invoked.\nOtherwise, behaviour is implementation defined. See the\n[D-Bus specification](https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-types-method).\nIt is recommended to return [error@Gio.DBusError.UNKNOWN_METHOD]."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DBusInterfaceMethodCallFunc =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    CString ->
    CString ->
    CString ->
    Ptr GVariant ->
    Ptr Gio.DBusMethodInvocation.DBusMethodInvocation ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sender"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The unique bus name of the remote caller, or `NULL` if\n    not specified by the caller, e.g. on peer-to-peer connections."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The object path that the method was invoked on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The D-Bus interface name the method was invoked on,\n    or `NULL` if not specified by the sender."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "method_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name of the method that was invoked."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parameters"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GVariant tuple with parameters."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "invocation"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DBusMethodInvocation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A #GDBusMethodInvocation object that must be used to return a value or error."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The @user_data #gpointer passed to g_dbus_connection_register_object()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DBusInterfaceMethodCallFunc :: FunPtr C_DBusInterfaceMethodCallFunc -> C_DBusInterfaceMethodCallFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DBusInterfaceMethodCallFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a, Gio.DBusMethodInvocation.IsDBusMethodInvocation b) =>
    FunPtr C_DBusInterfaceMethodCallFunc
    -> a
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe (T.Text)
    -- ^ /@sender@/: The unique bus name of the remote caller, or @NULL@ if
    --     not specified by the caller, e.g. on peer-to-peer connections.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the method was invoked on.
    -> Maybe (T.Text)
    -- ^ /@interfaceName@/: The D-Bus interface name the method was invoked on,
    --     or @NULL@ if not specified by the sender.
    -> T.Text
    -- ^ /@methodName@/: The name of the method that was invoked.
    -> GVariant
    -- ^ /@parameters@/: A t'GVariant' tuple with parameters.
    -> b
    -- ^ /@invocation@/: A t'GI.Gio.Objects.DBusMethodInvocation.DBusMethodInvocation' object that must be used to return a value or error.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to @/g_dbus_connection_register_object()/@.
    -> m ()
dynamic_DBusInterfaceMethodCallFunc __funPtr connection sender objectPath interfaceName methodName parameters invocation userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeSender <- case sender of
        Nothing -> return FP.nullPtr
        Just jSender -> do
            jSender' <- textToCString jSender
            return jSender'
    objectPath' <- textToCString objectPath
    maybeInterfaceName <- case interfaceName of
        Nothing -> return FP.nullPtr
        Just jInterfaceName -> do
            jInterfaceName' <- textToCString jInterfaceName
            return jInterfaceName'
    methodName' <- textToCString methodName
    parameters' <- unsafeManagedPtrGetPtr parameters
    invocation' <- B.ManagedPtr.disownObject invocation
    (__dynamic_C_DBusInterfaceMethodCallFunc __funPtr) connection' maybeSender objectPath' maybeInterfaceName methodName' parameters' invocation' userData
    touchManagedPtr connection
    touchManagedPtr parameters
    touchManagedPtr invocation
    freeMem maybeSender
    freeMem objectPath'
    freeMem maybeInterfaceName
    freeMem methodName'
    return ()

-- | Generate a function pointer callable from C code, from a `C_DBusInterfaceMethodCallFunc`.
foreign import ccall "wrapper"
    mk_DBusInterfaceMethodCallFunc :: C_DBusInterfaceMethodCallFunc -> IO (FunPtr C_DBusInterfaceMethodCallFunc)

-- | The type of the /@methodCall@/ function in t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable'.
-- 
-- /@interfaceName@/ may be @NULL@ if not specified by the sender, although it’s
-- encouraged for the sender to set it. If unset, and the object has only one
-- method (across all interfaces) matching /@methodName@/, that method is invoked.
-- Otherwise, behaviour is implementation defined. See the
-- <https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-types-method D-Bus specification>.
-- It is recommended to return [error/@gio@/.DBusError.UNKNOWN_METHOD].
-- 
-- /Since: 2.26/
type DBusInterfaceMethodCallFunc =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller, or @NULL@ if
    --     not specified by the caller, e.g. on peer-to-peer connections.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the method was invoked on.
    -> Maybe T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name the method was invoked on,
    --     or @NULL@ if not specified by the sender.
    -> T.Text
    -- ^ /@methodName@/: The name of the method that was invoked.
    -> GVariant
    -- ^ /@parameters@/: A t'GVariant' tuple with parameters.
    -> Gio.DBusMethodInvocation.DBusMethodInvocation
    -- ^ /@invocation@/: A t'GI.Gio.Objects.DBusMethodInvocation.DBusMethodInvocation' object that must be used to return a value or error.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusInterfaceMethodCallFunc`@.
noDBusInterfaceMethodCallFunc :: Maybe DBusInterfaceMethodCallFunc
noDBusInterfaceMethodCallFunc = Nothing

-- | The type of the /@methodCall@/ function in t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable'.
-- 
-- /@interfaceName@/ may be @NULL@ if not specified by the sender, although it’s
-- encouraged for the sender to set it. If unset, and the object has only one
-- method (across all interfaces) matching /@methodName@/, that method is invoked.
-- Otherwise, behaviour is implementation defined. See the
-- <https://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-types-method D-Bus specification>.
-- It is recommended to return [error/@gio@/.DBusError.UNKNOWN_METHOD].
-- 
-- /Since: 2.26/
type DBusInterfaceMethodCallFunc_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller, or @NULL@ if
    --     not specified by the caller, e.g. on peer-to-peer connections.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the method was invoked on.
    -> Maybe T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name the method was invoked on,
    --     or @NULL@ if not specified by the sender.
    -> T.Text
    -- ^ /@methodName@/: The name of the method that was invoked.
    -> GVariant
    -- ^ /@parameters@/: A t'GVariant' tuple with parameters.
    -> Gio.DBusMethodInvocation.DBusMethodInvocation
    -- ^ /@invocation@/: A t'GI.Gio.Objects.DBusMethodInvocation.DBusMethodInvocation' object that must be used to return a value or error.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to @/g_dbus_connection_register_object()/@.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusInterfaceMethodCallFunc_WithClosures`@.
noDBusInterfaceMethodCallFunc_WithClosures :: Maybe DBusInterfaceMethodCallFunc_WithClosures
noDBusInterfaceMethodCallFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DBusInterfaceMethodCallFunc :: DBusInterfaceMethodCallFunc -> DBusInterfaceMethodCallFunc_WithClosures
drop_closures_DBusInterfaceMethodCallFunc _f connection sender objectPath interfaceName methodName parameters invocation _ = _f connection sender objectPath interfaceName methodName parameters invocation

-- | Wrap the callback into a `GClosure`.
genClosure_DBusInterfaceMethodCallFunc :: MonadIO m => DBusInterfaceMethodCallFunc -> m (GClosure C_DBusInterfaceMethodCallFunc)
genClosure_DBusInterfaceMethodCallFunc cb = liftIO $ do
    let cb' = drop_closures_DBusInterfaceMethodCallFunc cb
    let cb'' = wrap_DBusInterfaceMethodCallFunc Nothing cb'
    mk_DBusInterfaceMethodCallFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DBusInterfaceMethodCallFunc` into a `C_DBusInterfaceMethodCallFunc`.
wrap_DBusInterfaceMethodCallFunc :: 
    Maybe (Ptr (FunPtr C_DBusInterfaceMethodCallFunc)) ->
    DBusInterfaceMethodCallFunc_WithClosures ->
    C_DBusInterfaceMethodCallFunc
wrap_DBusInterfaceMethodCallFunc gi'funptrptr gi'cb connection sender objectPath interfaceName methodName parameters invocation userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    maybeSender <-
        if sender == FP.nullPtr
        then return Nothing
        else do
            sender' <- cstringToText sender
            return $ Just sender'
    objectPath' <- cstringToText objectPath
    maybeInterfaceName <-
        if interfaceName == FP.nullPtr
        then return Nothing
        else do
            interfaceName' <- cstringToText interfaceName
            return $ Just interfaceName'
    methodName' <- cstringToText methodName
    parameters' <- B.GVariant.newGVariantFromPtr parameters
    invocation' <- (wrapObject Gio.DBusMethodInvocation.DBusMethodInvocation) invocation
    gi'cb  connection' maybeSender objectPath' maybeInterfaceName methodName' parameters' invocation' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback DBusInterfaceGetPropertyFunc
{- Callable
  { returnType = Just TVariant
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "A #GVariant with the value for @property_name or %NULL if\n    @error is set. If the returned #GVariant is floating, it is\n    consumed - otherwise its reference count is decreased by one."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A #GDBusConnection."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "sender"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The unique bus name of the remote caller or %NULL if\n    not specified by the caller, e.g. on peer-to-peer connections."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "object_path"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The object path that the method was invoked on."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "interface_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The D-Bus interface name for the property."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "property_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The name of the property to get the value of."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "error"
          , argType = TError
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "Return location for error."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The @user_data #gpointer passed to g_dbus_connection_register_object()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of the @get_property function in #GDBusInterfaceVTable."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DBusInterfaceGetPropertyFunc =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    CString ->
    CString ->
    CString ->
    Ptr GError ->
    Ptr () ->
    IO (Ptr GVariant)

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusConnection."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sender"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The unique bus name of the remote caller or %NULL if\n    not specified by the caller, e.g. on peer-to-peer connections."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The object path that the method was invoked on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The D-Bus interface name for the property."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name of the property to get the value of."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Return location for error."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The @user_data #gpointer passed to g_dbus_connection_register_object()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DBusInterfaceGetPropertyFunc :: FunPtr C_DBusInterfaceGetPropertyFunc -> C_DBusInterfaceGetPropertyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DBusInterfaceGetPropertyFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_DBusInterfaceGetPropertyFunc
    -> a
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe (T.Text)
    -- ^ /@sender@/: The unique bus name of the remote caller or 'P.Nothing' if
    --     not specified by the caller, e.g. on peer-to-peer connections.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the method was invoked on.
    -> T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name for the property.
    -> T.Text
    -- ^ /@propertyName@/: The name of the property to get the value of.
    -> GError
    -- ^ /@error@/: Return location for error.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to @/g_dbus_connection_register_object()/@.
    -> m GVariant
    -- ^ __Returns:__ A t'GVariant' with the value for /@propertyName@/ or 'P.Nothing' if
    --     /@error@/ is set. If the returned t'GVariant' is floating, it is
    --     consumed - otherwise its reference count is decreased by one.
dynamic_DBusInterfaceGetPropertyFunc __funPtr connection sender objectPath interfaceName propertyName error_ userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    maybeSender <- case sender of
        Nothing -> return FP.nullPtr
        Just jSender -> do
            jSender' <- textToCString jSender
            return jSender'
    objectPath' <- textToCString objectPath
    interfaceName' <- textToCString interfaceName
    propertyName' <- textToCString propertyName
    error_' <- unsafeManagedPtrGetPtr error_
    result <- (__dynamic_C_DBusInterfaceGetPropertyFunc __funPtr) connection' maybeSender objectPath' interfaceName' propertyName' error_' userData
    checkUnexpectedReturnNULL "dBusInterfaceGetPropertyFunc" result
    result' <- B.GVariant.wrapGVariantPtr result
    touchManagedPtr connection
    touchManagedPtr error_
    freeMem maybeSender
    freeMem objectPath'
    freeMem interfaceName'
    freeMem propertyName'
    return result'

-- | Generate a function pointer callable from C code, from a `C_DBusInterfaceGetPropertyFunc`.
foreign import ccall "wrapper"
    mk_DBusInterfaceGetPropertyFunc :: C_DBusInterfaceGetPropertyFunc -> IO (FunPtr C_DBusInterfaceGetPropertyFunc)

-- | The type of the /@getProperty@/ function in t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable'.
-- 
-- /Since: 2.26/
type DBusInterfaceGetPropertyFunc =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller or 'P.Nothing' if
    --     not specified by the caller, e.g. on peer-to-peer connections.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the method was invoked on.
    -> T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name for the property.
    -> T.Text
    -- ^ /@propertyName@/: The name of the property to get the value of.
    -> GError
    -- ^ /@error@/: Return location for error.
    -> IO GVariant
    -- ^ __Returns:__ A t'GVariant' with the value for /@propertyName@/ or 'P.Nothing' if
    --     /@error@/ is set. If the returned t'GVariant' is floating, it is
    --     consumed - otherwise its reference count is decreased by one.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusInterfaceGetPropertyFunc`@.
noDBusInterfaceGetPropertyFunc :: Maybe DBusInterfaceGetPropertyFunc
noDBusInterfaceGetPropertyFunc = Nothing

-- | The type of the /@getProperty@/ function in t'GI.Gio.Structs.DBusInterfaceVTable.DBusInterfaceVTable'.
-- 
-- /Since: 2.26/
type DBusInterfaceGetPropertyFunc_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: A t'GI.Gio.Objects.DBusConnection.DBusConnection'.
    -> Maybe T.Text
    -- ^ /@sender@/: The unique bus name of the remote caller or 'P.Nothing' if
    --     not specified by the caller, e.g. on peer-to-peer connections.
    -> T.Text
    -- ^ /@objectPath@/: The object path that the method was invoked on.
    -> T.Text
    -- ^ /@interfaceName@/: The D-Bus interface name for the property.
    -> T.Text
    -- ^ /@propertyName@/: The name of the property to get the value of.
    -> GError
    -- ^ /@error@/: Return location for error.
    -> Ptr ()
    -- ^ /@userData@/: The /@userData@/ @/gpointer/@ passed to @/g_dbus_connection_register_object()/@.
    -> IO GVariant
    -- ^ __Returns:__ A t'GVariant' with the value for /@propertyName@/ or 'P.Nothing' if
    --     /@error@/ is set. If the returned t'GVariant' is floating, it is
    --     consumed - otherwise its reference count is decreased by one.

-- | A convenience synonym for @`Nothing` :: `Maybe` `DBusInterfaceGetPropertyFunc_WithClosures`@.
noDBusInterfaceGetPropertyFunc_WithClosures :: Maybe DBusInterfaceGetPropertyFunc_WithClosures
noDBusInterfaceGetPropertyFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DBusInterfaceGetPropertyFunc :: DBusInterfaceGetPropertyFunc -> DBusInterfaceGetPropertyFunc_WithClosures
drop_closures_DBusInterfaceGetPropertyFunc _f connection sender objectPath interfaceName propertyName error_ _ = _f connection sender objectPath interfaceName propertyName error_

-- | Wrap the callback into a `GClosure`.
genClosure_DBusInterfaceGetPropertyFunc :: MonadIO m => DBusInterfaceGetPropertyFunc -> m (GClosure C_DBusInterfaceGetPropertyFunc)
genClosure_DBusInterfaceGetPropertyFunc cb = liftIO $ do
    let cb' = drop_closures_DBusInterfaceGetPropertyFunc cb
    let cb'' = wrap_DBusInterfaceGetPropertyFunc Nothing cb'
    mk_DBusInterfaceGetPropertyFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DBusInterfaceGetPropertyFunc` into a `C_DBusInterfaceGetPropertyFunc`.
wrap_DBusInterfaceGetPropertyFunc :: 
    Maybe (Ptr (FunPtr C_DBusInterfaceGetPropertyFunc)) ->
    DBusInterfaceGetPropertyFunc_WithClosures ->
    C_DBusInterfaceGetPropertyFunc
wrap_DBusInterfaceGetPropertyFunc gi'funptrptr gi'cb connection sender objectPath interfaceName propertyName error_ userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    maybeSender <-
        if sender == FP.nullPtr
        then return Nothing
        else do
            sender' <- cstringToText sender
            return $ Just sender'
    objectPath' <- cstringToText objectPath
    interfaceName' <- cstringToText interfaceName
    propertyName' <- cstringToText propertyName
    error_' <- (newBoxed GError) error_
    result <- gi'cb  connection' maybeSender objectPath' interfaceName' propertyName' error_' userData
    maybeReleaseFunPtr gi'funptrptr
    result' <- B.GVariant.disownGVariant result
    return result'


-- callback CancellableSourceFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "it should return %FALSE if the source should be removed."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "cancellable"
          , argType =
              TInterface Name { namespace = "Gio" , name = "Cancellable" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the #GCancellable" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed in by the user."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This is the function type of the callback used for the #GSource\nreturned by g_cancellable_source_new()."
        , sinceVersion = Just "2.28"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CancellableSourceFunc =
    Ptr Gio.Cancellable.Cancellable ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCancellable" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed in by the user."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CancellableSourceFunc :: FunPtr C_CancellableSourceFunc -> C_CancellableSourceFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CancellableSourceFunc ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.Cancellable.IsCancellable a) =>
    FunPtr C_CancellableSourceFunc
    -> Maybe (a)
    -- ^ /@cancellable@/: the t'GI.Gio.Objects.Cancellable.Cancellable'
    -> Ptr ()
    -- ^ /@data@/: data passed in by the user.
    -> m Bool
    -- ^ __Returns:__ it should return 'P.False' if the source should be removed.
dynamic_CancellableSourceFunc __funPtr cancellable data_ = liftIO $ do
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    result <- (__dynamic_C_CancellableSourceFunc __funPtr) maybeCancellable data_
    let result' = (/= 0) result
    whenJust cancellable touchManagedPtr
    return result'

-- | Generate a function pointer callable from C code, from a `C_CancellableSourceFunc`.
foreign import ccall "wrapper"
    mk_CancellableSourceFunc :: C_CancellableSourceFunc -> IO (FunPtr C_CancellableSourceFunc)

-- | This is the function type of the callback used for the t'GI.GLib.Structs.Source.Source'
-- returned by 'GI.Gio.Objects.Cancellable.cancellableSourceNew'.
-- 
-- /Since: 2.28/
type CancellableSourceFunc =
    Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: the t'GI.Gio.Objects.Cancellable.Cancellable'
    -> IO Bool
    -- ^ __Returns:__ it should return 'P.False' if the source should be removed.

-- | A convenience synonym for @`Nothing` :: `Maybe` `CancellableSourceFunc`@.
noCancellableSourceFunc :: Maybe CancellableSourceFunc
noCancellableSourceFunc = Nothing

-- | This is the function type of the callback used for the t'GI.GLib.Structs.Source.Source'
-- returned by 'GI.Gio.Objects.Cancellable.cancellableSourceNew'.
-- 
-- /Since: 2.28/
type CancellableSourceFunc_WithClosures =
    Maybe Gio.Cancellable.Cancellable
    -- ^ /@cancellable@/: the t'GI.Gio.Objects.Cancellable.Cancellable'
    -> Ptr ()
    -- ^ /@data@/: data passed in by the user.
    -> IO Bool
    -- ^ __Returns:__ it should return 'P.False' if the source should be removed.

-- | A convenience synonym for @`Nothing` :: `Maybe` `CancellableSourceFunc_WithClosures`@.
noCancellableSourceFunc_WithClosures :: Maybe CancellableSourceFunc_WithClosures
noCancellableSourceFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_CancellableSourceFunc :: CancellableSourceFunc -> CancellableSourceFunc_WithClosures
drop_closures_CancellableSourceFunc _f cancellable _ = _f cancellable

-- | Wrap the callback into a `GClosure`.
genClosure_CancellableSourceFunc :: MonadIO m => CancellableSourceFunc -> m (GClosure C_CancellableSourceFunc)
genClosure_CancellableSourceFunc cb = liftIO $ do
    let cb' = drop_closures_CancellableSourceFunc cb
    let cb'' = wrap_CancellableSourceFunc Nothing cb'
    mk_CancellableSourceFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `CancellableSourceFunc` into a `C_CancellableSourceFunc`.
wrap_CancellableSourceFunc :: 
    Maybe (Ptr (FunPtr C_CancellableSourceFunc)) ->
    CancellableSourceFunc_WithClosures ->
    C_CancellableSourceFunc
wrap_CancellableSourceFunc gi'funptrptr gi'cb cancellable data_ = do
    maybeCancellable <-
        if cancellable == FP.nullPtr
        then return Nothing
        else do
            cancellable' <- (newObject Gio.Cancellable.Cancellable) cancellable
            return $ Just cancellable'
    result <- gi'cb  maybeCancellable data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback BusNameVanishedCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The #GDBusConnection the name is being watched on, or\n    %NULL."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The name being watched."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data passed to g_bus_watch_name()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Invoked when the name being watched is known not to have to have an owner.\n\nThis is also invoked when the #GDBusConnection on which the watch was\nestablished has been closed.  In that case, @connection will be\n%NULL."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BusNameVanishedCallback =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The #GDBusConnection the name is being watched on, or\n    %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name being watched."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data passed to g_bus_watch_name()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BusNameVanishedCallback :: FunPtr C_BusNameVanishedCallback -> C_BusNameVanishedCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BusNameVanishedCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_BusNameVanishedCallback
    -> a
    -- ^ /@connection@/: The t'GI.Gio.Objects.DBusConnection.DBusConnection' the name is being watched on, or
    --     'P.Nothing'.
    -> T.Text
    -- ^ /@name@/: The name being watched.
    -> Ptr ()
    -- ^ /@userData@/: User data passed to @/g_bus_watch_name()/@.
    -> m ()
dynamic_BusNameVanishedCallback __funPtr connection name userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    name' <- textToCString name
    (__dynamic_C_BusNameVanishedCallback __funPtr) connection' name' userData
    touchManagedPtr connection
    freeMem name'
    return ()

-- | Generate a function pointer callable from C code, from a `C_BusNameVanishedCallback`.
foreign import ccall "wrapper"
    mk_BusNameVanishedCallback :: C_BusNameVanishedCallback -> IO (FunPtr C_BusNameVanishedCallback)

-- | Invoked when the name being watched is known not to have to have an owner.
-- 
-- This is also invoked when the t'GI.Gio.Objects.DBusConnection.DBusConnection' on which the watch was
-- established has been closed.  In that case, /@connection@/ will be
-- 'P.Nothing'.
-- 
-- /Since: 2.26/
type BusNameVanishedCallback =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: The t'GI.Gio.Objects.DBusConnection.DBusConnection' the name is being watched on, or
    --     'P.Nothing'.
    -> T.Text
    -- ^ /@name@/: The name being watched.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BusNameVanishedCallback`@.
noBusNameVanishedCallback :: Maybe BusNameVanishedCallback
noBusNameVanishedCallback = Nothing

-- | Invoked when the name being watched is known not to have to have an owner.
-- 
-- This is also invoked when the t'GI.Gio.Objects.DBusConnection.DBusConnection' on which the watch was
-- established has been closed.  In that case, /@connection@/ will be
-- 'P.Nothing'.
-- 
-- /Since: 2.26/
type BusNameVanishedCallback_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: The t'GI.Gio.Objects.DBusConnection.DBusConnection' the name is being watched on, or
    --     'P.Nothing'.
    -> T.Text
    -- ^ /@name@/: The name being watched.
    -> Ptr ()
    -- ^ /@userData@/: User data passed to @/g_bus_watch_name()/@.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BusNameVanishedCallback_WithClosures`@.
noBusNameVanishedCallback_WithClosures :: Maybe BusNameVanishedCallback_WithClosures
noBusNameVanishedCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BusNameVanishedCallback :: BusNameVanishedCallback -> BusNameVanishedCallback_WithClosures
drop_closures_BusNameVanishedCallback _f connection name _ = _f connection name

-- | Wrap the callback into a `GClosure`.
genClosure_BusNameVanishedCallback :: MonadIO m => BusNameVanishedCallback -> m (GClosure C_BusNameVanishedCallback)
genClosure_BusNameVanishedCallback cb = liftIO $ do
    let cb' = drop_closures_BusNameVanishedCallback cb
    let cb'' = wrap_BusNameVanishedCallback Nothing cb'
    mk_BusNameVanishedCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `BusNameVanishedCallback` into a `C_BusNameVanishedCallback`.
wrap_BusNameVanishedCallback :: 
    Maybe (Ptr (FunPtr C_BusNameVanishedCallback)) ->
    BusNameVanishedCallback_WithClosures ->
    C_BusNameVanishedCallback
wrap_BusNameVanishedCallback gi'funptrptr gi'cb connection name userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    name' <- cstringToText name
    gi'cb  connection' name' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback BusNameLostCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the connect on which to acquire the name or `NULL` if\n  the connection was disconnected"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the name being owned"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "user data passed to [func@Gio.bus_own_name] or\n  [func@Gio.bus_own_name_on_connection]"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Invoked when the name is lost or @connection has been closed."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BusNameLostCallback =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the connect on which to acquire the name or `NULL` if\n  the connection was disconnected"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name being owned"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "user data passed to [func@Gio.bus_own_name] or\n  [func@Gio.bus_own_name_on_connection]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BusNameLostCallback :: FunPtr C_BusNameLostCallback -> C_BusNameLostCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BusNameLostCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_BusNameLostCallback
    -> a
    -- ^ /@connection@/: the connect on which to acquire the name or @NULL@ if
    --   the connection was disconnected
    -> T.Text
    -- ^ /@name@/: the name being owned
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.Gio.Functions.busOwnName' or
    --   'GI.Gio.Functions.busOwnNameOnConnection'
    -> m ()
dynamic_BusNameLostCallback __funPtr connection name userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    name' <- textToCString name
    (__dynamic_C_BusNameLostCallback __funPtr) connection' name' userData
    touchManagedPtr connection
    freeMem name'
    return ()

-- | Generate a function pointer callable from C code, from a `C_BusNameLostCallback`.
foreign import ccall "wrapper"
    mk_BusNameLostCallback :: C_BusNameLostCallback -> IO (FunPtr C_BusNameLostCallback)

-- | Invoked when the name is lost or /@connection@/ has been closed.
-- 
-- /Since: 2.26/
type BusNameLostCallback =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: the connect on which to acquire the name or @NULL@ if
    --   the connection was disconnected
    -> T.Text
    -- ^ /@name@/: the name being owned
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BusNameLostCallback`@.
noBusNameLostCallback :: Maybe BusNameLostCallback
noBusNameLostCallback = Nothing

-- | Invoked when the name is lost or /@connection@/ has been closed.
-- 
-- /Since: 2.26/
type BusNameLostCallback_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: the connect on which to acquire the name or @NULL@ if
    --   the connection was disconnected
    -> T.Text
    -- ^ /@name@/: the name being owned
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.Gio.Functions.busOwnName' or
    --   'GI.Gio.Functions.busOwnNameOnConnection'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BusNameLostCallback_WithClosures`@.
noBusNameLostCallback_WithClosures :: Maybe BusNameLostCallback_WithClosures
noBusNameLostCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BusNameLostCallback :: BusNameLostCallback -> BusNameLostCallback_WithClosures
drop_closures_BusNameLostCallback _f connection name _ = _f connection name

-- | Wrap the callback into a `GClosure`.
genClosure_BusNameLostCallback :: MonadIO m => BusNameLostCallback -> m (GClosure C_BusNameLostCallback)
genClosure_BusNameLostCallback cb = liftIO $ do
    let cb' = drop_closures_BusNameLostCallback cb
    let cb'' = wrap_BusNameLostCallback Nothing cb'
    mk_BusNameLostCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `BusNameLostCallback` into a `C_BusNameLostCallback`.
wrap_BusNameLostCallback :: 
    Maybe (Ptr (FunPtr C_BusNameLostCallback)) ->
    BusNameLostCallback_WithClosures ->
    C_BusNameLostCallback
wrap_BusNameLostCallback gi'funptrptr gi'cb connection name userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    name' <- cstringToText name
    gi'cb  connection' name' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback BusNameAppearedCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "The #GDBusConnection the name is being watched on."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The name being watched."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "name_owner"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "Unique name of the owner of the name being watched."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "User data passed to g_bus_watch_name()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Invoked when the name being watched is known to have to have an owner."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BusNameAppearedCallback =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    CString ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The #GDBusConnection the name is being watched on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name being watched."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name_owner"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Unique name of the owner of the name being watched."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "User data passed to g_bus_watch_name()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BusNameAppearedCallback :: FunPtr C_BusNameAppearedCallback -> C_BusNameAppearedCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BusNameAppearedCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_BusNameAppearedCallback
    -> a
    -- ^ /@connection@/: The t'GI.Gio.Objects.DBusConnection.DBusConnection' the name is being watched on.
    -> T.Text
    -- ^ /@name@/: The name being watched.
    -> T.Text
    -- ^ /@nameOwner@/: Unique name of the owner of the name being watched.
    -> Ptr ()
    -- ^ /@userData@/: User data passed to @/g_bus_watch_name()/@.
    -> m ()
dynamic_BusNameAppearedCallback __funPtr connection name nameOwner userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    name' <- textToCString name
    nameOwner' <- textToCString nameOwner
    (__dynamic_C_BusNameAppearedCallback __funPtr) connection' name' nameOwner' userData
    touchManagedPtr connection
    freeMem name'
    freeMem nameOwner'
    return ()

-- | Generate a function pointer callable from C code, from a `C_BusNameAppearedCallback`.
foreign import ccall "wrapper"
    mk_BusNameAppearedCallback :: C_BusNameAppearedCallback -> IO (FunPtr C_BusNameAppearedCallback)

-- | Invoked when the name being watched is known to have to have an owner.
-- 
-- /Since: 2.26/
type BusNameAppearedCallback =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: The t'GI.Gio.Objects.DBusConnection.DBusConnection' the name is being watched on.
    -> T.Text
    -- ^ /@name@/: The name being watched.
    -> T.Text
    -- ^ /@nameOwner@/: Unique name of the owner of the name being watched.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BusNameAppearedCallback`@.
noBusNameAppearedCallback :: Maybe BusNameAppearedCallback
noBusNameAppearedCallback = Nothing

-- | Invoked when the name being watched is known to have to have an owner.
-- 
-- /Since: 2.26/
type BusNameAppearedCallback_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: The t'GI.Gio.Objects.DBusConnection.DBusConnection' the name is being watched on.
    -> T.Text
    -- ^ /@name@/: The name being watched.
    -> T.Text
    -- ^ /@nameOwner@/: Unique name of the owner of the name being watched.
    -> Ptr ()
    -- ^ /@userData@/: User data passed to @/g_bus_watch_name()/@.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BusNameAppearedCallback_WithClosures`@.
noBusNameAppearedCallback_WithClosures :: Maybe BusNameAppearedCallback_WithClosures
noBusNameAppearedCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BusNameAppearedCallback :: BusNameAppearedCallback -> BusNameAppearedCallback_WithClosures
drop_closures_BusNameAppearedCallback _f connection name nameOwner _ = _f connection name nameOwner

-- | Wrap the callback into a `GClosure`.
genClosure_BusNameAppearedCallback :: MonadIO m => BusNameAppearedCallback -> m (GClosure C_BusNameAppearedCallback)
genClosure_BusNameAppearedCallback cb = liftIO $ do
    let cb' = drop_closures_BusNameAppearedCallback cb
    let cb'' = wrap_BusNameAppearedCallback Nothing cb'
    mk_BusNameAppearedCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `BusNameAppearedCallback` into a `C_BusNameAppearedCallback`.
wrap_BusNameAppearedCallback :: 
    Maybe (Ptr (FunPtr C_BusNameAppearedCallback)) ->
    BusNameAppearedCallback_WithClosures ->
    C_BusNameAppearedCallback
wrap_BusNameAppearedCallback gi'funptrptr gi'cb connection name nameOwner userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    name' <- cstringToText name
    nameOwner' <- cstringToText nameOwner
    gi'cb  connection' name' nameOwner' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback BusNameAcquiredCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the connection on which to acquired the name"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the name being owned"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "user data passed to [func@Gio.bus_own_name] or\n  [func@Gio.bus_own_name_on_connection]"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText = Just "Invoked when the name is acquired."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BusNameAcquiredCallback =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the connection on which to acquired the name"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name being owned"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "user data passed to [func@Gio.bus_own_name] or\n  [func@Gio.bus_own_name_on_connection]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BusNameAcquiredCallback :: FunPtr C_BusNameAcquiredCallback -> C_BusNameAcquiredCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BusNameAcquiredCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_BusNameAcquiredCallback
    -> a
    -- ^ /@connection@/: the connection on which to acquired the name
    -> T.Text
    -- ^ /@name@/: the name being owned
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.Gio.Functions.busOwnName' or
    --   'GI.Gio.Functions.busOwnNameOnConnection'
    -> m ()
dynamic_BusNameAcquiredCallback __funPtr connection name userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    name' <- textToCString name
    (__dynamic_C_BusNameAcquiredCallback __funPtr) connection' name' userData
    touchManagedPtr connection
    freeMem name'
    return ()

-- | Generate a function pointer callable from C code, from a `C_BusNameAcquiredCallback`.
foreign import ccall "wrapper"
    mk_BusNameAcquiredCallback :: C_BusNameAcquiredCallback -> IO (FunPtr C_BusNameAcquiredCallback)

-- | Invoked when the name is acquired.
-- 
-- /Since: 2.26/
type BusNameAcquiredCallback =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: the connection on which to acquired the name
    -> T.Text
    -- ^ /@name@/: the name being owned
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BusNameAcquiredCallback`@.
noBusNameAcquiredCallback :: Maybe BusNameAcquiredCallback
noBusNameAcquiredCallback = Nothing

-- | Invoked when the name is acquired.
-- 
-- /Since: 2.26/
type BusNameAcquiredCallback_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: the connection on which to acquired the name
    -> T.Text
    -- ^ /@name@/: the name being owned
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.Gio.Functions.busOwnName' or
    --   'GI.Gio.Functions.busOwnNameOnConnection'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BusNameAcquiredCallback_WithClosures`@.
noBusNameAcquiredCallback_WithClosures :: Maybe BusNameAcquiredCallback_WithClosures
noBusNameAcquiredCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BusNameAcquiredCallback :: BusNameAcquiredCallback -> BusNameAcquiredCallback_WithClosures
drop_closures_BusNameAcquiredCallback _f connection name _ = _f connection name

-- | Wrap the callback into a `GClosure`.
genClosure_BusNameAcquiredCallback :: MonadIO m => BusNameAcquiredCallback -> m (GClosure C_BusNameAcquiredCallback)
genClosure_BusNameAcquiredCallback cb = liftIO $ do
    let cb' = drop_closures_BusNameAcquiredCallback cb
    let cb'' = wrap_BusNameAcquiredCallback Nothing cb'
    mk_BusNameAcquiredCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `BusNameAcquiredCallback` into a `C_BusNameAcquiredCallback`.
wrap_BusNameAcquiredCallback :: 
    Maybe (Ptr (FunPtr C_BusNameAcquiredCallback)) ->
    BusNameAcquiredCallback_WithClosures ->
    C_BusNameAcquiredCallback
wrap_BusNameAcquiredCallback gi'funptrptr gi'cb connection name userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    name' <- cstringToText name
    gi'cb  connection' name' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback BusAcquiredCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "connection"
          , argType =
              TInterface Name { namespace = "Gio" , name = "DBusConnection" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the connection to a message bus"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the name that is requested to be owned"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to [func@Gio.bus_own_name]"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Invoked when a connection to a message bus has been obtained."
        , sinceVersion = Just "2.26"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_BusAcquiredCallback =
    Ptr Gio.DBusConnection.DBusConnection ->
    CString ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "connection"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the connection to a message bus"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name that is requested to be owned"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to [func@Gio.bus_own_name]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_BusAcquiredCallback :: FunPtr C_BusAcquiredCallback -> C_BusAcquiredCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_BusAcquiredCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.DBusConnection.IsDBusConnection a) =>
    FunPtr C_BusAcquiredCallback
    -> a
    -- ^ /@connection@/: the connection to a message bus
    -> T.Text
    -- ^ /@name@/: the name that is requested to be owned
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.Gio.Functions.busOwnName'
    -> m ()
dynamic_BusAcquiredCallback __funPtr connection name userData = liftIO $ do
    connection' <- unsafeManagedPtrCastPtr connection
    name' <- textToCString name
    (__dynamic_C_BusAcquiredCallback __funPtr) connection' name' userData
    touchManagedPtr connection
    freeMem name'
    return ()

-- | Generate a function pointer callable from C code, from a `C_BusAcquiredCallback`.
foreign import ccall "wrapper"
    mk_BusAcquiredCallback :: C_BusAcquiredCallback -> IO (FunPtr C_BusAcquiredCallback)

-- | Invoked when a connection to a message bus has been obtained.
-- 
-- /Since: 2.26/
type BusAcquiredCallback =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: the connection to a message bus
    -> T.Text
    -- ^ /@name@/: the name that is requested to be owned
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BusAcquiredCallback`@.
noBusAcquiredCallback :: Maybe BusAcquiredCallback
noBusAcquiredCallback = Nothing

-- | Invoked when a connection to a message bus has been obtained.
-- 
-- /Since: 2.26/
type BusAcquiredCallback_WithClosures =
    Gio.DBusConnection.DBusConnection
    -- ^ /@connection@/: the connection to a message bus
    -> T.Text
    -- ^ /@name@/: the name that is requested to be owned
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.Gio.Functions.busOwnName'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `BusAcquiredCallback_WithClosures`@.
noBusAcquiredCallback_WithClosures :: Maybe BusAcquiredCallback_WithClosures
noBusAcquiredCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_BusAcquiredCallback :: BusAcquiredCallback -> BusAcquiredCallback_WithClosures
drop_closures_BusAcquiredCallback _f connection name _ = _f connection name

-- | Wrap the callback into a `GClosure`.
genClosure_BusAcquiredCallback :: MonadIO m => BusAcquiredCallback -> m (GClosure C_BusAcquiredCallback)
genClosure_BusAcquiredCallback cb = liftIO $ do
    let cb' = drop_closures_BusAcquiredCallback cb
    let cb'' = wrap_BusAcquiredCallback Nothing cb'
    mk_BusAcquiredCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `BusAcquiredCallback` into a `C_BusAcquiredCallback`.
wrap_BusAcquiredCallback :: 
    Maybe (Ptr (FunPtr C_BusAcquiredCallback)) ->
    BusAcquiredCallback_WithClosures ->
    C_BusAcquiredCallback
wrap_BusAcquiredCallback gi'funptrptr gi'cb connection name userData = do
    connection' <- (newObject Gio.DBusConnection.DBusConnection) connection
    name' <- cstringToText name
    gi'cb  connection' name' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback AsyncReadyCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "source_object"
          , argType =
              TInterface Name { namespace = "GObject" , name = "Object" }
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the object the asynchronous operation was started with."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "res"
          , argType =
              TInterface Name { namespace = "Gio" , name = "AsyncResult" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to the callback."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Type definition for a function that will be called back when an asynchronous\noperation within GIO has been completed. #GAsyncReadyCallback\ncallbacks from #GTask are guaranteed to be invoked in a later\niteration of the thread-default main context\n(see [method@GLib.MainContext.push_thread_default])\nwhere the #GTask was created. All other users of\n#GAsyncReadyCallback must likewise call it asynchronously in a\nlater iteration of the main context.\n\nThe asynchronous operation is guaranteed to have held a reference to\n@source_object from the time when the `*_async()` function was called, until\nafter this callback returns."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_AsyncReadyCallback =
    Ptr GObject.Object.Object ->
    Ptr Gio.AsyncResult.AsyncResult ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "source_object"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the object the asynchronous operation was started with."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncResult." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to the callback."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_AsyncReadyCallback :: FunPtr C_AsyncReadyCallback -> C_AsyncReadyCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_AsyncReadyCallback ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a, Gio.AsyncResult.IsAsyncResult b) =>
    FunPtr C_AsyncReadyCallback
    -> Maybe (a)
    -- ^ /@sourceObject@/: the object the asynchronous operation was started with.
    -> b
    -- ^ /@res@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> Ptr ()
    -- ^ /@data@/: user data passed to the callback.
    -> m ()
dynamic_AsyncReadyCallback __funPtr sourceObject res data_ = liftIO $ do
    maybeSourceObject <- case sourceObject of
        Nothing -> return FP.nullPtr
        Just jSourceObject -> do
            jSourceObject' <- unsafeManagedPtrCastPtr jSourceObject
            return jSourceObject'
    res' <- unsafeManagedPtrCastPtr res
    (__dynamic_C_AsyncReadyCallback __funPtr) maybeSourceObject res' data_
    whenJust sourceObject touchManagedPtr
    touchManagedPtr res
    return ()

-- | Generate a function pointer callable from C code, from a `C_AsyncReadyCallback`.
foreign import ccall "wrapper"
    mk_AsyncReadyCallback :: C_AsyncReadyCallback -> IO (FunPtr C_AsyncReadyCallback)

-- | Type definition for a function that will be called back when an asynchronous
-- operation within GIO has been completed. t'GI.Gio.Callbacks.AsyncReadyCallback'
-- callbacks from t'GI.Gio.Objects.Task.Task' are guaranteed to be invoked in a later
-- iteration of the thread-default main context
-- (see 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault')
-- where the t'GI.Gio.Objects.Task.Task' was created. All other users of
-- t'GI.Gio.Callbacks.AsyncReadyCallback' must likewise call it asynchronously in a
-- later iteration of the main context.
-- 
-- The asynchronous operation is guaranteed to have held a reference to
-- /@sourceObject@/ from the time when the @*_async()@ function was called, until
-- after this callback returns.
type AsyncReadyCallback =
    Maybe GObject.Object.Object
    -- ^ /@sourceObject@/: the object the asynchronous operation was started with.
    -> Gio.AsyncResult.AsyncResult
    -- ^ /@res@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `AsyncReadyCallback`@.
noAsyncReadyCallback :: Maybe AsyncReadyCallback
noAsyncReadyCallback = Nothing

-- | Type definition for a function that will be called back when an asynchronous
-- operation within GIO has been completed. t'GI.Gio.Callbacks.AsyncReadyCallback'
-- callbacks from t'GI.Gio.Objects.Task.Task' are guaranteed to be invoked in a later
-- iteration of the thread-default main context
-- (see 'GI.GLib.Structs.MainContext.mainContextPushThreadDefault')
-- where the t'GI.Gio.Objects.Task.Task' was created. All other users of
-- t'GI.Gio.Callbacks.AsyncReadyCallback' must likewise call it asynchronously in a
-- later iteration of the main context.
-- 
-- The asynchronous operation is guaranteed to have held a reference to
-- /@sourceObject@/ from the time when the @*_async()@ function was called, until
-- after this callback returns.
type AsyncReadyCallback_WithClosures =
    Maybe GObject.Object.Object
    -- ^ /@sourceObject@/: the object the asynchronous operation was started with.
    -> Gio.AsyncResult.AsyncResult
    -- ^ /@res@/: a t'GI.Gio.Interfaces.AsyncResult.AsyncResult'.
    -> Ptr ()
    -- ^ /@data@/: user data passed to the callback.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `AsyncReadyCallback_WithClosures`@.
noAsyncReadyCallback_WithClosures :: Maybe AsyncReadyCallback_WithClosures
noAsyncReadyCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_AsyncReadyCallback :: AsyncReadyCallback -> AsyncReadyCallback_WithClosures
drop_closures_AsyncReadyCallback _f sourceObject res _ = _f sourceObject res

-- | Wrap the callback into a `GClosure`.
genClosure_AsyncReadyCallback :: MonadIO m => AsyncReadyCallback -> m (GClosure C_AsyncReadyCallback)
genClosure_AsyncReadyCallback cb = liftIO $ do
    let cb' = drop_closures_AsyncReadyCallback cb
    let cb'' = wrap_AsyncReadyCallback Nothing cb'
    mk_AsyncReadyCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `AsyncReadyCallback` into a `C_AsyncReadyCallback`.
wrap_AsyncReadyCallback :: 
    Maybe (Ptr (FunPtr C_AsyncReadyCallback)) ->
    AsyncReadyCallback_WithClosures ->
    C_AsyncReadyCallback
wrap_AsyncReadyCallback gi'funptrptr gi'cb sourceObject res data_ = do
    maybeSourceObject <-
        if sourceObject == FP.nullPtr
        then return Nothing
        else do
            sourceObject' <- (newObject GObject.Object.Object) sourceObject
            return $ Just sourceObject'
    res' <- (newObject Gio.AsyncResult.AsyncResult) res
    gi'cb  maybeSourceObject res' data_
    maybeReleaseFunPtr gi'funptrptr


-- callback ActionEntryChangeStateFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "action"
          , argType =
              TInterface Name { namespace = "Gio" , name = "SimpleAction" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TVariant
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ActionEntryChangeStateFieldCallback =
    Ptr Gio.SimpleAction.SimpleAction ->
    Ptr GVariant ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "action"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ActionEntryChangeStateFieldCallback :: FunPtr C_ActionEntryChangeStateFieldCallback -> C_ActionEntryChangeStateFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ActionEntryChangeStateFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.SimpleAction.IsSimpleAction a) =>
    FunPtr C_ActionEntryChangeStateFieldCallback
    -> a
    -> GVariant
    -> Ptr ()
    -> m ()
dynamic_ActionEntryChangeStateFieldCallback __funPtr action value userData = liftIO $ do
    action' <- unsafeManagedPtrCastPtr action
    value' <- unsafeManagedPtrGetPtr value
    (__dynamic_C_ActionEntryChangeStateFieldCallback __funPtr) action' value' userData
    touchManagedPtr action
    touchManagedPtr value
    return ()

-- | Generate a function pointer callable from C code, from a `C_ActionEntryChangeStateFieldCallback`.
foreign import ccall "wrapper"
    mk_ActionEntryChangeStateFieldCallback :: C_ActionEntryChangeStateFieldCallback -> IO (FunPtr C_ActionEntryChangeStateFieldCallback)

-- | /No description available in the introspection data./
type ActionEntryChangeStateFieldCallback =
    Gio.SimpleAction.SimpleAction
    -> GVariant
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ActionEntryChangeStateFieldCallback`@.
noActionEntryChangeStateFieldCallback :: Maybe ActionEntryChangeStateFieldCallback
noActionEntryChangeStateFieldCallback = Nothing

-- | /No description available in the introspection data./
type ActionEntryChangeStateFieldCallback_WithClosures =
    Gio.SimpleAction.SimpleAction
    -> GVariant
    -> Ptr ()
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ActionEntryChangeStateFieldCallback_WithClosures`@.
noActionEntryChangeStateFieldCallback_WithClosures :: Maybe ActionEntryChangeStateFieldCallback_WithClosures
noActionEntryChangeStateFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ActionEntryChangeStateFieldCallback :: ActionEntryChangeStateFieldCallback -> ActionEntryChangeStateFieldCallback_WithClosures
drop_closures_ActionEntryChangeStateFieldCallback _f action value _ = _f action value

-- | Wrap the callback into a `GClosure`.
genClosure_ActionEntryChangeStateFieldCallback :: MonadIO m => ActionEntryChangeStateFieldCallback -> m (GClosure C_ActionEntryChangeStateFieldCallback)
genClosure_ActionEntryChangeStateFieldCallback cb = liftIO $ do
    let cb' = drop_closures_ActionEntryChangeStateFieldCallback cb
    let cb'' = wrap_ActionEntryChangeStateFieldCallback Nothing cb'
    mk_ActionEntryChangeStateFieldCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ActionEntryChangeStateFieldCallback` into a `C_ActionEntryChangeStateFieldCallback`.
wrap_ActionEntryChangeStateFieldCallback :: 
    Maybe (Ptr (FunPtr C_ActionEntryChangeStateFieldCallback)) ->
    ActionEntryChangeStateFieldCallback_WithClosures ->
    C_ActionEntryChangeStateFieldCallback
wrap_ActionEntryChangeStateFieldCallback gi'funptrptr gi'cb action value userData = do
    action' <- (newObject Gio.SimpleAction.SimpleAction) action
    value' <- B.GVariant.newGVariantFromPtr value
    gi'cb  action' value' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback ActionEntryActivateFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "action"
          , argType =
              TInterface Name { namespace = "Gio" , name = "SimpleAction" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "parameter"
          , argType = TVariant
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ActionEntryActivateFieldCallback =
    Ptr Gio.SimpleAction.SimpleAction ->
    Ptr GVariant ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "action"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parameter"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ActionEntryActivateFieldCallback :: FunPtr C_ActionEntryActivateFieldCallback -> C_ActionEntryActivateFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ActionEntryActivateFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.SimpleAction.IsSimpleAction a) =>
    FunPtr C_ActionEntryActivateFieldCallback
    -> a
    -> Maybe (GVariant)
    -> Ptr ()
    -> m ()
dynamic_ActionEntryActivateFieldCallback __funPtr action parameter userData = liftIO $ do
    action' <- unsafeManagedPtrCastPtr action
    maybeParameter <- case parameter of
        Nothing -> return FP.nullPtr
        Just jParameter -> do
            jParameter' <- unsafeManagedPtrGetPtr jParameter
            return jParameter'
    (__dynamic_C_ActionEntryActivateFieldCallback __funPtr) action' maybeParameter userData
    touchManagedPtr action
    whenJust parameter touchManagedPtr
    return ()

-- | Generate a function pointer callable from C code, from a `C_ActionEntryActivateFieldCallback`.
foreign import ccall "wrapper"
    mk_ActionEntryActivateFieldCallback :: C_ActionEntryActivateFieldCallback -> IO (FunPtr C_ActionEntryActivateFieldCallback)

-- | /No description available in the introspection data./
type ActionEntryActivateFieldCallback =
    Gio.SimpleAction.SimpleAction
    -> Maybe GVariant
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ActionEntryActivateFieldCallback`@.
noActionEntryActivateFieldCallback :: Maybe ActionEntryActivateFieldCallback
noActionEntryActivateFieldCallback = Nothing

-- | /No description available in the introspection data./
type ActionEntryActivateFieldCallback_WithClosures =
    Gio.SimpleAction.SimpleAction
    -> Maybe GVariant
    -> Ptr ()
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ActionEntryActivateFieldCallback_WithClosures`@.
noActionEntryActivateFieldCallback_WithClosures :: Maybe ActionEntryActivateFieldCallback_WithClosures
noActionEntryActivateFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ActionEntryActivateFieldCallback :: ActionEntryActivateFieldCallback -> ActionEntryActivateFieldCallback_WithClosures
drop_closures_ActionEntryActivateFieldCallback _f action parameter _ = _f action parameter

-- | Wrap the callback into a `GClosure`.
genClosure_ActionEntryActivateFieldCallback :: MonadIO m => ActionEntryActivateFieldCallback -> m (GClosure C_ActionEntryActivateFieldCallback)
genClosure_ActionEntryActivateFieldCallback cb = liftIO $ do
    let cb' = drop_closures_ActionEntryActivateFieldCallback cb
    let cb'' = wrap_ActionEntryActivateFieldCallback Nothing cb'
    mk_ActionEntryActivateFieldCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ActionEntryActivateFieldCallback` into a `C_ActionEntryActivateFieldCallback`.
wrap_ActionEntryActivateFieldCallback :: 
    Maybe (Ptr (FunPtr C_ActionEntryActivateFieldCallback)) ->
    ActionEntryActivateFieldCallback_WithClosures ->
    C_ActionEntryActivateFieldCallback
wrap_ActionEntryActivateFieldCallback gi'funptrptr gi'cb action parameter userData = do
    action' <- (newObject Gio.SimpleAction.SimpleAction) action
    maybeParameter <-
        if parameter == FP.nullPtr
        then return Nothing
        else do
            parameter' <- B.GVariant.newGVariantFromPtr parameter
            return $ Just parameter'
    gi'cb  action' maybeParameter userData
    maybeReleaseFunPtr gi'funptrptr



