{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11Screen
    ( 

-- * Exported types
    X11Screen(..)                           ,
    IsX11Screen                             ,
    toX11Screen                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isComposited]("GI.Gdk.Objects.Screen#g:method:isComposited"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listVisuals]("GI.Gdk.Objects.Screen#g:method:listVisuals"), [lookupVisual]("GI.GdkX11.Objects.X11Screen#g:method:lookupVisual"), [makeDisplayName]("GI.Gdk.Objects.Screen#g:method:makeDisplayName"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [supportsNetWmHint]("GI.GdkX11.Objects.X11Screen#g:method:supportsNetWmHint"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActiveWindow]("GI.Gdk.Objects.Screen#g:method:getActiveWindow"), [getCurrentDesktop]("GI.GdkX11.Objects.X11Screen#g:method:getCurrentDesktop"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.Screen#g:method:getDisplay"), [getFontOptions]("GI.Gdk.Objects.Screen#g:method:getFontOptions"), [getHeight]("GI.Gdk.Objects.Screen#g:method:getHeight"), [getHeightMm]("GI.Gdk.Objects.Screen#g:method:getHeightMm"), [getMonitorAtPoint]("GI.Gdk.Objects.Screen#g:method:getMonitorAtPoint"), [getMonitorAtWindow]("GI.Gdk.Objects.Screen#g:method:getMonitorAtWindow"), [getMonitorGeometry]("GI.Gdk.Objects.Screen#g:method:getMonitorGeometry"), [getMonitorHeightMm]("GI.Gdk.Objects.Screen#g:method:getMonitorHeightMm"), [getMonitorOutput]("GI.GdkX11.Objects.X11Screen#g:method:getMonitorOutput"), [getMonitorPlugName]("GI.Gdk.Objects.Screen#g:method:getMonitorPlugName"), [getMonitorScaleFactor]("GI.Gdk.Objects.Screen#g:method:getMonitorScaleFactor"), [getMonitorWidthMm]("GI.Gdk.Objects.Screen#g:method:getMonitorWidthMm"), [getMonitorWorkarea]("GI.Gdk.Objects.Screen#g:method:getMonitorWorkarea"), [getNMonitors]("GI.Gdk.Objects.Screen#g:method:getNMonitors"), [getNumber]("GI.Gdk.Objects.Screen#g:method:getNumber"), [getNumberOfDesktops]("GI.GdkX11.Objects.X11Screen#g:method:getNumberOfDesktops"), [getPrimaryMonitor]("GI.Gdk.Objects.Screen#g:method:getPrimaryMonitor"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getResolution]("GI.Gdk.Objects.Screen#g:method:getResolution"), [getRgbaVisual]("GI.Gdk.Objects.Screen#g:method:getRgbaVisual"), [getRootWindow]("GI.Gdk.Objects.Screen#g:method:getRootWindow"), [getScreenNumber]("GI.GdkX11.Objects.X11Screen#g:method:getScreenNumber"), [getSetting]("GI.Gdk.Objects.Screen#g:method:getSetting"), [getSystemVisual]("GI.Gdk.Objects.Screen#g:method:getSystemVisual"), [getToplevelWindows]("GI.Gdk.Objects.Screen#g:method:getToplevelWindows"), [getWidth]("GI.Gdk.Objects.Screen#g:method:getWidth"), [getWidthMm]("GI.Gdk.Objects.Screen#g:method:getWidthMm"), [getWindowManagerName]("GI.GdkX11.Objects.X11Screen#g:method:getWindowManagerName"), [getWindowStack]("GI.Gdk.Objects.Screen#g:method:getWindowStack"), [getXscreen]("GI.GdkX11.Objects.X11Screen#g:method:getXscreen").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFontOptions]("GI.Gdk.Objects.Screen#g:method:setFontOptions"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setResolution]("GI.Gdk.Objects.Screen#g:method:setResolution").

#if defined(ENABLE_OVERLOADING)
    ResolveX11ScreenMethod                  ,
#endif

-- ** getCurrentDesktop #method:getCurrentDesktop#

#if defined(ENABLE_OVERLOADING)
    X11ScreenGetCurrentDesktopMethodInfo    ,
#endif
    x11ScreenGetCurrentDesktop              ,


-- ** getMonitorOutput #method:getMonitorOutput#

#if defined(ENABLE_OVERLOADING)
    X11ScreenGetMonitorOutputMethodInfo     ,
#endif
    x11ScreenGetMonitorOutput               ,


-- ** getNumberOfDesktops #method:getNumberOfDesktops#

#if defined(ENABLE_OVERLOADING)
    X11ScreenGetNumberOfDesktopsMethodInfo  ,
#endif
    x11ScreenGetNumberOfDesktops            ,


-- ** getScreenNumber #method:getScreenNumber#

#if defined(ENABLE_OVERLOADING)
    X11ScreenGetScreenNumberMethodInfo      ,
#endif
    x11ScreenGetScreenNumber                ,


-- ** getWindowManagerName #method:getWindowManagerName#

#if defined(ENABLE_OVERLOADING)
    X11ScreenGetWindowManagerNameMethodInfo ,
#endif
    x11ScreenGetWindowManagerName           ,


-- ** getXscreen #method:getXscreen#

#if defined(ENABLE_OVERLOADING)
    X11ScreenGetXscreenMethodInfo           ,
#endif
    x11ScreenGetXscreen                     ,


-- ** lookupVisual #method:lookupVisual#

#if defined(ENABLE_OVERLOADING)
    X11ScreenLookupVisualMethodInfo         ,
#endif
    x11ScreenLookupVisual                   ,


-- ** supportsNetWmHint #method:supportsNetWmHint#

#if defined(ENABLE_OVERLOADING)
    X11ScreenSupportsNetWmHintMethodInfo    ,
#endif
    x11ScreenSupportsNetWmHint              ,




 -- * Signals


-- ** windowManagerChanged #signal:windowManagerChanged#

    X11ScreenWindowManagerChangedCallback   ,
#if defined(ENABLE_OVERLOADING)
    X11ScreenWindowManagerChangedSignalInfo ,
#endif
    afterX11ScreenWindowManagerChanged      ,
    onX11ScreenWindowManagerChanged         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Screen as Gdk.Screen
import qualified GI.Gdk.Objects.Visual as Gdk.Visual
import qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Visual as GdkX11.X11Visual
import qualified GI.Xlib.Structs.Screen as Xlib.Screen
import qualified GI.Xlib.Structs.Visual as Xlib.Visual

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Screen as Gdk.Screen
import qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Visual as GdkX11.X11Visual
import qualified GI.Xlib.Structs.Screen as Xlib.Screen

#endif

-- | Memory-managed wrapper type.
newtype X11Screen = X11Screen (SP.ManagedPtr X11Screen)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11Screen where
    toManagedPtr (X11Screen p) = p

foreign import ccall "gdk_x11_screen_get_type"
    c_gdk_x11_screen_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11Screen where
    glibType = c_gdk_x11_screen_get_type

instance B.Types.GObject X11Screen

-- | Type class for types which can be safely cast to `X11Screen`, for instance with `toX11Screen`.
class (SP.GObject o, O.IsDescendantOf X11Screen o) => IsX11Screen o
instance (SP.GObject o, O.IsDescendantOf X11Screen o) => IsX11Screen o

instance O.HasParentTypes X11Screen
type instance O.ParentTypes X11Screen = '[Gdk.Screen.Screen, GObject.Object.Object]

-- | Cast to `X11Screen`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toX11Screen :: (MIO.MonadIO m, IsX11Screen o) => o -> m X11Screen
toX11Screen = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11Screen

-- | Convert 'X11Screen' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11Screen) where
    gvalueGType_ = c_gdk_x11_screen_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11Screen)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11Screen)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11Screen ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11ScreenMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11ScreenMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11ScreenMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11ScreenMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11ScreenMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11ScreenMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11ScreenMethod "isComposited" o = Gdk.Screen.ScreenIsCompositedMethodInfo
    ResolveX11ScreenMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11ScreenMethod "listVisuals" o = Gdk.Screen.ScreenListVisualsMethodInfo
    ResolveX11ScreenMethod "lookupVisual" o = X11ScreenLookupVisualMethodInfo
    ResolveX11ScreenMethod "makeDisplayName" o = Gdk.Screen.ScreenMakeDisplayNameMethodInfo
    ResolveX11ScreenMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11ScreenMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11ScreenMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11ScreenMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11ScreenMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11ScreenMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11ScreenMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11ScreenMethod "supportsNetWmHint" o = X11ScreenSupportsNetWmHintMethodInfo
    ResolveX11ScreenMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11ScreenMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11ScreenMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11ScreenMethod "getActiveWindow" o = Gdk.Screen.ScreenGetActiveWindowMethodInfo
    ResolveX11ScreenMethod "getCurrentDesktop" o = X11ScreenGetCurrentDesktopMethodInfo
    ResolveX11ScreenMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11ScreenMethod "getDisplay" o = Gdk.Screen.ScreenGetDisplayMethodInfo
    ResolveX11ScreenMethod "getFontOptions" o = Gdk.Screen.ScreenGetFontOptionsMethodInfo
    ResolveX11ScreenMethod "getHeight" o = Gdk.Screen.ScreenGetHeightMethodInfo
    ResolveX11ScreenMethod "getHeightMm" o = Gdk.Screen.ScreenGetHeightMmMethodInfo
    ResolveX11ScreenMethod "getMonitorAtPoint" o = Gdk.Screen.ScreenGetMonitorAtPointMethodInfo
    ResolveX11ScreenMethod "getMonitorAtWindow" o = Gdk.Screen.ScreenGetMonitorAtWindowMethodInfo
    ResolveX11ScreenMethod "getMonitorGeometry" o = Gdk.Screen.ScreenGetMonitorGeometryMethodInfo
    ResolveX11ScreenMethod "getMonitorHeightMm" o = Gdk.Screen.ScreenGetMonitorHeightMmMethodInfo
    ResolveX11ScreenMethod "getMonitorOutput" o = X11ScreenGetMonitorOutputMethodInfo
    ResolveX11ScreenMethod "getMonitorPlugName" o = Gdk.Screen.ScreenGetMonitorPlugNameMethodInfo
    ResolveX11ScreenMethod "getMonitorScaleFactor" o = Gdk.Screen.ScreenGetMonitorScaleFactorMethodInfo
    ResolveX11ScreenMethod "getMonitorWidthMm" o = Gdk.Screen.ScreenGetMonitorWidthMmMethodInfo
    ResolveX11ScreenMethod "getMonitorWorkarea" o = Gdk.Screen.ScreenGetMonitorWorkareaMethodInfo
    ResolveX11ScreenMethod "getNMonitors" o = Gdk.Screen.ScreenGetNMonitorsMethodInfo
    ResolveX11ScreenMethod "getNumber" o = Gdk.Screen.ScreenGetNumberMethodInfo
    ResolveX11ScreenMethod "getNumberOfDesktops" o = X11ScreenGetNumberOfDesktopsMethodInfo
    ResolveX11ScreenMethod "getPrimaryMonitor" o = Gdk.Screen.ScreenGetPrimaryMonitorMethodInfo
    ResolveX11ScreenMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11ScreenMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11ScreenMethod "getResolution" o = Gdk.Screen.ScreenGetResolutionMethodInfo
    ResolveX11ScreenMethod "getRgbaVisual" o = Gdk.Screen.ScreenGetRgbaVisualMethodInfo
    ResolveX11ScreenMethod "getRootWindow" o = Gdk.Screen.ScreenGetRootWindowMethodInfo
    ResolveX11ScreenMethod "getScreenNumber" o = X11ScreenGetScreenNumberMethodInfo
    ResolveX11ScreenMethod "getSetting" o = Gdk.Screen.ScreenGetSettingMethodInfo
    ResolveX11ScreenMethod "getSystemVisual" o = Gdk.Screen.ScreenGetSystemVisualMethodInfo
    ResolveX11ScreenMethod "getToplevelWindows" o = Gdk.Screen.ScreenGetToplevelWindowsMethodInfo
    ResolveX11ScreenMethod "getWidth" o = Gdk.Screen.ScreenGetWidthMethodInfo
    ResolveX11ScreenMethod "getWidthMm" o = Gdk.Screen.ScreenGetWidthMmMethodInfo
    ResolveX11ScreenMethod "getWindowManagerName" o = X11ScreenGetWindowManagerNameMethodInfo
    ResolveX11ScreenMethod "getWindowStack" o = Gdk.Screen.ScreenGetWindowStackMethodInfo
    ResolveX11ScreenMethod "getXscreen" o = X11ScreenGetXscreenMethodInfo
    ResolveX11ScreenMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11ScreenMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11ScreenMethod "setFontOptions" o = Gdk.Screen.ScreenSetFontOptionsMethodInfo
    ResolveX11ScreenMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11ScreenMethod "setResolution" o = Gdk.Screen.ScreenSetResolutionMethodInfo
    ResolveX11ScreenMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11ScreenMethod t X11Screen, O.OverloadedMethod info X11Screen p) => OL.IsLabel t (X11Screen -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11ScreenMethod t X11Screen, O.OverloadedMethod info X11Screen p, R.HasField t X11Screen p) => R.HasField t X11Screen p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11ScreenMethod t X11Screen, O.OverloadedMethodInfo info X11Screen) => OL.IsLabel t (O.MethodProxy info X11Screen) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal X11Screen::window-manager-changed
-- | /No description available in the introspection data./
type X11ScreenWindowManagerChangedCallback =
    IO ()

type C_X11ScreenWindowManagerChangedCallback =
    Ptr X11Screen ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_X11ScreenWindowManagerChangedCallback`.
foreign import ccall "wrapper"
    mk_X11ScreenWindowManagerChangedCallback :: C_X11ScreenWindowManagerChangedCallback -> IO (FunPtr C_X11ScreenWindowManagerChangedCallback)

wrap_X11ScreenWindowManagerChangedCallback :: 
    GObject a => (a -> X11ScreenWindowManagerChangedCallback) ->
    C_X11ScreenWindowManagerChangedCallback
wrap_X11ScreenWindowManagerChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [windowManagerChanged](#signal:windowManagerChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' x11Screen #windowManagerChanged callback
-- @
-- 
-- 
onX11ScreenWindowManagerChanged :: (IsX11Screen a, MonadIO m) => a -> ((?self :: a) => X11ScreenWindowManagerChangedCallback) -> m SignalHandlerId
onX11ScreenWindowManagerChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_X11ScreenWindowManagerChangedCallback wrapped
    wrapped'' <- mk_X11ScreenWindowManagerChangedCallback wrapped'
    connectSignalFunPtr obj "window-manager-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [windowManagerChanged](#signal:windowManagerChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' x11Screen #windowManagerChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterX11ScreenWindowManagerChanged :: (IsX11Screen a, MonadIO m) => a -> ((?self :: a) => X11ScreenWindowManagerChangedCallback) -> m SignalHandlerId
afterX11ScreenWindowManagerChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_X11ScreenWindowManagerChangedCallback wrapped
    wrapped'' <- mk_X11ScreenWindowManagerChangedCallback wrapped'
    connectSignalFunPtr obj "window-manager-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data X11ScreenWindowManagerChangedSignalInfo
instance SignalInfo X11ScreenWindowManagerChangedSignalInfo where
    type HaskellCallbackType X11ScreenWindowManagerChangedSignalInfo = X11ScreenWindowManagerChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_X11ScreenWindowManagerChangedCallback cb
        cb'' <- mk_X11ScreenWindowManagerChangedCallback cb'
        connectSignalFunPtr obj "window-manager-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Screen::window-manager-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Screen.html#g:signal:windowManagerChanged"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11Screen
type instance O.AttributeList X11Screen = X11ScreenAttributeList
type X11ScreenAttributeList = ('[ '("fontOptions", Gdk.Screen.ScreenFontOptionsPropertyInfo), '("resolution", Gdk.Screen.ScreenResolutionPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11Screen = X11ScreenSignalList
type X11ScreenSignalList = ('[ '("compositedChanged", Gdk.Screen.ScreenCompositedChangedSignalInfo), '("monitorsChanged", Gdk.Screen.ScreenMonitorsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("sizeChanged", Gdk.Screen.ScreenSizeChangedSignalInfo), '("windowManagerChanged", X11ScreenWindowManagerChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method X11Screen::get_current_desktop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_screen_get_current_desktop" gdk_x11_screen_get_current_desktop :: 
    Ptr X11Screen ->                        -- screen : TInterface (Name {namespace = "GdkX11", name = "X11Screen"})
    IO Word32

-- | Returns the current workspace for /@screen@/ when running under a
-- window manager that supports multiple workspaces, as described
-- in the
-- <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints> specification.
-- 
-- /Since: 3.10/
x11ScreenGetCurrentDesktop ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Screen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Word32
    -- ^ __Returns:__ the current workspace, or 0 if workspaces are not supported
x11ScreenGetCurrentDesktop screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_x11_screen_get_current_desktop screen'
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data X11ScreenGetCurrentDesktopMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsX11Screen a) => O.OverloadedMethod X11ScreenGetCurrentDesktopMethodInfo a signature where
    overloadedMethod = x11ScreenGetCurrentDesktop

instance O.OverloadedMethodInfo X11ScreenGetCurrentDesktopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Screen.x11ScreenGetCurrentDesktop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Screen.html#v:x11ScreenGetCurrentDesktop"
        })


#endif

-- method X11Screen::get_monitor_output
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monitor_num"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "number of the monitor, between 0 and gdk_screen_get_n_monitors (screen)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_screen_get_monitor_output" gdk_x11_screen_get_monitor_output :: 
    Ptr X11Screen ->                        -- screen : TInterface (Name {namespace = "GdkX11", name = "X11Screen"})
    Int32 ->                                -- monitor_num : TBasicType TInt
    IO FCT.CULong

-- | Gets the XID of the specified output\/monitor.
-- If the X server does not support version 1.2 of the RANDR
-- extension, 0 is returned.
-- 
-- /Since: 2.14/
x11ScreenGetMonitorOutput ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Screen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> Int32
    -- ^ /@monitorNum@/: number of the monitor, between 0 and gdk_screen_get_n_monitors (screen)
    -> m FCT.CULong
    -- ^ __Returns:__ the XID of the monitor
x11ScreenGetMonitorOutput screen monitorNum = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_x11_screen_get_monitor_output screen' monitorNum
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data X11ScreenGetMonitorOutputMethodInfo
instance (signature ~ (Int32 -> m FCT.CULong), MonadIO m, IsX11Screen a) => O.OverloadedMethod X11ScreenGetMonitorOutputMethodInfo a signature where
    overloadedMethod = x11ScreenGetMonitorOutput

instance O.OverloadedMethodInfo X11ScreenGetMonitorOutputMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Screen.x11ScreenGetMonitorOutput",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Screen.html#v:x11ScreenGetMonitorOutput"
        })


#endif

-- method X11Screen::get_number_of_desktops
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_screen_get_number_of_desktops" gdk_x11_screen_get_number_of_desktops :: 
    Ptr X11Screen ->                        -- screen : TInterface (Name {namespace = "GdkX11", name = "X11Screen"})
    IO Word32

-- | Returns the number of workspaces for /@screen@/ when running under a
-- window manager that supports multiple workspaces, as described
-- in the
-- <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints> specification.
-- 
-- /Since: 3.10/
x11ScreenGetNumberOfDesktops ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Screen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Word32
    -- ^ __Returns:__ the number of workspaces, or 0 if workspaces are not supported
x11ScreenGetNumberOfDesktops screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_x11_screen_get_number_of_desktops screen'
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data X11ScreenGetNumberOfDesktopsMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsX11Screen a) => O.OverloadedMethod X11ScreenGetNumberOfDesktopsMethodInfo a signature where
    overloadedMethod = x11ScreenGetNumberOfDesktops

instance O.OverloadedMethodInfo X11ScreenGetNumberOfDesktopsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Screen.x11ScreenGetNumberOfDesktops",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Screen.html#v:x11ScreenGetNumberOfDesktops"
        })


#endif

-- method X11Screen::get_screen_number
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_screen_get_screen_number" gdk_x11_screen_get_screen_number :: 
    Ptr X11Screen ->                        -- screen : TInterface (Name {namespace = "GdkX11", name = "X11Screen"})
    IO Int32

-- | Returns the index of a t'GI.Gdk.Objects.Screen.Screen'.
-- 
-- /Since: 2.2/
x11ScreenGetScreenNumber ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Screen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Int32
    -- ^ __Returns:__ the position of /@screen@/ among the screens
    --     of its display
x11ScreenGetScreenNumber screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_x11_screen_get_screen_number screen'
    touchManagedPtr screen
    return result

#if defined(ENABLE_OVERLOADING)
data X11ScreenGetScreenNumberMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsX11Screen a) => O.OverloadedMethod X11ScreenGetScreenNumberMethodInfo a signature where
    overloadedMethod = x11ScreenGetScreenNumber

instance O.OverloadedMethodInfo X11ScreenGetScreenNumberMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Screen.x11ScreenGetScreenNumber",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Screen.html#v:x11ScreenGetScreenNumber"
        })


#endif

-- method X11Screen::get_window_manager_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_screen_get_window_manager_name" gdk_x11_screen_get_window_manager_name :: 
    Ptr X11Screen ->                        -- screen : TInterface (Name {namespace = "GdkX11", name = "X11Screen"})
    IO CString

-- | Returns the name of the window manager for /@screen@/.
-- 
-- /Since: 2.2/
x11ScreenGetWindowManagerName ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Screen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m T.Text
    -- ^ __Returns:__ the name of the window manager screen /@screen@/, or
    -- \"unknown\" if the window manager is unknown. The string is owned by GDK
    -- and should not be freed.
x11ScreenGetWindowManagerName screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_x11_screen_get_window_manager_name screen'
    checkUnexpectedReturnNULL "x11ScreenGetWindowManagerName" result
    result' <- cstringToText result
    touchManagedPtr screen
    return result'

#if defined(ENABLE_OVERLOADING)
data X11ScreenGetWindowManagerNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsX11Screen a) => O.OverloadedMethod X11ScreenGetWindowManagerNameMethodInfo a signature where
    overloadedMethod = x11ScreenGetWindowManagerName

instance O.OverloadedMethodInfo X11ScreenGetWindowManagerNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Screen.x11ScreenGetWindowManagerName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Screen.html#v:x11ScreenGetWindowManagerName"
        })


#endif

-- method X11Screen::get_xscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "xlib" , name = "Screen" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_screen_get_xscreen" gdk_x11_screen_get_xscreen :: 
    Ptr X11Screen ->                        -- screen : TInterface (Name {namespace = "GdkX11", name = "X11Screen"})
    IO (Ptr Xlib.Screen.Screen)

-- | Returns the screen of a t'GI.Gdk.Objects.Screen.Screen'.
-- 
-- /Since: 2.2/
x11ScreenGetXscreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Screen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'
    -> m Xlib.Screen.Screen
    -- ^ __Returns:__ an Xlib Screen*
x11ScreenGetXscreen screen = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_x11_screen_get_xscreen screen'
    checkUnexpectedReturnNULL "x11ScreenGetXscreen" result
    result' <- (newPtr Xlib.Screen.Screen) result
    touchManagedPtr screen
    return result'

#if defined(ENABLE_OVERLOADING)
data X11ScreenGetXscreenMethodInfo
instance (signature ~ (m Xlib.Screen.Screen), MonadIO m, IsX11Screen a) => O.OverloadedMethod X11ScreenGetXscreenMethodInfo a signature where
    overloadedMethod = x11ScreenGetXscreen

instance O.OverloadedMethodInfo X11ScreenGetXscreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Screen.x11ScreenGetXscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Screen.html#v:x11ScreenGetXscreen"
        })


#endif

-- method X11Screen::lookup_visual
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkScreen." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xvisualid"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an X Visual ID." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkX11" , name = "X11Visual" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_screen_lookup_visual" gdk_x11_screen_lookup_visual :: 
    Ptr X11Screen ->                        -- screen : TInterface (Name {namespace = "GdkX11", name = "X11Screen"})
    FCT.CULong ->                           -- xvisualid : TBasicType TULong
    IO (Ptr GdkX11.X11Visual.X11Visual)

-- | Looks up the t'GI.Gdk.Objects.Visual.Visual' for a particular screen and X Visual ID.
-- 
-- /Since: 2.2/
x11ScreenLookupVisual ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Screen a) =>
    a
    -- ^ /@screen@/: a t'GI.Gdk.Objects.Screen.Screen'.
    -> FCT.CULong
    -- ^ /@xvisualid@/: an X Visual ID.
    -> m GdkX11.X11Visual.X11Visual
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Visual.Visual' (owned by the screen
    --   object), or 'P.Nothing' if the visual ID wasn’t found.
x11ScreenLookupVisual screen xvisualid = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    result <- gdk_x11_screen_lookup_visual screen' xvisualid
    checkUnexpectedReturnNULL "x11ScreenLookupVisual" result
    result' <- (newObject GdkX11.X11Visual.X11Visual) result
    touchManagedPtr screen
    return result'

#if defined(ENABLE_OVERLOADING)
data X11ScreenLookupVisualMethodInfo
instance (signature ~ (FCT.CULong -> m GdkX11.X11Visual.X11Visual), MonadIO m, IsX11Screen a) => O.OverloadedMethod X11ScreenLookupVisualMethodInfo a signature where
    overloadedMethod = x11ScreenLookupVisual

instance O.OverloadedMethodInfo X11ScreenLookupVisualMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Screen.x11ScreenLookupVisual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Screen.html#v:x11ScreenLookupVisual"
        })


#endif

-- method X11Screen::supports_net_wm_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "screen"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the relevant #GdkScreen."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Atom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a property atom." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_screen_supports_net_wm_hint" gdk_x11_screen_supports_net_wm_hint :: 
    Ptr X11Screen ->                        -- screen : TInterface (Name {namespace = "GdkX11", name = "X11Screen"})
    Ptr Gdk.Atom.Atom ->                    -- property : TInterface (Name {namespace = "Gdk", name = "Atom"})
    IO CInt

-- | This function is specific to the X11 backend of GDK, and indicates
-- whether the window manager supports a certain hint from the
-- <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints> specification.
-- 
-- When using this function, keep in mind that the window manager
-- can change over time; so you shouldn’t use this function in
-- a way that impacts persistent application state. A common bug
-- is that your application can start up before the window manager
-- does when the user logs in, and before the window manager starts
-- 'GI.GdkX11.Objects.X11Screen.x11ScreenSupportsNetWmHint' will return 'P.False' for every property.
-- You can monitor the window_manager_changed signal on t'GI.Gdk.Objects.Screen.Screen' to detect
-- a window manager change.
-- 
-- /Since: 2.2/
x11ScreenSupportsNetWmHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Screen a) =>
    a
    -- ^ /@screen@/: the relevant t'GI.Gdk.Objects.Screen.Screen'.
    -> Gdk.Atom.Atom
    -- ^ /@property@/: a property atom.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the window manager supports /@property@/
x11ScreenSupportsNetWmHint screen property = liftIO $ do
    screen' <- unsafeManagedPtrCastPtr screen
    property' <- unsafeManagedPtrGetPtr property
    result <- gdk_x11_screen_supports_net_wm_hint screen' property'
    let result' = (/= 0) result
    touchManagedPtr screen
    touchManagedPtr property
    return result'

#if defined(ENABLE_OVERLOADING)
data X11ScreenSupportsNetWmHintMethodInfo
instance (signature ~ (Gdk.Atom.Atom -> m Bool), MonadIO m, IsX11Screen a) => O.OverloadedMethod X11ScreenSupportsNetWmHintMethodInfo a signature where
    overloadedMethod = x11ScreenSupportsNetWmHint

instance O.OverloadedMethodInfo X11ScreenSupportsNetWmHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Screen.x11ScreenSupportsNetWmHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Screen.html#v:x11ScreenSupportsNetWmHint"
        })


#endif


