{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11Keymap
    ( 

-- * Exported types
    X11Keymap(..)                           ,
    IsX11Keymap                             ,
    toX11Keymap                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addVirtualModifiers]("GI.Gdk.Objects.Keymap#g:method:addVirtualModifiers"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [haveBidiLayouts]("GI.Gdk.Objects.Keymap#g:method:haveBidiLayouts"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [keyIsModifier]("GI.GdkX11.Objects.X11Keymap#g:method:keyIsModifier"), [lookupKey]("GI.Gdk.Objects.Keymap#g:method:lookupKey"), [mapVirtualModifiers]("GI.Gdk.Objects.Keymap#g:method:mapVirtualModifiers"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateKeyboardState]("GI.Gdk.Objects.Keymap#g:method:translateKeyboardState"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCapsLockState]("GI.Gdk.Objects.Keymap#g:method:getCapsLockState"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gdk.Objects.Keymap#g:method:getDirection"), [getEntriesForKeycode]("GI.Gdk.Objects.Keymap#g:method:getEntriesForKeycode"), [getEntriesForKeyval]("GI.Gdk.Objects.Keymap#g:method:getEntriesForKeyval"), [getGroupForState]("GI.GdkX11.Objects.X11Keymap#g:method:getGroupForState"), [getModifierMask]("GI.Gdk.Objects.Keymap#g:method:getModifierMask"), [getModifierState]("GI.Gdk.Objects.Keymap#g:method:getModifierState"), [getNumLockState]("GI.Gdk.Objects.Keymap#g:method:getNumLockState"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScrollLockState]("GI.Gdk.Objects.Keymap#g:method:getScrollLockState").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveX11KeymapMethod                  ,
#endif

-- ** getGroupForState #method:getGroupForState#

#if defined(ENABLE_OVERLOADING)
    X11KeymapGetGroupForStateMethodInfo     ,
#endif
    x11KeymapGetGroupForState               ,


-- ** keyIsModifier #method:keyIsModifier#

#if defined(ENABLE_OVERLOADING)
    X11KeymapKeyIsModifierMethodInfo        ,
#endif
    x11KeymapKeyIsModifier                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Keymap as Gdk.Keymap

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Keymap as Gdk.Keymap

#endif

-- | Memory-managed wrapper type.
newtype X11Keymap = X11Keymap (SP.ManagedPtr X11Keymap)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11Keymap where
    toManagedPtr (X11Keymap p) = p

foreign import ccall "gdk_x11_keymap_get_type"
    c_gdk_x11_keymap_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11Keymap where
    glibType = c_gdk_x11_keymap_get_type

instance B.Types.GObject X11Keymap

-- | Type class for types which can be safely cast to `X11Keymap`, for instance with `toX11Keymap`.
class (SP.GObject o, O.IsDescendantOf X11Keymap o) => IsX11Keymap o
instance (SP.GObject o, O.IsDescendantOf X11Keymap o) => IsX11Keymap o

instance O.HasParentTypes X11Keymap
type instance O.ParentTypes X11Keymap = '[Gdk.Keymap.Keymap, GObject.Object.Object]

-- | Cast to `X11Keymap`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toX11Keymap :: (MIO.MonadIO m, IsX11Keymap o) => o -> m X11Keymap
toX11Keymap = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11Keymap

-- | Convert 'X11Keymap' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11Keymap) where
    gvalueGType_ = c_gdk_x11_keymap_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11Keymap)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11Keymap)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11Keymap ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11KeymapMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11KeymapMethod "addVirtualModifiers" o = Gdk.Keymap.KeymapAddVirtualModifiersMethodInfo
    ResolveX11KeymapMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11KeymapMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11KeymapMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11KeymapMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11KeymapMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11KeymapMethod "haveBidiLayouts" o = Gdk.Keymap.KeymapHaveBidiLayoutsMethodInfo
    ResolveX11KeymapMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11KeymapMethod "keyIsModifier" o = X11KeymapKeyIsModifierMethodInfo
    ResolveX11KeymapMethod "lookupKey" o = Gdk.Keymap.KeymapLookupKeyMethodInfo
    ResolveX11KeymapMethod "mapVirtualModifiers" o = Gdk.Keymap.KeymapMapVirtualModifiersMethodInfo
    ResolveX11KeymapMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11KeymapMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11KeymapMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11KeymapMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11KeymapMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11KeymapMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11KeymapMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11KeymapMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11KeymapMethod "translateKeyboardState" o = Gdk.Keymap.KeymapTranslateKeyboardStateMethodInfo
    ResolveX11KeymapMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11KeymapMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11KeymapMethod "getCapsLockState" o = Gdk.Keymap.KeymapGetCapsLockStateMethodInfo
    ResolveX11KeymapMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11KeymapMethod "getDirection" o = Gdk.Keymap.KeymapGetDirectionMethodInfo
    ResolveX11KeymapMethod "getEntriesForKeycode" o = Gdk.Keymap.KeymapGetEntriesForKeycodeMethodInfo
    ResolveX11KeymapMethod "getEntriesForKeyval" o = Gdk.Keymap.KeymapGetEntriesForKeyvalMethodInfo
    ResolveX11KeymapMethod "getGroupForState" o = X11KeymapGetGroupForStateMethodInfo
    ResolveX11KeymapMethod "getModifierMask" o = Gdk.Keymap.KeymapGetModifierMaskMethodInfo
    ResolveX11KeymapMethod "getModifierState" o = Gdk.Keymap.KeymapGetModifierStateMethodInfo
    ResolveX11KeymapMethod "getNumLockState" o = Gdk.Keymap.KeymapGetNumLockStateMethodInfo
    ResolveX11KeymapMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11KeymapMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11KeymapMethod "getScrollLockState" o = Gdk.Keymap.KeymapGetScrollLockStateMethodInfo
    ResolveX11KeymapMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11KeymapMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11KeymapMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11KeymapMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11KeymapMethod t X11Keymap, O.OverloadedMethod info X11Keymap p) => OL.IsLabel t (X11Keymap -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11KeymapMethod t X11Keymap, O.OverloadedMethod info X11Keymap p, R.HasField t X11Keymap p) => R.HasField t X11Keymap p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11KeymapMethod t X11Keymap, O.OverloadedMethodInfo info X11Keymap) => OL.IsLabel t (O.MethodProxy info X11Keymap) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11Keymap
type instance O.AttributeList X11Keymap = X11KeymapAttributeList
type X11KeymapAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11Keymap = X11KeymapSignalList
type X11KeymapSignalList = ('[ '("directionChanged", Gdk.Keymap.KeymapDirectionChangedSignalInfo), '("keysChanged", Gdk.Keymap.KeymapKeysChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("stateChanged", Gdk.Keymap.KeymapStateChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method X11Keymap::get_group_for_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkX11Keymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "raw state returned from X"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_keymap_get_group_for_state" gdk_x11_keymap_get_group_for_state :: 
    Ptr X11Keymap ->                        -- keymap : TInterface (Name {namespace = "GdkX11", name = "X11Keymap"})
    Word32 ->                               -- state : TBasicType TUInt
    IO Int32

-- | Extracts the group from the state field sent in an X Key event.
-- This is only needed for code processing raw X events, since t'GI.Gdk.Structs.EventKey.EventKey'
-- directly includes an is_modifier field.
-- 
-- /Since: 3.6/
x11KeymapGetGroupForState ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Keymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.GdkX11.Objects.X11Keymap.X11Keymap'
    -> Word32
    -- ^ /@state@/: raw state returned from X
    -> m Int32
    -- ^ __Returns:__ the index of the active keyboard group for the event
x11KeymapGetGroupForState keymap state = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    result <- gdk_x11_keymap_get_group_for_state keymap' state
    touchManagedPtr keymap
    return result

#if defined(ENABLE_OVERLOADING)
data X11KeymapGetGroupForStateMethodInfo
instance (signature ~ (Word32 -> m Int32), MonadIO m, IsX11Keymap a) => O.OverloadedMethod X11KeymapGetGroupForStateMethodInfo a signature where
    overloadedMethod = x11KeymapGetGroupForState

instance O.OverloadedMethodInfo X11KeymapGetGroupForStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Keymap.x11KeymapGetGroupForState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Keymap.html#v:x11KeymapGetGroupForState"
        })


#endif

-- method X11Keymap::key_is_modifier
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "keymap"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Keymap" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkX11Keymap" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keycode"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the hardware keycode from a key event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_keymap_key_is_modifier" gdk_x11_keymap_key_is_modifier :: 
    Ptr X11Keymap ->                        -- keymap : TInterface (Name {namespace = "GdkX11", name = "X11Keymap"})
    Word32 ->                               -- keycode : TBasicType TUInt
    IO CInt

-- | Determines whether a particular key code represents a key that
-- is a modifier. That is, it’s a key that normally just affects
-- the keyboard state and the behavior of other keys rather than
-- producing a direct effect itself. This is only needed for code
-- processing raw X events, since t'GI.Gdk.Structs.EventKey.EventKey' directly includes
-- an is_modifier field.
-- 
-- /Since: 3.6/
x11KeymapKeyIsModifier ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Keymap a) =>
    a
    -- ^ /@keymap@/: a t'GI.GdkX11.Objects.X11Keymap.X11Keymap'
    -> Word32
    -- ^ /@keycode@/: the hardware keycode from a key event
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the hardware keycode is a modifier key
x11KeymapKeyIsModifier keymap keycode = liftIO $ do
    keymap' <- unsafeManagedPtrCastPtr keymap
    result <- gdk_x11_keymap_key_is_modifier keymap' keycode
    let result' = (/= 0) result
    touchManagedPtr keymap
    return result'

#if defined(ENABLE_OVERLOADING)
data X11KeymapKeyIsModifierMethodInfo
instance (signature ~ (Word32 -> m Bool), MonadIO m, IsX11Keymap a) => O.OverloadedMethod X11KeymapKeyIsModifierMethodInfo a signature where
    overloadedMethod = x11KeymapKeyIsModifier

instance O.OverloadedMethodInfo X11KeymapKeyIsModifierMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Keymap.x11KeymapKeyIsModifier",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Keymap.html#v:x11KeymapKeyIsModifier"
        })


#endif


