{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11GLContext
    ( 

-- * Exported types
    X11GLContext(..)                        ,
    IsX11GLContext                          ,
    toX11GLContext                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isLegacy]("GI.Gdk.Objects.GLContext#g:method:isLegacy"), [makeCurrent]("GI.Gdk.Objects.GLContext#g:method:makeCurrent"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [realize]("GI.Gdk.Objects.GLContext#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDebugEnabled]("GI.Gdk.Objects.GLContext#g:method:getDebugEnabled"), [getDisplay]("GI.Gdk.Objects.GLContext#g:method:getDisplay"), [getForwardCompatible]("GI.Gdk.Objects.GLContext#g:method:getForwardCompatible"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRequiredVersion]("GI.Gdk.Objects.GLContext#g:method:getRequiredVersion"), [getSharedContext]("GI.Gdk.Objects.GLContext#g:method:getSharedContext"), [getUseEs]("GI.Gdk.Objects.GLContext#g:method:getUseEs"), [getVersion]("GI.Gdk.Objects.GLContext#g:method:getVersion"), [getWindow]("GI.Gdk.Objects.GLContext#g:method:getWindow").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDebugEnabled]("GI.Gdk.Objects.GLContext#g:method:setDebugEnabled"), [setForwardCompatible]("GI.Gdk.Objects.GLContext#g:method:setForwardCompatible"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRequiredVersion]("GI.Gdk.Objects.GLContext#g:method:setRequiredVersion"), [setUseEs]("GI.Gdk.Objects.GLContext#g:method:setUseEs").

#if defined(ENABLE_OVERLOADING)
    ResolveX11GLContextMethod               ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.GLContext as Gdk.GLContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.GLContext as Gdk.GLContext

#endif

-- | Memory-managed wrapper type.
newtype X11GLContext = X11GLContext (SP.ManagedPtr X11GLContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11GLContext where
    toManagedPtr (X11GLContext p) = p

foreign import ccall "gdk_x11_gl_context_get_type"
    c_gdk_x11_gl_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11GLContext where
    glibType = c_gdk_x11_gl_context_get_type

instance B.Types.GObject X11GLContext

-- | Type class for types which can be safely cast to `X11GLContext`, for instance with `toX11GLContext`.
class (SP.GObject o, O.IsDescendantOf X11GLContext o) => IsX11GLContext o
instance (SP.GObject o, O.IsDescendantOf X11GLContext o) => IsX11GLContext o

instance O.HasParentTypes X11GLContext
type instance O.ParentTypes X11GLContext = '[Gdk.GLContext.GLContext, GObject.Object.Object]

-- | Cast to `X11GLContext`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toX11GLContext :: (MIO.MonadIO m, IsX11GLContext o) => o -> m X11GLContext
toX11GLContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11GLContext

-- | Convert 'X11GLContext' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11GLContext) where
    gvalueGType_ = c_gdk_x11_gl_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11GLContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11GLContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11GLContext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11GLContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11GLContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11GLContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11GLContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11GLContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11GLContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11GLContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11GLContextMethod "isLegacy" o = Gdk.GLContext.GLContextIsLegacyMethodInfo
    ResolveX11GLContextMethod "makeCurrent" o = Gdk.GLContext.GLContextMakeCurrentMethodInfo
    ResolveX11GLContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11GLContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11GLContextMethod "realize" o = Gdk.GLContext.GLContextRealizeMethodInfo
    ResolveX11GLContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11GLContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11GLContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11GLContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11GLContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11GLContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11GLContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11GLContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11GLContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11GLContextMethod "getDebugEnabled" o = Gdk.GLContext.GLContextGetDebugEnabledMethodInfo
    ResolveX11GLContextMethod "getDisplay" o = Gdk.GLContext.GLContextGetDisplayMethodInfo
    ResolveX11GLContextMethod "getForwardCompatible" o = Gdk.GLContext.GLContextGetForwardCompatibleMethodInfo
    ResolveX11GLContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11GLContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11GLContextMethod "getRequiredVersion" o = Gdk.GLContext.GLContextGetRequiredVersionMethodInfo
    ResolveX11GLContextMethod "getSharedContext" o = Gdk.GLContext.GLContextGetSharedContextMethodInfo
    ResolveX11GLContextMethod "getUseEs" o = Gdk.GLContext.GLContextGetUseEsMethodInfo
    ResolveX11GLContextMethod "getVersion" o = Gdk.GLContext.GLContextGetVersionMethodInfo
    ResolveX11GLContextMethod "getWindow" o = Gdk.GLContext.GLContextGetWindowMethodInfo
    ResolveX11GLContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11GLContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11GLContextMethod "setDebugEnabled" o = Gdk.GLContext.GLContextSetDebugEnabledMethodInfo
    ResolveX11GLContextMethod "setForwardCompatible" o = Gdk.GLContext.GLContextSetForwardCompatibleMethodInfo
    ResolveX11GLContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11GLContextMethod "setRequiredVersion" o = Gdk.GLContext.GLContextSetRequiredVersionMethodInfo
    ResolveX11GLContextMethod "setUseEs" o = Gdk.GLContext.GLContextSetUseEsMethodInfo
    ResolveX11GLContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11GLContextMethod t X11GLContext, O.OverloadedMethod info X11GLContext p) => OL.IsLabel t (X11GLContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11GLContextMethod t X11GLContext, O.OverloadedMethod info X11GLContext p, R.HasField t X11GLContext p) => R.HasField t X11GLContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11GLContextMethod t X11GLContext, O.OverloadedMethodInfo info X11GLContext) => OL.IsLabel t (O.MethodProxy info X11GLContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11GLContext
type instance O.AttributeList X11GLContext = X11GLContextAttributeList
type X11GLContextAttributeList = ('[ '("display", Gdk.GLContext.GLContextDisplayPropertyInfo), '("sharedContext", Gdk.GLContext.GLContextSharedContextPropertyInfo), '("window", Gdk.GLContext.GLContextWindowPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11GLContext = X11GLContextSignalList
type X11GLContextSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


