{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11DeviceXI2
    ( 

-- * Exported types
    X11DeviceXI2(..)                        ,
    IsX11DeviceXI2                          ,
    toX11DeviceXI2                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grab]("GI.Gdk.Objects.Device#g:method:grab"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listAxes]("GI.Gdk.Objects.Device#g:method:listAxes"), [listSlaveDevices]("GI.Gdk.Objects.Device#g:method:listSlaveDevices"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [ungrab]("GI.Gdk.Objects.Device#g:method:ungrab"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [warp]("GI.Gdk.Objects.Device#g:method:warp"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAssociatedDevice]("GI.Gdk.Objects.Device#g:method:getAssociatedDevice"), [getAxes]("GI.Gdk.Objects.Device#g:method:getAxes"), [getAxisUse]("GI.Gdk.Objects.Device#g:method:getAxisUse"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDeviceType]("GI.Gdk.Objects.Device#g:method:getDeviceType"), [getDisplay]("GI.Gdk.Objects.Device#g:method:getDisplay"), [getHasCursor]("GI.Gdk.Objects.Device#g:method:getHasCursor"), [getKey]("GI.Gdk.Objects.Device#g:method:getKey"), [getLastEventWindow]("GI.Gdk.Objects.Device#g:method:getLastEventWindow"), [getMode]("GI.Gdk.Objects.Device#g:method:getMode"), [getNAxes]("GI.Gdk.Objects.Device#g:method:getNAxes"), [getNKeys]("GI.Gdk.Objects.Device#g:method:getNKeys"), [getName]("GI.Gdk.Objects.Device#g:method:getName"), [getPosition]("GI.Gdk.Objects.Device#g:method:getPosition"), [getPositionDouble]("GI.Gdk.Objects.Device#g:method:getPositionDouble"), [getProductId]("GI.Gdk.Objects.Device#g:method:getProductId"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSeat]("GI.Gdk.Objects.Device#g:method:getSeat"), [getSource]("GI.Gdk.Objects.Device#g:method:getSource"), [getVendorId]("GI.Gdk.Objects.Device#g:method:getVendorId"), [getWindowAtPosition]("GI.Gdk.Objects.Device#g:method:getWindowAtPosition"), [getWindowAtPositionDouble]("GI.Gdk.Objects.Device#g:method:getWindowAtPositionDouble").
-- 
-- ==== Setters
-- [setAxisUse]("GI.Gdk.Objects.Device#g:method:setAxisUse"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setKey]("GI.Gdk.Objects.Device#g:method:setKey"), [setMode]("GI.Gdk.Objects.Device#g:method:setMode"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveX11DeviceXI2Method               ,
#endif



 -- * Properties


-- ** deviceId #attr:deviceId#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    X11DeviceXI2DeviceIdPropertyInfo        ,
#endif
    constructX11DeviceXI2DeviceId           ,
    getX11DeviceXI2DeviceId                 ,
#if defined(ENABLE_OVERLOADING)
    x11DeviceXI2DeviceId                    ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Device as Gdk.Device

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Device as Gdk.Device

#endif

-- | Memory-managed wrapper type.
newtype X11DeviceXI2 = X11DeviceXI2 (SP.ManagedPtr X11DeviceXI2)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11DeviceXI2 where
    toManagedPtr (X11DeviceXI2 p) = p

foreign import ccall "gdk_x11_device_xi2_get_type"
    c_gdk_x11_device_xi2_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11DeviceXI2 where
    glibType = c_gdk_x11_device_xi2_get_type

instance B.Types.GObject X11DeviceXI2

-- | Type class for types which can be safely cast to `X11DeviceXI2`, for instance with `toX11DeviceXI2`.
class (SP.GObject o, O.IsDescendantOf X11DeviceXI2 o) => IsX11DeviceXI2 o
instance (SP.GObject o, O.IsDescendantOf X11DeviceXI2 o) => IsX11DeviceXI2 o

instance O.HasParentTypes X11DeviceXI2
type instance O.ParentTypes X11DeviceXI2 = '[Gdk.Device.Device, GObject.Object.Object]

-- | Cast to `X11DeviceXI2`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toX11DeviceXI2 :: (MIO.MonadIO m, IsX11DeviceXI2 o) => o -> m X11DeviceXI2
toX11DeviceXI2 = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11DeviceXI2

-- | Convert 'X11DeviceXI2' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11DeviceXI2) where
    gvalueGType_ = c_gdk_x11_device_xi2_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11DeviceXI2)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11DeviceXI2)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11DeviceXI2 ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11DeviceXI2Method (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11DeviceXI2Method "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11DeviceXI2Method "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11DeviceXI2Method "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11DeviceXI2Method "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11DeviceXI2Method "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11DeviceXI2Method "grab" o = Gdk.Device.DeviceGrabMethodInfo
    ResolveX11DeviceXI2Method "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11DeviceXI2Method "listAxes" o = Gdk.Device.DeviceListAxesMethodInfo
    ResolveX11DeviceXI2Method "listSlaveDevices" o = Gdk.Device.DeviceListSlaveDevicesMethodInfo
    ResolveX11DeviceXI2Method "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11DeviceXI2Method "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11DeviceXI2Method "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11DeviceXI2Method "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11DeviceXI2Method "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11DeviceXI2Method "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11DeviceXI2Method "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11DeviceXI2Method "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11DeviceXI2Method "ungrab" o = Gdk.Device.DeviceUngrabMethodInfo
    ResolveX11DeviceXI2Method "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11DeviceXI2Method "warp" o = Gdk.Device.DeviceWarpMethodInfo
    ResolveX11DeviceXI2Method "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11DeviceXI2Method "getAssociatedDevice" o = Gdk.Device.DeviceGetAssociatedDeviceMethodInfo
    ResolveX11DeviceXI2Method "getAxes" o = Gdk.Device.DeviceGetAxesMethodInfo
    ResolveX11DeviceXI2Method "getAxisUse" o = Gdk.Device.DeviceGetAxisUseMethodInfo
    ResolveX11DeviceXI2Method "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11DeviceXI2Method "getDeviceType" o = Gdk.Device.DeviceGetDeviceTypeMethodInfo
    ResolveX11DeviceXI2Method "getDisplay" o = Gdk.Device.DeviceGetDisplayMethodInfo
    ResolveX11DeviceXI2Method "getHasCursor" o = Gdk.Device.DeviceGetHasCursorMethodInfo
    ResolveX11DeviceXI2Method "getKey" o = Gdk.Device.DeviceGetKeyMethodInfo
    ResolveX11DeviceXI2Method "getLastEventWindow" o = Gdk.Device.DeviceGetLastEventWindowMethodInfo
    ResolveX11DeviceXI2Method "getMode" o = Gdk.Device.DeviceGetModeMethodInfo
    ResolveX11DeviceXI2Method "getNAxes" o = Gdk.Device.DeviceGetNAxesMethodInfo
    ResolveX11DeviceXI2Method "getNKeys" o = Gdk.Device.DeviceGetNKeysMethodInfo
    ResolveX11DeviceXI2Method "getName" o = Gdk.Device.DeviceGetNameMethodInfo
    ResolveX11DeviceXI2Method "getPosition" o = Gdk.Device.DeviceGetPositionMethodInfo
    ResolveX11DeviceXI2Method "getPositionDouble" o = Gdk.Device.DeviceGetPositionDoubleMethodInfo
    ResolveX11DeviceXI2Method "getProductId" o = Gdk.Device.DeviceGetProductIdMethodInfo
    ResolveX11DeviceXI2Method "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11DeviceXI2Method "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11DeviceXI2Method "getSeat" o = Gdk.Device.DeviceGetSeatMethodInfo
    ResolveX11DeviceXI2Method "getSource" o = Gdk.Device.DeviceGetSourceMethodInfo
    ResolveX11DeviceXI2Method "getVendorId" o = Gdk.Device.DeviceGetVendorIdMethodInfo
    ResolveX11DeviceXI2Method "getWindowAtPosition" o = Gdk.Device.DeviceGetWindowAtPositionMethodInfo
    ResolveX11DeviceXI2Method "getWindowAtPositionDouble" o = Gdk.Device.DeviceGetWindowAtPositionDoubleMethodInfo
    ResolveX11DeviceXI2Method "setAxisUse" o = Gdk.Device.DeviceSetAxisUseMethodInfo
    ResolveX11DeviceXI2Method "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11DeviceXI2Method "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11DeviceXI2Method "setKey" o = Gdk.Device.DeviceSetKeyMethodInfo
    ResolveX11DeviceXI2Method "setMode" o = Gdk.Device.DeviceSetModeMethodInfo
    ResolveX11DeviceXI2Method "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11DeviceXI2Method l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11DeviceXI2Method t X11DeviceXI2, O.OverloadedMethod info X11DeviceXI2 p) => OL.IsLabel t (X11DeviceXI2 -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11DeviceXI2Method t X11DeviceXI2, O.OverloadedMethod info X11DeviceXI2 p, R.HasField t X11DeviceXI2 p) => R.HasField t X11DeviceXI2 p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11DeviceXI2Method t X11DeviceXI2, O.OverloadedMethodInfo info X11DeviceXI2) => OL.IsLabel t (O.MethodProxy info X11DeviceXI2) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "device-id"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@device-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' x11DeviceXI2 #deviceId
-- @
getX11DeviceXI2DeviceId :: (MonadIO m, IsX11DeviceXI2 o) => o -> m Int32
getX11DeviceXI2DeviceId obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "device-id"

-- | Construct a `GValueConstruct` with valid value for the “@device-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructX11DeviceXI2DeviceId :: (IsX11DeviceXI2 o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructX11DeviceXI2DeviceId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "device-id" val

#if defined(ENABLE_OVERLOADING)
data X11DeviceXI2DeviceIdPropertyInfo
instance AttrInfo X11DeviceXI2DeviceIdPropertyInfo where
    type AttrAllowedOps X11DeviceXI2DeviceIdPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint X11DeviceXI2DeviceIdPropertyInfo = IsX11DeviceXI2
    type AttrSetTypeConstraint X11DeviceXI2DeviceIdPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint X11DeviceXI2DeviceIdPropertyInfo = (~) Int32
    type AttrTransferType X11DeviceXI2DeviceIdPropertyInfo = Int32
    type AttrGetType X11DeviceXI2DeviceIdPropertyInfo = Int32
    type AttrLabel X11DeviceXI2DeviceIdPropertyInfo = "device-id"
    type AttrOrigin X11DeviceXI2DeviceIdPropertyInfo = X11DeviceXI2
    attrGet = getX11DeviceXI2DeviceId
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructX11DeviceXI2DeviceId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11DeviceXI2.deviceId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11DeviceXI2.html#g:attr:deviceId"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11DeviceXI2
type instance O.AttributeList X11DeviceXI2 = X11DeviceXI2AttributeList
type X11DeviceXI2AttributeList = ('[ '("associatedDevice", Gdk.Device.DeviceAssociatedDevicePropertyInfo), '("axes", Gdk.Device.DeviceAxesPropertyInfo), '("deviceId", X11DeviceXI2DeviceIdPropertyInfo), '("deviceManager", Gdk.Device.DeviceDeviceManagerPropertyInfo), '("display", Gdk.Device.DeviceDisplayPropertyInfo), '("hasCursor", Gdk.Device.DeviceHasCursorPropertyInfo), '("inputMode", Gdk.Device.DeviceInputModePropertyInfo), '("inputSource", Gdk.Device.DeviceInputSourcePropertyInfo), '("nAxes", Gdk.Device.DeviceNAxesPropertyInfo), '("name", Gdk.Device.DeviceNamePropertyInfo), '("numTouches", Gdk.Device.DeviceNumTouchesPropertyInfo), '("productId", Gdk.Device.DeviceProductIdPropertyInfo), '("seat", Gdk.Device.DeviceSeatPropertyInfo), '("tool", Gdk.Device.DeviceToolPropertyInfo), '("type", Gdk.Device.DeviceTypePropertyInfo), '("vendorId", Gdk.Device.DeviceVendorIdPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
x11DeviceXI2DeviceId :: AttrLabelProxy "deviceId"
x11DeviceXI2DeviceId = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11DeviceXI2 = X11DeviceXI2SignalList
type X11DeviceXI2SignalList = ('[ '("changed", Gdk.Device.DeviceChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("toolChanged", Gdk.Device.DeviceToolChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif


