{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11DeviceManagerCore
    ( 

-- * Exported types
    X11DeviceManagerCore(..)                ,
    IsX11DeviceManagerCore                  ,
    toX11DeviceManagerCore                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listDevices]("GI.Gdk.Objects.DeviceManager#g:method:listDevices"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getClientPointer]("GI.Gdk.Objects.DeviceManager#g:method:getClientPointer"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.DeviceManager#g:method:getDisplay"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveX11DeviceManagerCoreMethod       ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager

#endif

-- | Memory-managed wrapper type.
newtype X11DeviceManagerCore = X11DeviceManagerCore (SP.ManagedPtr X11DeviceManagerCore)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11DeviceManagerCore where
    toManagedPtr (X11DeviceManagerCore p) = p

foreign import ccall "gdk_x11_device_manager_core_get_type"
    c_gdk_x11_device_manager_core_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11DeviceManagerCore where
    glibType = c_gdk_x11_device_manager_core_get_type

instance B.Types.GObject X11DeviceManagerCore

-- | Type class for types which can be safely cast to `X11DeviceManagerCore`, for instance with `toX11DeviceManagerCore`.
class (SP.GObject o, O.IsDescendantOf X11DeviceManagerCore o) => IsX11DeviceManagerCore o
instance (SP.GObject o, O.IsDescendantOf X11DeviceManagerCore o) => IsX11DeviceManagerCore o

instance O.HasParentTypes X11DeviceManagerCore
type instance O.ParentTypes X11DeviceManagerCore = '[Gdk.DeviceManager.DeviceManager, GObject.Object.Object]

-- | Cast to `X11DeviceManagerCore`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toX11DeviceManagerCore :: (MIO.MonadIO m, IsX11DeviceManagerCore o) => o -> m X11DeviceManagerCore
toX11DeviceManagerCore = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11DeviceManagerCore

-- | Convert 'X11DeviceManagerCore' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11DeviceManagerCore) where
    gvalueGType_ = c_gdk_x11_device_manager_core_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11DeviceManagerCore)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11DeviceManagerCore)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11DeviceManagerCore ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11DeviceManagerCoreMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11DeviceManagerCoreMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11DeviceManagerCoreMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11DeviceManagerCoreMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11DeviceManagerCoreMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11DeviceManagerCoreMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11DeviceManagerCoreMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11DeviceManagerCoreMethod "listDevices" o = Gdk.DeviceManager.DeviceManagerListDevicesMethodInfo
    ResolveX11DeviceManagerCoreMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11DeviceManagerCoreMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11DeviceManagerCoreMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11DeviceManagerCoreMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11DeviceManagerCoreMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11DeviceManagerCoreMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11DeviceManagerCoreMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11DeviceManagerCoreMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11DeviceManagerCoreMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11DeviceManagerCoreMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11DeviceManagerCoreMethod "getClientPointer" o = Gdk.DeviceManager.DeviceManagerGetClientPointerMethodInfo
    ResolveX11DeviceManagerCoreMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11DeviceManagerCoreMethod "getDisplay" o = Gdk.DeviceManager.DeviceManagerGetDisplayMethodInfo
    ResolveX11DeviceManagerCoreMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11DeviceManagerCoreMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11DeviceManagerCoreMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11DeviceManagerCoreMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11DeviceManagerCoreMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11DeviceManagerCoreMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11DeviceManagerCoreMethod t X11DeviceManagerCore, O.OverloadedMethod info X11DeviceManagerCore p) => OL.IsLabel t (X11DeviceManagerCore -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11DeviceManagerCoreMethod t X11DeviceManagerCore, O.OverloadedMethod info X11DeviceManagerCore p, R.HasField t X11DeviceManagerCore p) => R.HasField t X11DeviceManagerCore p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11DeviceManagerCoreMethod t X11DeviceManagerCore, O.OverloadedMethodInfo info X11DeviceManagerCore) => OL.IsLabel t (O.MethodProxy info X11DeviceManagerCore) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11DeviceManagerCore
type instance O.AttributeList X11DeviceManagerCore = X11DeviceManagerCoreAttributeList
type X11DeviceManagerCoreAttributeList = ('[ '("display", Gdk.DeviceManager.DeviceManagerDisplayPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11DeviceManagerCore = X11DeviceManagerCoreSignalList
type X11DeviceManagerCoreSignalList = ('[ '("deviceAdded", Gdk.DeviceManager.DeviceManagerDeviceAddedSignalInfo), '("deviceChanged", Gdk.DeviceManager.DeviceManagerDeviceChangedSignalInfo), '("deviceRemoved", Gdk.DeviceManager.DeviceManagerDeviceRemovedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


