{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11DeviceCore
    ( 

-- * Exported types
    X11DeviceCore(..)                       ,
    IsX11DeviceCore                         ,
    toX11DeviceCore                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grab]("GI.Gdk.Objects.Device#g:method:grab"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listAxes]("GI.Gdk.Objects.Device#g:method:listAxes"), [listSlaveDevices]("GI.Gdk.Objects.Device#g:method:listSlaveDevices"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [ungrab]("GI.Gdk.Objects.Device#g:method:ungrab"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [warp]("GI.Gdk.Objects.Device#g:method:warp"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAssociatedDevice]("GI.Gdk.Objects.Device#g:method:getAssociatedDevice"), [getAxes]("GI.Gdk.Objects.Device#g:method:getAxes"), [getAxisUse]("GI.Gdk.Objects.Device#g:method:getAxisUse"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDeviceType]("GI.Gdk.Objects.Device#g:method:getDeviceType"), [getDisplay]("GI.Gdk.Objects.Device#g:method:getDisplay"), [getHasCursor]("GI.Gdk.Objects.Device#g:method:getHasCursor"), [getKey]("GI.Gdk.Objects.Device#g:method:getKey"), [getLastEventWindow]("GI.Gdk.Objects.Device#g:method:getLastEventWindow"), [getMode]("GI.Gdk.Objects.Device#g:method:getMode"), [getNAxes]("GI.Gdk.Objects.Device#g:method:getNAxes"), [getNKeys]("GI.Gdk.Objects.Device#g:method:getNKeys"), [getName]("GI.Gdk.Objects.Device#g:method:getName"), [getPosition]("GI.Gdk.Objects.Device#g:method:getPosition"), [getPositionDouble]("GI.Gdk.Objects.Device#g:method:getPositionDouble"), [getProductId]("GI.Gdk.Objects.Device#g:method:getProductId"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSeat]("GI.Gdk.Objects.Device#g:method:getSeat"), [getSource]("GI.Gdk.Objects.Device#g:method:getSource"), [getVendorId]("GI.Gdk.Objects.Device#g:method:getVendorId"), [getWindowAtPosition]("GI.Gdk.Objects.Device#g:method:getWindowAtPosition"), [getWindowAtPositionDouble]("GI.Gdk.Objects.Device#g:method:getWindowAtPositionDouble").
-- 
-- ==== Setters
-- [setAxisUse]("GI.Gdk.Objects.Device#g:method:setAxisUse"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setKey]("GI.Gdk.Objects.Device#g:method:setKey"), [setMode]("GI.Gdk.Objects.Device#g:method:setMode"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveX11DeviceCoreMethod              ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Device as Gdk.Device

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Device as Gdk.Device

#endif

-- | Memory-managed wrapper type.
newtype X11DeviceCore = X11DeviceCore (SP.ManagedPtr X11DeviceCore)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11DeviceCore where
    toManagedPtr (X11DeviceCore p) = p

foreign import ccall "gdk_x11_device_core_get_type"
    c_gdk_x11_device_core_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11DeviceCore where
    glibType = c_gdk_x11_device_core_get_type

instance B.Types.GObject X11DeviceCore

-- | Type class for types which can be safely cast to `X11DeviceCore`, for instance with `toX11DeviceCore`.
class (SP.GObject o, O.IsDescendantOf X11DeviceCore o) => IsX11DeviceCore o
instance (SP.GObject o, O.IsDescendantOf X11DeviceCore o) => IsX11DeviceCore o

instance O.HasParentTypes X11DeviceCore
type instance O.ParentTypes X11DeviceCore = '[Gdk.Device.Device, GObject.Object.Object]

-- | Cast to `X11DeviceCore`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toX11DeviceCore :: (MIO.MonadIO m, IsX11DeviceCore o) => o -> m X11DeviceCore
toX11DeviceCore = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11DeviceCore

-- | Convert 'X11DeviceCore' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11DeviceCore) where
    gvalueGType_ = c_gdk_x11_device_core_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11DeviceCore)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11DeviceCore)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11DeviceCore ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11DeviceCoreMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11DeviceCoreMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11DeviceCoreMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11DeviceCoreMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11DeviceCoreMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11DeviceCoreMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11DeviceCoreMethod "grab" o = Gdk.Device.DeviceGrabMethodInfo
    ResolveX11DeviceCoreMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11DeviceCoreMethod "listAxes" o = Gdk.Device.DeviceListAxesMethodInfo
    ResolveX11DeviceCoreMethod "listSlaveDevices" o = Gdk.Device.DeviceListSlaveDevicesMethodInfo
    ResolveX11DeviceCoreMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11DeviceCoreMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11DeviceCoreMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11DeviceCoreMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11DeviceCoreMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11DeviceCoreMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11DeviceCoreMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11DeviceCoreMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11DeviceCoreMethod "ungrab" o = Gdk.Device.DeviceUngrabMethodInfo
    ResolveX11DeviceCoreMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11DeviceCoreMethod "warp" o = Gdk.Device.DeviceWarpMethodInfo
    ResolveX11DeviceCoreMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11DeviceCoreMethod "getAssociatedDevice" o = Gdk.Device.DeviceGetAssociatedDeviceMethodInfo
    ResolveX11DeviceCoreMethod "getAxes" o = Gdk.Device.DeviceGetAxesMethodInfo
    ResolveX11DeviceCoreMethod "getAxisUse" o = Gdk.Device.DeviceGetAxisUseMethodInfo
    ResolveX11DeviceCoreMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11DeviceCoreMethod "getDeviceType" o = Gdk.Device.DeviceGetDeviceTypeMethodInfo
    ResolveX11DeviceCoreMethod "getDisplay" o = Gdk.Device.DeviceGetDisplayMethodInfo
    ResolveX11DeviceCoreMethod "getHasCursor" o = Gdk.Device.DeviceGetHasCursorMethodInfo
    ResolveX11DeviceCoreMethod "getKey" o = Gdk.Device.DeviceGetKeyMethodInfo
    ResolveX11DeviceCoreMethod "getLastEventWindow" o = Gdk.Device.DeviceGetLastEventWindowMethodInfo
    ResolveX11DeviceCoreMethod "getMode" o = Gdk.Device.DeviceGetModeMethodInfo
    ResolveX11DeviceCoreMethod "getNAxes" o = Gdk.Device.DeviceGetNAxesMethodInfo
    ResolveX11DeviceCoreMethod "getNKeys" o = Gdk.Device.DeviceGetNKeysMethodInfo
    ResolveX11DeviceCoreMethod "getName" o = Gdk.Device.DeviceGetNameMethodInfo
    ResolveX11DeviceCoreMethod "getPosition" o = Gdk.Device.DeviceGetPositionMethodInfo
    ResolveX11DeviceCoreMethod "getPositionDouble" o = Gdk.Device.DeviceGetPositionDoubleMethodInfo
    ResolveX11DeviceCoreMethod "getProductId" o = Gdk.Device.DeviceGetProductIdMethodInfo
    ResolveX11DeviceCoreMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11DeviceCoreMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11DeviceCoreMethod "getSeat" o = Gdk.Device.DeviceGetSeatMethodInfo
    ResolveX11DeviceCoreMethod "getSource" o = Gdk.Device.DeviceGetSourceMethodInfo
    ResolveX11DeviceCoreMethod "getVendorId" o = Gdk.Device.DeviceGetVendorIdMethodInfo
    ResolveX11DeviceCoreMethod "getWindowAtPosition" o = Gdk.Device.DeviceGetWindowAtPositionMethodInfo
    ResolveX11DeviceCoreMethod "getWindowAtPositionDouble" o = Gdk.Device.DeviceGetWindowAtPositionDoubleMethodInfo
    ResolveX11DeviceCoreMethod "setAxisUse" o = Gdk.Device.DeviceSetAxisUseMethodInfo
    ResolveX11DeviceCoreMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11DeviceCoreMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11DeviceCoreMethod "setKey" o = Gdk.Device.DeviceSetKeyMethodInfo
    ResolveX11DeviceCoreMethod "setMode" o = Gdk.Device.DeviceSetModeMethodInfo
    ResolveX11DeviceCoreMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11DeviceCoreMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11DeviceCoreMethod t X11DeviceCore, O.OverloadedMethod info X11DeviceCore p) => OL.IsLabel t (X11DeviceCore -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11DeviceCoreMethod t X11DeviceCore, O.OverloadedMethod info X11DeviceCore p, R.HasField t X11DeviceCore p) => R.HasField t X11DeviceCore p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11DeviceCoreMethod t X11DeviceCore, O.OverloadedMethodInfo info X11DeviceCore) => OL.IsLabel t (O.MethodProxy info X11DeviceCore) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11DeviceCore
type instance O.AttributeList X11DeviceCore = X11DeviceCoreAttributeList
type X11DeviceCoreAttributeList = ('[ '("associatedDevice", Gdk.Device.DeviceAssociatedDevicePropertyInfo), '("axes", Gdk.Device.DeviceAxesPropertyInfo), '("deviceManager", Gdk.Device.DeviceDeviceManagerPropertyInfo), '("display", Gdk.Device.DeviceDisplayPropertyInfo), '("hasCursor", Gdk.Device.DeviceHasCursorPropertyInfo), '("inputMode", Gdk.Device.DeviceInputModePropertyInfo), '("inputSource", Gdk.Device.DeviceInputSourcePropertyInfo), '("nAxes", Gdk.Device.DeviceNAxesPropertyInfo), '("name", Gdk.Device.DeviceNamePropertyInfo), '("numTouches", Gdk.Device.DeviceNumTouchesPropertyInfo), '("productId", Gdk.Device.DeviceProductIdPropertyInfo), '("seat", Gdk.Device.DeviceSeatPropertyInfo), '("tool", Gdk.Device.DeviceToolPropertyInfo), '("type", Gdk.Device.DeviceTypePropertyInfo), '("vendorId", Gdk.Device.DeviceVendorIdPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11DeviceCore = X11DeviceCoreSignalList
type X11DeviceCoreSignalList = ('[ '("changed", Gdk.Device.DeviceChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("toolChanged", Gdk.Device.DeviceToolChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif


