{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11Window
    ( 

-- * Exported types
    X11Window(..)                           ,
    IsX11Window                             ,
    toX11Window                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beep]("GI.Gdk.Objects.Window#g:method:beep"), [beginDrawFrame]("GI.Gdk.Objects.Window#g:method:beginDrawFrame"), [beginMoveDrag]("GI.Gdk.Objects.Window#g:method:beginMoveDrag"), [beginMoveDragForDevice]("GI.Gdk.Objects.Window#g:method:beginMoveDragForDevice"), [beginPaintRect]("GI.Gdk.Objects.Window#g:method:beginPaintRect"), [beginPaintRegion]("GI.Gdk.Objects.Window#g:method:beginPaintRegion"), [beginResizeDrag]("GI.Gdk.Objects.Window#g:method:beginResizeDrag"), [beginResizeDragForDevice]("GI.Gdk.Objects.Window#g:method:beginResizeDragForDevice"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [configureFinished]("GI.Gdk.Objects.Window#g:method:configureFinished"), [coordsFromParent]("GI.Gdk.Objects.Window#g:method:coordsFromParent"), [coordsToParent]("GI.Gdk.Objects.Window#g:method:coordsToParent"), [createGlContext]("GI.Gdk.Objects.Window#g:method:createGlContext"), [createSimilarImageSurface]("GI.Gdk.Objects.Window#g:method:createSimilarImageSurface"), [createSimilarSurface]("GI.Gdk.Objects.Window#g:method:createSimilarSurface"), [deiconify]("GI.Gdk.Objects.Window#g:method:deiconify"), [destroy]("GI.Gdk.Objects.Window#g:method:destroy"), [destroyNotify]("GI.Gdk.Objects.Window#g:method:destroyNotify"), [enableSynchronizedConfigure]("GI.Gdk.Objects.Window#g:method:enableSynchronizedConfigure"), [endDrawFrame]("GI.Gdk.Objects.Window#g:method:endDrawFrame"), [endPaint]("GI.Gdk.Objects.Window#g:method:endPaint"), [ensureNative]("GI.Gdk.Objects.Window#g:method:ensureNative"), [flush]("GI.Gdk.Objects.Window#g:method:flush"), [focus]("GI.Gdk.Objects.Window#g:method:focus"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [freezeToplevelUpdatesLibgtkOnly]("GI.Gdk.Objects.Window#g:method:freezeToplevelUpdatesLibgtkOnly"), [freezeUpdates]("GI.Gdk.Objects.Window#g:method:freezeUpdates"), [fullscreen]("GI.Gdk.Objects.Window#g:method:fullscreen"), [fullscreenOnMonitor]("GI.Gdk.Objects.Window#g:method:fullscreenOnMonitor"), [geometryChanged]("GI.Gdk.Objects.Window#g:method:geometryChanged"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasNative]("GI.Gdk.Objects.Window#g:method:hasNative"), [hide]("GI.Gdk.Objects.Window#g:method:hide"), [iconify]("GI.Gdk.Objects.Window#g:method:iconify"), [inputShapeCombineRegion]("GI.Gdk.Objects.Window#g:method:inputShapeCombineRegion"), [invalidateMaybeRecurse]("GI.Gdk.Objects.Window#g:method:invalidateMaybeRecurse"), [invalidateRect]("GI.Gdk.Objects.Window#g:method:invalidateRect"), [invalidateRegion]("GI.Gdk.Objects.Window#g:method:invalidateRegion"), [isDestroyed]("GI.Gdk.Objects.Window#g:method:isDestroyed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isInputOnly]("GI.Gdk.Objects.Window#g:method:isInputOnly"), [isShaped]("GI.Gdk.Objects.Window#g:method:isShaped"), [isViewable]("GI.Gdk.Objects.Window#g:method:isViewable"), [isVisible]("GI.Gdk.Objects.Window#g:method:isVisible"), [lower]("GI.Gdk.Objects.Window#g:method:lower"), [markPaintFromClip]("GI.Gdk.Objects.Window#g:method:markPaintFromClip"), [maximize]("GI.Gdk.Objects.Window#g:method:maximize"), [mergeChildInputShapes]("GI.Gdk.Objects.Window#g:method:mergeChildInputShapes"), [mergeChildShapes]("GI.Gdk.Objects.Window#g:method:mergeChildShapes"), [move]("GI.Gdk.Objects.Window#g:method:move"), [moveRegion]("GI.Gdk.Objects.Window#g:method:moveRegion"), [moveResize]("GI.Gdk.Objects.Window#g:method:moveResize"), [moveToCurrentDesktop]("GI.GdkX11.Objects.X11Window#g:method:moveToCurrentDesktop"), [moveToDesktop]("GI.GdkX11.Objects.X11Window#g:method:moveToDesktop"), [moveToRect]("GI.Gdk.Objects.Window#g:method:moveToRect"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [peekChildren]("GI.Gdk.Objects.Window#g:method:peekChildren"), [processUpdates]("GI.Gdk.Objects.Window#g:method:processUpdates"), [raise]("GI.Gdk.Objects.Window#g:method:raise"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [registerDnd]("GI.Gdk.Objects.Window#g:method:registerDnd"), [reparent]("GI.Gdk.Objects.Window#g:method:reparent"), [resize]("GI.Gdk.Objects.Window#g:method:resize"), [restack]("GI.Gdk.Objects.Window#g:method:restack"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [scroll]("GI.Gdk.Objects.Window#g:method:scroll"), [shapeCombineRegion]("GI.Gdk.Objects.Window#g:method:shapeCombineRegion"), [show]("GI.Gdk.Objects.Window#g:method:show"), [showUnraised]("GI.Gdk.Objects.Window#g:method:showUnraised"), [showWindowMenu]("GI.Gdk.Objects.Window#g:method:showWindowMenu"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [stick]("GI.Gdk.Objects.Window#g:method:stick"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [thawToplevelUpdatesLibgtkOnly]("GI.Gdk.Objects.Window#g:method:thawToplevelUpdatesLibgtkOnly"), [thawUpdates]("GI.Gdk.Objects.Window#g:method:thawUpdates"), [unfullscreen]("GI.Gdk.Objects.Window#g:method:unfullscreen"), [unmaximize]("GI.Gdk.Objects.Window#g:method:unmaximize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unstick]("GI.Gdk.Objects.Window#g:method:unstick"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [withdraw]("GI.Gdk.Objects.Window#g:method:withdraw").
-- 
-- ==== Getters
-- [getAcceptFocus]("GI.Gdk.Objects.Window#g:method:getAcceptFocus"), [getBackgroundPattern]("GI.Gdk.Objects.Window#g:method:getBackgroundPattern"), [getChildren]("GI.Gdk.Objects.Window#g:method:getChildren"), [getChildrenWithUserData]("GI.Gdk.Objects.Window#g:method:getChildrenWithUserData"), [getClipRegion]("GI.Gdk.Objects.Window#g:method:getClipRegion"), [getComposited]("GI.Gdk.Objects.Window#g:method:getComposited"), [getCursor]("GI.Gdk.Objects.Window#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorations]("GI.Gdk.Objects.Window#g:method:getDecorations"), [getDesktop]("GI.GdkX11.Objects.X11Window#g:method:getDesktop"), [getDeviceCursor]("GI.Gdk.Objects.Window#g:method:getDeviceCursor"), [getDeviceEvents]("GI.Gdk.Objects.Window#g:method:getDeviceEvents"), [getDevicePosition]("GI.Gdk.Objects.Window#g:method:getDevicePosition"), [getDevicePositionDouble]("GI.Gdk.Objects.Window#g:method:getDevicePositionDouble"), [getDisplay]("GI.Gdk.Objects.Window#g:method:getDisplay"), [getDragProtocol]("GI.Gdk.Objects.Window#g:method:getDragProtocol"), [getEffectiveParent]("GI.Gdk.Objects.Window#g:method:getEffectiveParent"), [getEffectiveToplevel]("GI.Gdk.Objects.Window#g:method:getEffectiveToplevel"), [getEventCompression]("GI.Gdk.Objects.Window#g:method:getEventCompression"), [getEvents]("GI.Gdk.Objects.Window#g:method:getEvents"), [getFocusOnMap]("GI.Gdk.Objects.Window#g:method:getFocusOnMap"), [getFrameClock]("GI.Gdk.Objects.Window#g:method:getFrameClock"), [getFrameExtents]("GI.Gdk.Objects.Window#g:method:getFrameExtents"), [getFullscreenMode]("GI.Gdk.Objects.Window#g:method:getFullscreenMode"), [getGeometry]("GI.Gdk.Objects.Window#g:method:getGeometry"), [getGroup]("GI.Gdk.Objects.Window#g:method:getGroup"), [getHeight]("GI.Gdk.Objects.Window#g:method:getHeight"), [getModalHint]("GI.Gdk.Objects.Window#g:method:getModalHint"), [getOrigin]("GI.Gdk.Objects.Window#g:method:getOrigin"), [getParent]("GI.Gdk.Objects.Window#g:method:getParent"), [getPassThrough]("GI.Gdk.Objects.Window#g:method:getPassThrough"), [getPointer]("GI.Gdk.Objects.Window#g:method:getPointer"), [getPosition]("GI.Gdk.Objects.Window#g:method:getPosition"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRootCoords]("GI.Gdk.Objects.Window#g:method:getRootCoords"), [getRootOrigin]("GI.Gdk.Objects.Window#g:method:getRootOrigin"), [getScaleFactor]("GI.Gdk.Objects.Window#g:method:getScaleFactor"), [getScreen]("GI.Gdk.Objects.Window#g:method:getScreen"), [getSourceEvents]("GI.Gdk.Objects.Window#g:method:getSourceEvents"), [getState]("GI.Gdk.Objects.Window#g:method:getState"), [getSupportMultidevice]("GI.Gdk.Objects.Window#g:method:getSupportMultidevice"), [getToplevel]("GI.Gdk.Objects.Window#g:method:getToplevel"), [getTypeHint]("GI.Gdk.Objects.Window#g:method:getTypeHint"), [getUpdateArea]("GI.Gdk.Objects.Window#g:method:getUpdateArea"), [getUserData]("GI.Gdk.Objects.Window#g:method:getUserData"), [getVisibleRegion]("GI.Gdk.Objects.Window#g:method:getVisibleRegion"), [getVisual]("GI.Gdk.Objects.Window#g:method:getVisual"), [getWidth]("GI.Gdk.Objects.Window#g:method:getWidth"), [getWindowType]("GI.Gdk.Objects.Window#g:method:getWindowType"), [getXid]("GI.GdkX11.Objects.X11Window#g:method:getXid").
-- 
-- ==== Setters
-- [setAcceptFocus]("GI.Gdk.Objects.Window#g:method:setAcceptFocus"), [setBackground]("GI.Gdk.Objects.Window#g:method:setBackground"), [setBackgroundPattern]("GI.Gdk.Objects.Window#g:method:setBackgroundPattern"), [setBackgroundRgba]("GI.Gdk.Objects.Window#g:method:setBackgroundRgba"), [setChildInputShapes]("GI.Gdk.Objects.Window#g:method:setChildInputShapes"), [setChildShapes]("GI.Gdk.Objects.Window#g:method:setChildShapes"), [setComposited]("GI.Gdk.Objects.Window#g:method:setComposited"), [setCursor]("GI.Gdk.Objects.Window#g:method:setCursor"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorations]("GI.Gdk.Objects.Window#g:method:setDecorations"), [setDeviceCursor]("GI.Gdk.Objects.Window#g:method:setDeviceCursor"), [setDeviceEvents]("GI.Gdk.Objects.Window#g:method:setDeviceEvents"), [setEventCompression]("GI.Gdk.Objects.Window#g:method:setEventCompression"), [setEvents]("GI.Gdk.Objects.Window#g:method:setEvents"), [setFocusOnMap]("GI.Gdk.Objects.Window#g:method:setFocusOnMap"), [setFrameExtents]("GI.GdkX11.Objects.X11Window#g:method:setFrameExtents"), [setFrameSyncEnabled]("GI.GdkX11.Objects.X11Window#g:method:setFrameSyncEnabled"), [setFullscreenMode]("GI.Gdk.Objects.Window#g:method:setFullscreenMode"), [setFunctions]("GI.Gdk.Objects.Window#g:method:setFunctions"), [setGeometryHints]("GI.Gdk.Objects.Window#g:method:setGeometryHints"), [setGroup]("GI.Gdk.Objects.Window#g:method:setGroup"), [setHideTitlebarWhenMaximized]("GI.GdkX11.Objects.X11Window#g:method:setHideTitlebarWhenMaximized"), [setIconList]("GI.Gdk.Objects.Window#g:method:setIconList"), [setIconName]("GI.Gdk.Objects.Window#g:method:setIconName"), [setKeepAbove]("GI.Gdk.Objects.Window#g:method:setKeepAbove"), [setKeepBelow]("GI.Gdk.Objects.Window#g:method:setKeepBelow"), [setModalHint]("GI.Gdk.Objects.Window#g:method:setModalHint"), [setOpacity]("GI.Gdk.Objects.Window#g:method:setOpacity"), [setOpaqueRegion]("GI.Gdk.Objects.Window#g:method:setOpaqueRegion"), [setOverrideRedirect]("GI.Gdk.Objects.Window#g:method:setOverrideRedirect"), [setPassThrough]("GI.Gdk.Objects.Window#g:method:setPassThrough"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRole]("GI.Gdk.Objects.Window#g:method:setRole"), [setShadowWidth]("GI.Gdk.Objects.Window#g:method:setShadowWidth"), [setSkipPagerHint]("GI.Gdk.Objects.Window#g:method:setSkipPagerHint"), [setSkipTaskbarHint]("GI.Gdk.Objects.Window#g:method:setSkipTaskbarHint"), [setSourceEvents]("GI.Gdk.Objects.Window#g:method:setSourceEvents"), [setStartupId]("GI.Gdk.Objects.Window#g:method:setStartupId"), [setStaticGravities]("GI.Gdk.Objects.Window#g:method:setStaticGravities"), [setSupportMultidevice]("GI.Gdk.Objects.Window#g:method:setSupportMultidevice"), [setThemeVariant]("GI.GdkX11.Objects.X11Window#g:method:setThemeVariant"), [setTitle]("GI.Gdk.Objects.Window#g:method:setTitle"), [setTransientFor]("GI.Gdk.Objects.Window#g:method:setTransientFor"), [setTypeHint]("GI.Gdk.Objects.Window#g:method:setTypeHint"), [setUrgencyHint]("GI.Gdk.Objects.Window#g:method:setUrgencyHint"), [setUserData]("GI.Gdk.Objects.Window#g:method:setUserData"), [setUserTime]("GI.GdkX11.Objects.X11Window#g:method:setUserTime"), [setUtf8Property]("GI.GdkX11.Objects.X11Window#g:method:setUtf8Property").

#if defined(ENABLE_OVERLOADING)
    ResolveX11WindowMethod                  ,
#endif

-- ** foreignNewForDisplay #method:foreignNewForDisplay#

    x11WindowForeignNewForDisplay           ,


-- ** getDesktop #method:getDesktop#

#if defined(ENABLE_OVERLOADING)
    X11WindowGetDesktopMethodInfo           ,
#endif
    x11WindowGetDesktop                     ,


-- ** getXid #method:getXid#

#if defined(ENABLE_OVERLOADING)
    X11WindowGetXidMethodInfo               ,
#endif
    x11WindowGetXid                         ,


-- ** lookupForDisplay #method:lookupForDisplay#

    x11WindowLookupForDisplay               ,


-- ** moveToCurrentDesktop #method:moveToCurrentDesktop#

#if defined(ENABLE_OVERLOADING)
    X11WindowMoveToCurrentDesktopMethodInfo ,
#endif
    x11WindowMoveToCurrentDesktop           ,


-- ** moveToDesktop #method:moveToDesktop#

#if defined(ENABLE_OVERLOADING)
    X11WindowMoveToDesktopMethodInfo        ,
#endif
    x11WindowMoveToDesktop                  ,


-- ** setFrameExtents #method:setFrameExtents#

#if defined(ENABLE_OVERLOADING)
    X11WindowSetFrameExtentsMethodInfo      ,
#endif
    x11WindowSetFrameExtents                ,


-- ** setFrameSyncEnabled #method:setFrameSyncEnabled#

#if defined(ENABLE_OVERLOADING)
    X11WindowSetFrameSyncEnabledMethodInfo  ,
#endif
    x11WindowSetFrameSyncEnabled            ,


-- ** setHideTitlebarWhenMaximized #method:setHideTitlebarWhenMaximized#

#if defined(ENABLE_OVERLOADING)
    X11WindowSetHideTitlebarWhenMaximizedMethodInfo,
#endif
    x11WindowSetHideTitlebarWhenMaximized   ,


-- ** setThemeVariant #method:setThemeVariant#

#if defined(ENABLE_OVERLOADING)
    X11WindowSetThemeVariantMethodInfo      ,
#endif
    x11WindowSetThemeVariant                ,


-- ** setUserTime #method:setUserTime#

#if defined(ENABLE_OVERLOADING)
    X11WindowSetUserTimeMethodInfo          ,
#endif
    x11WindowSetUserTime                    ,


-- ** setUtf8Property #method:setUtf8Property#

#if defined(ENABLE_OVERLOADING)
    X11WindowSetUtf8PropertyMethodInfo      ,
#endif
    x11WindowSetUtf8Property                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Window as Gdk.Window
import qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Display as GdkX11.X11Display
import qualified GI.Xlib.Structs.Display as Xlib.Display

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.GdkX11.Objects.X11Display as GdkX11.X11Display

#endif

-- | Memory-managed wrapper type.
newtype X11Window = X11Window (SP.ManagedPtr X11Window)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11Window where
    toManagedPtr (X11Window p) = p

foreign import ccall "gdk_x11_window_get_type"
    c_gdk_x11_window_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11Window where
    glibType = c_gdk_x11_window_get_type

instance B.Types.GObject X11Window

-- | Type class for types which can be safely cast to `X11Window`, for instance with `toX11Window`.
class (SP.GObject o, O.IsDescendantOf X11Window o) => IsX11Window o
instance (SP.GObject o, O.IsDescendantOf X11Window o) => IsX11Window o

instance O.HasParentTypes X11Window
type instance O.ParentTypes X11Window = '[Gdk.Window.Window, GObject.Object.Object]

-- | Cast to `X11Window`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toX11Window :: (MIO.MonadIO m, IsX11Window o) => o -> m X11Window
toX11Window = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11Window

-- | Convert 'X11Window' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11Window) where
    gvalueGType_ = c_gdk_x11_window_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11Window)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11Window)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11Window ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11WindowMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11WindowMethod "beep" o = Gdk.Window.WindowBeepMethodInfo
    ResolveX11WindowMethod "beginDrawFrame" o = Gdk.Window.WindowBeginDrawFrameMethodInfo
    ResolveX11WindowMethod "beginMoveDrag" o = Gdk.Window.WindowBeginMoveDragMethodInfo
    ResolveX11WindowMethod "beginMoveDragForDevice" o = Gdk.Window.WindowBeginMoveDragForDeviceMethodInfo
    ResolveX11WindowMethod "beginPaintRect" o = Gdk.Window.WindowBeginPaintRectMethodInfo
    ResolveX11WindowMethod "beginPaintRegion" o = Gdk.Window.WindowBeginPaintRegionMethodInfo
    ResolveX11WindowMethod "beginResizeDrag" o = Gdk.Window.WindowBeginResizeDragMethodInfo
    ResolveX11WindowMethod "beginResizeDragForDevice" o = Gdk.Window.WindowBeginResizeDragForDeviceMethodInfo
    ResolveX11WindowMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11WindowMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11WindowMethod "configureFinished" o = Gdk.Window.WindowConfigureFinishedMethodInfo
    ResolveX11WindowMethod "coordsFromParent" o = Gdk.Window.WindowCoordsFromParentMethodInfo
    ResolveX11WindowMethod "coordsToParent" o = Gdk.Window.WindowCoordsToParentMethodInfo
    ResolveX11WindowMethod "createGlContext" o = Gdk.Window.WindowCreateGlContextMethodInfo
    ResolveX11WindowMethod "createSimilarImageSurface" o = Gdk.Window.WindowCreateSimilarImageSurfaceMethodInfo
    ResolveX11WindowMethod "createSimilarSurface" o = Gdk.Window.WindowCreateSimilarSurfaceMethodInfo
    ResolveX11WindowMethod "deiconify" o = Gdk.Window.WindowDeiconifyMethodInfo
    ResolveX11WindowMethod "destroy" o = Gdk.Window.WindowDestroyMethodInfo
    ResolveX11WindowMethod "destroyNotify" o = Gdk.Window.WindowDestroyNotifyMethodInfo
    ResolveX11WindowMethod "enableSynchronizedConfigure" o = Gdk.Window.WindowEnableSynchronizedConfigureMethodInfo
    ResolveX11WindowMethod "endDrawFrame" o = Gdk.Window.WindowEndDrawFrameMethodInfo
    ResolveX11WindowMethod "endPaint" o = Gdk.Window.WindowEndPaintMethodInfo
    ResolveX11WindowMethod "ensureNative" o = Gdk.Window.WindowEnsureNativeMethodInfo
    ResolveX11WindowMethod "flush" o = Gdk.Window.WindowFlushMethodInfo
    ResolveX11WindowMethod "focus" o = Gdk.Window.WindowFocusMethodInfo
    ResolveX11WindowMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11WindowMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11WindowMethod "freezeToplevelUpdatesLibgtkOnly" o = Gdk.Window.WindowFreezeToplevelUpdatesLibgtkOnlyMethodInfo
    ResolveX11WindowMethod "freezeUpdates" o = Gdk.Window.WindowFreezeUpdatesMethodInfo
    ResolveX11WindowMethod "fullscreen" o = Gdk.Window.WindowFullscreenMethodInfo
    ResolveX11WindowMethod "fullscreenOnMonitor" o = Gdk.Window.WindowFullscreenOnMonitorMethodInfo
    ResolveX11WindowMethod "geometryChanged" o = Gdk.Window.WindowGeometryChangedMethodInfo
    ResolveX11WindowMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11WindowMethod "hasNative" o = Gdk.Window.WindowHasNativeMethodInfo
    ResolveX11WindowMethod "hide" o = Gdk.Window.WindowHideMethodInfo
    ResolveX11WindowMethod "iconify" o = Gdk.Window.WindowIconifyMethodInfo
    ResolveX11WindowMethod "inputShapeCombineRegion" o = Gdk.Window.WindowInputShapeCombineRegionMethodInfo
    ResolveX11WindowMethod "invalidateMaybeRecurse" o = Gdk.Window.WindowInvalidateMaybeRecurseMethodInfo
    ResolveX11WindowMethod "invalidateRect" o = Gdk.Window.WindowInvalidateRectMethodInfo
    ResolveX11WindowMethod "invalidateRegion" o = Gdk.Window.WindowInvalidateRegionMethodInfo
    ResolveX11WindowMethod "isDestroyed" o = Gdk.Window.WindowIsDestroyedMethodInfo
    ResolveX11WindowMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11WindowMethod "isInputOnly" o = Gdk.Window.WindowIsInputOnlyMethodInfo
    ResolveX11WindowMethod "isShaped" o = Gdk.Window.WindowIsShapedMethodInfo
    ResolveX11WindowMethod "isViewable" o = Gdk.Window.WindowIsViewableMethodInfo
    ResolveX11WindowMethod "isVisible" o = Gdk.Window.WindowIsVisibleMethodInfo
    ResolveX11WindowMethod "lower" o = Gdk.Window.WindowLowerMethodInfo
    ResolveX11WindowMethod "markPaintFromClip" o = Gdk.Window.WindowMarkPaintFromClipMethodInfo
    ResolveX11WindowMethod "maximize" o = Gdk.Window.WindowMaximizeMethodInfo
    ResolveX11WindowMethod "mergeChildInputShapes" o = Gdk.Window.WindowMergeChildInputShapesMethodInfo
    ResolveX11WindowMethod "mergeChildShapes" o = Gdk.Window.WindowMergeChildShapesMethodInfo
    ResolveX11WindowMethod "move" o = Gdk.Window.WindowMoveMethodInfo
    ResolveX11WindowMethod "moveRegion" o = Gdk.Window.WindowMoveRegionMethodInfo
    ResolveX11WindowMethod "moveResize" o = Gdk.Window.WindowMoveResizeMethodInfo
    ResolveX11WindowMethod "moveToCurrentDesktop" o = X11WindowMoveToCurrentDesktopMethodInfo
    ResolveX11WindowMethod "moveToDesktop" o = X11WindowMoveToDesktopMethodInfo
    ResolveX11WindowMethod "moveToRect" o = Gdk.Window.WindowMoveToRectMethodInfo
    ResolveX11WindowMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11WindowMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11WindowMethod "peekChildren" o = Gdk.Window.WindowPeekChildrenMethodInfo
    ResolveX11WindowMethod "processUpdates" o = Gdk.Window.WindowProcessUpdatesMethodInfo
    ResolveX11WindowMethod "raise" o = Gdk.Window.WindowRaiseMethodInfo
    ResolveX11WindowMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11WindowMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11WindowMethod "registerDnd" o = Gdk.Window.WindowRegisterDndMethodInfo
    ResolveX11WindowMethod "reparent" o = Gdk.Window.WindowReparentMethodInfo
    ResolveX11WindowMethod "resize" o = Gdk.Window.WindowResizeMethodInfo
    ResolveX11WindowMethod "restack" o = Gdk.Window.WindowRestackMethodInfo
    ResolveX11WindowMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11WindowMethod "scroll" o = Gdk.Window.WindowScrollMethodInfo
    ResolveX11WindowMethod "shapeCombineRegion" o = Gdk.Window.WindowShapeCombineRegionMethodInfo
    ResolveX11WindowMethod "show" o = Gdk.Window.WindowShowMethodInfo
    ResolveX11WindowMethod "showUnraised" o = Gdk.Window.WindowShowUnraisedMethodInfo
    ResolveX11WindowMethod "showWindowMenu" o = Gdk.Window.WindowShowWindowMenuMethodInfo
    ResolveX11WindowMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11WindowMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11WindowMethod "stick" o = Gdk.Window.WindowStickMethodInfo
    ResolveX11WindowMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11WindowMethod "thawToplevelUpdatesLibgtkOnly" o = Gdk.Window.WindowThawToplevelUpdatesLibgtkOnlyMethodInfo
    ResolveX11WindowMethod "thawUpdates" o = Gdk.Window.WindowThawUpdatesMethodInfo
    ResolveX11WindowMethod "unfullscreen" o = Gdk.Window.WindowUnfullscreenMethodInfo
    ResolveX11WindowMethod "unmaximize" o = Gdk.Window.WindowUnmaximizeMethodInfo
    ResolveX11WindowMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11WindowMethod "unstick" o = Gdk.Window.WindowUnstickMethodInfo
    ResolveX11WindowMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11WindowMethod "withdraw" o = Gdk.Window.WindowWithdrawMethodInfo
    ResolveX11WindowMethod "getAcceptFocus" o = Gdk.Window.WindowGetAcceptFocusMethodInfo
    ResolveX11WindowMethod "getBackgroundPattern" o = Gdk.Window.WindowGetBackgroundPatternMethodInfo
    ResolveX11WindowMethod "getChildren" o = Gdk.Window.WindowGetChildrenMethodInfo
    ResolveX11WindowMethod "getChildrenWithUserData" o = Gdk.Window.WindowGetChildrenWithUserDataMethodInfo
    ResolveX11WindowMethod "getClipRegion" o = Gdk.Window.WindowGetClipRegionMethodInfo
    ResolveX11WindowMethod "getComposited" o = Gdk.Window.WindowGetCompositedMethodInfo
    ResolveX11WindowMethod "getCursor" o = Gdk.Window.WindowGetCursorMethodInfo
    ResolveX11WindowMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11WindowMethod "getDecorations" o = Gdk.Window.WindowGetDecorationsMethodInfo
    ResolveX11WindowMethod "getDesktop" o = X11WindowGetDesktopMethodInfo
    ResolveX11WindowMethod "getDeviceCursor" o = Gdk.Window.WindowGetDeviceCursorMethodInfo
    ResolveX11WindowMethod "getDeviceEvents" o = Gdk.Window.WindowGetDeviceEventsMethodInfo
    ResolveX11WindowMethod "getDevicePosition" o = Gdk.Window.WindowGetDevicePositionMethodInfo
    ResolveX11WindowMethod "getDevicePositionDouble" o = Gdk.Window.WindowGetDevicePositionDoubleMethodInfo
    ResolveX11WindowMethod "getDisplay" o = Gdk.Window.WindowGetDisplayMethodInfo
    ResolveX11WindowMethod "getDragProtocol" o = Gdk.Window.WindowGetDragProtocolMethodInfo
    ResolveX11WindowMethod "getEffectiveParent" o = Gdk.Window.WindowGetEffectiveParentMethodInfo
    ResolveX11WindowMethod "getEffectiveToplevel" o = Gdk.Window.WindowGetEffectiveToplevelMethodInfo
    ResolveX11WindowMethod "getEventCompression" o = Gdk.Window.WindowGetEventCompressionMethodInfo
    ResolveX11WindowMethod "getEvents" o = Gdk.Window.WindowGetEventsMethodInfo
    ResolveX11WindowMethod "getFocusOnMap" o = Gdk.Window.WindowGetFocusOnMapMethodInfo
    ResolveX11WindowMethod "getFrameClock" o = Gdk.Window.WindowGetFrameClockMethodInfo
    ResolveX11WindowMethod "getFrameExtents" o = Gdk.Window.WindowGetFrameExtentsMethodInfo
    ResolveX11WindowMethod "getFullscreenMode" o = Gdk.Window.WindowGetFullscreenModeMethodInfo
    ResolveX11WindowMethod "getGeometry" o = Gdk.Window.WindowGetGeometryMethodInfo
    ResolveX11WindowMethod "getGroup" o = Gdk.Window.WindowGetGroupMethodInfo
    ResolveX11WindowMethod "getHeight" o = Gdk.Window.WindowGetHeightMethodInfo
    ResolveX11WindowMethod "getModalHint" o = Gdk.Window.WindowGetModalHintMethodInfo
    ResolveX11WindowMethod "getOrigin" o = Gdk.Window.WindowGetOriginMethodInfo
    ResolveX11WindowMethod "getParent" o = Gdk.Window.WindowGetParentMethodInfo
    ResolveX11WindowMethod "getPassThrough" o = Gdk.Window.WindowGetPassThroughMethodInfo
    ResolveX11WindowMethod "getPointer" o = Gdk.Window.WindowGetPointerMethodInfo
    ResolveX11WindowMethod "getPosition" o = Gdk.Window.WindowGetPositionMethodInfo
    ResolveX11WindowMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11WindowMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11WindowMethod "getRootCoords" o = Gdk.Window.WindowGetRootCoordsMethodInfo
    ResolveX11WindowMethod "getRootOrigin" o = Gdk.Window.WindowGetRootOriginMethodInfo
    ResolveX11WindowMethod "getScaleFactor" o = Gdk.Window.WindowGetScaleFactorMethodInfo
    ResolveX11WindowMethod "getScreen" o = Gdk.Window.WindowGetScreenMethodInfo
    ResolveX11WindowMethod "getSourceEvents" o = Gdk.Window.WindowGetSourceEventsMethodInfo
    ResolveX11WindowMethod "getState" o = Gdk.Window.WindowGetStateMethodInfo
    ResolveX11WindowMethod "getSupportMultidevice" o = Gdk.Window.WindowGetSupportMultideviceMethodInfo
    ResolveX11WindowMethod "getToplevel" o = Gdk.Window.WindowGetToplevelMethodInfo
    ResolveX11WindowMethod "getTypeHint" o = Gdk.Window.WindowGetTypeHintMethodInfo
    ResolveX11WindowMethod "getUpdateArea" o = Gdk.Window.WindowGetUpdateAreaMethodInfo
    ResolveX11WindowMethod "getUserData" o = Gdk.Window.WindowGetUserDataMethodInfo
    ResolveX11WindowMethod "getVisibleRegion" o = Gdk.Window.WindowGetVisibleRegionMethodInfo
    ResolveX11WindowMethod "getVisual" o = Gdk.Window.WindowGetVisualMethodInfo
    ResolveX11WindowMethod "getWidth" o = Gdk.Window.WindowGetWidthMethodInfo
    ResolveX11WindowMethod "getWindowType" o = Gdk.Window.WindowGetWindowTypeMethodInfo
    ResolveX11WindowMethod "getXid" o = X11WindowGetXidMethodInfo
    ResolveX11WindowMethod "setAcceptFocus" o = Gdk.Window.WindowSetAcceptFocusMethodInfo
    ResolveX11WindowMethod "setBackground" o = Gdk.Window.WindowSetBackgroundMethodInfo
    ResolveX11WindowMethod "setBackgroundPattern" o = Gdk.Window.WindowSetBackgroundPatternMethodInfo
    ResolveX11WindowMethod "setBackgroundRgba" o = Gdk.Window.WindowSetBackgroundRgbaMethodInfo
    ResolveX11WindowMethod "setChildInputShapes" o = Gdk.Window.WindowSetChildInputShapesMethodInfo
    ResolveX11WindowMethod "setChildShapes" o = Gdk.Window.WindowSetChildShapesMethodInfo
    ResolveX11WindowMethod "setComposited" o = Gdk.Window.WindowSetCompositedMethodInfo
    ResolveX11WindowMethod "setCursor" o = Gdk.Window.WindowSetCursorMethodInfo
    ResolveX11WindowMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11WindowMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11WindowMethod "setDecorations" o = Gdk.Window.WindowSetDecorationsMethodInfo
    ResolveX11WindowMethod "setDeviceCursor" o = Gdk.Window.WindowSetDeviceCursorMethodInfo
    ResolveX11WindowMethod "setDeviceEvents" o = Gdk.Window.WindowSetDeviceEventsMethodInfo
    ResolveX11WindowMethod "setEventCompression" o = Gdk.Window.WindowSetEventCompressionMethodInfo
    ResolveX11WindowMethod "setEvents" o = Gdk.Window.WindowSetEventsMethodInfo
    ResolveX11WindowMethod "setFocusOnMap" o = Gdk.Window.WindowSetFocusOnMapMethodInfo
    ResolveX11WindowMethod "setFrameExtents" o = X11WindowSetFrameExtentsMethodInfo
    ResolveX11WindowMethod "setFrameSyncEnabled" o = X11WindowSetFrameSyncEnabledMethodInfo
    ResolveX11WindowMethod "setFullscreenMode" o = Gdk.Window.WindowSetFullscreenModeMethodInfo
    ResolveX11WindowMethod "setFunctions" o = Gdk.Window.WindowSetFunctionsMethodInfo
    ResolveX11WindowMethod "setGeometryHints" o = Gdk.Window.WindowSetGeometryHintsMethodInfo
    ResolveX11WindowMethod "setGroup" o = Gdk.Window.WindowSetGroupMethodInfo
    ResolveX11WindowMethod "setHideTitlebarWhenMaximized" o = X11WindowSetHideTitlebarWhenMaximizedMethodInfo
    ResolveX11WindowMethod "setIconList" o = Gdk.Window.WindowSetIconListMethodInfo
    ResolveX11WindowMethod "setIconName" o = Gdk.Window.WindowSetIconNameMethodInfo
    ResolveX11WindowMethod "setKeepAbove" o = Gdk.Window.WindowSetKeepAboveMethodInfo
    ResolveX11WindowMethod "setKeepBelow" o = Gdk.Window.WindowSetKeepBelowMethodInfo
    ResolveX11WindowMethod "setModalHint" o = Gdk.Window.WindowSetModalHintMethodInfo
    ResolveX11WindowMethod "setOpacity" o = Gdk.Window.WindowSetOpacityMethodInfo
    ResolveX11WindowMethod "setOpaqueRegion" o = Gdk.Window.WindowSetOpaqueRegionMethodInfo
    ResolveX11WindowMethod "setOverrideRedirect" o = Gdk.Window.WindowSetOverrideRedirectMethodInfo
    ResolveX11WindowMethod "setPassThrough" o = Gdk.Window.WindowSetPassThroughMethodInfo
    ResolveX11WindowMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11WindowMethod "setRole" o = Gdk.Window.WindowSetRoleMethodInfo
    ResolveX11WindowMethod "setShadowWidth" o = Gdk.Window.WindowSetShadowWidthMethodInfo
    ResolveX11WindowMethod "setSkipPagerHint" o = Gdk.Window.WindowSetSkipPagerHintMethodInfo
    ResolveX11WindowMethod "setSkipTaskbarHint" o = Gdk.Window.WindowSetSkipTaskbarHintMethodInfo
    ResolveX11WindowMethod "setSourceEvents" o = Gdk.Window.WindowSetSourceEventsMethodInfo
    ResolveX11WindowMethod "setStartupId" o = Gdk.Window.WindowSetStartupIdMethodInfo
    ResolveX11WindowMethod "setStaticGravities" o = Gdk.Window.WindowSetStaticGravitiesMethodInfo
    ResolveX11WindowMethod "setSupportMultidevice" o = Gdk.Window.WindowSetSupportMultideviceMethodInfo
    ResolveX11WindowMethod "setThemeVariant" o = X11WindowSetThemeVariantMethodInfo
    ResolveX11WindowMethod "setTitle" o = Gdk.Window.WindowSetTitleMethodInfo
    ResolveX11WindowMethod "setTransientFor" o = Gdk.Window.WindowSetTransientForMethodInfo
    ResolveX11WindowMethod "setTypeHint" o = Gdk.Window.WindowSetTypeHintMethodInfo
    ResolveX11WindowMethod "setUrgencyHint" o = Gdk.Window.WindowSetUrgencyHintMethodInfo
    ResolveX11WindowMethod "setUserData" o = Gdk.Window.WindowSetUserDataMethodInfo
    ResolveX11WindowMethod "setUserTime" o = X11WindowSetUserTimeMethodInfo
    ResolveX11WindowMethod "setUtf8Property" o = X11WindowSetUtf8PropertyMethodInfo
    ResolveX11WindowMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11WindowMethod t X11Window, O.OverloadedMethod info X11Window p) => OL.IsLabel t (X11Window -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11WindowMethod t X11Window, O.OverloadedMethod info X11Window p, R.HasField t X11Window p) => R.HasField t X11Window p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11WindowMethod t X11Window, O.OverloadedMethodInfo info X11Window) => OL.IsLabel t (O.MethodProxy info X11Window) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11Window
type instance O.AttributeList X11Window = X11WindowAttributeList
type X11WindowAttributeList = ('[ '("cursor", Gdk.Window.WindowCursorPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11Window = X11WindowSignalList
type X11WindowSignalList = ('[ '("createSurface", Gdk.Window.WindowCreateSurfaceSignalInfo), '("fromEmbedder", Gdk.Window.WindowFromEmbedderSignalInfo), '("movedToRect", Gdk.Window.WindowMovedToRectSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("pickEmbeddedChild", Gdk.Window.WindowPickEmbeddedChildSignalInfo), '("toEmbedder", Gdk.Window.WindowToEmbedderSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method X11Window::foreign_new_for_display
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkDisplay where the window handle comes from."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an Xlib Window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkX11" , name = "X11Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_foreign_new_for_display" gdk_x11_window_foreign_new_for_display :: 
    Ptr GdkX11.X11Display.X11Display ->     -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    FCT.CULong ->                           -- window : TBasicType TULong
    IO (Ptr X11Window)

-- | Wraps a native window in a t'GI.Gdk.Objects.Window.Window'. The function will try to
-- look up the window using 'GI.GdkX11.Objects.X11Window.x11WindowLookupForDisplay' first.
-- If it does not find it there, it will create a new window.
-- 
-- This may fail if the window has been destroyed. If the window
-- was already known to GDK, a new reference to the existing
-- t'GI.Gdk.Objects.Window.Window' is returned.
-- 
-- /Since: 2.24/
x11WindowForeignNewForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Display.IsX11Display a) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display' where the window handle comes from.
    -> FCT.CULong
    -- ^ /@window@/: an Xlib Window
    -> m X11Window
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Window.Window' wrapper for the native
    --   window, or 'P.Nothing' if the window has been destroyed. The wrapper
    --   will be newly created, if one doesn’t exist already.
x11WindowForeignNewForDisplay display window = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_window_foreign_new_for_display display' window
    checkUnexpectedReturnNULL "x11WindowForeignNewForDisplay" result
    result' <- (wrapObject X11Window) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method X11Window::get_desktop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt32)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_get_desktop" gdk_x11_window_get_desktop :: 
    Ptr X11Window ->                        -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    IO Word32

-- | Gets the number of the workspace /@window@/ is on.
-- 
-- /Since: 3.10/
x11WindowGetDesktop ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Window a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m Word32
    -- ^ __Returns:__ the current workspace of /@window@/
x11WindowGetDesktop window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_x11_window_get_desktop window'
    touchManagedPtr window
    return result

#if defined(ENABLE_OVERLOADING)
data X11WindowGetDesktopMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsX11Window a) => O.OverloadedMethod X11WindowGetDesktopMethodInfo a signature where
    overloadedMethod = x11WindowGetDesktop

instance O.OverloadedMethodInfo X11WindowGetDesktopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Window.x11WindowGetDesktop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Window.html#v:x11WindowGetDesktop"
        })


#endif

-- method X11Window::get_xid
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a native #GdkWindow."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TULong)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_get_xid" gdk_x11_window_get_xid :: 
    Ptr X11Window ->                        -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    IO FCT.CULong

-- | Returns the X resource (window) belonging to a t'GI.Gdk.Objects.Window.Window'.
x11WindowGetXid ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Window a) =>
    a
    -- ^ /@window@/: a native t'GI.Gdk.Objects.Window.Window'.
    -> m FCT.CULong
    -- ^ __Returns:__ the ID of /@drawable@/’s X resource.
x11WindowGetXid window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gdk_x11_window_get_xid window'
    touchManagedPtr window
    return result

#if defined(ENABLE_OVERLOADING)
data X11WindowGetXidMethodInfo
instance (signature ~ (m FCT.CULong), MonadIO m, IsX11Window a) => O.OverloadedMethod X11WindowGetXidMethodInfo a signature where
    overloadedMethod = x11WindowGetXid

instance O.OverloadedMethodInfo X11WindowGetXidMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Window.x11WindowGetXid",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Window.html#v:x11WindowGetXid"
        })


#endif

-- method X11Window::move_to_current_desktop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_move_to_current_desktop" gdk_x11_window_move_to_current_desktop :: 
    Ptr X11Window ->                        -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    IO ()

-- | Moves the window to the correct workspace when running under a
-- window manager that supports multiple workspaces, as described
-- in the <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints> specification.
-- Will not do anything if the window is already on all workspaces.
-- 
-- /Since: 2.8/
x11WindowMoveToCurrentDesktop ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Window a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> m ()
x11WindowMoveToCurrentDesktop window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_x11_window_move_to_current_desktop window'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data X11WindowMoveToCurrentDesktopMethodInfo
instance (signature ~ (m ()), MonadIO m, IsX11Window a) => O.OverloadedMethod X11WindowMoveToCurrentDesktopMethodInfo a signature where
    overloadedMethod = x11WindowMoveToCurrentDesktop

instance O.OverloadedMethodInfo X11WindowMoveToCurrentDesktopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Window.x11WindowMoveToCurrentDesktop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Window.html#v:x11WindowMoveToCurrentDesktop"
        })


#endif

-- method X11Window::move_to_desktop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "desktop"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of the workspace to move the window to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_move_to_desktop" gdk_x11_window_move_to_desktop :: 
    Ptr X11Window ->                        -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    Word32 ->                               -- desktop : TBasicType TUInt32
    IO ()

-- | Moves the window to the given workspace when running unde a
-- window manager that supports multiple workspaces, as described
-- in the <http://www.freedesktop.org/Standards/wm-spec Extended Window Manager Hints> specification.
-- 
-- /Since: 3.10/
x11WindowMoveToDesktop ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Window a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Word32
    -- ^ /@desktop@/: the number of the workspace to move the window to
    -> m ()
x11WindowMoveToDesktop window desktop = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_x11_window_move_to_desktop window' desktop
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data X11WindowMoveToDesktopMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsX11Window a) => O.OverloadedMethod X11WindowMoveToDesktopMethodInfo a signature where
    overloadedMethod = x11WindowMoveToDesktop

instance O.OverloadedMethodInfo X11WindowMoveToDesktopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Window.x11WindowMoveToDesktop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Window.html#v:x11WindowMoveToDesktop"
        })


#endif

-- method X11Window::set_frame_extents
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "left"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The left extent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "right"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The right extent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "top"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The top extent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bottom"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The bottom extent" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_set_frame_extents" gdk_x11_window_set_frame_extents :: 
    Ptr X11Window ->                        -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    Int32 ->                                -- left : TBasicType TInt
    Int32 ->                                -- right : TBasicType TInt
    Int32 ->                                -- top : TBasicType TInt
    Int32 ->                                -- bottom : TBasicType TInt
    IO ()

{-# DEPRECATED x11WindowSetFrameExtents ["(Since version 3.12)","Use 'GI.Gdk.Objects.Window.windowSetShadowWidth' instead."] #-}
-- | This is the same as 'GI.Gdk.Objects.Window.windowSetShadowWidth' but it only works
-- on GdkX11Window.
-- 
-- /Since: 3.10/
x11WindowSetFrameExtents ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Window a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Int32
    -- ^ /@left@/: The left extent
    -> Int32
    -- ^ /@right@/: The right extent
    -> Int32
    -- ^ /@top@/: The top extent
    -> Int32
    -- ^ /@bottom@/: The bottom extent
    -> m ()
x11WindowSetFrameExtents window left right top bottom = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_x11_window_set_frame_extents window' left right top bottom
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data X11WindowSetFrameExtentsMethodInfo
instance (signature ~ (Int32 -> Int32 -> Int32 -> Int32 -> m ()), MonadIO m, IsX11Window a) => O.OverloadedMethod X11WindowSetFrameExtentsMethodInfo a signature where
    overloadedMethod = x11WindowSetFrameExtents

instance O.OverloadedMethodInfo X11WindowSetFrameExtentsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Window.x11WindowSetFrameExtents",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Window.html#v:x11WindowSetFrameExtents"
        })


#endif

-- method X11Window::set_frame_sync_enabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a native #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "frame_sync_enabled"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether frame-synchronization should be enabled"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_set_frame_sync_enabled" gdk_x11_window_set_frame_sync_enabled :: 
    Ptr X11Window ->                        -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    CInt ->                                 -- frame_sync_enabled : TBasicType TBoolean
    IO ()

-- | This function can be used to disable frame synchronization for a window.
-- Normally frame synchronziation will be enabled or disabled based on whether
-- the system has a compositor that supports frame synchronization, but if
-- the window is not directly managed by the window manager, then frame
-- synchronziation may need to be disabled. This is the case for a window
-- embedded via the XEMBED protocol.
-- 
-- /Since: 3.8/
x11WindowSetFrameSyncEnabled ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Window a) =>
    a
    -- ^ /@window@/: a native t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@frameSyncEnabled@/: whether frame-synchronization should be enabled
    -> m ()
x11WindowSetFrameSyncEnabled window frameSyncEnabled = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let frameSyncEnabled' = (P.fromIntegral . P.fromEnum) frameSyncEnabled
    gdk_x11_window_set_frame_sync_enabled window' frameSyncEnabled'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data X11WindowSetFrameSyncEnabledMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsX11Window a) => O.OverloadedMethod X11WindowSetFrameSyncEnabledMethodInfo a signature where
    overloadedMethod = x11WindowSetFrameSyncEnabled

instance O.OverloadedMethodInfo X11WindowSetFrameSyncEnabledMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Window.x11WindowSetFrameSyncEnabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Window.html#v:x11WindowSetFrameSyncEnabled"
        })


#endif

-- method X11Window::set_hide_titlebar_when_maximized
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hide_titlebar_when_maximized"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether to hide the titlebar when\n                               maximized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_set_hide_titlebar_when_maximized" gdk_x11_window_set_hide_titlebar_when_maximized :: 
    Ptr X11Window ->                        -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    CInt ->                                 -- hide_titlebar_when_maximized : TBasicType TBoolean
    IO ()

-- | Set a hint for the window manager, requesting that the titlebar
-- should be hidden when the window is maximized.
-- 
-- Note that this property is automatically updated by GTK+, so this
-- function should only be used by applications which do not use GTK+
-- to create toplevel windows.
-- 
-- /Since: 3.4/
x11WindowSetHideTitlebarWhenMaximized ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Window a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> Bool
    -- ^ /@hideTitlebarWhenMaximized@/: whether to hide the titlebar when
    --                                maximized
    -> m ()
x11WindowSetHideTitlebarWhenMaximized window hideTitlebarWhenMaximized = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let hideTitlebarWhenMaximized' = (P.fromIntegral . P.fromEnum) hideTitlebarWhenMaximized
    gdk_x11_window_set_hide_titlebar_when_maximized window' hideTitlebarWhenMaximized'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data X11WindowSetHideTitlebarWhenMaximizedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsX11Window a) => O.OverloadedMethod X11WindowSetHideTitlebarWhenMaximizedMethodInfo a signature where
    overloadedMethod = x11WindowSetHideTitlebarWhenMaximized

instance O.OverloadedMethodInfo X11WindowSetHideTitlebarWhenMaximizedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Window.x11WindowSetHideTitlebarWhenMaximized",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Window.html#v:x11WindowSetHideTitlebarWhenMaximized"
        })


#endif

-- method X11Window::set_theme_variant
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "variant"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the theme variant to export"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_set_theme_variant" gdk_x11_window_set_theme_variant :: 
    Ptr X11Window ->                        -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    CString ->                              -- variant : TBasicType TUTF8
    IO ()

-- | GTK+ applications can request a dark theme variant. In order to
-- make other applications - namely window managers using GTK+ for
-- themeing - aware of this choice, GTK+ uses this function to
-- export the requested theme variant as _GTK_THEME_VARIANT property
-- on toplevel windows.
-- 
-- Note that this property is automatically updated by GTK+, so this
-- function should only be used by applications which do not use GTK+
-- to create toplevel windows.
-- 
-- /Since: 3.2/
x11WindowSetThemeVariant ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Window a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> T.Text
    -- ^ /@variant@/: the theme variant to export
    -> m ()
x11WindowSetThemeVariant window variant = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    variant' <- textToCString variant
    gdk_x11_window_set_theme_variant window' variant'
    touchManagedPtr window
    freeMem variant'
    return ()

#if defined(ENABLE_OVERLOADING)
data X11WindowSetThemeVariantMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsX11Window a) => O.OverloadedMethod X11WindowSetThemeVariantMethodInfo a signature where
    overloadedMethod = x11WindowSetThemeVariant

instance O.OverloadedMethodInfo X11WindowSetThemeVariantMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Window.x11WindowSetThemeVariant",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Window.html#v:x11WindowSetThemeVariant"
        })


#endif

-- method X11Window::set_user_time
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A toplevel #GdkWindow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timestamp"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "An XServer timestamp to which the property should be set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_set_user_time" gdk_x11_window_set_user_time :: 
    Ptr X11Window ->                        -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    Word32 ->                               -- timestamp : TBasicType TUInt32
    IO ()

-- | The application can use this call to update the _NET_WM_USER_TIME
-- property on a toplevel window.  This property stores an Xserver
-- time which represents the time of the last user input event
-- received for this window.  This property may be used by the window
-- manager to alter the focus, stacking, and\/or placement behavior of
-- windows when they are mapped depending on whether the new window
-- was created by a user action or is a \"pop-up\" window activated by a
-- timer or some other event.
-- 
-- Note that this property is automatically updated by GDK, so this
-- function should only be used by applications which handle input
-- events bypassing GDK.
-- 
-- /Since: 2.6/
x11WindowSetUserTime ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Window a) =>
    a
    -- ^ /@window@/: A toplevel t'GI.Gdk.Objects.Window.Window'
    -> Word32
    -- ^ /@timestamp@/: An XServer timestamp to which the property should be set
    -> m ()
x11WindowSetUserTime window timestamp = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    gdk_x11_window_set_user_time window' timestamp
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data X11WindowSetUserTimeMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsX11Window a) => O.OverloadedMethod X11WindowSetUserTimeMethodInfo a signature where
    overloadedMethod = x11WindowSetUserTime

instance O.OverloadedMethodInfo X11WindowSetUserTimeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Window.x11WindowSetUserTime",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Window.html#v:x11WindowSetUserTime"
        })


#endif

-- method X11Window::set_utf8_property
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkWindow" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Property name, will be interned as an X atom"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Property value, or %NULL to delete"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_set_utf8_property" gdk_x11_window_set_utf8_property :: 
    Ptr X11Window ->                        -- window : TInterface (Name {namespace = "GdkX11", name = "X11Window"})
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- value : TBasicType TUTF8
    IO ()

-- | This function modifies or removes an arbitrary X11 window
-- property of type UTF8_STRING.  If the given /@window@/ is
-- not a toplevel window, it is ignored.
-- 
-- /Since: 3.4/
x11WindowSetUtf8Property ::
    (B.CallStack.HasCallStack, MonadIO m, IsX11Window a) =>
    a
    -- ^ /@window@/: a t'GI.Gdk.Objects.Window.Window'
    -> T.Text
    -- ^ /@name@/: Property name, will be interned as an X atom
    -> Maybe (T.Text)
    -- ^ /@value@/: Property value, or 'P.Nothing' to delete
    -> m ()
x11WindowSetUtf8Property window name value = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    name' <- textToCString name
    maybeValue <- case value of
        Nothing -> return FP.nullPtr
        Just jValue -> do
            jValue' <- textToCString jValue
            return jValue'
    gdk_x11_window_set_utf8_property window' name' maybeValue
    touchManagedPtr window
    freeMem name'
    freeMem maybeValue
    return ()

#if defined(ENABLE_OVERLOADING)
data X11WindowSetUtf8PropertyMethodInfo
instance (signature ~ (T.Text -> Maybe (T.Text) -> m ()), MonadIO m, IsX11Window a) => O.OverloadedMethod X11WindowSetUtf8PropertyMethodInfo a signature where
    overloadedMethod = x11WindowSetUtf8Property

instance O.OverloadedMethodInfo X11WindowSetUtf8PropertyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkX11.Objects.X11Window.x11WindowSetUtf8Property",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkx11-3.0.13/docs/GI-GdkX11-Objects-X11Window.html#v:x11WindowSetUtf8Property"
        })


#endif

-- method X11Window::lookup_for_display
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "GdkX11" , name = "X11Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the #GdkDisplay corresponding to the\n          window handle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window"
--           , argType = TBasicType TULong
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an Xlib Window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "GdkX11" , name = "X11Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_x11_window_lookup_for_display" gdk_x11_window_lookup_for_display :: 
    Ptr GdkX11.X11Display.X11Display ->     -- display : TInterface (Name {namespace = "GdkX11", name = "X11Display"})
    FCT.CULong ->                           -- window : TBasicType TULong
    IO (Ptr X11Window)

-- | Looks up the t'GI.Gdk.Objects.Window.Window' that wraps the given native window handle.
-- 
-- /Since: 2.24/
x11WindowLookupForDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, GdkX11.X11Display.IsX11Display a) =>
    a
    -- ^ /@display@/: the t'GI.Gdk.Objects.Display.Display' corresponding to the
    --           window handle
    -> FCT.CULong
    -- ^ /@window@/: an Xlib Window
    -> m X11Window
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Window.Window' wrapper for the native
    --    window, or 'P.Nothing' if there is none.
x11WindowLookupForDisplay display window = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_x11_window_lookup_for_display display' window
    checkUnexpectedReturnNULL "x11WindowLookupForDisplay" result
    result' <- (newObject X11Window) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


