{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated from button presses for the buttons 4 to 7. Wheel mice are
-- usually configured to generate button press events for buttons 4 and 5
-- when the wheel is turned.
-- 
-- Some GDK backends can also generate “smooth” scroll events, which
-- can be recognized by the 'GI.Gdk.Enums.ScrollDirectionSmooth' scroll direction. For
-- these, the scroll deltas can be obtained with
-- 'GI.Gdk.Unions.Event.eventGetScrollDeltas'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventScroll
    ( 

-- * Exported types
    EventScroll(..)                         ,
    newZeroEventScroll                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventScrollMethod                ,
#endif



 -- * Properties


-- ** deltaX #attr:deltaX#
-- | the x coordinate of the scroll delta

#if defined(ENABLE_OVERLOADING)
    eventScroll_deltaX                      ,
#endif
    getEventScrollDeltaX                    ,
    setEventScrollDeltaX                    ,


-- ** deltaY #attr:deltaY#
-- | the y coordinate of the scroll delta

#if defined(ENABLE_OVERLOADING)
    eventScroll_deltaY                      ,
#endif
    getEventScrollDeltaY                    ,
    setEventScrollDeltaY                    ,


-- ** device #attr:device#
-- | the master device that the event originated from. Use
-- 'GI.Gdk.Unions.Event.eventGetSourceDevice' to get the slave device.

    clearEventScrollDevice                  ,
#if defined(ENABLE_OVERLOADING)
    eventScroll_device                      ,
#endif
    getEventScrollDevice                    ,
    setEventScrollDevice                    ,


-- ** direction #attr:direction#
-- | the direction to scroll to (one of 'GI.Gdk.Enums.ScrollDirectionUp',
--   'GI.Gdk.Enums.ScrollDirectionDown', 'GI.Gdk.Enums.ScrollDirectionLeft', 'GI.Gdk.Enums.ScrollDirectionRight' or
--   'GI.Gdk.Enums.ScrollDirectionSmooth').

#if defined(ENABLE_OVERLOADING)
    eventScroll_direction                   ,
#endif
    getEventScrollDirection                 ,
    setEventScrollDirection                 ,


-- ** isStop #attr:isStop#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    eventScroll_isStop                      ,
#endif
    getEventScrollIsStop                    ,
    setEventScrollIsStop                    ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventScroll_sendEvent                   ,
#endif
    getEventScrollSendEvent                 ,
    setEventScrollSendEvent                 ,


-- ** state #attr:state#
-- | a bit-mask representing the state of
--   the modifier keys (e.g. Control, Shift and Alt) and the pointer
--   buttons. See t'GI.Gdk.Flags.ModifierType'.

#if defined(ENABLE_OVERLOADING)
    eventScroll_state                       ,
#endif
    getEventScrollState                     ,
    setEventScrollState                     ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventScroll_time                        ,
#endif
    getEventScrollTime                      ,
    setEventScrollTime                      ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeScroll').

#if defined(ENABLE_OVERLOADING)
    eventScroll_type                        ,
#endif
    getEventScrollType                      ,
    setEventScrollType                      ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventScrollWindow                  ,
#if defined(ENABLE_OVERLOADING)
    eventScroll_window                      ,
#endif
    getEventScrollWindow                    ,
    setEventScrollWindow                    ,


-- ** x #attr:x#
-- | the x coordinate of the pointer relative to the window.

#if defined(ENABLE_OVERLOADING)
    eventScroll_x                           ,
#endif
    getEventScrollX                         ,
    setEventScrollX                         ,


-- ** xRoot #attr:xRoot#
-- | the x coordinate of the pointer relative to the root of the
--   screen.

#if defined(ENABLE_OVERLOADING)
    eventScroll_xRoot                       ,
#endif
    getEventScrollXRoot                     ,
    setEventScrollXRoot                     ,


-- ** y #attr:y#
-- | the y coordinate of the pointer relative to the window.

#if defined(ENABLE_OVERLOADING)
    eventScroll_y                           ,
#endif
    getEventScrollY                         ,
    setEventScrollY                         ,


-- ** yRoot #attr:yRoot#
-- | the y coordinate of the pointer relative to the root of the
--   screen.

#if defined(ENABLE_OVERLOADING)
    eventScroll_yRoot                       ,
#endif
    getEventScrollYRoot                     ,
    setEventScrollYRoot                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventScroll = EventScroll (SP.ManagedPtr EventScroll)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventScroll where
    toManagedPtr (EventScroll p) = p

instance BoxedPtr EventScroll where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 96 >=> B.ManagedPtr.wrapPtr EventScroll)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventScroll where
    boxedPtrCalloc = callocBytes 96


-- | Construct a `EventScroll` struct initialized to zero.
newZeroEventScroll :: MonadIO m => m EventScroll
newZeroEventScroll = liftIO $ boxedPtrCalloc >>= wrapPtr EventScroll

instance tag ~ 'AttrSet => Constructible EventScroll tag where
    new _ attrs = do
        o <- newZeroEventScroll
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #type
-- @
getEventScrollType :: MonadIO m => EventScroll -> m Gdk.Enums.EventType
getEventScrollType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollType :: MonadIO m => EventScroll -> Gdk.Enums.EventType -> m ()
setEventScrollType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventScrollTypeFieldInfo
instance AttrInfo EventScrollTypeFieldInfo where
    type AttrBaseTypeConstraint EventScrollTypeFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventScrollTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventScrollTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventScrollTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventScrollTypeFieldInfo = "type"
    type AttrOrigin EventScrollTypeFieldInfo = EventScroll
    attrGet = getEventScrollType
    attrSet = setEventScrollType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:type"
        })

eventScroll_type :: AttrLabelProxy "type"
eventScroll_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #window
-- @
getEventScrollWindow :: MonadIO m => EventScroll -> m (Maybe Gdk.Window.Window)
getEventScrollWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollWindow :: MonadIO m => EventScroll -> Ptr Gdk.Window.Window -> m ()
setEventScrollWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventScrollWindow :: MonadIO m => EventScroll -> m ()
clearEventScrollWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventScrollWindowFieldInfo
instance AttrInfo EventScrollWindowFieldInfo where
    type AttrBaseTypeConstraint EventScrollWindowFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventScrollWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventScrollWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventScrollWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventScrollWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventScrollWindowFieldInfo = "window"
    type AttrOrigin EventScrollWindowFieldInfo = EventScroll
    attrGet = getEventScrollWindow
    attrSet = setEventScrollWindow
    attrConstruct = undefined
    attrClear = clearEventScrollWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:window"
        })

eventScroll_window :: AttrLabelProxy "window"
eventScroll_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #sendEvent
-- @
getEventScrollSendEvent :: MonadIO m => EventScroll -> m Int8
getEventScrollSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollSendEvent :: MonadIO m => EventScroll -> Int8 -> m ()
setEventScrollSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventScrollSendEventFieldInfo
instance AttrInfo EventScrollSendEventFieldInfo where
    type AttrBaseTypeConstraint EventScrollSendEventFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventScrollSendEventFieldInfo = (~)Int8
    type AttrTransferType EventScrollSendEventFieldInfo = Int8
    type AttrGetType EventScrollSendEventFieldInfo = Int8
    type AttrLabel EventScrollSendEventFieldInfo = "send_event"
    type AttrOrigin EventScrollSendEventFieldInfo = EventScroll
    attrGet = getEventScrollSendEvent
    attrSet = setEventScrollSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:sendEvent"
        })

eventScroll_sendEvent :: AttrLabelProxy "sendEvent"
eventScroll_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #time
-- @
getEventScrollTime :: MonadIO m => EventScroll -> m Word32
getEventScrollTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollTime :: MonadIO m => EventScroll -> Word32 -> m ()
setEventScrollTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventScrollTimeFieldInfo
instance AttrInfo EventScrollTimeFieldInfo where
    type AttrBaseTypeConstraint EventScrollTimeFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventScrollTimeFieldInfo = (~)Word32
    type AttrTransferType EventScrollTimeFieldInfo = Word32
    type AttrGetType EventScrollTimeFieldInfo = Word32
    type AttrLabel EventScrollTimeFieldInfo = "time"
    type AttrOrigin EventScrollTimeFieldInfo = EventScroll
    attrGet = getEventScrollTime
    attrSet = setEventScrollTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:time"
        })

eventScroll_time :: AttrLabelProxy "time"
eventScroll_time = AttrLabelProxy

#endif


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #x
-- @
getEventScrollX :: MonadIO m => EventScroll -> m Double
getEventScrollX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollX :: MonadIO m => EventScroll -> Double -> m ()
setEventScrollX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 24) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventScrollXFieldInfo
instance AttrInfo EventScrollXFieldInfo where
    type AttrBaseTypeConstraint EventScrollXFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollXFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventScrollXFieldInfo = (~)Double
    type AttrTransferType EventScrollXFieldInfo = Double
    type AttrGetType EventScrollXFieldInfo = Double
    type AttrLabel EventScrollXFieldInfo = "x"
    type AttrOrigin EventScrollXFieldInfo = EventScroll
    attrGet = getEventScrollX
    attrSet = setEventScrollX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:x"
        })

eventScroll_x :: AttrLabelProxy "x"
eventScroll_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #y
-- @
getEventScrollY :: MonadIO m => EventScroll -> m Double
getEventScrollY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollY :: MonadIO m => EventScroll -> Double -> m ()
setEventScrollY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 32) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventScrollYFieldInfo
instance AttrInfo EventScrollYFieldInfo where
    type AttrBaseTypeConstraint EventScrollYFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollYFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventScrollYFieldInfo = (~)Double
    type AttrTransferType EventScrollYFieldInfo = Double
    type AttrGetType EventScrollYFieldInfo = Double
    type AttrLabel EventScrollYFieldInfo = "y"
    type AttrOrigin EventScrollYFieldInfo = EventScroll
    attrGet = getEventScrollY
    attrSet = setEventScrollY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:y"
        })

eventScroll_y :: AttrLabelProxy "y"
eventScroll_y = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #state
-- @
getEventScrollState :: MonadIO m => EventScroll -> m [Gdk.Flags.ModifierType]
getEventScrollState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollState :: MonadIO m => EventScroll -> [Gdk.Flags.ModifierType] -> m ()
setEventScrollState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 40) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventScrollStateFieldInfo
instance AttrInfo EventScrollStateFieldInfo where
    type AttrBaseTypeConstraint EventScrollStateFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollStateFieldInfo = (~) [Gdk.Flags.ModifierType]
    type AttrTransferTypeConstraint EventScrollStateFieldInfo = (~)[Gdk.Flags.ModifierType]
    type AttrTransferType EventScrollStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrGetType EventScrollStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrLabel EventScrollStateFieldInfo = "state"
    type AttrOrigin EventScrollStateFieldInfo = EventScroll
    attrGet = getEventScrollState
    attrSet = setEventScrollState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:state"
        })

eventScroll_state :: AttrLabelProxy "state"
eventScroll_state = AttrLabelProxy

#endif


-- | Get the value of the “@direction@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #direction
-- @
getEventScrollDirection :: MonadIO m => EventScroll -> m Gdk.Enums.ScrollDirection
getEventScrollDirection s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 44) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@direction@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #direction 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollDirection :: MonadIO m => EventScroll -> Gdk.Enums.ScrollDirection -> m ()
setEventScrollDirection s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 44) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventScrollDirectionFieldInfo
instance AttrInfo EventScrollDirectionFieldInfo where
    type AttrBaseTypeConstraint EventScrollDirectionFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollDirectionFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollDirectionFieldInfo = (~) Gdk.Enums.ScrollDirection
    type AttrTransferTypeConstraint EventScrollDirectionFieldInfo = (~)Gdk.Enums.ScrollDirection
    type AttrTransferType EventScrollDirectionFieldInfo = Gdk.Enums.ScrollDirection
    type AttrGetType EventScrollDirectionFieldInfo = Gdk.Enums.ScrollDirection
    type AttrLabel EventScrollDirectionFieldInfo = "direction"
    type AttrOrigin EventScrollDirectionFieldInfo = EventScroll
    attrGet = getEventScrollDirection
    attrSet = setEventScrollDirection
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.direction"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:direction"
        })

eventScroll_direction :: AttrLabelProxy "direction"
eventScroll_direction = AttrLabelProxy

#endif


-- | Get the value of the “@device@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #device
-- @
getEventScrollDevice :: MonadIO m => EventScroll -> m (Maybe Gdk.Device.Device)
getEventScrollDevice s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO (Ptr Gdk.Device.Device)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Device.Device) val'
        return val''
    return result

-- | Set the value of the “@device@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #device 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollDevice :: MonadIO m => EventScroll -> Ptr Gdk.Device.Device -> m ()
setEventScrollDevice s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (val :: Ptr Gdk.Device.Device)

-- | Set the value of the “@device@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #device
-- @
clearEventScrollDevice :: MonadIO m => EventScroll -> m ()
clearEventScrollDevice s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 48) (FP.nullPtr :: Ptr Gdk.Device.Device)

#if defined(ENABLE_OVERLOADING)
data EventScrollDeviceFieldInfo
instance AttrInfo EventScrollDeviceFieldInfo where
    type AttrBaseTypeConstraint EventScrollDeviceFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollDeviceFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventScrollDeviceFieldInfo = (~) (Ptr Gdk.Device.Device)
    type AttrTransferTypeConstraint EventScrollDeviceFieldInfo = (~)(Ptr Gdk.Device.Device)
    type AttrTransferType EventScrollDeviceFieldInfo = (Ptr Gdk.Device.Device)
    type AttrGetType EventScrollDeviceFieldInfo = Maybe Gdk.Device.Device
    type AttrLabel EventScrollDeviceFieldInfo = "device"
    type AttrOrigin EventScrollDeviceFieldInfo = EventScroll
    attrGet = getEventScrollDevice
    attrSet = setEventScrollDevice
    attrConstruct = undefined
    attrClear = clearEventScrollDevice
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.device"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:device"
        })

eventScroll_device :: AttrLabelProxy "device"
eventScroll_device = AttrLabelProxy

#endif


-- | Get the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #xRoot
-- @
getEventScrollXRoot :: MonadIO m => EventScroll -> m Double
getEventScrollXRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #xRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollXRoot :: MonadIO m => EventScroll -> Double -> m ()
setEventScrollXRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 56) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventScrollXRootFieldInfo
instance AttrInfo EventScrollXRootFieldInfo where
    type AttrBaseTypeConstraint EventScrollXRootFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollXRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollXRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventScrollXRootFieldInfo = (~)Double
    type AttrTransferType EventScrollXRootFieldInfo = Double
    type AttrGetType EventScrollXRootFieldInfo = Double
    type AttrLabel EventScrollXRootFieldInfo = "x_root"
    type AttrOrigin EventScrollXRootFieldInfo = EventScroll
    attrGet = getEventScrollXRoot
    attrSet = setEventScrollXRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.xRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:xRoot"
        })

eventScroll_xRoot :: AttrLabelProxy "xRoot"
eventScroll_xRoot = AttrLabelProxy

#endif


-- | Get the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #yRoot
-- @
getEventScrollYRoot :: MonadIO m => EventScroll -> m Double
getEventScrollYRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #yRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollYRoot :: MonadIO m => EventScroll -> Double -> m ()
setEventScrollYRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 64) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventScrollYRootFieldInfo
instance AttrInfo EventScrollYRootFieldInfo where
    type AttrBaseTypeConstraint EventScrollYRootFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollYRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollYRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventScrollYRootFieldInfo = (~)Double
    type AttrTransferType EventScrollYRootFieldInfo = Double
    type AttrGetType EventScrollYRootFieldInfo = Double
    type AttrLabel EventScrollYRootFieldInfo = "y_root"
    type AttrOrigin EventScrollYRootFieldInfo = EventScroll
    attrGet = getEventScrollYRoot
    attrSet = setEventScrollYRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.yRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:yRoot"
        })

eventScroll_yRoot :: AttrLabelProxy "yRoot"
eventScroll_yRoot = AttrLabelProxy

#endif


-- | Get the value of the “@delta_x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #deltaX
-- @
getEventScrollDeltaX :: MonadIO m => EventScroll -> m Double
getEventScrollDeltaX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@delta_x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #deltaX 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollDeltaX :: MonadIO m => EventScroll -> Double -> m ()
setEventScrollDeltaX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 72) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventScrollDeltaXFieldInfo
instance AttrInfo EventScrollDeltaXFieldInfo where
    type AttrBaseTypeConstraint EventScrollDeltaXFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollDeltaXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollDeltaXFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventScrollDeltaXFieldInfo = (~)Double
    type AttrTransferType EventScrollDeltaXFieldInfo = Double
    type AttrGetType EventScrollDeltaXFieldInfo = Double
    type AttrLabel EventScrollDeltaXFieldInfo = "delta_x"
    type AttrOrigin EventScrollDeltaXFieldInfo = EventScroll
    attrGet = getEventScrollDeltaX
    attrSet = setEventScrollDeltaX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.deltaX"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:deltaX"
        })

eventScroll_deltaX :: AttrLabelProxy "deltaX"
eventScroll_deltaX = AttrLabelProxy

#endif


-- | Get the value of the “@delta_y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #deltaY
-- @
getEventScrollDeltaY :: MonadIO m => EventScroll -> m Double
getEventScrollDeltaY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 80) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@delta_y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #deltaY 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollDeltaY :: MonadIO m => EventScroll -> Double -> m ()
setEventScrollDeltaY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 80) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventScrollDeltaYFieldInfo
instance AttrInfo EventScrollDeltaYFieldInfo where
    type AttrBaseTypeConstraint EventScrollDeltaYFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollDeltaYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollDeltaYFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventScrollDeltaYFieldInfo = (~)Double
    type AttrTransferType EventScrollDeltaYFieldInfo = Double
    type AttrGetType EventScrollDeltaYFieldInfo = Double
    type AttrLabel EventScrollDeltaYFieldInfo = "delta_y"
    type AttrOrigin EventScrollDeltaYFieldInfo = EventScroll
    attrGet = getEventScrollDeltaY
    attrSet = setEventScrollDeltaY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.deltaY"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:deltaY"
        })

eventScroll_deltaY :: AttrLabelProxy "deltaY"
eventScroll_deltaY = AttrLabelProxy

#endif


-- | Get the value of the “@is_stop@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventScroll #isStop
-- @
getEventScrollIsStop :: MonadIO m => EventScroll -> m Word32
getEventScrollIsStop s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 88) :: IO Word32
    return val

-- | Set the value of the “@is_stop@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventScroll [ #isStop 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventScrollIsStop :: MonadIO m => EventScroll -> Word32 -> m ()
setEventScrollIsStop s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 88) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventScrollIsStopFieldInfo
instance AttrInfo EventScrollIsStopFieldInfo where
    type AttrBaseTypeConstraint EventScrollIsStopFieldInfo = (~) EventScroll
    type AttrAllowedOps EventScrollIsStopFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventScrollIsStopFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventScrollIsStopFieldInfo = (~)Word32
    type AttrTransferType EventScrollIsStopFieldInfo = Word32
    type AttrGetType EventScrollIsStopFieldInfo = Word32
    type AttrLabel EventScrollIsStopFieldInfo = "is_stop"
    type AttrOrigin EventScrollIsStopFieldInfo = EventScroll
    attrGet = getEventScrollIsStop
    attrSet = setEventScrollIsStop
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventScroll.isStop"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventScroll.html#g:attr:isStop"
        })

eventScroll_isStop :: AttrLabelProxy "isStop"
eventScroll_isStop = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventScroll
type instance O.AttributeList EventScroll = EventScrollAttributeList
type EventScrollAttributeList = ('[ '("type", EventScrollTypeFieldInfo), '("window", EventScrollWindowFieldInfo), '("sendEvent", EventScrollSendEventFieldInfo), '("time", EventScrollTimeFieldInfo), '("x", EventScrollXFieldInfo), '("y", EventScrollYFieldInfo), '("state", EventScrollStateFieldInfo), '("direction", EventScrollDirectionFieldInfo), '("device", EventScrollDeviceFieldInfo), '("xRoot", EventScrollXRootFieldInfo), '("yRoot", EventScrollYRootFieldInfo), '("deltaX", EventScrollDeltaXFieldInfo), '("deltaY", EventScrollDeltaYFieldInfo), '("isStop", EventScrollIsStopFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventScrollMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventScrollMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventScrollMethod t EventScroll, O.OverloadedMethod info EventScroll p) => OL.IsLabel t (EventScroll -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventScrollMethod t EventScroll, O.OverloadedMethod info EventScroll p, R.HasField t EventScroll p) => R.HasField t EventScroll p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventScrollMethod t EventScroll, O.OverloadedMethodInfo info EventScroll) => OL.IsLabel t (O.MethodProxy info EventScroll) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


