{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Proximity events are generated when using GDK’s wrapper for the
-- XInput extension. The XInput extension is an add-on for standard X
-- that allows you to use nonstandard devices such as graphics tablets.
-- A proximity event indicates that the stylus has moved in or out of
-- contact with the tablet, or perhaps that the user’s finger has moved
-- in or out of contact with a touch screen.
-- 
-- This event type will be used pretty rarely. It only is important for
-- XInput aware programs that are drawing their own cursor.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventProximity
    ( 

-- * Exported types
    EventProximity(..)                      ,
    newZeroEventProximity                   ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventProximityMethod             ,
#endif



 -- * Properties


-- ** device #attr:device#
-- | the master device that the event originated from. Use
-- 'GI.Gdk.Unions.Event.eventGetSourceDevice' to get the slave device.

    clearEventProximityDevice               ,
#if defined(ENABLE_OVERLOADING)
    eventProximity_device                   ,
#endif
    getEventProximityDevice                 ,
    setEventProximityDevice                 ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventProximity_sendEvent                ,
#endif
    getEventProximitySendEvent              ,
    setEventProximitySendEvent              ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventProximity_time                     ,
#endif
    getEventProximityTime                   ,
    setEventProximityTime                   ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeProximityIn' or 'GI.Gdk.Enums.EventTypeProximityOut').

#if defined(ENABLE_OVERLOADING)
    eventProximity_type                     ,
#endif
    getEventProximityType                   ,
    setEventProximityType                   ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventProximityWindow               ,
#if defined(ENABLE_OVERLOADING)
    eventProximity_window                   ,
#endif
    getEventProximityWindow                 ,
    setEventProximityWindow                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventProximity = EventProximity (SP.ManagedPtr EventProximity)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventProximity where
    toManagedPtr (EventProximity p) = p

instance BoxedPtr EventProximity where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 32 >=> B.ManagedPtr.wrapPtr EventProximity)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventProximity where
    boxedPtrCalloc = callocBytes 32


-- | Construct a `EventProximity` struct initialized to zero.
newZeroEventProximity :: MonadIO m => m EventProximity
newZeroEventProximity = liftIO $ boxedPtrCalloc >>= wrapPtr EventProximity

instance tag ~ 'AttrSet => Constructible EventProximity tag where
    new _ attrs = do
        o <- newZeroEventProximity
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProximity #type
-- @
getEventProximityType :: MonadIO m => EventProximity -> m Gdk.Enums.EventType
getEventProximityType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventProximity [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventProximityType :: MonadIO m => EventProximity -> Gdk.Enums.EventType -> m ()
setEventProximityType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventProximityTypeFieldInfo
instance AttrInfo EventProximityTypeFieldInfo where
    type AttrBaseTypeConstraint EventProximityTypeFieldInfo = (~) EventProximity
    type AttrAllowedOps EventProximityTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventProximityTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventProximityTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventProximityTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventProximityTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventProximityTypeFieldInfo = "type"
    type AttrOrigin EventProximityTypeFieldInfo = EventProximity
    attrGet = getEventProximityType
    attrSet = setEventProximityType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProximity.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventProximity.html#g:attr:type"
        })

eventProximity_type :: AttrLabelProxy "type"
eventProximity_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProximity #window
-- @
getEventProximityWindow :: MonadIO m => EventProximity -> m (Maybe Gdk.Window.Window)
getEventProximityWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventProximity [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventProximityWindow :: MonadIO m => EventProximity -> Ptr Gdk.Window.Window -> m ()
setEventProximityWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventProximityWindow :: MonadIO m => EventProximity -> m ()
clearEventProximityWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventProximityWindowFieldInfo
instance AttrInfo EventProximityWindowFieldInfo where
    type AttrBaseTypeConstraint EventProximityWindowFieldInfo = (~) EventProximity
    type AttrAllowedOps EventProximityWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventProximityWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventProximityWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventProximityWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventProximityWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventProximityWindowFieldInfo = "window"
    type AttrOrigin EventProximityWindowFieldInfo = EventProximity
    attrGet = getEventProximityWindow
    attrSet = setEventProximityWindow
    attrConstruct = undefined
    attrClear = clearEventProximityWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProximity.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventProximity.html#g:attr:window"
        })

eventProximity_window :: AttrLabelProxy "window"
eventProximity_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProximity #sendEvent
-- @
getEventProximitySendEvent :: MonadIO m => EventProximity -> m Int8
getEventProximitySendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventProximity [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventProximitySendEvent :: MonadIO m => EventProximity -> Int8 -> m ()
setEventProximitySendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventProximitySendEventFieldInfo
instance AttrInfo EventProximitySendEventFieldInfo where
    type AttrBaseTypeConstraint EventProximitySendEventFieldInfo = (~) EventProximity
    type AttrAllowedOps EventProximitySendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventProximitySendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventProximitySendEventFieldInfo = (~)Int8
    type AttrTransferType EventProximitySendEventFieldInfo = Int8
    type AttrGetType EventProximitySendEventFieldInfo = Int8
    type AttrLabel EventProximitySendEventFieldInfo = "send_event"
    type AttrOrigin EventProximitySendEventFieldInfo = EventProximity
    attrGet = getEventProximitySendEvent
    attrSet = setEventProximitySendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProximity.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventProximity.html#g:attr:sendEvent"
        })

eventProximity_sendEvent :: AttrLabelProxy "sendEvent"
eventProximity_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProximity #time
-- @
getEventProximityTime :: MonadIO m => EventProximity -> m Word32
getEventProximityTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventProximity [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventProximityTime :: MonadIO m => EventProximity -> Word32 -> m ()
setEventProximityTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventProximityTimeFieldInfo
instance AttrInfo EventProximityTimeFieldInfo where
    type AttrBaseTypeConstraint EventProximityTimeFieldInfo = (~) EventProximity
    type AttrAllowedOps EventProximityTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventProximityTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventProximityTimeFieldInfo = (~)Word32
    type AttrTransferType EventProximityTimeFieldInfo = Word32
    type AttrGetType EventProximityTimeFieldInfo = Word32
    type AttrLabel EventProximityTimeFieldInfo = "time"
    type AttrOrigin EventProximityTimeFieldInfo = EventProximity
    attrGet = getEventProximityTime
    attrSet = setEventProximityTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProximity.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventProximity.html#g:attr:time"
        })

eventProximity_time :: AttrLabelProxy "time"
eventProximity_time = AttrLabelProxy

#endif


-- | Get the value of the “@device@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventProximity #device
-- @
getEventProximityDevice :: MonadIO m => EventProximity -> m (Maybe Gdk.Device.Device)
getEventProximityDevice s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr Gdk.Device.Device)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Device.Device) val'
        return val''
    return result

-- | Set the value of the “@device@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventProximity [ #device 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventProximityDevice :: MonadIO m => EventProximity -> Ptr Gdk.Device.Device -> m ()
setEventProximityDevice s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr Gdk.Device.Device)

-- | Set the value of the “@device@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #device
-- @
clearEventProximityDevice :: MonadIO m => EventProximity -> m ()
clearEventProximityDevice s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr Gdk.Device.Device)

#if defined(ENABLE_OVERLOADING)
data EventProximityDeviceFieldInfo
instance AttrInfo EventProximityDeviceFieldInfo where
    type AttrBaseTypeConstraint EventProximityDeviceFieldInfo = (~) EventProximity
    type AttrAllowedOps EventProximityDeviceFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventProximityDeviceFieldInfo = (~) (Ptr Gdk.Device.Device)
    type AttrTransferTypeConstraint EventProximityDeviceFieldInfo = (~)(Ptr Gdk.Device.Device)
    type AttrTransferType EventProximityDeviceFieldInfo = (Ptr Gdk.Device.Device)
    type AttrGetType EventProximityDeviceFieldInfo = Maybe Gdk.Device.Device
    type AttrLabel EventProximityDeviceFieldInfo = "device"
    type AttrOrigin EventProximityDeviceFieldInfo = EventProximity
    attrGet = getEventProximityDevice
    attrSet = setEventProximityDevice
    attrConstruct = undefined
    attrClear = clearEventProximityDevice
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventProximity.device"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventProximity.html#g:attr:device"
        })

eventProximity_device :: AttrLabelProxy "device"
eventProximity_device = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventProximity
type instance O.AttributeList EventProximity = EventProximityAttributeList
type EventProximityAttributeList = ('[ '("type", EventProximityTypeFieldInfo), '("window", EventProximityWindowFieldInfo), '("sendEvent", EventProximitySendEventFieldInfo), '("time", EventProximityTimeFieldInfo), '("device", EventProximityDeviceFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventProximityMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventProximityMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventProximityMethod t EventProximity, O.OverloadedMethod info EventProximity p) => OL.IsLabel t (EventProximity -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventProximityMethod t EventProximity, O.OverloadedMethod info EventProximity p, R.HasField t EventProximity p) => R.HasField t EventProximity p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventProximityMethod t EventProximity, O.OverloadedMethodInfo info EventProximity) => OL.IsLabel t (O.MethodProxy info EventProximity) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


