{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated when the pointer moves.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventMotion
    ( 

-- * Exported types
    EventMotion(..)                         ,
    newZeroEventMotion                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventMotionMethod                ,
#endif



 -- * Properties


-- ** axes #attr:axes#
-- | /@x@/, /@y@/ translated to the axes of /@device@/, or 'P.Nothing' if /@device@/ is
--   the mouse.

#if defined(ENABLE_OVERLOADING)
    eventMotion_axes                        ,
#endif
    getEventMotionAxes                      ,
    setEventMotionAxes                      ,


-- ** device #attr:device#
-- | the master device that the event originated from. Use
-- 'GI.Gdk.Unions.Event.eventGetSourceDevice' to get the slave device.

    clearEventMotionDevice                  ,
#if defined(ENABLE_OVERLOADING)
    eventMotion_device                      ,
#endif
    getEventMotionDevice                    ,
    setEventMotionDevice                    ,


-- ** isHint #attr:isHint#
-- | set to 1 if this event is just a hint, see the
--   'GI.Gdk.Flags.EventMaskPointerMotionHintMask' value of t'GI.Gdk.Flags.EventMask'.

#if defined(ENABLE_OVERLOADING)
    eventMotion_isHint                      ,
#endif
    getEventMotionIsHint                    ,
    setEventMotionIsHint                    ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventMotion_sendEvent                   ,
#endif
    getEventMotionSendEvent                 ,
    setEventMotionSendEvent                 ,


-- ** state #attr:state#
-- | a bit-mask representing the state of
--   the modifier keys (e.g. Control, Shift and Alt) and the pointer
--   buttons. See t'GI.Gdk.Flags.ModifierType'.

#if defined(ENABLE_OVERLOADING)
    eventMotion_state                       ,
#endif
    getEventMotionState                     ,
    setEventMotionState                     ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventMotion_time                        ,
#endif
    getEventMotionTime                      ,
    setEventMotionTime                      ,


-- ** type #attr:type#
-- | the type of the event.

#if defined(ENABLE_OVERLOADING)
    eventMotion_type                        ,
#endif
    getEventMotionType                      ,
    setEventMotionType                      ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventMotionWindow                  ,
#if defined(ENABLE_OVERLOADING)
    eventMotion_window                      ,
#endif
    getEventMotionWindow                    ,
    setEventMotionWindow                    ,


-- ** x #attr:x#
-- | the x coordinate of the pointer relative to the window.

#if defined(ENABLE_OVERLOADING)
    eventMotion_x                           ,
#endif
    getEventMotionX                         ,
    setEventMotionX                         ,


-- ** xRoot #attr:xRoot#
-- | the x coordinate of the pointer relative to the root of the
--   screen.

#if defined(ENABLE_OVERLOADING)
    eventMotion_xRoot                       ,
#endif
    getEventMotionXRoot                     ,
    setEventMotionXRoot                     ,


-- ** y #attr:y#
-- | the y coordinate of the pointer relative to the window.

#if defined(ENABLE_OVERLOADING)
    eventMotion_y                           ,
#endif
    getEventMotionY                         ,
    setEventMotionY                         ,


-- ** yRoot #attr:yRoot#
-- | the y coordinate of the pointer relative to the root of the
--   screen.

#if defined(ENABLE_OVERLOADING)
    eventMotion_yRoot                       ,
#endif
    getEventMotionYRoot                     ,
    setEventMotionYRoot                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventMotion = EventMotion (SP.ManagedPtr EventMotion)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventMotion where
    toManagedPtr (EventMotion p) = p

instance BoxedPtr EventMotion where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 80 >=> B.ManagedPtr.wrapPtr EventMotion)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventMotion where
    boxedPtrCalloc = callocBytes 80


-- | Construct a `EventMotion` struct initialized to zero.
newZeroEventMotion :: MonadIO m => m EventMotion
newZeroEventMotion = liftIO $ boxedPtrCalloc >>= wrapPtr EventMotion

instance tag ~ 'AttrSet => Constructible EventMotion tag where
    new _ attrs = do
        o <- newZeroEventMotion
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #type
-- @
getEventMotionType :: MonadIO m => EventMotion -> m Gdk.Enums.EventType
getEventMotionType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionType :: MonadIO m => EventMotion -> Gdk.Enums.EventType -> m ()
setEventMotionType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventMotionTypeFieldInfo
instance AttrInfo EventMotionTypeFieldInfo where
    type AttrBaseTypeConstraint EventMotionTypeFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventMotionTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventMotionTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventMotionTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventMotionTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventMotionTypeFieldInfo = "type"
    type AttrOrigin EventMotionTypeFieldInfo = EventMotion
    attrGet = getEventMotionType
    attrSet = setEventMotionType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:type"
        })

eventMotion_type :: AttrLabelProxy "type"
eventMotion_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #window
-- @
getEventMotionWindow :: MonadIO m => EventMotion -> m (Maybe Gdk.Window.Window)
getEventMotionWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionWindow :: MonadIO m => EventMotion -> Ptr Gdk.Window.Window -> m ()
setEventMotionWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventMotionWindow :: MonadIO m => EventMotion -> m ()
clearEventMotionWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventMotionWindowFieldInfo
instance AttrInfo EventMotionWindowFieldInfo where
    type AttrBaseTypeConstraint EventMotionWindowFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventMotionWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventMotionWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventMotionWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventMotionWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventMotionWindowFieldInfo = "window"
    type AttrOrigin EventMotionWindowFieldInfo = EventMotion
    attrGet = getEventMotionWindow
    attrSet = setEventMotionWindow
    attrConstruct = undefined
    attrClear = clearEventMotionWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:window"
        })

eventMotion_window :: AttrLabelProxy "window"
eventMotion_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #sendEvent
-- @
getEventMotionSendEvent :: MonadIO m => EventMotion -> m Int8
getEventMotionSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionSendEvent :: MonadIO m => EventMotion -> Int8 -> m ()
setEventMotionSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventMotionSendEventFieldInfo
instance AttrInfo EventMotionSendEventFieldInfo where
    type AttrBaseTypeConstraint EventMotionSendEventFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventMotionSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventMotionSendEventFieldInfo = (~)Int8
    type AttrTransferType EventMotionSendEventFieldInfo = Int8
    type AttrGetType EventMotionSendEventFieldInfo = Int8
    type AttrLabel EventMotionSendEventFieldInfo = "send_event"
    type AttrOrigin EventMotionSendEventFieldInfo = EventMotion
    attrGet = getEventMotionSendEvent
    attrSet = setEventMotionSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:sendEvent"
        })

eventMotion_sendEvent :: AttrLabelProxy "sendEvent"
eventMotion_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #time
-- @
getEventMotionTime :: MonadIO m => EventMotion -> m Word32
getEventMotionTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionTime :: MonadIO m => EventMotion -> Word32 -> m ()
setEventMotionTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventMotionTimeFieldInfo
instance AttrInfo EventMotionTimeFieldInfo where
    type AttrBaseTypeConstraint EventMotionTimeFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventMotionTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventMotionTimeFieldInfo = (~)Word32
    type AttrTransferType EventMotionTimeFieldInfo = Word32
    type AttrGetType EventMotionTimeFieldInfo = Word32
    type AttrLabel EventMotionTimeFieldInfo = "time"
    type AttrOrigin EventMotionTimeFieldInfo = EventMotion
    attrGet = getEventMotionTime
    attrSet = setEventMotionTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:time"
        })

eventMotion_time :: AttrLabelProxy "time"
eventMotion_time = AttrLabelProxy

#endif


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #x
-- @
getEventMotionX :: MonadIO m => EventMotion -> m Double
getEventMotionX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionX :: MonadIO m => EventMotion -> Double -> m ()
setEventMotionX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 24) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventMotionXFieldInfo
instance AttrInfo EventMotionXFieldInfo where
    type AttrBaseTypeConstraint EventMotionXFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventMotionXFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventMotionXFieldInfo = (~)Double
    type AttrTransferType EventMotionXFieldInfo = Double
    type AttrGetType EventMotionXFieldInfo = Double
    type AttrLabel EventMotionXFieldInfo = "x"
    type AttrOrigin EventMotionXFieldInfo = EventMotion
    attrGet = getEventMotionX
    attrSet = setEventMotionX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:x"
        })

eventMotion_x :: AttrLabelProxy "x"
eventMotion_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #y
-- @
getEventMotionY :: MonadIO m => EventMotion -> m Double
getEventMotionY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionY :: MonadIO m => EventMotion -> Double -> m ()
setEventMotionY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 32) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventMotionYFieldInfo
instance AttrInfo EventMotionYFieldInfo where
    type AttrBaseTypeConstraint EventMotionYFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventMotionYFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventMotionYFieldInfo = (~)Double
    type AttrTransferType EventMotionYFieldInfo = Double
    type AttrGetType EventMotionYFieldInfo = Double
    type AttrLabel EventMotionYFieldInfo = "y"
    type AttrOrigin EventMotionYFieldInfo = EventMotion
    attrGet = getEventMotionY
    attrSet = setEventMotionY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:y"
        })

eventMotion_y :: AttrLabelProxy "y"
eventMotion_y = AttrLabelProxy

#endif


-- | Get the value of the “@axes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #axes
-- @
getEventMotionAxes :: MonadIO m => EventMotion -> m Double
getEventMotionAxes s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@axes@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #axes 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionAxes :: MonadIO m => EventMotion -> Double -> m ()
setEventMotionAxes s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 40) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventMotionAxesFieldInfo
instance AttrInfo EventMotionAxesFieldInfo where
    type AttrBaseTypeConstraint EventMotionAxesFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionAxesFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventMotionAxesFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventMotionAxesFieldInfo = (~)Double
    type AttrTransferType EventMotionAxesFieldInfo = Double
    type AttrGetType EventMotionAxesFieldInfo = Double
    type AttrLabel EventMotionAxesFieldInfo = "axes"
    type AttrOrigin EventMotionAxesFieldInfo = EventMotion
    attrGet = getEventMotionAxes
    attrSet = setEventMotionAxes
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.axes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:axes"
        })

eventMotion_axes :: AttrLabelProxy "axes"
eventMotion_axes = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #state
-- @
getEventMotionState :: MonadIO m => EventMotion -> m [Gdk.Flags.ModifierType]
getEventMotionState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionState :: MonadIO m => EventMotion -> [Gdk.Flags.ModifierType] -> m ()
setEventMotionState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 48) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventMotionStateFieldInfo
instance AttrInfo EventMotionStateFieldInfo where
    type AttrBaseTypeConstraint EventMotionStateFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventMotionStateFieldInfo = (~) [Gdk.Flags.ModifierType]
    type AttrTransferTypeConstraint EventMotionStateFieldInfo = (~)[Gdk.Flags.ModifierType]
    type AttrTransferType EventMotionStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrGetType EventMotionStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrLabel EventMotionStateFieldInfo = "state"
    type AttrOrigin EventMotionStateFieldInfo = EventMotion
    attrGet = getEventMotionState
    attrSet = setEventMotionState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:state"
        })

eventMotion_state :: AttrLabelProxy "state"
eventMotion_state = AttrLabelProxy

#endif


-- | Get the value of the “@is_hint@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #isHint
-- @
getEventMotionIsHint :: MonadIO m => EventMotion -> m Int16
getEventMotionIsHint s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 52) :: IO Int16
    return val

-- | Set the value of the “@is_hint@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #isHint 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionIsHint :: MonadIO m => EventMotion -> Int16 -> m ()
setEventMotionIsHint s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 52) (val :: Int16)

#if defined(ENABLE_OVERLOADING)
data EventMotionIsHintFieldInfo
instance AttrInfo EventMotionIsHintFieldInfo where
    type AttrBaseTypeConstraint EventMotionIsHintFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionIsHintFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventMotionIsHintFieldInfo = (~) Int16
    type AttrTransferTypeConstraint EventMotionIsHintFieldInfo = (~)Int16
    type AttrTransferType EventMotionIsHintFieldInfo = Int16
    type AttrGetType EventMotionIsHintFieldInfo = Int16
    type AttrLabel EventMotionIsHintFieldInfo = "is_hint"
    type AttrOrigin EventMotionIsHintFieldInfo = EventMotion
    attrGet = getEventMotionIsHint
    attrSet = setEventMotionIsHint
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.isHint"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:isHint"
        })

eventMotion_isHint :: AttrLabelProxy "isHint"
eventMotion_isHint = AttrLabelProxy

#endif


-- | Get the value of the “@device@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #device
-- @
getEventMotionDevice :: MonadIO m => EventMotion -> m (Maybe Gdk.Device.Device)
getEventMotionDevice s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO (Ptr Gdk.Device.Device)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Device.Device) val'
        return val''
    return result

-- | Set the value of the “@device@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #device 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionDevice :: MonadIO m => EventMotion -> Ptr Gdk.Device.Device -> m ()
setEventMotionDevice s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (val :: Ptr Gdk.Device.Device)

-- | Set the value of the “@device@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #device
-- @
clearEventMotionDevice :: MonadIO m => EventMotion -> m ()
clearEventMotionDevice s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 56) (FP.nullPtr :: Ptr Gdk.Device.Device)

#if defined(ENABLE_OVERLOADING)
data EventMotionDeviceFieldInfo
instance AttrInfo EventMotionDeviceFieldInfo where
    type AttrBaseTypeConstraint EventMotionDeviceFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionDeviceFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventMotionDeviceFieldInfo = (~) (Ptr Gdk.Device.Device)
    type AttrTransferTypeConstraint EventMotionDeviceFieldInfo = (~)(Ptr Gdk.Device.Device)
    type AttrTransferType EventMotionDeviceFieldInfo = (Ptr Gdk.Device.Device)
    type AttrGetType EventMotionDeviceFieldInfo = Maybe Gdk.Device.Device
    type AttrLabel EventMotionDeviceFieldInfo = "device"
    type AttrOrigin EventMotionDeviceFieldInfo = EventMotion
    attrGet = getEventMotionDevice
    attrSet = setEventMotionDevice
    attrConstruct = undefined
    attrClear = clearEventMotionDevice
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.device"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:device"
        })

eventMotion_device :: AttrLabelProxy "device"
eventMotion_device = AttrLabelProxy

#endif


-- | Get the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #xRoot
-- @
getEventMotionXRoot :: MonadIO m => EventMotion -> m Double
getEventMotionXRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #xRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionXRoot :: MonadIO m => EventMotion -> Double -> m ()
setEventMotionXRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 64) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventMotionXRootFieldInfo
instance AttrInfo EventMotionXRootFieldInfo where
    type AttrBaseTypeConstraint EventMotionXRootFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionXRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventMotionXRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventMotionXRootFieldInfo = (~)Double
    type AttrTransferType EventMotionXRootFieldInfo = Double
    type AttrGetType EventMotionXRootFieldInfo = Double
    type AttrLabel EventMotionXRootFieldInfo = "x_root"
    type AttrOrigin EventMotionXRootFieldInfo = EventMotion
    attrGet = getEventMotionXRoot
    attrSet = setEventMotionXRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.xRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:xRoot"
        })

eventMotion_xRoot :: AttrLabelProxy "xRoot"
eventMotion_xRoot = AttrLabelProxy

#endif


-- | Get the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventMotion #yRoot
-- @
getEventMotionYRoot :: MonadIO m => EventMotion -> m Double
getEventMotionYRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventMotion [ #yRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventMotionYRoot :: MonadIO m => EventMotion -> Double -> m ()
setEventMotionYRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 72) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventMotionYRootFieldInfo
instance AttrInfo EventMotionYRootFieldInfo where
    type AttrBaseTypeConstraint EventMotionYRootFieldInfo = (~) EventMotion
    type AttrAllowedOps EventMotionYRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventMotionYRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventMotionYRootFieldInfo = (~)Double
    type AttrTransferType EventMotionYRootFieldInfo = Double
    type AttrGetType EventMotionYRootFieldInfo = Double
    type AttrLabel EventMotionYRootFieldInfo = "y_root"
    type AttrOrigin EventMotionYRootFieldInfo = EventMotion
    attrGet = getEventMotionYRoot
    attrSet = setEventMotionYRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventMotion.yRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventMotion.html#g:attr:yRoot"
        })

eventMotion_yRoot :: AttrLabelProxy "yRoot"
eventMotion_yRoot = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventMotion
type instance O.AttributeList EventMotion = EventMotionAttributeList
type EventMotionAttributeList = ('[ '("type", EventMotionTypeFieldInfo), '("window", EventMotionWindowFieldInfo), '("sendEvent", EventMotionSendEventFieldInfo), '("time", EventMotionTimeFieldInfo), '("x", EventMotionXFieldInfo), '("y", EventMotionYFieldInfo), '("axes", EventMotionAxesFieldInfo), '("state", EventMotionStateFieldInfo), '("isHint", EventMotionIsHintFieldInfo), '("device", EventMotionDeviceFieldInfo), '("xRoot", EventMotionXRootFieldInfo), '("yRoot", EventMotionYRootFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventMotionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventMotionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventMotionMethod t EventMotion, O.OverloadedMethod info EventMotion p) => OL.IsLabel t (EventMotion -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventMotionMethod t EventMotion, O.OverloadedMethod info EventMotion p, R.HasField t EventMotion p) => R.HasField t EventMotion p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventMotionMethod t EventMotion, O.OverloadedMethodInfo info EventMotion) => OL.IsLabel t (O.MethodProxy info EventMotion) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


