{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated when a pointer or keyboard grab is broken. On X11, this happens
-- when the grab window becomes unviewable (i.e. it or one of its ancestors
-- is unmapped), or if the same application grabs the pointer or keyboard
-- again. Note that implicit grabs (which are initiated by button presses)
-- can also cause t'GI.Gdk.Structs.EventGrabBroken.EventGrabBroken' events.
-- 
-- /Since: 2.8/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventGrabBroken
    ( 

-- * Exported types
    EventGrabBroken(..)                     ,
    newZeroEventGrabBroken                  ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventGrabBrokenMethod            ,
#endif



 -- * Properties


-- ** grabWindow #attr:grabWindow#
-- | If this event is caused by another grab in the same
--   application, /@grabWindow@/ contains the new grab window. Otherwise
--   /@grabWindow@/ is 'P.Nothing'.

    clearEventGrabBrokenGrabWindow          ,
#if defined(ENABLE_OVERLOADING)
    eventGrabBroken_grabWindow              ,
#endif
    getEventGrabBrokenGrabWindow            ,
    setEventGrabBrokenGrabWindow            ,


-- ** implicit #attr:implicit#
-- | 'P.True' if the broken grab was implicit

#if defined(ENABLE_OVERLOADING)
    eventGrabBroken_implicit                ,
#endif
    getEventGrabBrokenImplicit              ,
    setEventGrabBrokenImplicit              ,


-- ** keyboard #attr:keyboard#
-- | 'P.True' if a keyboard grab was broken, 'P.False' if a pointer
--   grab was broken

#if defined(ENABLE_OVERLOADING)
    eventGrabBroken_keyboard                ,
#endif
    getEventGrabBrokenKeyboard              ,
    setEventGrabBrokenKeyboard              ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventGrabBroken_sendEvent               ,
#endif
    getEventGrabBrokenSendEvent             ,
    setEventGrabBrokenSendEvent             ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeGrabBroken')

#if defined(ENABLE_OVERLOADING)
    eventGrabBroken_type                    ,
#endif
    getEventGrabBrokenType                  ,
    setEventGrabBrokenType                  ,


-- ** window #attr:window#
-- | the window which received the event, i.e. the window
--   that previously owned the grab

    clearEventGrabBrokenWindow              ,
#if defined(ENABLE_OVERLOADING)
    eventGrabBroken_window                  ,
#endif
    getEventGrabBrokenWindow                ,
    setEventGrabBrokenWindow                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventGrabBroken = EventGrabBroken (SP.ManagedPtr EventGrabBroken)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventGrabBroken where
    toManagedPtr (EventGrabBroken p) = p

instance BoxedPtr EventGrabBroken where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 40 >=> B.ManagedPtr.wrapPtr EventGrabBroken)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventGrabBroken where
    boxedPtrCalloc = callocBytes 40


-- | Construct a `EventGrabBroken` struct initialized to zero.
newZeroEventGrabBroken :: MonadIO m => m EventGrabBroken
newZeroEventGrabBroken = liftIO $ boxedPtrCalloc >>= wrapPtr EventGrabBroken

instance tag ~ 'AttrSet => Constructible EventGrabBroken tag where
    new _ attrs = do
        o <- newZeroEventGrabBroken
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventGrabBroken #type
-- @
getEventGrabBrokenType :: MonadIO m => EventGrabBroken -> m Gdk.Enums.EventType
getEventGrabBrokenType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventGrabBroken [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventGrabBrokenType :: MonadIO m => EventGrabBroken -> Gdk.Enums.EventType -> m ()
setEventGrabBrokenType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventGrabBrokenTypeFieldInfo
instance AttrInfo EventGrabBrokenTypeFieldInfo where
    type AttrBaseTypeConstraint EventGrabBrokenTypeFieldInfo = (~) EventGrabBroken
    type AttrAllowedOps EventGrabBrokenTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventGrabBrokenTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventGrabBrokenTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventGrabBrokenTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventGrabBrokenTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventGrabBrokenTypeFieldInfo = "type"
    type AttrOrigin EventGrabBrokenTypeFieldInfo = EventGrabBroken
    attrGet = getEventGrabBrokenType
    attrSet = setEventGrabBrokenType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventGrabBroken.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventGrabBroken.html#g:attr:type"
        })

eventGrabBroken_type :: AttrLabelProxy "type"
eventGrabBroken_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventGrabBroken #window
-- @
getEventGrabBrokenWindow :: MonadIO m => EventGrabBroken -> m (Maybe Gdk.Window.Window)
getEventGrabBrokenWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventGrabBroken [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventGrabBrokenWindow :: MonadIO m => EventGrabBroken -> Ptr Gdk.Window.Window -> m ()
setEventGrabBrokenWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventGrabBrokenWindow :: MonadIO m => EventGrabBroken -> m ()
clearEventGrabBrokenWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventGrabBrokenWindowFieldInfo
instance AttrInfo EventGrabBrokenWindowFieldInfo where
    type AttrBaseTypeConstraint EventGrabBrokenWindowFieldInfo = (~) EventGrabBroken
    type AttrAllowedOps EventGrabBrokenWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventGrabBrokenWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventGrabBrokenWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventGrabBrokenWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventGrabBrokenWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventGrabBrokenWindowFieldInfo = "window"
    type AttrOrigin EventGrabBrokenWindowFieldInfo = EventGrabBroken
    attrGet = getEventGrabBrokenWindow
    attrSet = setEventGrabBrokenWindow
    attrConstruct = undefined
    attrClear = clearEventGrabBrokenWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventGrabBroken.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventGrabBroken.html#g:attr:window"
        })

eventGrabBroken_window :: AttrLabelProxy "window"
eventGrabBroken_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventGrabBroken #sendEvent
-- @
getEventGrabBrokenSendEvent :: MonadIO m => EventGrabBroken -> m Int8
getEventGrabBrokenSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventGrabBroken [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventGrabBrokenSendEvent :: MonadIO m => EventGrabBroken -> Int8 -> m ()
setEventGrabBrokenSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventGrabBrokenSendEventFieldInfo
instance AttrInfo EventGrabBrokenSendEventFieldInfo where
    type AttrBaseTypeConstraint EventGrabBrokenSendEventFieldInfo = (~) EventGrabBroken
    type AttrAllowedOps EventGrabBrokenSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventGrabBrokenSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventGrabBrokenSendEventFieldInfo = (~)Int8
    type AttrTransferType EventGrabBrokenSendEventFieldInfo = Int8
    type AttrGetType EventGrabBrokenSendEventFieldInfo = Int8
    type AttrLabel EventGrabBrokenSendEventFieldInfo = "send_event"
    type AttrOrigin EventGrabBrokenSendEventFieldInfo = EventGrabBroken
    attrGet = getEventGrabBrokenSendEvent
    attrSet = setEventGrabBrokenSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventGrabBroken.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventGrabBroken.html#g:attr:sendEvent"
        })

eventGrabBroken_sendEvent :: AttrLabelProxy "sendEvent"
eventGrabBroken_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@keyboard@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventGrabBroken #keyboard
-- @
getEventGrabBrokenKeyboard :: MonadIO m => EventGrabBroken -> m Bool
getEventGrabBrokenKeyboard s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@keyboard@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventGrabBroken [ #keyboard 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventGrabBrokenKeyboard :: MonadIO m => EventGrabBroken -> Bool -> m ()
setEventGrabBrokenKeyboard s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 20) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventGrabBrokenKeyboardFieldInfo
instance AttrInfo EventGrabBrokenKeyboardFieldInfo where
    type AttrBaseTypeConstraint EventGrabBrokenKeyboardFieldInfo = (~) EventGrabBroken
    type AttrAllowedOps EventGrabBrokenKeyboardFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventGrabBrokenKeyboardFieldInfo = (~) Bool
    type AttrTransferTypeConstraint EventGrabBrokenKeyboardFieldInfo = (~)Bool
    type AttrTransferType EventGrabBrokenKeyboardFieldInfo = Bool
    type AttrGetType EventGrabBrokenKeyboardFieldInfo = Bool
    type AttrLabel EventGrabBrokenKeyboardFieldInfo = "keyboard"
    type AttrOrigin EventGrabBrokenKeyboardFieldInfo = EventGrabBroken
    attrGet = getEventGrabBrokenKeyboard
    attrSet = setEventGrabBrokenKeyboard
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventGrabBroken.keyboard"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventGrabBroken.html#g:attr:keyboard"
        })

eventGrabBroken_keyboard :: AttrLabelProxy "keyboard"
eventGrabBroken_keyboard = AttrLabelProxy

#endif


-- | Get the value of the “@implicit@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventGrabBroken #implicit
-- @
getEventGrabBrokenImplicit :: MonadIO m => EventGrabBroken -> m Bool
getEventGrabBrokenImplicit s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@implicit@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventGrabBroken [ #implicit 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventGrabBrokenImplicit :: MonadIO m => EventGrabBroken -> Bool -> m ()
setEventGrabBrokenImplicit s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 24) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventGrabBrokenImplicitFieldInfo
instance AttrInfo EventGrabBrokenImplicitFieldInfo where
    type AttrBaseTypeConstraint EventGrabBrokenImplicitFieldInfo = (~) EventGrabBroken
    type AttrAllowedOps EventGrabBrokenImplicitFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventGrabBrokenImplicitFieldInfo = (~) Bool
    type AttrTransferTypeConstraint EventGrabBrokenImplicitFieldInfo = (~)Bool
    type AttrTransferType EventGrabBrokenImplicitFieldInfo = Bool
    type AttrGetType EventGrabBrokenImplicitFieldInfo = Bool
    type AttrLabel EventGrabBrokenImplicitFieldInfo = "implicit"
    type AttrOrigin EventGrabBrokenImplicitFieldInfo = EventGrabBroken
    attrGet = getEventGrabBrokenImplicit
    attrSet = setEventGrabBrokenImplicit
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventGrabBroken.implicit"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventGrabBroken.html#g:attr:implicit"
        })

eventGrabBroken_implicit :: AttrLabelProxy "implicit"
eventGrabBroken_implicit = AttrLabelProxy

#endif


-- | Get the value of the “@grab_window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventGrabBroken #grabWindow
-- @
getEventGrabBrokenGrabWindow :: MonadIO m => EventGrabBroken -> m (Maybe Gdk.Window.Window)
getEventGrabBrokenGrabWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@grab_window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventGrabBroken [ #grabWindow 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventGrabBrokenGrabWindow :: MonadIO m => EventGrabBroken -> Ptr Gdk.Window.Window -> m ()
setEventGrabBrokenGrabWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@grab_window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #grabWindow
-- @
clearEventGrabBrokenGrabWindow :: MonadIO m => EventGrabBroken -> m ()
clearEventGrabBrokenGrabWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventGrabBrokenGrabWindowFieldInfo
instance AttrInfo EventGrabBrokenGrabWindowFieldInfo where
    type AttrBaseTypeConstraint EventGrabBrokenGrabWindowFieldInfo = (~) EventGrabBroken
    type AttrAllowedOps EventGrabBrokenGrabWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventGrabBrokenGrabWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventGrabBrokenGrabWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventGrabBrokenGrabWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventGrabBrokenGrabWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventGrabBrokenGrabWindowFieldInfo = "grab_window"
    type AttrOrigin EventGrabBrokenGrabWindowFieldInfo = EventGrabBroken
    attrGet = getEventGrabBrokenGrabWindow
    attrSet = setEventGrabBrokenGrabWindow
    attrConstruct = undefined
    attrClear = clearEventGrabBrokenGrabWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventGrabBroken.grabWindow"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventGrabBroken.html#g:attr:grabWindow"
        })

eventGrabBroken_grabWindow :: AttrLabelProxy "grabWindow"
eventGrabBroken_grabWindow = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventGrabBroken
type instance O.AttributeList EventGrabBroken = EventGrabBrokenAttributeList
type EventGrabBrokenAttributeList = ('[ '("type", EventGrabBrokenTypeFieldInfo), '("window", EventGrabBrokenWindowFieldInfo), '("sendEvent", EventGrabBrokenSendEventFieldInfo), '("keyboard", EventGrabBrokenKeyboardFieldInfo), '("implicit", EventGrabBrokenImplicitFieldInfo), '("grabWindow", EventGrabBrokenGrabWindowFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventGrabBrokenMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventGrabBrokenMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventGrabBrokenMethod t EventGrabBroken, O.OverloadedMethod info EventGrabBroken p) => OL.IsLabel t (EventGrabBroken -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventGrabBrokenMethod t EventGrabBroken, O.OverloadedMethod info EventGrabBroken p, R.HasField t EventGrabBroken p) => R.HasField t EventGrabBroken p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventGrabBrokenMethod t EventGrabBroken, O.OverloadedMethodInfo info EventGrabBroken) => OL.IsLabel t (O.MethodProxy info EventGrabBroken) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


