{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Describes a change of keyboard focus.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventFocus
    ( 

-- * Exported types
    EventFocus(..)                          ,
    newZeroEventFocus                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventFocusMethod                 ,
#endif



 -- * Properties


-- ** in #attr:in#
-- | 'P.True' if the window has gained the keyboard focus, 'P.False' if
--   it has lost the focus.

#if defined(ENABLE_OVERLOADING)
    eventFocus_in                           ,
#endif
    getEventFocusIn                         ,
    setEventFocusIn                         ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventFocus_sendEvent                    ,
#endif
    getEventFocusSendEvent                  ,
    setEventFocusSendEvent                  ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeFocusChange').

#if defined(ENABLE_OVERLOADING)
    eventFocus_type                         ,
#endif
    getEventFocusType                       ,
    setEventFocusType                       ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventFocusWindow                   ,
#if defined(ENABLE_OVERLOADING)
    eventFocus_window                       ,
#endif
    getEventFocusWindow                     ,
    setEventFocusWindow                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventFocus = EventFocus (SP.ManagedPtr EventFocus)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventFocus where
    toManagedPtr (EventFocus p) = p

instance BoxedPtr EventFocus where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr EventFocus)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventFocus where
    boxedPtrCalloc = callocBytes 24


-- | Construct a `EventFocus` struct initialized to zero.
newZeroEventFocus :: MonadIO m => m EventFocus
newZeroEventFocus = liftIO $ boxedPtrCalloc >>= wrapPtr EventFocus

instance tag ~ 'AttrSet => Constructible EventFocus tag where
    new _ attrs = do
        o <- newZeroEventFocus
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventFocus #type
-- @
getEventFocusType :: MonadIO m => EventFocus -> m Gdk.Enums.EventType
getEventFocusType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventFocus [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventFocusType :: MonadIO m => EventFocus -> Gdk.Enums.EventType -> m ()
setEventFocusType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventFocusTypeFieldInfo
instance AttrInfo EventFocusTypeFieldInfo where
    type AttrBaseTypeConstraint EventFocusTypeFieldInfo = (~) EventFocus
    type AttrAllowedOps EventFocusTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventFocusTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventFocusTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventFocusTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventFocusTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventFocusTypeFieldInfo = "type"
    type AttrOrigin EventFocusTypeFieldInfo = EventFocus
    attrGet = getEventFocusType
    attrSet = setEventFocusType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventFocus.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventFocus.html#g:attr:type"
        })

eventFocus_type :: AttrLabelProxy "type"
eventFocus_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventFocus #window
-- @
getEventFocusWindow :: MonadIO m => EventFocus -> m (Maybe Gdk.Window.Window)
getEventFocusWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventFocus [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventFocusWindow :: MonadIO m => EventFocus -> Ptr Gdk.Window.Window -> m ()
setEventFocusWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventFocusWindow :: MonadIO m => EventFocus -> m ()
clearEventFocusWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventFocusWindowFieldInfo
instance AttrInfo EventFocusWindowFieldInfo where
    type AttrBaseTypeConstraint EventFocusWindowFieldInfo = (~) EventFocus
    type AttrAllowedOps EventFocusWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventFocusWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventFocusWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventFocusWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventFocusWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventFocusWindowFieldInfo = "window"
    type AttrOrigin EventFocusWindowFieldInfo = EventFocus
    attrGet = getEventFocusWindow
    attrSet = setEventFocusWindow
    attrConstruct = undefined
    attrClear = clearEventFocusWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventFocus.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventFocus.html#g:attr:window"
        })

eventFocus_window :: AttrLabelProxy "window"
eventFocus_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventFocus #sendEvent
-- @
getEventFocusSendEvent :: MonadIO m => EventFocus -> m Int8
getEventFocusSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventFocus [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventFocusSendEvent :: MonadIO m => EventFocus -> Int8 -> m ()
setEventFocusSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventFocusSendEventFieldInfo
instance AttrInfo EventFocusSendEventFieldInfo where
    type AttrBaseTypeConstraint EventFocusSendEventFieldInfo = (~) EventFocus
    type AttrAllowedOps EventFocusSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventFocusSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventFocusSendEventFieldInfo = (~)Int8
    type AttrTransferType EventFocusSendEventFieldInfo = Int8
    type AttrGetType EventFocusSendEventFieldInfo = Int8
    type AttrLabel EventFocusSendEventFieldInfo = "send_event"
    type AttrOrigin EventFocusSendEventFieldInfo = EventFocus
    attrGet = getEventFocusSendEvent
    attrSet = setEventFocusSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventFocus.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventFocus.html#g:attr:sendEvent"
        })

eventFocus_sendEvent :: AttrLabelProxy "sendEvent"
eventFocus_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@in@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventFocus #in
-- @
getEventFocusIn :: MonadIO m => EventFocus -> m Int16
getEventFocusIn s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 18) :: IO Int16
    return val

-- | Set the value of the “@in@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventFocus [ #in 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventFocusIn :: MonadIO m => EventFocus -> Int16 -> m ()
setEventFocusIn s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 18) (val :: Int16)

#if defined(ENABLE_OVERLOADING)
data EventFocusInFieldInfo
instance AttrInfo EventFocusInFieldInfo where
    type AttrBaseTypeConstraint EventFocusInFieldInfo = (~) EventFocus
    type AttrAllowedOps EventFocusInFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventFocusInFieldInfo = (~) Int16
    type AttrTransferTypeConstraint EventFocusInFieldInfo = (~)Int16
    type AttrTransferType EventFocusInFieldInfo = Int16
    type AttrGetType EventFocusInFieldInfo = Int16
    type AttrLabel EventFocusInFieldInfo = "in"
    type AttrOrigin EventFocusInFieldInfo = EventFocus
    attrGet = getEventFocusIn
    attrSet = setEventFocusIn
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventFocus.in"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventFocus.html#g:attr:in"
        })

eventFocus_in :: AttrLabelProxy "in"
eventFocus_in = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventFocus
type instance O.AttributeList EventFocus = EventFocusAttributeList
type EventFocusAttributeList = ('[ '("type", EventFocusTypeFieldInfo), '("window", EventFocusWindowFieldInfo), '("sendEvent", EventFocusSendEventFieldInfo), '("in", EventFocusInFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventFocusMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventFocusMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventFocusMethod t EventFocus, O.OverloadedMethod info EventFocus p) => OL.IsLabel t (EventFocus -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventFocusMethod t EventFocus, O.OverloadedMethod info EventFocus p, R.HasField t EventFocus p) => R.HasField t EventFocus p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventFocusMethod t EventFocus, O.OverloadedMethodInfo info EventFocus) => OL.IsLabel t (O.MethodProxy info EventFocus) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


