{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated when the pointer enters or leaves a window.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventCrossing
    ( 

-- * Exported types
    EventCrossing(..)                       ,
    newZeroEventCrossing                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventCrossingMethod              ,
#endif



 -- * Properties


-- ** detail #attr:detail#
-- | the kind of crossing that happened ('GI.Gdk.Enums.NotifyTypeInferior',
--  'GI.Gdk.Enums.NotifyTypeAncestor', 'GI.Gdk.Enums.NotifyTypeVirtual', 'GI.Gdk.Enums.NotifyTypeNonlinear' or
--  'GI.Gdk.Enums.NotifyTypeNonlinearVirtual').

#if defined(ENABLE_OVERLOADING)
    eventCrossing_detail                    ,
#endif
    getEventCrossingDetail                  ,
    setEventCrossingDetail                  ,


-- ** focus #attr:focus#
-- | 'P.True' if /@window@/ is the focus window or an inferior.

#if defined(ENABLE_OVERLOADING)
    eventCrossing_focus                     ,
#endif
    getEventCrossingFocus                   ,
    setEventCrossingFocus                   ,


-- ** mode #attr:mode#
-- | the crossing mode ('GI.Gdk.Enums.CrossingModeNormal', 'GI.Gdk.Enums.CrossingModeGrab',
--  'GI.Gdk.Enums.CrossingModeUngrab', 'GI.Gdk.Enums.CrossingModeGtkGrab', 'GI.Gdk.Enums.CrossingModeGtkUngrab' or
--  'GI.Gdk.Enums.CrossingModeStateChanged').  'GI.Gdk.Enums.CrossingModeGtkGrab', 'GI.Gdk.Enums.CrossingModeGtkUngrab',
--  and 'GI.Gdk.Enums.CrossingModeStateChanged' were added in 2.14 and are always synthesized,
--  never native.

#if defined(ENABLE_OVERLOADING)
    eventCrossing_mode                      ,
#endif
    getEventCrossingMode                    ,
    setEventCrossingMode                    ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventCrossing_sendEvent                 ,
#endif
    getEventCrossingSendEvent               ,
    setEventCrossingSendEvent               ,


-- ** state #attr:state#
-- | a bit-mask representing the state of
--   the modifier keys (e.g. Control, Shift and Alt) and the pointer
--   buttons. See t'GI.Gdk.Flags.ModifierType'.

#if defined(ENABLE_OVERLOADING)
    eventCrossing_state                     ,
#endif
    getEventCrossingState                   ,
    setEventCrossingState                   ,


-- ** subwindow #attr:subwindow#
-- | the window that was entered or left.

    clearEventCrossingSubwindow             ,
#if defined(ENABLE_OVERLOADING)
    eventCrossing_subwindow                 ,
#endif
    getEventCrossingSubwindow               ,
    setEventCrossingSubwindow               ,


-- ** time #attr:time#
-- | the time of the event in milliseconds.

#if defined(ENABLE_OVERLOADING)
    eventCrossing_time                      ,
#endif
    getEventCrossingTime                    ,
    setEventCrossingTime                    ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeEnterNotify' or 'GI.Gdk.Enums.EventTypeLeaveNotify').

#if defined(ENABLE_OVERLOADING)
    eventCrossing_type                      ,
#endif
    getEventCrossingType                    ,
    setEventCrossingType                    ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventCrossingWindow                ,
#if defined(ENABLE_OVERLOADING)
    eventCrossing_window                    ,
#endif
    getEventCrossingWindow                  ,
    setEventCrossingWindow                  ,


-- ** x #attr:x#
-- | the x coordinate of the pointer relative to the window.

#if defined(ENABLE_OVERLOADING)
    eventCrossing_x                         ,
#endif
    getEventCrossingX                       ,
    setEventCrossingX                       ,


-- ** xRoot #attr:xRoot#
-- | the x coordinate of the pointer relative to the root of the screen.

#if defined(ENABLE_OVERLOADING)
    eventCrossing_xRoot                     ,
#endif
    getEventCrossingXRoot                   ,
    setEventCrossingXRoot                   ,


-- ** y #attr:y#
-- | the y coordinate of the pointer relative to the window.

#if defined(ENABLE_OVERLOADING)
    eventCrossing_y                         ,
#endif
    getEventCrossingY                       ,
    setEventCrossingY                       ,


-- ** yRoot #attr:yRoot#
-- | the y coordinate of the pointer relative to the root of the screen.

#if defined(ENABLE_OVERLOADING)
    eventCrossing_yRoot                     ,
#endif
    getEventCrossingYRoot                   ,
    setEventCrossingYRoot                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventCrossing = EventCrossing (SP.ManagedPtr EventCrossing)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventCrossing where
    toManagedPtr (EventCrossing p) = p

instance BoxedPtr EventCrossing where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 88 >=> B.ManagedPtr.wrapPtr EventCrossing)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventCrossing where
    boxedPtrCalloc = callocBytes 88


-- | Construct a `EventCrossing` struct initialized to zero.
newZeroEventCrossing :: MonadIO m => m EventCrossing
newZeroEventCrossing = liftIO $ boxedPtrCalloc >>= wrapPtr EventCrossing

instance tag ~ 'AttrSet => Constructible EventCrossing tag where
    new _ attrs = do
        o <- newZeroEventCrossing
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #type
-- @
getEventCrossingType :: MonadIO m => EventCrossing -> m Gdk.Enums.EventType
getEventCrossingType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingType :: MonadIO m => EventCrossing -> Gdk.Enums.EventType -> m ()
setEventCrossingType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventCrossingTypeFieldInfo
instance AttrInfo EventCrossingTypeFieldInfo where
    type AttrBaseTypeConstraint EventCrossingTypeFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventCrossingTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventCrossingTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventCrossingTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventCrossingTypeFieldInfo = "type"
    type AttrOrigin EventCrossingTypeFieldInfo = EventCrossing
    attrGet = getEventCrossingType
    attrSet = setEventCrossingType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:type"
        })

eventCrossing_type :: AttrLabelProxy "type"
eventCrossing_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #window
-- @
getEventCrossingWindow :: MonadIO m => EventCrossing -> m (Maybe Gdk.Window.Window)
getEventCrossingWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingWindow :: MonadIO m => EventCrossing -> Ptr Gdk.Window.Window -> m ()
setEventCrossingWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventCrossingWindow :: MonadIO m => EventCrossing -> m ()
clearEventCrossingWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventCrossingWindowFieldInfo
instance AttrInfo EventCrossingWindowFieldInfo where
    type AttrBaseTypeConstraint EventCrossingWindowFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventCrossingWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventCrossingWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventCrossingWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventCrossingWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventCrossingWindowFieldInfo = "window"
    type AttrOrigin EventCrossingWindowFieldInfo = EventCrossing
    attrGet = getEventCrossingWindow
    attrSet = setEventCrossingWindow
    attrConstruct = undefined
    attrClear = clearEventCrossingWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:window"
        })

eventCrossing_window :: AttrLabelProxy "window"
eventCrossing_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #sendEvent
-- @
getEventCrossingSendEvent :: MonadIO m => EventCrossing -> m Int8
getEventCrossingSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingSendEvent :: MonadIO m => EventCrossing -> Int8 -> m ()
setEventCrossingSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventCrossingSendEventFieldInfo
instance AttrInfo EventCrossingSendEventFieldInfo where
    type AttrBaseTypeConstraint EventCrossingSendEventFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventCrossingSendEventFieldInfo = (~)Int8
    type AttrTransferType EventCrossingSendEventFieldInfo = Int8
    type AttrGetType EventCrossingSendEventFieldInfo = Int8
    type AttrLabel EventCrossingSendEventFieldInfo = "send_event"
    type AttrOrigin EventCrossingSendEventFieldInfo = EventCrossing
    attrGet = getEventCrossingSendEvent
    attrSet = setEventCrossingSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:sendEvent"
        })

eventCrossing_sendEvent :: AttrLabelProxy "sendEvent"
eventCrossing_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@subwindow@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #subwindow
-- @
getEventCrossingSubwindow :: MonadIO m => EventCrossing -> m (Maybe Gdk.Window.Window)
getEventCrossingSubwindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@subwindow@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #subwindow 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingSubwindow :: MonadIO m => EventCrossing -> Ptr Gdk.Window.Window -> m ()
setEventCrossingSubwindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@subwindow@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #subwindow
-- @
clearEventCrossingSubwindow :: MonadIO m => EventCrossing -> m ()
clearEventCrossingSubwindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventCrossingSubwindowFieldInfo
instance AttrInfo EventCrossingSubwindowFieldInfo where
    type AttrBaseTypeConstraint EventCrossingSubwindowFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingSubwindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventCrossingSubwindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventCrossingSubwindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventCrossingSubwindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventCrossingSubwindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventCrossingSubwindowFieldInfo = "subwindow"
    type AttrOrigin EventCrossingSubwindowFieldInfo = EventCrossing
    attrGet = getEventCrossingSubwindow
    attrSet = setEventCrossingSubwindow
    attrConstruct = undefined
    attrClear = clearEventCrossingSubwindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.subwindow"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:subwindow"
        })

eventCrossing_subwindow :: AttrLabelProxy "subwindow"
eventCrossing_subwindow = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #time
-- @
getEventCrossingTime :: MonadIO m => EventCrossing -> m Word32
getEventCrossingTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingTime :: MonadIO m => EventCrossing -> Word32 -> m ()
setEventCrossingTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventCrossingTimeFieldInfo
instance AttrInfo EventCrossingTimeFieldInfo where
    type AttrBaseTypeConstraint EventCrossingTimeFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventCrossingTimeFieldInfo = (~)Word32
    type AttrTransferType EventCrossingTimeFieldInfo = Word32
    type AttrGetType EventCrossingTimeFieldInfo = Word32
    type AttrLabel EventCrossingTimeFieldInfo = "time"
    type AttrOrigin EventCrossingTimeFieldInfo = EventCrossing
    attrGet = getEventCrossingTime
    attrSet = setEventCrossingTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:time"
        })

eventCrossing_time :: AttrLabelProxy "time"
eventCrossing_time = AttrLabelProxy

#endif


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #x
-- @
getEventCrossingX :: MonadIO m => EventCrossing -> m Double
getEventCrossingX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingX :: MonadIO m => EventCrossing -> Double -> m ()
setEventCrossingX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 40) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventCrossingXFieldInfo
instance AttrInfo EventCrossingXFieldInfo where
    type AttrBaseTypeConstraint EventCrossingXFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingXFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventCrossingXFieldInfo = (~)Double
    type AttrTransferType EventCrossingXFieldInfo = Double
    type AttrGetType EventCrossingXFieldInfo = Double
    type AttrLabel EventCrossingXFieldInfo = "x"
    type AttrOrigin EventCrossingXFieldInfo = EventCrossing
    attrGet = getEventCrossingX
    attrSet = setEventCrossingX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:x"
        })

eventCrossing_x :: AttrLabelProxy "x"
eventCrossing_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #y
-- @
getEventCrossingY :: MonadIO m => EventCrossing -> m Double
getEventCrossingY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingY :: MonadIO m => EventCrossing -> Double -> m ()
setEventCrossingY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 48) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventCrossingYFieldInfo
instance AttrInfo EventCrossingYFieldInfo where
    type AttrBaseTypeConstraint EventCrossingYFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingYFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventCrossingYFieldInfo = (~)Double
    type AttrTransferType EventCrossingYFieldInfo = Double
    type AttrGetType EventCrossingYFieldInfo = Double
    type AttrLabel EventCrossingYFieldInfo = "y"
    type AttrOrigin EventCrossingYFieldInfo = EventCrossing
    attrGet = getEventCrossingY
    attrSet = setEventCrossingY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:y"
        })

eventCrossing_y :: AttrLabelProxy "y"
eventCrossing_y = AttrLabelProxy

#endif


-- | Get the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #xRoot
-- @
getEventCrossingXRoot :: MonadIO m => EventCrossing -> m Double
getEventCrossingXRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #xRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingXRoot :: MonadIO m => EventCrossing -> Double -> m ()
setEventCrossingXRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 56) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventCrossingXRootFieldInfo
instance AttrInfo EventCrossingXRootFieldInfo where
    type AttrBaseTypeConstraint EventCrossingXRootFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingXRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingXRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventCrossingXRootFieldInfo = (~)Double
    type AttrTransferType EventCrossingXRootFieldInfo = Double
    type AttrGetType EventCrossingXRootFieldInfo = Double
    type AttrLabel EventCrossingXRootFieldInfo = "x_root"
    type AttrOrigin EventCrossingXRootFieldInfo = EventCrossing
    attrGet = getEventCrossingXRoot
    attrSet = setEventCrossingXRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.xRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:xRoot"
        })

eventCrossing_xRoot :: AttrLabelProxy "xRoot"
eventCrossing_xRoot = AttrLabelProxy

#endif


-- | Get the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #yRoot
-- @
getEventCrossingYRoot :: MonadIO m => EventCrossing -> m Double
getEventCrossingYRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #yRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingYRoot :: MonadIO m => EventCrossing -> Double -> m ()
setEventCrossingYRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 64) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventCrossingYRootFieldInfo
instance AttrInfo EventCrossingYRootFieldInfo where
    type AttrBaseTypeConstraint EventCrossingYRootFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingYRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingYRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventCrossingYRootFieldInfo = (~)Double
    type AttrTransferType EventCrossingYRootFieldInfo = Double
    type AttrGetType EventCrossingYRootFieldInfo = Double
    type AttrLabel EventCrossingYRootFieldInfo = "y_root"
    type AttrOrigin EventCrossingYRootFieldInfo = EventCrossing
    attrGet = getEventCrossingYRoot
    attrSet = setEventCrossingYRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.yRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:yRoot"
        })

eventCrossing_yRoot :: AttrLabelProxy "yRoot"
eventCrossing_yRoot = AttrLabelProxy

#endif


-- | Get the value of the “@mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #mode
-- @
getEventCrossingMode :: MonadIO m => EventCrossing -> m Gdk.Enums.CrossingMode
getEventCrossingMode s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #mode 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingMode :: MonadIO m => EventCrossing -> Gdk.Enums.CrossingMode -> m ()
setEventCrossingMode s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 72) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventCrossingModeFieldInfo
instance AttrInfo EventCrossingModeFieldInfo where
    type AttrBaseTypeConstraint EventCrossingModeFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingModeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingModeFieldInfo = (~) Gdk.Enums.CrossingMode
    type AttrTransferTypeConstraint EventCrossingModeFieldInfo = (~)Gdk.Enums.CrossingMode
    type AttrTransferType EventCrossingModeFieldInfo = Gdk.Enums.CrossingMode
    type AttrGetType EventCrossingModeFieldInfo = Gdk.Enums.CrossingMode
    type AttrLabel EventCrossingModeFieldInfo = "mode"
    type AttrOrigin EventCrossingModeFieldInfo = EventCrossing
    attrGet = getEventCrossingMode
    attrSet = setEventCrossingMode
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.mode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:mode"
        })

eventCrossing_mode :: AttrLabelProxy "mode"
eventCrossing_mode = AttrLabelProxy

#endif


-- | Get the value of the “@detail@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #detail
-- @
getEventCrossingDetail :: MonadIO m => EventCrossing -> m Gdk.Enums.NotifyType
getEventCrossingDetail s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 76) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@detail@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #detail 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingDetail :: MonadIO m => EventCrossing -> Gdk.Enums.NotifyType -> m ()
setEventCrossingDetail s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 76) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventCrossingDetailFieldInfo
instance AttrInfo EventCrossingDetailFieldInfo where
    type AttrBaseTypeConstraint EventCrossingDetailFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingDetailFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingDetailFieldInfo = (~) Gdk.Enums.NotifyType
    type AttrTransferTypeConstraint EventCrossingDetailFieldInfo = (~)Gdk.Enums.NotifyType
    type AttrTransferType EventCrossingDetailFieldInfo = Gdk.Enums.NotifyType
    type AttrGetType EventCrossingDetailFieldInfo = Gdk.Enums.NotifyType
    type AttrLabel EventCrossingDetailFieldInfo = "detail"
    type AttrOrigin EventCrossingDetailFieldInfo = EventCrossing
    attrGet = getEventCrossingDetail
    attrSet = setEventCrossingDetail
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.detail"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:detail"
        })

eventCrossing_detail :: AttrLabelProxy "detail"
eventCrossing_detail = AttrLabelProxy

#endif


-- | Get the value of the “@focus@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #focus
-- @
getEventCrossingFocus :: MonadIO m => EventCrossing -> m Bool
getEventCrossingFocus s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 80) :: IO CInt
    let val' = (/= 0) val
    return val'

-- | Set the value of the “@focus@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #focus 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingFocus :: MonadIO m => EventCrossing -> Bool -> m ()
setEventCrossingFocus s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (P.fromIntegral . P.fromEnum) val
    poke (ptr `plusPtr` 80) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventCrossingFocusFieldInfo
instance AttrInfo EventCrossingFocusFieldInfo where
    type AttrBaseTypeConstraint EventCrossingFocusFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingFocusFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingFocusFieldInfo = (~) Bool
    type AttrTransferTypeConstraint EventCrossingFocusFieldInfo = (~)Bool
    type AttrTransferType EventCrossingFocusFieldInfo = Bool
    type AttrGetType EventCrossingFocusFieldInfo = Bool
    type AttrLabel EventCrossingFocusFieldInfo = "focus"
    type AttrOrigin EventCrossingFocusFieldInfo = EventCrossing
    attrGet = getEventCrossingFocus
    attrSet = setEventCrossingFocus
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.focus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:focus"
        })

eventCrossing_focus :: AttrLabelProxy "focus"
eventCrossing_focus = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventCrossing #state
-- @
getEventCrossingState :: MonadIO m => EventCrossing -> m [Gdk.Flags.ModifierType]
getEventCrossingState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 84) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventCrossing [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventCrossingState :: MonadIO m => EventCrossing -> [Gdk.Flags.ModifierType] -> m ()
setEventCrossingState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 84) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventCrossingStateFieldInfo
instance AttrInfo EventCrossingStateFieldInfo where
    type AttrBaseTypeConstraint EventCrossingStateFieldInfo = (~) EventCrossing
    type AttrAllowedOps EventCrossingStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventCrossingStateFieldInfo = (~) [Gdk.Flags.ModifierType]
    type AttrTransferTypeConstraint EventCrossingStateFieldInfo = (~)[Gdk.Flags.ModifierType]
    type AttrTransferType EventCrossingStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrGetType EventCrossingStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrLabel EventCrossingStateFieldInfo = "state"
    type AttrOrigin EventCrossingStateFieldInfo = EventCrossing
    attrGet = getEventCrossingState
    attrSet = setEventCrossingState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventCrossing.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Structs-EventCrossing.html#g:attr:state"
        })

eventCrossing_state :: AttrLabelProxy "state"
eventCrossing_state = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventCrossing
type instance O.AttributeList EventCrossing = EventCrossingAttributeList
type EventCrossingAttributeList = ('[ '("type", EventCrossingTypeFieldInfo), '("window", EventCrossingWindowFieldInfo), '("sendEvent", EventCrossingSendEventFieldInfo), '("subwindow", EventCrossingSubwindowFieldInfo), '("time", EventCrossingTimeFieldInfo), '("x", EventCrossingXFieldInfo), '("y", EventCrossingYFieldInfo), '("xRoot", EventCrossingXRootFieldInfo), '("yRoot", EventCrossingYRootFieldInfo), '("mode", EventCrossingModeFieldInfo), '("detail", EventCrossingDetailFieldInfo), '("focus", EventCrossingFocusFieldInfo), '("state", EventCrossingStateFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventCrossingMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventCrossingMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventCrossingMethod t EventCrossing, O.OverloadedMethod info EventCrossing p) => OL.IsLabel t (EventCrossing -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventCrossingMethod t EventCrossing, O.OverloadedMethod info EventCrossing p, R.HasField t EventCrossing p) => R.HasField t EventCrossing p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventCrossingMethod t EventCrossing, O.OverloadedMethodInfo info EventCrossing) => OL.IsLabel t (O.MethodProxy info EventCrossing) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


