{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.DragContext
    ( 

-- * Exported types
    DragContext(..)                         ,
    IsDragContext                           ,
    toDragContext                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listTargets]("GI.Gdk.Objects.DragContext#g:method:listTargets"), [manageDnd]("GI.Gdk.Objects.DragContext#g:method:manageDnd"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActions]("GI.Gdk.Objects.DragContext#g:method:getActions"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDestWindow]("GI.Gdk.Objects.DragContext#g:method:getDestWindow"), [getDevice]("GI.Gdk.Objects.DragContext#g:method:getDevice"), [getDragWindow]("GI.Gdk.Objects.DragContext#g:method:getDragWindow"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getProtocol]("GI.Gdk.Objects.DragContext#g:method:getProtocol"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSelectedAction]("GI.Gdk.Objects.DragContext#g:method:getSelectedAction"), [getSourceWindow]("GI.Gdk.Objects.DragContext#g:method:getSourceWindow"), [getSuggestedAction]("GI.Gdk.Objects.DragContext#g:method:getSuggestedAction").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDevice]("GI.Gdk.Objects.DragContext#g:method:setDevice"), [setHotspot]("GI.Gdk.Objects.DragContext#g:method:setHotspot"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDragContextMethod                ,
#endif

-- ** getActions #method:getActions#

#if defined(ENABLE_OVERLOADING)
    DragContextGetActionsMethodInfo         ,
#endif
    dragContextGetActions                   ,


-- ** getDestWindow #method:getDestWindow#

#if defined(ENABLE_OVERLOADING)
    DragContextGetDestWindowMethodInfo      ,
#endif
    dragContextGetDestWindow                ,


-- ** getDevice #method:getDevice#

#if defined(ENABLE_OVERLOADING)
    DragContextGetDeviceMethodInfo          ,
#endif
    dragContextGetDevice                    ,


-- ** getDragWindow #method:getDragWindow#

#if defined(ENABLE_OVERLOADING)
    DragContextGetDragWindowMethodInfo      ,
#endif
    dragContextGetDragWindow                ,


-- ** getProtocol #method:getProtocol#

#if defined(ENABLE_OVERLOADING)
    DragContextGetProtocolMethodInfo        ,
#endif
    dragContextGetProtocol                  ,


-- ** getSelectedAction #method:getSelectedAction#

#if defined(ENABLE_OVERLOADING)
    DragContextGetSelectedActionMethodInfo  ,
#endif
    dragContextGetSelectedAction            ,


-- ** getSourceWindow #method:getSourceWindow#

#if defined(ENABLE_OVERLOADING)
    DragContextGetSourceWindowMethodInfo    ,
#endif
    dragContextGetSourceWindow              ,


-- ** getSuggestedAction #method:getSuggestedAction#

#if defined(ENABLE_OVERLOADING)
    DragContextGetSuggestedActionMethodInfo ,
#endif
    dragContextGetSuggestedAction           ,


-- ** listTargets #method:listTargets#

#if defined(ENABLE_OVERLOADING)
    DragContextListTargetsMethodInfo        ,
#endif
    dragContextListTargets                  ,


-- ** manageDnd #method:manageDnd#

#if defined(ENABLE_OVERLOADING)
    DragContextManageDndMethodInfo          ,
#endif
    dragContextManageDnd                    ,


-- ** setDevice #method:setDevice#

#if defined(ENABLE_OVERLOADING)
    DragContextSetDeviceMethodInfo          ,
#endif
    dragContextSetDevice                    ,


-- ** setHotspot #method:setHotspot#

#if defined(ENABLE_OVERLOADING)
    DragContextSetHotspotMethodInfo         ,
#endif
    dragContextSetHotspot                   ,




 -- * Signals


-- ** actionChanged #signal:actionChanged#

    DragContextActionChangedCallback        ,
#if defined(ENABLE_OVERLOADING)
    DragContextActionChangedSignalInfo      ,
#endif
    afterDragContextActionChanged           ,
    onDragContextActionChanged              ,


-- ** cancel #signal:cancel#

    DragContextCancelCallback               ,
#if defined(ENABLE_OVERLOADING)
    DragContextCancelSignalInfo             ,
#endif
    afterDragContextCancel                  ,
    onDragContextCancel                     ,


-- ** dndFinished #signal:dndFinished#

    DragContextDndFinishedCallback          ,
#if defined(ENABLE_OVERLOADING)
    DragContextDndFinishedSignalInfo        ,
#endif
    afterDragContextDndFinished             ,
    onDragContextDndFinished                ,


-- ** dropPerformed #signal:dropPerformed#

    DragContextDropPerformedCallback        ,
#if defined(ENABLE_OVERLOADING)
    DragContextDropPerformedSignalInfo      ,
#endif
    afterDragContextDropPerformed           ,
    onDragContextDropPerformed              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom

#endif

-- | Memory-managed wrapper type.
newtype DragContext = DragContext (SP.ManagedPtr DragContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype DragContext where
    toManagedPtr (DragContext p) = p

foreign import ccall "gdk_drag_context_get_type"
    c_gdk_drag_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject DragContext where
    glibType = c_gdk_drag_context_get_type

instance B.Types.GObject DragContext

-- | Type class for types which can be safely cast to `DragContext`, for instance with `toDragContext`.
class (SP.GObject o, O.IsDescendantOf DragContext o) => IsDragContext o
instance (SP.GObject o, O.IsDescendantOf DragContext o) => IsDragContext o

instance O.HasParentTypes DragContext
type instance O.ParentTypes DragContext = '[GObject.Object.Object]

-- | Cast to `DragContext`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toDragContext :: (MIO.MonadIO m, IsDragContext o) => o -> m DragContext
toDragContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo DragContext

-- | Convert 'DragContext' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DragContext) where
    gvalueGType_ = c_gdk_drag_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DragContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DragContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DragContext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDragContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDragContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDragContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDragContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDragContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDragContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDragContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDragContextMethod "listTargets" o = DragContextListTargetsMethodInfo
    ResolveDragContextMethod "manageDnd" o = DragContextManageDndMethodInfo
    ResolveDragContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDragContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDragContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDragContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDragContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDragContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDragContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDragContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDragContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDragContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDragContextMethod "getActions" o = DragContextGetActionsMethodInfo
    ResolveDragContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDragContextMethod "getDestWindow" o = DragContextGetDestWindowMethodInfo
    ResolveDragContextMethod "getDevice" o = DragContextGetDeviceMethodInfo
    ResolveDragContextMethod "getDragWindow" o = DragContextGetDragWindowMethodInfo
    ResolveDragContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDragContextMethod "getProtocol" o = DragContextGetProtocolMethodInfo
    ResolveDragContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDragContextMethod "getSelectedAction" o = DragContextGetSelectedActionMethodInfo
    ResolveDragContextMethod "getSourceWindow" o = DragContextGetSourceWindowMethodInfo
    ResolveDragContextMethod "getSuggestedAction" o = DragContextGetSuggestedActionMethodInfo
    ResolveDragContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDragContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDragContextMethod "setDevice" o = DragContextSetDeviceMethodInfo
    ResolveDragContextMethod "setHotspot" o = DragContextSetHotspotMethodInfo
    ResolveDragContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDragContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDragContextMethod t DragContext, O.OverloadedMethod info DragContext p) => OL.IsLabel t (DragContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDragContextMethod t DragContext, O.OverloadedMethod info DragContext p, R.HasField t DragContext p) => R.HasField t DragContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDragContextMethod t DragContext, O.OverloadedMethodInfo info DragContext) => OL.IsLabel t (O.MethodProxy info DragContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal DragContext::action-changed
-- | A new action is being chosen for the drag and drop operation.
-- 
-- This signal will only be emitted if the t'GI.Gdk.Objects.DragContext.DragContext' manages
-- the drag and drop operation. See 'GI.Gdk.Objects.DragContext.dragContextManageDnd'
-- for more information.
-- 
-- /Since: 3.20/
type DragContextActionChangedCallback =
    [Gdk.Flags.DragAction]
    -- ^ /@action@/: The action currently chosen
    -> IO ()

type C_DragContextActionChangedCallback =
    Ptr DragContext ->                      -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DragContextActionChangedCallback`.
foreign import ccall "wrapper"
    mk_DragContextActionChangedCallback :: C_DragContextActionChangedCallback -> IO (FunPtr C_DragContextActionChangedCallback)

wrap_DragContextActionChangedCallback :: 
    GObject a => (a -> DragContextActionChangedCallback) ->
    C_DragContextActionChangedCallback
wrap_DragContextActionChangedCallback gi'cb gi'selfPtr action _ = do
    let action' = wordToGFlags action
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  action'


-- | Connect a signal handler for the [actionChanged](#signal:actionChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dragContext #actionChanged callback
-- @
-- 
-- 
onDragContextActionChanged :: (IsDragContext a, MonadIO m) => a -> ((?self :: a) => DragContextActionChangedCallback) -> m SignalHandlerId
onDragContextActionChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragContextActionChangedCallback wrapped
    wrapped'' <- mk_DragContextActionChangedCallback wrapped'
    connectSignalFunPtr obj "action-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [actionChanged](#signal:actionChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dragContext #actionChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDragContextActionChanged :: (IsDragContext a, MonadIO m) => a -> ((?self :: a) => DragContextActionChangedCallback) -> m SignalHandlerId
afterDragContextActionChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragContextActionChangedCallback wrapped
    wrapped'' <- mk_DragContextActionChangedCallback wrapped'
    connectSignalFunPtr obj "action-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DragContextActionChangedSignalInfo
instance SignalInfo DragContextActionChangedSignalInfo where
    type HaskellCallbackType DragContextActionChangedSignalInfo = DragContextActionChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DragContextActionChangedCallback cb
        cb'' <- mk_DragContextActionChangedCallback cb'
        connectSignalFunPtr obj "action-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext::action-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#g:signal:actionChanged"})

#endif

-- signal DragContext::cancel
-- | The drag and drop operation was cancelled.
-- 
-- This signal will only be emitted if the t'GI.Gdk.Objects.DragContext.DragContext' manages
-- the drag and drop operation. See 'GI.Gdk.Objects.DragContext.dragContextManageDnd'
-- for more information.
-- 
-- /Since: 3.20/
type DragContextCancelCallback =
    Gdk.Enums.DragCancelReason
    -- ^ /@reason@/: The reason the context was cancelled
    -> IO ()

type C_DragContextCancelCallback =
    Ptr DragContext ->                      -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DragContextCancelCallback`.
foreign import ccall "wrapper"
    mk_DragContextCancelCallback :: C_DragContextCancelCallback -> IO (FunPtr C_DragContextCancelCallback)

wrap_DragContextCancelCallback :: 
    GObject a => (a -> DragContextCancelCallback) ->
    C_DragContextCancelCallback
wrap_DragContextCancelCallback gi'cb gi'selfPtr reason _ = do
    let reason' = (toEnum . fromIntegral) reason
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  reason'


-- | Connect a signal handler for the [cancel](#signal:cancel) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dragContext #cancel callback
-- @
-- 
-- 
onDragContextCancel :: (IsDragContext a, MonadIO m) => a -> ((?self :: a) => DragContextCancelCallback) -> m SignalHandlerId
onDragContextCancel obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragContextCancelCallback wrapped
    wrapped'' <- mk_DragContextCancelCallback wrapped'
    connectSignalFunPtr obj "cancel" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [cancel](#signal:cancel) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dragContext #cancel callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDragContextCancel :: (IsDragContext a, MonadIO m) => a -> ((?self :: a) => DragContextCancelCallback) -> m SignalHandlerId
afterDragContextCancel obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragContextCancelCallback wrapped
    wrapped'' <- mk_DragContextCancelCallback wrapped'
    connectSignalFunPtr obj "cancel" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DragContextCancelSignalInfo
instance SignalInfo DragContextCancelSignalInfo where
    type HaskellCallbackType DragContextCancelSignalInfo = DragContextCancelCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DragContextCancelCallback cb
        cb'' <- mk_DragContextCancelCallback cb'
        connectSignalFunPtr obj "cancel" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext::cancel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#g:signal:cancel"})

#endif

-- signal DragContext::dnd-finished
-- | The drag and drop operation was finished, the drag destination
-- finished reading all data. The drag source can now free all
-- miscellaneous data.
-- 
-- This signal will only be emitted if the t'GI.Gdk.Objects.DragContext.DragContext' manages
-- the drag and drop operation. See 'GI.Gdk.Objects.DragContext.dragContextManageDnd'
-- for more information.
-- 
-- /Since: 3.20/
type DragContextDndFinishedCallback =
    IO ()

type C_DragContextDndFinishedCallback =
    Ptr DragContext ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DragContextDndFinishedCallback`.
foreign import ccall "wrapper"
    mk_DragContextDndFinishedCallback :: C_DragContextDndFinishedCallback -> IO (FunPtr C_DragContextDndFinishedCallback)

wrap_DragContextDndFinishedCallback :: 
    GObject a => (a -> DragContextDndFinishedCallback) ->
    C_DragContextDndFinishedCallback
wrap_DragContextDndFinishedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [dndFinished](#signal:dndFinished) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dragContext #dndFinished callback
-- @
-- 
-- 
onDragContextDndFinished :: (IsDragContext a, MonadIO m) => a -> ((?self :: a) => DragContextDndFinishedCallback) -> m SignalHandlerId
onDragContextDndFinished obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragContextDndFinishedCallback wrapped
    wrapped'' <- mk_DragContextDndFinishedCallback wrapped'
    connectSignalFunPtr obj "dnd-finished" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [dndFinished](#signal:dndFinished) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dragContext #dndFinished callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDragContextDndFinished :: (IsDragContext a, MonadIO m) => a -> ((?self :: a) => DragContextDndFinishedCallback) -> m SignalHandlerId
afterDragContextDndFinished obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragContextDndFinishedCallback wrapped
    wrapped'' <- mk_DragContextDndFinishedCallback wrapped'
    connectSignalFunPtr obj "dnd-finished" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DragContextDndFinishedSignalInfo
instance SignalInfo DragContextDndFinishedSignalInfo where
    type HaskellCallbackType DragContextDndFinishedSignalInfo = DragContextDndFinishedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DragContextDndFinishedCallback cb
        cb'' <- mk_DragContextDndFinishedCallback cb'
        connectSignalFunPtr obj "dnd-finished" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext::dnd-finished"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#g:signal:dndFinished"})

#endif

-- signal DragContext::drop-performed
-- | The drag and drop operation was performed on an accepting client.
-- 
-- This signal will only be emitted if the t'GI.Gdk.Objects.DragContext.DragContext' manages
-- the drag and drop operation. See 'GI.Gdk.Objects.DragContext.dragContextManageDnd'
-- for more information.
-- 
-- /Since: 3.20/
type DragContextDropPerformedCallback =
    Int32
    -- ^ /@time@/: the time at which the drop happened.
    -> IO ()

type C_DragContextDropPerformedCallback =
    Ptr DragContext ->                      -- object
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DragContextDropPerformedCallback`.
foreign import ccall "wrapper"
    mk_DragContextDropPerformedCallback :: C_DragContextDropPerformedCallback -> IO (FunPtr C_DragContextDropPerformedCallback)

wrap_DragContextDropPerformedCallback :: 
    GObject a => (a -> DragContextDropPerformedCallback) ->
    C_DragContextDropPerformedCallback
wrap_DragContextDropPerformedCallback gi'cb gi'selfPtr time _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  time


-- | Connect a signal handler for the [dropPerformed](#signal:dropPerformed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dragContext #dropPerformed callback
-- @
-- 
-- 
onDragContextDropPerformed :: (IsDragContext a, MonadIO m) => a -> ((?self :: a) => DragContextDropPerformedCallback) -> m SignalHandlerId
onDragContextDropPerformed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragContextDropPerformedCallback wrapped
    wrapped'' <- mk_DragContextDropPerformedCallback wrapped'
    connectSignalFunPtr obj "drop-performed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [dropPerformed](#signal:dropPerformed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dragContext #dropPerformed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDragContextDropPerformed :: (IsDragContext a, MonadIO m) => a -> ((?self :: a) => DragContextDropPerformedCallback) -> m SignalHandlerId
afterDragContextDropPerformed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragContextDropPerformedCallback wrapped
    wrapped'' <- mk_DragContextDropPerformedCallback wrapped'
    connectSignalFunPtr obj "drop-performed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DragContextDropPerformedSignalInfo
instance SignalInfo DragContextDropPerformedSignalInfo where
    type HaskellCallbackType DragContextDropPerformedSignalInfo = DragContextDropPerformedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DragContextDropPerformedCallback cb
        cb'' <- mk_DragContextDropPerformedCallback cb'
        connectSignalFunPtr obj "drop-performed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext::drop-performed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#g:signal:dropPerformed"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DragContext
type instance O.AttributeList DragContext = DragContextAttributeList
type DragContextAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DragContext = DragContextSignalList
type DragContextSignalList = ('[ '("actionChanged", DragContextActionChangedSignalInfo), '("cancel", DragContextCancelSignalInfo), '("dndFinished", DragContextDndFinishedSignalInfo), '("dropPerformed", DragContextDropPerformedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DragContext::get_actions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DragAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_get_actions" gdk_drag_context_get_actions :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO CUInt

-- | Determines the bitmask of actions proposed by the source if
-- 'GI.Gdk.Objects.DragContext.dragContextGetSuggestedAction' returns 'GI.Gdk.Flags.DragActionAsk'.
-- 
-- /Since: 2.22/
dragContextGetActions ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> m [Gdk.Flags.DragAction]
    -- ^ __Returns:__ the t'GI.Gdk.Flags.DragAction' flags
dragContextGetActions context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_context_get_actions context'
    let result' = wordToGFlags result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DragContextGetActionsMethodInfo
instance (signature ~ (m [Gdk.Flags.DragAction]), MonadIO m, IsDragContext a) => O.OverloadedMethod DragContextGetActionsMethodInfo a signature where
    overloadedMethod = dragContextGetActions

instance O.OverloadedMethodInfo DragContextGetActionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextGetActions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextGetActions"
        })


#endif

-- method DragContext::get_dest_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_get_dest_window" gdk_drag_context_get_dest_window :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO (Ptr Gdk.Window.Window)

-- | Returns the destination window for the DND operation.
-- 
-- /Since: 3.0/
dragContextGetDestWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> m Gdk.Window.Window
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Window.Window'
dragContextGetDestWindow context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_context_get_dest_window context'
    checkUnexpectedReturnNULL "dragContextGetDestWindow" result
    result' <- (newObject Gdk.Window.Window) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DragContextGetDestWindowMethodInfo
instance (signature ~ (m Gdk.Window.Window), MonadIO m, IsDragContext a) => O.OverloadedMethod DragContextGetDestWindowMethodInfo a signature where
    overloadedMethod = dragContextGetDestWindow

instance O.OverloadedMethodInfo DragContextGetDestWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextGetDestWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextGetDestWindow"
        })


#endif

-- method DragContext::get_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Device" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_get_device" gdk_drag_context_get_device :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO (Ptr Gdk.Device.Device)

-- | Returns the t'GI.Gdk.Objects.Device.Device' associated to the drag context.
dragContextGetDevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> m Gdk.Device.Device
    -- ^ __Returns:__ The t'GI.Gdk.Objects.Device.Device' associated to /@context@/.
dragContextGetDevice context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_context_get_device context'
    checkUnexpectedReturnNULL "dragContextGetDevice" result
    result' <- (newObject Gdk.Device.Device) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DragContextGetDeviceMethodInfo
instance (signature ~ (m Gdk.Device.Device), MonadIO m, IsDragContext a) => O.OverloadedMethod DragContextGetDeviceMethodInfo a signature where
    overloadedMethod = dragContextGetDevice

instance O.OverloadedMethodInfo DragContextGetDeviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextGetDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextGetDevice"
        })


#endif

-- method DragContext::get_drag_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_get_drag_window" gdk_drag_context_get_drag_window :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO (Ptr Gdk.Window.Window)

-- | Returns the window on which the drag icon should be rendered
-- during the drag operation. Note that the window may not be
-- available until the drag operation has begun. GDK will move
-- the window in accordance with the ongoing drag operation.
-- The window is owned by /@context@/ and will be destroyed when
-- the drag operation is over.
-- 
-- /Since: 3.20/
dragContextGetDragWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> m (Maybe Gdk.Window.Window)
    -- ^ __Returns:__ the drag window, or 'P.Nothing'
dragContextGetDragWindow context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_context_get_drag_window context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Window.Window) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DragContextGetDragWindowMethodInfo
instance (signature ~ (m (Maybe Gdk.Window.Window)), MonadIO m, IsDragContext a) => O.OverloadedMethod DragContextGetDragWindowMethodInfo a signature where
    overloadedMethod = dragContextGetDragWindow

instance O.OverloadedMethodInfo DragContextGetDragWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextGetDragWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextGetDragWindow"
        })


#endif

-- method DragContext::get_protocol
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "DragProtocol" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_get_protocol" gdk_drag_context_get_protocol :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO CUInt

-- | Returns the drag protocol that is used by this context.
-- 
-- /Since: 3.0/
dragContextGetProtocol ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> m Gdk.Enums.DragProtocol
    -- ^ __Returns:__ the drag protocol
dragContextGetProtocol context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_context_get_protocol context'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DragContextGetProtocolMethodInfo
instance (signature ~ (m Gdk.Enums.DragProtocol), MonadIO m, IsDragContext a) => O.OverloadedMethod DragContextGetProtocolMethodInfo a signature where
    overloadedMethod = dragContextGetProtocol

instance O.OverloadedMethodInfo DragContextGetProtocolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextGetProtocol",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextGetProtocol"
        })


#endif

-- method DragContext::get_selected_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DragAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_get_selected_action" gdk_drag_context_get_selected_action :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO CUInt

-- | Determines the action chosen by the drag destination.
-- 
-- /Since: 2.22/
dragContextGetSelectedAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> m [Gdk.Flags.DragAction]
    -- ^ __Returns:__ a t'GI.Gdk.Flags.DragAction' value
dragContextGetSelectedAction context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_context_get_selected_action context'
    let result' = wordToGFlags result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DragContextGetSelectedActionMethodInfo
instance (signature ~ (m [Gdk.Flags.DragAction]), MonadIO m, IsDragContext a) => O.OverloadedMethod DragContextGetSelectedActionMethodInfo a signature where
    overloadedMethod = dragContextGetSelectedAction

instance O.OverloadedMethodInfo DragContextGetSelectedActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextGetSelectedAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextGetSelectedAction"
        })


#endif

-- method DragContext::get_source_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_get_source_window" gdk_drag_context_get_source_window :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO (Ptr Gdk.Window.Window)

-- | Returns the t'GI.Gdk.Objects.Window.Window' where the DND operation started.
-- 
-- /Since: 2.22/
dragContextGetSourceWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> m Gdk.Window.Window
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Window.Window'
dragContextGetSourceWindow context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_context_get_source_window context'
    checkUnexpectedReturnNULL "dragContextGetSourceWindow" result
    result' <- (newObject Gdk.Window.Window) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DragContextGetSourceWindowMethodInfo
instance (signature ~ (m Gdk.Window.Window), MonadIO m, IsDragContext a) => O.OverloadedMethod DragContextGetSourceWindowMethodInfo a signature where
    overloadedMethod = dragContextGetSourceWindow

instance O.OverloadedMethodInfo DragContextGetSourceWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextGetSourceWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextGetSourceWindow"
        })


#endif

-- method DragContext::get_suggested_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DragAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_get_suggested_action" gdk_drag_context_get_suggested_action :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO CUInt

-- | Determines the suggested drag action of the context.
-- 
-- /Since: 2.22/
dragContextGetSuggestedAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> m [Gdk.Flags.DragAction]
    -- ^ __Returns:__ a t'GI.Gdk.Flags.DragAction' value
dragContextGetSuggestedAction context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_context_get_suggested_action context'
    let result' = wordToGFlags result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DragContextGetSuggestedActionMethodInfo
instance (signature ~ (m [Gdk.Flags.DragAction]), MonadIO m, IsDragContext a) => O.OverloadedMethod DragContextGetSuggestedActionMethodInfo a signature where
    overloadedMethod = dragContextGetSuggestedAction

instance O.OverloadedMethodInfo DragContextGetSuggestedActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextGetSuggestedAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextGetSuggestedAction"
        })


#endif

-- method DragContext::list_targets
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Atom" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_list_targets" gdk_drag_context_list_targets :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    IO (Ptr (GList (Ptr Gdk.Atom.Atom)))

-- | Retrieves the list of targets of the context.
-- 
-- /Since: 2.22/
dragContextListTargets ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> m [Gdk.Atom.Atom]
    -- ^ __Returns:__ a t'GI.GLib.Structs.List.List' of targets
dragContextListTargets context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drag_context_list_targets context'
    result' <- unpackGList result
    result'' <- mapM (newPtr Gdk.Atom.Atom) result'
    touchManagedPtr context
    return result''

#if defined(ENABLE_OVERLOADING)
data DragContextListTargetsMethodInfo
instance (signature ~ (m [Gdk.Atom.Atom]), MonadIO m, IsDragContext a) => O.OverloadedMethod DragContextListTargetsMethodInfo a signature where
    overloadedMethod = dragContextListTargets

instance O.OverloadedMethodInfo DragContextListTargetsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextListTargets",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextListTargets"
        })


#endif

-- method DragContext::manage_dnd
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ipc_window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Window to use for IPC messaging/events"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "actions"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the actions supported by the drag source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_manage_dnd" gdk_drag_context_manage_dnd :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    Ptr Gdk.Window.Window ->                -- ipc_window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- actions : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    IO CInt

-- | Requests the drag and drop operation to be managed by /@context@/.
-- When a drag and drop operation becomes managed, the t'GI.Gdk.Objects.DragContext.DragContext'
-- will internally handle all input and source-side t'GI.Gdk.Structs.EventDND.EventDND' events
-- as required by the windowing system.
-- 
-- Once the drag and drop operation is managed, the drag context will
-- emit the following signals:
-- 
-- * The [DragContext::actionChanged]("GI.Gdk.Objects.DragContext#g:signal:actionChanged") signal whenever the final action
-- to be performed by the drag and drop operation changes.
-- * The [DragContext::dropPerformed]("GI.Gdk.Objects.DragContext#g:signal:dropPerformed") signal after the user performs
-- the drag and drop gesture (typically by releasing the mouse button).
-- * The [DragContext::dndFinished]("GI.Gdk.Objects.DragContext#g:signal:dndFinished") signal after the drag and drop
-- operation concludes (after all @/GdkSelection/@ transfers happen).
-- * The [DragContext::cancel]("GI.Gdk.Objects.DragContext#g:signal:cancel") signal if the drag and drop operation is
-- finished but doesn\'t happen over an accepting destination, or is
-- cancelled through other means.
-- 
-- 
-- /Since: 3.20/
dragContextManageDnd ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a, Gdk.Window.IsWindow b) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> b
    -- ^ /@ipcWindow@/: Window to use for IPC messaging\/events
    -> [Gdk.Flags.DragAction]
    -- ^ /@actions@/: the actions supported by the drag source
    -> m Bool
    -- ^ __Returns:__ @/TRUE/@ if the drag and drop operation is managed.
dragContextManageDnd context ipcWindow actions = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    ipcWindow' <- unsafeManagedPtrCastPtr ipcWindow
    let actions' = gflagsToWord actions
    result <- gdk_drag_context_manage_dnd context' ipcWindow' actions'
    let result' = (/= 0) result
    touchManagedPtr context
    touchManagedPtr ipcWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data DragContextManageDndMethodInfo
instance (signature ~ (b -> [Gdk.Flags.DragAction] -> m Bool), MonadIO m, IsDragContext a, Gdk.Window.IsWindow b) => O.OverloadedMethod DragContextManageDndMethodInfo a signature where
    overloadedMethod = dragContextManageDnd

instance O.OverloadedMethodInfo DragContextManageDndMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextManageDnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextManageDnd"
        })


#endif

-- method DragContext::set_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_set_device" gdk_drag_context_set_device :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO ()

-- | Associates a t'GI.Gdk.Objects.Device.Device' to /@context@/, so all Drag and Drop events
-- for /@context@/ are emitted as if they came from this device.
dragContextSetDevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> b
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m ()
dragContextSetDevice context device = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    device' <- unsafeManagedPtrCastPtr device
    gdk_drag_context_set_device context' device'
    touchManagedPtr context
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data DragContextSetDeviceMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsDragContext a, Gdk.Device.IsDevice b) => O.OverloadedMethod DragContextSetDeviceMethodInfo a signature where
    overloadedMethod = dragContextSetDevice

instance O.OverloadedMethodInfo DragContextSetDeviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextSetDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextSetDevice"
        })


#endif

-- method DragContext::set_hotspot
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDragContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hot_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "x coordinate of the drag window hotspot"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hot_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "y coordinate of the drag window hotspot"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_context_set_hotspot" gdk_drag_context_set_hotspot :: 
    Ptr DragContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DragContext"})
    Int32 ->                                -- hot_x : TBasicType TInt
    Int32 ->                                -- hot_y : TBasicType TInt
    IO ()

-- | Sets the position of the drag window that will be kept
-- under the cursor hotspot. Initially, the hotspot is at the
-- top left corner of the drag window.
-- 
-- /Since: 3.20/
dragContextSetHotspot ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DragContext.DragContext'
    -> Int32
    -- ^ /@hotX@/: x coordinate of the drag window hotspot
    -> Int32
    -- ^ /@hotY@/: y coordinate of the drag window hotspot
    -> m ()
dragContextSetHotspot context hotX hotY = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gdk_drag_context_set_hotspot context' hotX hotY
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data DragContextSetHotspotMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m, IsDragContext a) => O.OverloadedMethod DragContextSetHotspotMethodInfo a signature where
    overloadedMethod = dragContextSetHotspot

instance O.OverloadedMethodInfo DragContextSetHotspotMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DragContext.dragContextSetHotspot",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.26/docs/GI-Gdk-Objects-DragContext.html#v:dragContextSetHotspot"
        })


#endif


